package ONVIF::Analytics::Types::MetadataConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Analytics::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %PTZStatus_of :ATTR(:get<PTZStatus>);
my %Analytics_of :ATTR(:get<Analytics>);
my %Multicast_of :ATTR(:get<Multicast>);
my %SessionTimeout_of :ATTR(:get<SessionTimeout>);
my %AnalyticsEngineConfiguration_of :ATTR(:get<AnalyticsEngineConfiguration>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        PTZStatus
        Analytics
        Multicast
        SessionTimeout
        AnalyticsEngineConfiguration
        Extension

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'PTZStatus' => \%PTZStatus_of,
        'Analytics' => \%Analytics_of,
        'Multicast' => \%Multicast_of,
        'SessionTimeout' => \%SessionTimeout_of,
        'AnalyticsEngineConfiguration' => \%AnalyticsEngineConfiguration_of,
        'Extension' => \%Extension_of,
    },
    {
        'Name' => 'ONVIF::Analytics::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'PTZStatus' => 'ONVIF::Analytics::Types::PTZFilter',
        'Analytics' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Multicast' => 'ONVIF::Analytics::Types::MulticastConfiguration',
        'SessionTimeout' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
        'AnalyticsEngineConfiguration' => 'ONVIF::Analytics::Types::AnalyticsEngineConfiguration',
        'Extension' => 'ONVIF::Analytics::Types::MetadataConfigurationExtension',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'PTZStatus' => 'PTZStatus',
        'Analytics' => 'Analytics',
        'Multicast' => 'Multicast',
        'SessionTimeout' => 'SessionTimeout',
        'AnalyticsEngineConfiguration' => 'AnalyticsEngineConfiguration',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::MetadataConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MetadataConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PTZStatus


=item * Analytics


=item * Multicast


=item * SessionTimeout


=item * AnalyticsEngineConfiguration


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::MetadataConfiguration
   PTZStatus =>  { # ONVIF::Analytics::Types::PTZFilter
     Status =>  $some_value, # boolean
     Position =>  $some_value, # boolean
   },
   Analytics =>  $some_value, # boolean
   Multicast =>  { # ONVIF::Analytics::Types::MulticastConfiguration
     Address =>  { # ONVIF::Analytics::Types::IPAddress
       Type => $some_value, # IPType
       IPv4Address => $some_value, # IPv4Address
       IPv6Address => $some_value, # IPv6Address
     },
     Port =>  $some_value, # int
     TTL =>  $some_value, # int
     AutoStart =>  $some_value, # boolean
   },
   SessionTimeout =>  $some_value, # duration
   AnalyticsEngineConfiguration =>  { # ONVIF::Analytics::Types::AnalyticsEngineConfiguration
     AnalyticsModule =>  { # ONVIF::Analytics::Types::Config
       Parameters =>  { # ONVIF::Analytics::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::Analytics::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::Analytics::Types::AnalyticsEngineConfigurationExtension
     },
   },
   Extension =>  { # ONVIF::Analytics::Types::MetadataConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

