
# Cisco UCS Manager SNMP

## Overview

For Zabbix version: 5.0 and higher  
Cisco UCS® Manager provides unified, embedded management of all software and hardware
 components of the Cisco Unified Computing System™ (Cisco UCS) across multiple chassis
 and rack servers. It enables server, fabric, and storage provisioning as well as,
 device discovery, inventory, configuration, diagnostics, monitoring, fault detection,
 auditing, and statistics collection.  
This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.  
You can download UCS MIB files there ftp://ftp.cisco.com/pub/mibs/ucs-mibs/.


## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/5.0/manual/config/templates_out_of_the_box/network_devices) for basic instructions.

1\. Create a host for Cisco USC Manager IP as SNMPv2 interface.

2\. Link the template to the host.

3\. Customize macro values if needed.



## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$DISK.ARRAY.CACHE.BATTERY.STATUS.CRIT} |<p>The cache battery critical state for trigger expression.</p> |`2` |
|{$DISK.ARRAY.CACHE.BATTERY.STATUS.OK} |<p>The cache battery normal state for trigger expression.</p> |`1` |
|{$DISK.ARRAY.STATUS.CRIT:"inoperable"} |<p>The array controller critical state for trigger expression.</p> |`2` |
|{$DISK.ARRAY.STATUS.OK:"operable"} |<p>The array controller normal state for trigger expression.</p> |`1` |
|{$DISK.ARRAY.STATUS.WARN:"degraded"} |<p>The array controller warning state for trigger expression.</p> |`3` |
|{$DISK.STATUS.CRIT:"bad"} |<p>The disk critical state for trigger expression.</p> |`16` |
|{$DISK.STATUS.CRIT:"predictiveFailure"} |<p>The disk critical state for trigger expression.</p> |`11` |
|{$DISK.STATUS.FAIL:"failed"} |<p>The disk fail state for trigger expression.</p> |`9` |
|{$FAN.STATUS.CRIT:"inoperable"} |<p>The critical value of the FAN sensor for trigger expression.</p> |`2` |
|{$FAN.STATUS.WARN:"degraded"} |<p>The warning value of the FAN sensor for trigger expression.</p> |`3` |
|{$HEALTH.STATUS.CRIT:"computeFailed"} |<p>The unit health critical state for trigger expression.</p> |`30` |
|{$HEALTH.STATUS.CRIT:"configFailure"} |<p>The unit health critical state for trigger expression.</p> |`33` |
|{$HEALTH.STATUS.CRIT:"inoperable"} |<p>The unit health critical state for trigger expression.</p> |`60` |
|{$HEALTH.STATUS.CRIT:"unconfigFailure"} |<p>The unit health critical state for trigger expression.</p> |`34` |
|{$HEALTH.STATUS.WARN:"diagnosticsFailed"} |<p>The unit health warning state for trigger expression.</p> |`204` |
|{$HEALTH.STATUS.WARN:"powerProblem"} |<p>The unit health warning state for trigger expression.</p> |`62` |
|{$HEALTH.STATUS.WARN:"testFailed"} |<p>The unit health warning state for trigger expression.</p> |`35` |
|{$HEALTH.STATUS.WARN:"thermalProblem"} |<p>The unit health warning state for trigger expression.</p> |`60` |
|{$HEALTH.STATUS.WARN:"voltageProblem"} |<p>The unit health warning state for trigger expression.</p> |`62` |
|{$IF.ERRORS.WARN} |<p>-</p> |`2` |
|{$IFCONTROL} |<p>-</p> |`1` |
|{$NET.IFADMINSTATUS.MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level. Ignore notPresent(6) by default.</p> |`^.*` |
|{$NET.IFADMINSTATUS.NOT_MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level. Ignore down(2) administrative status by default.</p> |`^2$` |
|{$NET.IFALIAS.MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`.*` |
|{$NET.IFALIAS.NOT_MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`CHANGE_IF_NEEDED` |
|{$NET.IFDESCR.MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`.*` |
|{$NET.IFDESCR.NOT_MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`CHANGE_IF_NEEDED` |
|{$NET.IFNAME.MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`^.*$` |
|{$NET.IFNAME.NOT_MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level. Filter out loopbacks, sup-fc0, nulls, docker veth links and docker0 bridge by default.</p> |`(^Software Loopback Interface|^NULL[0-9.]*$|^[Ll]o[0-9.]*$|^[Ss]ystem$|^Nu[0-9.]*$|^veth[0-9a-z]+$|docker[0-9]+|br-[a-z0-9]{12}|sup-fc0)` |
|{$NET.IFOPERSTATUS.MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`^.*$` |
|{$NET.IFOPERSTATUS.NOT_MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level. Ignore notPresent(6) by default.</p> |`^6$` |
|{$NET.IFTYPE.MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`.*` |
|{$NET.IFTYPE.NOT_MATCHES} |<p>This macro is used in network interface discovery. Can be overridden on the host level.</p> |`CHANGE_IF_NEEDED` |
|{$PSU.STATUS.CRIT:"inoperable"} |<p>The critical value of the PSU sensor for trigger expression.</p> |`2` |
|{$PSU.STATUS.WARN:"degraded"} |<p>The warning value of the PSU sensor for trigger expression.</p> |`3` |
|{$SNMP.TIMEOUT} |<p>The time interval for SNMP agent availability trigger expression.</p> |`5m` |
|{$TEMP.MAX.CRIT:"Ambient"} |<p>The temperature maximum critical value for trigger expression.</p> |`35` |
|{$TEMP.MAX.WARN:"Ambient"} |<p>The temperature maximum warning value for trigger expression.</p> |`30` |
|{$VDISK.STATUS.OK:"equipped"} |<p>The vdisk normal state for trigger expression.</p> |`10` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Temperature discovery |<p>-</p> |SNMP |cisco.ucs.temp.discovery |
|Temperature CPU discovery |<p>-</p> |SNMP |cisco.ucs.temp.cpu.discovery |
|Network interface discovery |<p>Discovering interfaces from IF-MIB.</p> |SNMP |cisco.ucs.net.if.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>**Filter**:</p>AND <p>- A: {#IFADMINSTATUS} MATCHES_REGEX `{$NET.IFADMINSTATUS.MATCHES}`</p><p>- B: {#IFADMINSTATUS} NOT_MATCHES_REGEX `{$NET.IFADMINSTATUS.NOT_MATCHES}`</p><p>- C: {#IFOPERSTATUS} MATCHES_REGEX `{$NET.IFOPERSTATUS.MATCHES}`</p><p>- D: {#IFOPERSTATUS} NOT_MATCHES_REGEX `{$NET.IFOPERSTATUS.NOT_MATCHES}`</p><p>- E: {#IFNAME} MATCHES_REGEX `{$NET.IFNAME.MATCHES}`</p><p>- F: {#IFNAME} NOT_MATCHES_REGEX `{$NET.IFNAME.NOT_MATCHES}`</p><p>- G: {#IFDESCR} MATCHES_REGEX `{$NET.IFDESCR.MATCHES}`</p><p>- H: {#IFDESCR} NOT_MATCHES_REGEX `{$NET.IFDESCR.NOT_MATCHES}`</p><p>- I: {#IFALIAS} MATCHES_REGEX `{$NET.IFALIAS.MATCHES}`</p><p>- J: {#IFALIAS} NOT_MATCHES_REGEX `{$NET.IFALIAS.NOT_MATCHES}`</p><p>- K: {#IFTYPE} MATCHES_REGEX `{$NET.IFTYPE.MATCHES}`</p><p>- L: {#IFTYPE} NOT_MATCHES_REGEX `{$NET.IFTYPE.NOT_MATCHES}`</p> |
|PSU discovery |<p>-</p> |SNMP |cisco.ucs.psu.discovery |
|Unit discovery |<p>-</p> |SNMP |cisco.ucs.unit.discovery |
|FAN discovery |<p>-</p> |SNMP |cisco.ucs.fan.discovery |
|Physical disk discovery |<p>Scanning table of physical drive entries CISCO-UNIFIED-COMPUTING-STORAGE-MIB::cucsStorageLocalDiskTable.</p> |SNMP |cisco.ucs.physicalDisk.discovery |
|Virtual disk discovery |<p>CISCO-UNIFIED-COMPUTING-STORAGE-MIB::cucsStorageLocalLunTable</p> |SNMP |cisco.ucs.virtualDisk.discovery |
|Array controller discovery |<p>Scanning table of Array controllers: CISCO-UNIFIED-COMPUTING-STORAGE-MIB::cucsStorageControllerTable.</p> |SNMP |cisco.ucs.array.discovery |
|Array controller cache discovery |<p>Scanning table of Array controllers: CISCO-UNIFIED-COMPUTING-STORAGE-MIB::cucsStorageControllerTable.</p> |SNMP |cisco.ucs.array.cache.discovery |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Disk_arrays |{#DISKARRAY_LOCATION}: Disk array controller status |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:RaidBattery:operability managed object property.</p> |SNMP |cisco.ucs.hw.diskarray.status[cucsStorageControllerOperState.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Disk_arrays |{#DISKARRAY_LOCATION}: Disk array controller model |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p> |SNMP |cisco.ucs.hw.diskarray.model[cucsStorageControllerModel.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Disk_arrays |{#DISKARRAY_CACHE_LOCATION}: Disk array cache controller battery status |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p> |SNMP |cisco.ucs.hw.diskarray.cache.battery.status[cucsStorageRaidBatteryOperability.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Fans |{#FAN_LOCATION}: Fan status |<p>MIB: CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB</p><p>Cisco UCS equipment:Fan:operState managed object property</p> |SNMP |cisco.ucs.sensor.fan.status[cucsEquipmentFanOperState.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |SNMP traps (fallback) |<p>Item is used to collect all SNMP traps unmatched by other snmptrap items</p> |SNMP_TRAP |snmptrap.fallback |
|General |System location |<p>MIB: SNMPv2-MIB</p><p>The physical location of this node (e.g., `telephone closet,</p><p>3rd floor').  If the location is unknown, the value is the zero-length string.</p> |SNMP |cisco.ucs.location[sysLocation.0]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|General |System contact details |<p>MIB: SNMPv2-MIB</p><p>The textual identification of the contact person for this managed</p><p>node, together with information on how to contact this person.  If no contact</p><p>information is known, the value is the zero-length string.</p> |SNMP |cisco.ucs.contact[sysContact.0]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|General |System object ID |<p>MIB: SNMPv2-MIB</p><p>The vendor's authoritative identification of the network management</p><p>subsystem contained in the entity.  This value is allocated within the SMI enterprises</p><p>subtree (1.3.6.1.4.1) and provides an easy and unambiguous means for determining 'what</p><p>kind of box' is being managed. For example, if vendor 'Flintstones, Inc.' was</p><p>assigned the subtree1.3.6.1.4.1.4242, it could assign the identifier 1.3.6.1.4.1.4242.1.1</p><p>to its 'Fred Router'.</p> |SNMP |cisco.ucs.objectid[sysObjectID.0]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|General |System name |<p>MIB: SNMPv2-MIB</p><p>An administratively-assigned name for this managed node.By</p><p>convention, this is the node's fully-qualified domain name.  If the name is unknown,</p><p>the value is the zero-length string.</p> |SNMP |cisco.ucs.name[sysName.0]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|General |System description |<p>MIB: SNMPv2-MIB</p><p>A textual description of the entity. This value should</p><p>include the full name and version identification of the system's hardware type, software operating-system, and</p><p>networking software.</p> |SNMP |cisco.ucs.descr[sysDescr.0]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Inventory |{#UNIT_LOCATION}: Hardware model name |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Cisco UCS compute:RackUnit:model managed object property</p> |SNMP |cisco.ucs.hw.model[cucsComputeRackUnitModel.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Inventory |{#UNIT_LOCATION}: Hardware serial number |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Cisco UCS compute:RackUnit:serial managed object property</p> |SNMP |cisco.ucs.hw.serialnumber[cucsComputeRackUnitSerial.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Operational status |<p>MIB: IF-MIB</p><p>The current operational state of the interface.</p><p>- The testing(3) state indicates that no operational packet scan be passed</p><p>- If ifAdminStatus is down(2) then ifOperStatus should be down(2)</p><p>- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic</p><p>- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)</p><p>- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state</p><p>- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.</p> |SNMP |cisco.ucs.if.status[ifOperStatus.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Bits received |<p>MIB: IF-MIB</p><p>The total number of octets received on the interface, including framing characters. This object is a 64-bit version of ifInOctets. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.in[ifHCInOctets.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- MULTIPLIER: `8`</p> |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Bits sent |<p>MIB: IF-MIB</p><p>The total number of octets transmitted out of the interface, including framing characters. This object is a 64-bit version of ifOutOctets.Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.out[ifHCOutOctets.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- MULTIPLIER: `8`</p> |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Inbound packets with errors |<p>MIB: IF-MIB</p><p>For packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.in.errors[ifInErrors.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Outbound packets with errors |<p>MIB: IF-MIB</p><p>For packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.out.errors[ifOutErrors.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Outbound packets discarded |<p>MIB: IF-MIB</p><p>The number of outbound packets which were chosen to be discarded</p><p>even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.</p><p>One possible reason for discarding such a packet could be to free up buffer space.</p><p>Discontinuities in the value of this counter can occur at re-initialization of the management system,</p><p>and at other times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.out.discards[ifOutDiscards.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Inbound packets discarded |<p>MIB: IF-MIB</p><p>The number of inbound packets which were chosen to be discarded</p><p>even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.</p><p>One possible reason for discarding such a packet could be to free up buffer space.</p><p>Discontinuities in the value of this counter can occur at re-initialization of the management system,</p><p>and at other times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.in.discards[ifInDiscards.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Multicast packets received |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were addressed to a multicast</p><p>address at this sub-layer.  For a MAC layer protocol, this</p><p>includes both Group and Functional addresses.  This object</p><p>is a 64-bit version of ifInMulticastPkts.</p><p>Discontinuities in the value of this counter can occur at</p><p>re-initialization of the management system, and at other</p><p>times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.in.multicast[ifHCInMulticastPkts.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Multicast packets sent |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were addressed to a</p><p>multicast address at this sub-layer, including those that</p><p>were discarded or not sent.  For a MAC layer protocol, this</p><p>includes both Group and Functional addresses.  This object</p><p>is a 64-bit version of ifOutMulticastPkts.</p><p>Discontinuities in the value of this counter can occur at</p><p>re-initialization of the management system, and at other</p><p>times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.out.multicast[ifHCOutMulticastPkts.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Broadcast packets received |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were addressed to a broadcast</p><p>address at this sub-layer.  This object is a 64-bit version</p><p>of ifInBroadcastPkts.</p><p>Discontinuities in the value of this counter can occur at</p><p>re-initialization of the management system, and at other</p><p>times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.in.broadcast[ifHCInBroadcastPkts.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Broadcast packets sent |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were addressed to a</p><p>broadcast address at this sub-layer, including those that</p><p>were discarded or not sent.  This object is a 64-bit version</p><p>of ifOutBroadcastPkts.</p><p>Discontinuities in the value of this counter can occur at</p><p>re-initialization of the management system, and at other</p><p>times as indicated by the value of ifCounterDiscontinuityTime.</p> |SNMP |cisco.ucs.if.out.broadcast[ifHCOutBroadcastPkts.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Interface type |<p>MIB: IF-MIB</p><p>The type of interface.</p><p>Additional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),</p><p>through updating the syntax of the IANAifType textual convention.</p> |SNMP |cisco.ucs.if.type[ifType.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Interface description |<p>MIB: IF-MIB</p><p>A textual string containing information about the</p><p>interface.  This string should include the name of the</p><p>manufacturer, the product name and the version of the</p><p>interface hardware/software.</p> |SNMP |cisco.ucs.if.descr[ifDescr.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Network_interfaces |Interface {#IFNAME}({#IFALIAS}): Speed |<p>MIB: IF-MIB</p><p>An estimate of the interface's current bandwidth in units of 1,000,000 bits per second. If this object reports a value of `n' then the speed of the interface is somewhere in the range of `n-500,000' to`n+499,999'.  For interfaces which do not vary in bandwidth or for those where no accurate estimation can be made, this object should contain the nominal bandwidth. For a sub-layer which has no concept of bandwidth, this object should be zero.</p> |SNMP |cisco.ucs.if.speed[ifHighSpeed.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `1000000`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Physical_disks |{#DISK_LOCATION}: Physical disk status |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalDisk:diskState managed object property.</p> |SNMP |cisco.ucs.hw.physicaldisk.status[cucsStorageLocalDiskDiskState.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Physical_disks |{#DISK_LOCATION}: Physical disk model name |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalDisk:model managed object property.</p> |SNMP |cisco.ucs.hw.physicaldisk.model[cucsStorageLocalDiskModel.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Physical_disks |{#DISK_LOCATION}: Physical disk serial number |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalDisk:serial managed object property. Actually returns part number code.</p> |SNMP |cisco.ucs.hw.physicaldisk.serialnumber[cucsStorageLocalDiskSerial.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Physical_disks |{#DISK_LOCATION}: Physical disk media type |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalDisk:deviceType managed object property. Actually returns 'HDD' or 'SSD'.</p> |SNMP |cisco.ucs.hw.physicaldisk.media_type[cucsStorageLocalDiskDeviceType.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Physical_disks |{#DISK_LOCATION}: Disk size |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalDisk:size managed object property. In MB.</p> |SNMP |cisco.ucs.hw.physicaldisk.size[cucsStorageLocalDiskSize.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `1048576`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Power_supply |{#PSU_LOCATION}: Power supply status |<p>MIB: CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB</p><p>Cisco UCS equipment:Psu:operState managed object property</p> |SNMP |cisco.ucs.sensor.psu.status[cucsEquipmentPsuOperState.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Status |Uptime |<p>MIB: SNMPv2-MIB</p><p>The time in seconds since the network management</p><p>portion of the system was last re-initialized.</p> |SNMP |cisco.ucs.uptime[sysUpTime.0]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.01`</p> |
|Status |SNMP agent availability |<p>Availability of SNMP checks on the host. The value of this item corresponds to availability icons in the host list.</p><p>Possible value:</p><p>0 - not available</p><p>1 - available</p><p>2 - unknown</p> |INTERNAL |zabbix[host,snmp,available]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Status |{#UNIT_LOCATION}: Overall system health status |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Cisco UCS compute:RackUnit:operState managed object property</p> |SNMP |cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Temperature |{#SENSOR_LOCATION}.Ambient: Temperature |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Temperature readings of testpoint: {#SENSOR_LOCATION}.Ambient</p> |SNMP |cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsAmbientTemp.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Temperature |{#SENSOR_LOCATION}.Front: Temperature |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Cisco UCS compute:RackUnitMbTempStats:frontTemp managed object property</p> |SNMP |cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsFrontTemp.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Temperature |{#SENSOR_LOCATION}.Rear: Temperature |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Cisco UCS compute:RackUnitMbTempStats:rearTemp managed object property</p> |SNMP |cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsRearTemp.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Temperature |{#SENSOR_LOCATION}.IOH: Temperature |<p>MIB: CISCO-UNIFIED-COMPUTING-COMPUTE-MIB</p><p>Cisco UCS compute:RackUnitMbTempStats:ioh1Temp managed object property</p> |SNMP |cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempSltatsIoh1Temp.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Temperature |{#SENSOR_LOCATION}: Temperature |<p>MIB: CISCO-UNIFIED-COMPUTING-PROCESSOR-MIB</p><p>Cisco UCS processor:EnvStats:temperature managed object property</p> |SNMP |cisco.ucs.sensor.temp.value[cucsProcessorEnvStatsTemperature.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Virtual_disks |{#VDISK_LOCATION}: Status |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalLun:presence managed object property</p> |SNMP |cisco.ucs.hw.virtualdisk.status[cucsStorageLocalLunPresence.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Virtual_disks |{#VDISK_LOCATION}: Layout type  |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalLun:type managed object property</p> |SNMP |cisco.ucs.hw.virtualdisk.layout[cucsStorageLocalLunType.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Virtual_disks |{#VDISK_LOCATION}: Disk size |<p>MIB: CISCO-UNIFIED-COMPUTING-STORAGE-MIB</p><p>Cisco UCS storage:LocalLun:size managed object property in MB.</p> |SNMP |cisco.ucs.hw.virtualdisk.size[cucsStorageLocalLunSize.{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `1048576`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|{#DISKARRAY_LOCATION}: Disk array controller is in critical state |<p>Please check the device for faults</p> |`{TEMPLATE_NAME:cisco.ucs.hw.diskarray.status[cucsStorageControllerOperState.{#SNMPINDEX}].last()}={$DISK.ARRAY.STATUS.CRIT:"inoperable"}` |HIGH | |
|{#DISKARRAY_LOCATION}: Disk array controller is in warning state |<p>Please check the device for faults</p> |`{TEMPLATE_NAME:cisco.ucs.hw.diskarray.status[cucsStorageControllerOperState.{#SNMPINDEX}].last()}={$DISK.ARRAY.STATUS.WARN:"degraded"}` |AVERAGE |<p>**Depends on**:</p><p>- {#DISKARRAY_LOCATION}: Disk array controller is in critical state</p> |
|{#DISKARRAY_LOCATION}: Disk array controller is not in optimal state |<p>Please check the device for faults</p> |`{TEMPLATE_NAME:cisco.ucs.hw.diskarray.status[cucsStorageControllerOperState.{#SNMPINDEX}].last()}>{$DISK.ARRAY.STATUS.OK:"operable"}` |WARNING |<p>**Depends on**:</p><p>- {#DISKARRAY_LOCATION}: Disk array controller is in critical state</p><p>- {#DISKARRAY_LOCATION}: Disk array controller is in warning state</p> |
|{#DISKARRAY_CACHE_LOCATION}: Disk array cache controller battery is in critical state! |<p>Please check the device for faults</p> |`{TEMPLATE_NAME:cisco.ucs.hw.diskarray.cache.battery.status[cucsStorageRaidBatteryOperability.{#SNMPINDEX}].last()}={$DISK.ARRAY.CACHE.BATTERY.STATUS.CRIT}` |AVERAGE | |
|{#DISKARRAY_CACHE_LOCATION}: Disk array cache controller battery is not in optimal state |<p>Please check the device for faults</p> |`{TEMPLATE_NAME:cisco.ucs.hw.diskarray.cache.battery.status[cucsStorageRaidBatteryOperability.{#SNMPINDEX}].last()}<>{$DISK.ARRAY.CACHE.BATTERY.STATUS.OK}` |WARNING |<p>**Depends on**:</p><p>- {#DISKARRAY_CACHE_LOCATION}: Disk array cache controller battery is in critical state!</p> |
|{#FAN_LOCATION}: Fan is in critical state |<p>Please check the fan unit</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.fan.status[cucsEquipmentFanOperState.{#SNMPINDEX}].last()}={$FAN.STATUS.CRIT:"inoperable"}` |AVERAGE | |
|{#FAN_LOCATION}: Fan is in warning state |<p>Please check the fan unit</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.fan.status[cucsEquipmentFanOperState.{#SNMPINDEX}].last()}={$FAN.STATUS.WARN:"degraded"}` |WARNING |<p>**Depends on**:</p><p>- {#FAN_LOCATION}: Fan is in critical state</p> |
|System name has changed (new name: {ITEM.VALUE}) |<p>System name has changed. Ack to close.</p> |`{TEMPLATE_NAME:cisco.ucs.name[sysName.0].diff()}=1 and {TEMPLATE_NAME:cisco.ucs.name[sysName.0].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|{#UNIT_LOCATION}: Device has been replaced (new serial number received) |<p>Device serial number has changed. Ack to close</p> |`{TEMPLATE_NAME:cisco.ucs.hw.serialnumber[cucsComputeRackUnitSerial.{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:cisco.ucs.hw.serialnumber[cucsComputeRackUnitSerial.{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|Interface {#IFNAME}({#IFALIAS}): Link down |<p>This trigger expression works as follows:</p><p>1. Can be triggered if operations status is down.</p><p>2. {$IFCONTROL:"{#IFNAME}"}=1 - user can redefine Context macro to value - 0. That marks this interface as not important. No new trigger will be fired if this interface is down.</p><p>3. {TEMPLATE_NAME:METRIC.diff()}=1) - trigger fires only if operational status was up(1) sometime before. (So, do not fire 'ethernal off' interfaces.)</p><p>WARNING: if closed manually - won't fire again on next poll, because of .diff.</p> |`{$IFCONTROL:"{#IFNAME}"}=1 and ({TEMPLATE_NAME:cisco.ucs.if.status[ifOperStatus.{#SNMPINDEX}].last()}=2 and {TEMPLATE_NAME:cisco.ucs.if.status[ifOperStatus.{#SNMPINDEX}].diff()}=1)`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.if.status[ifOperStatus.{#SNMPINDEX}].last()}<>2 or {$IFCONTROL:"{#IFNAME}"}=0` |AVERAGE |<p>Manual close: YES</p> |
|Interface {#IFNAME}({#IFALIAS}): High error rate on {#IFNAME} ( > {$IF.ERRORS.WARN:"{#IFNAME}"} for 5m) |<p>Recovers when value below {$IF.ERRORS.WARN:"{#IFNAME}"} threshold.</p> |`{TEMPLATE_NAME:cisco.ucs.if.in.errors[ifInErrors.{#SNMPINDEX}].min(5m)}>{$IF.ERRORS.WARN:"{#IFNAME}"} or {Cisco UCS Manager SNMP:cisco.ucs.if.out.errors[ifOutErrors.{#SNMPINDEX}].min(5m)}>{$IF.ERRORS.WARN:"{#IFNAME}"}` |WARNING |<p>Manual close: YES</p><p>**Depends on**:</p><p>- Interface {#IFNAME}({#IFALIAS}): Link down</p> |
|{#DISK_LOCATION}: Physical disk failed |<p>Please check physical disk for warnings or errors</p> |`{TEMPLATE_NAME:cisco.ucs.hw.physicaldisk.status[cucsStorageLocalDiskDiskState.{#SNMPINDEX}].last()}={$DISK.STATUS.FAIL:"failed"}` |HIGH | |
|{#DISK_LOCATION}: Physical disk error |<p>Please check physical disk for warnings or errors</p> |`{TEMPLATE_NAME:cisco.ucs.hw.physicaldisk.status[cucsStorageLocalDiskDiskState.{#SNMPINDEX}].last()}={$DISK.STATUS.CRIT:"bad"} or {TEMPLATE_NAME:cisco.ucs.hw.physicaldisk.status[cucsStorageLocalDiskDiskState.{#SNMPINDEX}].last()}={$DISK.STATUS.CRIT:"predictiveFailure"}` |AVERAGE |<p>**Depends on**:</p><p>- {#DISK_LOCATION}: Physical disk failed</p> |
|{#DISK_LOCATION}: Disk has been replaced (new serial number received) |<p>Disk serial number has changed. Ack to close</p> |`{TEMPLATE_NAME:cisco.ucs.hw.physicaldisk.serialnumber[cucsStorageLocalDiskSerial.{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:cisco.ucs.hw.physicaldisk.serialnumber[cucsStorageLocalDiskSerial.{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|{#PSU_LOCATION}: Power supply is in critical state |<p>Please check the power supply unit for errors</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.psu.status[cucsEquipmentPsuOperState.{#SNMPINDEX}].last()}={$PSU.STATUS.CRIT:"inoperable"}` |AVERAGE | |
|{#PSU_LOCATION}: Power supply is in warning state |<p>Please check the power supply unit for errors</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.psu.status[cucsEquipmentPsuOperState.{#SNMPINDEX}].last()}={$PSU.STATUS.WARN:"degraded"}` |WARNING |<p>**Depends on**:</p><p>- {#PSU_LOCATION}: Power supply is in critical state</p> |
|{HOST.NAME} has been restarted (uptime < 10m) |<p>Uptime is less than 10 minutes</p> |`{TEMPLATE_NAME:cisco.ucs.uptime[sysUpTime.0].last()}<10m` |WARNING |<p>Manual close: YES</p><p>**Depends on**:</p><p>- No SNMP data collection</p> |
|No SNMP data collection |<p>SNMP is not available for polling. Please check device connectivity and SNMP settings.</p> |`{TEMPLATE_NAME:zabbix[host,snmp,available].max({$SNMP.TIMEOUT})}=0` |WARNING | |
|{#UNIT_LOCATION}: System status is in critical state |<p>Please check the device for errors</p> |`{TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.CRIT:"computeFailed"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.CRIT:"configFailure"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.CRIT:"unconfigFailure"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.CRIT:"inoperable"}` |HIGH | |
|{#UNIT_LOCATION}: System status is in warning state |<p>Please check the device for warnings</p> |`{TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.WARN:"testFailed"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.WARN:"thermalProblem"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.WARN:"powerProblem"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.WARN:"voltageProblem"} or {TEMPLATE_NAME:cisco.ucs.status[cucsComputeRackUnitOperState.{#SNMPINDEX}].last()}={$HEALTH.STATUS.WARN:"diagnosticsFailed"}` |WARNING |<p>**Depends on**:</p><p>- {#UNIT_LOCATION}: System status is in critical state</p> |
|{#SENSOR_LOCATION}.Ambient: Temperature is above warning threshold: >{$TEMP.MAX.WARN:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsAmbientTemp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.WARN:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsAmbientTemp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.WARN:"Ambient"}-3` |WARNING |<p>**Depends on**:</p><p>- {#SENSOR_LOCATION}.Ambient: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Front: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.IOH: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Rear: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p> |
|{#SENSOR_LOCATION}.Ambient: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsAmbientTemp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.CRIT:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsAmbientTemp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.CRIT:"Ambient"}-3` |HIGH | |
|{#SENSOR_LOCATION}.Front: Temperature is above warning threshold: >{$TEMP.MAX.WARN:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsFrontTemp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.WARN:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsFrontTemp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.WARN:"Ambient"}-3` |WARNING |<p>**Depends on**:</p><p>- {#SENSOR_LOCATION}.Ambient: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Front: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.IOH: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Rear: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p> |
|{#SENSOR_LOCATION}.Front: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsFrontTemp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.CRIT:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsFrontTemp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.CRIT:"Ambient"}-3` |HIGH | |
|{#SENSOR_LOCATION}.Rear: Temperature is above warning threshold: >{$TEMP.MAX.WARN:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsRearTemp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.WARN:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsRearTemp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.WARN:"Ambient"}-3` |WARNING |<p>**Depends on**:</p><p>- {#SENSOR_LOCATION}.Ambient: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Front: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.IOH: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Rear: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p> |
|{#SENSOR_LOCATION}.Rear: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsRearTemp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.CRIT:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempStatsRearTemp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.CRIT:"Ambient"}-3` |HIGH | |
|{#SENSOR_LOCATION}.IOH: Temperature is above warning threshold: >{$TEMP.MAX.WARN:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempSltatsIoh1Temp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.WARN:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempSltatsIoh1Temp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.WARN:"Ambient"}-3` |WARNING |<p>**Depends on**:</p><p>- {#SENSOR_LOCATION}.Ambient: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Front: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.IOH: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p><p>- {#SENSOR_LOCATION}.Rear: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"}</p> |
|{#SENSOR_LOCATION}.IOH: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"Ambient"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempSltatsIoh1Temp.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.CRIT:"Ambient"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsComputeRackUnitMbTempSltatsIoh1Temp.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.CRIT:"Ambient"}-3` |HIGH | |
|{#SENSOR_LOCATION}: Temperature is above warning threshold: >{$TEMP.MAX.WARN:"CPU"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsProcessorEnvStatsTemperature.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.WARN:"CPU"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsProcessorEnvStatsTemperature.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.WARN:"CPU"}-3` |WARNING |<p>**Depends on**:</p><p>- {#SENSOR_LOCATION}: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"CPU"}</p> |
|{#SENSOR_LOCATION}: Temperature is above critical threshold: >{$TEMP.MAX.CRIT:"CPU"} |<p>This trigger uses temperature sensor values as well as temperature sensor status if available</p> |`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsProcessorEnvStatsTemperature.{#SNMPINDEX}].avg(5m)}>{$TEMP.MAX.CRIT:"CPU"}`<p>Recovery expression:</p>`{TEMPLATE_NAME:cisco.ucs.sensor.temp.value[cucsProcessorEnvStatsTemperature.{#SNMPINDEX}].max(5m)}<{$TEMP.MAX.CRIT:"CPU"}-3` |HIGH | |
|{#VDISK_LOCATION}: Virtual disk is not in OK state |<p>Please check virtual disk for warnings or errors</p> |`{TEMPLATE_NAME:cisco.ucs.hw.virtualdisk.status[cucsStorageLocalLunPresence.{#SNMPINDEX}].last()}<>{$VDISK.STATUS.OK:"equipped"}` |WARNING | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide a feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco).

