/*
 *  yosys -- Yosys Open SYnthesis Suite
 *
 *  Copyright (C) 2012  Clifford Wolf <clifford@clifford.at>
 *
 *  Permission to use, copy, modify, and/or distribute this software for any
 *  purpose with or without fee is hereby granted, provided that the above
 *  copyright notice and this permission notice appear in all copies.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  ---
 *
 *  A very simple and straightforward frontend for the RTLIL text
 *  representation (as generated by the 'ilang' backend).
 *
 */

#include "ilang_frontend.h"
#include "kernel/register.h"
#include "kernel/log.h"

void rtlil_frontend_ilang_yyerror(char const *s)
{
	YOSYS_NAMESPACE_PREFIX log_error("Parser error in line %d: %s\n", rtlil_frontend_ilang_yyget_lineno(), s);
}

YOSYS_NAMESPACE_BEGIN

struct IlangFrontend : public Frontend {
	IlangFrontend() : Frontend("ilang", "read modules from ilang file") { }
	virtual void help()
	{
		//   |---v---|---v---|---v---|---v---|---v---|---v---|---v---|---v---|---v---|---v---|
		log("\n");
		log("    read_ilang [filename]\n");
		log("\n");
		log("Load modules from an ilang file to the current design. (ilang is a text\n");
		log("representation of a design in yosys's internal format.)\n");
		log("\n");
	}
	virtual void execute(std::istream *&f, std::string filename, std::vector<std::string> args, RTLIL::Design *design)
	{
		log_header("Executing ILANG frontend.\n");
		extra_args(f, filename, args, 1);
		log("Input filename: %s\n", filename.c_str());

		ILANG_FRONTEND::lexin = f;
		ILANG_FRONTEND::current_design = design;
		rtlil_frontend_ilang_yydebug = false;
		rtlil_frontend_ilang_yyrestart(NULL);
		rtlil_frontend_ilang_yyparse();
		rtlil_frontend_ilang_yylex_destroy();
	}
} IlangFrontend;

YOSYS_NAMESPACE_END

