#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Features.Transforms.Basis import Basis

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.6.post2'
__CHEETAH_versionTuple__ = (3, 2, 6, 'post', 2)
__CHEETAH_genTime__ = 1634954793.2466092
__CHEETAH_genTimestamp__ = 'Sat Oct 23 13:06:33 2021'
__CHEETAH_src__ = '/home/mattias/xmds-3.0.0/admin/staging/xmds-3.1.0/xpdeint/Features/Transforms/EPBasis.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Aug 22 13:50:36 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class EPBasis(Basis):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(EPBasis, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def transformFunctionStart(self, **KWS):



        ## CHEETAH: generated from @def transformFunctionStart at line 30, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''static ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 31, col 8
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 31, col 8.
        write(''' *_mmt_matrix_forward_even = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 32, col 8
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 32, col 8.
        write(''' *_mmt_matrix_forward_odd  = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 33, col 8
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 33, col 8.
        write(''' *_mmt_matrix_backward_even = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 34, col 8
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 34, col 8.
        write(''' *_mmt_matrix_backward_odd  = NULL;
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimReps(self, forwardDimRep, backwardDimRep, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimReps($forwardDimRep, $backwardDimRep) at line 38, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''long _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 39, col 12
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 39, col 12.
        write(''' = (''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 39, col 37
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 39, col 37.
        write(''' + 1)/2;   // Number of even (symmetric) basis modes
long _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 40, col 11
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 40, col 11.
        write(''' = ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 40, col 35
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 40, col 35.
        write('''/2;          // Number of odd (antisymmetric) basis modes
long _even_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 41, col 12
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 41, col 12.
        write(''' = (''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 41, col 38
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 41, col 38.
        write(''' + 1)/2;
long _odd_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 42, col 11
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 42, col 11.
        write(''' = ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 42, col 36
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 42, col 36.
        write('''/2;
_mmt_matrix_forward_even = (''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 43, col 29
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 43, col 29.
        write(''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 43, col 62
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 43, col 62.
        write(''') * _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 43, col 83
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 43, col 83.
        write(''' * _even_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 43, col 113
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 43, col 113.
        write(''');
_mmt_matrix_forward_odd  = (''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 44, col 29
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 44, col 29.
        write(''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 44, col 62
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 44, col 62.
        write(''') * _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 44, col 82
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 44, col 82.
        write(''' * _odd_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 44, col 111
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 44, col 111.
        write(''');
_mmt_matrix_backward_even = (''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 45, col 30
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 45, col 30.
        write(''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 45, col 63
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 45, col 63.
        write(''') * _even_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 45, col 84
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 45, col 84.
        write(''' * _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 45, col 115
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 45, col 115.
        write(''');
_mmt_matrix_backward_odd  = (''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 46, col 30
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 46, col 30.
        write(''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 46, col 63
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 46, col 63.
        write(''') * _odd_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 46, col 83
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 46, col 83.
        write(''' * _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 46, col 113
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 46, col 113.
        write(''');

for (long _i0 = 0; _i0 < _even_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 48, col 32
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 48, col 32.
        write('''; _i0++) {
  long __i0 = ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 49, col 15
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 49, col 15.
        write(''' - 1 - _i0;
  ''')
        _v = VFFSL(SL,"transformMatricesForwardDimConstantsAtIndex",False)(forwardDimRep, backwardDimRep, '__i0') # "${transformMatricesForwardDimConstantsAtIndex(forwardDimRep, backwardDimRep, '__i0'), autoIndent=True}" on line 50, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${transformMatricesForwardDimConstantsAtIndex(forwardDimRep, backwardDimRep, '__i0'), autoIndent=True}")) # from line 50, col 3.
        write('''  for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 51, col 28
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 51, col 28.
        write('''; _i1++) {
    ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndices",False)(forwardDimRep, backwardDimRep, '_i0', '_i1') # "${transformMatricesForDimRepsAtIndices(forwardDimRep, backwardDimRep, '_i0', '_i1'), autoIndent=True}" on line 52, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${transformMatricesForDimRepsAtIndices(forwardDimRep, backwardDimRep, '_i0', '_i1'), autoIndent=True}")) # from line 52, col 5.
        write('''  }
}
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimRepsAtIndices(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimRepsAtIndices($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex) at line 57, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''if (''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 59, col 5
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 59, col 5.
        write(''' & 1) {
  // ''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 60, col 6
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 60, col 6.
        write(''' is odd
  if (''')
        _v = VFFSL(SL,"forwardIndex",True) # '${forwardIndex}' on line 61, col 7
        if _v is not None: write(_filter(_v, rawExpr='${forwardIndex}')) # from line 61, col 7.
        write(''' < _odd_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 61, col 30
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 61, col 30.
        write(''') {
    ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndicesOfKind",False)(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'odd') # "${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'odd'), autoIndent=True}" on line 62, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'odd'), autoIndent=True}")) # from line 62, col 5.
        write('''  }
} else {
  // ''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 65, col 6
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 65, col 6.
        write(''' is even
  ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndicesOfKind",False)(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'even') # "${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'even'), autoIndent=True}" on line 66, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${transformMatricesForDimRepsAtIndicesOfKind(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, 'even'), autoIndent=True}")) # from line 66, col 3.
        write('''}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimRepsAtIndicesOfKind(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, kind, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimRepsAtIndicesOfKind($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex, $kind) at line 71, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        logicalForwardIndex = '_' + forwardIndex
        logicalBackwardIndex = backwardIndex
        actualBackwardIndex = '_' + backwardIndex
        if kind == 'even': # generated from line 76, col 3
            actualForwardIndex = forwardIndex
        else: # generated from line 78, col 3
            actualForwardIndex = ''.join(['(_odd_',str(VFFSL(SL,"forwardDimRep.name",True)),' -1 - ',str(VFFSL(SL,"forwardIndex",True)),')'])
        write('''long ''')
        _v = VFFSL(SL,"actualBackwardIndex",True) # '${actualBackwardIndex}' on line 81, col 6
        if _v is not None: write(_filter(_v, rawExpr='${actualBackwardIndex}')) # from line 81, col 6.
        write(''' = ''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 81, col 31
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 81, col 31.
        write('''/2;
_mmt_matrix_forward_''')
        _v = VFFSL(SL,"kind",True) # '${kind}' on line 82, col 21
        if _v is not None: write(_filter(_v, rawExpr='${kind}')) # from line 82, col 21.
        write('''[''')
        _v = VFFSL(SL,"actualBackwardIndex",True) # '${actualBackwardIndex}' on line 82, col 29
        if _v is not None: write(_filter(_v, rawExpr='${actualBackwardIndex}')) # from line 82, col 29.
        write(''' * _''')
        _v = VFFSL(SL,"kind",True) # '${kind}' on line 82, col 55
        if _v is not None: write(_filter(_v, rawExpr='${kind}')) # from line 82, col 55.
        write('''_''')
        _v = VFFSL(SL,"forwardDimRep.name",True) # '${forwardDimRep.name}' on line 82, col 63
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.name}')) # from line 82, col 63.
        write(''' + ''')
        _v = VFFSL(SL,"actualForwardIndex",True) # '${actualForwardIndex}' on line 82, col 87
        if _v is not None: write(_filter(_v, rawExpr='${actualForwardIndex}')) # from line 82, col 87.
        write('''] = \\
  ''')
        _v = VFFSL(SL,"forwardMatrixForDimAtIndices",False)(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex) # '${forwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}' on line 83, col 3
        if _v is not None: write(_filter(_v, rawExpr='${forwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}')) # from line 83, col 3.
        write(''';
_mmt_matrix_backward_''')
        _v = VFFSL(SL,"kind",True) # '${kind}' on line 84, col 22
        if _v is not None: write(_filter(_v, rawExpr='${kind}')) # from line 84, col 22.
        write('''[''')
        _v = VFFSL(SL,"actualForwardIndex",True) # '${actualForwardIndex}' on line 84, col 30
        if _v is not None: write(_filter(_v, rawExpr='${actualForwardIndex}')) # from line 84, col 30.
        write(''' * _''')
        _v = VFFSL(SL,"kind",True) # '${kind}' on line 84, col 55
        if _v is not None: write(_filter(_v, rawExpr='${kind}')) # from line 84, col 55.
        write('''_''')
        _v = VFFSL(SL,"backwardDimRep.name",True) # '${backwardDimRep.name}' on line 84, col 63
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.name}')) # from line 84, col 63.
        write(''' + ''')
        _v = VFFSL(SL,"actualBackwardIndex",True) # '${actualBackwardIndex}' on line 84, col 88
        if _v is not None: write(_filter(_v, rawExpr='${actualBackwardIndex}')) # from line 84, col 88.
        write('''] = \\
  ''')
        _v = VFFSL(SL,"backwardMatrixForDimAtIndices",False)(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex) # '${backwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}' on line 85, col 3
        if _v is not None: write(_filter(_v, rawExpr='${backwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, logicalForwardIndex, logicalBackwardIndex)}')) # from line 85, col 3.
        write(''';
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performTransform(self, sourceDimRep, destDimRep, dir=None, **KWS):



        ## CHEETAH: generated from @def performTransform($sourceDimRep, $destDimRep, $dir = None) at line 89, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        if dir == 'forward': # generated from line 91, col 3
            _v = VFFSL(SL,"performForwardTransform",False)(sourceDimRep, destDimRep) # '${performForwardTransform(sourceDimRep, destDimRep)}' on line 92, col 1
            if _v is not None: write(_filter(_v, rawExpr='${performForwardTransform(sourceDimRep, destDimRep)}')) # from line 92, col 1.
        else: # generated from line 93, col 3
            _v = VFFSL(SL,"performBackwardTransform",False)(sourceDimRep, destDimRep) # '${performBackwardTransform(sourceDimRep, destDimRep)}' on line 94, col 1
            if _v is not None: write(_filter(_v, rawExpr='${performBackwardTransform(sourceDimRep, destDimRep)}')) # from line 94, col 1.
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performForwardTransform(self, sourceDimRep, destDimRep, **KWS):



        ## CHEETAH: generated from @def performForwardTransform($sourceDimRep, $destDimRep) at line 98, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        blasTypeChar = {'real': {'single': 's', 'double': 'd'}, 'complex': {'single': 'c', 'double': 'z'}}[self.matrixType][VFFSL(SL,"precision",True)]
        alphaBetaPrefix = {'real': '', 'complex': '&'}[self.matrixType]
        matMultFunction = 'cblas_%sgemm' % blasTypeChar
        write('''// Loop to create symmetric and antisymmetric components.
''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 104, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 104, col 1.
        write(''' _temp;
long outerOffset = _i0 * innerLoopSize * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 105, col 42
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 105, col 42.
        write(''';
for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 106, col 26
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 106, col 26.
        write('''/2; _i1++) {
  ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 107, col 3
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 107, col 3.
        write('''* __restrict__ _low = &source_data[outerOffset + _i1 * innerLoopSize];
  ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 108, col 3
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 108, col 3.
        write('''* __restrict__ _high = &source_data[outerOffset + (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 108, col 67
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 108, col 67.
        write(''' - 1 - _i1) * innerLoopSize];
  for (long _i2 = 0; _i2 < innerLoopSize; _i2++) {
    _temp = _low[_i2];
    _low[_i2] += _high[_i2];  // _low stores the symmetric component
    _high[_i2] -= _temp; // _high stores the antisymmetric component
  }
}
const ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 115, col 7
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 115, col 7.
        write(''' alpha = 1.0;
const ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 116, col 7
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 116, col 7.
        write(''' beta = 0.0;

/* Note that the ''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 118, col 18
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 118, col 18.
        write(''' matrix multiply call does the following matrix multiplication

   C = alpha A B + beta C

where A is m-by-k, B is k-by-n. Parameters are

void ''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 124, col 6
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 124, col 6.
        write('''(Order, TransA, TransB, M, N, K, alpha, *A, lda, *B, ldb, beta, *C, ldc)

where
Order:  Specifies row-major (C) or column-major (Fortran) data ordering.
TransA: Specifies whether to transpose matrix A.
TransB: Specifies whether to transpose matrix B.
M:      Number of rows in matrices A and C.
N:      Number of columns in matrices B and C.
K:      Number of columns in matrix A; number of rows in matrix B.
alpha:  Scaling factor for the product of matrices A and B.
A:      Matrix A.
lda:    The size of the first dimension of matrix A; if you are passing a matrix A[m][n], the value should be m.
B:      Matrix B.
ldb:    The size of the first dimension of matrix B; if you are passing a matrix B[m][n], the value should be m.
beta:   Scaling factor for matrix C.
C:      Matrix C.
ldc:   The size of the first dimension of matrix C; if you are passing a matrix C[m][n], the value should be m.
*/

// Symmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 144, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 144, col 1.
        write('''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 145, col 14
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 145, col 14.
        write('''+1)/2,
            /* nelem */ innerLoopSize,
            (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 147, col 14
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 147, col 14.
        write('''+1)/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 148, col 25
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 148, col 25.
        write('''alpha,
            /* A */ _mmt_matrix_forward_even, (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 149, col 48
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 149, col 48.
        write('''+1)/2,
            /* B */ source_data + _i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 150, col 41
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 150, col 41.
        write(''' * innerLoopSize,
                    innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 152, col 24
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 152, col 24.
        write('''beta,
            /* C */ dest_data + _i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 153, col 39
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 153, col 39.
        write(''' * innerLoopSize,
            2 * innerLoopSize);
// Antisymmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 156, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 156, col 1.
        write('''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 157, col 13
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 157, col 13.
        write('''/2,
            /* nelem */ innerLoopSize,
            ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 159, col 13
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 159, col 13.
        write('''/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 160, col 25
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 160, col 25.
        write('''alpha,
            /* A */ _mmt_matrix_forward_odd, ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 161, col 46
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 161, col 46.
        write('''/2,
            /* B */ source_data + (_i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 162, col 42
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 162, col 42.
        write(''' + (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 162, col 75
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 162, col 75.
        write('''+1)/2) * innerLoopSize,
                    innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 164, col 24
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 164, col 24.
        write('''beta,
            /* C */ dest_data + (_i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 165, col 40
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 165, col 40.
        write(''' + 1) * innerLoopSize,
            2 * innerLoopSize);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performBackwardTransform(self, sourceDimRep, destDimRep, **KWS):



        ## CHEETAH: generated from @def performBackwardTransform($sourceDimRep, $destDimRep) at line 170, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        blasTypeChar = {'real': {'single': 's', 'double': 'd'}, 'complex': {'single': 'c', 'double': 'z'}}[self.matrixType][VFFSL(SL,"precision",True)]
        alphaBetaPrefix = {'real': '', 'complex': '&'}[self.matrixType]
        matMultFunction = 'cblas_%sgemm' % blasTypeChar
        write('''const ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 175, col 7
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 175, col 7.
        write(''' alpha = 1.0;
const ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 176, col 7
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 176, col 7.
        write(''' beta = 0.0;

// Symmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 179, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 179, col 1.
        write('''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 180, col 14
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 180, col 14.
        write('''+1)/2,
            /* nelem */ innerLoopSize,
            (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 182, col 14
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 182, col 14.
        write('''+1)/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 183, col 25
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 183, col 25.
        write('''alpha,
            /* A */ _mmt_matrix_backward_even, (''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 184, col 49
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 184, col 49.
        write('''+1)/2,
            /* B */ source_data + _i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 185, col 41
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 185, col 41.
        write(''' * innerLoopSize,
                    2 * innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 187, col 24
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 187, col 24.
        write('''beta,
            /* C */ dest_data + _i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 188, col 39
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 188, col 39.
        write(''' * innerLoopSize,
            innerLoopSize);
// Antisymmetric component of the transform
''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 191, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 191, col 1.
        write('''(CblasRowMajor, CblasNoTrans, CblasNoTrans,
            ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 192, col 13
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 192, col 13.
        write('''/2,
            /* nelem */ innerLoopSize,
            ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 194, col 13
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 194, col 13.
        write('''/2,
            /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 195, col 25
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 195, col 25.
        write('''alpha,
            /* A */ _mmt_matrix_backward_odd, ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 196, col 47
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 196, col 47.
        write('''/2,
            /* B */ source_data + (_i0 * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 197, col 42
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 197, col 42.
        write(''' + 1) * innerLoopSize,
                    2 * innerLoopSize,
            /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 199, col 24
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 199, col 24.
        write('''beta,
            /* C */ dest_data + (_i0 * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 200, col 40
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 200, col 40.
        write(''' + (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 200, col 71
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 200, col 71.
        write('''+1)/2) * innerLoopSize,
            innerLoopSize);
// Loop to unravel symmetric and antisymmetric components.
''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 203, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 203, col 1.
        write(''' _temp;
long outerOffset = _i0 * innerLoopSize * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 204, col 42
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 204, col 42.
        write(''';
for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 205, col 26
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 205, col 26.
        write('''/2; _i1++) {
  // _low stored the symmetric component
  ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 207, col 3
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 207, col 3.
        write('''* __restrict__ _low = &dest_data[outerOffset + _i1 * innerLoopSize];
  // _high stored the antisymmetric component
  ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 209, col 3
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 209, col 3.
        write('''* __restrict__ _high = &dest_data[outerOffset + (''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 209, col 65
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 209, col 65.
        write(''' - 1 - _i1) * innerLoopSize];
  for (long _i2 = 0; _i2 < innerLoopSize; _i2++) {
    _temp = _low[_i2];
    // _low is the negative domain
    _low[_i2] -= _high[_i2];
    // _high is the positive domain
    _high[_i2] += _temp;
  }
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # EPBasis.tmpl
        # 
        # Base class for a Basis where each basis function has definite parity
        # and the parity alternates between successive basis functions.
        # Bases inheriting from this class will use the faster Parity Matrix Multiplication Transform (PMMT).
        # 
        # Created by Graham Dennis on 2008-12-27.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''








''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_EPBasis = 'writeBody'

## END CLASS DEFINITION

if not hasattr(EPBasis, '_initCheetahAttributes'):
    templateAPIClass = getattr(EPBasis,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(EPBasis)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=EPBasis()).run()


