/******************************************************************************
* Copyright 2015-2020 Xilinx, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
******************************************************************************/

#pragma once

#ifndef _HELP_VERSAL_H_
#define _HELP_VERSAL_H_

#include <string>



/***********************************************************************************************
* Option       : init
* Description  : Register Initialization
************************************************************************************************/
#define HV_BIF_INIT_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | init                                                           |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Register initialization block at the end of the bootloader,    |\n\
             | built by parsing the .int file specification. Maximum of 256   |\n\
             | address-value init pairs are allowed. The int files have       |\n\
             | a specific format.                                             |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | init = <filename>                                              |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |    init = test.ini                                             |\n\
             |    { type = bootloader, file = /path/to/plm.elf }              |\n\
             | }                                                              |\n\
             |----------------------------------------------------------------|\n\
             | Sample .int file - test.ini                                    |\n\
             |      .set. 0xF8000120 = 0x1F000200;                            |\n\
             |      .set. 0xF8000720 = 0x00000202;                            |\n\
             |      .set. 0xF800014C = 0x00000521;                            |\n\
-------------+----------------------------------------------------------------+\n"	


/***********************************************************************************************
* Option       : aeskeyfile
* Description  : Encryption Key File
************************************************************************************************/
#define HV_BIF_AES_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | aeskeyfile                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | The path to the AES keyfile. The keyfile contains AES key used |\n\
             | to encrypt the partitions. The contents of the key file needs  |\n\
             | to written to efuse or bbram.                                  |\n\
             | If the key file is not present in the path specified, a new key|\n\
             | is generated by bootgen, which is used for encryption.         |\n\
             | Key file should be specified for each partition.               |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | aeskeyfile = <key filename>                                    |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |         {                                                      |\n\
             |             type = pmcdata,                                    |\n\
             |             load = 0xf2000000,                                 |\n\
             |             aeskeyfile = key2.nky,                             |\n\
             |             file = pmc_cdo.bin                                 |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+"


/***********************************************************************************************
* Option       : ppkfile
* Description  : Encryption Key File
************************************************************************************************/
#define HV_BIF_PPK_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | ppkfile, pskfile, spkfile, sskfile                             |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | These keys are used to authenticate partitions in the bootimage|\n\
             | Xilinx SoCs use primary & secondary keys for authentication.   |\n\
             | The primary keys authenticate the secondary keys and the       |\n\
             | secondary keys authenticate the partitions.                    |\n\
             |    PPK - Primary Public Key                                    |\n\
             |    PSK - Primary Secret Key                                    |\n\
             |    SPK - Secondary Public Key                                  |\n\
             |    SSK - Secondary Secret Key                                  |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | ppkfile = <key filename>                                       |\n\
             | pskfile = <key filename>                                       |\n\
             | spkfile = <key filename>                                       |\n\
             | sskfile = <key filename>                                       |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |     boot_config {bh_auth_enable}                               |\n\
             |     pskfile = /path/to/primary0.pem                            |\n\
             |     sskfile = /path/to/secondary0.pem                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |              id = 0x00010000,                                  |\n\
             |              type = bootloader,                                |\n\
             |              authentication = rsa,                             |\n\
             |              file = /path/to/plm.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              authentication = rsa,                             |\n\
             |              file = /path/to/apu.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

//#define HV_BIF_SPKSIGN_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | spksignature                                                   |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Imports SPK signature into authentication certificate. This can|\n\
             | be used incase the user does't want to share the secret key PSK|\n\
             | The user can create a signature and provide it to Bootgen.     |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | spksignature = <signature-file>                                |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |     headersignature = /path/to/header.sig                      |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |              id = 0x00010000,                                  |\n\
             |              type = bootloader,                                |\n\
             |              authentication = rsa,                             |\n\
             |              sskfile = /path/to/secondary-key.pem,             |\n\
             |              spksignature = /path/to/secondary-key.pem.sig,    |\n\
             |              file = /path/to/plm.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              authentication = rsa,                             |\n\
             |              sskfile = /path/to/secondary-key-2.pem,           |\n\
             |              spksignature = /path/to/secondary-key-2.pem.sig,  |\n\
             |              file = /path/to/apu.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"


//#define HV_BIF_HDRSIGN_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | headersignature                                                |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Imports Header signature into authentication certificate. This |\n\
             | can be used incase the user does't want to share the secret key|\n\
             | The user can create a signature and provide it to Bootgen.     |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | headersignature = <signature-file>                             |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |     headersignature = /path/to/header.sig                      |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |              id = 0x00010000,                                  |\n\
             |              type = bootloader,                                |\n\
             |              authentication = rsa,                             |\n\
             |              sskfile = /path/to/secondary-key.pem,             |\n\
             |              spksignature = /path/to/secondary-key.pem.sig,    |\n\
             |              file = /path/to/plm.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              authentication = rsa,                             |\n\
             |              sskfile = /path/to/secondary-key-2.pem,           |\n\
             |              spksignature = /path/to/secondary-key-2.pem.sig,  |\n\
             |              file = /path/to/apu.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_BI_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | bootimage                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This specifies that the following file specification is a      |\n\
             | bootimage that was created by Bootgen, being reused as input.  |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { type = bootimage }                                           |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          { type = bootimage, file = base_pdi.bin }             |\n\
             |          { type = cdo, file = ps_cdo.bin}                      |\n\
             |          { core = a72 - 0, file = a72_app.elf}                 |\n\
             |          { core = r5 - 0, file = r5_app.elf}                   |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_BL_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | bootloader                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This specifies the partition is a bootloader (PLM). This      |\n\
             | attribute is specified with along with other partition bif     |\n\
             | attributes.                                                    |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { type = bootloader }                                          |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          { type = bootloader, file = plm.elf }                 |\n\
             |          { type = pmcdata, file = pmc_cdo.bin }                |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_ENCR_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | encryption                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This specifies the partition needs to be encrypted.            |\n\
             | AES-GCM is the encryption algorithm used                       |\n\
             |     Versal  : AES-GCM                                          |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { encryption = <options> }                                     |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     | *none : Partition not encrypted                                |\n\
             |  aes  : Partition encrypted using AES algorithm                |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |         {                                                      |\n\
             |             type = pmcdata,                                    |\n\
             |             load = 0xf2000000,                                 |\n\
             |             aeskeyfile = key2.nky,                             |\n\
             |             file = pmc_cdo.bin                                 |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+"

#define HV_BIF_AUTH_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | authentication                                                 |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This specifies the partition needs to be authenticated.        |\n\
             | Authentication Algorithms: RSA-4096, ECDSA                     |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { authenication = <options> }                                  |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     | *none  : Partition not authenticated                           |\n\
             |  rsa   : Partition authenticated using RSA algorithm           |\n\
             |  ecdsa : Partition authenticated using RSA algorithm           |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      boot_config{ bh_auth_enable }                             |\n\
             |      pskfile = primary0.pem                                    |\n\
             |      sskfile = secondary0.pem                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_ss, id = 0x1c000001                        |\n\
             |          {                                                     |\n\
             |              type = bootloader,                                |\n\
             |              authentication = rsa,                             |\n\
             |              file = plm.elf                                    |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              type = pmcdata,                                   |\n\
             |              load = 0xf2000000,                                |\n\
             |              file = pmc_cdo.bin                                |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          {                                                     |\n\
             |              type = cdo,                                       |\n\
             |              authentication = rsa,                             |\n\
             |              file = ps_cdo.bin                                 |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              core = a72-0,                                     |\n\
             |              authentication = rsa,                             |\n\
             |              file = a72_app.elf                                |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |   }                                                            |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_CHKSM_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | checksum                                                       |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This specifies the partition needs to be checksummed.          |\n\
             | Checksum Algorithms: SHA3                                      |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { checksum = <options> }                                       |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     | *none : no checksum operation                                  |\n\
             |  sha3 : SHA3 checksum operation                                |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      init = reginit.ini                                        |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          { type=bootloader, checksum=sha3, file=plm.elf }      |\n\
             |          { type=pmcdata, load=0xf2000000, file=pmc_cdo.bin}    |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n\
 NOTE        | Checksum operation is not supported along with authentication  |\n\
             | and encryption.                                                |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_POWNER_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | owner                                                          |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Owner of the partition which is responsible to load the        |\n\
             | partition.                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { owner = <options> }                                          |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     | *plm  : PLM loads this partition                               |\n\
             |  non-plm : PLM ignores this partition, someone else loads      |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |              id = 0x00010000,                                  |\n\
             |              type = bootloader,                                |\n\
             |              file = /path/to/plm.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              owner = non-plm,                                  |\n\
             |              file = /path/to/hello.elf                         |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"


//#define HV_BIF_PRESIGN_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | presign                                                        |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Imports partition signature into partition authenticate        |\n\
             | certificate.                                                   |\n\
             | This can be used incase the user does't want to share the      |\n\
             | secret key(SSK). The user can create a signature and provide   |\n\
             | it to Bootgen.                                                 |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { presign = <signature-file> }                                 |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |     ppkfile = /path/to/primary0.pem                            |\n\
             |     headersignature = /path/to/headers.sha256.sig              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |              id = 0x00010000,                                  |\n\
             |              type = bootloader,                                |\n\
             |              authentication = rsa,                             |\n\
             |              spkfile = /path/to/secondary-key.pem,             |\n\
             |              spksignature = /path/to/sec-key.pem.sha384.sig,   |\n\
             |              presign = /path/to/plm.sha384.sig,                |\n\
             |              file = /path/to/plm.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_OFFSET_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | offset                                                         |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Sets the absolute offset of the partition in the boot image.   |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { offset = <value> }                                           |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  all:                                                          |\n\
             |  {                                                             |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          { type=bootloader, file=plm.elf }                     |\n\
             |          { type=pmcdata, file=pmc_data.cdo }                   |\n\
             |          { type=cdo, file=ddr.rnpi }                           |\n\
             |          { core=psm, file=psm.elf }                            |\n\
             |          { type=cdo, file=ps_data.cdo }                        |\n\
             |          { type=cdo, file=subsystem.cdo }                      |\n\
             |          { file=u-boot.elf }                                   |\n\
             |          { load=0x1000, offset=0xa00000, file=system.dtb }     |\n\
             |          { core=a72-0, exception_level=el-3, file=bl31.elf }   |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_LOAD_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | load                                                           |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Sets the load address for the partition in memory.             |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { load = <value> }                                             |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          { type=bootloader, checksum=sha3, file=plm.elf }      |\n\
             |          { type=pmcdata, load=0xf2000000, file=pmc_cdo.bin}    |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_KEYSRC_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | keysrc                                                         |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Key source for encryption                                      |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { keysrc = <options> }                                         |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     | efuse_red_key  : Red Key stored in efuse                       |\n\
             | bbram_red_key  : Red Key stored in bbram                       |\n\
             | efuse_gry_key  : Grey (Obfuscated) Key stored in efuse         |\n\
             | bbram_gry_key  : Grey (Obfuscated) Key stored in bbram         |\n\
             | bh_gry_key     : Grey (Obfuscated) Key stored in boot header   |\n\
             | efuse_blk_key  : Black Key stored in efuse                     |\n\
             | bbram_blk_key  : Black Key stored in bbram                     |\n\
             | bh_blk_key     : Black Key stored in boot header               |\n\
             | kup_key        : User Key in boot header                       |\n\
             | user_key0      : User Key 0                                    |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |         {                                                      |\n\
             |             type = pmcdata,                                    |\n\
             |             load = 0xf2000000,                                 |\n\
             |             aeskeyfile = key2.nky,                             |\n\
             |             file = pmc_cdo.bin                                 |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_PMCCONFIG_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | boot_config                                                    |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | These parameters are used to configure the bootimage           |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | boot_config { <options> }                                      |\n\
-------------+---------------------+------------------------------------------+\n\
 OPTIONS     |       Options       |             Description                  |\n\
             +---------------------+------------------------------------------+\n\
             | bh_auth_enable      | Boot Header Authentication Enable:       |\n\
             |                     | Authentication of the bootimage will     |\n\
             |                     | be done excluding the verification of    |\n\
             |                     | PPK hash and SPK ID.                     |\n\
             +---------------------+------------------------------------------+\n\
             | pufhd_bh            | PUF helper data is stored in BH.         |\n\
             |                     | (Default is efuse)                       |\n\
             |                     | PUF helper data file is passed to bootgen|\n\
             |                     | using the option [puf_file].             |\n\
             +---------------------+------------------------------------------+\n\
             | puf4kmode           | PUF is tuned to use in 4k bit syndrome   |\n\
             |                     | configuration.                           |\n\
             |                     | (Default is 12k bit)                     |\n\
             +---------------------+------------------------------------------+\n\
             | shutter = <value>   | 32 bit PUF_SHUT register value to        |\n\
             |                     | configure PUF for shutter offset time    |\n\
             |                     | and shutter open time.                   |\n\
             +---------------------+------------------------------------------+\n\
             | smap_width = <value>| 8, 16, 32                                |\n\
             |                     | Default is 32-bit                        |\n\
-------------+---------------------+------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             +----------------------------------------------------------------|\n\
             | bh_auth_enable_smap_width:                                     |\n\
             | {                                                              |\n\
             |     boot_config { bh_auth_enable, smap_width=16 }              |\n\
             |     pskfile = /path/to/primary0.pem                            |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |              id = 0x00010000,                                  |\n\
             |              type = bootloader,                                |\n\
             |              authentication = rsa,                             |\n\
             |              sskfile = /path/to/secondary-key.pem,             |\n\
             |              file = /path/to/plm.elf                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_DESTCPU_H "\
-------------+----------------------------------------------------------------+\n\
ATTRIBUTE    | core                                                           |\n\
-------------+----------------------------------------------------------------+\n\
DESCRIPTION  | Specifies which core will execute the partition                |\n\
-------------+----------------------------------------------------------------+\n\
USAGE        | { core = <options> }                                           |\n\
-------------+----------------------------------------------------------------+\n\
OPTIONS      | * a72-0                                                        |\n\
             |   a72-1                                                        |\n\
             |   r5-0                                                         |\n\
             |   r5-1                                                         |\n\
             |   psm                                                          |\n\
-------------+----------------------------------------------------------------+\n\
EXPLANATION  | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              offset = 0x500000,                                |\n\
             |              file = /path/to/apu.bin                           |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_TYPE_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | type                                                           |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specifies the type of partition                                |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { type = <options> }                                           |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     | bootloader                                                     |\n\
             | pmcdata                                                        |\n\
             | cdo                                                            |\n\
             | cfi                                                            |\n\
             | bootimage                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          {                                                     |\n\
             |               type = bootloader,                               |\n\
             |               file = plm.elf                                   |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |               type = pmcdata,                                  |\n\
             |               load = 0xf2000000,                               |\n\
             |               file = pmc_data.cdo                              |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_EL_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | exception_level                                                |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Exception level for which the core should be configured        |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { exception_level = <options> }                                |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     |  el-0                                                          |\n\
             |  el-1                                                          |\n\
             |  el-2                                                          |\n\
             | *el-3                                                          |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              exception_level = el-3,                           |\n\
             |              trustzone = secure,                               |\n\
             |              file = /path/to/bl31.elf                          |\n\
             |         }                                                      |\n\
             |         {                                                      |\n\
             |              id = 0x00000001,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              exception_level = el-2,                           |\n\
             |              file = /path/to/u-boot.elf                        |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_TZ_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | trustzone                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Configures the core to be Trustzone secure or nonsecure        |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { trustzone = <options> }                                      |\n\
-------------+----------------------------------------------------------------+\n\
 OPTIONS     |  *secure                                                       |\n\
             |  nonsecure                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = apu_subsys,  id = 0x1c000003                    |\n\
             |         {                                                      |\n\
             |              id = 0x00000000,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              exception_level = el-3,                           |\n\
             |              trustzone = secure,                               |\n\
             |              file = /path/to/bl31.elf                          |\n\
             |         }                                                      |\n\
             |         {                                                      |\n\
             |              id = 0x00000001,                                  |\n\
             |              core = a72-0,                                     |\n\
             |              exception_level = el-2,                           |\n\
             |              file = /path/to/u-boot.elf                        |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_BOOTDEV_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | boot_device                                                    |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Secondary Boot Attributes                                      |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | boot_device { <device>, address= <address> }                   |\n\
             | <device>  - To specify the secondary boot device.              |\n\
             | address   - To specify the address at which the image is       |\n\
             |             present in the secondary boot device.              |\n\
             |             Default address is 0.                              |\n\
-------------+----------------------------------------------------------------|\n\
 OPTIONS     |  qspi32                                                        |\n\
             |  qspi24                                                        |\n\
             |  nand                                                          |\n\
             |  sd0                                                           |\n\
             |  sd1                                                           |\n\
             |  sd-ls                                                         |\n\
             |  mmc                                                           |\n\
             |  usb                                                           |\n\
             |  ethernet                                                      |\n\
             |  pcie                                                          |\n\
             |  sata                                                          |\n\
             |  ospi                                                          |\n\
             |  smap                                                          |\n\
             |  sbi                                                           |\n\
             |  sd0-raw                                                       |\n\
             |  sd1-raw                                                       |\n\
             |  sd-ls-raw                                                     |\n\
             |  mmc-raw                                                       |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF 1 - test.bif                                        |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |      boot_device { qspi32, address = 0x10000 }                 |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          {                                                     |\n\
             |               type = bootloader,                               |\n\
             |               file = plm.elf                                   |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              type = pmcdata,                                   |\n\
             |              load = 0xf2000000,                                |\n\
             |              file = pmc_data.cdo                               |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_BHKEY_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | bh_keyfile                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | 256-bit obfuscated key to be stored in boot header             |\n\
             | This is only valid, when [keysrc_encryption] bh_gry_key        |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | bh_keyfile = <key file path>                                   |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bh_gry_key,                               |\n\
             |             bh_keyfile = obfuscated_key.txt                    |\n\
             |             bh_key_iv = obfuscated_iv.txt                      |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_BHIV_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | bh_key_iv                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Initialization vector used when decrypting the obfuscated key  |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | bh_key_iv = <iv file path>                                     |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bh_gry_key,                               |\n\
             |             bh_keyfile = obfuscated_key.txt                    |\n\
             |             bh_key_iv = obfuscated_iv.txt                      |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_METAL_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | familykey                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specify family key to generate obfuscated key from red key     |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | familykey = <key file path>                                    |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             | {                                                              |\n\
             |    aeskeyfile = encr.nky                                       |\n\
             |    bh_key_iv = bh_iv.txt                                       |\n\
             |    familykey = familykey.txt                                   |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"	


#define HV_BIF_BLOCKS_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | blocks                                                         |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specify block sizes for key-rolling feature in encrytion.      |\n\
             | Each module is encrypted using its own unique key. The initial |\n\
             | key is stored at the key source on the device, while keys for  |\n\
             | each successive module are encrypted (wrapped) in the previous |\n\
             | module.                                                        |\n\
             | <size> mentioned will be taken in Bytes. If X(*) is specified, |\n\
             | then all the remaining blocks would of the size 'X'.           |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { blocks = <size><num>; <size><num>; ...; <size><*> }          |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |     image                                                      |\n\
             |     {                                                          |\n\
             |         name = pmc_subsys, id = 0x1c000001                     |\n\
             |         {                                                      |\n\
             |             type = bootloader,                                 |\n\
             |             encryption = aes,                                  |\n\
             |             keysrc = bbram_red_key,                            |\n\
             |             aeskeyfile = key1.nky,                             |\n\
             |             blocks= 512(2); 65536; 8192(*)                     |\n\
             |             file = plm.elf                                     |\n\
             |         }                                                      |\n\
             |     }                                                          |\n\
-------------+----------------------------------------------------------------+\n\
             | In the above example, the first two blocks are of 512 bytes,   |\n\
             | next block is of 65536 bytes, the rest of the partition into   |\n\
             | blocks of 8192 bytes.                                          |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_DELAYHNDOFF_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | delay_handoff                                                  |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | With this flag specified, the handoff to subsystem is delayed  |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { delay_handoff }                                              |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |      id = 2                                                    |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          { type = bootloader, file = plm.elf }                 |\n\
             |          { type = pmcdata, file = pmc_cdo.bin }                |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = subsys_1, id = 0x1c000000, delay_handoff       |\n\
             |          { type = cdo, file = apu_cdo.cdo }                    |\n\
             |          { core = a72-0, file = apu.elf }                      |\n\
             |      }                                                         |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_DELAYLOAD_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | delay_load                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | With this flag specified, the loading of subsystem is delayed  |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { delay_load }                                                 |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             | {                                                              |\n\
             |      id = 2                                                    |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          { type = bootloader, file = plm.elf }                 |\n\
             |          { type = pmcdata, file = pmc_cdo.bin }                |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = subsys_1, id = 0x1c000000, delay_load          |\n\
             |          { type = cdo, file = apu_cdo.cdo }                    |\n\
             |          { core = a72-0, file = apu.elf }                      |\n\
             |      }                                                         |\n\
             | }                                                              |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_PARTITION_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | partition                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This attribute is used to define a partition                   |\n\
             | It is an optional attribute to make the BIF short and readable |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | partition {  }                                                 |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = WDI_FLAT, id = 0x1c000000                      |\n\
             |          partition                                             |\n\
             |          {                                                     |\n\
             |              id = 0x1                                          |\n\
             |              type = bootloader                                 |\n\
             |              file = plm.elf                                    |\n\
             |          }                                                     |\n\
             |          partition                                             |\n\
             |          {                                                     |\n\
             |              id = 0x9                                          |\n\
             |              type = pmcdata,                                   |\n\
             |              file = pmc_cdo.bin                                |\n\
             |          }                                                     |\n\
             |          partition                                             |\n\
             |          {                                                     |\n\
             |              id = 0x3                                          |\n\
             |              type = cdo                                        |\n\
             |              file = bitstream.rcdo                             |\n\
             |          }                                                     |\n\
             |          partition                                             |\n\
             |          {                                                     |\n\
             |              id = 0x4                                          |\n\
             |              file = bitstream.rcfi                             |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
             |                                                                |\n\
             | The same BIF can be written in shorter format as:              |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = WDI_FLAT, id = 0x1c000000                      |\n\
             |          { id = 0x1, type = bootloader, file = plm.elf }       |\n\
             |          { id = 0x9, type = pmcdata, file = pmc_cdo.bin }      |\n\
             |          { id = 0x3, type = cdo, file = bitstream.rcdo }       |\n\
             |          { id = 0x4, file = bitstream.rcfi }                   |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
             |                                                                |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_IMAGE_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | image                                                          |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This attribute is used to define a subsytem/image              |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | image {  }                                                     |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = PMC_SS, id = 0x1c000000                        |\n\
             |          { id = 0x1, type = bootloader, file = plm.elf }       |\n\
             |          { id = 0x9, type = pmcdata, file = pmc_cdo.bin }      |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = PL_SS, id = 0x1c000004                         |\n\
             |          { id = 0x3, type = cdo, file = bitstream.rcdo }       |\n\
             |          { id = 0x4, file = bitstream.rcfi }                   |\n\
             |          { id = 0x4, file = bitstream.rnpi }                   |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
             |                                                                |\n\
             | Here two subsystems/images are created:                        |\n\
             |   1. PMC_SS (0x1c000000)                                       |\n\
             |   2. PL_SS (0x1c000004)                                        |\n\
-------------+----------------------------------------------------------------|\n"

#define HV_BIF_METAHDR_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | metahdr                                                        |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | This attribute is used to define encryption, authentication    |\n\
             | attributes for meta headers like keys, key sources etc.        |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | metahdr {  }                                                   |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | test:                                                          |\n\
             |  {                                                             |\n\
             |      metaheader                                                |\n\
             |      {                                                         |\n\
             |          encryption = aes,                                     |\n\
             |          keysrc = bbram_red_key,                               |\n\
             |          aeskeyfile = headerkey.nky,                           |\n\
             |          authentication = rsa                                  |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          {                                                     |\n\
             |              type = bootloader,                                |\n\
             |              encryption = aes,                                 |\n\
             |              keysrc = bbram_red_key,                           |\n\
             |              aeskeyfile = key1.nky,                            |\n\
             |              blocks = 8192(*),                                 |\n\
             |              file = plm.elf                                    |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              type = pmcdata,                                   |\n\
             |              load = 0xf2000000,                                |\n\
             |              aeskeyfile = key2.nky,                            |\n\
             |              file = pmc_cdo.bin                                |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------|\n"

#define HV_BIF_RES_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | reserve                                                        |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Reserves the memory and padded after the partition.            |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { reserve = <value> }                                          |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             | all:                                                           |\n\
             |  {                                                             |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          { type = bootloader, file = plm.elf }                 |\n\
             |          { type = pmcdata, file = pmc_data.cdo }               |\n\
             |          { reserve = 0x1000, file = system.bin }               |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"


#define HV_BIF_COPY_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | copy                                                           |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Copies the image to memory at specified address.               |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { copy = <addr> }                                              |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 2                                                    |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_subsys, id = 0x1c000001                    |\n\
             |          { id = 0x1, type = bootloader, file = plm.elf  }      |\n\
             |          { type = pmcdata, file = pmc_cdo.bin }                |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = subsys_1, id = 0x1c000000, copy = 0x30000      |\n\
             |          { core = psm, file = psm.elf }                        |\n\
             |          { type = cdo, file = ps_data.cdo }                    |\n\
             |          { core = a72 - 0, file = a72_app.elf }                |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_STARTUP_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | startup                                                        |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Provides the start/execution address in case of binary file    |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { startup = <addr> }                                           |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_ss, id = 0x1c000001                        |\n\
             |          { type = bootloader, file = plm.elf}                  |\n\
             |          { type = pmcdata, file = pmc_cdo.bin}                 |\n\
             |          { core = psm, file = psm_fw.elf}                      |\n\
             |          { type = cdo, file = ps_cdo.bin}                      |\n\
             |          { core = a72-0, load = 0x20000, startup = 0x20000,    |\n\
             |            file = a72_app.bin }                                |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_PARENTID_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | parent_id                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specifies the ID for the parent PDI. This is used to identify  |\n\
             | the relationship between a partial PDI and its corresponding   |\n\
             | Boot PDI                                                       |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | parent_id = <id>                                               |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      parent_id = 0x2                                           |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = psm_ss, id = 0x1c000001                        |\n\
             |          { core = psm, file = psm_fw.elf }                     |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = apu_ss, id = 0x1c000002                        |\n\
             |          { type = cdo, file = ps_cdo.bin }                     |\n\
             |          { core = a72-0, file = a72_app.elf }                  |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_ID_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | id                                                             |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specifies the following IDs based on the place its defined:    |\n\
             |   * pdi id       - within outermost/pdi paranthesis            |\n\
             |   * image id     - within image paranthesis                    |\n\
             |   * partition id - within partition paranthesis                |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | id = <id>                                                      |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                            // PDI ID             |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_ss,                                        |\n\
             |          id = 0x1c000001                 // Image ID           |\n\
             |          {                                                     |\n\
             |              type = bootloader,                                |\n\
             |              id = 0x1,                   // Partition ID       |\n\
             |              file = plm.elf                                    |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              type = pmcdata,                                   |\n\
             |              load = 0xf2000000,                                |\n\
             |              file = pmc_cdo.bin                                |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = psm_ss,                                        |\n\
             |          id = 0x1c000001                 // Image ID           |\n\
             |          {                                                     |\n\
             |              core = psm,                                       |\n\
             |              id = 0x3,                   // Partition ID       |\n\
             |              file = psm_fw.elf                                 |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = apu_ss,                                        |\n\
             |          id = 0x1c000002                 // Image ID           |\n\
             |          {                                                     |\n\
             |              type = cdo,                                       |\n\
             |              id = 0x4,                   // Partition ID       |\n\
             |              file = apu_cdo.bin                                |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              core = a72-0,                                     |\n\
             |              id = 0x5,                   // Partition ID       |\n\
             |              file = a72_app.bin                                |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_NAME_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | name                                                           |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specifies the name of the image/subsystem                      |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | name = <name>                                                  |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                            // PDI ID             |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_ss,                  // Image name         |\n\
             |          id = 0x1c000001                 // Image ID           |\n\
             |          {                                                     |\n\
             |              type = bootloader,                                |\n\
             |              id = 0x1,                   // Partition ID       |\n\
             |              file = plm.elf                                    |\n\
             |          }                                                     |\n\
             |          {                                                     |\n\
             |              type = pmcdata,                                   |\n\
             |              load = 0xf2000000,                                |\n\
             |              file = pmc_cdo.bin                                |\n\
             |          }                                                     |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_FILE_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | file                                                           |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specifies the file for creating the partition                  |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { file = <path/to/file> }                                      |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_ss, id = 0x1c000001                        |\n\
             |          { type = bootloader, file = plm.elf}                  |\n\
             |          { type = pmcdata, file = pmc_cdo.bin}                 |\n\
             |          { core = psm, file = psm_fw.elf}                      |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"

#define HV_BIF_PMCDATA_H "\
-------------+----------------------------------------------------------------+\n\
 ATTRIBUTE   | pmcdata                                                        |\n\
-------------+----------------------------------------------------------------+\n\
 DESCRIPTION | Specifies the PMC CDO file which is stiched along with PLM to  |\n\
             | form a single partition loaded by BootRoM                      |\n\
             | This data is encrypted separately but authenticated as a single|\n\
             | partition along with PLM                                       |\n\
-------------+----------------------------------------------------------------+\n\
 USAGE       | { type = <pmc cdo> }                                           |\n\
-------------+----------------------------------------------------------------+\n\
 EXPLANATION | Sample BIF - test.bif                                          |\n\
             |  test:                                                         |\n\
             |  {                                                             |\n\
             |      id = 0x2                                                  |\n\
             |      image                                                     |\n\
             |      {                                                         |\n\
             |          name = pmc_ss, id = 0x1c000001                        |\n\
             |          { type = bootloader, file = plm.elf}                  |\n\
             |          { type = pmcdata, file = pmc_cdo.bin}                 |\n\
             |          { core = psm, file = psm_fw.elf}                      |\n\
             |      }                                                         |\n\
             |  }                                                             |\n\
-------------+----------------------------------------------------------------+\n"
#endif



