/* packet-q708.c
 * Routine and tables for analyzing an ISPC according to Q.708
 * Copyright 2010, Gerasimos Dimitriadis <dimeg [AT] intracom.gr>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <epan/packet.h>

#include "packet-q708.h"

void proto_register_q708(void);

static int proto_q708 = -1;
static int hf_q708_sanc = -1;
static int hf_q708_ispc_name = -1;
static int hf_q708_ispc_operator_name = -1;

/*
 * List of Signalling Area/Network Codes (SANC)
 * Annex to the ITU Operational Bulletin No. 1125 - 1.VI.2017
 *
 * Mapping of SANC to Geographical Area or Signalling Network
 */
static const value_string q708_sanc_areas[] = {
	{ 512, "Liechtenstein (Principality of)" },
	{ 513, "Italy" },
	{ 514, "Netherlands (Kingdom of the)" },
	{ 515, "Italy" },
	{ 516, "Greece" },
	{ 517, "Greece" },
	{ 518, "Netherlands (Kingdom of the)" },
	{ 519, "Netherlands (Kingdom of the)" },
	{ 520, "Netherlands (Kingdom of the)" },
	{ 521, "Netherlands (Kingdom of the)" },
	{ 522, "Netherlands (Kingdom of the)" },
	{ 523, "Netherlands (Kingdom of the)" },
	{ 524, "Belgium" },
	{ 525, "Belgium" },
	{ 526, "Belgium" },
	{ 527, "Belgium" },
	{ 528, "France" },
	{ 529, "France" },
	{ 530, "France" },
	{ 531, "France" },
	{ 532, "France" },
	{ 533, "France" },
	{ 534, "France" },
	{ 535, "France" },
	{ 536, "Monaco (Principality of)" },
	{ 537, "Austria" },
	{ 538, "Austria" },
	{ 539, "Spain" },
	{ 540, "Spain" },
	{ 541, "Spain" },
	{ 542, "Spain" },
	{ 543, "Spain" },
	{ 544, "Hungary" },
	{ 545, "Germany (Federal Republic of)" },
	{ 546, "Germany (Federal Republic of)" },
	{ 547, "Germany (Federal Republic of)" },
	{ 548, "Germany (Federal Republic of)" },
	{ 549, "Germany (Federal Republic of)" },
	{ 550, "Germany (Federal Republic of)" },
	{ 551, "Germany (Federal Republic of)" },
	{ 552, "Serbia (Republic of)" },
	{ 553, "Italy" },
	{ 554, "Italy" },
	{ 555, "Italy" },
	{ 556, "Italy" },
	{ 557, "Italy" },
	{ 558, "Italy" },
	{ 559, "Italy" },
	{ 560, "Italy" },
	{ 561, "Italy" },
	{ 562, "Italy" },
	{ 563, "Italy" },
	{ 564, "Romania" },
	{ 565, "Switzerland (Confederation of)" },
	{ 566, "Switzerland (Confederation of)" },
	{ 567, "Switzerland (Confederation of)" },
	{ 568, "Switzerland (Confederation of)" },
	{ 569, "Switzerland (Confederation of)" },
	{ 570, "Switzerland (Confederation of)" },
	{ 571, "Switzerland (Confederation of)" },
	{ 572, "Czech Republic" },
	{ 573, "Switzerland (Confederation of)" },
	{ 574, "Switzerland (Confederation of)" },
	{ 575, "Switzerland (Confederation of)" },
	{ 576, "Austria" },
	{ 577, "Austria" },
	{ 578, "Austria" },
	{ 579, "Austria" },
	{ 580, "United Kingdom of Great Britain and Northern Ireland" },
	{ 581, "United Kingdom of Great Britain and Northern Ireland" },
	{ 582, "United Kingdom of Great Britain and Northern Ireland" },
	{ 583, "United Kingdom of Great Britain and Northern Ireland" },
	{ 584, "United Kingdom of Great Britain and Northern Ireland" },
	{ 585, "United Kingdom of Great Britain and Northern Ireland" },
	{ 586, "United Kingdom of Great Britain and Northern Ireland" },
	{ 587, "United Kingdom of Great Britain and Northern Ireland" },
	{ 588, "Denmark" },
	{ 589, "Denmark" },
	{ 590, "Denmark" },
	{ 591, "Denmark" },
	{ 592, "Sweden" },
	{ 593, "Sweden" },
	{ 594, "Sweden" },
	{ 595, "Sweden" },
	{ 596, "Norway" },
	{ 597, "Norway" },
	{ 598, "Norway" },
	{ 599, "Norway" },
	{ 600, "Finland" },
	{ 601, "Finland" },
	{ 602, "Finland" },
	{ 603, "Finland" },
	{ 604, "Estonia (Republic of)" },
	{ 605, "Italy" },
	{ 606, "Italy" },
	{ 607, "Italy" },
	{ 608, "Latvia (Republic of)" },
	{ 609, "Belgium" },
	{ 610, "Belgium" },
	{ 611, "Belgium" },
	{ 612, "Russian Federation" },
	{ 613, "Russian Federation" },
	{ 614, "Russian Federation" },
	{ 615, "Russian Federation" },
	{ 616, "Russian Federation" },
	{ 617, "Russian Federation" },
	{ 618, "Russian Federation" },
	{ 619, "Russian Federation" },
	{ 620, "Russian Federation" },
	{ 621, "Russian Federation" },
	{ 622, "Russian Federation" },
	{ 623, "Russian Federation" },
	{ 624, "Russian Federation" },
	{ 625, "Russian Federation" },
	{ 626, "Russian Federation" },
	{ 627, "Russian Federation" },
	{ 628, "Russian Federation" },
	{ 629, "Russian Federation" },
	{ 630, "Russian Federation" },
	{ 631, "Russian Federation" },
	{ 632, "Poland (Republic of)" },
	{ 633, "Germany (Federal Republic of)" },
	{ 634, "Germany (Federal Republic of)" },
	{ 635, "Germany (Federal Republic of)" },
	{ 636, "Germany (Federal Republic of)" },
	{ 637, "Germany (Federal Republic of)" },
	{ 638, "Germany (Federal Republic of)" },
	{ 639, "Germany (Federal Republic of)" },
	{ 640, "Germany (Federal Republic of)" },
	{ 641, "Germany (Federal Republic of)" },
	{ 642, "Germany (Federal Republic of)" },
	{ 643, "Germany (Federal Republic of)" },
	{ 644, "Gibraltar" },
	{ 645, "Austria" },
	{ 646, "Poland (Republic of)" },
	{ 647, "Luxembourg" },
	{ 648, "Portugal" },
	{ 649, "Portugal" },
	{ 650, "Portugal" },
	{ 651, "Portugal" },
	{ 652, "Luxembourg" },
	{ 653, "Luxembourg" },
	{ 654, "Netherlands (Kingdom of the)" },
	{ 655, "Netherlands (Kingdom of the)" },
	{ 656, "Ireland" },
	{ 657, "Ireland" },
	{ 658, "Ireland" },
	{ 659, "United Kingdom of Great Britain and Northern Ireland" },
	{ 660, "Iceland" },
	{ 661, "France" },
	{ 662, "France" },
	{ 663, "France" },
	{ 664, "Albania (Republic of)" },
	{ 665, "United Kingdom of Great Britain and Northern Ireland" },
	{ 666, "United Kingdom of Great Britain and Northern Ireland" },
	{ 667, "United Kingdom of Great Britain and Northern Ireland" },
	{ 668, "Malta" },
	{ 669, "Italy" },
	{ 670, "Italy" },
	{ 671, "Italy" },
	{ 672, "Cyprus (Republic of)" },
	{ 673, "United Kingdom of Great Britain and Northern Ireland" },
	{ 674, "United Kingdom of Great Britain and Northern Ireland" },
	{ 675, "United Kingdom of Great Britain and Northern Ireland" },
	{ 676, "United Kingdom of Great Britain and Northern Ireland" },
	{ 677, "United Kingdom of Great Britain and Northern Ireland" },
	{ 678, "United Kingdom of Great Britain and Northern Ireland" },
	{ 679, "United Kingdom of Great Britain and Northern Ireland" },
	{ 680, "Bulgaria (Republic of)" },
	{ 681, "United Kingdom of Great Britain and Northern Ireland" },
	{ 682, "United Kingdom of Great Britain and Northern Ireland" },
	{ 683, "Turkey" },
	{ 684, "Turkey" },
	{ 685, "Turkey" },
	{ 686, "United Kingdom of Great Britain and Northern Ireland" },
	{ 687, "United Kingdom of Great Britain and Northern Ireland" },
	{ 688, "United Kingdom of Great Britain and Northern Ireland" },
	{ 689, "United Kingdom of Great Britain and Northern Ireland" },
	{ 690, "United Kingdom of Great Britain and Northern Ireland" },
	{ 691, "United Kingdom of Great Britain and Northern Ireland" },
	{ 692, "Croatia (Republic of)" },
	{ 693, "Italy" },
	{ 694, "Slovenia (Republic of)" },
	{ 695, "Italy" },
	{ 696, "San Marino (Republic of)" },
	{ 697, "United Kingdom of Great Britain and Northern Ireland" },
	{ 698, "United Kingdom of Great Britain and Northern Ireland" },
	{ 699, "United Kingdom of Great Britain and Northern Ireland" },
	{ 700, "United Kingdom of Great Britain and Northern Ireland" },
	{ 701, "United Kingdom of Great Britain and Northern Ireland" },
	{ 702, "United Kingdom of Great Britain and Northern Ireland" },
	{ 703, "United Kingdom of Great Britain and Northern Ireland" },
	{ 704, "Sweden" },
	{ 705, "Sweden" },
	{ 706, "Sweden" },
	{ 707, "Sweden" },
	{ 708, "Andorra (Principality of)" },
	{ 709, "Andorra (Principality of)" },
	{ 710, "Netherlands (Kingdom of the)" },
	{ 711, "Estonia (Republic of)" },
	{ 712, "Armenia (Republic of)" },
	{ 713, "France" },
	{ 714, "France" },
	{ 715, "France" },
	{ 716, "Belarus (Republic of)" },
	{ 717, "Sweden" },
	{ 718, "Greece" },
	{ 719, "Italy" },
	{ 720, "Georgia" },
	{ 721, "United Kingdom of Great Britain and Northern Ireland" },
	{ 722, "United Kingdom of Great Britain and Northern Ireland" },
	{ 723, "United Kingdom of Great Britain and Northern Ireland" },
	{ 724, "Hungary" },
	{ 725, "Georgia" },
	{ 726, "Ukraine" },
	{ 727, "Italy" },
	{ 728, "Italy" },
	{ 729, "Denmark" },
	{ 730, "Bosnia and Herzegovina" },
	{ 731, "Bosnia and Herzegovina" },
	{ 732, "The Former Yugoslav Republic of Macedonia" },
	{ 733, "France" },
	{ 734, "Germany (Federal Republic of)" },
	{ 735, "Portugal" },
	{ 736, "Moldova (Republic of)" },
	{ 737, "Germany (Federal Republic of)" },
	{ 738, "Germany (Federal Republic of)" },
	{ 739, "Romania" },
	{ 740, "Czech Republic" },
	{ 741, "Czech Republic" },
	{ 742, "Czech Republic" },
	{ 743, "Czech Republic" },
	{ 744, "Slovak Republic" },
	{ 745, "Slovak Republic" },
	{ 746, "Slovak Republic" },
	{ 747, "Slovak Republic" },
	{ 748, "Lithuania (Republic of)" },
	{ 749, "Spain" },
	{ 750, "Spain" },
	{ 751, "Spain" },
	{ 752, "Spain" },
	{ 753, "Spain" },
	{ 754, "Germany (Federal Republic of)" },
	{ 755, "Germany (Federal Republic of)" },
	{ 756, "Germany (Federal Republic of)" },
	{ 757, "Germany (Federal Republic of)" },
	{ 758, "Germany (Federal Republic of)" },
	{ 759, "Germany (Federal Republic of)" },
	{ 760, "Germany (Federal Republic of)" },
	{ 761, "Germany (Federal Republic of)" },
	{ 762, "Germany (Federal Republic of)" },
	{ 763, "Germany (Federal Republic of)" },
	{ 764, "Germany (Federal Republic of)" },
	{ 765, "Netherlands (Kingdom of the)" },
	{ 766, "Finland" },
	{ 767, "Finland" },
	{ 768, "Unassigned" },
	{ 769, "Unassigned" },
	{ 770, "Unassigned" },
	{ 771, "Unassigned" },
	{ 772, "Canada" },
	{ 773, "Canada" },
	{ 774, "Canada" },
	{ 775, "Canada" },
	{ 776, "Canada" },
	{ 777, "Canada" },
	{ 778, "Canada" },
	{ 779, "Canada" },
	{ 780, "Canada" },
	{ 781, "Canada" },
	{ 782, "Unassigned" },
	{ 783, "Unassigned" },
	{ 784, "Saint Pierre and Miquelon (Collectivité territoriale de la République française)" },
	{ 785, "Moldova (Republic of)" },
	{ 786, "Greenland (Denmark)" },
	{ 787, "Unassigned" },
	{ 788, "United States of America" },
	{ 789, "United States of America" },
	{ 790, "United States of America" },
	{ 791, "United States of America" },
	{ 792, "United States of America" },
	{ 793, "United States of America" },
	{ 794, "United States of America" },
	{ 795, "United States of America" },
	{ 796, "United States of America" },
	{ 797, "United States of America" },
	{ 798, "United States of America" },
	{ 799, "United States of America" },
	{ 800, "United States of America" },
	{ 801, "United States of America" },
	{ 802, "United States of America" },
	{ 803, "United States of America" },
	{ 804, "United States of America" },
	{ 805, "United States of America" },
	{ 806, "United States of America" },
	{ 807, "United States of America" },
	{ 808, "United States of America" },
	{ 809, "United States of America" },
	{ 810, "United States of America" },
	{ 811, "United States of America" },
	{ 812, "United States of America" },
	{ 813, "United States of America" },
	{ 814, "United States of America" },
	{ 815, "United States of America" },
	{ 816, "United States of America" },
	{ 817, "United States of America" },
	{ 818, "United States of America" },
	{ 819, "United States of America" },
	{ 820, "United States of America" },
	{ 821, "United States of America" },
	{ 822, "United States of America" },
	{ 823, "United States of America" },
	{ 824, "United States of America" },
	{ 825, "United States of America" },
	{ 826, "United States of America" },
	{ 827, "United States of America" },
	{ 828, "Puerto Rico" },
	{ 829, "Unassigned" },
	{ 830, "Unassigned" },
	{ 831, "Unassigned" },
	{ 832, "United States Virgin Islands" },
	{ 833, "Unassigned" },
	{ 834, "Unassigned" },
	{ 835, "Unassigned" },
	{ 836, "Mexico" },
	{ 837, "Mexico" },
	{ 838, "Mexico" },
	{ 839, "Mexico" },
	{ 840, "Mexico" },
	{ 841, "Mexico" },
	{ 842, "Mexico" },
	{ 843, "Mexico" },
	{ 844, "Jamaica" },
	{ 845, "Jamaica" },
	{ 846, "Jamaica" },
	{ 847, "Jamaica" },
	{ 848, "Unassigned" },
	{ 849, "Unassigned" },
	{ 850, "Unassigned" },
	{ 851, "Unassigned" },
	{ 852, "Barbados" },
	{ 853, "Barbados" },
	{ 854, "Barbados" },
	{ 855, "Unassigned" },
	{ 856, "Antigua and Barbuda" },
	{ 857, "Antigua and Barbuda" },
	{ 858, "Unassigned" },
	{ 859, "Unassigned" },
	{ 860, "Cayman Islands" },
	{ 861, "Cayman Islands" },
	{ 862, "Unassigned" },
	{ 863, "Unassigned" },
	{ 864, "British Virgin Islands" },
	{ 865, "British Virgin Islands" },
	{ 866, "Unassigned" },
	{ 867, "Unassigned" },
	{ 868, "Bermuda" },
	{ 869, "Unassigned" },
	{ 870, "Unassigned" },
	{ 871, "Unassigned" },
	{ 872, "Grenada" },
	{ 873, "Unassigned" },
	{ 874, "Unassigned" },
	{ 875, "Unassigned" },
	{ 876, "Montserrat" },
	{ 877, "Unassigned" },
	{ 878, "Unassigned" },
	{ 879, "Unassigned" },
	{ 880, "Saint Kitts and Nevis" },
	{ 881, "Unassigned" },
	{ 882, "Unassigned" },
	{ 883, "Unassigned" },
	{ 884, "Saint Lucia" },
	{ 885, "Unassigned" },
	{ 886, "Unassigned" },
	{ 887, "Unassigned" },
	{ 888, "Saint Vincent and the Grenadines" },
	{ 889, "Unassigned" },
	{ 890, "Unassigned" },
	{ 891, "Unassigned" },
	{ 892, "Curaçao" },
	{ 893, "Curaçao" },
	{ 894, "Curaçao" },
	{ 895, "Unassigned" },
	{ 896, "Bahamas (Commonwealth of the)" },
	{ 897, "Unassigned" },
	{ 898, "Unassigned" },
	{ 899, "Unassigned" },
	{ 900, "Dominica (Commonwealth of)" },
	{ 901, "Unassigned" },
	{ 902, "Unassigned" },
	{ 903, "Unassigned" },
	{ 904, "Cuba" },
	{ 905, "Cuba" },
	{ 906, "Unassigned" },
	{ 907, "Unassigned" },
	{ 908, "Dominican Republic" },
	{ 909, "Dominican Republic" },
	{ 910, "Dominican Republic" },
	{ 911, "Unassigned" },
	{ 912, "Haiti (Republic of)" },
	{ 913, "Unassigned" },
	{ 914, "Unassigned" },
	{ 915, "Unassigned" },
	{ 916, "Trinidad and Tobago" },
	{ 917, "Trinidad and Tobago" },
	{ 918, "Trinidad and Tobago" },
	{ 919, "Unassigned" },
	{ 920, "Turks and Caicos Islands" },
	{ 921, "Turks and Caicos Islands" },
	{ 922, "Turks and Caicos Islands" },
	{ 923, "Unassigned" },
	{ 924, "Guadeloupe (French Department of)" },
	{ 925, "Unassigned" },
	{ 926, "Unassigned" },
	{ 927, "Unassigned" },
	{ 928, "Martinique (French Department of)" },
	{ 929, "Unassigned" },
	{ 930, "Unassigned" },
	{ 931, "Unassigned" },
	{ 932, "Aruba" },
	{ 933, "Faroe Islands" },
	{ 934, "Unassigned" },
	{ 935, "Unassigned" },
	{ 936, "Anguilla" },
	{ 937, "Anguilla" },
	{ 938, "Unassigned" },
	{ 939, "Unassigned" },
	{ 940, "Mexico" },
	{ 941, "Mexico" },
	{ 942, "Mexico" },
	{ 943, "Mexico" },
	{ 944, "Mexico" },
	{ 945, "Mexico" },
	{ 946, "Mexico" },
	{ 947, "Faroe Islands" },
	{ 948, "United States of America" },
	{ 949, "United States of America" },
	{ 950, "United States of America" },
	{ 951, "United States of America" },
	{ 952, "United States of America" },
	{ 953, "United States of America" },
	{ 954, "United States of America" },
	{ 955, "United States of America" },
	{ 956, "United States of America" },
	{ 957, "United States of America" },
	{ 958, "United States of America" },
	{ 959, "United States of America" },
	{ 960, "United States of America" },
	{ 961, "United States of America" },
	{ 962, "United States of America" },
	{ 963, "United States of America" },
	{ 964, "United States of America" },
	{ 965, "United States of America" },
	{ 966, "United States of America" },
	{ 967, "United States of America" },
	{ 968, "United States of America" },
	{ 969, "United States of America" },
	{ 970, "United States of America" },
	{ 971, "United States of America" },
	{ 972, "United States of America" },
	{ 973, "Unassigned" },
	{ 974, "Unassigned" },
	{ 975, "Unassigned" },
	{ 976, "Unassigned" },
	{ 977, "Unassigned" },
	{ 978, "Saint Helena, Ascension and Tristan da Cunha" },
	{ 979, "Unassigned" },
	{ 980, "Unassigned" },
	{ 981, "Unassigned" },
	{ 982, "Unassigned" },
	{ 983, "Mexico" },
	{ 984, "Mexico" },
	{ 985, "Unassigned" },
	{ 986, "Unassigned" },
	{ 987, "Unassigned" },
	{ 988, "Unassigned" },
	{ 989, "Unassigned" },
	{ 990, "Unassigned" },
	{ 991, "Unassigned" },
	{ 992, "Unassigned" },
	{ 993, "Unassigned" },
	{ 994, "Unassigned" },
	{ 995, "Latvia (Republic of)" },
	{ 996, "Albania (Republic of)" },
	{ 997, "Sweden" },
	{ 998, "United Kingdom of Great Britain and Northern Ireland" },
	{ 999, "Bulgaria (Republic of)" },
	{ 1000, "France" },
	{ 1001, "Albania (Republic of)" },
	{ 1002, "Latvia (Republic of)" },
	{ 1003, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1004, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1005, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1006, "Romania" },
	{ 1007, "Bosnia and Herzegovina" },
	{ 1008, "Cambodia (Kingdom of)" },
	{ 1009, "Montenegro" },
	{ 1010, "Spain" },
	{ 1011, "Germany (Federal Republic of)" },
	{ 1012, "Estonia (Republic of)" },
	{ 1013, "Croatia (Republic of)" },
	{ 1014, "Georgia" },
	{ 1015, "Turkey" },
	{ 1016, "Cyprus (Republic of)" },
	{ 1017, "Portugal" },
	{ 1018, "Romania" },
	{ 1019, "Poland (Republic of)" },
	{ 1020, "Germany (Federal Republic of)" },
	{ 1021, "Poland (Republic of)" },
	{ 1022, "Germany (Federal Republic of)" },
	{ 1023, "Germany (Federal Republic of)" },
	{ 1024, "Unassigned" },
	{ 1025, "Unassigned" },
	{ 1026, "Unassigned" },
	{ 1027, "Israel (State of)" },
	{ 1028, "Israel (State of)" },
	{ 1029, "India (Republic of)" },
	{ 1030, "India (Republic of)" },
	{ 1031, "India (Republic of)" },
	{ 1032, "India (Republic of)" },
	{ 1033, "India (Republic of)" },
	{ 1034, "India (Republic of)" },
	{ 1035, "India (Republic of)" },
	{ 1036, "India (Republic of)" },
	{ 1037, "India (Republic of)" },
	{ 1038, "India (Republic of)" },
	{ 1039, "India (Republic of)" },
	{ 1040, "India (Republic of)" },
	{ 1041, "India (Republic of)" },
	{ 1042, "India (Republic of)" },
	{ 1043, "Pakistan (Islamic Republic of)" },
	{ 1044, "Pakistan (Islamic Republic of)" },
	{ 1045, "Pakistan (Islamic Republic of)" },
	{ 1046, "Pakistan (Islamic Republic of)" },
	{ 1047, "Pakistan (Islamic Republic of)" },
	{ 1048, "Afghanistan" },
	{ 1049, "Afghanistan" },
	{ 1050, "Sri Lanka (Democratic Socialist Republic of)" },
	{ 1051, "Sri Lanka (Democratic Socialist Republic of)" },
	{ 1052, "Myanmar (Republic of the Union of)" },
	{ 1053, "Bangladesh (People's Republic of)" },
	{ 1054, "Lebanon" },
	{ 1055, "Jordan (Hashemite Kingdom of)" },
	{ 1056, "Jordan (Hashemite Kingdom of)" },
	{ 1057, "Jordan (Hashemite Kingdom of)" },
	{ 1058, "Syrian Arab Republic" },
	{ 1059, "Unassigned" },
	{ 1060, "Iraq (Republic of)" },
	{ 1061, "Unassigned" },
	{ 1062, "Kuwait (State of)" },
	{ 1063, "Saudi Arabia (Kingdom of)" },
	{ 1064, "Saudi Arabia (Kingdom of)" },
	{ 1065, "Saudi Arabia (Kingdom of)" },
	{ 1066, "Yemen (Republic of)" },
	{ 1067, "Saudi Arabia (Kingdom of)" },
	{ 1068, "Oman (Sultanate of)" },
	{ 1069, "Oman (Sultanate of)" },
	{ 1070, "Yemen (Republic of)" },
	{ 1071, "Unassigned" },
	{ 1072, "United Arab Emirates" },
	{ 1073, "United Arab Emirates" },
	{ 1074, "Israel (State of)" },
	{ 1075, "Israel (State of)" },
	{ 1076, "Bahrain (Kingdom of)" },
	{ 1077, "Bahrain (Kingdom of)" },
	{ 1078, "Qatar (State of)" },
	{ 1079, "Qatar (State of)" },
	{ 1080, "Mongolia" },
	{ 1081, "Nepal (Federal Democratic Republic of)" },
	{ 1082, "Nepal (Federal Democratic Republic of)" },
	{ 1083, "Nepal (Federal Democratic Republic of)" },
	{ 1084, "United Arab Emirates" },
	{ 1085, "United Arab Emirates" },
	{ 1086, "United Arab Emirates" },
	{ 1087, "Unassigned" },
	{ 1088, "Iran (Islamic Republic of)" },
	{ 1089, "Iran (Islamic Republic of)" },
	{ 1090, "Unassigned" },
	{ 1091, "Unassigned" },
	{ 1092, "Unassigned" },
	{ 1093, "Unassigned" },
	{ 1094, "Azerbaijan (Republic of)" },
	{ 1095, "Azerbaijan (Republic of)" },
	{ 1096, "Bhutan (Kingdom of)" },
	{ 1097, "Unassigned" },
	{ 1098, "Kazakhstan (Republic of)" },
	{ 1099, "Kazakhstan (Republic of)" },
	{ 1100, "Kazakhstan (Republic of)" },
	{ 1101, "Kazakhstan (Republic of)" },
	{ 1102, "Kyrgyz Republic" },
	{ 1103, "Kyrgyz Republic" },
	{ 1104, "Japan" },
	{ 1105, "Japan" },
	{ 1106, "Japan" },
	{ 1107, "Japan" },
	{ 1108, "Japan" },
	{ 1109, "Japan" },
	{ 1110, "Japan" },
	{ 1111, "Japan" },
	{ 1112, "Bahrain (Kingdom of)" },
	{ 1113, "Bahrain (Kingdom of)" },
	{ 1114, "Japan" },
	{ 1115, "Unassigned" },
	{ 1116, "Unassigned" },
	{ 1117, "Unassigned" },
	{ 1118, "Unassigned" },
	{ 1119, "Unassigned" },
	{ 1120, "Unassigned" },
	{ 1121, "Unassigned" },
	{ 1122, "Unassigned" },
	{ 1123, "Unassigned" },
	{ 1124, "Korea (Republic of)" },
	{ 1125, "Korea (Republic of)" },
	{ 1126, "Korea (Republic of)" },
	{ 1127, "Viet Nam (Socialist Republic of)" },
	{ 1128, "Viet Nam (Socialist Republic of)" },
	{ 1129, "Hong Kong, China" },
	{ 1130, "Hong Kong, China" },
	{ 1131, "Hong Kong, China" },
	{ 1132, "Hong Kong, China" },
	{ 1133, "Hong Kong, China" },
	{ 1134, "Macao, China" },
	{ 1135, "Hong Kong, China" },
	{ 1136, "Cambodia (Kingdom of)" },
	{ 1137, "Cambodia (Kingdom of)" },
	{ 1138, "Lao People's Democratic Republic" },
	{ 1139, "Unassigned" },
	{ 1140, "Unassigned" },
	{ 1141, "Unassigned" },
	{ 1142, "Unassigned" },
	{ 1143, "Macao, China" },
	{ 1144, "China (People's Republic of)" },
	{ 1145, "China (People's Republic of)" },
	{ 1146, "China (People's Republic of)" },
	{ 1147, "China (People's Republic of)" },
	{ 1148, "China (People's Republic of)" },
	{ 1149, "China (People's Republic of)" },
	{ 1150, "China (People's Republic of)" },
	{ 1151, "China (People's Republic of)" },
	{ 1152, "China (People's Republic of)" },
	{ 1153, "China (People's Republic of)" },
	{ 1154, "China (People's Republic of)" },
	{ 1155, "Unassigned" },
	{ 1156, "Unassigned" },
	{ 1157, "Unassigned" },
	{ 1158, "Unassigned" },
	{ 1159, "Democratic People's Republic of Korea" },
	{ 1160, "Afghanistan" },
	{ 1161, "Afghanistan" },
	{ 1162, "Afghanistan" },
	{ 1163, "Bangladesh (People's Republic of)" },
	{ 1164, "Bangladesh (People's Republic of)" },
	{ 1165, "Bangladesh (People's Republic of)" },
	{ 1166, "Bangladesh (People's Republic of)" },
	{ 1167, "Bangladesh (People's Republic of)" },
	{ 1168, "Maldives (Republic of)" },
	{ 1169, "Korea (Republic of)" },
	{ 1170, "Unassigned" },
	{ 1171, "Korea (Republic of)" },
	{ 1172, "Korea (Republic of)" },
	{ 1173, "Korea (Republic of)" },
	{ 1174, "Korea (Republic of)" },
	{ 1175, "Korea (Republic of)" },
	{ 1176, "Korea (Republic of)" },
	{ 1177, "Korea (Republic of)" },
	{ 1178, "Korea (Republic of)" },
	{ 1179, "Unassigned" },
	{ 1180, "Unassigned" },
	{ 1181, "Tajikistan (Republic of)" },
	{ 1182, "Tajikistan (Republic of)" },
	{ 1183, "Tajikistan (Republic of)" },
	{ 1184, "Turkmenistan" },
	{ 1185, "Unassigned" },
	{ 1186, "Unassigned" },
	{ 1187, "Unassigned" },
	{ 1188, "Uzbekistan (Republic of)" },
	{ 1189, "Uzbekistan (Republic of)" },
	{ 1190, "Unassigned" },
	{ 1191, "Kyrgyz Republic" },
	{ 1192, "Unassigned" },
	{ 1193, "Unassigned" },
	{ 1194, "Taiwan, China" },
	{ 1195, "Taiwan, China" },
	{ 1196, "Taiwan, China" },
	{ 1197, "Taiwan, China" },
	{ 1198, "Taiwan, China" },
	{ 1199, "Reserved" },
	{ 1200, "Hong Kong, China" },
	{ 1201, "Hong Kong, China" },
	{ 1202, "Hong Kong, China" },
	{ 1203, "Hong Kong, China" },
	{ 1204, "Hong Kong, China" },
	{ 1205, "Hong Kong, China" },
	{ 1206, "Hong Kong, China" },
	{ 1207, "Hong Kong, China" },
	{ 1208, "Hong Kong, China" },
	{ 1209, "Hong Kong, China" },
	{ 1210, "Unassigned" },
	{ 1211, "Unassigned" },
	{ 1212, "Unassigned" },
	{ 1213, "Unassigned" },
	{ 1214, "Sri Lanka (Democratic Socialist Republic of)" },
	{ 1215, "Sri Lanka (Democratic Socialist Republic of)" },
	{ 1216, "Unassigned" },
	{ 1217, "Unassigned" },
	{ 1218, "Unassigned" },
	{ 1219, "Jordan (Hashemite Kingdom of)" },
	{ 1220, "Jordan (Hashemite Kingdom of)" },
	{ 1221, "Unassigned" },
	{ 1222, "Unassigned" },
	{ 1223, "Unassigned" },
	{ 1224, "Kuwait (State of)" },
	{ 1225, "Unassigned" },
	{ 1226, "Unassigned" },
	{ 1227, "Unassigned" },
	{ 1228, "Unassigned" },
	{ 1229, "Viet Nam (Socialist Republic of)" },
	{ 1230, "Viet Nam (Socialist Republic of)" },
	{ 1231, "Unassigned" },
	{ 1232, "Unassigned" },
	{ 1233, "Unassigned" },
	{ 1234, "Unassigned" },
	{ 1235, "Maldives (Republic of)" },
	{ 1236, "Unassigned" },
	{ 1237, "Unassigned" },
	{ 1238, "Unassigned" },
	{ 1239, "Unassigned" },
	{ 1240, "Unassigned" },
	{ 1241, "Nepal (Federal Democratic Republic of)" },
	{ 1242, "Unassigned" },
	{ 1243, "Unassigned" },
	{ 1244, "Unassigned" },
	{ 1245, "Unassigned" },
	{ 1246, "Unassigned" },
	{ 1247, "Unassigned" },
	{ 1248, "India (Republic of)" },
	{ 1249, "Myanmar (Republic of the Union of)" },
	{ 1250, "Myanmar (Republic of the Union of)" },
	{ 1251, "Albania (Republic of)" },
	{ 1252, "France" },
	{ 1253, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1254, "Netherlands (Kingdom of the)" },
	{ 1255, "Finland" },
	{ 1256, "Slovenia (Republic of)" },
	{ 1257, "Armenia (Republic of)" },
	{ 1258, "Greece" },
	{ 1259, "Spain" },
	{ 1260, "Lithuania (Republic of)" },
	{ 1261, "Latvia (Republic of)" },
	{ 1262, "Netherlands (Kingdom of the)" },
	{ 1263, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1264, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1265, "Ireland" },
	{ 1266, "Ukraine" },
	{ 1267, "Hungary" },
	{ 1268, "Germany (Federal Republic of)" },
	{ 1269, "Greece" },
	{ 1270, "Germany (Federal Republic of)" },
	{ 1271, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1272, "Serbia (Republic of)" },
	{ 1273, "Croatia (Republic of)" },
	{ 1274, "Poland (Republic of)" },
	{ 1275, "Slovak Republic" },
	{ 1276, "Romania" },
	{ 1277, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1278, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1279, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1280, "Unassigned" },
	{ 1281, "Malaysia" },
	{ 1282, "Malaysia" },
	{ 1283, "Malaysia" },
	{ 1284, "Malaysia" },
	{ 1285, "Malaysia" },
	{ 1286, "Malaysia" },
	{ 1287, "Malaysia" },
	{ 1288, "Malaysia" },
	{ 1289, "Malaysia" },
	{ 1290, "Australia" },
	{ 1291, "Australia" },
	{ 1292, "Australia" },
	{ 1293, "Australia" },
	{ 1294, "Australia" },
	{ 1295, "Australia" },
	{ 1296, "Australia" },
	{ 1297, "Australia" },
	{ 1298, "Australia" },
	{ 1299, "Australia" },
	{ 1300, "Indonesia (Republic of)" },
	{ 1301, "Indonesia (Republic of)" },
	{ 1302, "Indonesia (Republic of)" },
	{ 1303, "Indonesia (Republic of)" },
	{ 1304, "Indonesia (Republic of)" },
	{ 1305, "Indonesia (Republic of)" },
	{ 1306, "Unassigned" },
	{ 1307, "Unassigned" },
	{ 1308, "Unassigned" },
	{ 1309, "Unassigned" },
	{ 1310, "Philippines (Republic of the)" },
	{ 1311, "Philippines (Republic of the)" },
	{ 1312, "Philippines (Republic of the)" },
	{ 1313, "Philippines (Republic of the)" },
	{ 1314, "Philippines (Republic of the)" },
	{ 1315, "Philippines (Republic of the)" },
	{ 1316, "Philippines (Republic of the)" },
	{ 1317, "Philippines (Republic of the)" },
	{ 1318, "Philippines (Republic of the)" },
	{ 1319, "Thailand" },
	{ 1320, "Thailand" },
	{ 1321, "Thailand" },
	{ 1322, "Thailand" },
	{ 1323, "Thailand" },
	{ 1324, "Thailand" },
	{ 1325, "Singapore (Republic of)" },
	{ 1326, "Singapore (Republic of)" },
	{ 1327, "Singapore (Republic of)" },
	{ 1328, "Singapore (Republic of)" },
	{ 1329, "Singapore (Republic of)" },
	{ 1330, "Singapore (Republic of)" },
	{ 1331, "Singapore (Republic of)" },
	{ 1332, "Singapore (Republic of)" },
	{ 1333, "Singapore (Republic of)" },
	{ 1334, "Singapore (Republic of)" },
	{ 1335, "Singapore (Republic of)" },
	{ 1336, "Brunei Darussalam" },
	{ 1337, "Brunei Darussalam" },
	{ 1338, "Unassigned" },
	{ 1339, "Unassigned" },
	{ 1340, "New Zealand" },
	{ 1341, "New Zealand" },
	{ 1342, "New Zealand" },
	{ 1343, "New Zealand" },
	{ 1344, "Unassigned" },
	{ 1345, "New Zealand" },
	{ 1346, "Unassigned" },
	{ 1347, "New Zealand" },
	{ 1348, "Unassigned" },
	{ 1349, "Unassigned" },
	{ 1350, "Guam" },
	{ 1351, "Unassigned" },
	{ 1352, "Nauru (Republic of)" },
	{ 1353, "Unassigned" },
	{ 1354, "Papua New Guinea" },
	{ 1355, "Papua New Guinea" },
	{ 1356, "Unassigned" },
	{ 1357, "Unassigned" },
	{ 1358, "Tonga (Kingdom of)" },
	{ 1359, "Unassigned" },
	{ 1360, "Solomon Islands" },
	{ 1361, "Unassigned" },
	{ 1362, "Vanuatu (Republic of)" },
	{ 1363, "Unassigned" },
	{ 1364, "Fiji (Republic of)" },
	{ 1365, "Fiji (Republic of)" },
	{ 1366, "Wallis and Futuna (Territoire français d'outre-mer)" },
	{ 1367, "Unassigned" },
	{ 1368, "American Samoa" },
	{ 1369, "Unassigned" },
	{ 1370, "Niue" },
	{ 1371, "Unassigned" },
	{ 1372, "New Caledonia (Territoire français d'outre-mer)" },
	{ 1373, "Unassigned" },
	{ 1374, "French Polynesia (Territoire français d'outre-mer)" },
	{ 1375, "Unassigned" },
	{ 1376, "Cook Islands" },
	{ 1377, "Unassigned" },
	{ 1378, "Samoa (Independent State of)" },
	{ 1379, "Unassigned" },
	{ 1380, "Kiribati (Republic of)" },
	{ 1381, "Unassigned" },
	{ 1382, "Tuvalu" },
	{ 1383, "Unassigned" },
	{ 1384, "Unassigned" },
	{ 1385, "Marshall Islands (Republic of the)" },
	{ 1386, "Unassigned" },
	{ 1387, "Micronesia (Federated States of)" },
	{ 1388, "Unassigned" },
	{ 1389, "Unassigned" },
	{ 1390, "Palau (Republic of)" },
	{ 1391, "Unassigned" },
	{ 1392, "Unassigned" },
	{ 1393, "Northern Mariana Islands (Commonwealth of the)" },
	{ 1394, "Unassigned" },
	{ 1395, "Australia" },
	{ 1396, "Australia" },
	{ 1397, "Australia" },
	{ 1398, "Australia" },
	{ 1399, "Australia" },
	{ 1400, "Australia" },
	{ 1401, "Australia" },
	{ 1402, "Australia" },
	{ 1403, "Unassigned" },
	{ 1404, "Unassigned" },
	{ 1405, "Unassigned" },
	{ 1406, "Unassigned" },
	{ 1407, "Unassigned" },
	{ 1408, "Unassigned" },
	{ 1409, "Unassigned" },
	{ 1410, "Timor-Leste (Democratic Republic of)" },
	{ 1411, "Timor-Leste (Democratic Republic of)" },
	{ 1412, "Unassigned" },
	{ 1413, "Unassigned" },
	{ 1414, "Unassigned" },
	{ 1415, "Thailand" },
	{ 1416, "Unassigned" },
	{ 1417, "Unassigned" },
	{ 1418, "Unassigned" },
	{ 1419, "Unassigned" },
	{ 1420, "Singapore (Republic of)" },
	{ 1421, "Singapore (Republic of)" },
	{ 1422, "Singapore (Republic of)" },
	{ 1423, "Singapore (Republic of)" },
	{ 1424, "Singapore (Republic of)" },
	{ 1425, "Unassigned" },
	{ 1426, "Unassigned" },
	{ 1427, "Unassigned" },
	{ 1428, "Unassigned" },
	{ 1429, "Unassigned" },
	{ 1430, "Unassigned" },
	{ 1431, "Unassigned" },
	{ 1432, "Unassigned" },
	{ 1433, "Unassigned" },
	{ 1434, "Unassigned" },
	{ 1435, "Unassigned" },
	{ 1436, "Unassigned" },
	{ 1437, "Unassigned" },
	{ 1438, "Unassigned" },
	{ 1439, "Unassigned" },
	{ 1440, "Unassigned" },
	{ 1441, "Unassigned" },
	{ 1442, "Unassigned" },
	{ 1443, "Unassigned" },
	{ 1444, "Unassigned" },
	{ 1445, "Unassigned" },
	{ 1446, "Unassigned" },
	{ 1447, "Unassigned" },
	{ 1448, "Unassigned" },
	{ 1449, "Unassigned" },
	{ 1450, "Unassigned" },
	{ 1451, "Unassigned" },
	{ 1452, "Unassigned" },
	{ 1453, "Unassigned" },
	{ 1454, "Unassigned" },
	{ 1455, "Unassigned" },
	{ 1456, "Unassigned" },
	{ 1457, "Unassigned" },
	{ 1458, "Unassigned" },
	{ 1459, "Unassigned" },
	{ 1460, "Unassigned" },
	{ 1461, "Unassigned" },
	{ 1462, "Unassigned" },
	{ 1463, "Unassigned" },
	{ 1464, "Unassigned" },
	{ 1465, "Unassigned" },
	{ 1466, "Unassigned" },
	{ 1467, "Unassigned" },
	{ 1468, "Unassigned" },
	{ 1469, "Unassigned" },
	{ 1470, "Unassigned" },
	{ 1471, "Unassigned" },
	{ 1472, "Unassigned" },
	{ 1473, "Unassigned" },
	{ 1474, "Unassigned" },
	{ 1475, "Unassigned" },
	{ 1476, "Unassigned" },
	{ 1477, "Unassigned" },
	{ 1478, "Unassigned" },
	{ 1479, "Unassigned" },
	{ 1480, "Unassigned" },
	{ 1481, "Unassigned" },
	{ 1482, "Unassigned" },
	{ 1483, "Unassigned" },
	{ 1484, "Unassigned" },
	{ 1485, "Unassigned" },
	{ 1486, "Unassigned" },
	{ 1487, "Unassigned" },
	{ 1488, "Unassigned" },
	{ 1489, "Unassigned" },
	{ 1490, "Unassigned" },
	{ 1491, "Unassigned" },
	{ 1492, "Unassigned" },
	{ 1493, "Unassigned" },
	{ 1494, "Unassigned" },
	{ 1495, "Cyprus (Republic of)" },
	{ 1496, "Ireland" },
	{ 1497, "Bulgaria (Republic of)" },
	{ 1498, "Hungary" },
	{ 1499, "Unassigned" },
	{ 1500, "The Former Yugoslav Republic of Macedonia" },
	{ 1501, "The Former Yugoslav Republic of Macedonia" },
	{ 1502, "Unassigned" },
	{ 1503, "Unassigned" },
	{ 1504, "Unassigned" },
	{ 1505, "Italy" },
	{ 1506, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1507, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1508, "Ireland" },
	{ 1509, "Poland (Republic of)" },
	{ 1510, "Estonia (Republic of)" },
	{ 1511, "The Former Yugoslav Republic of Macedonia" },
	{ 1512, "Croatia (Republic of)" },
	{ 1513, "Georgia" },
	{ 1514, "Armenia (Republic of)" },
	{ 1515, "Malta" },
	{ 1516, "Greece" },
	{ 1517, "Cyprus (Republic of)" },
	{ 1518, "Montenegro" },
	{ 1519, "Netherlands (Kingdom of the)" },
	{ 1520, "Germany (Federal Republic of)" },
	{ 1521, "Turkey" },
	{ 1522, "Romania" },
	{ 1523, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1524, "Italy" },
	{ 1525, "Germany (Federal Republic of)" },
	{ 1526, "Switzerland (Confederation of)" },
	{ 1527, "Slovenia (Republic of)" },
	{ 1528, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1529, "Latvia (Republic of)" },
	{ 1530, "Slovenia (Republic of)" },
	{ 1531, "Germany (Federal Republic of)" },
	{ 1532, "Latvia (Republic of)" },
	{ 1533, "Poland (Republic of)" },
	{ 1534, "Greece" },
	{ 1535, "Italy" },
	{ 1536, "Unassigned" },
	{ 1537, "Unassigned" },
	{ 1538, "Unassigned" },
	{ 1539, "Egypt (Arab Republic of)" },
	{ 1540, "Egypt (Arab Republic of)" },
	{ 1541, "Egypt (Arab Republic of)" },
	{ 1542, "Algeria (People's Democratic Republic of)" },
	{ 1543, "Algeria (People's Democratic Republic of)" },
	{ 1544, "Morocco (Kingdom of)" },
	{ 1545, "Morocco (Kingdom of)" },
	{ 1546, "Tunisia" },
	{ 1547, "Libya" },
	{ 1548, "Libya" },
	{ 1549, "Libya" },
	{ 1550, "Gambia (Republic of the)" },
	{ 1551, "Gambia (Republic of the)" },
	{ 1552, "Senegal (Republic of)" },
	{ 1553, "Senegal (Republic of)" },
	{ 1554, "Mauritania (Islamic Republic of)" },
	{ 1555, "Mauritania (Islamic Republic of)" },
	{ 1556, "Mali (Republic of)" },
	{ 1557, "Guinea (Republic of)" },
	{ 1558, "Guinea (Republic of)" },
	{ 1559, "Guinea (Republic of)" },
	{ 1560, "Côte d'Ivoire (Republic of)" },
	{ 1561, "Côte d'Ivoire (Republic of)" },
	{ 1562, "Burkina Faso" },
	{ 1563, "Unassigned" },
	{ 1564, "Niger (Republic of the)" },
	{ 1565, "Niger (Republic of the)" },
	{ 1566, "Togolese Republic" },
	{ 1567, "Benin (Republic of)" },
	{ 1568, "Benin (Republic of)" },
	{ 1569, "Mauritius (Republic of)" },
	{ 1570, "Mauritius (Republic of)" },
	{ 1571, "Mauritius (Republic of)" },
	{ 1572, "Liberia (Republic of)" },
	{ 1573, "Unassigned" },
	{ 1574, "Sierra Leone" },
	{ 1575, "Sierra Leone" },
	{ 1576, "Ghana" },
	{ 1577, "Nigeria (Federal Republic of)" },
	{ 1578, "Nigeria (Federal Republic of)" },
	{ 1579, "Nigeria (Federal Republic of)" },
	{ 1580, "Chad (Republic of)" },
	{ 1581, "Unassigned" },
	{ 1582, "Central African Republic" },
	{ 1583, "Central African Republic" },
	{ 1584, "Cameroon (Republic of)" },
	{ 1585, "Cameroon (Republic of)" },
	{ 1586, "Cabo Verde (Republic of)" },
	{ 1587, "Cabo Verde (Republic of)" },
	{ 1588, "Sao Tome and Principe (Democratic Republic of)" },
	{ 1589, "Unassigned" },
	{ 1590, "Equatorial Guinea (Republic of)" },
	{ 1591, "Gabonese Republic" },
	{ 1592, "Gabonese Republic" },
	{ 1593, "Gabonese Republic" },
	{ 1594, "Congo (Republic of the)" },
	{ 1595, "Democratic Republic of the Congo" },
	{ 1596, "Democratic Republic of the Congo" },
	{ 1597, "Democratic Republic of the Congo" },
	{ 1598, "Angola (Republic of)" },
	{ 1599, "Angola (Republic of)" },
	{ 1600, "Guinea-Bissau (Republic of)" },
	{ 1601, "Unassigned" },
	{ 1602, "Seychelles (Republic of)" },
	{ 1603, "Seychelles (Republic of)" },
	{ 1604, "Sudan (Republic of the)" },
	{ 1605, "Sudan (Republic of the)" },
	{ 1606, "Rwanda (Republic of)" },
	{ 1607, "Rwanda (Republic of)" },
	{ 1608, "Ethiopia (Federal Democratic Republic of)" },
	{ 1609, "Rwanda (Republic of)" },
	{ 1610, "Somalia (Federal Republic of)" },
	{ 1611, "Unassigned" },
	{ 1612, "Djibouti (Republic of)" },
	{ 1613, "Rwanda (Republic of)" },
	{ 1614, "Kenya (Republic of)" },
	{ 1615, "Kenya (Republic of)" },
	{ 1616, "Tanzania (United Republic of)" },
	{ 1617, "Tanzania (United Republic of)" },
	{ 1618, "Uganda (Republic of)" },
	{ 1619, "Uganda (Republic of)" },
	{ 1620, "Burundi (Republic of)" },
	{ 1621, "Burundi (Republic of)" },
	{ 1622, "Mozambique (Republic of)" },
	{ 1623, "Mozambique (Republic of)" },
	{ 1624, "Congo (Republic of the)" },
	{ 1625, "Congo (Republic of the)" },
	{ 1626, "Zambia (Republic of)" },
	{ 1627, "Unassigned" },
	{ 1628, "Madagascar (Republic of)" },
	{ 1629, "Madagascar (Republic of)" },
	{ 1630, "French Departments and Territories in the Indian Ocean" },
	{ 1631, "Zimbabwe (Republic of)" },
	{ 1632, "Zimbabwe (Republic of)" },
	{ 1633, "Zimbabwe (Republic of)" },
	{ 1634, "Namibia (Republic of)" },
	{ 1635, "Namibia (Republic of)" },
	{ 1636, "Malawi" },
	{ 1637, "Unassigned" },
	{ 1638, "Lesotho (Kingdom of)" },
	{ 1639, "Unassigned" },
	{ 1640, "Botswana (Republic of)" },
	{ 1641, "Botswana (Republic of)" },
	{ 1642, "Swaziland (Kingdom of)" },
	{ 1643, "Unassigned" },
	{ 1644, "Comoros (Union of the)" },
	{ 1645, "South Africa (Republic of)" },
	{ 1646, "South Africa (Republic of)" },
	{ 1647, "South Africa (Republic of)" },
	{ 1648, "South Africa (Republic of)" },
	{ 1649, "South Africa (Republic of)" },
	{ 1650, "Eritrea" },
	{ 1651, "Unassigned" },
	{ 1652, "Saint Helena, Ascension and Tristan da Cunha" },
	{ 1653, "Unassigned" },
	{ 1654, "French Departments and Territories in the Indian Ocean" },
	{ 1655, "Unassigned" },
	{ 1656, "Diego Garcia" },
	{ 1657, "Unassigned" },
	{ 1658, "Unassigned" },
	{ 1659, "Tanzania (United Republic of)" },
	{ 1660, "Unassigned" },
	{ 1661, "Unassigned" },
	{ 1662, "Unassigned" },
	{ 1663, "Unassigned" },
	{ 1664, "Unassigned" },
	{ 1665, "Unassigned" },
	{ 1666, "Uganda (Republic of)" },
	{ 1667, "Uganda (Republic of)" },
	{ 1668, "Uganda (Republic of)" },
	{ 1669, "Unassigned" },
	{ 1670, "Unassigned" },
	{ 1671, "Nigeria (Federal Republic of)" },
	{ 1672, "Unassigned" },
	{ 1673, "Unassigned" },
	{ 1674, "Unassigned" },
	{ 1675, "Unassigned" },
	{ 1676, "Angola (Republic of)" },
	{ 1677, "Unassigned" },
	{ 1678, "Unassigned" },
	{ 1679, "Unassigned" },
	{ 1680, "Unassigned" },
	{ 1681, "South Africa (Republic of)" },
	{ 1682, "Unassigned" },
	{ 1683, "Unassigned" },
	{ 1684, "Unassigned" },
	{ 1685, "Unassigned" },
	{ 1686, "Morocco (Kingdom of)" },
	{ 1687, "Unassigned" },
	{ 1688, "Unassigned" },
	{ 1689, "Unassigned" },
	{ 1690, "Unassigned" },
	{ 1691, "Unassigned" },
	{ 1692, "Unassigned" },
	{ 1693, "Unassigned" },
	{ 1694, "Unassigned" },
	{ 1695, "Unassigned" },
	{ 1696, "Ghana" },
	{ 1697, "Unassigned" },
	{ 1698, "Unassigned" },
	{ 1699, "Unassigned" },
	{ 1700, "Unassigned" },
	{ 1701, "Unassigned" },
	{ 1702, "Unassigned" },
	{ 1703, "Unassigned" },
	{ 1704, "Cameroon (Republic of)" },
	{ 1705, "Unassigned" },
	{ 1706, "Sudan (Republic of the)" },
	{ 1707, "Unassigned" },
	{ 1708, "Unassigned" },
	{ 1709, "South Sudan (Republic of)" },
	{ 1710, "South Sudan (Republic of)" },
	{ 1711, "Equatorial Guinea (Republic of)" },
	{ 1712, "Equatorial Guinea (Republic of)" },
	{ 1713, "Cameroon (Republic of)" },
	{ 1714, "Democratic Republic of the Congo" },
	{ 1715, "Democratic Republic of the Congo" },
	{ 1716, "Algeria (People's Democratic Republic of)" },
	{ 1717, "Unassigned" },
	{ 1718, "Unassigned" },
	{ 1719, "Mali (Republic of)" },
	{ 1720, "Unassigned" },
	{ 1721, "Unassigned" },
	{ 1722, "Unassigned" },
	{ 1723, "Unassigned" },
	{ 1724, "Unassigned" },
	{ 1725, "Unassigned" },
	{ 1726, "Unassigned" },
	{ 1727, "Unassigned" },
	{ 1728, "Unassigned" },
	{ 1729, "Unassigned" },
	{ 1730, "Unassigned" },
	{ 1731, "Unassigned" },
	{ 1732, "Unassigned" },
	{ 1733, "Unassigned" },
	{ 1734, "Unassigned" },
	{ 1735, "Unassigned" },
	{ 1736, "Unassigned" },
	{ 1737, "Unassigned" },
	{ 1738, "Unassigned" },
	{ 1739, "Unassigned" },
	{ 1740, "Unassigned" },
	{ 1741, "Unassigned" },
	{ 1742, "Unassigned" },
	{ 1743, "Unassigned" },
	{ 1744, "Unassigned" },
	{ 1745, "Unassigned" },
	{ 1746, "Unassigned" },
	{ 1747, "Unassigned" },
	{ 1748, "Unassigned" },
	{ 1749, "Unassigned" },
	{ 1750, "Unassigned" },
	{ 1751, "Unassigned" },
	{ 1752, "Unassigned" },
	{ 1753, "Unassigned" },
	{ 1754, "Unassigned" },
	{ 1755, "Unassigned" },
	{ 1756, "The Former Yugoslav Republic of Macedonia" },
	{ 1757, "The Former Yugoslav Republic of Macedonia" },
	{ 1758, "Unassigned" },
	{ 1759, "Unassigned" },
	{ 1760, "Armenia (Republic of)" },
	{ 1761, "Ireland" },
	{ 1762, "Sweden" },
	{ 1763, "Estonia (Republic of)" },
	{ 1764, "Lithuania (Republic of)" },
	{ 1765, "Sweden" },
	{ 1766, "Sweden" },
	{ 1767, "Cyprus (Republic of)" },
	{ 1768, "Sweden" },
	{ 1769, "France" },
	{ 1770, "Czech Republic" },
	{ 1771, "Slovenia (Republic of)" },
	{ 1772, "Poland (Republic of)" },
	{ 1773, "Germany (Federal Republic of)" },
	{ 1774, "Sweden" },
	{ 1775, "Bulgaria (Republic of)" },
	{ 1776, "Monaco (Principality of)" },
	{ 1777, "Ukraine" },
	{ 1778, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1779, "Iceland" },
	{ 1780, "Spain" },
	{ 1781, "Italy" },
	{ 1782, "Ireland" },
	{ 1783, "Bulgaria (Republic of)" },
	{ 1784, "Latvia (Republic of)" },
	{ 1785, "Netherlands (Kingdom of the)" },
	{ 1786, "Bulgaria (Republic of)" },
	{ 1787, "Hungary" },
	{ 1788, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1789, "Slovenia (Republic of)" },
	{ 1790, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1791, "United Kingdom of Great Britain and Northern Ireland" },
	{ 1792, "Unassigned" },
	{ 1793, "Unassigned" },
	{ 1794, "Unassigned" },
	{ 1795, "Unassigned" },
	{ 1796, "Belize" },
	{ 1797, "Belize" },
	{ 1798, "Unassigned" },
	{ 1799, "Unassigned" },
	{ 1800, "Guatemala (Republic of)" },
	{ 1801, "Guatemala (Republic of)" },
	{ 1802, "Guatemala (Republic of)" },
	{ 1803, "Unassigned" },
	{ 1804, "El Salvador (Republic of)" },
	{ 1805, "El Salvador (Republic of)" },
	{ 1806, "El Salvador (Republic of)" },
	{ 1807, "El Salvador (Republic of)" },
	{ 1808, "Honduras (Republic of)" },
	{ 1809, "Honduras (Republic of)" },
	{ 1810, "Honduras (Republic of)" },
	{ 1811, "Unassigned" },
	{ 1812, "Nicaragua" },
	{ 1813, "Nicaragua" },
	{ 1814, "Unassigned" },
	{ 1815, "Costa Rica" },
	{ 1816, "Costa Rica" },
	{ 1817, "Costa Rica" },
	{ 1818, "Panama (Republic of)" },
	{ 1819, "Panama (Republic of)" },
	{ 1820, "Panama (Republic of)" },
	{ 1821, "Panama (Republic of)" },
	{ 1822, "Panama (Republic of)" },
	{ 1823, "Panama (Republic of)" },
	{ 1824, "Peru" },
	{ 1825, "Peru" },
	{ 1826, "Peru" },
	{ 1827, "Peru" },
	{ 1828, "Peru" },
	{ 1829, "Peru" },
	{ 1830, "Peru" },
	{ 1831, "Peru" },
	{ 1832, "Argentine Republic" },
	{ 1833, "Argentine Republic" },
	{ 1834, "Argentine Republic" },
	{ 1835, "Argentine Republic" },
	{ 1836, "Argentine Republic" },
	{ 1837, "Argentine Republic" },
	{ 1838, "Argentine Republic" },
	{ 1839, "Argentine Republic" },
	{ 1840, "Brazil (Federative Republic of)" },
	{ 1841, "Brazil (Federative Republic of)" },
	{ 1842, "Brazil (Federative Republic of)" },
	{ 1843, "Brazil (Federative Republic of)" },
	{ 1844, "Brazil (Federative Republic of)" },
	{ 1845, "Brazil (Federative Republic of)" },
	{ 1846, "Brazil (Federative Republic of)" },
	{ 1847, "Brazil (Federative Republic of)" },
	{ 1848, "Brazil (Federative Republic of)" },
	{ 1849, "Brazil (Federative Republic of)" },
	{ 1850, "Unassigned" },
	{ 1851, "Chile" },
	{ 1852, "Chile" },
	{ 1853, "Chile" },
	{ 1854, "Chile" },
	{ 1855, "Chile" },
	{ 1856, "Colombia (Republic of)" },
	{ 1857, "Colombia (Republic of)" },
	{ 1858, "Colombia (Republic of)" },
	{ 1859, "Colombia (Republic of)" },
	{ 1860, "Venezuela (Bolivarian Republic of)" },
	{ 1861, "Venezuela (Bolivarian Republic of)" },
	{ 1862, "Venezuela (Bolivarian Republic of)" },
	{ 1863, "Venezuela (Bolivarian Republic of)" },
	{ 1864, "Bolivia (Plurinational State of)" },
	{ 1865, "Bolivia (Plurinational State of)" },
	{ 1866, "Bolivia (Plurinational State of)" },
	{ 1867, "Bolivia (Plurinational State of)" },
	{ 1868, "Guyana" },
	{ 1869, "Guyana" },
	{ 1870, "Unassigned" },
	{ 1871, "Unassigned" },
	{ 1872, "Ecuador" },
	{ 1873, "Ecuador" },
	{ 1874, "Ecuador" },
	{ 1875, "Unassigned" },
	{ 1876, "French Guiana (French Department of)" },
	{ 1877, "Unassigned" },
	{ 1878, "Unassigned" },
	{ 1879, "Unassigned" },
	{ 1880, "Paraguay (Republic of)" },
	{ 1881, "Paraguay (Republic of)" },
	{ 1882, "Paraguay (Republic of)" },
	{ 1883, "Unassigned" },
	{ 1884, "Suriname (Republic of)" },
	{ 1885, "Suriname (Republic of)" },
	{ 1886, "Unassigned" },
	{ 1887, "Unassigned" },
	{ 1888, "Uruguay (Eastern Republic of)" },
	{ 1889, "Uruguay (Eastern Republic of)" },
	{ 1890, "Unassigned" },
	{ 1891, "Falkland Islands (Malvinas)" },
	{ 1892, "Venezuela (Bolivarian Republic of)" },
	{ 1893, "Unassigned" },
	{ 1894, "Unassigned" },
	{ 1895, "Unassigned" },
	{ 1896, "Unassigned" },
	{ 1897, "Unassigned" },
	{ 1898, "Unassigned" },
	{ 1899, "Unassigned" },
	{ 1900, "Unassigned" },
	{ 1901, "Unassigned" },
	{ 1902, "Colombia (Republic of)" },
	{ 1903, "Unassigned" },
	{ 1904, "Unassigned" },
	{ 1905, "Unassigned" },
	{ 1906, "Unassigned" },
	{ 1907, "Unassigned" },
	{ 1908, "Unassigned" },
	{ 1909, "Unassigned" },
	{ 1910, "Unassigned" },
	{ 1911, "Unassigned" },
	{ 1912, "Unassigned" },
	{ 1913, "Unassigned" },
	{ 1914, "Unassigned" },
	{ 1915, "Unassigned" },
	{ 1916, "Unassigned" },
	{ 1917, "Unassigned" },
	{ 1918, "Unassigned" },
	{ 1919, "Unassigned" },
	{ 1920, "Unassigned" },
	{ 1921, "Unassigned" },
	{ 1922, "Unassigned" },
	{ 1923, "Unassigned" },
	{ 1924, "Unassigned" },
	{ 1925, "Unassigned" },
	{ 1926, "Unassigned" },
	{ 1927, "Unassigned" },
	{ 1928, "Unassigned" },
	{ 1929, "Unassigned" },
	{ 1930, "Unassigned" },
	{ 1931, "Unassigned" },
	{ 1932, "Unassigned" },
	{ 1933, "Unassigned" },
	{ 1934, "Unassigned" },
	{ 1935, "Unassigned" },
	{ 1936, "Unassigned" },
	{ 1937, "Unassigned" },
	{ 1938, "Unassigned" },
	{ 1939, "Unassigned" },
	{ 1940, "Unassigned" },
	{ 1941, "Unassigned" },
	{ 1942, "Bolivia (Plurinational State of)" },
	{ 1943, "Bolivia (Plurinational State of)" },
	{ 1944, "Bolivia (Plurinational State of)" },
	{ 1945, "Bolivia (Plurinational State of)" },
	{ 1946, "Unassigned" },
	{ 1947, "Unassigned" },
	{ 1948, "Unassigned" },
	{ 1949, "Unassigned" },
	{ 1950, "Unassigned" },
	{ 1951, "Unassigned" },
	{ 1952, "Peru" },
	{ 1953, "Peru" },
	{ 1954, "Unassigned" },
	{ 1955, "Unassigned" },
	{ 1956, "Unassigned" },
	{ 1957, "Unassigned" },
	{ 1958, "Unassigned" },
	{ 1959, "Unassigned" },
	{ 1960, "Unassigned" },
	{ 1961, "Unassigned" },
	{ 1962, "Unassigned" },
	{ 1963, "Unassigned" },
	{ 1964, "Unassigned" },
	{ 1965, "Unassigned" },
	{ 1966, "Unassigned" },
	{ 1967, "Unassigned" },
	{ 1968, "Unassigned" },
	{ 1969, "Unassigned" },
	{ 1970, "Unassigned" },
	{ 1971, "Unassigned" },
	{ 1972, "Unassigned" },
	{ 1973, "Unassigned" },
	{ 1974, "Unassigned" },
	{ 1975, "Unassigned" },
	{ 1976, "Unassigned" },
	{ 1977, "Unassigned" },
	{ 1978, "Unassigned" },
	{ 1979, "Unassigned" },
	{ 1980, "Unassigned" },
	{ 1981, "Unassigned" },
	{ 1982, "Unassigned" },
	{ 1983, "Unassigned" },
	{ 1984, "Unassigned" },
	{ 1985, "Unassigned" },
	{ 1986, "Unassigned" },
	{ 1987, "Unassigned" },
	{ 1988, "Unassigned" },
	{ 1989, "Unassigned" },
	{ 1990, "Unassigned" },
	{ 1991, "Unassigned" },
	{ 1992, "Unassigned" },
	{ 1993, "Unassigned" },
	{ 1994, "Unassigned" },
	{ 1995, "Netherlands (Kingdom of the)" },
	{ 1996, "Unassigned" },
	{ 1997, "Luxembourg" },
	{ 1998, "Poland (Republic of)" },
	{ 1999, "Sweden" },
	{ 2000, "Unassigned" },
	{ 2001, "Unassigned" },
	{ 2002, "Liechtenstein (Principality of)" },
	{ 2003, "Unassigned" },
	{ 2004, "Unassigned" },
	{ 2005, "Kosovo*" },
	{ 2006, "Kosovo*" },
	{ 2007, "Croatia (Republic of)" },
	{ 2008, "Colombia (Republic of)" },
	{ 2009, "Norway" },
	{ 2010, "Romania" },
	{ 2011, "Albania (Republic of)" },
	{ 2012, "Luxembourg" },
	{ 2013, "Bulgaria (Republic of)" },
	{ 2014, "Malta" },
	{ 2015, "France" },
	{ 2016, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2017, "Netherlands (Kingdom of the)" },
	{ 2018, "Greece" },
	{ 2019, "Serbia (Republic of)" },
	{ 2020, "Switzerland (Confederation of)" },
	{ 2021, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2022, "Lithuania (Republic of)" },
	{ 2023, "Norway" },
	{ 2024, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2025, "Bosnia and Herzegovina" },
	{ 2026, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2027, "Croatia (Republic of)" },
	{ 2028, "Spain" },
	{ 2029, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2030, "France" },
	{ 2031, "Slovak Republic" },
	{ 2032, "Norway" },
	{ 2033, "Spain" },
	{ 2034, "Ukraine" },
	{ 2035, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2036, "Poland (Republic of)" },
	{ 2037, "Latvia (Republic of)" },
	{ 2038, "Poland (Republic of)" },
	{ 2039, "Switzerland (Confederation of)" },
	{ 2040, "Romania" },
	{ 2041, "Germany (Federal Republic of)" },
	{ 2042, "Latvia (Republic of)" },
	{ 2043, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2044, "Lithuania (Republic of)" },
	{ 2045, "United Kingdom of Great Britain and Northern Ireland" },
	{ 2046, "Spain" },
	{ 2047, "Liechtenstein (Principality of)" },
	{  0, NULL }
};

/*
 * List of International Signalling Point Codes (ISPC)
 * Annex to ITU Operational Bulletin No. 1199 - 1.VII.2020
 *
 * Mapping of ISPC to Unique name of the signalling point
 */
static const value_string q708_ispc_point_name[] = {
	{  4096, "TLI Vaduz" },
	{  4097, "TLI Eschen" },
	{  4099, "TLI Mauren 01" },
	{  4100, "TLI Mauren 02" },
	{  4101, "iMetrik STP 01" },
	{  4102, "Orange Balzers GMSC" },
	{  4103, "iMetrik STP 02" },
	{  4104, "Roma/via T. Mestrelli" },
	{  4105, "Milano/via A.De Gaspari S. Donato Milanese" },
	{  4106, "Trento/via Gilli 2" },
	{  4107, "Roma/Via Di Torre Spaccata, 172" },
	{  4108, "Milano/Via A. De Gasperi S. Donato Milanese" },
	{  4109, "Firenze/via Italo Piccagli 24" },
	{  4110, "Milano/Via Caldera, 21" },
	{  4111, "Roma/via G. Donizetti 7" },
	{  4112, "ROTSTP, Rotterdam, Abraham v" },
	{  4113, "AM1STP01/AM1STP02, Schiphol-Rijk" },
	{  4114, "Eric1, Cessnalaan 1-33, Sch" },
	{  4115, "HIGHNL001, Rotterdam, Vollenhov" },
	{  4116, "Ams ss 701, Amsterdam" },
	{  4117, "(MSC) GSM-R, Den Haag" },
	{  4118, "NL MSC 1, Kabelweg 51" },
	{  4119, "AsdSTP5, Amsterdam" },
	{  4120, "Genova/via De Marini 1- Torre WTC" },
	{  4121, "Milano/Via Caracciolo, 51" },
	{  4122, "Torino/via Cristoforo Colombo 24" },
	{  4123, "Mialno\\Via Caldera, 21" },
	{  4124, "Cagliari/via Efisio Melis 26 - TICA1" },
	{  4125, "Vía Tucidide 56 - Milano" },
	{  4126, "Vía Alcide De Gasperi, 2 San Donato Milanese" },
	{  4127, "Milano/Via Caldera, 21 - c\\o Netscalibur" },
	{  4128, "Athens/KT" },
	{  4130, "Athens/NMA" },
	{  4131, "Thessaloniki/ERM" },
	{  4132, "Athens. L. Athinon TAH1, international" },
	{  4133, "Pireos TSC-S (for roaming functionality) (TSAPS_ SPX2)" },
	{  4134, "Athens Rentis : HISREN1" },
	{  4135, "Pallini TSC-S (for roaming functionality) (TSAPI_ SPX2)" },
	{  4136, "Cosmoline Athens isc/1" },
	{  4137, "Wind Hellas Fixed Network -TATN02" },
	{  4138, "FORTHnet/Athens/1" },
	{  4139, "Athens, N. Philadelphia TAH2, international" },
	{  4140, "Reserved for future use" },
	{  4141, "Reserved for future use" },
	{  4142, "Athens Alexandra : HISALE1" },
	{  4143, "4GBS ATHENS-1" },
	{  4144, "COLT ASD MAD EX1, Amsterdam" },
	{  4145, "Verizon Belgium, Brussel Rue de la Sc" },
	{  4146, "Solaris Systems B.V., Amsterdam ZO" },
	{  4147, "C1/AMS, Amsterdam" },
	{  4148, "ISTP no. 2, Schiphol-Rijk" },
	{  4149, "ROTMSC 01, Rotterdam" },
	{  4150, "KPN B.V., Den Haag" },
	{  4151, "Amsterdam" },
	{  4152, "Tele 2 Amsterdam, Amsterdam" },
	{  4153, "AMS-1, 1061HE 4 Amsterdam" },
	{  4154, "IXT 1A, Amsterdam" },
	{  4155, "Versatel-1, Amsterdam" },
	{  4156, "NL MSC 2, Cessnalaan Schiphol-Rijk" },
	{  4157, "AMS MSC1, Amsterdam" },
	{  4158, "EHVMSC1, Eindhoven" },
	{  4159, "ISTP no 1, Rotterdam" },
	{  4160, "NLBZ01T/2010815, Schiphol-Rijk" },
	{  4161, "Asd 2H, Amsterdam" },
	{  4162, "Rt 2D, Rotterdam" },
	{  4163, "Rt 1D, Rotterdam" },
	{  4164, "ZWL, Zwolle" },
	{  4165, "SGRMS01, Den Haag" },
	{  4166, "ASDSSP3, Amsterdam" },
	{  4167, "Asd 2P, Amsterdam" },
	{  4168, "Asd STP2, Amsterdam" },
	{  4169, "Rt STP2, Rotterdam" },
	{  4170, "RT 1P, Rotterdam" },
	{  4171, "GVOIP 2, AMSIX Arena 1066VH AMST" },
	{  4172, "MSTP GV, Den Haag" },
	{  4173, "MSTP EHV, Eindhoven" },
	{  4174, "ASD 2 GW, Amsterdam" },
	{  4175, "RT 2N, Rotterdam" },
	{  4176, "TISMI, 1062HE 4 Amsterdam" },
	{  4177, "Hilf_ISPC1, Amsterdam" },
	{  4178, "RM STP1, Rotterdam" },
	{  4179, "EN STP1, Son" },
	{  4180, "Cisco ITP, Laarderhoogtweg 57 , Amsterdam" },
	{  4181, "VT-SSP, Schiphol-Rijk" },
	{  4182, "Amsterdam 1, Amsterdam" },
	{  4183, "VIS Vas PLATFORM, Equinix AM3, Science Park" },
	{  4184, "Telfort ASD, Amsterdam" },
	{  4185, "Telfort RT, Rotterdam" },
	{  4186, "ROT MSC1, Rotterdam" },
	{  4187, "G1 STP-B, Schiphol-Rijk" },
	{  4188, "AMS 03, Schiphol-Rijk" },
	{  4189, "ROT1/0-4189, Rotterdam" },
	{  4190, "Amsterdam" },
	{  4191, "Esprit Telecom, Amsterdam" },
	{  4193, "Bruxelles/F" },
	{  4194, "Bruxelles/G" },
	{  4195, "Liège/C" },
	{  4197, "Orange 4" },
	{  4199, "Antwerpen/E" },
	{  4200, "" },
	{  4201, "Bruxelles A/STP" },
	{  4202, "Antwerpen" },
	{  4203, "" },
	{  4204, "" },
	{  4205, "" },
	{  4208, "Bruxelles L/STP" },
	{  4209, "Brussels, Evere" },
	{  4210, "Unleashed 1" },
	{  4211, "Unleashed 2" },
	{  4212, "T2 Antwerpen 1" },
	{  4213, "IPNexia 1" },
	{  4215, "Bruxelles B/STP" },
	{  4216, "Bruxelles M/STP" },
	{  4217, "Zaventem" },
	{  4218, "AFRK/Gosselies" },
	{  4219, "TELENET - STP Hoboken" },
	{  4220, "TELENET - STP Gent" },
	{  4222, "BMSCA/Brussel-N" },
	{  4223, "Globaltouch" },
	{  4224, "Sewan Communications - Courbevoie" },
	{  4225, "SFR - Paris 3" },
	{  4226, "Orange -Paris Pastourelle - NP Hub" },
	{  4227, "Orange - Paris Pastourelle - CTI Pastourelle" },
	{  4228, "Free Mobile - POP Paris Courbevoie 1" },
	{  4229, "SFR- Vélizy 3" },
	{  4230, "Free Mobile - POP Paris Courbevoie 2" },
	{  4231, "Orange - Paris Archives - PTS No1" },
	{  4232, "SFR - Vélizy 4" },
	{  4233, "Vérizon France – Saint Denis" },
	{  4235, "Wavecrest - Boulogne 1" },
	{  4236, "SFR - XA20 - Nanterre" },
	{  4237, "SFR - XA22 - Lyon" },
	{  4238, "SFR - Vélizy 2" },
	{  4239, "SFR- Lyon 4" },
	{  4240, "Orange - Paris Archives - Cisco ITP 1" },
	{  4241, "Bouygues Telecom 3" },
	{  4242, "Bouygues Telecom 4" },
	{  4243, "Completel - Mundolsheim" },
	{  4244, "Orange - Paris Archives - Cisco ITP 2" },
	{  4245, "SFR - XB95 - Puteaux" },
	{  4246, "Vue Tel – Saint Denis" },
	{  4247, "Orange - Reims - PTS No 2" },
	{  4248, "Free - XD54" },
	{  4249, "Orange - Paris Pastourelle - NGN PT 5" },
	{  4250, "Free - XD55" },
	{  4251, "Orange - Reims - NGN RS4" },
	{  4252, "Colt - XB03" },
	{  4253, "SFR - XD73 - Vénissieux" },
	{  4254, "Colt - XB04" },
	{  4255, "SFR - XB96 - Puteaux" },
	{  4256, "Free Mobile - POP Paris Courbevoie 3" },
	{  4257, "SFR - Nanterre" },
	{  4258, "Cable & Wireless 1" },
	{  4259, "Viatel 1" },
	{  4260, "Free Mobile - POP Marseille" },
	{  4261, "Orange - Paris Pastourelle - OTPTS" },
	{  4262, "Orange - Reims - International Gateway Point No 1" },
	{  4263, "Orange - Paris Archives – International Gateway Point No 2" },
	{  4264, "SFR Lyon" },
	{  4265, "SFR Int 1, interconnexion international" },
	{  4266, "SFR idf" },
	{  4267, "SFR Dijon 1, PTS/SSCS de Dijon" },
	{  4268, "Jet comm telecom – Paris 1" },
	{  4269, "Jet comm telecom – Paris 2" },
	{  4270, "BYT 1, BYT Plateforme roaming" },
	{  4271, "SFR - XC74 - Courbevoie" },
	{  4272, "Orange - Paris Archives - GLR1" },
	{  4273, "Colt Int 1, interconnexion international" },
	{  4274, "Equant France-Paris Neo POP" },
	{  4275, "SFR - XA30" },
	{  4276, "SFR - XA47" },
	{  4277, "SFR - XD00 - Paris" },
	{  4278, "SFR - XD19 - Palaiseau" },
	{  4279, "SFR - XA67 - Bordeaux" },
	{  4280, "Budget Telecom – Paris 2" },
	{  4281, "Colt - Malakoff" },
	{  4282, "BJT Partners – Paris 1" },
	{  4283, "SFR - XA21 - Palaiseau" },
	{  4284, "Viatel 2" },
	{  4285, "BJT Partners – Paris 2" },
	{  4286, "PSN 1" },
	{  4287, "Telecom Italia - POP Lille 1" },
	{  4288, "MT03" },
	{  4289, "MT01" },
	{  4290, "MT04" },
	{  4291, "PTS 1" },
	{  4292, "AXE Mednet" },
	{  4293, "Kosovo roaming" },
	{  4294, "PTS 2" },
	{  4295, "MC 5" },
	{  4296, "MSS_SA_A" },
	{  4301, "MSC01" },
	{  4302, "MSC02" },
	{  4304, "Wien" },
	{  4305, "Innsbruck" },
	{  4308, "Wien" },
	{  4309, "A1-ISPC-2-26-5" },
	{  4311, "A1-ISPC-2-26-7" },
	{  4312, "Madrid" },
	{  4313, "Madrid" },
	{  4314, "Zaragoza" },
	{  4315, "Barcelona" },
	{  4316, "Madrid" },
	{  4317, "" },
	{  4318, "" },
	{  4319, "Madrid" },
	{  4327, "Barcelona" },
	{  4328, "Sevilla" },
	{  4329, "Valencia" },
	{  4332, "" },
	{  4333, "" },
	{  4334, "Madrid" },
	{  4335, "Barcelona" },
	{  4336, "Madrid/Alcobendas – Jose Echegaray" },
	{  4337, "Madrid – Isabel Colbrand" },
	{  4342, "" },
	{  4343, "" },
	{  4344, "" },
	{  4345, "" },
	{  4347, "Madrid" },
	{  4348, "Madrid Norte" },
	{  4349, "Madrid Alias" },
	{  4351, "Barcelona" },
	{  4352, "Pannon INT2" },
	{  4354, "M1-MSC-PC2" },
	{  4358, "TTI INT 01" },
	{  4359, "Budapest BTH01" },
	{  4360, "Essen" },
	{  4361, "Berlin" },
	{  4362, "Frankfurt" },
	{  4363, "Düsseldorf" },
	{  4364, "Hamburg" },
	{  4365, "Haar" },
	{  4366, "Stuttgart" },
	{  4367, "Frankfurt" },
	{  4368, "Frankfurt" },
	{  4369, "Frankfurt" },
	{  4370, "München" },
	{  4371, "Eschborn" },
	{  4372, "Frankfurt" },
	{  4373, "Eschborn" },
	{  4374, "Stuttgart" },
	{  4375, "Frankfurt" },
	{  4376, "Frankfurt" },
	{  4377, "Hamburg" },
	{  4378, "Berlin" },
	{  4379, "Frankfurt" },
	{  4382, "Frankfurt" },
	{  4383, "Hamburg" },
	{  4384, "Ratingen" },
	{  4385, "Sulzbach" },
	{  4386, "Frankfurt" },
	{  4387, "Stuttgart" },
	{  4388, "Frankfurt" },
	{  4389, "FRA STP1" },
	{  4390, "Düsseldorf" },
	{  4391, "Frankfurt" },
	{  4392, "Frankfurt" },
	{  4393, "OVH DE Internat 1" },
	{  4394, "Frankfurt" },
	{  4395, "Frankfurt" },
	{  4396, "Frankfurt" },
	{  4397, "Leer" },
	{  4398, "Frankfurt" },
	{  4400, "Frankfurt" },
	{  4401, "Frankfurt" },
	{  4402, "Frankfurt" },
	{  4403, "Frankfurt" },
	{  4404, "Düsseldorf" },
	{  4405, "Frankfurt" },
	{  4406, "Frankfurt" },
	{  4407, "Düsseldorf" },
	{  4408, "Frankfurt" },
	{  4409, "Düsseldorf" },
	{  4410, "Frankfurt" },
	{  4411, "München" },
	{  4412, "Frankfurt" },
	{  4413, "Frankfurt" },
	{  4414, "Frankfurt" },
	{  4415, "Frankfurt" },
	{  4416, "Beograd/MN1" },
	{  4417, "Beograd/MN2" },
	{  4418, "" },
	{  4419, "Beograd/MN3" },
	{  4420, "" },
	{  4421, "" },
	{  4422, "Telenor Belgrade 2" },
	{  4423, "" },
	{  4424, "Milano/Via Viviani, 8 - DTM1" },
	{  4425, "Roma/via Ercolano Salvi 12" },
	{  4426, "Milano/via Caldera 21/F - TIMI1" },
	{  4427, "Firenze/Via Cironi, 32a" },
	{  4428, "Bologna/Via del Terrapieno, 46" },
	{  4429, "Massarosa (LU)/Via Montramito, 431a" },
	{  4430, "Via Caldera 21 - Milano" },
	{  4431, "Torino via Livorno 60" },
	{  4432, "Torino/via Issigno 62" },
	{  4433, "Milano/strada5, palazzo N, Fiori Rozzano" },
	{  4434, "Milano/Via Bensi 1/8 Liberty B - VOMI1" },
	{  4435, "Via Bellafino 35 - Bergamo" },
	{  4436, "Via Cornelia 498 - 00166 ROMA" },
	{  4437, "Via Caldera 71 - MILANO" },
	{  4438, "Torino/Corso Svizzera 185" },
	{  4439, "Bolzano/via Lungo Isarco Sinistro" },
	{  4440, "Milano/Via Caldera, 21" },
	{  4441, "Lucca viale Puccini,134" },
	{  4442, "Milano - via F.lli Rosselli 68" },
	{  4443, "Firenze\\Via Quintino Sella, 36" },
	{  4444, "via Montramito 431 Massarosa" },
	{  4445, "Bolzano via Pacinotti 12" },
	{  4446, "via E Giannesi 14 Montacchillo" },
	{  4447, "MILANO VIA LANCETTI - PMMI1" },
	{  4448, "Roma/1240 - TEST2" },
	{  4449, "Roma/A2I - UT100" },
	{  4450, "Milano/M2I - UT100" },
	{  4451, "Roma/A1T - AXE" },
	{  4452, "Roma/A1I - 1240" },
	{  4453, "Palermo/L1I - 1240" },
	{  4454, "Milano/M1I - 1240" },
	{  4455, "Milano\\Via Cappuccini, 8" },
	{  4456, "Roma/N1I - 1240" },
	{  4457, "Milano1/via jenner 56" },
	{  4458, "Roma/IS - RM1" },
	{  4459, "Milano/M3I - UT100" },
	{  4460, "Roma/AEI - 5ESS" },
	{  4461, "Milano/Via Benzi, 1/8" },
	{  4462, "Milano/Via Kuliscioff, 32" },
	{  4463, "Roma/UT100 - TEST3" },
	{  4464, "Milano/R1I - UT100" },
	{  4465, "Milano/IS - MI1" },
	{  4466, "Milano/UT100 - TEST1" },
	{  4467, "Trezzano sul Naviglio (MI)/via L.Da Vinci, 1 – HGMI1" },
	{  4468, "Roma/AUI - UT100" },
	{  4469, "Milano/DMS-1" },
	{  4470, "Milano/MI01" },
	{  4471, "Roma/RM01" },
	{  4472, "WI MI1 Milano" },
	{  4473, "WI RM1 Roma" },
	{  4474, "Milano/IS - MI2" },
	{  4475, "Milano/MI-MSC" },
	{  4476, "Roma/Ro-CTRL" },
	{  4477, "Milano San Simpliciano ITZ" },
	{  4478, "Via Viviani, 8 Milano - PLMI1" },
	{  4479, "Via Viviani, 8 Milano - PLMI2" },
	{  4480, "Trento/Via Brennero, 169/11" },
	{  4481, "Milano/Via Caldera,21" },
	{  4482, "Bologna/Via Ca Dell'orbo, 34/9 Castenaso" },
	{  4483, "Milano/Via Aporti 26" },
	{  4484, "Segrate/via Cassanese 210" },
	{  4485, "Roma/viale di Porta Ardeatina 129" },
	{  4486, "Milano/Via Kulishoff, 5" },
	{  4487, "Milano/via Bensi 12/9, Liberty A - VOMI2" },
	{  4488, "Roma/Via del Fosso di Santa Maura, 26 – VORM1" },
	{  4489, "L'Aquila(Ortuccio)/Fucino1" },
	{  4490, "L'Aquila(Ortuccio)/Fucino2" },
	{  4491, "Via Caldera 21/A - Milano" },
	{  4492, "Roma/Via del Fosso di Santa Maura, 26 – VORM2" },
	{  4493, "Roma/Via del Fosso di S.Maura ^ Torrespaccata" },
	{  4494, "Milano/via Rombon 11" },
	{  4495, "Milano/corso S. Gottardo 39" },
	{  4496, "Napoli/Strada Nazionale delle Puglie, 63 - San Vitaliano" },
	{  4497, "Milano\\Viale F. Testi, 7" },
	{  4498, "Milano\\Via Caldera, 21" },
	{  4499, "Roma/vicolo Colle della Strega 41" },
	{  4500, "Via Tucidide 56 Torre 2 - 20134 Milano" },
	{  4501, "Milano/Via Viviani, 8 - DTM2" },
	{  4502, "Roma/via A. Severo, 246 - HGRM1" },
	{  4503, "Via Caldera 21 Milano - ATMI2" },
	{  4504, "MILANO VIA LANCETTI - PMMI2" },
	{  4505, "MILANO VIA LANCETTI - PMMI3" },
	{  4506, "Cremona/Via Persico, 31A" },
	{  4507, "Trezzano sul Naviglio (MI)/via L.Da Vinci, 1 – HGMI2" },
	{  4508, "Via Caldera 21 20153 Milano" },
	{  4509, "Milano/Via Lancetti Martini, 23" },
	{  4510, "Roma/Via della Valle dei Fontanili, 29" },
	{  4511, "Milano/Viale De Gasperi, 2 (S. Donato Milanese)" },
	{  4512, "Bucuresti" },
	{  4513, "Bucuresti" },
	{  4514, "Brasov" },
	{  4515, "Brasov" },
	{  4516, "Brasov" },
	{  4517, "Bucuresti" },
	{  4518, "Bucuresti" },
	{  4519, "Bucuresti" },
	{  4520, "Zürich" },
	{  4521, "Renens VD" },
	{  4522, "..." },
	{  4524, "Zurich" },
	{  4526, "Zürich" },
	{  4527, "Renens VD" },
	{  4528, "Bern" },
	{  4529, "Crissier" },
	{  4530, "Zürich" },
	{  4531, "Lugano" },
	{  4532, "ZH_1" },
	{  4533, "ZH_2" },
	{  4534, "Bern" },
	{  4535, "Zürich_1" },
	{  4536, "Lausanne" },
	{  4537, "Zürich" },
	{  4538, "Olten" },
	{  4539, "Geneva 1" },
	{  4540, "Bern" },
	{  4541, "Geneva 2" },
	{  4542, "Zürich" },
	{  4543, "RenensVD" },
	{  4544, "Zürich" },
	{  4545, "Zürich" },
	{  4546, "Genève" },
	{  4547, "Genève" },
	{  4548, "Zürich" },
	{  4549, "Zürich" },
	{  4550, "Basel" },
	{  4551, "Basel" },
	{  4552, "Used for Swisscom internal purposes" },
	{  4553, "Swiss GSM Int'l Roaming Switch, MSC1 Lausanne (Swiss Natel D)" },
	{  4554, "Swiss GSM Int'l Roaming Switch, MSC5 Zürich (Swiss Natel D)" },
	{  4555, "Swiss NMT Int'l Roaming Switch, NC5/NMT (Swiss Natel C)" },
	{  4556, "Bern" },
	{  4557, "Basel" },
	{  4558, "Bern" },
	{  4559, "Zürich" },
	{  4560, "Zürich" },
	{  4561, "Zürich S01" },
	{  4562, "Alias ZHSTP02/GESTP01" },
	{  4563, "Zürich" },
	{  4564, "Lausanne S01" },
	{  4565, "Zürich" },
	{  4566, "Zürich" },
	{  4567, "Zürich" },
	{  4568, "Pratteln" },
	{  4569, "Genève" },
	{  4570, "Genève" },
	{  4571, "Bern" },
	{  4572, "Zürich" },
	{  4573, "Luzern" },
	{  4574, "Bern" },
	{  4575, "Bern" },
	{  4577, "MSSBRB2" },
	{  4578, "MSSRZT1" },
	{  4579, "Tiscali CZ" },
	{  4580, "SZDC" },
	{  4581, "Ceznet Praha CZ" },
	{  4582, "SZDC CZ" },
	{  4584, "Zürich" },
	{  4585, "Renens VD" },
	{  4586, "..." },
	{  4587, "Zürich_2" },
	{  4588, "..." },
	{  4590, "Bern" },
	{  4591, "Bern" },
	{  4592, "Zürich 2" },
	{  4593, "Zug 2" },
	{  4594, "ZHSTP02" },
	{  4595, "Zürich" },
	{  4596, "Pratteln" },
	{  4597, "Zürich" },
	{  4598, "Zürich" },
	{  4599, "Zurich_3" },
	{  4600, "Zürich" },
	{  4601, "GESTP01" },
	{  4603, "Zürich" },
	{  4604, "Zurich" },
	{  4606, "Zug" },
	{  4607, "Zug" },
	{  4608, "A1-ISPC-2-64-0" },
	{  4609, "A1-ISPC-2-64-1" },
	{  4610, "A1-ISPC-2-64-2" },
	{  4611, "A1-ISPC-2-64-3" },
	{  4612, "A1-ISPC-2-64-4" },
	{  4613, "Wien" },
	{  4614, "Wien" },
	{  4615, "A1-ISPC-2-64-7" },
	{  4616, "A1-ISPC-2-65-0" },
	{  4617, "A1-ISPC-2-65-1" },
	{  4618, "A1-ISPC-2-65-2" },
	{  4619, "A1-ISPC-2-65-3" },
	{  4620, "A1-ISPC-2-65-4" },
	{  4622, "A1-ISPC-2-65-6" },
	{  4623, "SP_4623_Vienna_Tele2" },
	{  4626, "W07AI" },
	{  4627, "W10MI" },
	{  4628, "I05AI" },
	{  4629, "SP_4629_Linz_Tele2" },
	{  4630, "Wien" },
	{  4632, "GLOB01" },
	{  4633, "GLOB02" },
	{  4634, "USP_Wien" },
	{  4635, "SALZAUBB03M" },
	{  4636, "USP_Salzburg" },
	{  4637, "MGW11" },
	{  4638, "MGW12" },
	{  4639, "UPC_WIEN" },
	{  4641, "ZZ5" },
	{  4642, "Manchester TeS" },
	{  4643, "ZZ6" },
	{  4644, "EGH-G41SCCP" },
	{  4645, "Belfast Cromac DXA" },
	{  4647, "LonDocklands" },
	{  4648, "JER-TPSTA" },
	{  4649, "Belfast City Unit B" },
	{  4650, "Portadown DCCE Unit 1" },
	{  4651, "YANNA UK1" },
	{  4652, "LON-TPSTB" },
	{  4653, "MGC1" },
	{  4654, "MGC2" },
	{  4655, "The-G41SCCP" },
	{  4656, "Turner SSP" },
	{  4657, "London GSX 9" },
	{  4658, "Frankfurt Durer SSP" },
	{  4659, "Sydny Bell SSP" },
	{  4660, "Monet SSP" },
	{  4661, "Blake SSP (ex-Peto N/Yk)" },
	{  4662, "Ref Model Mtlsham" },
	{  4663, "Ref Model Mtlsham" },
	{  4664, "Hng Kong Hogth SSP" },
	{  4665, "Tokyo Utamaro SSP" },
	{  4666, "Arun" },
	{  4667, "Bollin" },
	{  4668, "Jersey Airtel 2" },
	{  4669, "Glasgow TeS" },
	{  4670, "LONDON1" },
	{  4671, "Brentwood1" },
	{  4672, "BKLSW2 2-072-0" },
	{  4673, "ZZ1 CT2 Pop" },
	{  4674, "VHXSW2 2-072" },
	{  4675, "BKLSW5 2-072-3" },
	{  4676, "CHTSW3 2-072-4" },
	{  4677, "SQYSW4 2-072-5" },
	{  4678, "Bracknell West 1 International STP" },
	{  4679, "Surrey Quays 5 International STP" },
	{  4680, "th-prd-itp3" },
	{  4681, "th-prd-itp4" },
	{  4683, "Brentwood2" },
	{  4684, "Telsis" },
	{  4685, "LONDON 1" },
	{  4686, "TELEHOUSE 2" },
	{  4687, "" },
	{  4688, "Nokia 1" },
	{  4689, "LonGoswell" },
	{  4690, "L/PSX/5" },
	{  4691, "Nutel SG1" },
	{  4692, "London 1" },
	{  4693, "LDNI ISC" },
	{  4694, "TINC IN Platform" },
	{  4695, "TIND IN Platform" },
	{  4697, "Bristol AVN2046-E10" },
	{  4698, "ECT 1" },
	{  4699, "UK 2" },
	{  4700, "London 1" },
	{  4701, "Croydon GMSC 2 (CN9)" },
	{  4702, "JE/W/STP" },
	{  4703, "Jersey Central" },
	{  4704, "Copenhagen - Copenhagen dnc" },
	{  4706, "Copenhagen - Albertslund dnc" },
	{  4709, "" },
	{  4711, "" },
	{  4714, "Copenhagen" },
	{  4715, "Banedanmark East" },
	{  4716, "Banedanmark West" },
	{  4719, "" },
	{  4721, "Copenhagen - Ejby LS" },
	{  4725, "..." },
	{  4732, "Copenhagen - Orestaden LS" },
	{  4733, "Telehouse Glostrup" },
	{  4736, "Stockholm UX1 (Stockholm)" },
	{  4737, "VMS1 (Stockholm)" },
	{  4738, "MSC 1 (Stockholm)" },
	{  4739, "MSC 2 (Stockholm)" },
	{  4740, "GTS-STO-S1 (Stockholm)" },
	{  4741, "GBR2S (Göteborg)" },
	{  4742, "NMT STHLM MSC1 (Stockholm)" },
	{  4743, "Stockholm UX2 (Stockholm)" },
	{  4744, "Stockholm/UN STX (Stockholm)" },
	{  4745, "Stockholm/UR STX (Stockholm)" },
	{  4746, "Malmö/UR STX (Malmö)" },
	{  4747, "HY1S (Stockholm)" },
	{  4748, "MSC 102 (Stockholm)" },
	{  4749, "SNVH1-INT (Stockholm)" },
	{  4750, "SNKT1-INT (Stockholm)" },
	{  4752, "RIX1" },
	{  4753, "IQVM4 (Stockholm)" },
	{  4754, "VRR2 MSC (Göteborg)" },
	{  4755, "MSC 402 (Stockholm)" },
	{  4756, "MSC 401 (Stockholm)" },
	{  4758, "MGW 102 (Stockholm)" },
	{  4760, "Kista/TL2 (Stockholm)" },
	{  4761, "Gothenburg/TL2 (Göteborg)" },
	{  4762, "WCOMSTHLM2 (Stockholm)" },
	{  4763, "WCOMSTHLM3 (Stockholm)" },
	{  4764, "SU-HUV-MSS1 (Stockholm)" },
	{  4765, "KK-B-MSC09 (Karlskrona)" },
	{  4766, "RSL-SWE 2 (Stockholm)" },
	{  4768, "Eik GW1" },
	{  4769, "Eik GW2" },
	{  4770, "Oslo1" },
	{  4771, "Oslo" },
	{  4772, "Aeromobile 1" },
	{  4773, "Oslo U1" },
	{  4774, "Oslo U2" },
	{  4775, "OSLO_IP" },
	{  4776, "Oslo MSC1" },
	{  4779, "Oslo G MSC" },
	{  4780, "Oslo Network Norway" },
	{  4781, "Oslo1" },
	{  4782, "Oslo" },
	{  4783, "Oslo2" },
	{  4784, "Oslo Netc1 MSC" },
	{  4785, "Oslo Netc4 MSC" },
	{  4786, "T1E-Osl" },
	{  4787, "T1E-Bgo" },
	{  4788, "Kvantel 1" },
	{  4789, "NOOSLULV89" },
	{  4790, "OSL-TL1" },
	{  4791, "Oslo_LX" },
	{  4793, "NOOSLOKE121" },
	{  4794, "STVR_LX" },
	{  4795, "C4MSS1" },
	{  4796, "NIT-GW1" },
	{  4797, "Eik MSC 1" },
	{  4799, "Gri CDMA MSC" },
	{  4803, "Raisio MGW (FI2_MGW)" },
	{  4805, "Helsinki (HLS-SIGW1 TSIC)" },
	{  4806, "Helsinki (MGTS)" },
	{  4809, "Helsinki (GIWU)" },
	{  4811, "Hämeenlinna (HML1 Surpass MGC)" },
	{  4812, "Helsinki (HMG02 TSIC)" },
	{  4813, "Lahti (MSCSLA5, MSC)" },
	{  4814, "Lahti (STPLA1, STP-keskus)" },
	{  4815, "Hyvinkää (KOE10 Surpass)" },
	{  4816, "Mariehamn (Mariehamn)" },
	{  4817, "Jomala (Jomala)" },
	{  4818, "Helsinki (STPHE2, STP-keskus)" },
	{  4820, "Helsinki (FI1)" },
	{  4821, "Raisio (FI2)" },
	{  4823, "Helsinki (SMS02HKP)" },
	{  4824, "Tampere (SMS03TRE)" },
	{  4825, "Helsinki/Jorvas (FITEST)" },
	{  4832, "Tallinn" },
	{  4833, "Tallinn" },
	{  4834, "Tallinn" },
	{  4835, "Tallinn" },
	{  4837, "Tallin" },
	{  4838, "Tallinn" },
	{  4839, "Tallinn" },
	{  4840, "Via Caldera 21 - Milano" },
	{  4841, "Nola (NA) Via Polveriera, 130" },
	{  4842, "Bari Via Traversa, 310 di Via Napoli, 49g" },
	{  4843, "Roma/Sedime Aeroportuale di fiumicino" },
	{  4844, "Milano/via Ugo Bassi 2" },
	{  4845, "L'Aquila(Ortucchio)/Fucino - TSAQ1" },
	{  4846, "Milano/via Caldera 21/F - TIMI2" },
	{  4847, "Milano/Via Caldera, 21" },
	{  4848, "Roma/via S. Martini 127/129" },
	{  4849, "Roma/viale Lincoln 18" },
	{  4850, "Via Boccanelli 21, ROMA - WTRM1" },
	{  4851, "Via Boccanelli 21, ROMA - WTRM2" },
	{  4852, "MILANO VIA LANCETTI - PMMI4" },
	{  4853, "Trento via Ernesto Sestan 5" },
	{  4854, "MILANO VIA LANCETTI - PMMI5" },
	{  4855, "L'Aquila(Ortucchio)/Fucino - TSAQ2" },
	{  4856, "Milano/via Bensi 12/9, Liberty A - VOMI3" },
	{  4857, "Roma/via Fosse di S.Maura angolo via di Torre Spaccata" },
	{  4858, "Milano/via Caldera 21" },
	{  4859, "Pozzuoli(Na)/via Antiniana 2/A" },
	{  4860, "Via Cavriana, 14 MILANO" },
	{  4861, "Via Caldera 21 - 20153 Milano" },
	{  4862, "Treviolo(BG)/V.le Europa 17/B" },
	{  4863, "VIA LANCETTI MARTINI 23 - 20159 MILANO" },
	{  4864, "Riga ISC1 (S-12)" },
	{  4865, "Riga ISC 2" },
	{  4866, "Riga SN 2" },
	{  4867, "Riga LE Gateway" },
	{  4868, "GSM" },
	{  4869, "Riga TB1" },
	{  4870, "MSC-1" },
	{  4871, "GSM" },
	{  4872, "Mobistar STP T02 BRU" },
	{  4873, "Mobistar STP T03 ANT" },
	{  4875, "BMSC2/Brussels" },
	{  4876, "ZMSC1" },
	{  4877, "GMSC3" },
	{  4879, "TELENET - Asse" },
	{  4880, "Vodafone Belgium 1" },
	{  4881, "" },
	{  4882, "" },
	{  4883, "BSTP1/Brussels STP" },
	{  4884, "ASTP1/Antwerp STP" },
	{  4885, "" },
	{  4886, "Nethys 1" },
	{  4887, "Nethys 2" },
	{  4888, "" },
	{  4890, "" },
	{  4891, "" },
	{  4892, "MSC-S/MGW Intl1" },
	{  4893, "MSC-S/MGW Intl2" },
	{  4895, "Voyacom 1" },
	{  4896, "Moscow International Switching Centre-3" },
	{  4897, "St Petersburg International Switching Centre" },
	{  4898, "Moscow International Switching Centre-4" },
	{  4899, "Khabarovsk International Switching Centre" },
	{  4900, "Samara International Switching Centre" },
	{  4901, "Novosibirsk International Switching Centre" },
	{  4902, "Ekaterinburg International Switching Centre" },
	{  4903, "Rostov International Switching Centre" },
	{  4904, "IGW1/MOS International gateway 1, Moscow" },
	{  4905, "IGW2/SPB International gateway 2, St Petersburg" },
	{  4906, "IGW3/NVS International gateway 3, Novosibirsk" },
	{  4911, "IGW4/HAB International gateway 4, Khabarovsk" },
	{  4912, "Moscow International Gateway 1, GSM" },
	{  4913, "St. Petersburg International Gateway, GSM" },
	{  4917, "Moscow International Gateway 2" },
	{  4920, "Moscow Connection Station" },
	{  4928, "Moscow International Switching Center-1" },
	{  4929, "St. Petersburg International Switching Center-33" },
	{  4930, "Murmansk International Switching Center" },
	{  4931, "Moscow International Stand alone STP-1" },
	{  4932, "Moscow International Stand alone STP-2" },
	{  4933, "Kaliningrad International Switching Center" },
	{  4934, "Moscow International Switching Center-5" },
	{  4935, "Moscow International Switching Center-2" },
	{  5056, "OPL WAW 1" },
	{  5057, "OPL KAT 1" },
	{  5058, "OPL POZ 1" },
	{  5059, "OPL KAT 2" },
	{  5060, "OPL POZ 2" },
	{  5061, "POL WAW 1" },
	{  5062, "POL WAW 3" },
	{  5063, "NOR WAW 1" },
	{  5064, "DERATSG01_RATINGEN_VRS" },
	{  5065, "DERATSG02_RATINGEN_VRS" },
	{  5066, "München" },
	{  5067, "Frankfurt" },
	{  5068, "Frankfurt" },
	{  5069, "Eschborn" },
	{  5070, "Düsseldorf" },
	{  5071, "Frankfurt" },
	{  5072, "Bielefeld" },
	{  5073, "Frankfurt" },
	{  5074, "Frankfurt" },
	{  5075, "Frankfurt" },
	{  5076, "Hamburg" },
	{  5077, "Hamburg" },
	{  5078, "Frankfurt" },
	{  5079, "Frankfurt" },
	{  5080, "Düsseldorf" },
	{  5081, "Frankfurt" },
	{  5082, "Frankfurt" },
	{  5083, "Frankfurt" },
	{  5084, "Frankfurt" },
	{  5085, "Düsseldorf" },
	{  5086, "Wuppertal" },
	{  5087, "Frankfurt" },
	{  5088, "Frankfurt" },
	{  5089, "Düsseldorf" },
	{  5090, "Düsseldorf" },
	{  5091, "Düsseldorf" },
	{  5092, "Düsseldorf" },
	{  5093, "Düsseldorf" },
	{  5094, "Düsseldorf" },
	{  5095, "Düsseldorf" },
	{  5096, "Frankfurt" },
	{  5097, "Frankfurt" },
	{  5098, "Berlin" },
	{  5099, "Frankfurt" },
	{  5100, "Frankfurt" },
	{  5101, "Frankfurt" },
	{  5102, "Frankfurt" },
	{  5103, "Frankfurt" },
	{  5104, "Hamburg" },
	{  5105, "Frankfurt" },
	{  5106, "Hamburg" },
	{  5107, "München" },
	{  5108, "Köln" },
	{  5109, "Stuttgart" },
	{  5110, "Hamburg" },
	{  5111, "Frankfurt" },
	{  5112, "Frankfurt" },
	{  5113, "Düsseldorf" },
	{  5114, "Bamberg" },
	{  5115, "Essen" },
	{  5117, "Frankfurt" },
	{  5118, "Frankfurt" },
	{  5119, "Frankfurt" },
	{  5120, "Frankfurt" },
	{  5121, "Frankfurt" },
	{  5122, "Frankfurt" },
	{  5123, "Frankfurt" },
	{  5124, "Frankfurt" },
	{  5125, "Frankfurt" },
	{  5126, "Frankfurt" },
	{  5127, "Frankfurt" },
	{  5128, "Nürnberg" },
	{  5130, "Stuttgart" },
	{  5131, "Wendlingen" },
	{  5132, "Stuttgart" },
	{  5133, "Frankfurt" },
	{  5134, "Frankfurt" },
	{  5135, "Frankfurt" },
	{  5136, "München" },
	{  5137, "Frankfurt" },
	{  5138, "Frankfurt" },
	{  5139, "Frankfurt" },
	{  5140, "Frankfurt" },
	{  5141, "Frankfurt" },
	{  5142, "Frankfurt" },
	{  5143, "Frankfurt" },
	{  5144, "Berlin" },
	{  5145, "Düsseldorf" },
	{  5146, "Nürnberg" },
	{  5147, "Nürnberg" },
	{  5148, "Nürnberg" },
	{  5149, "Nürnberg" },
	{  5150, "Nürnberg" },
	{  5151, "Nürnberg" },
	{  5152, "Gibtelecom" },
	{  5154, "Gibtelecom" },
	{  5155, "Sapphire Networks" },
	{  5156, "Gibtelecom" },
	{  5157, "Eazi Telecom" },
	{  5161, "W05MI" },
	{  5162, "STP_WS_A" },
	{  5163, "STP_WR_A" },
	{  5164, "MGW_WR_A" },
	{  5165, "MGW_WS_A" },
	{  5166, "MSS_WR_A" },
	{  5167, "WIENAUBB01M" },
	{  5168, "OPL WAW 2" },
	{  5169, "MDT WAW 1" },
	{  5170, "TMP WAW 1" },
	{  5171, "NET WAW 1" },
	{  5172, "NET KAT" },
	{  5173, "EXA WAW" },
	{  5174, "EXA KAT" },
	{  5175, "OPL WAW 3" },
	{  5176, "EBRC Kayl" },
	{  5177, "EBRC Kayl" },
	{  5178, "Luxconnect S.A. Bettembourg" },
	{  5179, "MSC Kirchberg" },
	{  5180, "Luxembourg-Gare" },
	{  5181, "MGW Kirchberg" },
	{  5182, "" },
	{  5183, "" },
	{  5184, "Stand Alone Linda-a-Velha (SA1)" },
	{  5185, "Stand Alone Picoas (SA2)" },
	{  5186, "TDM Switch Linda-a-Velha (LRM4)" },
	{  5187, "Planned for Stand Alone Linda-a-Velha (SA1)" },
	{  5188, "Planned for Stand Alone Picoas (SA2)" },
	{  5189, "Planned for Stand Alone Linda-a-Velha (SA1)" },
	{  5190, "Planned for Stand Alone Picoas (SA2)" },
	{  5192, "NOS (LOS10) LISBOA" },
	{  5193, "Planned for Stand Alone Linda-a-Velha (SA1)" },
	{  5194, "Planned for Stand Alone Picoas (SA2)" },
	{  5195, "TDM Switch Picoas (LRM3)" },
	{  5196, "NOS (LON10) LISBOA" },
	{  5197, "NOS (PCS10) PORTO" },
	{  5198, "ARTELECOM (LSBNPTJZ01T) LISBOA" },
	{  5201, "VODAFONE (MAT1TE) LISBOA-MATINHA" },
	{  5202, "NOS (LSB30) LISBOA-LOURES" },
	{  5203, "ONI (00INTL1) LISBOA" },
	{  5204, "ONI (00INTP1) PORTO" },
	{  5205, "ONI (REPÚBLICA) AV. DA REPÚBLICA" },
	{  5206, "NOS (TVCLIS04) LISBOA" },
	{  5207, "NOS (TVCLIS91) LISBOA" },
	{  5208, "NOS (GRA30) LISBOA" },
	{  5209, "VODAFONE (MAT1FS) LISBOA-MATINHA" },
	{  5210, "VODAFONE (ALF1ME) CASAL DE ALFRAGIDE" },
	{  5211, "VODAFONE (BOA1FS) PORTO/BOAVISTA" },
	{  5212, "VODAFONE (ALF1TC) LISBOA" },
	{  5213, "VODAFONE (BOA1TC) PORTO" },
	{  5214, "COLT (COLT) OEIRAS" },
	{  5215, "IP (RTINT1) LISBOA-GARE DO ORIENTE" },
	{  5216, "Luxembourg-Gare" },
	{  5217, "Luxembourg-Belair" },
	{  5218, "Luxembourg-Gare" },
	{  5219, "MSC Bertrange" },
	{  5220, "Contern" },
	{  5221, "Contern" },
	{  5222, "Howald" },
	{  5223, "Bertrange" },
	{  5224, "Luxembourg" },
	{  5225, "Contern" },
	{  5226, "Cloche d’or" },
	{  5227, "Luxconnect S.A. Bettembourg" },
	{  5228, "Luxembourg-Gare" },
	{  5229, "Contern" },
	{  5230, "Bertrange" },
	{  5231, "Bertrange" },
	{  5232, "PT NTP(Equinox Datacenter), Amsterdam" },
	{  5233, "NL01, Amsterdam" },
	{  5234, "IMCSTPI01, 1096AM 127" },
	{  5235, "MSC Server YA, Computerwg 20 Maarsen" },
	{  5236, "TR, Rotterdam" },
	{  5237, "TA, Amsterdam" },
	{  5238, "Land Earth Station S, Wytsemaweg 11 Burum" },
	{  5239, "ETAMS1, Stekkenbergweg 4 Amsterdam" },
	{  5240, "PMGSSP, Amsterdam" },
	{  5241, "UT_MBC, Nieuwegein" },
	{  5242, "HILF ISPC 2, Kuiperbergweg 13, 1101 AE Amst" },
	{  5243, "PT NTP(Equinox Datacenter), Amsterdam" },
	{  5244, "AMDi, Amsterdam" },
	{  5245, "SGRSTP01, Laan van Ypenburg 10" },
	{  5246, "SEP, Rdam2" },
	{  5247, "Asd-Drs VIGCI, Drentsestraat 12" },
	{  5248, "Dublin, Dame Court" },
	{  5249, "Dublin, Adelaide Road" },
	{  5250, "Dublin 1" },
	{  5251, "Dublin 2" },
	{  5252, "Dublin, Dolphin's Barn" },
	{  5253, "Blanchardstown (M10)" },
	{  5254, "Willsborough (W31)" },
	{  5255, "Dundrum" },
	{  5256, "Fenian Street" },
	{  5257, "Sir Rodgerson's Quay" },
	{  5258, "Harcourt St. 1" },
	{  5259, "Barrow St." },
	{  5260, "L. Pembroke St." },
	{  5261, "Esat Wall D3" },
	{  5262, "Erne Street D2" },
	{  5263, "Courtyard Business Pk., Blackrock" },
	{  5264, "Hogan Place" },
	{  5265, "DN1MGW04" },
	{  5266, "MAGNETSPI-01" },
	{  5267, "Flemings Place" },
	{  5268, "BL0MSS03" },
	{  5269, "East Wall Dublin" },
	{  5270, "East Wall Dublin" },
	{  5271, "VoIP Ireland" },
	{  5272, "LQ-DG1-THO" },
	{  5273, "FixGroup01" },
	{  5274, "London" },
	{  5275, "GBS2" },
	{  5276, "C20 Manchester" },
	{  5277, "Lannet London 2" },
	{  5278, "Lannet London 3" },
	{  5279, "SQTC2" },
	{  5280, "Reykjavik/RIC" },
	{  5281, "Reykjavik/MIC" },
	{  5283, "IPF IC" },
	{  5284, "HalloReyk001" },
	{  5285, "Reykjavik/ISAXE" },
	{  5286, "Reykjavik/ISMID" },
	{  5287, "NOVA ISL3" },
	{  5288, "MCI Worldcom - Paris" },
	{  5289, "Completel – Paris 1" },
	{  5290, "Intercall - Courbevoie" },
	{  5291, "Telia France 1" },
	{  5292, "Cable & Wireless 2" },
	{  5293, "Coriolis Telecom – Paris" },
	{  5294, "Coriolis Telecom – Saint Denis" },
	{  5295, "Numéricâble - Champs sur Marne" },
	{  5296, "Orange - Paris Archives - GLR2" },
	{  5297, "Completel 1" },
	{  5298, "Mobiquithings – Vitry 4" },
	{  5299, "Mobiquithings – Vitry 5" },
	{  5300, "Mobiquithings – Vitry 6" },
	{  5301, "Orange - Paris Archives - Cisco ITP 3" },
	{  5302, "Orange - Corbeil IGP 4" },
	{  5303, "Prosodie 1" },
	{  5304, "SAP France – Courbevoie 1 bis" },
	{  5305, "SAP France – Courbevoie 2 bis" },
	{  5306, "Bouygues Telecom 2" },
	{  5307, "Symacom - Paris 2" },
	{  5308, "Equant 1" },
	{  5309, "SFR - XC97" },
	{  5310, "Global Crossing 1" },
	{  5311, "Multicoms 1" },
	{  5312, "ISC – Tirana" },
	{  5313, "GMSC – Tirana" },
	{  5315, "GMSC – Tirana" },
	{  5316, "ISC - Durres" },
	{  5318, "GMSC – Tirana" },
	{  5319, "STP- Tirana" },
	{  5320, "C20 Hayes" },
	{  5321, "ISG_TS_AM3" },
	{  5322, "LMUK-iSTP3" },
	{  5323, "LMUK-iSTP4" },
	{  5325, "London STP" },
	{  5326, "Jersey Telenet Ltd 1" },
	{  5327, "Collindale TeS" },
	{  5328, "London 1" },
	{  5329, "LONDON TH B" },
	{  5331, "LANNET LONDON 1" },
	{  5332, "STK2" },
	{  5333, "Slough VOIP1" },
	{  5334, "Docklands VOIP 1" },
	{  5335, "MTLJE02" },
	{  5336, "London 178GSX1" },
	{  5337, "PG01-LON" },
	{  5339, "KJCOPM01" },
	{  5340, "GC Slough 1" },
	{  5341, "Ematel1" },
	{  5342, "London 178GSX2" },
	{  5344, "MOTSS International 1" },
	{  5345, "MOTSS International 2" },
	{  5346, "go1" },
	{  5347, "VOD1-MT" },
	{  5348, "VOD2-MT" },
	{  5351, "3GT" },
	{  5352, "Verona/Via Lungadige Galtarossa, 8" },
	{  5353, "Rozzano 20089 Milanofiori, strada 4 edif. Q" },
	{  5354, "Prato(FI)/via di Grignano 11" },
	{  5355, "Milano/ viale Ortles 70" },
	{  5356, "Roma/ via Idrovore della Magliana 163 – WTRM3" },
	{  5357, "Milano/viale Ortles 70" },
	{  5358, "Roma/ via Idrovore della Magliana 163 – WTRM4" },
	{  5359, "MILANO VIA LANCETTI - PMMI6" },
	{  5360, "via caldera milano" },
	{  5361, "Via Bernina - MILANO" },
	{  5362, "Pisa/via A.Bellatalla 1" },
	{  5363, "Casalecchio sul Reno BO via Bertocchi,97" },
	{  5364, "Roma/via G.V. Bona 67 Ed. B - CTRM1" },
	{  5365, "Via Anagnina, 203 - ROMA" },
	{  5366, "Torino/via Nizza 262 int. 58 c/o Centro Lingotto" },
	{  5367, "Siena/viale Toselli 9/a" },
	{  5368, "Milano/via E. Jenner 33" },
	{  5369, "Cagliari/SS 195 Km 6 Loc. 'Sa Illetta'" },
	{  5370, "Roma/via di Tor Pagnotta 68 - TIRM1" },
	{  5371, "Milano/via Giacosa 19 - TIMI1" },
	{  5372, "Via del Lavoro, 85 - Casalecchio sul Reno (BO)" },
	{  5373, "Torino/Corso Moncalieri, 21" },
	{  5374, "Padova/via Longhin 97" },
	{  5375, "Via G. Ferraris, 40/D - NAPOLI" },
	{  5376, "ACR ITE Nicosia" },
	{  5377, "AMA ITE Limassol" },
	{  5378, "GSM, Nicosia, Kennedy" },
	{  5379, "Callsat NIC1, Nicosia" },
	{  5380, "GSM, Nicosia, Latsia" },
	{  5381, "ONT/NIC 1, Nicosia" },
	{  5382, "TWX/LIM1, Limassol" },
	{  5383, "OMGTEL-FR" },
	{  5384, "San Jose Adams" },
	{  5386, "London Docklands 2" },
	{  5387, "London Docklands 1" },
	{  5388, "Teleglobe LHX" },
	{  5389, "London 7" },
	{  5390, "Eircom SQP1" },
	{  5391, "London STP" },
	{  5392, "Isle of Man" },
	{  5393, "LONDON 1" },
	{  5394, "Poplar Business Park Local" },
	{  5395, "CLTLN9P0" },
	{  5397, "Guernsey Castel" },
	{  5398, "Gloucester STP" },
	{  5399, "Mansfield M89" },
	{  5400, "MR9" },
	{  5401, "LEBARA 2" },
	{  5402, "London-2" },
	{  5403, "Isle of Man" },
	{  5404, "Fareham01" },
	{  5405, "Teles MGC CLUSTER EGH" },
	{  5407, "Spacetel UK 1" },
	{  5408, "Brentford ISC" },
	{  5409, "MW UK POP 1" },
	{  5410, "TRIAx01" },
	{  5411, "SOUT-STP" },
	{  5412, "BAGU-STP" },
	{  5413, "CMIV01" },
	{  5414, "Feltham 4" },
	{  5415, "CMIS05" },
	{  5416, "GC Birmingham" },
	{  5417, "L/CWX/1" },
	{  5418, "Fareham HAM6040-E16" },
	{  5419, "London 2" },
	{  5421, "LEBARA5" },
	{  5423, "Kg John Carrier 1" },
	{  5424, "London 4" },
	{  5425, "Slough" },
	{  5426, "BHXGSX1" },
	{  5427, "Telsis" },
	{  5428, "HTUKSMS1" },
	{  5429, "L/TZX/6" },
	{  5430, "Leeds STP" },
	{  5431, "Luton BED6000-E17" },
	{  5432, "BMSTP" },
	{  5433, "Ilford STP" },
	{  5434, "Manchester GMN0901-E18" },
	{  5437, "Budapest 1" },
	{  5438, "Prague 1" },
	{  5439, "Hanhaa-STP1" },
	{  5440, "TPN" },
	{  5441, "ITE" },
	{  5442, "ITE2" },
	{  5443, "ORBG" },
	{  5444, "SPNET" },
	{  5445, "GMSC1" },
	{  5446, "STP1" },
	{  5447, "MSCS1" },
	{  5448, "HTUKSMS2" },
	{  5449, "GB04" },
	{  5450, "Telehouse 3" },
	{  5451, "Hanhaa-STP2" },
	{  5452, "DC1-STP" },
	{  5453, "Luton BED6000-E19" },
	{  5454, "DC2-STP" },
	{  5455, "STPCY1" },
	{  5456, "Lond - 03" },
	{  5457, "Lond - 04" },
	{  5459, "Fareham HAM6040-E20" },
	{  5460, "Manchester GMN0901-E21" },
	{  5461, "Reading STP" },
	{  5462, "King Johns Local" },
	{  5463, "Telehouse 1" },
	{  5464, "Ankara/Eser Telekom" },
	{  5465, "GISAD" },
	{  5466, "Istanbul/Borusan Telekom" },
	{  5468, "Istanbul/Vianet" },
	{  5469, "Istanbul/Superonline" },
	{  5470, "Istanbul/Televersal" },
	{  5472, "Ankara /Ulus/CS2k" },
	{  5473, "Ankara /Ulus/DMS-300" },
	{  5474, "Istanbul/Atakoy/ DMS-300" },
	{  5475, "Izmir/karsryaka DMS-300" },
	{  5476, "Telsim GSM" },
	{  5477, "Ankara/Sogutozu/SOG01" },
	{  5478, "Istanbul/Maltepe/MTG02" },
	{  5479, "Istanbul/Telsim GSM" },
	{  5481, "Istanbul/MISTS01 Avea GSM" },
	{  5482, "Ankara/MULUS01 Avea GSM" },
	{  5483, "Izmir/Avea GSM" },
	{  5484, "Istanbul/MACBS01 Avea GSM" },
	{  5485, "Istanbul/Telsim GSM" },
	{  5486, "Ankara/Telsim GSM" },
	{  5487, "Millenicom" },
	{  5488, "Kg John Carrier 2" },
	{  5490, "Greenwich-K59" },
	{  5491, "Keybridge L/Key/STP1" },
	{  5492, "Madley MDY/STP1" },
	{  5493, "STPER1" },
	{  5495, "IRT8" },
	{  5497, "Citrus-1" },
	{  5498, "Birmingham K-58" },
	{  5499, "Tannochside STR4003-E22" },
	{  5500, "London TIVR 1" },
	{  5501, "SQ2" },
	{  5502, "Switch 1 - Goswell1" },
	{  5503, "STPGL1" },
	{  5504, "VTEC LON 1" },
	{  5505, "Tannochside STR4003-E23" },
	{  5506, "Croydon-T13" },
	{  5507, "Park Royal-T04" },
	{  5508, "UK2" },
	{  5509, "Cs2k Basingstoke" },
	{  5510, "Cs2k Reading" },
	{  5511, "STPSN1" },
	{  5513, "STPRM1" },
	{  5514, "PLSUKDMS1I" },
	{  5515, "ITP1" },
	{  5518, "STPOM1" },
	{  5519, "ITP" },
	{  5520, "STPPH1" },
	{  5521, "STC2" },
	{  5522, "Central" },
	{  5523, "TELES" },
	{  5524, "London 3" },
	{  5525, "Paul Street DMS" },
	{  5526, "C&W Jersey" },
	{  5527, "IRT7" },
	{  5528, "Ans-Thm-1" },
	{  5529, "London 1" },
	{  5530, "STPPH2" },
	{  5531, "LNC2" },
	{  5532, "Watford STP" },
	{  5533, "JALSTP1" },
	{  5534, "DDCLZTE1" },
	{  5536, "Zagreb/MC2" },
	{  5537, "ZGMSCS2" },
	{  5538, "ZAGM" },
	{  5539, "STP1 Zagreb" },
	{  5540, "Zagreb/MC1" },
	{  5541, "STP2 Rijeka" },
	{  5542, "MSC Zagreb" },
	{  5543, "MSC Rijeka" },
	{  5544, "Settingiano (CZ)/Loc. Campo Zona Industriale" },
	{  5545, "Firenze/via Slataper 2" },
	{  5546, "Roma/via di Tor Pagnotta 68 - TIRM2" },
	{  5547, "Segrate (MI)/via Cassanese 210" },
	{  5548, "TORINO C.SO TAZZOLI - PMTO1" },
	{  5549, "Rimini/via Circonvallazione Meridionale 54" },
	{  5550, "Roma/via di Tor Pagnotta 68 - TIRM3" },
	{  5551, "Roma/via di Tor Pagnotta 68 - TIRM4" },
	{  5552, "IX1 Ljubljana" },
	{  5553, "IX2 Maribor, Tezno" },
	{  5554, "GSM MSC1 Ljubljana" },
	{  5555, "SA-STP Ljubljana" },
	{  5556, "GSM MSC1 Ljubljana" },
	{  5557, "NETSETRA1" },
	{  5558, "Inlife - LJ1" },
	{  5559, "TUS Telekom d.d. 1" },
	{  5560, "Torino/via Bologna 220" },
	{  5561, "Napoli/cento direziona napoli Isola B5" },
	{  5562, "Modena/via Ganceto 154" },
	{  5563, "TORINO C.SO TAZZOLI - PMTO2" },
	{  5564, "TORINO C.SO TAZZOLI - PMTO3" },
	{  5565, "TORINO C.SO TAZZOLI - PMTO4" },
	{  5566, "TORINO C.SO TAZZOLI - PMTO5" },
	{  5567, "Milano/Via S. Giusto, 51" },
	{  5569, "San Marino" },
	{  5570, "RSM-SMT-0" },
	{  5571, "RSM-SMT-01" },
	{  5573, "NETSETRA 1" },
	{  5576, "Marylebone" },
	{  5577, "L/TZX/3" },
	{  5579, "KDD-E" },
	{  5580, "UKLHCO5-Mercur" },
	{  5581, "JALSTP2" },
	{  5582, "TSC 90" },
	{  5584, "JE/TXD" },
	{  5585, "JE/E" },
	{  5586, "Jersey TRS" },
	{  5588, "H18_LN" },
	{  5589, "Nsoft 1" },
	{  5590, "EPSILON-CTI" },
	{  5591, "Lon1" },
	{  5592, "L/PSX/3" },
	{  5593, "MSSGU" },
	{  5594, "MSC 21" },
	{  5595, "Ans-Hk-1" },
	{  5596, "London1" },
	{  5597, "London1" },
	{  5598, "DDCLZTE1" },
	{  5599, "LEBARA6" },
	{  5600, "New STP/SSP" },
	{  5601, "MSC50" },
	{  5607, "London1" },
	{  5608, "London1" },
	{  5609, "MSC53" },
	{  5610, "LONDON 3" },
	{  5611, "MSC01" },
	{  5612, "Radlett GMSC (RA9)" },
	{  5613, "Sunbury GMSC (SU9)" },
	{  5614, "CW IoM No.1" },
	{  5615, "London 1" },
	{  5616, "Birmingham STP" },
	{  5617, "GC-UK-STP-01" },
	{  5619, "ZZ2 BQ3 Pop" },
	{  5621, "Douglas1" },
	{  5622, "Bishopsgate" },
	{  5623, "City" },
	{  5624, "LONDON 2" },
	{  5625, "Tufnell Park AXD" },
	{  5626, "Luton Int" },
	{  5627, "Switch 2 – Goswell 2" },
	{  5628, "ipLCR Leman" },
	{  5629, "London 1" },
	{  5630, "JE/N/STP" },
	{  5631, "L/TZX/5" },
	{  5634, "S TE 1 (Stockholm)" },
	{  5635, "HY1 MSC-S (Stockholm)" },
	{  5636, "FRE1 MSC-S (Stockholm)" },
	{  5637, "S TE 2 (Stockholm)" },
	{  5639, "VMS2 (Stockholm)" },
	{  5640, "WCOMSTHLM1 (Stockholm)" },
	{  5641, "STO/TN1 (Stockholm)" },
	{  5642, "GTO/TN1 (Göteborg)" },
	{  5643, "RSL_SWE (Stockholm)" },
	{  5644, "VTP (Stockholm)" },
	{  5645, "SAV (Göteborg)" },
	{  5646, "mg1.int.upp" },
	{  5647, "STO-B1-GMSC01 (Stockholm)" },
	{  5649, "Stockholm COLT SWE1 (Stockholm)" },
	{  5650, "SH-B-MSC08 (Stockholm)" },
	{  5651, "ML-BRO-MSC10 (Göteborg)" },
	{  5652, "KK-B-SRR1 (Karlskrona)" },
	{  5653, "GB-BA-SRR2 (Göteborg)" },
	{  5654, "KA-B1-GMSC01 (Karlskrona)" },
	{  5655, "MGW 161 (Stockholm)" },
	{  5656, "MSC 101 (Stockholm)" },
	{  5657, "MGW 101 (Stockholm)" },
	{  5658, "KK-GRA-MSS2 (Karlskrona)" },
	{  5661, "STP1 (Karlskrona)" },
	{  5662, "STP2 (Stockholm)" },
	{  5663, "MSC1 (Stockholm)" },
	{  5665, "Andorra AXE" },
	{  5680, "AMSCA, Amsterdam" },
	{  5681, "E10 GV, Den Haag" },
	{  5682, "MSC Server YB, Rotterdam" },
	{  5683, "Global Switch, Amsterdam" },
	{  5684, "ASD-STP, Amsterdam" },
	{  5685, "RT-STP, Rotterdam" },
	{  5686, "RT_1, Rotterdam" },
	{  5687, "ASD-4, Amsterdam" },
	{  5688, "Tallinn" },
	{  5691, "STP4" },
	{  5693, "STP EST1" },
	{  5694, "STP EST2" },
	{  5695, "NRD/TLN11" },
	{  5696, "Arminco" },
	{  5697, "Yerevan" },
	{  5698, "ARMGSM" },
	{  5699, "Orange" },
	{  5700, "PMPSI" },
	{  5701, "KTPSI" },
	{  5702, "KTPSI" },
	{  5704, "Telecom Italia - POP Nantes 1" },
	{  5705, "SFR - XA08 - Aubervilliers" },
	{  5706, "Colt 2" },
	{  5707, "Colt 3" },
	{  5709, "SFR - XC64 - Vélizy" },
	{  5710, "Dauphin Telecom 2" },
	{  5711, "Orange - Bagnolet - NGN BG6" },
	{  5712, "Telecom Italia - POP Strasbourg 1" },
	{  5713, "SFR - XB89 - Puteaux" },
	{  5714, "Completel 2" },
	{  5715, "Orange - Paris Archives – International Gateway Point No4" },
	{  5716, "Orange - Reims - International Gateway Point No 3" },
	{  5717, "Orange - Paris Pastourelle - Call Server YK02" },
	{  5718, "Mobiweb Telecom – Paris" },
	{  5719, "Mobiweb Telecom – Roubaix" },
	{  5720, "Orange - Lyon- Call Server VOIP YK03" },
	{  5722, "Longphone - Paris 2" },
	{  5723, "XC27" },
	{  5724, "XD13" },
	{  5725, "Outremer Telecom - Paris" },
	{  5726, "LLEIDA - Vitry sur Seine" },
	{  5727, "SFR - Mitry-03" },
	{  5728, "Minsk, EWSD" },
	{  5729, "Borisov, AXE-10" },
	{  5730, "STP1" },
	{  5731, "STP2" },
	{  5733, "Minsk2" },
	{  5734, "Minsk3" },
	{  5736, "GN1S (Stockholm)" },
	{  5737, "GN1B (Trollhättan)" },
	{  5738, "SWE-LINK01 (Linköping)" },
	{  5739, "SWE-STHLM01 (Stockholm)" },
	{  5740, "STH1 (Stockholm)" },
	{  5741, "EuSWE1 (Linköping)" },
	{  5742, "EuSWE2 (Linköping)" },
	{  5743, "CoolTEL SMSC-KLD-1 (Kolding)" },
	{  5745, "Yuboto" },
	{  5746, "Interconnect isc" },
	{  5749, "Wind Hellas Fixed Network -TATN01" },
	{  5752, "Palermo/via A. De Gasperi 50" },
	{  5753, "TORINO C.SO TAZZOLI - PMTO6" },
	{  5754, "MILANO VIA CALDERA 21" },
	{  5755, "Bari/via Nickman 19" },
	{  5756, "Catania/via Conte di Torino 64" },
	{  5757, "Bolzano/Via Pacinotti, 12" },
	{  5758, "Cagliari/via Efisio Melis 26 - TICA2" },
	{  5759, "Milano/Via Caldera 21 - ATMI1" },
	{  5760, "Tbilisi, International Exchange" },
	{  5761, "Tbilisi, International Exchange" },
	{  5762, "Tbilisi, Mobile Switching Centre" },
	{  5763, "Tbilisi, Mobile Switching Centre" },
	{  5764, "Tbilisi, Mobile Switching Centre" },
	{  5765, "Tbilisi, International Exchange" },
	{  5766, "Tbilisi, Mobile Switching Centre" },
	{  5767, "Tbilisi, Mobile Switching Centre" },
	{  5768, "N2P UK 1" },
	{  5769, "Southern Transit" },
	{  5770, "Marathon Telecom" },
	{  5771, "London" },
	{  5772, "Yorkshire Transit" },
	{  5773, "LND 01 Docklands" },
	{  5774, "LND 02" },
	{  5775, "EPSILON-VERAZ" },
	{  5776, "DDCLZTE1" },
	{  5777, "DDCLZTE1" },
	{  5778, "Lannet London 5" },
	{  5779, "LMUK-MSC1" },
	{  5781, "ipLCR Poplar" },
	{  5783, "Fleet" },
	{  5784, "BM1" },
	{  5785, "Reading-M64" },
	{  5787, "Chet" },
	{  5791, "Beckton GMSC1 (KT9)" },
	{  5793, "Monor_INT1" },
	{  5794, "M2-MSC-PC2" },
	{  5797, "M1-SG/STP-PC2" },
	{  5798, "Pannon INT1" },
	{  5799, "M2-SG/STP-PC2" },
	{  5801, "Tbilisi, International Exchange" },
	{  5802, "Rustavi, PSTN Switch" },
	{  5803, "Tbilisi, International Exchange" },
	{  5805, "Tbilisi, International Exchange" },
	{  5806, "Tbilisi, International Exchange" },
	{  5807, "Tbilisi, PSTN Switch" },
	{  5808, "KIVISC1" },
	{  5809, "LVVISC2" },
	{  5810, "Kyiv ISC_1" },
	{  5812, "GTISC" },
	{  5814, "KIMG4" },
	{  5815, "DNMG1" },
	{  5816, "Roma/Via Casilina Vecchia, 84 c/o Staz. Tuscolana" },
	{  5817, "Bologna/v. le C. Berti Pichat 2/4" },
	{  5818, "Verona\\via del perlar, 26" },
	{  5819, "Roma/via A. Severo, 246 - HGRM2" },
	{  5820, "Bergamo/via Stendhal 3" },
	{  5821, "Milano/via Giacosa 19 - TIMI2" },
	{  5822, "Milano/via Giacosa 19 - TIMI3" },
	{  5823, "Milano/via Giacosa 19 - TIMI4" },
	{  5824, "Torino corso Tazzoli - PMTO7" },
	{  5825, "MILANO VIA LANCETTI - PMMI7" },
	{  5826, "Milano/via Tortona 26" },
	{  5827, "Roma/via G.V. Bona 67 Ed. B - CTRM2" },
	{  5828, "Roma/via G.V. Bona 67 Ed. B - CTRM3" },
	{  5829, "Milano/via Ugo Bassi 2" },
	{  5830, "KyivISC" },
	{  5831, "Milano via caldera - DYMI2" },
	{  5833, "Copenhagen" },
	{  5841, "IATC SA2/Sarajevo" },
	{  5842, "SS MNC SA3" },
	{  5843, "Siroki Brijeg" },
	{  5844, "Mostar" },
	{  5846, "Sarajevo/STPSA" },
	{  5847, "Zenica/STPZE" },
	{  5848, "T3/SA1 Sarajevo" },
	{  5850, "Logosoft/ SA1 Sarajevo" },
	{  5852, "Akt.Ol./Sa1 Sarajevo" },
	{  5853, "BAEPNSA1 Sarajevo" },
	{  5854, "Aneks/BL1 Banjaluka" },
	{  5855, "MH-INAt-33 Sarajevo" },
	{  5856, "STP Skopje" },
	{  5857, "SK2" },
	{  5858, "ST" },
	{  5859, "STP Skopje" },
	{  5860, "STP Stip" },
	{  5861, "MSC1INT" },
	{  5862, "STP Skopje" },
	{  5863, "MSCBL1 (SPX1)" },
	{  5864, "Orange - Paris Pastourelle - Call Server YK01" },
	{  5865, "Orange - Reims - Call Server VOIP YK00" },
	{  5866, "Budget Telecom - Paris" },
	{  5867, "SFR -Mitry-04" },
	{  5868, "SFR -Corbas-01" },
	{  5870, "Transatel - Paris 2" },
	{  5871, "Orange - Paris Roaming Hub" },
	{  5872, "Frankfurt" },
	{  5873, "Ratingen" },
	{  5874, "Frankfurt" },
	{  5875, "Essen" },
	{  5876, "Berlin" },
	{  5877, "Frankfurt" },
	{  5878, "ITP1_FRANKFURT_KDG" },
	{  5879, "Berlin" },
	{  5880, "NOWO (LSBNPTCB01V) PALMELA" },
	{  5881, "NOWO (ESTRPOCB02V) ESTARREJA" },
	{  5882, "NOWO (G9S01) LISBOA" },
	{  5883, "NOWO (G9S02) PORTO" },
	{  5884, "ARTELECOM (ALC01-SSW02) LISBOA" },
	{  5885, "Lisboa - LISBSC2ARTELECOM (ALC01-MGW03) LISBOA" },
	{  5886, "ALF1FS" },
	{  5887, "BOA1FS" },
	{  5888, "Chisinau" },
	{  5889, "Balti" },
	{  5890, "Chisinau" },
	{  5891, "Chisinau" },
	{  5894, "Chisinau" },
	{  5895, "Chisinau" },
	{  5896, "Frankfurt" },
	{  5897, "Hannover" },
	{  5898, "Frankfurt" },
	{  5899, "Frankfurt" },
	{  5900, "Berlin" },
	{  5901, "Düsseldorf" },
	{  5902, "München" },
	{  5903, "Frankfurt" },
	{  5904, "Frankfurt" },
	{  5905, "Düsseldorf" },
	{  5906, "Frankfurt" },
	{  5907, "Hamburg" },
	{  5908, "Frankfurt" },
	{  5909, "Düsseldorf" },
	{  5910, "Ratingen" },
	{  5911, "Frankfurt" },
	{  5912, "Bucuresti" },
	{  5913, "Bucuresti" },
	{  5914, "Bucuresti" },
	{  5915, "Brasov" },
	{  5916, "Brasov" },
	{  5917, "Brasov" },
	{  5918, "Brasov" },
	{  5919, "Bucuresti" },
	{  5921, "Praha, SA-STP" },
	{  5922, "Brno, SA STP" },
	{  5925, "SZDC" },
	{  5926, "CEZnet Praha CZ" },
	{  5928, "BT Czech Republic" },
	{  5929, "Praha, International exchange" },
	{  5930, "Brno, International exchange" },
	{  5932, "Praha CS" },
	{  5933, "Brno CS" },
	{  5937, "MSS HRK 1" },
	{  5939, "TS1PG" },
	{  5940, "TS1BM" },
	{  5941, "SAPH" },
	{  5942, "SABO" },
	{  5943, "MSS BRN" },
	{  5947, "SZDC" },
	{  5948, "SRP1 Praha" },
	{  5949, "SRP2 Brno" },
	{  5950, "DIAL-PRAHA CZ" },
	{  5951, "MSS PRC 1" },
	{  5952, "ISC Bratislava" },
	{  5953, "Bratislava, international gateway" },
	{  5954, "Banská Bystrica, international gateway" },
	{  5955, "ISC Bratislava" },
	{  5956, "SA STP" },
	{  5957, "SA STP" },
	{  5958, "LES12 Bratislava Test 3" },
	{  5959, "LES12 Bratislava Test 2" },
	{  5960, "STP GTS Nextra, Bratislava" },
	{  5961, "ISC Bratislava" },
	{  5962, "ISC Bratislava" },
	{  5963, "ISC Bratislava" },
	{  5964, "ISC Bratislava" },
	{  5965, "ISC/softswitch Bratislava" },
	{  5967, "ISC Bratislava" },
	{  5968, "ISC Bratislava" },
	{  5969, "MSC1 Banská Bystrica" },
	{  5970, "ISC Bratislava" },
	{  5971, "MSC7 Bratislava" },
	{  5972, "MSC5 Banská Bystrica" },
	{  5973, "MSC2 Bratislava" },
	{  5974, "ISC Bratislava" },
	{  5975, "ISC Bratislava" },
	{  5976, "Bratislava, NMT" },
	{  5977, "Banská Bystrica, GSM MSC1" },
	{  5978, "Bratislava, GSM MSC1" },
	{  5979, "Bratislava, GSM MSC2" },
	{  5980, "Banská Bystrica, GSM MSC2" },
	{  5981, "Bratislava, GSM MSC3" },
	{  5982, "MSC1 Bratislava" },
	{  5983, "Kosice, GSM MSC4" },
	{  5984, "..." },
	{  5985, "" },
	{  5986, "" },
	{  5987, "" },
	{  5988, "\\" },
	{  5989, "\\" },
	{  5990, "..." },
	{  5991, "" },
	{  5992, "Madrid-Atocha" },
	{  5993, "Madrid-Bellas Vistas" },
	{  5994, "Barcelona-Guipúzcoa" },
	{  5995, "Barcelona-Cerdá" },
	{  5996, "" },
	{  5997, "" },
	{  5998, "Madrid" },
	{  5999, "Madrid" },
	{  6000, "Madrid" },
	{  6001, "" },
	{  6002, "Barcelona" },
	{  6003, "" },
	{  6004, "Madrid" },
	{  6005, "Barcelona" },
	{  6006, "Madrid" },
	{  6007, "Barcelona" },
	{  6009, "" },
	{  6010, "" },
	{  6014, "" },
	{  6015, "" },
	{  6016, "Madrid" },
	{  6017, "Madrid" },
	{  6018, "Madrid" },
	{  6019, "" },
	{  6020, "Barcelona" },
	{  6022, "Barcelona" },
	{  6024, "" },
	{  6026, "Barcelona" },
	{  6027, "Madrid" },
	{  6028, "" },
	{  6029, "Manresa" },
	{  6030, "" },
	{  6032, "München" },
	{  6033, "Frankfurt" },
	{  6034, "Hamburg" },
	{  6035, "ITP2_BERLIN_KDG" },
	{  6036, "Frankfurt" },
	{  6037, "Frankfurt" },
	{  6038, "SSTPFRAAC" },
	{  6039, "Frankfurt" },
	{  6040, "Dortmund" },
	{  6041, "Frankfurt" },
	{  6042, "Frankfurt" },
	{  6043, "Frankfurt" },
	{  6044, "Düsseldorf" },
	{  6045, "Frankfurt" },
	{  6046, "Frankfurt" },
	{  6047, "Frankfurt" },
	{  6048, "Stuttgart" },
	{  6049, "Düsseldorf" },
	{  6050, "Düsseldorf" },
	{  6051, "Frankfurt" },
	{  6052, "Frankfurt" },
	{  6053, "Frankfurt" },
	{  6054, "Frankfurt" },
	{  6055, "Frankfurt" },
	{  6056, "Düsseldorf" },
	{  6057, "München" },
	{  6058, "München" },
	{  6059, "Düsseldorf" },
	{  6060, "Frankfurt" },
	{  6061, "Frankfurt" },
	{  6062, "Wuerzburg" },
	{  6063, "Flensburg" },
	{  6064, "Frankfurt" },
	{  6065, "Köln" },
	{  6066, "Düsseldorf" },
	{  6067, "Eschborn" },
	{  6068, "Hamburg" },
	{  6069, "Frankfurt" },
	{  6070, "Frankfurt" },
	{  6071, "Karlsruhe" },
	{  6072, "Hamburg" },
	{  6073, "Frankfurt" },
	{  6074, "Frankfurt" },
	{  6075, "Frankfurt" },
	{  6076, "Berlin" },
	{  6077, "51-418-1627" },
	{  6078, "Frankfurt" },
	{  6079, "Mannheim" },
	{  6080, "Frankfurt" },
	{  6081, "Frankfurt" },
	{  6082, "MSS_FFT1" },
	{  6083, "Aachen" },
	{  6084, "Drillisch-Mobil-Duesseldorf" },
	{  6085, "Düsseldorf" },
	{  6086, "AlpTelco-Archway-02" },
	{  6087, "Berlin" },
	{  6088, "Hilden" },
	{  6089, "Frankfurt" },
	{  6090, "51-418-1627" },
	{  6091, "Frankfurt" },
	{  6092, "Frankfurt" },
	{  6093, "Frankfurt" },
	{  6094, "Saarbrücken" },
	{  6095, "Frankfurt" },
	{  6096, "Frankfurt" },
	{  6097, "Frankfurt" },
	{  6098, "Völklingen" },
	{  6099, "Frankfurt" },
	{  6100, "STP_FFT1" },
	{  6101, "Frankfurt" },
	{  6102, "Frankfurt" },
	{  6103, "Stuttgart" },
	{  6104, "Hamburg" },
	{  6105, "Düsseldorf" },
	{  6106, "Offenbach" },
	{  6107, "Frankfurt" },
	{  6108, "Hannover" },
	{  6109, "Duesseldorf" },
	{  6110, "Drillisch-Mobil-Frankfurt" },
	{  6111, "Düsseldorf" },
	{  6112, "Frankfurt" },
	{  6113, "Frankfurt" },
	{  6114, "Essen" },
	{  6115, "Hannover" },
	{  6116, "Leinfelden-Echterdingen" },
	{  6117, "Frankfurt" },
	{  6118, "Frankfurt" },
	{  6119, "Stuttgart" },
	{  6120, "QUNL01, Zoetermeer, Chroomst" },
	{  6123, "AMSTERDAM SSP, Amsterdam" },
	{  6124, "ROTTERDAM SSP, Rotterdam" },
	{  6125, "ASDSTP, Amsterdam, Hemweg 6P" },
	{  6126, "ProRail GSM-R Nederland, A Fokkerwg 40 3088GG Rotterdam" },
	{  6127, "Carrier to Carrier, Biddinghuizen" },
	{  6128, "Helsinki (HKISTP4)" },
	{  6129, "Helsinki (SMS01HKI)" },
	{  6130, "Helsinki (Globetel1)" },
	{  6133, "Tampere (TRESTP5)" },
	{  6135, "MSCSHE6, MSC, Helsinki" },
	{  6138, "Helsinki MGW (FI1_MGW)" },
	{  6139, "Lahti (MGLAH05, MediaGateway)" },
	{  6141, "Helsinki (MGHEL06, MediaGateway)" },
	{  6176, "VPA1" },
	{  6177, "VPD1" },
	{  6178, "réservé/reserved/reservado" },
	{  6179, "réservé/reserved/reservado" },
	{  6180, "VPC3" },
	{  6181, "réservé/reserved/reservado" },
	{  6182, "T6X1" },
	{  6183, "TCU" },
	{  6184, "TTP1" },
	{  6185, "..." },
	{  6186, "VPC1" },
	{  6187, "TTP1" },
	{  6188, "TOR2" },
	{  6189, "TOR2" },
	{  6190, "..." },
	{  6191, "réservé/reserved/reservado" },
	{  6192, "MTP1" },
	{  6193, "LBM1" },
	{  6194, "MTL2" },
	{  6195, "réservé/reserved/reservado" },
	{  6196, "MTL2" },
	{  6197, "..." },
	{  6198, "..." },
	{  6199, "..." },
	{  6200, "DMS-250-Toronto 13" },
	{  6201, "DMS-250-Toronto 14" },
	{  6202, "Toronto STP" },
	{  6203, "Montreal DMS - 250" },
	{  6206, "Vancouver DMS-250" },
	{  6207, "Telus Communications Inc." },
	{  6208, "Rexdale" },
	{  6209, "Toronto" },
	{  6210, "Toronto - Mathew" },
	{  6211, "CLGRAB2116W" },
	{  6212, "EDTNAB0214W" },
	{  6213, "Ericsson Trans Local Axe-10, Toronto" },
	{  6214, "YVRLX20 (London, United Kingdom)" },
	{  6215, "Alcatel DSC 600E" },
	{  6216, "Siemens DCO" },
	{  6217, "VANCBC0802T" },
	{  6218, "VAN IPTC-1" },
	{  6219, "TOR IPTC-1" },
	{  6220, "TOR IPTC-2" },
	{  6221, "MTL IPTC-1" },
	{  6222, "MTL IPTC-2" },
	{  6223, "TREXSS1" },
	{  6224, "EYRKONAE01T" },
	{  6225, "Smiths Falls Gateway" },
	{  6226, "..." },
	{  6227, "A4C1" },
	{  6228, "A5C1" },
	{  6229, "FYV1" },
	{  6230, "reserved" },
	{  6231, "VPP1" },
	{  6232, "LDP1" },
	{  6233, "FVP1" },
	{  6234, "SGX SSP (Scarborough, Ontario)" },
	{  6235, "GSX1 SSP (Scarborough, Ontario)" },
	{  6236, "GSX2 SSP (Scarborough, Ontario)" },
	{  6237, "GSX3 SSP (Scarborough, Ontario)" },
	{  6238, "SGX SSP (Montreal, Quebec)" },
	{  6239, "GSX1 SSP (Montreal, Quebec)" },
	{  6240, "GSX2 SSP (Montreal, Quebec)" },
	{  6241, "GSX3 SSP (Montreal, Quebec)" },
	{  6242, "RMHLONBICA5 (Richmond Hill, Ontario)" },
	{  6243, "3000 (CLLI: TOROONXN18T), Toronto, Ontario" },
	{  6245, "IRISTEL INC., Toronto, Ontario" },
	{  6246, "DCP2 STP1" },
	{  6247, "DCP1 STP1" },
	{  6272, "St. Pierre-et-Miquelon E10" },
	{  6280, "Anenii Noi" },
	{  6288, "NUK-MC_INT" },
	{  6289, "CTP-1_INT" },
	{  6290, "CTP-2_INT" },
	{  6304, "New York, NY" },
	{  6305, "White Plains, NY" },
	{  6306, "Harrisburg (1), PA" },
	{  6307, "White Plains, NY" },
	{  6308, "Sacramento, CA" },
	{  6309, "Sherman Oaks" },
	{  6310, "San Diego" },
	{  6311, "Warrenville, IL" },
	{  6312, "West Orange (2), NJ" },
	{  6313, "Chicago, IL" },
	{  6314, "Plattsburg, NY" },
	{  6315, "Madison, WI" },
	{  6316, "West Orange, NJ" },
	{  6317, "Dominguez Hills, CA" },
	{  6318, "San Antonio, TX" },
	{  6319, "Pottstown, PA" },
	{  6320, "Wichita Falls, TX" },
	{  6321, "Pompano Beach, FL" },
	{  6322, "Pottstown, PA" },
	{  6323, "Chicago, IL" },
	{  6324, "Dallas, TX" },
	{  6325, "Dallas (1), TX" },
	{  6326, "San Antonio, TX" },
	{  6327, "Harrisburg (2), PA" },
	{  6328, "Sacramento, CA" },
	{  6329, "Sherman Oaks" },
	{  6330, "Pittsburg, PA" },
	{  6331, "Atlanta" },
	{  6332, "New York, NY" },
	{  6333, "Honolulu, HI" },
	{  6334, "Stockton" },
	{  6335, "Dominguez Hills (1), CA" },
	{  6336, "Dominguez Hills (2), CA" },
	{  6337, "Irving (1), TX" },
	{  6338, "Sacremento, CA" },
	{  6339, "Tampa, FL" },
	{  6340, "Fort Worth" },
	{  6341, "Dallas, TX" },
	{  6342, "Fort Worth(2)" },
	{  6343, "Pittsburg(3), PA" },
	{  6344, "Chicago. IL" },
	{  6345, "Dallas (6), TX" },
	{  6346, "Dallas (7), TX" },
	{  6347, "Albuquerque" },
	{  6348, "San Antonio" },
	{  6349, "Honolulu, HI" },
	{  6350, "Los Angeles (1), CA" },
	{  6351, "Los Angeles (2), CA" },
	{  6352, "New York City, NY" },
	{  6353, "Los Angeles, CA" },
	{  6354, "Tampa, FL" },
	{  6355, "Sacremento, CA" },
	{  6356, "Wentzville, MO" },
	{  6357, "Dallas (5), TX" },
	{  6358, "Caparra, PR" },
	{  6359, "New York, NY" },
	{  6360, "Miami, FL" },
	{  6362, "Garden City, NY" },
	{  6363, "Los Angeles (2),CA" },
	{  6364, "Miami, FL" },
	{  6365, "Chicago (1), IL" },
	{  6366, "Chicago (2), IL" },
	{  6367, "New York, NY" },
	{  6368, "New York, NY" },
	{  6369, "Los Angeles, CA" },
	{  6370, "New York, NY" },
	{  6371, "Miami, FL" },
	{  6372, "Hollywood, FL" },
	{  6373, "Miami, FL" },
	{  6374, "Garden City, NY" },
	{  6375, "Ft. Lauderdale, FL (STP)" },
	{  6376, "Ft. Lauderdale FL (Gateway)" },
	{  6377, "New York, NY (STP)" },
	{  6378, "New York, NY (Gateway)" },
	{  6379, "San Juan, Puerto Rico" },
	{  6380, "Miami, FL" },
	{  6381, "New York, NY" },
	{  6382, "Dallas, TX" },
	{  6383, "Olympia, WA" },
	{  6384, "Miami, FL" },
	{  6385, "Temple Terrace (1), FL" },
	{  6386, "Temple Terrace (2), FL" },
	{  6387, "Temple Terrace (3), FL" },
	{  6388, "Temple Terrace (4), FL" },
	{  6389, "Temple Terrace (5), FL" },
	{  6390, "Temple Terrace (6), FL" },
	{  6391, "Los Angeles, CA" },
	{  6392, "Temple Terrace, FL" },
	{  6393, "New York, NY" },
	{  6394, "San Francisco, CA" },
	{  6395, "Newark, NJ" },
	{  6396, "New York City, NY" },
	{  6397, "Washington DC" },
	{  6398, "Honolulu (2), HI" },
	{  6399, "Honolulu (3), HI" },
	{  6400, "Los Angeles, CA" },
	{  6401, "Jersey City, NJ" },
	{  6402, "West Orange (1), NJ" },
	{  6403, "Irving (2), TX" },
	{  6404, "Pompano Beach, FL" },
	{  6405, "Pompano Beach, FL" },
	{  6406, "Chandler (1), AZ" },
	{  6407, "Chandler (2), AZ" },
	{  6408, "Tempe, AZ" },
	{  6409, "New York, NY" },
	{  6410, "New York (2), NY" },
	{  6411, "Los Angeles,CA" },
	{  6412, "New York, NY" },
	{  6413, "Miami, FL" },
	{  6414, "Southbury, CT" },
	{  6415, "Santa Paula, CA" },
	{  6416, "Miami, FL" },
	{  6417, "New York, NY" },
	{  6418, "New York, NY" },
	{  6419, "New York, NY(2)" },
	{  6420, "Dallas, TX" },
	{  6421, "Los Angeles, CA" },
	{  6422, "McLean, VA" },
	{  6423, "Newark, NJ" },
	{  6424, "Piscataway, NJ" },
	{  6425, "New York, NY" },
	{  6426, "Dallas, TX" },
	{  6427, "Burlingame, CA" },
	{  6428, "Newark, NJ" },
	{  6429, "New York (1), NY" },
	{  6430, "New York (2), NY" },
	{  6431, "Wentzville, MO" },
	{  6432, "O'Fallon, MO" },
	{  6433, "Miami, FL" },
	{  6434, "Miami, FL" },
	{  6435, "Miami, FL" },
	{  6436, "Santa Paula, CA" },
	{  6437, "Dallas, TX" },
	{  6438, "Seattle, WA" },
	{  6439, "Miami, FL" },
	{  6440, "Pittsburgh, PA" },
	{  6441, "Pittsburg, PA" },
	{  6442, "White Plains, NY" },
	{  6443, "Sacramento, CA" },
	{  6444, "Sherman Oaks, CA" },
	{  6445, "Atlanta, GA" },
	{  6446, "Miami, FL" },
	{  6447, "Atlanta (1), GA" },
	{  6448, "Atlanta (2), GA" },
	{  6449, "New York, NY" },
	{  6450, "Miami (1), FL" },
	{  6451, "New York, NY" },
	{  6452, "San Francisco, CA" },
	{  6453, "Miami, FL" },
	{  6454, "Miami, FL" },
	{  6455, "New York, NY" },
	{  6456, "Miami, FL" },
	{  6457, "Oak Hill, VA" },
	{  6458, "Oak Hill, VA" },
	{  6459, "Jersey City, NJ" },
	{  6460, "Miami, FL" },
	{  6461, "Miami, FL" },
	{  6462, "New York, NY" },
	{  6463, "New York, NY" },
	{  6464, "Miami, FL" },
	{  6465, "New York, NY" },
	{  6466, "Miami, FL" },
	{  6467, "New York, NY" },
	{  6468, "Piscataway, NJ" },
	{  6469, "Washington, D.C." },
	{  6470, "Dallas, TX" },
	{  6471, "New York, NY" },
	{  6472, "New York, NY" },
	{  6473, "Los Angeles, CA" },
	{  6474, "Jersey City, NJ" },
	{  6475, "d/b/a GSI Telecom, Jersey City, NJ" },
	{  6476, "Jersey City, NJ" },
	{  6477, "New York City, NY" },
	{  6478, "New York, NY" },
	{  6479, "Quincy, MA" },
	{  6480, "Orlando, FL" },
	{  6481, "Los Angeles, CA" },
	{  6482, "Seattle, WA" },
	{  6483, "Los Angeles (2), CA" },
	{  6484, "Los Angeles, CA" },
	{  6485, "Seattle, WA" },
	{  6486, "New York, NY" },
	{  6487, "Dallas, TX" },
	{  6488, "Mc Lean, VA" },
	{  6489, "New York, NY" },
	{  6490, "Miami, FL" },
	{  6491, "New York, NY" },
	{  6492, "Los Angeles, CA" },
	{  6493, "Miami, FL" },
	{  6495, "New York, NY" },
	{  6496, "Miami, FL" },
	{  6497, "Los Angeles, CA" },
	{  6498, "New York, NY" },
	{  6499, "Los Angeles, CA" },
	{  6500, "Los Angeles, CA" },
	{  6501, "New York, NY" },
	{  6502, "New York, NY" },
	{  6503, "New York, NY" },
	{  6504, "Los Angeles, CA" },
	{  6505, "Richardson, TX" },
	{  6506, "Miami, FL" },
	{  6507, "Pottstown, PA" },
	{  6508, "Dallas, TX" },
	{  6509, "Hayward, CA" },
	{  6510, "Jersey City (1), NJ" },
	{  6511, "Jersey City (2), NJ" },
	{  6512, "Atlanta, GA" },
	{  6513, "Sunnyvale, CA" },
	{  6514, "Dublin, OH" },
	{  6515, "Houston, TX" },
	{  6516, "Dublin, OH" },
	{  6517, "Houston, TX" },
	{  6518, "Southbury, CT" },
	{  6519, "Paumalu, HI" },
	{  6520, "Los Angeles, CA" },
	{  6521, "Los Angeles, CA" },
	{  6522, "Manhattan, NY" },
	{  6523, "Los Angeles, CA" },
	{  6524, "Piscataway, NJ" },
	{  6525, "New York (1), NY" },
	{  6526, "New York (2), NY" },
	{  6527, "College Park (1), GA" },
	{  6528, "Atlanta, GA" },
	{  6529, "College Park (2), GA" },
	{  6530, "Homestead, FL" },
	{  6532, "Los Angeles (1), CA" },
	{  6533, "Westmont, IL" },
	{  6534, "San Francisco, CA" },
	{  6535, "New York, NY" },
	{  6536, "New York, NY" },
	{  6537, "Los Angeles (2), CA" },
	{  6538, "Los Angeles (3), CA" },
	{  6539, "Los Angeles (4), CA" },
	{  6540, "New York (1), NY" },
	{  6541, "Piscataway, NJ" },
	{  6542, "Irvine, CA" },
	{  6543, "Los Angeles, CA" },
	{  6544, "Manhattan, NY" },
	{  6545, "Los Angeles, CA" },
	{  6546, "Melbourne, FL" },
	{  6547, "Oak Hill, VA" },
	{  6548, "Harrisburg (3), PA" },
	{  6549, "New York, NY" },
	{  6550, "Fresno, CA" },
	{  6551, "Ft. Lauderdale, FL" },
	{  6552, "New York, NY" },
	{  6554, "Los Angeles, CA" },
	{  6555, "New York, NY" },
	{  6556, "New York, NY" },
	{  6557, "Miami, FL" },
	{  6558, "Austin, TX" },
	{  6559, "Los Angeles, CA" },
	{  6560, "Miami, FL" },
	{  6561, "Miami, FL" },
	{  6562, "Los Angeles, CA" },
	{  6563, "New York, NY" },
	{  6564, "Los Angeles, CA" },
	{  6565, "Oakland, CA" },
	{  6566, "Laredo, TX" },
	{  6567, "Staten Island, NY" },
	{  6568, "New York, NY" },
	{  6569, "New York, NY" },
	{  6570, "Elmsford, NY" },
	{  6571, "New York, NY" },
	{  6572, "New York, NY" },
	{  6573, "Wilton Manors, FL" },
	{  6574, "New York, NY" },
	{  6575, "Staten Island, NY" },
	{  6576, "" },
	{  6577, "" },
	{  6578, "" },
	{  6579, "Seattle,WA" },
	{  6580, "Seattle, WA" },
	{  6581, "Seattle, WA" },
	{  6582, "Leesburg, VA" },
	{  6583, "Reston, VA" },
	{  6584, "Reston, VA" },
	{  6585, "New York, NY" },
	{  6586, "Phoenix, AZ" },
	{  6587, "Dallas, TX" },
	{  6588, "New York, NY" },
	{  6589, "Los Angeles, CA" },
	{  6590, "Fremont, CA" },
	{  6591, "Jackson Heights, NY" },
	{  6592, "Rialto, CA" },
	{  6593, "Los Angeles, CA" },
	{  6594, "Los Angeles, CA" },
	{  6595, "Miami, FL" },
	{  6596, "Miami, FL" },
	{  6597, "Brewster, WA" },
	{  6598, "Brewster, WA" },
	{  6599, "Jersey City, NJ" },
	{  6600, "Miramar, FL" },
	{  6601, "Coconut Grove, FL" },
	{  6602, "Madison, WI" },
	{  6603, "Sacramento (3), CA" },
	{  6604, "Las Vegas" },
	{  6605, "Sacramento (5), CA" },
	{  6606, "Las Vegas (2)" },
	{  6607, "Miami, FL" },
	{  6608, "Los Angeles, CA" },
	{  6609, "Miami, FL" },
	{  6610, "New York, NY" },
	{  6611, "New York, NY" },
	{  6612, "New York, NY" },
	{  6613, "Atlanta, GA" },
	{  6614, "White Plains, NY" },
	{  6615, "Miami, FL" },
	{  6616, "New York, NY" },
	{  6617, "New York, NY" },
	{  6618, "San Antonio, TX" },
	{  6619, "New York, NY" },
	{  6620, "Newark, NJ" },
	{  6622, "Miami, FL" },
	{  6623, "Miami, FL" },
	{  6624, "San Juan, PR" },
	{  6688, "Marcatel Com, S.A. de C.V.-MTY, Monterrey N.L." },
	{  6689, "Mexico CTSJ CIM, México D.F." },
	{  6690, "Monterrey Revolución A CTI, México D.F." },
	{  6691, "Marcatel Com, S.A. de C.V.-MTY, Monterrey N.L." },
	{  6692, "Marcatel Com, S.A. de C.V.-MTY, Monterrey N.L." },
	{  6693, "Pio Pico CTI, Tijuana BCN" },
	{  6694, "Gonzalez Ortega CTI, Mexicali BCN" },
	{  6695, "Del Valle, Mexico D.F." },
	{  6696, "Reserved" },
	{  6697, "Tulancingo CM, Tulancingo, Hgo." },
	{  6698, "Guadalajara CTI-2 (Tlaquepaque)" },
	{  6699, "Guadalajara CTI-2 (CTG)" },
	{  6700, "Mexicali (Gonzalez. Ortega)" },
	{  6701, "Monterrey CTI-1 (Mayo)" },
	{  6702, "Mexico Nextengo CI, México D.F." },
	{  6703, "Hidalgo MTY, Monterrey" },
	{  6704, "MSSCTulancingo Hgo" },
	{  6705, "Celaya CTI-1 (Aztecas)" },
	{  6706, "Celaya CTI-2 (Corregidora)" },
	{  6707, "México PTS CTSJ INT.1" },
	{  6708, "Chihuahua CTI-2 (Centauro)" },
	{  6709, "Chihuahua CTI-1 (Catedral)" },
	{  6710, "Hermosillo CTI-2 (Yaqez)" },
	{  6711, "Hermosillo CTI-1 (Garmendia)" },
	{  6712, "Tijuana (Pio Pico)" },
	{  6713, "Cuernavaca CTI-1 (Borda)" },
	{  6714, "Cuernavaca CTI-2 (Mirador)" },
	{  6715, "Coatzacoalcos CTI-1 (Ignacio de la Llave)" },
	{  6716, "Coatzacoalcos CTI-2 (Hidalgo)" },
	{  6717, "Puebla CTI-1 (CTP)" },
	{  6718, "Puebla CTI-2 (Fuertes)" },
	{  6719, "México Nextengo Int. 2" },
	{  6720, "MXOT Mexico DF STP" },
	{  6721, "GDJT Guadalajara JAL STP" },
	{  6722, "RADE Monterrey NL DMS 250" },
	{  6723, "MX01 Mexico DF DMS 250" },
	{  6724, "MTY1, Apodaca N.L." },
	{  6725, "GDJ1 Guadalajara JAL DMS 250" },
	{  6726, "RADG Monterrey NL STP" },
	{  6727, "MX02 Tlalnepantla Mex." },
	{  6728, "Reserved" },
	{  6729, "Pasteje DMS 300-250" },
	{  6730, "Reserved" },
	{  6731, "Reserved" },
	{  6732, "Pasteje STP" },
	{  6733, "Guadalajara STP" },
	{  6734, "Reserved" },
	{  6735, "Reserved" },
	{  6736, "MNTRXLAD Monterrey" },
	{  6737, "TLPNXMAA Mexico" },
	{  6738, "ZPPNJAAA Guadalajara" },
	{  6739, "TIJNXBAB Tijuana" },
	{  6740, "CDJRXHAD Ciudad Juárez, Chih." },
	{  6741, "Reserved" },
	{  6742, "Reserved" },
	{  6743, "Reserved" },
	{  6744, "Reserved" },
	{  6745, "Central Mexico D.F." },
	{  6746, "Guadalajara Jal." },
	{  6747, "Monterrey N.L." },
	{  6748, "Central Tijuana BCN" },
	{  6749, "Reserved" },
	{  6750, "Reserved" },
	{  6751, "Reserved" },
	{  6752, "..." },
	{  6753, "Kingston" },
	{  6754, "..." },
	{  6755, "..." },
	{  6756, "..." },
	{  6757, "..." },
	{  6758, "..." },
	{  6759, "..." },
	{  6760, "..." },
	{  6761, "..." },
	{  6762, "..." },
	{  6763, "..." },
	{  6764, "..." },
	{  6765, "Kingston" },
	{  6766, "Kingston" },
	{  6770, "Kingston" },
	{  6771, "Kingston" },
	{  6772, "Kingston" },
	{  6773, "Kingston" },
	{  6774, "Kingston" },
	{  6775, "Kingston" },
	{  6776, "Kingston" },
	{  6778, "..." },
	{  6779, "..." },
	{  6816, "DMS-300 International Gateway Switch 1995" },
	{  6817, "Roaming Replicator GSM Platform 2004" },
	{  6818, "GSM MSC: GSM cellular switch 2003" },
	{  6819, "GSM HLR: GSM subscriber database platform 2003" },
	{  6820, "BAR BB STP-C1 signalling platform 1998" },
	{  6821, "GSM VMS: GSM Voicemail Platform 2003" },
	{  6822, "BAR CS2K: International Packet Gateway Switch 2001" },
	{  6823, "Verisign 1-800call-USA, Phone/Credit card calling platform 2003" },
	{  6824, "Call completion and information transfer between global networks" },
	{  6825, "Call completion and information transfer between global networks" },
	{  6826, "International Gateway for MSC" },
	{  6827, "Comverie pre-paid system (PPS)" },
	{  6828, "Domestic termination on termination of inbound traffic" },
	{  6829, "Transit traffic through Barbados to other islands in the eastern Carib" },
	{  6830, "Transfer calls destined for Barbados via Cable & Wireless (Barbados)" },
	{  6831, "Interconnect with Cable & Wireless (Barbados) Ltd" },
	{  6832, "GSM HLR" },
	{  6833, "GSM Prepaid SCP" },
	{  6834, "GSM Voice Mail" },
	{  6835, "Interconnection with Cable & Wireless" },
	{  6836, "Interconnection with Cable & Wireless" },
	{  6837, "Interconnect with Cable & Wireless" },
	{  6848, "NEAX61E INTS" },
	{  6849, "Ericsson APG40 MSC" },
	{  6850, "SS8 Voicemail" },
	{  6851, "BCG prepaid" },
	{  6852, "Voicemail 1" },
	{  6853, "Voicemail 2" },
	{  6854, "ANMUBSC41 E3" },
	{  6855, "DMS MSC" },
	{  6880, "ISC Current Gateway" },
	{  6881, "1 Tech Sq Call Server" },
	{  6882, "1 Tech Sq USP" },
	{  6883, "1 Tech Sq STP" },
	{  6884, "High Rock Call Server" },
	{  6885, "MSC Switch" },
	{  6886, "MSC" },
	{  6889, "WES-BTS-INT-01" },
	{  6890, "One Int 01" },
	{  6891, "G.T. Server 1" },
	{  6892, "G.T. Server 2" },
	{  6912, "Chalwell ITP-1" },
	{  6913, "Road Town DMS-100" },
	{  6914, "Chalwell TDMA" },
	{  6916, "Road Town CS2K" },
	{  6917, "Road Town Broadband STP" },
	{  6918, "Chalwell Teeno SCP" },
	{  6919, "Road town Nokia MSC" },
	{  6920, "Chalwell ITP-2" },
	{  6921, "BVI-MSC1" },
	{  6945, "DV1" },
	{  6946, "DV2" },
	{  6947, "TB1" },
	{  6948, "Q1" },
	{  6949, "Q2" },
	{  6976, "Mount Hartman Exchange" },
	{  6978, "Morne Jaloux Exchange" },
	{  6979, "Tempe St. Georges Exchange" },
	{  7040, "Ponds-Needsmust Exchange" },
	{  7041, "Needsmust Exchange" },
	{  7043, "La Guerite Exchange" },
	{  7073, "Sans Soucis Exchange" },
	{  7074, "Vieux Exchange" },
	{  7075, "Marisule Exchange" },
	{  7076, "Marisule Exchange" },
	{  7104, "Arnos Vale Exchange" },
	{  7105, "Arnos Vale Mobile Exchange" },
	{  7106, "Arnos Vale Prepaid Platform" },
	{  7136, "Curaçao 1" },
	{  7137, "Sint Maarten" },
	{  7138, "Curaçao 1" },
	{  7139, "Curaçao/ANM" },
	{  7140, "Curaçao 2" },
	{  7141, "Bonaire/Telbo" },
	{  7142, "Curaçao/GSN" },
	{  7143, "Sint Maarten" },
	{  7144, "Curaçao/ANM0102" },
	{  7145, "Curaçao/Setel GSM" },
	{  7146, "Curaçao 1" },
	{  7147, "Curaçao 2" },
	{  7148, "Curaçao 2" },
	{  7149, "Sint Maarten" },
	{  7157, "Curaçao" },
	{  7159, "St. Eustatius" },
	{  7168, "Central Four" },
	{  7169, "Eight Mile Rock" },
	{  7170, "Soldier Road" },
	{  7171, "Grand Bahama STP" },
	{  7172, "Nassau STP" },
	{  7200, "Roseau Exchange" },
	{  7201, "Roseau DAX" },
	{  7203, "Roseau Exchange" },
	{  7233, "" },
	{  7234, "Varadero" },
	{  7235, "La Habana" },
	{  7236, "La Habana" },
	{  7237, "Camaguey" },
	{  7238, "La Habana" },
	{  7241, "" },
	{  7242, "Holguin" },
	{  7264, "ISUP Gateway 0" },
	{  7265, "ISUP Gateway 1" },
	{  7266, "DMS 300 LDV-STP-VIR (Zona Norte)" },
	{  7267, "STP-LDV (Metro)" },
	{  7268, "ODOGW1" },
	{  7269, "STP-VIR (Zona Norte)" },
	{  7270, "GSM (SGU/SLU)" },
	{  7271, "Sistema EIR (SQUIERE)" },
	{  7272, "Gateway" },
	{  7273, "Gateway" },
	{  7274, "Gateway" },
	{  7275, "Gateway" },
	{  7276, "Gateway" },
	{  7277, "Gateway" },
	{  7278, "Toll Sto. Dgo." },
	{  7279, "Toll Santiago" },
	{  7296, "HAITEL" },
	{  7297, "Port-au-Prince" },
	{  7298, "DIGICEL" },
	{  7299, "TELECO" },
	{  7328, "DMS 300 TSTT House" },
	{  7329, "DMS 300 Couva" },
	{  7330, "Broadband STP - Nelson" },
	{  7331, "Broadband STP - Couva" },
	{  7332, "VoIP Gateway Net2Phone" },
	{  7333, "Alias STP Functionality DMS 300" },
	{  7334, "VoIP Gateway Clarent TSTT House" },
	{  7335, "VoIP Gateway Clarent Couva" },
	{  7336, "CS2K - Nelson" },
	{  7337, "CS2K - Tompson" },
	{  7338, "Alias STP NGN" },
	{  7339, "DCCHAG" },
	{  7340, "DCSTP1" },
	{  7341, "DCSTP2" },
	{  7342, "DCPOS1" },
	{  7343, "Alias STP - Digicel" },
	{  7360, "MTX-PSTN-LS" },
	{  7361, "PSTN-MTX-LS7" },
	{  7362, "PSTN-PPD-LS7" },
	{  7363, "MTX-VM-LS" },
	{  7364, "G-MSC" },
	{  7365, "TCIBSC91LS" },
	{  7366, "..." },
	{  7367, "..." },
	{  7368, "..." },
	{  7369, "MGW" },
	{  7370, "MSS" },
	{  7371, "RNC" },
	{  7372, "HLR" },
	{  7373, "MSC" },
	{  7374, "RNC" },
	{  7375, "MGW" },
	{  7393, "Dauphin Télécom - Saint Martin 1" },
	{  7394, "St. Martin et St. Barthélémy Tel Cell St Martin" },
	{  7395, "Dauphin Télécom - Saint Martin 2" },
	{  7396, "Médiaserv - Guadeloupe" },
	{  7424, "Dauphin Télécom - Martinique" },
	{  7425, "Outremer Télécom - Martinique" },
	{  7426, "Dauphin Telecom - Martinique 2" },
	{  7456, "OSTD" },
	{  7457, "OSTD2" },
	{  7458, "DIGIARU" },
	{  7459, "SAN1" },
	{  7460, "AUADTH" },
	{  7462, "Auarainbow" },
	{  7488, "TDMA Mobile Switch" },
	{  7489, "PSTN Switch" },
	{  7490, "GSM Base Station Controller E3" },
	{  7491, "Voicemail" },
	{  7492, "Pre-Paid Platform" },
	{  7493, "International STP PSTN Switch to Call Server" },
	{  7494, "GSM Base Station Controller 2G" },
	{  7495, "International STP Mobile Switch to Call Server" },
	{  7520, "Reserved" },
	{  7521, "Monterrey Mayo B CTI, Monterrey N.L." },
	{  7522, "Monterrey Revolución B CTI, Monterrey N.L." },
	{  7523, "Hermosillo Garmendia B CTI, Hermosillo Son." },
	{  7524, "Hermosillo Yaqez B CTI, Hermosillo, Son." },
	{  7525, "Santa Apolonia, México D.F." },
	{  7526, "CISNE Guadalajara, Jal." },
	{  7527, "Mex9msco1" },
	{  7528, "POP Nuevo Laredo, Nuevo Laredo, Tamps." },
	{  7529, "Reserved" },
	{  7530, "Puerto Internacional Nuevo Tulancingo 2" },
	{  7531, "Laborotorio Axe Local 6 México DF" },
	{  7532, "PCS Aztecas 1, Cetaya" },
	{  7533, "PCS Nextengo 1, México" },
	{  7534, "PCS Tlaquepaque, Guadalajara" },
	{  7536, "Amazon, Apodaca, NL" },
	{  7537, "Radiomóvil DIPSA, S.A. de C.V. Cuautitlan" },
	{  7538, "Radiomóvil DIPSA, S.A. de C.V. Xochimilco" },
	{  7539, "Hermosillo, Son." },
	{  7540, "San Pedro, Garza García, N.L." },
	{  7541, "Monterrey, NL" },
	{  7542, "México, D.F." },
	{  7543, "México" },
	{  7544, "Pts Zinc-Mty" },
	{  7545, "Ps Zinc Mty" },
	{  7546, "Pts Mier Mty" },
	{  7547, "Nextengo 2 México 3" },
	{  7548, "Nextengo 1 México 1" },
	{  7549, "MTY4MSC01" },
	{  7550, "Inversiones Nextel de México, S.A. de C.V. - Mexico" },
	{  7551, "Nextel-Tlanepantla" },
	{  7552, "Reserved" },
	{  7553, "Reserved" },
	{  7554, "Reserved" },
	{  7555, "Reserved" },
	{  7556, "Reserved" },
	{  7557, "Reserved" },
	{  7558, "Mexico" },
	{  7559, "Mexico" },
	{  7560, "Mexico" },
	{  7561, "Mexico" },
	{  7562, "Mexico" },
	{  7563, "" },
	{  7564, "" },
	{  7565, "" },
	{  7566, "" },
	{  7567, "" },
	{  7568, "" },
	{  7569, "" },
	{  7570, "" },
	{  7571, "" },
	{  7572, "" },
	{  7573, "" },
	{  7574, "SGX MTY II" },
	{  7575, "SGX MX" },
	{  7576, "FOIC1" },
	{  7577, "FOIC2" },
	{  7578, "FT MSS" },
	{  7581, "ANIC1" },
	{  7582, "KGSM1" },
	{  7583, "TELEF" },
	{  7584, "Newark, NJ" },
	{  7585, "Bridgewater, NJ" },
	{  7586, "Dallas, TX" },
	{  7587, "New York" },
	{  7588, "Anaheim, CA" },
	{  7589, "Newark, NJ" },
	{  7590, "Dallas, TX" },
	{  7591, "New York, NY" },
	{  7592, "Houston, TX" },
	{  7593, "Los Angeles, CA" },
	{  7594, "Newark, NJ" },
	{  7595, "Los Angeles, CA" },
	{  7596, "Dallas, TX" },
	{  7597, "New York, NY" },
	{  7598, "Ashburn, VA" },
	{  7599, "Los Angeles, CA" },
	{  7600, "New York, NY" },
	{  7601, "Los Angeles, CA" },
	{  7602, "Boca Raton, FL" },
	{  7603, "Sherman Oaks (4), CA" },
	{  7605, "Elmswood, NY" },
	{  7606, "Los Angeles, CA" },
	{  7607, "Los Angeles (1), CA" },
	{  7608, "Los Angeles (2), CA" },
	{  7609, "Los Angeles, CA" },
	{  7610, "New York (2), NY" },
	{  7611, "New York (3), NY" },
	{  7613, "Atlanta, GA" },
	{  7614, "Jersey City, NJ" },
	{  7615, "San Antonio, TX" },
	{  7616, "New York, NY" },
	{  7618, "Honolulu, HI" },
	{  7619, "Piscataway, NJ" },
	{  7620, "New York, NY" },
	{  7621, "Newark, NJ" },
	{  7622, "San Diego, CA" },
	{  7623, "Laredo, TX" },
	{  7624, "Los Angeles, CA" },
	{  7625, "Stockton, CA" },
	{  7627, "New York, NY" },
	{  7628, "Miami, FL" },
	{  7630, "New York, NY" },
	{  7632, "New York, NY" },
	{  7633, "Brooklyn, NY" },
	{  7634, "Atlanta, GA" },
	{  7635, "New York, NY" },
	{  7636, "New York, NY" },
	{  7637, "New York, NY" },
	{  7638, "Los Angeles, CA" },
	{  7639, "New York, NY" },
	{  7640, "Oak Hill, VA" },
	{  7641, "Newark, NJ" },
	{  7642, "Jersey City, NJ" },
	{  7643, "Miami, FL" },
	{  7644, "Newark, NJ" },
	{  7645, "Holmdale, NJ" },
	{  7646, "Ft. Lauderdale, FL" },
	{  7647, "Jersey City, NJ" },
	{  7648, "New York, NY" },
	{  7649, "Newark, NJ" },
	{  7650, "Los Angeles, CA" },
	{  7651, "Rockledge, FL" },
	{  7652, "New York, NY" },
	{  7653, "Longview, TX" },
	{  7654, "New York, NY" },
	{  7656, "New York, NY" },
	{  7657, "Newark, New Jersey" },
	{  7658, "Los Angeles, CA" },
	{  7659, "Los Angeles, CA" },
	{  7660, "Houston, TX" },
	{  7661, "New York, NY" },
	{  7662, "New York, NY" },
	{  7663, "Anaheim, CA" },
	{  7664, "Los Angeles, CA" },
	{  7665, "Chicago, IL" },
	{  7666, "Los Angeles, CA" },
	{  7667, "New York, NY" },
	{  7668, "Los Angeles (2), CA" },
	{  7669, "Jersey City, NJ" },
	{  7670, "Los Angeles, CA" },
	{  7671, "New York, NY" },
	{  7673, "New York, NY" },
	{  7674, "Newark, NJ" },
	{  7675, "Atlanta, GA" },
	{  7676, "Charlotte, NC" },
	{  7677, "Portland, OR" },
	{  7678, "Los Angeles, CA" },
	{  7679, "Boca Raton, FL" },
	{  7682, "New York, NY" },
	{  7683, "Miami, FL" },
	{  7684, "Dallas, TX" },
	{  7685, "Los Angeles, CA" },
	{  7686, "Madison, WI" },
	{  7687, "New York, NY" },
	{  7688, "Los Angeles, CA" },
	{  7690, "Miami, FL" },
	{  7691, "New York, NY" },
	{  7692, "Los Angeles, CA" },
	{  7693, "New York, NY" },
	{  7694, "Dallas, TX" },
	{  7695, "San Antonio, TX" },
	{  7696, "Atlanta, GA" },
	{  7697, "Los Angeles, CA" },
	{  7698, "Los Angeles, CA" },
	{  7699, "Temple Terrace (7), FL" },
	{  7700, "Miami, FL" },
	{  7701, "Anaheim, CA" },
	{  7702, "Tampa, FL" },
	{  7703, "New York, NY" },
	{  7704, "Los Angeles, CA" },
	{  7705, "New York, NY" },
	{  7706, "Hauppauge, NY" },
	{  7707, "Billerica, MA" },
	{  7708, "Portland, OR" },
	{  7710, "Miami, FL" },
	{  7711, "Miami, FL" },
	{  7712, "Plattsburgh, NY" },
	{  7713, "Reston, VA" },
	{  7714, "Los Angeles, CA" },
	{  7715, "New York, NY" },
	{  7716, "New York, NY" },
	{  7717, "Miami, FL" },
	{  7718, "Halsey, NJ" },
	{  7719, "Herndon, VA" },
	{  7720, "New York, NY" },
	{  7721, "Los Angeles, CA" },
	{  7722, "Los Angeles, CA" },
	{  7723, "Newark, NJ" },
	{  7724, "New York, NY" },
	{  7725, "Boston, MA" },
	{  7726, "Cedar Falls, IA" },
	{  7727, "Miami, FL" },
	{  7728, "Miami, FL" },
	{  7729, "San Jose, CA" },
	{  7730, "New York, NY" },
	{  7731, "Los Angeles, CA" },
	{  7732, "Mattoon, IL" },
	{  7733, "Los Angeles, CA" },
	{  7734, "San Jose, CA" },
	{  7735, "Ashburn, VA" },
	{  7736, "New York, NY" },
	{  7737, "Houston, TX" },
	{  7738, "Los Angeles, CA" },
	{  7739, "Pompano Beach, FL" },
	{  7740, "New York, NY" },
	{  7741, "New York, NY" },
	{  7742, "New York, NY" },
	{  7743, "Miami, FL" },
	{  7744, "Wentzville, MO" },
	{  7745, "Fort Lauderdale, FL" },
	{  7746, "Los Angeles, CS" },
	{  7747, "Dallas, TX" },
	{  7748, "Philadelphia, PA" },
	{  7749, "Miami, FL" },
	{  7750, "Los Angeles, CA" },
	{  7751, "Los Angeles (3), CA" },
	{  7752, "Oak Hill, VA" },
	{  7753, "Los Angeles, CA" },
	{  7754, "Tampa, FL" },
	{  7755, "Tampa, FL" },
	{  7756, "Newark, NJ" },
	{  7757, "New York, NY" },
	{  7758, "Los Angeles, CA" },
	{  7759, "New York, NY" },
	{  7760, "San Antonio, TX" },
	{  7761, "Overland Park, KS" },
	{  7762, "New York, NY" },
	{  7763, "Dallas, TX" },
	{  7764, "Dallas (2), TX" },
	{  7765, "Nashville, TN" },
	{  7766, "Boca Raton, FL" },
	{  7767, "Sunnyvale, CA" },
	{  7768, "Los Angeles, CA" },
	{  7769, "Houston, TX" },
	{  7770, "Los Angeles, CA" },
	{  7771, "Los Angeles (2), CA" },
	{  7772, "Los Angeles (3), CA" },
	{  7773, "Los Angeles (4), CA" },
	{  7774, "Miami, FL" },
	{  7775, "Palm Bay, FL" },
	{  7776, "Orlando, FL" },
	{  7777, "New York, NY" },
	{  7778, "New York, NY" },
	{  7779, "Dallas, TX" },
	{  7780, "Hauppauge, NY" },
	{  7781, "Miami, FL" },
	{  7782, "New York, NY" },
	{  7783, "New York, NY" },
	{  7864, "SGX GDL" },
	{  7968, "SPX_1.1-MTX1" },
	{  7969, "SPX_1.2-MTX1" },
	{  7970, "SPX_2.1-MTX2" },
	{  7971, "SPX_2.2-MTX2" },
	{  7972, "PRIMO IXFR" },
	{  7973, "ASC-SS7" },
	{  7974, "ABISSNET S01" },
	{  7975, "ALBON-AL-SS7" },
	{  7976, "CLXSTH-1 (Stockholm)" },
	{  7977, "CLXSTH-2 (Stockholm)" },
	{  7978, "CLXSTH-3 (Stockholm)" },
	{  7979, "CLXSTH-4 (Stockholm)" },
	{  7980, "MobiWebSTP1 (Falkenstein)" },
	{  7981, "MobiWebSTP2 (Falkenstein)" },
	{  7982, "MobiWebSTP3 (Falkenstein)" },
	{  7983, "mg2.int.upp" },
	{  7984, "MSCS R1" },
	{  7985, "STP R1" },
	{  7986, "ECO-MSC1-THO" },
	{  7987, "ECO-STP1-THO" },
	{  7989, "TNZUK London 2" },
	{  7992, "TLCBL1" },
	{  7993, "TLCBL2" },
	{  7994, "NET1BG" },
	{  7995, "NISA" },
	{  7997, "STPG1" },
	{  7998, "STPG2" },
	{  7999, "PREMIUM" },
	{  8000, "P1 Security – Vitry 1" },
	{  8001, "P1 Security – Vitry 2" },
	{  8002, "NRJ Mobile - Aubervilliers 1" },
	{  8003, "NRJ Mobile - Aubervilliers 2" },
	{  8004, "M Target – St Denis 1" },
	{  8005, "M Target – St Denis 2" },
	{  8007, "Orange – CTI France Paris – YJ03" },
	{  8008, "STP-INT/Durres" },
	{  8009, "GMSC-AMC2" },
	{  8010, "INFOTEL AL" },
	{  8011, "Tirana 10" },
	{  8012, "CT Nisatel Tirana" },
	{  8013, "ABCom TS1-SOIP" },
	{  8014, "BC_1-MTX1" },
	{  8015, "BC_2-MTX2" },
	{  8016, "CSC2_Riga" },
	{  8017, "MSC4" },
	{  8018, "MSC5" },
	{  8019, "MGW1" },
	{  8020, "MGW2" },
	{  8021, "INTLLC1" },
	{  8022, "TLNVAI" },
	{  8031, "SMiLOUS London" },
	{  8033, "GBS1" },
	{  8034, "GVSUKD" },
	{  8035, "Birmingham WMD0900-T52" },
	{  8036, "Acton GLN1070-T53" },
	{  8037, "Leicester LEC5090-T54" },
	{  8038, "Manchester GMN0901-T55" },
	{  8040, "LON STP1" },
	{  8041, "TSC 93" },
	{  8042, "TSC 95" },
	{  8043, "TSC 96" },
	{  8046, "Synective - UK" },
	{  8047, "Synective -UK" },
	{  8048, "Bucuresti" },
	{  8049, "Bucuresti" },
	{  8051, "Bucuresti" },
	{  8052, "Bucuresti" },
	{  8053, "Brasov" },
	{  8054, "Bucuresti" },
	{  8055, "Brasov" },
	{  8056, "STA STP BLUKA1" },
	{  8057, "STA STP BLUKA2" },
	{  8058, "IE BLUKA1" },
	{  8059, "IE BLUKA2" },
	{  8060, "EK St1" },
	{  8061, "ITM-Sa" },
	{  8062, "ABC Sarajevo" },
	{  8072, "" },
	{  8073, "PCOM-01,RS" },
	{  8074, "" },
	{  8075, "" },
	{  8076, "..." },
	{  8077, "..." },
	{  8078, "..." },
	{  8079, "..." },
	{  8080, "" },
	{  8081, "" },
	{  8082, "" },
	{  8083, "" },
	{  8084, "Lleida" },
	{  8086, "" },
	{  8088, "Flensburg" },
	{  8090, "Frankfurt" },
	{  8091, "Frankfurt" },
	{  8092, "Frankfurt" },
	{  8093, "Hamburg" },
	{  8094, "Frankfurt" },
	{  8095, "FRA STP2" },
	{  8096, "Novametro1" },
	{  8100, "Tallinn" },
	{  8101, "Tallin" },
	{  8102, "Tallinn" },
	{  8103, "Tallinn" },
	{  8104, "Iskon Zagreb 1" },
	{  8105, "Iskon Zagreb 2" },
	{  8106, "METRONET-ZG-002" },
	{  8107, "TERRA_ZG_SW-1" },
	{  8108, "Zagreb/MC2" },
	{  8109, "STP1 Zagreb" },
	{  8110, "STP2 Rijeka" },
	{  8111, "MSS1 Zagreb" },
	{  8112, "Tbilisi, Mobile Switching Centre" },
	{  8113, "Tbilisi, International Exchange" },
	{  8114, "Tbilisi, International Exchange" },
	{  8115, "Tbilisi, International Exchange" },
	{  8116, "Tbilisi, Mobile Switching Centre" },
	{  8117, "Tbilisi, International Exchange" },
	{  8118, "Tbilisi, International Exchange" },
	{  8119, "Tbilisi, International Exchange" },
	{  8120, "Tele2" },
	{  8121, "Tellcom" },
	{  8123, "Global" },
	{  8124, "Mega" },
	{  8125, "Ankara/Borusan" },
	{  8126, "Kocnet" },
	{  8127, "Dogan Iletisim" },
	{  8128, "TWX/LIM2, Limassol" },
	{  8129, "WLD-CY" },
	{  8130, "TWX/LIM1, Nicosia" },
	{  8131, "ISCLYK, Nicosia" },
	{  8132, "ISCMGI, Limassol" },
	{  8133, "CBNT_CY, Nicosia" },
	{  8134, "MTNCYMSS1, Nicosia" },
	{  8135, "MTNCYMSS2, Nicosia" },
	{  8136, "SPIC1 (STP Picoas Lisboa)" },
	{  8137, "SLAP1 (STP Lapa Porto)" },
	{  8144, "Bucuresti" },
	{  8145, "Cluj-Napoca" },
	{  8146, "Brasov" },
	{  8148, "Bucuresti" },
	{  8149, "Bucuresti" },
	{  8150, "Bucuresti" },
	{  8151, "Bucuresti" },
	{  8152, "P4 JAW" },
	{  8153, "TNO WAW" },
	{  8154, "TMP WAW 2" },
	{  8155, "POL KAT" },
	{  8156, "EXA MOR" },
	{  8157, "PLK WAW 1" },
	{  8158, "PLK WAW 2" },
	{  8159, "PLK WAW 3" },
	{  8160, "Frankfurt" },
	{  8161, "Gütersloh" },
	{  8162, "Taucha" },
	{  8163, "Frankfurt" },
	{  8164, "Frankfurt" },
	{  8165, "FRA SCP1" },
	{  8166, "Frankfurt" },
	{  8167, "Stuttgart" },
	{  8168, "P4 WAW 3" },
	{  8169, "P4 WAW 4" },
	{  8170, "SFE WAW" },
	{  8171, "ETE WAW" },
	{  8172, "OPL WAW 4" },
	{  8173, "OPL KAT 3" },
	{  8174, "P4 WAW 5" },
	{  8175, "TKT WAW" },
	{  8176, "Saarbrücken" },
	{  8177, "Frankfurt" },
	{  8178, "Frankfurt" },
	{  8179, "Bielefeld" },
	{  8180, "FRA SCP2" },
	{  8181, "Göppingen" },
	{  8182, "Düsseldorf" },
	{  8183, "CGN-EPC-1" },
	{  8184, "Düsseldorf" },
	{  8185, "Neubrandenburg" },
	{  8186, "Rostock" },
	{  8187, "HAM-EPC-1" },
	{  8188, "Frankfurt" },
	{  8189, "Frankfurt" },
	{  8190, "Frankfurt" },
	{  8191, "EMNIFYWUERZBURGDE2" },
	{  8216, "..." },
	{  8217, "..." },
	{  8218, "..." },
	{  8219, "..." },
	{  8220, "..." },
	{  8221, "..." },
	{  8224, "Bezeq Int. 5" },
	{  8225, "Bezeq Int. 6" },
	{  8226, "Golden Lines 3" },
	{  8227, "Golden Lines 4" },
	{  8228, "..." },
	{  8229, "..." },
	{  8230, "..." },
	{  8231, "..." },
	{  8232, "ISC-12, Mumbai" },
	{  8233, "ISC Chennai" },
	{  8234, "ISC Mumbai" },
	{  8235, "ISC Delhi" },
	{  8236, "ISC Chennai" },
	{  8237, "ISC Ernakulam" },
	{  8238, "ISC- Chennai" },
	{  8239, "ISC Chennai SSTP" },
	{  8240, "ISC-1, Hyderabad" },
	{  8241, "ISC-1, Ahmedabad" },
	{  8242, "ISC-3, Jalandhar" },
	{  8243, "ISC-1, Surat" },
	{  8244, "ISC Delhi" },
	{  8245, "ISC Mumbai" },
	{  8246, "ISC-11, VoIP-New Delhi" },
	{  8247, "ISC-4, VOIP-Ernakulam" },
	{  8248, "ISC Kolkata - STP" },
	{  8249, "ISC Chennai - STP" },
	{  8250, "ISC 1 Lucknow" },
	{  8251, "ISC 9 New Delhi" },
	{  8252, "ISC 7 Chennai" },
	{  8253, "ISC 11 Mumbai" },
	{  8254, "ISC 10 New Delhi" },
	{  8255, "ISC-1, Gurgoan" },
	{  8256, "ISC Kolkata - SSTP" },
	{  8257, "ISC Delhi - STP" },
	{  8258, "ISC Mumbai - STP" },
	{  8259, "ISC Mumbai" },
	{  8260, "ISC Ernakulam - SSTP" },
	{  8261, "ISC Mumbai - STP" },
	{  8262, "ISC Delhi - STP" },
	{  8263, "ISC Jalandhar - SSTP" },
	{  8264, "ISC 3 New Delhi-ICO" },
	{  8265, "ISC Jalandhar" },
	{  8266, "ISC Ahmedabad" },
	{  8267, "ISC 1 Iridium Pune" },
	{  8268, "ISC, ERNAKULAM" },
	{  8269, "ISC Guwahati" },
	{  8270, "ISC-3, ATM NODE-1 Mumbai" },
	{  8271, "ISC-4, ATM NODE-2 Mumbai" },
	{  8272, "ISC 4 New Delhi" },
	{  8273, "ISC 3 Kolkata" },
	{  8274, "ISC 1 Patna" },
	{  8275, "ISC-5, Mumbai" },
	{  8276, "ISC-3, Chennai" },
	{  8277, "ISC 6 Mumbai" },
	{  8278, "ISC 4 Chennai" },
	{  8279, "ISC-5, New Delhi" },
	{  8280, "ISC 6 New Delhi" },
	{  8281, "ISC 7 Mumbai" },
	{  8282, "ISC-2, Ernakulam" },
	{  8283, "ISC 7 New Delhi" },
	{  8284, "ISC 4 Kolkata" },
	{  8285, "ISC 5 Kolkata" },
	{  8286, "ISC 5 Chennai" },
	{  8287, "ISC 1 Bangalore" },
	{  8288, "ISC 8 Mumbai" },
	{  8289, "ISC 2 Bangalore" },
	{  8290, "ISC-6, Kolkata" },
	{  8291, "ISC-9, VOIP-Mumbai" },
	{  8292, "ISC-2, Gandhi Nagar - VOIP" },
	{  8293, "ISC 2 Jalandhar VoIP" },
	{  8294, "ISC Mohali, Chandigarh - STP" },
	{  8295, "ISC Gandhinagar - STP" },
	{  8296, "ISC Mumbai SSTP" },
	{  8297, "ISC Delhi SSTP" },
	{  8298, "ISC Delhi" },
	{  8299, "ISC Mumbai" },
	{  8300, "ISC Chennai" },
	{  8301, "ISC Kolkata" },
	{  8302, "ISC Lucknow - STP" },
	{  8303, "ISC Bangalore - STP" },
	{  8304, "ISC Chennai" },
	{  8305, "ISC Delhi" },
	{  8306, "ISC Hyderabad" },
	{  8307, "ISC Ernakulam" },
	{  8308, "ISC Mumbai - STP" },
	{  8309, "ISC Kolkata - STP" },
	{  8310, "ISC Mumbai" },
	{  8311, "ISC Delhi" },
	{  8312, "ISC-Thane Mumbai" },
	{  8313, "ISC Chennai" },
	{  8314, "ISC Ernakulam" },
	{  8315, "ISC Mumbai" },
	{  8316, "ISC New Delhi" },
	{  8317, "ISC Chennai" },
	{  8318, "ISC Mumbai" },
	{  8319, "ISC - New Delhi" },
	{  8320, "ISC - Chennai" },
	{  8321, "ISC - Mumbai" },
	{  8322, "ISC - Gurgoan" },
	{  8323, "ISC - Chennai" },
	{  8324, "ISC - Mumbai" },
	{  8325, "ISC - Mumbai (for STP)" },
	{  8326, "ISC - Mumbai (for STP)" },
	{  8327, "ISC - New Delhii (for STP)" },
	{  8328, "ISC - Mumbai (for STP)" },
	{  8329, "ISC - Chennai (for STP)" },
	{  8330, "ISC - Chennai (for STP)" },
	{  8331, "Mumbai" },
	{  8332, "Chennai" },
	{  8333, "Mumbai" },
	{  8334, "Noida" },
	{  8335, "Pune" },
	{  8336, "Navi Mumbai" },
	{  8337, "Mumbai" },
	{  8338, "Ernakulam, Kerala" },
	{  8339, "Chennai" },
	{  8340, "Greater Noida" },
	{  8341, "Mumbai" },
	{  8352, "IGE-2 Karachi (KHI2)" },
	{  8353, "IGE-1 Karachi (KHI1)" },
	{  8354, "IGE-2 Islamabad (IBA2)" },
	{  8355, "IGE-3 Islamabad (IBA3)" },
	{  8356, "LDI (IGE1) Lahore" },
	{  8357, "ISC1 (IGE-ISB-1)" },
	{  8358, "TCL (IGE1) Karachi" },
	{  8359, "IGE-1 AJK" },
	{  8360, "B640 KHI" },
	{  8361, "WC INT LHR 01" },
	{  8362, "WTL INT LHR 01" },
	{  8363, "Telenor Pak LDI-KHI" },
	{  8364, "LDI (IGE-2) Karachi" },
	{  8365, "DVC IBA 1" },
	{  8366, "Telenor Pak LDI-2 IBA" },
	{  8367, "RP1" },
	{  8368, "LDI - IGE - LHR 1" },
	{  8369, "LDI - IGE - KHI 1" },
	{  8370, "WTL INT KHI 02" },
	{  8371, "CTTL 3" },
	{  8372, "Pakfon" },
	{  8373, "BTLINAT" },
	{  8374, "DVC IBA 2 (STP-A)" },
	{  8375, "WTL INT LHR 02" },
	{  8376, "RP2" },
	{  8377, "TCL (IGE-2) Karachi" },
	{  8378, "WTL INT KHI 01" },
	{  8379, "LDI-IGE-ISB2" },
	{  8380, "STP-B IBA 1-9" },
	{  8381, "reserved" },
	{  8382, "reserved" },
	{  8384, "AWCC" },
	{  8385, "AWCC" },
	{  8386, "AWCC" },
	{  8387, "Afghan Telecom" },
	{  8388, "Kamss3-TV" },
	{  8389, "Hemss1-Herat" },
	{  8390, "Roshan" },
	{  8391, "Roshan" },
	{  8392, "Roshan" },
	{  8393, "Roshan" },
	{  8394, "Roshan" },
	{  8395, "AWCC" },
	{  8396, "AWCC" },
	{  8397, "Afghan Telecom" },
	{  8398, "Afghan Telecom" },
	{  8399, "Etisalat Afghanistan" },
	{  8400, "ISC1 - 5ESS Int'l Gateway" },
	{  8401, "ISC2 - NEAX Int'l Gateway" },
	{  8402, "ISC3 - NEAX Int'l Gateway" },
	{  8403, "ZE" },
	{  8404, "..." },
	{  8405, "Mobitel" },
	{  8406, "Celltel 1" },
	{  8407, "MTNLK 1" },
	{  8408, "UNIL Sri Lanka 1" },
	{  8409, "VLL Gateway, Colombo" },
	{  8410, "LBSW2" },
	{  8411, "MTNLK2" },
	{  8412, "LBSW1" },
	{  8413, "Celltel" },
	{  8414, "SUNTEL ISC" },
	{  8415, "MTT 01" },
	{  8417, "Huawei Softswitch (YGN)" },
	{  8418, "Genband Softswitch (NPT)" },
	{  8419, "DMS-300 (NPT)" },
	{  8421, "Huawei Softswitch (YGN)" },
	{  8422, "Huawei Signalling Gateway (YGN)" },
	{  8423, "Huawei Signalling Gateway (NPT)" },
	{  8433, "Beirut, Justice ISC AXE-10" },
	{  8434, "Beirut, Ras Beirut ISC AXE-10" },
	{  8435, "Beirut, Jdeideh, ISC AXE-10" },
	{  8440, "..." },
	{  8441, "" },
	{  8442, "..." },
	{  8443, "" },
	{  8445, "" },
	{  8446, "" },
	{  8447, "" },
	{  8448, "..." },
	{  8449, "..." },
	{  8450, "..." },
	{  8451, "..." },
	{  8452, "..." },
	{  8453, "..." },
	{  8454, "..." },
	{  8455, "..." },
	{  8456, "..." },
	{  8457, "..." },
	{  8458, "" },
	{  8459, "..." },
	{  8460, "..." },
	{  8461, "..." },
	{  8463, "..." },
	{  8465, "Damascus" },
	{  8466, "Aleppo" },
	{  8467, "Syriatel-STD MMUH1" },
	{  8468, "MTN-Damascus" },
	{  8469, "MTN-Latakia" },
	{  8470, "Syriatel-STD MDUM1" },
	{  8480, "..." },
	{  8481, "..." },
	{  8482, "..." },
	{  8483, "..." },
	{  8496, "ISCX-1" },
	{  8497, "ISC-2" },
	{  8498, "ISC-3" },
	{  8499, "Mobile operator" },
	{  8500, "Mobile Operator" },
	{  8501, "Mobile operator" },
	{  8502, "Mobile operator" },
	{  8503, "Mobile operator" },
	{  8512, "DAMMAM INTL. VoIP" },
	{  8513, "JEDDAH INTL. VoIP" },
	{  8514, "HUTT" },
	{  8515, "RIYADH INTL. VoIP" },
	{  8516, "MUJA" },
	{  8517, "JIN1" },
	{  8518, "RIN1" },
	{  8519, "DIN1" },
	{  8520, "JED1" },
	{  8521, "RYD1" },
	{  8522, "JST1" },
	{  8523, "RST1" },
	{  8524, "M1I2" },
	{  8525, "M2I2" },
	{  8526, "M1S2" },
	{  8527, "M2S2" },
	{  8528, "Sana'a ISC2" },
	{  8529, "STY GSM Exchange" },
	{  8530, "SF GSM Exchange" },
	{  8531, "IGW4" },
	{  8532, "IGW4" },
	{  8533, "AIGW" },
	{  8534, "HDIGW" },
	{  8535, "AMOB" },
	{  8544, "Inter Switch 1 at TCC (ISC1)" },
	{  8545, "Inter Switch 2 at MUS1 (ISC2)" },
	{  8546, "Nawras 1" },
	{  8547, "Nawras 2" },
	{  8548, "TCC (Soft Switch)" },
	{  8560, "ISC3" },
	{  8561, "IGW5" },
	{  8562, "IGW5" },
	{  8563, "YEM-Unitel-1" },
	{  8564, "YEM-Unitel-2" },
	{  8565, "YEM-YTel-3" },
	{  8566, "YEM-YTel-4" },
	{  8567, "YEM-YTel-5" },
	{  8576, "IG Softswitch 1 (IS1)" },
	{  8577, "IG Softswitch 2 (IS2)" },
	{  8578, "IG Softswitch 3 (IS3)" },
	{  8579, "IG Softswitch 4 (IS4)" },
	{  8580, "IG Softswitch 5 (IS5)" },
	{  8582, "IG Softswitch 5 (SGW)" },
	{  8583, "IG Softswitch 6 (SGW)" },
	{  8584, "TC1CSW02" },
	{  8585, "ITP3" },
	{  8586, "ITP4" },
	{  8587, "DXB001GSX1" },
	{  8592, "..." },
	{  8593, "ISC Oron" },
	{  8594, "PTTK" },
	{  8595, "..." },
	{  8596, "ISC Barak1" },
	{  8597, "ISC Barak 2" },
	{  8598, "ISC PTTK" },
	{  8599, "ISC Kiron" },
	{  8600, "ISC SIV" },
	{  8601, "ISC EDEN" },
	{  8602, "Partner 1" },
	{  8603, "Y2K testing" },
	{  8604, "" },
	{  8605, "" },
	{  8606, "Xfone1" },
	{  8607, "Xfone2" },
	{  8608, "Salmanya (SAL)" },
	{  8609, "Sanad (SND)" },
	{  8610, "infonasbh" },
	{  8611, "VoIP" },
	{  8612, "NUETEL-AMWAJ" },
	{  8613, "Diplomat" },
	{  8614, "MSC2-Istiqlala" },
	{  8615, "MSC2-Tubli" },
	{  8617, "Softswitch" },
	{  8618, "" },
	{  8619, "-" },
	{  8620, "" },
	{  8621, "IGWs-MSCs" },
	{  8622, "IGWs-MSCs" },
	{  8623, "MSC1-Tubli-MSC Server1" },
	{  8624, "spare" },
	{  8625, "Doha STP3" },
	{  8626, "ITSC-3-Doha" },
	{  8627, "spare" },
	{  8628, "Cisco-PGW" },
	{  8629, "Doha IGW1" },
	{  8630, "Doha IGW2" },
	{  8631, "Doha STP2" },
	{  8632, "VFQ-M1" },
	{  8633, "VFQ-M2" },
	{  8641, "IGW" },
	{  8642, "STP" },
	{  8644, "UNITEL MN" },
	{  8647, "G-MOBILE MN" },
	{  8648, "NSTPL1" },
	{  8649, "MSC4" },
	{  8650, "MSC5" },
	{  8656, "Patan ISC (Kathmandu)" },
	{  8657, "Central ISC (Kathmandu)" },
	{  8658, "UTL ISC01 (Kathmandu)" },
	{  8659, "Kathmandu SNPL-1" },
	{  8660, "PATAN STP" },
	{  8661, "STM Sanchar Nepal (Kathmandu)" },
	{  8662, "Central STP" },
	{  8663, "STP_KTM" },
	{  8664, "UTL_SSP" },
	{  8665, "UTL_SCCP" },
	{  8666, "Sundhara Pol" },
	{  8667, "KTM-2 SNPL" },
	{  8668, "Jawalakhel Pol" },
	{  8669, "SMART_INT_SP1" },
	{  8670, "Sundhara IGE" },
	{  8671, "Butwal IGE" },
	{  8672, "ACI" },
	{  8673, "2IS" },
	{  8674, "ASI" },
	{  8675, "WSI" },
	{  8676, "EDCH" },
	{  8677, "ITP1" },
	{  8678, "TC1CSW01" },
	{  8679, "ITP-2" },
	{  8688, "DCI" },
	{  8689, "4IS" },
	{  8690, "DSI" },
	{  8691, "WCI" },
	{  8692, "IG Softswitch 6 (IS6)" },
	{  8694, "EITCSW01 (IMSS)" },
	{  8704, "Reserved" },
	{  8705, "Tehran ISC2" },
	{  8706, "Tehran ISC1" },
	{  8707, "Shiraz ISC3" },
	{  8708, "Reserved" },
	{  8709, "Tehran STP1" },
	{  8710, "Tehran STP2" },
	{  8711, "Irancell-GMSC1" },
	{  8712, "Irancell-GMSC2" },
	{  8713, "Reserved" },
	{  8714, "Reserved" },
	{  8715, "Reserved" },
	{  8716, "MCI-GMSC1" },
	{  8717, "MCI-GMSC2" },
	{  8718, "Rightel-GMSC1" },
	{  8719, "Rightel-GMSC2" },
	{  8752, "BAKU_INT_N7" },
	{  8753, "BAKU_INT_N7_" },
	{  8754, "BAKU_INT_N7_1" },
	{  8755, "Nakhchivan Toll" },
	{  8756, "MSOFTX3000_2" },
	{  8757, "GWMSG-1" },
	{  8758, "GWMSG-2" },
	{  8759, "MSOFTX3000_1" },
	{  8760, "STP BTC_1E" },
	{  8761, "STPCS3_2E" },
	{  8762, "STP BHQ_1" },
	{  8763, "STP BHQ_2" },
	{  8764, "Class-4 IGW Network" },
	{  8765, "BAKU_INT_N7_2" },
	{  8766, "STP-1" },
	{  8767, "STP-2" },
	{  8768, "..." },
	{  8784, "Central Earth Station, Almaty" },
	{  8785, "Almaty International Switching Centre (ISC)" },
	{  8786, "Aktyubinsk ISC" },
	{  8787, "Astana ISC" },
	{  8788, "GSM Kazakhstan (roaming)" },
	{  8789, "..." },
	{  8790, "..." },
	{  8791, "..." },
	{  8792, "Almaty ISC" },
	{  8793, "Almaty ISC" },
	{  8794, "Almaty ISC" },
	{  8795, "Almaty ISC" },
	{  8796, "Almaty ISC" },
	{  8797, "Almaty ISC" },
	{  8798, "Astana ISC" },
	{  8799, "Astana ISC" },
	{  8800, "Almaty ISC" },
	{  8801, "Astana ISC" },
	{  8802, "Almaty ISC" },
	{  8803, "Almaty ISC" },
	{  8804, "Almaty ISC" },
	{  8805, "Astana ISC" },
	{  8806, "Almaty ISC" },
	{  8816, "Gateway-1, Bishkek" },
	{  8817, "..." },
	{  8818, "..." },
	{  8819, "..." },
	{  8820, "..." },
	{  8821, "..." },
	{  8822, "..." },
	{  8824, "Gateway-2, Bishkek" },
	{  8825, "..." },
	{  8826, "..." },
	{  8827, "..." },
	{  8828, "..." },
	{  8829, "..." },
	{  8830, "..." },
	{  8834, "Yamaguchi-1" },
	{  8835, "Tokyo-B" },
	{  8836, "Tokyo" },
	{  8839, "Tokyo-2" },
	{  8841, "Tokyo-4" },
	{  8842, "Osaka-3" },
	{  8843, "Osaka-4" },
	{  8846, "TOKYO1" },
	{  8847, "OSAKA1" },
	{  8848, "Tokyo1" },
	{  8849, "Tokyo2" },
	{  8852, "Fukagawa-01" },
	{  8856, "Kyoto1" },
	{  8857, "Chiba1" },
	{  8858, "Chiba2" },
	{  8859, "TOKYO2" },
	{  8860, "Tokyo" },
	{  8861, "Osaka" },
	{  8863, "Tokyo-CDC1" },
	{  8864, "Tokyo-CDC2" },
	{  8865, "Osaka-CDC1" },
	{  8866, "Osaka-CDC2" },
	{  8867, "Tokyo Brastel IGS-3" },
	{  8868, "Tokyo Brastel IGS-2" },
	{  8869, "Tokyo1" },
	{  8870, "Tokyo2" },
	{  8871, "Tokyo-A" },
	{  8872, "Kyoto2" },
	{  8873, "Kyoto3" },
	{  8874, "Chiba4" },
	{  8875, "Fukagawa-02" },
	{  8877, "OSAKA2" },
	{  8879, "Tokyo" },
	{  8882, "Tama-1" },
	{  8883, "Osaka-5" },
	{  8884, "Tokyo-6" },
	{  8885, "Osaka-9" },
	{  8886, "TOKYO3" },
	{  8887, "OSAKA3" },
	{  8888, "Osaka1" },
	{  8889, "Osaka2" },
	{  8890, "Tokyo-5" },
	{  8891, "Osaka-7" },
	{  8892, "Oyama-1" },
	{  8893, "Tama-2" },
	{  8894, "Osaka-8" },
	{  8895, "Hakata-1" },
	{  8896, "MSC1-Tubli-MGW" },
	{  8897, "MSC1-Tubli-STP1" },
	{  8898, "MSC2-Sanad-MSCserver2" },
	{  8899, "MSC2-Sanad-MGW" },
	{  8900, "IMCS1" },
	{  8901, "IMCS2" },
	{  8903, "STP1" },
	{  8904, "STP2" },
	{  8905, "Temp ISPC" },
	{  8906, "Temp ISPC" },
	{  8912, "sumida-sgw-ag" },
	{  8913, "kyoto-sgw-ag" },
	{  8914, "TOKYO4" },
	{  8915, "OSAKA4" },
	{  8916, "Tokyo-7" },
	{  8917, "Osaka-10" },
	{  8918, "Tokyo-1 Internet Initiative Japan Inc." },
	{  8919, "Osaka-1 Internet Initiative Japan Inc." },
	{  8992, "Seoul Gateway" },
	{  8993, "Seoul Gateway" },
	{  8994, "Pusan Gateway" },
	{  8995, "Seoul Gateway" },
	{  8996, "Daejeon Gateway" },
	{  8997, "Seoul Gateway" },
	{  8998, "Pusan Gateway" },
	{  8999, "Pusan Gateway" },
	{  9000, "Seoul Gateway" },
	{  9001, "Daejon Gateway" },
	{  9002, "Seoul Gateway" },
	{  9003, "Daejon Gateway" },
	{  9004, "Anyang Gateway" },
	{  9005, "..." },
	{  9006, "Seoul Gateway" },
	{  9007, "Seoul Gateway" },
	{  9016, "IGW Ha Noi" },
	{  9017, "IGW HCM" },
	{  9019, "HCM-IDD" },
	{  9020, "ISTP Ha Noi" },
	{  9021, "Alias Point Code for NGN Gateways" },
	{  9022, "ISPT HCM" },
	{  9023, "Gateway Danang" },
	{  9024, "TDM Gateway Hanoi, AXE Exchange" },
	{  9025, "TDM Gateway Danang, AXE Exchange" },
	{  9026, "TDM Gateway Ho Chi Minh, AXE Exchange" },
	{  9027, "SCCP Gateway Hanoi" },
	{  9028, "SCCP Gateway Ho Chi Minh" },
	{  9029, "Signalling Transfer Point Gateway Hanoi" },
	{  9030, "Signalling Transfer Point Gateway Ho Chi Minh" },
	{  9031, "IGW HCM" },
	{  9032, "GlobalOne-HK1" },
	{  9033, "STHK" },
	{  9034, "Wharf T&T - WCTU2" },
	{  9035, "HTHKIU1" },
	{  9036, "H6" },
	{  9037, "HTCL" },
	{  9038, "HK-1" },
	{  9039, "Wharf T&T - KCTU2" },
	{  9040, "CTI/HKG1" },
	{  9041, "HTHKIU2" },
	{  9042, "KDDI HK" },
	{  9043, "Tung Chung/HKG1" },
	{  9044, "Kwai Chung/HKG2" },
	{  9045, "HKT ISGW1" },
	{  9046, "HKG06" },
	{  9047, "S2T" },
	{  9048, "HKT ISC1" },
	{  9049, "HKT ISC2" },
	{  9050, "CTI/HKG2" },
	{  9051, "HGKGCNGBGT1" },
	{  9052, "Smartgate" },
	{  9053, "Unicom1" },
	{  9054, "Lucky Tone Communications Ltd" },
	{  9055, "HK1/CNC" },
	{  9056, "Electra" },
	{  9057, "Hermes" },
	{  9058, "Zodiac" },
	{  9059, "Mini-ISC" },
	{  9060, "HKG04-SW1" },
	{  9061, "HKG04-SW2" },
	{  9062, "CSL INT POI 1" },
	{  9063, "CSL INT POI 2" },
	{  9064, "TELIN-HK ISS" },
	{  9065, "Unicom2" },
	{  9066, "HKG07" },
	{  9067, "Whart T&T - WCTU5" },
	{  9068, "HKG02" },
	{  9069, "PHA" },
	{  9070, "Centrex" },
	{  9071, "HKS1" },
	{  9072, "MMSS1" },
	{  9073, "ISC1" },
	{  9074, "ISC2" },
	{  9075, "MSC" },
	{  9076, "MACSMC" },
	{  9077, "MG1" },
	{  9078, "CTMO" },
	{  9079, "ISC3" },
	{  9080, "CCS1582" },
	{  9081, "GTI (HK) Ltd" },
	{  9082, "Unicom3" },
	{  9083, "HKGCH1" },
	{  9085, "TMHK-2" },
	{  9086, "HKCSW 1" },
	{  9087, "CMCC-HKISC" },
	{  9088, "Bayon G1" },
	{  9089, "Bayon G2" },
	{  9090, "RT11" },
	{  9091, "RT12" },
	{  9093, "RTI 3" },
	{  9094, "RTI 4" },
	{  9095, "TCT1" },
	{  9097, "VTC1" },
	{  9104, "ETL Saylom ISC" },
	{  9109, "LAT" },
	{  9110, "..." },
	{  9144, "MACSMC1" },
	{  9145, "IG-1" },
	{  9146, "IG-2" },
	{  9147, "MACSMC2" },
	{  9152, "BEIJING ISC1" },
	{  9153, "Beijing international exchange" },
	{  9154, "BEIJING ISC2" },
	{  9155, "Shanghai ISC1" },
	{  9156, "Shanghai ISC2" },
	{  9157, "Guangzhou ISC1" },
	{  9158, "Guangzhou ISC2" },
	{  9159, "Beijing ISC ""iridium"" system" },
	{  9160, "Shanghai E-Call gateway 3" },
	{  9161, "BEIJING ISTP1" },
	{  9162, "Shanghai ISTP1" },
	{  9163, "Shanghai ISTP2" },
	{  9164, "Guangzhou ISTP1" },
	{  9165, "Guangzhou E-Call gateway 1" },
	{  9166, "Tsingtao border exchange" },
	{  9167, "Shenzhen border exchange" },
	{  9168, "Shanghai ISTP" },
	{  9169, "Beijing E-Call gateway 1" },
	{  9170, "Beijing E-Call gateway 2" },
	{  9171, "Shanghai E-Call gateway 2" },
	{  9172, "Guangzhou E-Call gateway 3" },
	{  9173, "Guangzhou E-Call gateway 2" },
	{  9174, "Shanghai E-Call gateway 1" },
	{  9175, "Shanghai NGN International exchange" },
	{  9176, "Beijing CDMA-ITP1" },
	{  9177, "Guangzhou ISC" },
	{  9178, "Shanghai ISC" },
	{  9179, "Beijing ISC1" },
	{  9180, "Guangzhou ISC2" },
	{  9181, "Shanghai ISC2" },
	{  9182, "Beijing ISC2" },
	{  9183, "Beijing CDMA-ITP2" },
	{  9184, "Shanghai CDMA-ITP" },
	{  9185, "Beijing ISTP1" },
	{  9186, "Shanghai ISTP1" },
	{  9187, "Beijing ISCP" },
	{  9188, "Beijing ISC" },
	{  9189, "Shanghai ISC" },
	{  9190, "Guangzhou ISC" },
	{  9191, "Guangzhou NGN International exchange" },
	{  9192, "Beijing Inmarsat Standard Land Earth Station" },
	{  9193, "Beijing Inmarsat-F System Standard Land Earth Station" },
	{  9194, "Beijing ISC" },
	{  9195, "Shanghai ISC" },
	{  9196, "Guangzhou ISC" },
	{  9197, "Shanghai ISC" },
	{  9198, "Guangzhou ISC" },
	{  9199, "Guangzhou CDMA-ITP" },
	{  9200, "Beijing ISC1" },
	{  9201, "Beijing ISC" },
	{  9202, "Shanghai ISC" },
	{  9203, "Guangzhou ISC" },
	{  9204, "Beijing ISC" },
	{  9205, "Shanghai ISC" },
	{  9206, "Guangzhou ISC" },
	{  9207, "Guangzhou ISC2" },
	{  9208, "Shanghai CDMA-ITP1" },
	{  9209, "Guangzhou CDMA-ITP1" },
	{  9210, "Beijing CDMA-ITP" },
	{  9211, "Beijing CDMA-ITP1" },
	{  9212, "Beijing GC Gateway" },
	{  9213, "Shanghai GC gateway" },
	{  9214, "Guangzhou GC gateway" },
	{  9215, "Beijing ISS" },
	{  9216, "Beijing ITMG/SG" },
	{  9217, "Shanghai ISS" },
	{  9218, "Shanghai ITMG/SG" },
	{  9219, "Guangzhou ISS" },
	{  9220, "Guangzhou ITMG/SG" },
	{  9221, "Shanghai ISTP2A'" },
	{  9222, "Guangzhou ISTP2B'" },
	{  9223, "GtoG International roaming value-added service platform iGRSP" },
	{  9224, "Beijing NGN SS" },
	{  9225, "Beijing NGN SG" },
	{  9226, "Harbin NGN SS" },
	{  9227, "Harbin NGN SG" },
	{  9228, "Urumqi NGN SS" },
	{  9229, "Urumqi NGN SG" },
	{  9280, "Kabul SMSC" },
	{  9281, "KBLMSS" },
	{  9282, "KBLMGW" },
	{  9283, "Roshan" },
	{  9284, "Roshan" },
	{  9285, "Roshan" },
	{  9286, "Roshan" },
	{  9287, "Roshan" },
	{  9288, "MSC-HRT" },
	{  9289, "MSC-M2R" },
	{  9290, "MSC-JLD" },
	{  9291, "MSC-KDR" },
	{  9292, "KBL1 MSC" },
	{  9293, "KBL2 MSC" },
	{  9294, "STP1" },
	{  9295, "STP2" },
	{  9296, "Mamss1-mazan" },
	{  9297, "Kamss1-PP" },
	{  9298, "Jamss1-jalalabad" },
	{  9299, "KDRMSS" },
	{  9300, "KDRMGW" },
	{  9304, "International Gateway,Mohakhali,Dhaka" },
	{  9305, "International Gateway,Banani,Dhaka" },
	{  9306, "International Gateway,Gulshan,Dhaka" },
	{  9307, "International Gateway,Baridhara,Dhaka" },
	{  9308, "International Gateway,Gulshan,Dhaka" },
	{  9309, "International Gateway, Banani,Dhaka" },
	{  9310, "International Gateway,Kawran Bazar,Dhaka" },
	{  9311, "International Gateway,Gulshan,Dhaka" },
	{  9312, "International Gateway, Mohakhali, Dhaka" },
	{  9313, "GMSC at Hosna Chamber, Gulshan Dhaka" },
	{  9314, "ITX-1/3 Magbazar, Dhaka" },
	{  9315, "ITX-2 Mohakhali, Dhaka" },
	{  9316, "ITX-4 Sylhet" },
	{  9317, "ITX-5 Mohakhali, Dhaka" },
	{  9318, "GMSC Mohakhali, Dhaka" },
	{  9319, "GMSC Mohakhali, Dhaka" },
	{  9320, "International Gateway, Gulshan, Dhaka" },
	{  9321, "ITX-6, Moghbazar, Dhaka" },
	{  9322, "ITX-7, Moghbazar, Dhaka" },
	{  9323, "GMSC, Motijheel, Dhaka" },
	{  9324, "GMSC, Uttara, Dhaka" },
	{  9325, "GMSC, Facilities Tower, Badda Dhaka" },
	{  9326, "GMSC, 3rd Floor, Pacific Center, 14 Mohakhali C/A, Dhaka" },
	{  9327, "GMSC, Ramna, Dhaka" },
	{  9328, "International Gateway, Banani, Dhaka" },
	{  9329, "International Gateway, Banani, Dhaka" },
	{  9330, "International Gateway, Gulshan, Dhaka" },
	{  9331, "International Gateway, Eskaton, Dhaka" },
	{  9332, "International Gateway, Banani, Dhaka" },
	{  9333, "GMSC, Facilities Tower, Badda,Dhaka" },
	{  9334, "International Gateway, Eskaton, Dhaka" },
	{  9335, "International Gateway, 26 Shaymoli, Bir Uttam A. W. Chowdhury Road, Dhaka" },
	{  9336, "International Gateway, Mohakhali, Dhaka" },
	{  9337, "International Gateway, Eskaton, Dhaka" },
	{  9338, "International Gateway, Segun Bagicha, Dhaka" },
	{  9339, "International Gateway, Panthopath, Dhaka" },
	{  9340, "International Gateway, Bir Uttam C.R. Datta Road, Dhaka" },
	{  9341, "International Gateway, Gulshan,Dhaka" },
	{  9342, "GMSC,Ramna,Dhaka" },
	{  9343, "International Gateway,Mohakhali,Dhaka" },
	{  9345, "DHRS3" },
	{  9346, "DHRMSC01" },
	{  9347, "WTMMSC01" },
	{  9348, "DHRMSC02" },
	{  9349, "WTM001" },
	{  9350, "DHRSOFTSWITCH01" },
	{  9351, "DHIRAAGU WCS1" },
	{  9352, "..." },
	{  9353, "Seoul Gateway" },
	{  9354, "..." },
	{  9355, "..." },
	{  9356, "..." },
	{  9357, "..." },
	{  9358, "..." },
	{  9359, "..." },
	{  9368, "Gwacheon Gateway" },
	{  9369, "Seoul Gateway" },
	{  9370, "..." },
	{  9371, "Seoul Gateway" },
	{  9372, "..." },
	{  9373, "..." },
	{  9374, "Seoul Gateway" },
	{  9375, "Seoul Gateway" },
	{  9376, "..." },
	{  9377, "Seoul Gateway" },
	{  9378, "Seoul Gateway" },
	{  9379, "Seoul Gateway" },
	{  9380, "..." },
	{  9381, "..." },
	{  9382, "..." },
	{  9383, "Seoul Gateway" },
	{  9384, "..." },
	{  9385, "..." },
	{  9386, "..." },
	{  9387, "..." },
	{  9388, "..." },
	{  9389, "..." },
	{  9390, "Seoul Gateway" },
	{  9391, "..." },
	{  9392, "Seoul Gateway" },
	{  9393, "..." },
	{  9394, "..." },
	{  9395, "..." },
	{  9396, "..." },
	{  9397, "Seoul Gateway" },
	{  9398, "..." },
	{  9399, "Seoul Gateway" },
	{  9400, "..." },
	{  9401, "Seoul Gateway" },
	{  9402, "..." },
	{  9403, "..." },
	{  9404, "Pusan" },
	{  9405, "Seoul Gateway" },
	{  9406, "Seoul Gateway" },
	{  9407, "..." },
	{  9408, "Seoul Gateway" },
	{  9409, "..." },
	{  9410, "..." },
	{  9411, "..." },
	{  9412, "..." },
	{  9413, "..." },
	{  9414, "..." },
	{  9415, "..." },
	{  9416, "Seoul Gateway" },
	{  9417, "Seoul Gateway" },
	{  9418, "Pusan Gateway" },
	{  9419, "..." },
	{  9420, "..." },
	{  9421, "..." },
	{  9422, "..." },
	{  9423, "..." },
	{  9424, "reserved" },
	{  9425, "reserved" },
	{  9426, "reserved" },
	{  9427, "reserved" },
	{  9428, "reserved" },
	{  9429, "reserved" },
	{  9430, "reserved" },
	{  9431, "reserved" },
	{  9448, "Dushanbe" },
	{  9449, "Dushanbe" },
	{  9450, "Dushanbe" },
	{  9451, "Dushanbe" },
	{  9452, "Khujand" },
	{  9453, "Dushanbe" },
	{  9454, "Khujand" },
	{  9455, "Khujand" },
	{  9456, "Dushanbe" },
	{  9457, "Dushanbe" },
	{  9458, "Khujand" },
	{  9459, "Dushanbe" },
	{  9460, "Khujand" },
	{  9461, "Dushanbe" },
	{  9462, "Khujand" },
	{  9463, "reserved" },
	{  9473, "Ashgabat" },
	{  9505, "Tashkent EWSD" },
	{  9506, "Tashkent AXE-10" },
	{  9507, "Tashkent NEAX-61" },
	{  9600, "CMIS01" },
	{  9601, "H18" },
	{  9602, "China Virtual (HR) Ltd" },
	{  9603, "ISC-M800-01" },
	{  9604, "S5" },
	{  9605, "H10" },
	{  9606, "ISC-M800-03" },
	{  9607, "HNKNHKBX00T" },
	{  9608, "HKLS" },
	{  9609, "S4" },
	{  9610, "CIT/HKG3" },
	{  9611, "FNT-HK" },
	{  9612, "ChinaMotion Netcom (Asia) Ltd." },
	{  9613, "Magitelecom" },
	{  9614, "Digital Pacific" },
	{  9615, "IDD 1628" },
	{  9616, "CMIS02" },
	{  9617, "CMTEL" },
	{  9618, "I001-HNK-POP" },
	{  9619, "S3" },
	{  9620, "HKT ISGW2" },
	{  9621, "HKTele1" },
	{  9622, "HKGSTP1" },
	{  9623, "APT Telecom Services Ltd." },
	{  9624, "S6" },
	{  9625, "H8" },
	{  9626, "CTTHK-INT" },
	{  9627, "CNHKC1" },
	{  9628, "CRC-HK" },
	{  9629, "HKCNW-1" },
	{  9630, "H10" },
	{  9631, "ISC-M800-04" },
	{  9632, "EC Telecom VS3000 Switch" },
	{  9633, "TMHK" },
	{  9634, "PIDD" },
	{  9635, "South China Telecommunications (HK) Ltd." },
	{  9636, "HTHKIU3" },
	{  9637, "Systech Telecom Ltd" },
	{  9638, "NTTCA-ISC-HKG01" },
	{  9639, "Kwai Chung/HKG3" },
	{  9640, "Sun55" },
	{  9641, "CMCC-HKISC2" },
	{  9642, "C&C08#2" },
	{  9644, "HKGW02" },
	{  9645, "ISC-M800-02" },
	{  9648, "MARU" },
	{  9649, "SmartGate2" },
	{  9650, "CITIC_H19" },
	{  9651, "SCHKGHDA" },
	{  9652, "PGW106" },
	{  9653, "SSHK01" },
	{  9654, "SSHK02" },
	{  9655, "PLDT HK POP" },
	{  9656, "HTHKIU5" },
	{  9657, "HTHKIU6" },
	{  9658, "TWHK01" },
	{  9659, "CTHK ACCESS GW1" },
	{  9660, "CTHK ACCESS GW2" },
	{  9661, "TASGWHK1" },
	{  9662, "CMTHK01" },
	{  9663, "CMIS03" },
	{  9664, "CMIS04" },
	{  9665, "CTG_HK_SS1_SS2" },
	{  9666, "CTG_HK_TG/SG" },
	{  9667, "CTG_HK_IN_USAU" },
	{  9668, "CTG_HK_IN_URP" },
	{  9712, "MTNLK 03" },
	{  9713, "MTNLK 04" },
	{  9714, "MOBI/WELI2" },
	{  9715, "ATLMSS01" },
	{  9716, "TOLLGATEWAY-2, Colombo" },
	{  9717, "HTLL-INT-PC" },
	{  9718, "Etisalat SL1" },
	{  9719, "Etisalat SL2" },
	{  9752, "" },
	{  9754, "" },
	{  9755, "" },
	{  9792, "IGW1" },
	{  9793, "IGW2" },
	{  9794, "IGW3" },
	{  9832, "GMSC Hanoi" },
	{  9833, "GMSC Ho Chi Minh" },
	{  9834, "NGN Gateway Hanoi, HiE9200 Exchange" },
	{  9835, "NGN Gateway Ho Chi Minh, HiE9200 Exchange" },
	{  9836, "STPHNI" },
	{  9837, "GTMSC Hanoi" },
	{  9838, "STPHCM" },
	{  9839, "GTMSC HoChiMinh" },
	{  9992, "YGIG01_01" },
	{  9993, "YGST01_01" },
	{  9994, "MDIG01_01" },
	{  9995, "MDST01_01" },
	{ 10000, "Yangon Signaling Gateway" },
	{ 10001, "Yangon International Gateway" },
	{ 10002, "Mandalay International Gateway" },
	{ 10003, "Mandalay Signaling Gateway" },
	{ 10004, "MSYA1" },
	{ 10005, "MSMA1" },
	{ 10006, "STYA1" },
	{ 10007, "STMA1" },
	{ 10008, "FBD SS7" },
	{ 10009, "SELCOM ALBANIA" },
	{ 10016, "Free – XC27 – Courbevoie 2" },
	{ 10017, "Free – XD13 – Paris 2" },
	{ 10018, "Completel – Champs sur Marne 1" },
	{ 10019, "Completel – Champs sur Marne 2" },
	{ 10020, "Bouygues Telecom - MG008 - Nanterre" },
	{ 10021, "Bouygues Telecom - MG011 - Crosne" },
	{ 10022, "Bouygues Telecom - MGNR3 -Nanterre" },
	{ 10024, "London 1" },
	{ 10025, "LON STP2" },
	{ 10026, "London" },
	{ 10027, "London" },
	{ 10028, "LON001 GSX2" },
	{ 10029, "LON002 GSX2" },
	{ 10030, "Lon-MSS1" },
	{ 10032, "Almere" },
	{ 10033, "Almere" },
	{ 10034, "AMS5 datacenter (Interaxion), tupolelaan 101 1119PA Ams" },
	{ 10035, "AMS5 datacenter, Rack space 130C AMS 5.1, Amsterdam" },
	{ 10036, "AMS5 datacenter, Rack space 130C AMS 5.1, Amsterdam" },
	{ 10037, "AMS5 datacenter (Interaxion), Amsterdam" },
	{ 10038, "Amsterdam-2K, Amsterdam" },
	{ 10039, "AMSITP03, Amsterdam" },
	{ 10048, "TUSMGW3" },
	{ 10049, "SZSLOLJMSCS" },
	{ 10050, "SZSLOLJSTP" },
	{ 10051, "SZSLOMBSTP" },
	{ 10052, "AKTON Ljubljana 2" },
	{ 10056, "Ucom" },
	{ 10057, "Griar" },
	{ 10058, "GNC Alfa" },
	{ 10064, "AMDGR01" },
	{ 10065, "Athens Alexandra : MGWALE4" },
	{ 10066, "Pallini TSC-S (for voice functionality) (TSAPI_BC)" },
	{ 10067, "Pireos TSC-S (for voice functionality) (TSAPS_BC)" },
	{ 10072, "" },
	{ 10073, "" },
	{ 10076, "" },
	{ 10077, "" },
	{ 10078, "" },
	{ 10080, "" },
	{ 10081, "" },
	{ 10082, "" },
	{ 10083, "" },
	{ 10084, "" },
	{ 10085, "" },
	{ 10086, "" },
	{ 10087, "" },
	{ 10088, "SOTUS Fra" },
	{ 10089, "SOTUS Riga" },
	{ 10090, "IT Baltija" },
	{ 10091, "SN Riga" },
	{ 10092, "Riga IG 1" },
	{ 10093, "TGB 1" },
	{ 10094, "TGB 2" },
	{ 10095, "TGT 1" },
	{ 10096, "ASD STP, Nieuwe Hemweg 6P, Am" },
	{ 10097, "PGW/MGX cluster Amsterdam en Rotterdam, Amsterdam/Rotterdam" },
	{ 10098, "ATTAMSTNLBWGS0, Amsterdam, J.Huizing" },
	{ 10099, "TB-RCoo1-MGCoo1, Winschoterdiep 60, G" },
	{ 10100, "Hoognael 0 1L, Toldijk 19B Hoogevee" },
	{ 10101, "gn-rc0002, winschoterdiep 50 9723 groning" },
	{ 10102, "tb-rc0001, goirkekanaaldijk 44 tilburg" },
	{ 10103, "PGW/MGX cluster Amsterdam en Rotterdam" },
	{ 10104, "London 1" },
	{ 10105, "London 2" },
	{ 10106, "London" },
	{ 10107, "London GSX" },
	{ 10108, "Douglas 2" },
	{ 10109, "L/FAR/HM1 AXD" },
	{ 10110, "L/FAR/SM1 AXD" },
	{ 10111, "Int SCCP Signalling connection with Belgacom" },
	{ 10113, "London 1" },
	{ 10116, "London 1" },
	{ 10117, "DDCLVERAZ1" },
	{ 10118, "Switch 3 – Docklands 2" },
	{ 10119, "Hawaii 1" },
	{ 10120, "DN1MSS04" },
	{ 10121, "BL0MGW05" },
	{ 10122, "SONUS INTERNATIONAL" },
	{ 10123, "Validsoft-Dublin" },
	{ 10124, "SEP680MSS2" },
	{ 10125, "SEP706MSS2" },
	{ 10126, "STP680MGW3" },
	{ 10127, "STP422MGW3" },
	{ 10130, "IM441" },
	{ 10131, "KSTP1" },
	{ 10132, "LSTP2" },
	{ 10133, "KSISC1" },
	{ 10134, "FRTKV2" },
	{ 10135, "ETTUA" },
	{ 10136, "VFN-INT-ITP1" },
	{ 10137, "VFN-INT-ITP4" },
	{ 10138, "Bp. MGWG" },
	{ 10140, "Debrecen-DIGIMOBIL-01" },
	{ 10141, "Budapest-DIGIMOBIL-02" },
	{ 10142, "Debrecen-DIGIMOBIL-02" },
	{ 10143, "VFHU-INT-HWSTP1" },
	{ 10144, "Frankfurt" },
	{ 10145, "STP_BBN1" },
	{ 10146, "Frankfurt" },
	{ 10147, "Frankfurt" },
	{ 10148, "Dortmund" },
	{ 10149, "Hannover" },
	{ 10150, "Frankfurt" },
	{ 10151, "Frankfurt" },
	{ 10153, "OTG_SMX_KT" },
	{ 10154, "OTG_ SG_KT2" },
	{ 10155, "ΟΝ-ΑΤΗ" },
	{ 10156, "Wind Hellas Fixed Network - TATN03" },
	{ 10157, "Reserved for future use" },
	{ 10158, "Kvlonos antigonis 4" },
	{ 10159, "OTG_ SG_KT" },
	{ 10160, "Frankfurt" },
	{ 10161, "Frankfurt" },
	{ 10162, "Hamm W9511" },
	{ 10163, "Frankfurt" },
	{ 10164, "Frankfurt" },
	{ 10165, "Frankfurt" },
	{ 10166, "Frankfurt" },
	{ 10167, "Frankfurt" },
	{ 10168, "Hawaii 2" },
	{ 10169, "MSCS D1" },
	{ 10170, "MSCS S1" },
	{ 10171, "LMUK-MSC2" },
	{ 10172, "London" },
	{ 10173, "X Gate" },
	{ 10174, "Lovat" },
	{ 10175, "Tufnell Park AXD B" },
	{ 10176, "Železnik/VBG01BG" },
	{ 10177, "Bežanija/VBZ01BC" },
	{ 10178, "Beograd MSCS1" },
	{ 10179, "Beograd STP1" },
	{ 10180, "Telenor Belgrade 1" },
	{ 10181, "Kragujevac STP2" },
	{ 10182, "Telenor Belgrade 3" },
	{ 10183, "Telenor Belgrade 4" },
	{ 10184, "PGW-Zg" },
	{ 10185, "STP-Zg" },
	{ 10186, "SSW Zagreb1" },
	{ 10188, "H1-ZG01" },
	{ 10189, "MSS2 Rijeka" },
	{ 10190, "METRONET-ZG-001" },
	{ 10192, "MPL OMA" },
	{ 10193, "OPL WAW 5" },
	{ 10194, "AER WAW 1" },
	{ 10195, "MNI WAW" },
	{ 10196, "BTP WAW" },
	{ 10197, "TMP WAW 3" },
	{ 10198, "POL POZ 1" },
	{ 10199, "AER WAW 2" },
	{ 10200, "STP Bratislava" },
	{ 10201, "STP Banská Bystrica" },
	{ 10202, "MSC Svaty Jur" },
	{ 10203, "MSC Kosice" },
	{ 10204, "ISC Bratislava" },
	{ 10205, "SonusTest" },
	{ 10206, "SonusTest" },
	{ 10207, "ISC Kosice" },
	{ 10208, "Oradea" },
	{ 10209, "Timisoara" },
	{ 10210, "Bucuresti" },
	{ 10211, "Bucuresti (GSM-R networks)" },
	{ 10212, "Bucuresti" },
	{ 10213, "Bucuresti" },
	{ 10215, "Bucuresti" },
	{ 10216, "FUCINO 1" },
	{ 10218, "Colne" },
	{ 10219, "STP D1" },
	{ 10220, "London 1" },
	{ 10221, "FUCINO 2" },
	{ 10222, "Telehouse" },
	{ 10223, "UC LONDON1" },
	{ 10224, "STP S1" },
	{ 10225, "ECO-BHG1-THO" },
	{ 10228, "Manchester-M66" },
	{ 10229, "Birmingham-M67" },
	{ 10231, "ZTA London" },
	{ 10232, "Beult" },
	{ 10233, "London Harbour Exchange" },
	{ 10234, "LONDON" },
	{ 10235, "Belfast Switch 1" },
	{ 10237, "Manchester DMS100 1" },
	{ 10238, "Tufnell Park" },
	{ 10239, "LMUK-STP1" },
	{ 10248, "IGW 4" },
	{ 10256, "STZSH1" },
	{ 10257, "STZSK1" },
	{ 10258, "ISZSH1" },
	{ 10259, "ISZSK1" },
	{ 10260, "P1KLJISTP01" },
	{ 10261, "P1JRCISTP01" },
	{ 10262, "CBYSTP01" },
	{ 10263, "CBYMSC01" },
	{ 10264, "RSHSSHW01" },
	{ 10268, "SGSWA" },
	{ 10270, "IGHTB" },
	{ 10271, "REDtone ISC AIMS-MY" },
	{ 10272, "LBN" },
	{ 10273, "KLJ" },
	{ 10274, "KLR" },
	{ 10275, "TM IGWKL1" },
	{ 10276, "TM IGWKL2" },
	{ 10277, "TM IGWKL3" },
	{ 10278, "CEL IGWSHT" },
	{ 10279, "CEL IGWKPG" },
	{ 10281, "FINLA" },
	{ 10282, "IGWYSHT01" },
	{ 10283, "IGWYKPG01" },
	{ 10286, "DTI" },
	{ 10287, "MTI" },
	{ 10290, "Time ISC (Glenmarie)" },
	{ 10291, "Time ISC (UPM)" },
	{ 10293, "TM IGWKL4" },
	{ 10294, "TM IGWKL5" },
	{ 10295, "TM IGWKL6" },
	{ 10299, "Melaka DTS" },
	{ 10300, "vSPSSH1" },
	{ 10301, "vSPSSK1" },
	{ 10302, "STHSH1" },
	{ 10303, "STHSK1" },
	{ 10304, "Pasir Mas DTS" },
	{ 10308, "STHTC" },
	{ 10312, "CEL IGWSAL1" },
	{ 10313, "CEL IGWKPG2" },
	{ 10314, "STKPA" },
	{ 10315, "IGSTA" },
	{ 10316, "IGKPA" },
	{ 10317, "UPSHB" },
	{ 10318, "TTIG1" },
	{ 10320, "Sydney" },
	{ 10321, "Sydney" },
	{ 10322, "S12 Model No. 1" },
	{ 10323, "IN Test Platform" },
	{ 10324, "Sydney" },
	{ 10325, "Sydney" },
	{ 10326, "Sydney" },
	{ 10327, "Sydney" },
	{ 10328, "Sydney, SYFx" },
	{ 10329, "Sydney Test Switch" },
	{ 10330, "Sydney" },
	{ 10331, "Sydney" },
	{ 10332, "Mobile Satellite - Geostationary" },
	{ 10333, "Mobile Satellite - Geostationary" },
	{ 10334, "Mobile Satellite - MEO (NGII)" },
	{ 10335, "Mobile Satellite - MEO" },
	{ 10336, "Sydney switch ID = S2SB" },
	{ 10338, "Melbourne switch ID = S3MB" },
	{ 10339, "REIN" },
	{ 10340, "Melbourne-Australia-IPSystems-SLT1" },
	{ 10341, "Melbourne-Australia-IPSystems-SLT2" },
	{ 10342, "TNZAI" },
	{ 10343, "Melbourne" },
	{ 10344, "Sydney" },
	{ 10345, "Sydney" },
	{ 10346, "Sydney" },
	{ 10347, "Melbourne" },
	{ 10348, "Melbourne" },
	{ 10349, "Sydney" },
	{ 10350, "Sydney" },
	{ 10351, "BT Global Office Sydney Can" },
	{ 10352, "Sydney" },
	{ 10353, "Sydney" },
	{ 10354, "Sydney" },
	{ 10355, "Norfolk Island-GSMC" },
	{ 10356, "Norfolk Island-International switch PSTN gateway" },
	{ 10357, "IDT-Sydney" },
	{ 10358, "Sydney" },
	{ 10359, "Sydney" },
	{ 10360, "Sydney" },
	{ 10361, "Sydney" },
	{ 10362, "SYD/PCT" },
	{ 10363, "Globalstar Sydney" },
	{ 10364, "Sydney" },
	{ 10365, "Melbourne" },
	{ 10366, "Sydney" },
	{ 10367, "Perth" },
	{ 10368, "Sydney" },
	{ 10369, "Sydney" },
	{ 10370, "Melbourne" },
	{ 10371, "Melbourne (1999)" },
	{ 10372, "Melbourne (1999)" },
	{ 10373, "Sydney (1999)" },
	{ 10374, "Sydney (Siemens)" },
	{ 10375, "Melbourne (Siemens)" },
	{ 10376, "SYF6" },
	{ 10377, "SYF7" },
	{ 10378, "SYF8" },
	{ 10379, "SYF9" },
	{ 10380, "Cell Wireless Switch - Sydney" },
	{ 10381, "Sydney" },
	{ 10382, "Pivotel Sydney 1" },
	{ 10383, "Pivotel Sydney 2" },
	{ 10384, "1-Syd" },
	{ 10385, "SGX-Sydney, Australia" },
	{ 10386, "NTMI - SYD01" },
	{ 10387, "NTMI - SYD02" },
	{ 10388, "NTMI - BRI01" },
	{ 10389, "NTMI - BRI02" },
	{ 10390, "NTMI - MEL01" },
	{ 10391, "NTMI - MEL02" },
	{ 10392, "Sydney, SYDT" },
	{ 10393, "Sydney, SYD0" },
	{ 10394, "Melbourne, MEZ0" },
	{ 10395, "Sydney, SYF1" },
	{ 10396, "SYF2" },
	{ 10397, "Sydney, SYF3" },
	{ 10398, "Sydney, SYF4" },
	{ 10399, "Sydney, SYF5" },
	{ 10400, "Jakarta-1b ISC" },
	{ 10401, "Jakarta-1a ISC" },
	{ 10402, "Medan-2a ISC" },
	{ 10403, "Batam-3 ISC" },
	{ 10404, "Surabaya-4 ISC" },
	{ 10405, "Int'l SCCP-1" },
	{ 10406, "Jakarta-1 ISC" },
	{ 10407, "Jakarta-2 ISC" },
	{ 10408, "Jakarta-1C ISC" },
	{ 10409, "Int'l SCCP" },
	{ 10410, "Medan-2b ISC" },
	{ 10411, "ICO SP" },
	{ 10412, "IN SP" },
	{ 10413, "Medan ISC" },
	{ 10414, "Int'l SCCP" },
	{ 10415, "Denpasar ISC" },
	{ 10416, "Int'l SCCP" },
	{ 10417, "Int'l SCCP-1" },
	{ 10418, "Int'l SCCP-2" },
	{ 10419, "Int'l SCCP" },
	{ 10420, "reserved" },
	{ 10421, "Int'l ISC" },
	{ 10422, "Int'l ISC" },
	{ 10423, "Int'l ISC" },
	{ 10424, "STP Jakarta" },
	{ 10425, "STP Surabaya" },
	{ 10426, "Int'l SCCP-1" },
	{ 10427, "SCCP" },
	{ 10428, "Batam ISC" },
	{ 10429, "SCCP" },
	{ 10430, "Jakarta ISC" },
	{ 10431, "Surabaya ISC" },
	{ 10432, "..." },
	{ 10433, "..." },
	{ 10434, "..." },
	{ 10435, "..." },
	{ 10436, "..." },
	{ 10437, "..." },
	{ 10440, "International Gateway Jakarta" },
	{ 10480, "..." },
	{ 10481, "Metro Manila 1" },
	{ 10482, "Metro Manila 2" },
	{ 10483, "Metro Manila 3" },
	{ 10484, "..." },
	{ 10485, "..." },
	{ 10486, "..." },
	{ 10487, "..." },
	{ 10488, "..." },
	{ 10489, "..." },
	{ 10490, "..." },
	{ 10491, "..." },
	{ 10492, "..." },
	{ 10493, "SCC, Makati City" },
	{ 10494, "SCC, Makati City" },
	{ 10495, "SCC, Makati City" },
	{ 10496, "..." },
	{ 10497, "..." },
	{ 10498, "..." },
	{ 10499, "..." },
	{ 10500, "Manila GSM" },
	{ 10501, "GSM" },
	{ 10502, "GSM" },
	{ 10503, "Cebu City GSM" },
	{ 10504, "..." },
	{ 10505, "..." },
	{ 10506, "..." },
	{ 10507, "..." },
	{ 10508, "..." },
	{ 10509, "..." },
	{ 10510, "..." },
	{ 10511, "..." },
	{ 10512, "Makati City" },
	{ 10513, "Makati City" },
	{ 10514, "Makati City" },
	{ 10515, "..." },
	{ 10516, "..." },
	{ 10517, "..." },
	{ 10518, "..." },
	{ 10519, "..." },
	{ 10520, "..." },
	{ 10521, "GSM" },
	{ 10522, "GSM" },
	{ 10523, "..." },
	{ 10524, "..." },
	{ 10525, "..." },
	{ 10526, "..." },
	{ 10527, "..." },
	{ 10528, "..." },
	{ 10529, "..." },
	{ 10530, "..." },
	{ 10531, "..." },
	{ 10532, "" },
	{ 10533, "" },
	{ 10534, "" },
	{ 10535, "" },
	{ 10536, "" },
	{ 10537, "philipppines" },
	{ 10538, "" },
	{ 10539, "" },
	{ 10540, "" },
	{ 10541, "" },
	{ 10542, "" },
	{ 10543, "" },
	{ 10544, "" },
	{ 10546, "Philippines" },
	{ 10552, "BPL/POI (AWN-ISC1)" },
	{ 10553, "RST/POI (AWN-ISC2)" },
	{ 10554, "TIC-TYN-1" },
	{ 10555, "TIC-MTG-1" },
	{ 10556, "TIC-TYN-3" },
	{ 10557, "TIC-MTG-3" },
	{ 10560, "ITSC4B" },
	{ 10561, "ITSC1/IMS1" },
	{ 10562, "ITSC2/IMS2" },
	{ 10563, "ITSC3/STP3" },
	{ 10564, "ITSC4A" },
	{ 10565, "STP1" },
	{ 10566, "STP2" },
	{ 10567, "STP4" },
	{ 10568, "ST-RST" },
	{ 10569, "TOT - ISG1 - KKM" },
	{ 10570, "TOT - IGW1 - KKM" },
	{ 10571, "TOT - IGW2 - HY1" },
	{ 10572, "TOT - ISG2 - HY1" },
	{ 10573, "NSC -1 - KKM" },
	{ 10574, "NSC -1 - HY1" },
	{ 10575, "IGW – STS" },
	{ 10576, "IG – RST" },
	{ 10577, "BPL/POI (AIN-ISC1)" },
	{ 10578, "RST/POI (AIN-ISC2)" },
	{ 10579, "N&T STP – A" },
	{ 10580, "N&T STP – B" },
	{ 10581, "N&T SG" },
	{ 10582, "ST – SNK" },
	{ 10583, "IG – SNK" },
	{ 10584, "IGW – JMN" },
	{ 10585, "IGW – AYA" },
	{ 10586, "STP – C" },
	{ 10587, "STP – D" },
	{ 10588, "MSC-LKS" },
	{ 10589, "MGW-LKS" },
	{ 10590, "MSC-KKM" },
	{ 10591, "MGW-KKM" },
	{ 10592, "BPL/POI (AIN-STP1)" },
	{ 10593, "BPL/POI (AIN-STP2)" },
	{ 10594, "IGW_RST2 (MSC-S)" },
	{ 10595, "IGW_RST2 (MGW)" },
	{ 10596, "IGW_SNK2 (MSC-S)" },
	{ 10597, "IGW_SNK2 (MGW)" },
	{ 10598, "BPL/POI (AWN-STP1)" },
	{ 10599, "TWA/POI (AWN-STP2)" },
	{ 10600, "SingTel OC - INGS-3" },
	{ 10601, "SingTel OC - STP-1" },
	{ 10602, "SingTel OC - STP-2" },
	{ 10603, "SingTel OC - STP-3" },
	{ 10604, "Telekom Malaysia - Equinix 3" },
	{ 10605, "Telekom Malaysia - Equinix 4" },
	{ 10606, "ComNet Telecom Equinix" },
	{ 10608, "StarHub - TSS-STP-3" },
	{ 10609, "SingTel Globalstar - SSP-1" },
	{ 10610, "SingTel Globalstar - STP-1" },
	{ 10611, "SingTel Globalstar - STP-2" },
	{ 10612, "SingTel AR - INGS-1" },
	{ 10613, "SingTel AR - STP-1" },
	{ 10614, "SingTel OC - INGS-1" },
	{ 10615, "SingTel OC - INGS-2" },
	{ 10616, "FM-STP1" },
	{ 10617, "FM-STP2" },
	{ 10619, "Global Crossing - Tai Seng Drive" },
	{ 10620, "StarHub - KJS-STP-2" },
	{ 10621, "StarHub - TSS-STP-2" },
	{ 10623, "StarHub - KBS-STP-3" },
	{ 10624, "ComNet ESE" },
	{ 10625, "Nexwave - Ang Mo Kio 2" },
	{ 10626, "Bludot-Pantech 21" },
	{ 10627, "VSNL-SNG Cable Landind Station" },
	{ 10628, "M1-MOC-STP" },
	{ 10629, "M1-ROC-STP" },
	{ 10630, "Asia Netcom - Tai Seng" },
	{ 10631, "ComNet Telecom Sonus" },
	{ 10632, "StarHub-KBS-STP" },
	{ 10633, "StarHub-TSS-STP" },
	{ 10634, "VSNL-Tai Seng" },
	{ 10635, "Blueberry" },
	{ 10636, "C&W Equinix, Ayer Rajah" },
	{ 10637, "Singapore Smart Telecom - Equinix Ayer Rajah" },
	{ 10638, "BT Singapore - Tai Seng Drive" },
	{ 10639, "SingTel-ITP 1" },
	{ 10640, "Enhanced Software Service Centre (SCII)" },
	{ 10641, "Gateway (SNE)" },
	{ 10642, "Gateway (SNC)" },
	{ 10643, "GSM (MSC1) (CMRS3)" },
	{ 10644, "GSM (MSC2) (CMRS3)" },
	{ 10645, "Gateway (SNP)" },
	{ 10646, "GATES (SSP)" },
	{ 10647, "GT/GATES Software Service Centre" },
	{ 10648, "Media Gateway Controller - MGC A" },
	{ 10649, "Media Gateway Controller - MGC B" },
	{ 10650, "City Interconnect Tandem (CYNX)" },
	{ 10651, "Hougan Interconnect Tandem (HGNX)" },
	{ 10652, "Pickering Gateway-Trunk (PGT)" },
	{ 10653, "Comcentre Gateway-Trunk (CGT)" },
	{ 10654, "PLDT - Ayer Rajah Crescent" },
	{ 10655, "Inmarsat B (Planned)" },
	{ 10656, "International standalone STP-2" },
	{ 10657, "East Gateway - Trunk (EGT)" },
	{ 10658, "SESS Model 2000 Software Service Centre" },
	{ 10659, "GNC (Global Network Comcentre)" },
	{ 10660, "MCI - Singapore 1" },
	{ 10661, "M1-MOC" },
	{ 10662, "M1-ROC" },
	{ 10663, "Blueberry" },
	{ 10664, "KPJI Switch" },
	{ 10665, "TSGI Switch" },
	{ 10666, "I2U - Singapore Technologies Building" },
	{ 10667, "Redtone Technology - Equinix" },
	{ 10668, "ETN Singapore - Ayer Rajah Crescent" },
	{ 10669, "MCI - Singapore 2" },
	{ 10670, "France Telecom - Chai Chee" },
	{ 10673, "Telekom Malaysia - Equinix" },
	{ 10674, "Telekom Malaysia - Equinix 2" },
	{ 10675, "Itopia-GNCC" },
	{ 10676, "Inmarsat M/B/Mini-M Land Earth station_1 (LES)" },
	{ 10679, "Nexwave - Ang Mo Kio" },
	{ 10680, "ETNS - Changi" },
	{ 10681, "Interconnect Technology - Kimly Bdlg" },
	{ 10682, "PLDT - Tai Seng Drive" },
	{ 10683, "Teleone Tai Seng Drive" },
	{ 10684, "M1-SCCP1" },
	{ 10685, "M1-SCCP2" },
	{ 10686, "SingTel-ITP 2" },
	{ 10687, "ComNet IMG" },
	{ 10688, "DST International Gateway 2" },
	{ 10689, "BR1" },
	{ 10690, "BR2" },
	{ 10691, "DST International Gateway" },
	{ 10692, "DST International Gateway 2" },
	{ 10693, "" },
	{ 10694, "" },
	{ 10695, "" },
	{ 10696, "DSTIGW1 Telanai Exchange, Beribi" },
	{ 10697, "DSTIGW1 Telanai Exchange, Beribi" },
	{ 10698, "PCSB Gateway" },
	{ 10720, "GTY5 (Mayoral Drive)" },
	{ 10721, "GTY6 (Takapuna)" },
	{ 10723, "2DMSC1" },
	{ 10726, "Easycall" },
	{ 10727, "GTY7 (Mayoral Drive)" },
	{ 10728, "COMPI" },
	{ 10729, "AKP1" },
	{ 10730, "2DSTP1" },
	{ 10731, "2DSTP2" },
	{ 10733, "ACS1 (Mayoral Drive STP)" },
	{ 10734, "CPA2" },
	{ 10735, "ACS2 (Takapuna STP)" },
	{ 10736, "WCS09 (Model)" },
	{ 10737, "MGW2 (Model)" },
	{ 10738, "WCS02 (Mayoral Drive)" },
	{ 10739, "MGW02 (Mayoral Drive)" },
	{ 10740, "WCS02 (Christchurch)" },
	{ 10741, "MGW02 (Christchurch)" },
	{ 10742, "FTMG3" },
	{ 10743, "FTMS1" },
	{ 10745, "LDMG3" },
	{ 10746, "MSC3" },
	{ 10747, "WLNX" },
	{ 10748, "AUCX (A100)" },
	{ 10749, "Mayoral Drive STP" },
	{ 10750, "GTY8 (Takapuna)" },
	{ 10751, "2DMSC2" },
	{ 10761, "AUCS (ASTP)" },
	{ 10762, "WLNS (WSTP)" },
	{ 10766, "WCS01 (Mayoral Drive)" },
	{ 10767, "WCS201 (Christchurch)" },
	{ 10777, "LDMS1" },
	{ 10778, "WXCI" },
	{ 10781, "WCS05" },
	{ 10782, "Mobile Lab" },
	{ 10783, "Mobile Lab" },
	{ 10800, "Harmon (1), Guam" },
	{ 10801, "Harmon, Guam" },
	{ 10803, "Harmon (3), Guam" },
	{ 10804, "Harmon, Guam" },
	{ 10805, "Upper Tumon, Guam" },
	{ 10818, "Digicel Nauru Ltd" },
	{ 10819, "Digicel Nauru Ltd" },
	{ 10832, "LAEMGW" },
	{ 10833, "LAEMSC-S" },
	{ 10834, "POM_MSC_1" },
	{ 10835, "LAEG" },
	{ 10836, "POMG" },
	{ 10837, "POM_MSC" },
	{ 10838, "POMMSC-S" },
	{ 10839, "B-Mobile" },
	{ 10842, "POMMGW" },
	{ 10864, "Nuku'alofa switch" },
	{ 10869, "..." },
	{ 10896, "Port Vila" },
	{ 10897, "Port Vila" },
	{ 10899, "MGW Port-Vila" },
	{ 10900, "Port-Vila" },
	{ 10902, "Digical Pacific Ltd, Hong Kong" },
	{ 10903, "Ellouk, Port Vila, Vanuatu" },
	{ 10912, "FINTEL ISC-1" },
	{ 10913, "FINTEL ISC-2" },
	{ 10914, "VODAFONE MSC-1" },
	{ 10915, "VODAFONE MGw-1 Suva" },
	{ 10916, "Vodafone MGw Lautoka" },
	{ 10917, "Vodafone MSC-2 Lautoka" },
	{ 10918, "DIGICEL MSC" },
	{ 10919, "DIGICEL" },
	{ 10920, "FINTEL STP-1" },
	{ 10921, "FINTEL STP-2" },
	{ 10922, "FINTEL FW" },
	{ 10923, "FINTEL-3" },
	{ 10944, "Pago Pago, American Samoa" },
	{ 10948, "Pago Pago, AS" },
	{ 10976, "Noumea Gallieni" },
	{ 10977, "Noumea PK5" },
	{ 10978, "Noumea PK5IGP1" },
	{ 10979, "Noumea IGP2" },
	{ 10980, "Nouméa Gallieni HC4" },
	{ 10981, "Nouméa CITIUS" },
	{ 10992, "Commutateur Papeete" },
	{ 10993, "Commutateur FAAA" },
	{ 10994, "Centre de commutation, Papeete" },
	{ 10995, "IMS Coeur 4G" },
	{ 10996, "MSC HW RDO" },
	{ 10997, "MSC ALU RDO" },
	{ 10998, "MSC NGN HDP" },
	{ 10999, "MSC NGN FU" },
	{ 11008, "AVR-MOB" },
	{ 11009, "AVR-HDX" },
	{ 11010, "ARO-MOB" },
	{ 11011, "ARO-HDX" },
	{ 11024, "Int-Gateway/PSTN Switch" },
	{ 11028, "Mobile Int Roaming 1" },
	{ 11029, "Mobile Int Roaming 2" },
	{ 11040, "ATHKL_TARAWA" },
	{ 11096, "Kolonia, GSM" },
	{ 11097, "Kolonia, PSTN" },
	{ 11120, "Palau Communication & Electronics Company" },
	{ 11125, "PMCI STP01" },
	{ 11126, "PMCI STP02" },
	{ 11144, "Saipan, Northern Marianas" },
	{ 11160, "SYF 10" },
	{ 11161, "SYF 11" },
	{ 11162, "SYF 12" },
	{ 11163, "SYF 13" },
	{ 11164, "PCM1" },
	{ 11165, "Sydney PYR1" },
	{ 11166, "Sydney GLB1" },
	{ 11167, "Sydney CAS1" },
	{ 11168, "Sydney PCM2" },
	{ 11169, "C2CA" },
	{ 11170, "EPS1 (Sydney 1)" },
	{ 11171, "EPS2 (Sydney 2)" },
	{ 11172, "EPM1 (Melbourne 1)" },
	{ 11173, "EPM2 (Melbourne 2)" },
	{ 11174, "Sydney" },
	{ 11175, "Melbourne" },
	{ 11176, "Sydney" },
	{ 11177, "Prodigy Sydney Switch" },
	{ 11178, "Prodigy Melbourne Switch" },
	{ 11179, "AlphaSydney 01-05" },
	{ 11180, "HI-Tel" },
	{ 11181, "TP1SYDNEY" },
	{ 11182, "SYD-DIG01" },
	{ 11183, "SYD-DIG02" },
	{ 11184, "ANCSYD01" },
	{ 11185, "GSX-Sydney, Australia" },
	{ 11186, "Tel.Pacific-Sydney-01" },
	{ 11187, "Tel.Pacific-Sydney-02" },
	{ 11188, "TP2SYDNEY" },
	{ 11189, "TP1MELBOURNE" },
	{ 11190, "TP2MELBOURNE" },
	{ 11191, "TP1BRISBANE" },
	{ 11192, "TP1CANBERRA" },
	{ 11193, "TP1PERTH" },
	{ 11194, "TP1ADELAIDE" },
	{ 11195, "TP1NEWCASTLE" },
	{ 11196, "ATX-MELBOURNE Q767-1" },
	{ 11197, "ATX-SYDNEY Q767-1" },
	{ 11198, "Sydney-Australia-IPSystems-SLT1" },
	{ 11199, "Sydney-Australia-IPSystems-SLT1" },
	{ 11200, "MelbVzbIMG-1" },
	{ 11201, "MelbVzbIMG-2" },
	{ 11204, "BNE2 - MEDIAGW01" },
	{ 11205, "SYM-IMG-WS-02-MAS-AV" },
	{ 11207, "GG-SYDNEY-1" },
	{ 11208, "SYDNEY SGX - AUSTRALIA" },
	{ 11209, "SYDNEY GSX - AUSTRALIA" },
	{ 11210, "LM-SYD-NGN1" },
	{ 11211, "LM-SYD-NGN2" },
	{ 11212, "LM-SYD-STP1" },
	{ 11213, "LM-SYD-STP2" },
	{ 11215, "SYM-IMG-WS-02-MAS-AU" },
	{ 11216, "P2SC" },
	{ 11217, "Inmarsat Sydney 1" },
	{ 11218, "Pivotel Sydney 3" },
	{ 11219, "SYDM" },
	{ 11220, "SYDOM" },
	{ 11221, "SYDPM" },
	{ 11222, "Sydney" },
	{ 11223, "Melbourne" },
	{ 11224, "CONCERSYD" },
	{ 11280, "Telin 2" },
	{ 11281, "Dili" },
	{ 11282, "TT M-2 (NOVA)" },
	{ 11283, "TT M-3" },
	{ 11284, "TT M-4" },
	{ 11285, "Viettel 1" },
	{ 11286, "Viettel 2" },
	{ 11287, "Telin 1" },
	{ 11360, "M1-NGN SG1" },
	{ 11361, "M1-NGN SS1" },
	{ 11362, "BBT_PC_2" },
	{ 11363, "BBT_PC" },
	{ 11364, "Telewest-TFN-HK" },
	{ 11365, "Belgacom Equinix" },
	{ 11367, "HOIIO" },
	{ 11369, "TELIN - ISS" },
	{ 11370, "Epsilon -Smilous" },
	{ 11372, "Equinix Data center" },
	{ 11373, "M1-MOC-NGN SG" },
	{ 11374, "M1-MOC-NGN SS" },
	{ 11375, "M1-TMOC2" },
	{ 11376, "M1-TROC2" },
	{ 11377, "Equinix" },
	{ 11378, "Equinix Data Centre" },
	{ 11379, "Equinix Singapore" },
	{ 11380, "Equinix Singapore" },
	{ 11381, "Equinix Data Centre" },
	{ 11382, "SingTel Expan" },
	{ 11383, "1-Net - Chai Chee Technopark" },
	{ 11384, "Equinix SG 1" },
	{ 11385, "Equinix SG 1-1" },
	{ 11386, "Reliance Jio - Equinix" },
	{ 11387, "Hello Technology – Starhub IO DC" },
	{ 11388, "WHC - Epsilon1" },
	{ 11389, "WHC - Epsilon2" },
	{ 11390, "South China Telecom - Equinix" },
	{ 11391, "Equinix SG1" },
	{ 11392, "SMSC1 1-Net @ Chai Chee" },
	{ 11393, "NGT-IMG1" },
	{ 11394, "NGT-TMG1" },
	{ 11395, "NGT-SMSC1" },
	{ 11396, "DC1_CloudCS01" },
	{ 11397, "DC2_CloudCS01" },
	{ 11398, "DC1_MGW01" },
	{ 11399, "DC2_MGW01" },
	{ 11400, "STP-Sonus Singapore 1" },
	{ 11401, "STP-Sonus Singapore 2" },
	{ 11402, "ARS" },
	{ 11403, "TSS" },
	{ 11960, "FEBO, Limassol" },
	{ 11968, "SAPIRL1" },
	{ 11969, "SAPIRL2" },
	{ 11970, "MSCCL1" },
	{ 11971, "MSCKW1" },
	{ 11972, "TB0M5581" },
	{ 11973, "TB01M5582" },
	{ 11974, "TB0MGW01" },
	{ 11975, "TB0MGW02" },
	{ 11984, "VFHU-INT-HWSTP4" },
	{ 12000, "TMMK MGw2" },
	{ 12001, "MGW Makedonija" },
	{ 12002, "WTI SK" },
	{ 12003, "MSCBL1 (SPX2)" },
	{ 12004, "MGC1 (Skopje)" },
	{ 12005, "MGC3 (Stip)" },
	{ 12006, "MSCBL1 (BIG)" },
	{ 12007, "MSC BL2 (SPX1)" },
	{ 12048, "Islay" },
	{ 12049, "UKSTP01" },
	{ 12050, "UKSTP02" },
	{ 12051, "Cisco STP" },
	{ 12052, "Lostock" },
	{ 12053, "London-MGC1" },
	{ 12054, "Trent" },
	{ 12055, "SGWLD2" },
	{ 12056, "" },
	{ 12057, "" },
	{ 12058, "Yaana UK2" },
	{ 12059, "LON-MGW1" },
	{ 12061, "EPSILON-VERAZ" },
	{ 12062, "LDTWSS1" },
	{ 12063, "LDTWSS2" },
	{ 12064, "DGMGW02_TEMP" },
	{ 12065, "DGMSC01_TEMP" },
	{ 12066, "DGMGW01_TEMP" },
	{ 12067, "SPX1" },
	{ 12068, "SPX2" },
	{ 12069, "Common GCP" },
	{ 12070, "Common HCP" },
	{ 12071, "SPX1 706MSS1" },
	{ 12072, "POL POZ 4" },
	{ 12073, "POL WAW 5" },
	{ 12074, "EZP WAW 3" },
	{ 12075, "EZP WAW 4" },
	{ 12080, "Tallinn" },
	{ 12081, "Tallinn" },
	{ 12082, "Dzinga/TLN" },
	{ 12083, "Tallinn" },
	{ 12084, "Tallinn" },
	{ 12085, "ADA345MSS1" },
	{ 12086, "TEL444MSS2" },
	{ 12088, "MSC BL2 (SPX2)" },
	{ 12089, "MSC BL2 (BIG)" },
	{ 12090, "MSC BL2 (HPC)" },
	{ 12091, "IIMS Lab SK" },
	{ 12092, "SKOPJE MGC1" },
	{ 12093, "MSC SERVER 2 Skopje" },
	{ 12094, "MSC SERVER 2 Skopje" },
	{ 12096, "TERRA_ZG_SW-2" },
	{ 12097, "TERRA_ZG_SW-3" },
	{ 12098, "SN-CRO-ISPC" },
	{ 12099, "ZAGS" },
	{ 12100, "Zagreb/MC1" },
	{ 12101, "SiOL ZG International" },
	{ 12104, "Tbilisi, Mobile Switching Centre" },
	{ 12105, "Tbilisi, Mobile Switching Centre" },
	{ 12106, "Tbilisi, Mobile Switching Centre" },
	{ 12107, "Tbilisi, Mobile Switching Centre" },
	{ 12108, "Tbilisi, PSTN Switch" },
	{ 12109, "Tbilisi, PSTN Switch" },
	{ 12110, "Tbilisi, International Exchange" },
	{ 12111, "Tbilisi, Mobile Switching Centre" },
	{ 12112, "iCON" },
	{ 12113, "Orange" },
	{ 12115, "Corssnet" },
	{ 12116, "Dzoraxbyur" },
	{ 12117, "Netsys Armenia" },
	{ 12118, "Calline" },
	{ 12119, "Interactive" },
	{ 12120, "3GT" },
	{ 12121, "go2" },
	{ 12122, "GOM STP C" },
	{ 12123, "GOM STP D" },
	{ 12124, "HMMGW01" },
	{ 12125, "HMMSS01" },
	{ 12126, "HMMGW02" },
	{ 12127, "HMMSS02" },
	{ 12128, "OTG_STP_KT" },
	{ 12129, "OTG_SG_NYMA" },
	{ 12130, "OTG_STP_NYMA" },
	{ 12131, "Pallini 3 MGW (MGAPI)" },
	{ 12132, "Kifissos 2 MGW (MGAKF)" },
	{ 12133, "Athens Rentis : MGWREN2" },
	{ 12134, "FORTHNET ISPC" },
	{ 12135, "Reserved for future use" },
	{ 12136, "MTNCYSTP1, Nicosia" },
	{ 12137, "MTNCYSTP2, Nicosia" },
	{ 12138, "MTNCYMGW1, Nicosia" },
	{ 12139, "MTNCYMGW2, Nicosia" },
	{ 12140, "PrimeTelMVNO, Limassol" },
	{ 12141, "PrimeTelMVNO2, Limassol" },
	{ 12142, "PrimeTel-FRA1, Limassol" },
	{ 12143, "PrimeTel-ATH1, Limassol" },
	{ 12144, "..." },
	{ 12145, "..." },
	{ 12152, "ARNSTP01, Conradweg 26, Arnhem" },
	{ 12153, "MSC Den Haag 2, Spaarneplein 2 2515V" },
	{ 12154, "ASDSTP2A, Amsterdam,BarbaraSt" },
	{ 12155, "RTSTP2A, Rotterdam, Antoniefok" },
	{ 12156, "STRATOS_BURUM_02_TEL, Wijtsmaweg 11, 9851" },
	{ 12157, "NL GMSC, Telecity Kruislaan 4" },
	{ 12158, "NL SCCP GW, Telecity Kruislaan 4" },
	{ 12159, "HIGHNL002, Kruislaan 415,1098" },
	{ 12160, "Frankfurt" },
	{ 12161, "Frankfurt" },
	{ 12162, "Frankfurt" },
	{ 12163, "Köln" },
	{ 12164, "Frankfurt" },
	{ 12165, "Frankfurt" },
	{ 12166, "Frankfurt" },
	{ 12167, "Frankfurt" },
	{ 12168, "..." },
	{ 12169, "..." },
	{ 12170, "..." },
	{ 12176, "Bucuresti" },
	{ 12177, "Brasov" },
	{ 12178, "Bucuresti" },
	{ 12179, "Bucuresti" },
	{ 12180, "Bucuresti" },
	{ 12181, "Brasov" },
	{ 12182, "Bucuresti" },
	{ 12183, "Brasov" },
	{ 12186, "LMUK-STP1" },
	{ 12187, "L/GLS/HM1 AXD" },
	{ 12188, "L/GLS/SM1 AXD" },
	{ 12189, "Switchware 1" },
	{ 12190, "SQ1" },
	{ 12191, "LND IC-SWC" },
	{ 12192, "Milano\\Via Caldera, 21" },
	{ 12193, "Roma\\Piazza Bologna" },
	{ 12194, "Via Luca Marenzio 18 - 50127 Firenze" },
	{ 12195, "MILANO via Caldera 21 acr ITM/MI" },
	{ 12196, "Via Bellafino 35 24126 - Bergamo" },
	{ 12197, "Milano via caldera - DYMI3" },
	{ 12198, "Milano via caldera - DYMI4" },
	{ 12199, "Milano/Via Caldera 21 - ATMI3" },
	{ 12200, "Frankfurt" },
	{ 12201, "Frankfurt" },
	{ 12202, "Muenchen M8354" },
	{ 12204, "Telecom26 Frankfurt FR5 STP1" },
	{ 12205, "Frankfurt" },
	{ 12207, "Frankfurt" },
	{ 12208, "Zürich" },
	{ 12209, "Zürich" },
	{ 12210, "Zürich" },
	{ 12211, "Lausanne3" },
	{ 12212, "Renens VD" },
	{ 12213, "Renens VD" },
	{ 12214, "Zurich" },
	{ 12215, "Zürich7" },
	{ 12216, "Softnet-Telekom-Trunk LJ" },
	{ 12217, "Akton Ljubljana 1" },
	{ 12218, "TUSMBW1" },
	{ 12219, "TUSMSS1" },
	{ 12220, "SA-STP Maribor" },
	{ 12221, "TUSMGW2" },
	{ 12222, "MGw12" },
	{ 12223, "MGw22" },
	{ 12224, "London 2" },
	{ 12227, "UKSA1 UKSA2" },
	{ 12229, "LEBARA3" },
	{ 12230, "Greenwich T49" },
	{ 12231, "London 3" },
	{ 12232, "Unistars Latvia" },
	{ 12233, "Riga TB CDMA" },
	{ 12234, "IC1" },
	{ 12235, "D-COM" },
	{ 12236, "" },
	{ 12237, "Riga TC1" },
	{ 12238, "Riga IMS1" },
	{ 12239, "ECON1" },
	{ 12240, "Inlife-LJ2" },
	{ 12241, "Inlife - LJ3" },
	{ 12242, "Inlife - LJ4" },
	{ 12243, "T-2 d.o.o. Gateway - Trunk T-2 d.o.o. Ljubljana 1" },
	{ 12244, "GW1" },
	{ 12245, "CS1" },
	{ 12247, "SIOL International 1" },
	{ 12249, "Gütersloh" },
	{ 12250, "Augsburg" },
	{ 12253, "Frankfurt" },
	{ 12254, "Frankfurt" },
	{ 12255, "Frankfurt" },
	{ 12256, "Riga TKG 01" },
	{ 12257, "DATA-LV" },
	{ 12258, "ITGROU" },
	{ 12259, "LDz Latvian Railway" },
	{ 12260, "ANS2" },
	{ 12261, "BTV 1" },
	{ 12262, "BTV 2" },
	{ 12263, "FINOR" },
	{ 12264, "NOR WAW 2" },
	{ 12265, "EXA GDA" },
	{ 12266, "EXA POZ" },
	{ 12267, "POL WAW 2" },
	{ 12268, "NET WAW 2" },
	{ 12269, "TDG ZGA" },
	{ 12270, "POL WAW 4" },
	{ 12271, "GLC WAW" },
	{ 12272, "Reserved for future use" },
	{ 12273, "Reserved for future use" },
	{ 12274, "Media Gateway Athens 3" },
	{ 12275, "HOL isc1" },
	{ 12276, "HOL isc2" },
	{ 12277, "WIND Hellas ISC" },
	{ 12278, "WIND Hellas ISC2" },
	{ 12279, "Media Gateway Athens 5" },
	{ 12280, "Milano/Via Breda, 28 c/o Stazione G. Pirelli" },
	{ 12281, "Milano/Via Caldera 21 - ATMI4" },
	{ 12282, "Milano/Via Caldera 21 - ATMI5" },
	{ 12283, "Roma - via Alessandro Severo 246 - HGRM3" },
	{ 12284, "Milano\\Via delle Azzalee, 19 Buccinasco" },
	{ 12285, "Roma/Via del Fosso di Santa Maura, 26 – VORM3" },
	{ 12286, "Milano/Via Bensi 1/8 Liberty B - VOMI4" },
	{ 12287, "Roma/Via del Fosso di Santa Maura, 26 – VORM4" },
	{ 12312, "SIT01, Cairo" },
	{ 12313, "SIH01, Cairo" },
	{ 12314, "XIT02, Alexandria" },
	{ 12315, "SIS01, Cairo" },
	{ 12316, "CIH02, Cairo" },
	{ 12317, "CIS02, Cairo" },
	{ 12320, "CAI 1 Ramsis/Cairo" },
	{ 12321, "Alex.1, Mahatet MisrAlexandria" },
	{ 12322, "Heliopolis" },
	{ 12323, "Obour" },
	{ 12325, "Haby 1" },
	{ 12326, "Haby 2" },
	{ 12330, "SST01, Cairo" },
	{ 12331, "XST02, Alexandria" },
	{ 12332, "CAI2, Ramsis/Cairo" },
	{ 12333, "Alex 2, Mahatet MisrAlexandria" },
	{ 12334, "Almaza, Cairo" },
	{ 12336, "" },
	{ 12337, "Alger ISC" },
	{ 12338, "" },
	{ 12339, "Oran ISC" },
	{ 12340, "Constantine ISC" },
	{ 12341, "" },
	{ 12342, "" },
	{ 12343, "Alger MSC (GSM, mobile)" },
	{ 12345, "" },
	{ 12346, "" },
	{ 12347, "" },
	{ 12348, "" },
	{ 12349, "" },
	{ 12350, "" },
	{ 12352, "STP1 Rabat" },
	{ 12353, "Casa TSS" },
	{ 12354, "Rabat TSS" },
	{ 12355, "STP3 Casablanca" },
	{ 12358, "STP CASA" },
	{ 12359, "STP Rabat" },
	{ 12360, "Casa CTI" },
	{ 12361, "Rabat CTI" },
	{ 12368, "Central Kasbash" },
	{ 12369, "Central Nabeul" },
	{ 12370, "..." },
	{ 12371, "..." },
	{ 12374, "..." },
	{ 12375, "..." },
	{ 12384, "International Switching Exchange – Sirt" },
	{ 12385, "SMS monitoring system" },
	{ 12386, "International Switching Exchange – Tripoli" },
	{ 12387, "Telephone service via IP" },
	{ 12388, "International Exchange" },
	{ 12389, "Libyana Mobile Exchange" },
	{ 12390, "Short Messaging System" },
	{ 12391, "Al-Madar Mobile Exchange" },
	{ 12392, "LITC Soft-Switch (Tripoli)" },
	{ 12393, "LITC Media Gateway (Tripoli)" },
	{ 12394, "LITC Km4 Soft-Switch" },
	{ 12395, "LITC Km4 Media Gateway" },
	{ 12396, "LITC Soft-Switch (Benghazi)" },
	{ 12397, "LITC Media Gateway (Benghazi)" },
	{ 12398, "Libyana Mobile Exchange" },
	{ 12399, "Al-Jeel Al-Jadeed (MVNO)" },
	{ 12400, "" },
	{ 12401, "" },
	{ 12402, "" },
	{ 12403, "" },
	{ 12404, "" },
	{ 12405, "" },
	{ 12406, "" },
	{ 12407, "" },
	{ 12416, "INTSTP1" },
	{ 12417, "CTI - Thiaroye" },
	{ 12418, "CTI-Médina" },
	{ 12419, "Huawei_CMSC" },
	{ 12420, "Huawei_WMSC" },
	{ 12421, "PTS Technopole" },
	{ 12422, "PTS Dakar RP" },
	{ 12423, "INTSTP1" },
	{ 12424, "SPX-1 (ALMBC1) SIGNALLING PROXY 1" },
	{ 12425, "SPX-2 (ALMBC1) SIGNALLING PROXY 2" },
	{ 12426, "CSU" },
	{ 12427, "THIES MGW 1 BLADE CLUSTER" },
	{ 12428, "ALMBC1(ALMADIES BLADE CLUSTER 1)" },
	{ 12432, "reserved" },
	{ 12433, "CTI No 1" },
	{ 12434, "GMSCNKC" },
	{ 12435, "GMSC-1 NKC" },
	{ 12436, "MSC-2" },
	{ 12437, "CTI No2" },
	{ 12438, "GMSC-NKC" },
	{ 12439, "CTI/CTN-NKC" },
	{ 12448, "MSC1-Huawei (Site ACI2000)" },
	{ 12449, "Plateforme Roaming Halys( Site ACI2000)" },
	{ 12450, "CTI NGN HUAWEI à Bamako-Coura" },
	{ 12451, "CTI NGN ALU au Halles de Bamako" },
	{ 12452, "ATEL-GMSC" },
	{ 12453, "ATEL-STP" },
	{ 12454, "SCCPGW" },
	{ 12455, "GMSC1" },
	{ 12456, "" },
	{ 12464, "GSM" },
	{ 12465, "CONAKRY" },
	{ 12466, "GSM" },
	{ 12467, "..." },
	{ 12468, "GSM" },
	{ 12469, "GSM" },
	{ 12470, "CONAKRY" },
	{ 12471, "GSM" },
	{ 12472, "GSM" },
	{ 12473, "GSM" },
	{ 12474, "GSM" },
	{ 12475, "STP1" },
	{ 12476, "STP2" },
	{ 12477, "GSM" },
	{ 12478, "GSM" },
	{ 12479, "GSM" },
	{ 12481, "NGP Gateway - Abidjan" },
	{ 12482, "CTI - Abidjan" },
	{ 12483, "MGW01 - Abidjan" },
	{ 12484, "MSOFTS3000 - Abidjan" },
	{ 12485, "SOFTX3000 - Abidjan" },
	{ 12486, "MSC01 - Abidjan" },
	{ 12487, "MSC-T-Abidjan" },
	{ 12490, "CTI-Banco/Abidjan" },
	{ 12492, "YOMBC02 / Abidjan - Yopougon" },
	{ 12493, "MSS6/Abidjan - Riviera 3" },
	{ 12494, "STP1/Abidjan - 2 Plateaux" },
	{ 12495, "STP2/Abidjan - Riviera 3" },
	{ 12496, "ZAD" },
	{ 12497, "CTI_JLC" },
	{ 12498, "OUMSS1" },
	{ 12499, "OUMSC01" },
	{ 12500, "GMSC Bobo Dioulasso" },
	{ 12501, "OUSPS1" },
	{ 12502, "BOSPS1" },
	{ 12512, "OCB Niamey" },
	{ 12513, "GMSC" },
	{ 12514, "GMSC" },
	{ 12515, "GMSC" },
	{ 12516, "ZCXJ 10-MNiamey" },
	{ 12518, "GMSC" },
	{ 12519, "MGW SGW" },
	{ 12528, "CTI LOME AXE 10" },
	{ 12529, "CTI KARA AXE 10" },
	{ 12530, "International 1" },
	{ 12531, "SG7000 LOME" },
	{ 12532, "SG7000 KARA" },
	{ 12533, "International 2" },
	{ 12534, "SSP02" },
	{ 12535, "IGP01TGO" },
	{ 12545, "" },
	{ 12546, "" },
	{ 12547, "" },
	{ 12548, "" },
	{ 12549, "" },
	{ 12550, "" },
	{ 12551, "" },
	{ 12560, "Port Louis 1" },
	{ 12561, "Port Louis 2" },
	{ 12562, "Bay Jacotet 1" },
	{ 12563, "Bay Jacotet 2" },
	{ 12564, "Rose Hill 1" },
	{ 12565, "Rose Hill 2" },
	{ 12567, "MTML 1" },
	{ 12568, "MTML 2" },
	{ 12569, "Hot Link 1" },
	{ 12570, "MT Floreal International Gateway" },
	{ 12571, "MT Rose-Hill International gateway" },
	{ 12572, "MT Port-Louis International Gateway" },
	{ 12573, "MT Rose-Hill Softswitch" },
	{ 12574, "MT Floreal Softswitch" },
	{ 12576, "MSC (MBC1)" },
	{ 12592, "Sierratel Freetown" },
	{ 12593, "Celtel" },
	{ 12594, "Millicom" },
	{ 12595, "Sierratel Freetown" },
	{ 12596, "Datatel" },
	{ 12597, "Comium" },
	{ 12598, "Africell" },
	{ 12599, "QCell(SL)" },
	{ 12608, "Accra North International Gateway (ITE1)" },
	{ 12609, "Cantonments International Gateway (ITE2)" },
	{ 12610, "AC1 MSS1" },
	{ 12611, "DMS300 Gateway" },
	{ 12612, "..." },
	{ 12613, "..." },
	{ 12614, "..." },
	{ 12616, "" },
	{ 12617, "LGSTP1" },
	{ 12618, "LAGOSINT.ITSC1" },
	{ 12619, "CCNS1.IPXS2" },
	{ 12620, "TEIGL1_C4STP" },
	{ 12621, "MLTL2" },
	{ 12624, "LGITSC" },
	{ 12625, "ENITSC" },
	{ 12626, "KDITSC" },
	{ 12627, "..." },
	{ 12628, "LG1" },
	{ 12629, "AS1" },
	{ 12630, "AB1" },
	{ 12631, "..." },
	{ 12632, "LG2" },
	{ 12633, "LGMSCO5" },
	{ 12634, "LGTSCO1" },
	{ 12635, "LGTEX1" },
	{ 12636, "ABJTEX3" },
	{ 12637, "LGMSC1" },
	{ 12638, "MLTL1" },
	{ 12639, "LAGEMXINT" },
	{ 12656, "" },
	{ 12657, "" },
	{ 12658, "" },
	{ 12659, "" },
	{ 12660, "" },
	{ 12661, "" },
	{ 12662, "" },
	{ 12663, "" },
	{ 12672, "Yaoundé, ISC" },
	{ 12673, "Yaoundé, MSC Server" },
	{ 12674, "Douala, MSC Server" },
	{ 12675, "Douala, MSC Server" },
	{ 12676, "Yaoundé, MSC Server" },
	{ 12677, "Douala, MSC Server" },
	{ 12678, "Yaoundé, MSC Server" },
	{ 12679, "Douala, ISC" },
	{ 12680, "Yaoundé" },
	{ 12681, "Douala" },
	{ 12682, "Yaoundé" },
	{ 12683, "Douala, MSC Server" },
	{ 12684, "Douala, Media Gateway" },
	{ 12685, "Yaoundé, MSC Server" },
	{ 12686, "Yaoundé, Media Gateway" },
	{ 12688, "CVT INTGAT PRAIA" },
	{ 12689, "T+INTGAT PRAIA1" },
	{ 12690, "T+INTGAT PRAIA2" },
	{ 12691, "CVTINTGATPRAIA2" },
	{ 12693, "T+STPPRAIA1" },
	{ 12694, "T+STPPRAIA2" },
	{ 12695, "CVMMINTGATPRAIA" },
	{ 12696, "CVM INTGATPRAIA" },
	{ 12697, "CVM INTGATPRAIA2" },
	{ 12704, "CST FIX" },
	{ 12705, "CST MOV" },
	{ 12706, "Sao Tome" },
	{ 12707, "CST MOV1" },
	{ 12708, "CST GW" },
	{ 12720, "PS International Bata" },
	{ 12721, "PS International Malabo" },
	{ 12722, "Lien Roaming" },
	{ 12723, "Lien SS7 VoIP" },
	{ 12724, "Bata Internacional" },
	{ 12725, "Malabo Internacional" },
	{ 12726, "Roaming" },
	{ 12727, "SS7 Voip" },
	{ 12736, "Système de gestion des réseaux" },
	{ 12737, "CTI Libreville" },
	{ 12738, "CUI Franceville" },
	{ 12739, "Réseau intelligent" },
	{ 12740, "Libertis 1" },
	{ 12741, "Alantique Telecom (Telecel) 1" },
	{ 12742, "Celtel Gabon 1" },
	{ 12743, "Libertis 2" },
	{ 12744, "" },
	{ 12745, "SCP" },
	{ 12746, "SCP-2" },
	{ 12747, "" },
	{ 12748, "" },
	{ 12749, "SPC-2" },
	{ 12750, "" },
	{ 12751, "" },
	{ 12752, "" },
	{ 12753, "" },
	{ 12754, "" },
	{ 12755, "" },
	{ 12756, "" },
	{ 12757, "" },
	{ 12758, "" },
	{ 12759, "" },
	{ 12761, "Kinshasa" },
	{ 12762, "Goma" },
	{ 12763, "Kinshasa" },
	{ 12764, "Goma" },
	{ 12765, "Lubumbashi" },
	{ 12766, "Goma" },
	{ 12767, "Kinshasa" },
	{ 12768, "Kinshasa" },
	{ 12769, "Kinshasa" },
	{ 12770, "Inato" },
	{ 12773, "IMBJ" },
	{ 12775, "Kinshasa" },
	{ 12777, "Vodacom Congo SSP01" },
	{ 12778, "Vodacom Congo SSP01" },
	{ 12779, "INAT01" },
	{ 12780, "Kinshasa" },
	{ 12781, "Vodacom Congo SSP01" },
	{ 12782, "INAT02" },
	{ 12783, "Kinshasa" },
	{ 12784, "ISC1" },
	{ 12785, "ISC2" },
	{ 12786, "ISC3" },
	{ 12787, "ISC4" },
	{ 12788, "ISC5" },
	{ 12789, "ISC6" },
	{ 12790, "ISC7" },
	{ 12791, "ISC8" },
	{ 12792, "ISC1" },
	{ 12794, "ISC3" },
	{ 12795, "ISC4" },
	{ 12816, "E10S1" },
	{ 12817, "Seychelles MSC" },
	{ 12818, "Media Gateway (MGW)" },
	{ 12820, "INTV-MAHE-01" },
	{ 12821, "Media Gateway - Airtel" },
	{ 12822, "TLS" },
	{ 12823, "MSC" },
	{ 12824, "Kokonet - 0" },
	{ 12826, "HSS Node" },
	{ 12827, "MSC-SC 01" },
	{ 12828, "HLR1" },
	{ 12829, "HLR2" },
	{ 12830, "MSC1" },
	{ 12831, "MSC2" },
	{ 12832, "ITC Khartoum" },
	{ 12833, "ITC UM Haraz" },
	{ 12834, "NGN" },
	{ 12835, "Signalling Gateway" },
	{ 12836, "Soft Switch" },
	{ 12837, "NGN(Soft Switch) 1" },
	{ 12838, "GMSC" },
	{ 12840, "SMS" },
	{ 12841, "Signalling Gateway" },
	{ 12842, "Soft Switch" },
	{ 12843, "..." },
	{ 12844, "NGN(Soft Switch) 2" },
	{ 12848, "RMSSBC1_Cluster" },
	{ 12849, "FSXKGL1" },
	{ 12850, "NMSC Switch 1" },
	{ 12851, "NYMGW3" },
	{ 12852, "RMWGW1" },
	{ 12853, "SG7KGL1" },
	{ 12854, "KIMGW01" },
	{ 12855, "KIMSC01" },
	{ 12856, "KG1MSC1" },
	{ 12857, "KG1MGW1" },
	{ 12858, "NMGW1" },
	{ 12859, "NMSSBC1" },
	{ 12860, "NMSS1" },
	{ 12861, "KIMGW04" },
	{ 12862, "KIMBC02" },
	{ 12863, "KIMGW03" },
	{ 12865, "Bole" },
	{ 12872, "NYMBC1" },
	{ 12873, "RMMBC1" },
	{ 12874, "RMGW1" },
	{ 12876, "RMSSBC1_SPX1" },
	{ 12877, "RMSSBC1_SPX2" },
	{ 12880, "Mogadishu" },
	{ 12881, "Hargeysa" },
	{ 12882, "Mogadishu" },
	{ 12883, "Hargeysa" },
	{ 12884, "Bosaso" },
	{ 12887, "Mogadishu/BW" },
	{ 12912, "Milimani" },
	{ 12913, "Westlands" },
	{ 12914, "Westlands" },
	{ 12915, "Nairobi" },
	{ 12916, "Kasarani" },
	{ 12917, "Extelcoms" },
	{ 12918, "Nairobi" },
	{ 12919, "Nairobi" },
	{ 12920, "Nairobi" },
	{ 12921, "Nairobi" },
	{ 12928, "DSMITE01" },
	{ 12930, "GMSC" },
	{ 12931, "ITSC ZNZ" },
	{ 12932, "MSDA1" },
	{ 12933, "DSMSC01" },
	{ 12935, "MSC2 DAR" },
	{ 12936, "DSMSGW01" },
	{ 12937, "DAMS01" },
	{ 12939, "MSDA4" },
	{ 12940, "MWMS01" },
	{ 12941, "DSMSS10" },
	{ 12942, "DSSTP01" },
	{ 12943, "DSSTP02" },
	{ 12944, "Kampala" },
	{ 12945, "Kampala" },
	{ 12946, "Kampala" },
	{ 12947, "Kampala" },
	{ 12948, "Kampala" },
	{ 12949, "Kampala" },
	{ 12950, "KAMSS3" },
	{ 12951, "KAMSS4" },
	{ 12952, "SOFTX" },
	{ 12953, "MSCSLCRC1" },
	{ 12954, "SGWLCRC1" },
	{ 12955, "MSCSLBUG1" },
	{ 12956, "SGWLBUG1" },
	{ 12959, "Kampala/H3I" },
	{ 12960, "" },
	{ 12961, "" },
	{ 12963, "" },
	{ 12964, "" },
	{ 12966, "" },
	{ 12967, "" },
	{ 12968, "Burundi_Gateway 1" },
	{ 12969, "Burundi_Gateway 2" },
	{ 12976, "International Transit center" },
	{ 12977, "International Transit Center" },
	{ 12979, "SSPO4" },
	{ 12980, "SSPO4" },
	{ 12981, "SSPO4" },
	{ 12982, "SSPO4" },
	{ 12983, "SSPO4" },
	{ 12988, "SSPO4" },
	{ 12992, "" },
	{ 12993, "" },
	{ 12994, "" },
	{ 12995, "" },
	{ 12996, "" },
	{ 12997, "" },
	{ 12998, "" },
	{ 12999, "" },
	{ 13008, "Lusaka Gateway" },
	{ 13009, "..." },
	{ 13010, "New Lamya ITSC" },
	{ 13011, "MSC Server Room" },
	{ 13024, "Antananarivo" },
	{ 13025, "Antananarivo" },
	{ 13026, "Antananarivo" },
	{ 13027, "Antananarivo" },
	{ 13028, "Antananarivo" },
	{ 13030, "Antananarivo" },
	{ 13031, "Antananarivo" },
	{ 13032, "Antananarivo" },
	{ 13040, "SRR - Réunion - Le Port" },
	{ 13041, "SRR - Mayotte" },
	{ 13042, "Telco OI – Sainte Clotilde 1" },
	{ 13043, "Telco OI – Sainte Clotilde 2" },
	{ 13044, "Telco OI – Mamoudzou 1" },
	{ 13045, "Telco OI – Mamoudzou 2" },
	{ 13048, "Harare STP-202" },
	{ 13049, "Econet Pockets Hill STP" },
	{ 13050, "Econet Willowvale STP" },
	{ 13051, "HRE-ZTE-MSC1-2" },
	{ 13056, "Harare TS(F150)" },
	{ 13057, "Gweru ITSC(AXE10)" },
	{ 13058, "ZWNET1A" },
	{ 13059, "ZWNET1B" },
	{ 13060, "Harare ISC(C&C08)" },
	{ 13061, "Econet Pockets Hill GMSC" },
	{ 13062, "Gweru ITSC (C&C08)" },
	{ 13063, "Liquid Telecom" },
	{ 13064, "Econet Willowvale GMSC" },
	{ 13065, "PowerTel STP1" },
	{ 13066, "Harare STP-148" },
	{ 13067, "Harare GMSC-148" },
	{ 13068, "Africom" },
	{ 13069, "Aquiva Wireless" },
	{ 13071, "Pecus VoIP" },
	{ 13072, "Windhoek International Exchange" },
	{ 13073, "MTCNAM" },
	{ 13074, "Windhoek International Exchange 2" },
	{ 13075, "IDI Industria International" },
	{ 13076, "LEONAM" },
	{ 13077, "WTNNAM" },
	{ 13078, "LEONAM2" },
	{ 13079, "DemshiNAM" },
	{ 13080, "WTNNAM2" },
	{ 13081, "MTN" },
	{ 13082, "MTCNAM2" },
	{ 13104, "MSU" },
	{ 13105, "ETLSS" },
	{ 13106, "ETLMGW" },
	{ 13107, "VCLMGW" },
	{ 13108, "GMAMSC2" },
	{ 13109, "GMAMSC1" },
	{ 13110, "MLT" },
	{ 13111, "VCLMSS" },
	{ 13112, "VCLLKK" },
	{ 13113, "VCLMSW" },
	{ 13120, "TOLLOPS (GISC)" },
	{ 13121, "FTISC" },
	{ 13122, "GASPX01" },
	{ 13123, "OBO_IGW1" },
	{ 13124, "OBO_IGW2" },
	{ 13125, "Gaborone International Signalling Gateway (GISG)" },
	{ 13126, "Francistown International Signaling Gateway (FTISG)" },
	{ 13127, "GAMBCO1" },
	{ 13128, "PHMBC01" },
	{ 13129, "PHSPX01" },
	{ 13136, "ISC AXE" },
	{ 13137, "IMG MBA" },
	{ 13138, "SMC MBA" },
	{ 13139, "SZM MBA" },
	{ 13141, "EZ MSC" },
	{ 13142, "MA MSC" },
	{ 13152, "MSC CT Moroni" },
	{ 13153, "MSC CT" },
	{ 13154, "MSC1" },
	{ 13155, "MSC2" },
	{ 13156, "Moroni - MSC" },
	{ 13160, "ECO-MSC1-JBG-01" },
	{ 13161, "ECO-STP1-JBG-01" },
	{ 13162, "ILIZWI-MSC-01" },
	{ 13163, "JHMES2-01" },
	{ 13164, "RBM2S1-01" },
	{ 13165, "NEW DOORNFONTEIN- NDF00" },
	{ 13166, "RJBZ-00" },
	{ 13167, "RJSZ-00" },
	{ 13168, "Johannesburg JB ISC" },
	{ 13169, "Johannesburg JS ISC" },
	{ 13170, "JB STP1" },
	{ 13171, "JB STP2" },
	{ 13172, "RJB-01" },
	{ 13173, "MTN Cellular Network" },
	{ 13175, "Brongberg Test Exchange" },
	{ 13176, "Sentech LTH 1" },
	{ 13177, "Cell C" },
	{ 13178, "Cell C" },
	{ 13181, "MTN STP 2" },
	{ 13182, "RJSP 01" },
	{ 13183, "Sentech LTH 2" },
	{ 13185, "NST01" },
	{ 13186, "BLE01" },
	{ 13187, "PSTSTP" },
	{ 13188, "JSE STP" },
	{ 13189, "JTGMSS-1" },
	{ 13190, "STP-JGTST" },
	{ 13191, "STP-MNEST" },
	{ 13192, "JNGMSS-1" },
	{ 13193, "JBM-01" },
	{ 13194, "JSM-01" },
	{ 13196, "MSIGM" },
	{ 13197, "MSIPS" },
	{ 13198, "WIRECONNECT-00" },
	{ 13199, "CAPE TOWN BARRACK STREET - CBS00" },
	{ 13201, "Asmara" },
	{ 13272, "SMILE-MG" },
	{ 13273, "WTLSC01" },
	{ 13328, "SMUG-ISPC" },
	{ 13329, "Kampala/i-TEL1" },
	{ 13332, "SMUGSMS" },
	{ 13333, "KAMGW 1" },
	{ 13334, "KAMGW 3" },
	{ 13336, "EAMGW4" },
	{ 13337, "WEMGW5" },
	{ 13338, "Kmpms - 01/S11" },
	{ 13339, "Sure Telecom" },
	{ 13340, "Kmpms - 01/S31" },
	{ 13341, "MGGC1" },
	{ 13342, "IDPHONE" },
	{ 13343, "MSGC1" },
	{ 13448, "SPR STP" },
	{ 13449, "SMT STP" },
	{ 13450, "VSPRO 11" },
	{ 13451, "VSMTO 11" },
	{ 13488, "MSC Rabat" },
	{ 13489, "MSC Casa" },
	{ 13490, "V-STP CASA" },
	{ 13491, "V-STP RABAT" },
	{ 13648, "GMSC" },
	{ 13649, "GMSC" },
	{ 13650, "MGW" },
	{ 13651, "MGW" },
	{ 13652, "MGW" },
	{ 13653, "MGW" },
	{ 13672, "Ministry of Telecommunication" },
	{ 13673, "Ministry of Telecommunication" },
	{ 13674, "Ministry of Telecommunication" },
	{ 13675, "GEMTEL" },
	{ 13676, "VIVACEL" },
	{ 13677, "MTN" },
	{ 13678, "ZAIN" },
	{ 13679, "SUDANI" },
	{ 13688, "" },
	{ 13689, "" },
	{ 13690, "" },
	{ 13691, "" },
	{ 13704, "Yaoundé, MSC Server" },
	{ 13705, "Douala, MSC Server" },
	{ 13706, "Garoua, SEP" },
	{ 13707, "Garoua, STP" },
	{ 13708, "Yaoundé, SEP" },
	{ 13709, "Douala, SEP, GMSC" },
	{ 13710, "Yaoundé, SEP, GMSC" },
	{ 13720, "Goma" },
	{ 13721, "Goma" },
	{ 13722, "Kinshasa" },
	{ 13723, "Kinshasa" },
	{ 13724, "Lubumbashi" },
	{ 13725, "Goma" },
	{ 13752, "GMSC2" },
	{ 13753, "STP1" },
	{ 13754, "STP2" },
	{ 14048, "STP Skopje" },
	{ 14049, "STP1 Skopje" },
	{ 14050, "STP2 Skopje" },
	{ 14051, "MSCBL1 (HPC)" },
	{ 14052, "ON1" },
	{ 14053, "TMMK MSC1 SK" },
	{ 14054, "TMMK MSC2 SK" },
	{ 14055, "TMMK MGw1" },
	{ 14061, "SIOL, Skopje" },
	{ 14088, "SPX2 706MSS1" },
	{ 14089, "Common GCP 706MSS1" },
	{ 14090, "Common HCP 706MSS1" },
	{ 14091, "CPWPC01" },
	{ 14092, "CPWPC02" },
	{ 14093, "CPWPC03" },
	{ 14094, "BL0MGW06" },
	{ 14095, "DN1MGW07" },
	{ 14096, "MGW1 (Hallsberg)" },
	{ 14097, "MSS1 (Hallsberg)" },
	{ 14098, "MGW2 (Gävle)" },
	{ 14099, "MSS2 (Gävle)" },
	{ 14100, "BSU2 (Stockholm)" },
	{ 14101, "STP105 (Stockholm)" },
	{ 14102, "STP165 (Stockholm)" },
	{ 14103, "STP405 (Stockholm)" },
	{ 14109, "Tallinn" },
	{ 14110, "Tallinn" },
	{ 14111, "Tallinn" },
	{ 14120, "MISTH-3 (Stockholm)" },
	{ 14121, "MISTH-4 (Stockholm)" },
	{ 14123, "Maingate SP01 (Karlskrona)" },
	{ 14124, "Maingate SP02 (Karlskrona)" },
	{ 14125, "Maingate SP03 (Karlskrona)" },
	{ 14126, "STP465 (Stockholm)" },
	{ 14128, "MCS BC110 (Stockholm)" },
	{ 14129, "MCS BC110 (Stockholm)" },
	{ 14130, "MCS BC110 (Stockholm)" },
	{ 14131, "MCS BC110 (Stockholm)" },
	{ 14132, "MCS BC120 (Stockholm)" },
	{ 14133, "MCS BC120 (Stockholm)" },
	{ 14134, "MCS BC120 (Stockholm)" },
	{ 14135, "MCS BC120 (Stockholm)" },
	{ 14136, "PrimeTel-LON1, Limassol" },
	{ 14137, "IntellTel - CY1, Nicosia" },
	{ 14138, "MTNCYMGCF1" },
	{ 14139, "MTNCYMGCF2" },
	{ 14140, "MTNCYIMGW1" },
	{ 14141, "MTNCYIMGW2" },
	{ 14142, "MTNCYSPS1" },
	{ 14143, "MTNCYSPS2" },
	{ 14144, "SH-B-STP1 (Stockholm)" },
	{ 14145, "KK-B-STP2 (Karlskrona)" },
	{ 14146, "MISTH-1 (Stockholm)" },
	{ 14147, "MISTH-2 (Stockholm)" },
	{ 14150, "42 STP1 (Linköping)" },
	{ 14151, "42 STP2 (Linköping)" },
	{ 14154, "Completel - Villeurbanne" },
	{ 14155, "Completel - Toulouse" },
	{ 14156, "Wanatel - Paris" },
	{ 14157, "Mobiqui Things - Vitry 1" },
	{ 14159, "Mobiqui Things - Vitry 2" },
	{ 14160, "VF STP Praha" },
	{ 14161, "VF STP Brno" },
	{ 14162, "VF STP Praha 2" },
	{ 14163, "VF STP Brno 2" },
	{ 14168, "SVN-LJU-MOBIK-2" },
	{ 14169, "SVN-LJU-MOBIK-3" },
	{ 14170, "GW2" },
	{ 14171, "CS2" },
	{ 14172, "TELEMACH-1" },
	{ 14173, "7E-GW-TS" },
	{ 14174, "MSCS1" },
	{ 14175, "MSCS2" },
	{ 14176, "TMP WAW 7" },
	{ 14177, "TMP WAW 8" },
	{ 14178, "TMP KOM 2" },
	{ 14179, "TMP KOM 3" },
	{ 14180, "OPL WAW 8" },
	{ 14181, "OPL WAW 9" },
	{ 14182, "EZP WAW 1" },
	{ 14183, "EZP WAW 2" },
	{ 14184, "Frankfurt" },
	{ 14185, "Hilden" },
	{ 14186, "Frankfurt" },
	{ 14187, "Frankfurt" },
	{ 14189, "Frankfurt" },
	{ 14190, "Köln" },
	{ 14192, "CT-STP1 (Frankfurt)" },
	{ 14193, "CT-STP2 (Frankfurt)" },
	{ 14194, "STPHorisen1 (Rorschach)" },
	{ 14195, "RWC-ISPC-1 (Stockholm)" },
	{ 14196, "Infobip GE (SMSC 1) (Frankfurt)" },
	{ 14197, "Infobip GE (SMSC 2) (Frankfurt)" },
	{ 14198, "Infobip GE (SMSC 3) (Frankfurt)" },
	{ 14199, "Infobip GE (SMSC 4) (Frankfurt)" },
	{ 14200, "GOLD" },
	{ 14201, "ESCOM" },
	{ 14202, "BTCNET" },
	{ 14203, "NETFINITY2" },
	{ 14204, "NETCONNBG" },
	{ 14205, "SFINT" },
	{ 14206, "SFINT STP1" },
	{ 14207, "MGW1" },
	{ 14217, "IMSISC" },
	{ 14219, "KSTP2" },
	{ 14220, "KIE/STP3" },
	{ 14221, "ODE/STP1" },
	{ 14222, "Kyiv IGW" },
	{ 14224, "MLOA - Belfast" },
	{ 14225, "London 2" },
	{ 14227, "MN-TK1" },
	{ 14228, "MN-TK2" },
	{ 14231, "JER-TPSTC" },
	{ 14234, "NOVA ISL" },
	{ 14235, "NOVA ISL2" },
	{ 14240, "Madrid" },
	{ 14241, "Madrid" },
	{ 14242, "Madrid" },
	{ 14243, "" },
	{ 14244, "" },
	{ 14245, "" },
	{ 14246, "" },
	{ 14247, "" },
	{ 14248, "Trento via Ernesto Sestan 5" },
	{ 14249, "c/o Colt Telecom - Viale Jenner 56/Milano" },
	{ 14250, "Via 24 Maggio, 16/Ghedi (BS)" },
	{ 14251, "via Panella 10 20100 Milano" },
	{ 14252, "via ex-aeroporto 80038 - Pomigliano d'Arco – Napoli" },
	{ 14253, "via Caracciolo 51 - 20155 Milano" },
	{ 14254, "via Caldera 21, Milano" },
	{ 14255, "Genova Granarolo/via Mura al forte di Begato" },
	{ 14256, "Clonshaugh Gateway" },
	{ 14257, "MSC3" },
	{ 14258, "SWIFDUB1" },
	{ 14259, "M20" },
	{ 14260, "W20" },
	{ 14261, "M30" },
	{ 14262, "W30" },
	{ 14264, "ECCBL" },
	{ 14265, "GSM3INT1" },
	{ 14266, "GMSC2" },
	{ 14267, "GSM3INT2" },
	{ 14268, "NTS" },
	{ 14269, "GSM-R BG" },
	{ 14270, "MSCS5" },
	{ 14271, "MGW7" },
	{ 14272, "GT" },
	{ 14273, "TGT 2" },
	{ 14274, "OPTRONET_LV" },
	{ 14275, "MGTL1" },
	{ 14276, "CDMA 1" },
	{ 14277, "CDMA 2" },
	{ 14278, "Riga TB" },
	{ 14279, "Bite LV-1" },
	{ 14280, "RtSTP5, Rotterdam" },
	{ 14281, "ROTC, Vlaardingenweg 62 , R" },
	{ 14282, "ALB, DNC, Holsbjergvej 18" },
	{ 14283, "KH DNC, Borup Alle 43" },
	{ 14284, "MSTP GV, Pr. Beatrixlaan 10" },
	{ 14285, "MSTP EHV, Prof. Dr. Dorgelolaa" },
	{ 14286, "Asd MMSC2, Fokkerweg 300" },
	{ 14287, "Amsterdam NL_04, Amsterdam" },
	{ 14288, "STP2" },
	{ 14289, "ETC" },
	{ 14290, "sip.vmobile.eu" },
	{ 14291, "SFINT STP2" },
	{ 14292, "GTH" },
	{ 14293, "VEST" },
	{ 14294, "NETFINITY" },
	{ 14296, "Budapest-DIGIMOBIL-01" },
	{ 14298, "VHF-INT-GW1" },
	{ 14299, "VHF-INT-GW4" },
	{ 14300, "Budapest-DIGI-02" },
	{ 14301, "Bp. IP STP MST2" },
	{ 14302, "TTI INT 02" },
	{ 14303, "Bp. IP STP MST1" },
	{ 14304, "Paul Street" },
	{ 14305, "Brentford" },
	{ 14306, "BURUM 2" },
	{ 14307, "London" },
	{ 14308, "Global Switch" },
	{ 14309, "Jukej 1" },
	{ 14310, "LON-TPSTD" },
	{ 14311, "LONDON1" },
	{ 14312, "MGW-T-2 Mobile" },
	{ 14314, "SVN-LJU-MOBIK-1" },
	{ 14315, "Mobitel GMSC1" },
	{ 14316, "Mobitel GMSC2" },
	{ 14317, "AMIS-1" },
	{ 14318, "T-2 Mobile Gateway Ljubjana 1" },
	{ 14319, "GSM MSC3 Maribor" },
	{ 14322, "UKVZ02" },
	{ 14323, "ITP 1A" },
	{ 14325, "ITP 2B" },
	{ 14329, "MComXL1" },
	{ 14330, "Greenwich M79" },
	{ 14331, "Greenwich M82" },
	{ 14333, "MSC 23" },
	{ 14334, "MSC 24" },
	{ 14335, "UK STP 3" },
	{ 14368, "Orange Walk Huawei HSS" },
	{ 14369, "Orange Walk Huawei DRA/STP" },
	{ 14370, "Belmopan Huawei DRA/STP" },
	{ 14371, "Belmopan Huawei HSS" },
	{ 14372, "Nortel GSP" },
	{ 14373, "Genband STP" },
	{ 14374, "Pay and Prepaid Services" },
	{ 14375, "Mobile Services" },
	{ 14400, "Central Aristos/EWSD" },
	{ 14401, "AXE810INT" },
	{ 14402, "Internacional Guarda Viejo I, AXE-10" },
	{ 14403, "Centro Tránsito" },
	{ 14404, "AT&T Guatemala" },
	{ 14405, "Americatel Guatemala" },
	{ 14406, "Gateway Guatemala 1" },
	{ 14407, "Tránsito Guatemala" },
	{ 14408, "AXE810INT01" },
	{ 14409, "Central GT-AXE" },
	{ 14410, "ANS Internacional" },
	{ 14411, "PCS GSM OPC 1" },
	{ 14412, "PCS GSM OPC 2" },
	{ 14413, "USP, Nortel, DMS-STP" },
	{ 14414, "AXEINT" },
	{ 14415, "STP MARISCAL" },
	{ 14432, "LD1" },
	{ 14433, "INT2" },
	{ 14434, "INT1" },
	{ 14435, "Roaming Personal 1" },
	{ 14436, "Telefónica 1" },
	{ 14437, "Salnet 1" },
	{ 14438, "Telemóvil 1" },
	{ 14439, "Americatel 1" },
	{ 14440, "Telefónica 2" },
	{ 14441, "Digicel 1" },
	{ 14442, "AESTEL 1" },
	{ 14443, "SALTEL 1" },
	{ 14444, "GCA 1" },
	{ 14445, "Telecam 1" },
	{ 14446, "Saltel 2" },
	{ 14447, "Americana 1" },
	{ 14448, "Telefónica 3" },
	{ 14449, "Telemóvil 2" },
	{ 14450, "SKY 1" },
	{ 14451, "Portal Virtual 1" },
	{ 14452, "Portal Virtual 2" },
	{ 14453, "Telefónica 4" },
	{ 14454, "Telefónica 5" },
	{ 14455, "Telemóvil 3" },
	{ 14456, "Telemóvil 4" },
	{ 14457, "Digicel 2" },
	{ 14459, "Roaming Personal 2" },
	{ 14464, "TGA-MSSTGU" },
	{ 14465, "INTL II" },
	{ 14466, "STP-TGA" },
	{ 14467, "STP-TGA" },
	{ 14468, "INTL III (SPS-III)" },
	{ 14469, "INTL-SPS" },
	{ 14470, "MSSTGU2" },
	{ 14471, "SPS-MGWSPS" },
	{ 14472, "MGW1-TGA" },
	{ 14473, "ITP1-TGA" },
	{ 14474, "IGATE-TGA" },
	{ 14475, "MGW2-TGA" },
	{ 14476, "ITP3-TGA" },
	{ 14477, "ITP4-TGA" },
	{ 14478, "MGW-TGU" },
	{ 14479, "MSS-SPS" },
	{ 14480, "MGW-CBA1" },
	{ 14481, "STPTGU1" },
	{ 14482, "STPSPS1" },
	{ 14496, "MT20" },
	{ 14497, "10000000000000" },
	{ 14498, "AXE 810 PCS" },
	{ 14499, "ENITEL_MOVIL" },
	{ 14501, "Bellsouth" },
	{ 14503, "GLOBALSTAR" },
	{ 14520, "MSC Internacional" },
	{ 14521, "MGW Internacional 1" },
	{ 14522, "MGW Internacional 2" },
	{ 14523, "Internacional 1" },
	{ 14524, "Internacional 2" },
	{ 14525, "Plataforma de SVA's" },
	{ 14526, "STP Internacional 1" },
	{ 14527, "STP Internacional 2" },
	{ 14528, "Central Internacional San José" },
	{ 14529, "Central Internacional San Pedro" },
	{ 14530, "Gateway SCCP internacional SUR" },
	{ 14531, "Gateway SCCP Internacional Alajuela" },
	{ 14532, "Central Internacional IP" },
	{ 14533, "Central Internacional IP" },
	{ 14534, "STP Internacional" },
	{ 14535, "Monitoreo BK7" },
	{ 14547, "NetUno INT" },
	{ 14548, "JFHLR1" },
	{ 14550, "FortInt 1" },
	{ 14551, "PANSL4M" },
	{ 14553, "COint2" },
	{ 14554, "Mobil Red I" },
	{ 14556, "Nodo Intl para Central de Rio Abajo" },
	{ 14557, "Claro Panama 1" },
	{ 14558, "Claro Panama 2" },
	{ 14559, "Digicel Panama 1" },
	{ 14560, "Gateway MSC Digicel" },
	{ 14561, "ISC1 (La Exposición)" },
	{ 14562, "ISC2 (San Francisco)" },
	{ 14563, "GSM LR Data Base" },
	{ 14564, "BSC" },
	{ 14565, "Nodo Intl para Central de Juan Franco" },
	{ 14566, "NACT STX Panama" },
	{ 14571, "COint3" },
	{ 14572, "STP01DAV01" },
	{ 14573, "Claro Panamá 3" },
	{ 14574, "DAVTE1P" },
	{ 14576, "STP1 Intl Digicel" },
	{ 14577, "STP2 Intl Digicel" },
	{ 14578, "COint4" },
	{ 14579, "PANSL2P" },
	{ 14580, "Digicel MG Intl" },
	{ 14581, "PANSL4M_SPX1" },
	{ 14582, "PANSL4M_SPX2" },
	{ 14584, "BTPTY1" },
	{ 14585, "Skymond1 MSC" },
	{ 14586, "Skymond2 MSC" },
	{ 14587, "PANSL 2M" },
	{ 14588, "PANSL 1P" },
	{ 14589, "ITP Internacional" },
	{ 14590, "MGW PANSL3G" },
	{ 14591, "ISC3" },
	{ 14592, "Lima N1" },
	{ 14593, "Washington Instal 1" },
	{ 14594, "El Cercado Instal 2" },
	{ 14595, "Lima" },
	{ 14596, "La Victoria T2000-1" },
	{ 14597, "Villa El Salvador FC-1" },
	{ 14598, "San Isidro GV-1" },
	{ 14599, "La Victoria OC-1" },
	{ 14600, "San Isidro RCP-1" },
	{ 14601, "San Isidro GC-1" },
	{ 14602, "San Isidro TA-1" },
	{ 14603, "Lima" },
	{ 14604, "Lima" },
	{ 14605, "San Isidro BE-1" },
	{ 14606, "Lima" },
	{ 14607, "San Isidro O-1" },
	{ 14608, "Miraflores I-1" },
	{ 14609, "Surco CG-1" },
	{ 14610, "San Borja CO 1" },
	{ 14611, "San Borja IIP-1" },
	{ 14612, "Surco AII-1" },
	{ 14613, "La Molina TE-1" },
	{ 14614, "Ate JT-1" },
	{ 14615, "Lima" },
	{ 14616, "San Isidro HH-1" },
	{ 14617, "San Borja BP-1" },
	{ 14618, "La Victoria BP-2" },
	{ 14619, "La Victoria BP-3" },
	{ 14620, "San Isidro TE.AN-1" },
	{ 14621, "Lima" },
	{ 14622, "Lima" },
	{ 14623, "Lima" },
	{ 14624, "Lima" },
	{ 14625, "Lima" },
	{ 14626, "Lima" },
	{ 14627, "Lima" },
	{ 14628, "Lima" },
	{ 14629, "Lima" },
	{ 14630, "Lima" },
	{ 14631, "Lima" },
	{ 14632, "Lima" },
	{ 14633, "Lima" },
	{ 14634, "Lima" },
	{ 14635, "Lima" },
	{ 14636, "Lima" },
	{ 14637, "Lima" },
	{ 14638, "Lima" },
	{ 14639, "Lima" },
	{ 14640, "Lima" },
	{ 14641, "Lima" },
	{ 14642, "Lima" },
	{ 14643, "Lima" },
	{ 14644, "Lima" },
	{ 14645, "Lima" },
	{ 14646, "Lima" },
	{ 14647, "Puno - Arequipa" },
	{ 14648, "Lima" },
	{ 14649, "Lima" },
	{ 14650, "Lima" },
	{ 14651, "Lima" },
	{ 14652, "Lima" },
	{ 14653, "Lima" },
	{ 14654, "Lima" },
	{ 14655, "Lima" },
	{ 14656, "Ruta 180, Km15. Paraje Bosque Alegre, Departamento Punilla, Provincia de Córdoba" },
	{ 14657, "Emilio Lamarca 2482 - Talar de Pacheco Tigre, buenos Aires / TORCUATO" },
	{ 14664, "Artigas II" },
	{ 14665, "Esmeralda II" },
	{ 14666, "STP-1 Telefónica Unifon" },
	{ 14667, "STP-2 Telefónica Unifon" },
	{ 14668, "CIBA NGN" },
	{ 14669, "CWAY SG BA1" },
	{ 14670, "CCT1 Argentina" },
	{ 14671, "Av. Forest 362 - Ciudad Autónoma de Buenos Aires / FOREST" },
	{ 14672, "Ciudad de Buenos Aires - Nodo 1" },
	{ 14673, "RASA-01" },
	{ 14674, "Buenos Aires/STP Clinicas" },
	{ 14675, "Darwin" },
	{ 14676, "Techtel Rosario" },
	{ 14677, "Buenos Aires 1 AT&T" },
	{ 14678, "Córdoba 1 AT&T" },
	{ 14679, "Rosario 1 AT&T" },
	{ 14680, "Buenos Aires" },
	{ 14681, "DKA-1" },
	{ 14682, "Ortega 5500 (B1874CRN) Wilde, Buenos Aires" },
	{ 14683, "Rafaela/Wilson" },
	{ 14684, "Buenos Aires" },
	{ 14685, "Buenos Aires/Nodo Buenos Aires 1" },
	{ 14686, "Buenos Aires/Colubris 1" },
	{ 14687, "TS Buenos Aires 1" },
	{ 14688, "Buenos Aires / STP Norte 2 (Coghlan)" },
	{ 14689, "Buenos Aires / Ciba Sur 1" },
	{ 14690, "Buenos Aires / Ciba Norte 1 (Golf)" },
	{ 14691, "Buenos Aires / Ciba Sur 2" },
	{ 14692, "Buenos Aires / STP Norte 1 (Golf)" },
	{ 14693, "Buenos Aires / STP Sur 1" },
	{ 14694, "Buenos Aires / Ciba Norte 2 (Coghlan)" },
	{ 14695, "Buenos Aires / STP Sur 2" },
	{ 14696, "Buenos Aires/C.L.D. Velez 1" },
	{ 14697, "Buenos Aires/C.L.D. Viale 1" },
	{ 14698, "Buenos Aires/C.L.D. Velez 2" },
	{ 14699, "Buenos Aires/C.L.D. Viale 2" },
	{ 14700, "Buenos Aires/Alvarez Jonte 1862" },
	{ 14701, "Buenos Aires/Alvarez Jonte 1862" },
	{ 14702, "Buenos Aires/Alvarez Jonte 1862" },
	{ 14703, "Cordoba/Urvitel" },
	{ 14704, "Buenos Aires 2 AT&T" },
	{ 14705, "Buenos Aires 3 AT&T" },
	{ 14706, "25 de Mayo 565 - Bs As/Superfone" },
	{ 14707, "Espinosa 1045 - Buenos Aires - Argentina/SES BA GW No 1" },
	{ 14708, "Bs As/Garay 34" },
	{ 14709, "Buenos Aires, Argentina/Metroredar01" },
	{ 14710, "Av. Del Campo 1301 - Bs As/Artigas" },
	{ 14711, "Esmeralda 330 - Bs As/Esmeralda" },
	{ 14712, "Balcarce 479 - Switch BA 1 Buenos Aires" },
	{ 14713, "Balcarce 479 - Switch BA 2 Buenos Aires" },
	{ 14714, "Buenos Aires - Wilde 1" },
	{ 14715, "Buenos Aires - Wilde 2" },
	{ 14716, "Buenos Aires/Iplan AR" },
	{ 14717, "Córdoba/Trejo" },
	{ 14718, "Buenos Aires/BAS/N1" },
	{ 14719, "AMBA/CONVI" },
	{ 14720, "Rio de Janeiro/PTS ARCOS-PTSA" },
	{ 14721, "Sao Paulo/CISP-A" },
	{ 14722, "Sao Paulo/TR Paraiso" },
	{ 14723, "SAO PAULO/CT TR INT SPO" },
	{ 14724, "Sao Paulo/CISP-B" },
	{ 14725, "Rio de Janeiro/PTS STPRJ1" },
	{ 14726, "Campinas/PTS STPRI1" },
	{ 14727, "Sao Paulo/SPO.JB.LTR1" },
	{ 14728, "RIO DE JANEIRO/RJO/INT" },
	{ 14729, "SAO PAULO/SPO/INT" },
	{ 14730, "Brasilia/ETCO GW2" },
	{ 14731, "Belo Horizonte/PTS SAG I" },
	{ 14732, "Belo Horizonte/PTS LUE I" },
	{ 14733, "Presidente Prudente/GW-PPE" },
	{ 14734, "Rio de Janeiro/RJO5" },
	{ 14735, "Sao Paulo /SPO5" },
	{ 14736, "Sao Paulo/SPO.IB.PT1" },
	{ 14737, "Rio de Janeiro/CIRJ-A" },
	{ 14738, "Petrolina/GW-PTA" },
	{ 14739, "Rio de Janeiro/CORJ-A" },
	{ 14740, "RIO DE JANEIRO/BRB01-MSC-RJO" },
	{ 14741, "Brasilia/ETCE PTS" },
	{ 14742, "Sao Paulo/SPO.LI.PT1" },
	{ 14743, "Sao Paulo/SPO.PD.LTR1" },
	{ 14744, "SAO PAULO/GSPO01" },
	{ 14745, "RIO DE JANEIRO/BRB INT RJO LDI" },
	{ 14746, "RIO DE JANEIRO/FLO INT RJO LDI" },
	{ 14747, "RIO DE JANEIRO/GRJO01" },
	{ 14748, "SAO PAULO - SP SPO.SER.1" },
	{ 14749, "CURITIBA/PTS" },
	{ 14750, "CURITIBA/CTME SURPASS" },
	{ 14751, "CURITIBA/PTS CTA" },
	{ 14752, "PORTO ALEGRE-PTS POA" },
	{ 14753, "RIO DE JANEIRO/PTS MONS JERÔNIMO-PTSB" },
	{ 14754, "SAO PAULO/SPO IB PT2" },
	{ 14755, "SAO PAULO/SPO.SI.LMC1" },
	{ 14756, "Belo Horizonte/PTS" },
	{ 14757, "Belo Horizonte/PTS SAG II" },
	{ 14758, "Belo Horizonte/PTS LUE II" },
	{ 14759, "São Paulo" },
	{ 14760, "Rio de Janeiro/PTS BARRA DA TIJUCA" },
	{ 14761, "Rio de Janeiro/PTS-CC" },
	{ 14762, "RIO DE JANEIRO/CIDADE DE DEUS PTS-CC" },
	{ 14763, "RIO DE JANEIRO/CENTRO PS-CC" },
	{ 14764, "SAO PAULO/PTS JAGUARÉ-PTS JG2" },
	{ 14765, "UBERLANDIA/MSC ULA-B" },
	{ 14766, "SALVADOR/GSDR" },
	{ 14767, "RIO DE JANEIRO/GRJO02" },
	{ 14768, "SAO PAULO/ STPSM3" },
	{ 14769, "RIO DE JANEIRO/São Cristóvão - RJ CRJO 01" },
	{ 14770, "SAO PAULO/Vila Andrade - SP CSPO 01" },
	{ 14771, "UBERLANDIA/SSW MSC ULA-B" },
	{ 14772, "São Paulo" },
	{ 14773, "Brasilia/ETCO-ITP BSA" },
	{ 14774, "Curitiba/ETBV-ITP CTA" },
	{ 14775, "SAO PAULO/BT-SPO" },
	{ 14776, "SAO PAULO/BT-SPO1" },
	{ 14777, "RIO DE JANEIRO/PTS BENTO RIBEIRO" },
	{ 14778, "RIO DE JANEIRO/PTS – BERNARDO GUIMARAES" },
	{ 14779, "RIO DE JANEIRO/CPCRJSI - VOLUNTÁRIOS" },
	{ 14780, "RIO DE JANEIRO/MGCF RJO AM" },
	{ 14781, "SAO PAULO/RUA SAO LEOPOLDO, 460-BAIRRO BELEM" },
	{ 14782, "SAO PAULO/ MSO Belem" },
	{ 14783, "RIO DE JANEIRO/Oswaldo Cruz-MSO Rio" },
	{ 14785, "SANTO ANDRE-ALEXANDRE DE GUSMAO-SPO" },
	{ 14786, "SAO PAULO-VILA ANASTACIO-SPO" },
	{ 14787, "RIO DE JANEIRO/ STPRJ3" },
	{ 14788, "RIO DE JANEIRO/ CPCRJ3SM3" },
	{ 14789, "SPO.RIS.INT.01 Rua dos Ingleses, 600, Sao Paulo" },
	{ 14808, "Santiago" },
	{ 14809, "Santiago" },
	{ 14810, "Santiago" },
	{ 14811, "Santiago" },
	{ 14812, "Santiago" },
	{ 14813, "Santiago" },
	{ 14814, "Santiago" },
	{ 14815, "Santiago" },
	{ 14816, "..." },
	{ 14817, "..." },
	{ 14818, "..." },
	{ 14819, "..." },
	{ 14820, "..." },
	{ 14821, "..." },
	{ 14822, "..." },
	{ 14823, "..." },
	{ 14824, "..." },
	{ 14825, "..." },
	{ 14826, "Santiago" },
	{ 14827, "Santiago" },
	{ 14828, "Santiago" },
	{ 14829, "Santiago" },
	{ 14830, "Santiago" },
	{ 14831, "Santiago" },
	{ 14832, "Santiago" },
	{ 14833, "Santiago" },
	{ 14834, "Santiago" },
	{ 14835, "Santiago" },
	{ 14836, "Santiago" },
	{ 14837, "Santiago" },
	{ 14838, "Santiago" },
	{ 14839, "Santiago" },
	{ 14840, "Santiago" },
	{ 14841, "Santiago" },
	{ 14842, "ROSAS" },
	{ 14848, "E-10 MT - BOGOTÁ" },
	{ 14849, "AXE NORTE - BOGOTÁ" },
	{ 14850, "AXE - BARRANQUILLA" },
	{ 14851, "E-10 MT" },
	{ 14852, "AXE TRANSGATE3 - MEDELLÍN" },
	{ 14853, "AXE TRANSGATE3 - BOGOTÁ" },
	{ 14854, "EWSD VERSIÓN 12 - BOGOTÁ" },
	{ 14855, "EWSD VERSIÓN 12 - CALI" },
	{ 14856, "AXE-10 BOGOTÁ - CENTRO" },
	{ 14857, "AXE 10 BARRANQUILLA - EL PELU" },
	{ 14858, "MD_INT_SS_ORB- MEDELLIN" },
	{ 14859, "BOGOENTST01- BOGOTA" },
	{ 14860, "CALICOLST01- CALI" },
	{ 14861, "AVANTEL ROAMING -BOGOTA" },
	{ 14862, "CSMS-AVANTEL- BOGOTA" },
	{ 14863, "HLR-AVANTEL- BOGOTA" },
	{ 14864, "MGW01ZFB- BOGOTA" },
	{ 14865, "SFS01ZFB- BOGOTA" },
	{ 14866, "CALLE 72- BOGOTA" },
	{ 14867, "NETUNO GW STP/ITP SS7- BOGOTA" },
	{ 14868, "AVANTEL- BOGOTA" },
	{ 14869, "CASTELLANA- BOGOTA" },
	{ 14870, "AUTOPISTA- BOGOTA" },
	{ 14871, "TABOR- BARRANQUILLA" },
	{ 14872, "BARRTABST02 - BARRANQUILLA" },
	{ 14873, "GW-LDI- BOGOTA" },
	{ 14874, "TELINTEL BOGOTA - BOGOTA" },
	{ 14875, "BOGOENTST03 - BOGOTA" },
	{ 14876, "TyS-001- BOGOTA" },
	{ 14877, "EIR AVANTEL- BOGOTA" },
	{ 14878, "MEDEPABST02- MEDELLIN" },
	{ 14879, "HLR02AVA- BOGOTA" },
	{ 14881, "Caracas - El Rosal (CR4)" },
	{ 14882, "Caracas - CNT (CR3)" },
	{ 14883, "Maracaibo (MB0)" },
	{ 14885, "Los Velázquez, Municipio Eulalia Buroz, Edo. Miranda" },
	{ 14886, "Parque Tecnológico Sartenejas" },
	{ 14887, "Estado Zulia - Mara 1" },
	{ 14888, "Anzoátegui, AMZMC001" },
	{ 14889, "Caracas, ID#5" },
	{ 14890, "Torre Mariara, El Rosal, Caracas" },
	{ 14891, "ANS_CCS (Vitcom), C.A." },
	{ 14892, "Cracas - CNT - NDC00" },
	{ 14893, "Avenida de Libertador, Caracas" },
	{ 14894, "Miranda, Caracas" },
	{ 14895, "Miranda, Caracas" },
	{ 14896, "Av. Francisco de Miranda, Caracas" },
	{ 14897, "Av. Libertador, Caracas" },
	{ 14898, "Av. Francisco de Miranda, Caracas" },
	{ 14899, "ANS_CCS, Caracas" },
	{ 14900, "Av. Los Leones y Carona Barquisimeto Estado Lara" },
	{ 14901, "Central AXE - CCS, ID39" },
	{ 14902, "Caracas" },
	{ 14903, "Barquisimeto - BTO - NDC00" },
	{ 14904, "Caracas-LUR-NDC00" },
	{ 14905, "Valencia-VAL-NDC00" },
	{ 14906, "STP_Caracas" },
	{ 14907, "STP_Valencia" },
	{ 14908, "Gateway Cantata" },
	{ 14909, "Caracas 1" },
	{ 14910, "SPS - CCS" },
	{ 14911, "SPS - MCY" },
	{ 14912, "LPZ 0" },
	{ 14913, "SCZ 0" },
	{ 14914, "COTAS LPZ" },
	{ 14915, "LPZ 1" },
	{ 14916, "14916" },
	{ 14917, "STC 1" },
	{ 14918, "COTAS SCZ" },
	{ 14919, "14919" },
	{ 14920, "BOLLP 1, La Paz" },
	{ 14921, "BOLCBA 1, Cochabamba" },
	{ 14922, "BOLSC 1, Santa Cruz" },
	{ 14923, "14923" },
	{ 14924, "14924" },
	{ 14925, "14925" },
	{ 14926, "14926" },
	{ 14927, "14927" },
	{ 14928, "GRAN CENTRO 13, La Paz" },
	{ 14929, "UTI 01, La Paz" },
	{ 14930, "MSC GSM, Santa Cruz" },
	{ 14931, "UNTLPZ, La Paz" },
	{ 14932, "COTAS COCHABAMBA, Cochabamba" },
	{ 14933, "14933" },
	{ 14934, "14934" },
	{ 14935, "14935" },
	{ 14936, "14936" },
	{ 14937, "14937" },
	{ 14938, "14938" },
	{ 14939, "14939" },
	{ 14940, "14940" },
	{ 14941, "14941" },
	{ 14942, "SGW FIJO 01 LPZ, STP La Paz" },
	{ 14943, "SGW FIJO 01 CBB, STP Cochabamba" },
	{ 14944, "Telquest Northcom Home Country Direct Service" },
	{ 14945, "..." },
	{ 14946, "..." },
	{ 14947, "..." },
	{ 14948, "..." },
	{ 14949, "..." },
	{ 14950, "..." },
	{ 14951, "..." },
	{ 14976, "Quito, Central Internacional" },
	{ 14977, "Guayaquil, Central Internacional 2" },
	{ 14978, "Guayaquil, Central Internacional 1" },
	{ 14979, "Guayaquil, Switch" },
	{ 14980, "Quito, Switch" },
	{ 14981, "Guayaquil, Switch" },
	{ 14982, "Guayaquil, MSC TDMA" },
	{ 14983, "Quito, MSC TDMA" },
	{ 14984, "Telecsa UIO-CDMA" },
	{ 14985, "Etapa Cuenca Novatelefonía" },
	{ 14986, "Central Quito SETEL" },
	{ 14987, "Central Internacional (Quito 2)" },
	{ 14988, "MG_UIO_001" },
	{ 14990, "MSSS 1" },
	{ 14991, "MSS GSM UIO" },
	{ 14992, "MSS GSM GYE" },
	{ 14993, "Ecutel" },
	{ 14994, "TELECSA GSM" },
	{ 14995, "TELECSA GSM SP Node" },
	{ 15009, "Dauphin Télécom - Guyane" },
	{ 15040, "..." },
	{ 15041, "..." },
	{ 15042, "" },
	{ 15043, "..." },
	{ 15044, "..." },
	{ 15045, "..." },
	{ 15046, "" },
	{ 15047, "" },
	{ 15048, "" },
	{ 15049, "" },
	{ 15050, "" },
	{ 15052, "" },
	{ 15053, "" },
	{ 15072, "Paramaribo 1" },
	{ 15073, "Paramaribo 2" },
	{ 15074, "Paramaribo 3" },
	{ 15075, "Paramaribo 4" },
	{ 15078, "reserved" },
	{ 15079, "reserved" },
	{ 15105, "CTI1, Montevideo Aguada (AXE10)" },
	{ 15106, "CTI2, Montevideo Unión (AXE10)" },
	{ 15107, "MSC-GSM/Montevideo 1" },
	{ 15108, "MSC-GSM/Montevideo 2" },
	{ 15109, "MSCMV1" },
	{ 15110, "Central Victoria Plaza" },
	{ 15111, "UY-TELMEX" },
	{ 15112, "Montevideo Softswitch NGN" },
	{ 15114, "MSCMV2" },
	{ 15115, "STPBEL" },
	{ 15116, "STPSMA" },
	{ 15129, "ISCFalklands" },
	{ 15130, "TOUCH" },
	{ 15136, "Nodo Principal, Código: GCCS1" },
	{ 15216, "XIUS-HLR-INTL-01 - BOGOTA" },
	{ 15217, "SETROCOMVINTERNACION - BOGOTA" },
	{ 15218, "SETROCOMVINTREDUNDAN- BOGOTA" },
	{ 15536, "INTERNACIONAL ROAMING MSS SCZ, SP Santa Cruz" },
	{ 15537, "COTAS BOL 4, Santa Cruz" },
	{ 15538, "INTERNACIONAL ROAMING MGw LPZ, STP La Paz" },
	{ 15539, "INTERNACIONAL ROAMING MGw SCZ, STP Santa Cruz" },
	{ 15540, "SERVER FIJO 01 STC, STP Santa Cruz" },
	{ 15541, "SGW FIJO 01 STC, STP Santa Cruz" },
	{ 15542, "INTERNACIONAL ROAMING MSS 02 LPZ, STO La Paz" },
	{ 15543, "INTERNACIONAL ROAMING MGw 02 LPZ, STP La Paz" },
	{ 15544, "MSS 3G LPZ" },
	{ 15545, "MSS 3G CBB" },
	{ 15546, "MSS 3G STC" },
	{ 15547, "ECOM-LPZ0" },
	{ 15548, "MGWAVTEL-I-LPZ" },
	{ 15549, "MSC4 GSM" },
	{ 15550, "MGW1" },
	{ 15551, "MGW4" },
	{ 15552, "MGW6" },
	{ 15553, "MSC2 GSM" },
	{ 15554, "MGW2" },
	{ 15555, "MGW5" },
	{ 15556, "MGW7" },
	{ 15557, "MSC3 GSM" },
	{ 15558, "MGW3" },
	{ 15559, "MGW8" },
	{ 15616, "Lima" },
	{ 15617, "Lima" },
	{ 15618, "Lima" },
	{ 15619, "Lima" },
	{ 15620, "Lima" },
	{ 15621, "Lima" },
	{ 15622, "Lima" },
	{ 15623, "Lima" },
	{ 15992, "MontyMobile-SWE-1 (London)" },
	{ 15993, "MontyMobile-SWE-2 (London)" },
	{ 15994, "viahubSTP1 (Nürnberg)" },
	{ 15995, "MontySCCP-SWE-1" },
	{ 15996, "MontySCCP-SWE-2" },
	{ 15997, "BSG-SMSC" },
	{ 15998, "FTS-SW1" },
	{ 15999, "FTS-SW2" },
	{ 16048, "TK01 (SP)" },
	{ 16049, "TK02 (GMSC)" },
	{ 16050, "TK03 (GMSC)" },
	{ 16051, "MSCS91" },
	{ 16052, "MGW91" },
	{ 16053, "EIMOB1" },
	{ 16054, "KNET-Prishtinë" },
	{ 16055, "IMS Severna Mitrovica" },
	{ 16064, "CESG- BOGOTA" },
	{ 16065, "COSG- BOGOTA" },
	{ 16066, "LLEIDA_CO- BOGOTA" },
	{ 16067, "STP01VEN- BOGOTA" },
	{ 16068, "STP01BUC- BUCARAMANGA" },
	{ 16069, "STP02AVA- BOGOTA" },
	{ 16070, "STP02AVAINT02 - BOGOTA" },
	{ 16071, "XIUS-HL-INTL-02 - BOGOTA" },
	{ 16072, "OSL3MGC1" },
	{ 16073, "OSL4MGC1" },
	{ 16074, "Oslo_6" },
	{ 16075, "Oslo_7" },
	{ 16076, "Iristel1" },
	{ 16088, "PEGASUS ALBANIA" },
	{ 16089, "Alb.Tel.Partner" },
	{ 16090, "PROTON Communication" },
	{ 16092, "UNIFI Albania" },
	{ 16093, "Bleta sh.p.k." },
	{ 16096, "NOT YET AVAILABLE" },
	{ 16097, "POST Luxembourg" },
	{ 16098, "POST Luxembourg" },
	{ 16104, "GSM3INT3" },
	{ 16105, "RTLCOM" },
	{ 16106, "MAX1" },
	{ 16107, "MAX2" },
	{ 16108, "BSCM-I-1" },
	{ 16109, "BTC-STP2" },
	{ 16110, "VNIE2" },
	{ 16112, "Melita-Int." },
	{ 16128, "SGWOM2" },
	{ 16129, "NN.01" },
	{ 16130, "NN.02" },
	{ 16136, "NL-0 Mobicents jSS7, Tupolevlaan 103a Schiphol rijk" },
	{ 16137, "NL-1 Mobicents jSS7, Tupolevlaan 103a Schiphol rijk" },
	{ 16138, "ASAMSS4, Amsterdam" },
	{ 16139, "AHAMSS4, Arnhem" },
	{ 16140, "43048/3540AA, Utrecht" },
	{ 16141, "43048/3540AA, Utrecht" },
	{ 16142, "TISMI redundant, 1042AZ 140 AMSTERDAM" },
	{ 16143, "AM1STP01/AM1STP02, Schiphol-Rijk" },
	{ 16144, "Athens MSC 2, International" },
	{ 16145, "Athens MSC 2, signaling proxy 1" },
	{ 16146, "Athens MSC 2, signaling proxy 2" },
	{ 16147, "Athens MSC 4, International" },
	{ 16148, "Athens MSC 4, signaling proxy 1" },
	{ 16149, "Athens MSC 4, signaling proxy 2" },
	{ 16150, "Athens MSC 3, International" },
	{ 16151, "Athens MSC 5, International" },
	{ 16160, "Berne_3" },
	{ 16161, "Lausanne_3" },
	{ 16162, "Zürich" },
	{ 16163, "Zürich" },
	{ 16164, "Zürich" },
	{ 16165, "Zürich_1" },
	{ 16166, "Zürich_2" },
	{ 16171, "Squire" },
	{ 16172, "LON-TPCPC" },
	{ 16173, "Beijing 1" },
	{ 16174, "Beijing 2" },
	{ 16175, "London" },
	{ 16176, "" },
	{ 16177, "" },
	{ 16178, "" },
	{ 16179, "" },
	{ 16180, "" },
	{ 16184, "HMG9-MSS01" },
	{ 16185, "HMG9-MGW01" },
	{ 16186, "SIG14-MSS02" },
	{ 16187, "SIG14-MGW02" },
	{ 16188, "MSC-S Marienborg" },
	{ 16189, "MSC-S Dora" },
	{ 16190, "MGW Marienborg" },
	{ 16191, "MGW Dora" },
	{ 16192, "MSC-S 82" },
	{ 16193, "MSC-S 83" },
	{ 16194, "London2" },
	{ 16195, "JE/W/ITP2" },
	{ 16196, "MSCS - 87" },
	{ 16197, "STP 07" },
	{ 16198, "JE/N/ITP2" },
	{ 16199, "STP08" },
	{ 16211, "LONDON" },
	{ 16212, "London ISC" },
	{ 16214, "Stour Marine 2" },
	{ 16215, "Stour Marine" },
	{ 16216, "MSS3 Split" },
	{ 16217, "OKTV1" },
	{ 16218, "OKTV2" },
	{ 16219, "AKT-HR01" },
	{ 16220, "STP1" },
	{ 16221, "STP2" },
	{ 16222, "STMSCS2" },
	{ 16223, "TERRA_ZG_SW-4" },
	{ 16224, "" },
	{ 16226, "Barcelona MSC" },
	{ 16227, "Barcelona PTS" },
	{ 16228, "" },
	{ 16229, "" },
	{ 16234, "London Poplar" },
	{ 16235, "London 3" },
	{ 16236, "London 4" },
	{ 16237, "London 5" },
	{ 16238, "London 6" },
	{ 16240, "Transatel-Paris" },
	{ 16241, "SFR - Paris 2" },
	{ 16242, "Symacom - Paris 1" },
	{ 16243, "PTS03 – Nanterre" },
	{ 16244, "PTS04 – Bobigny" },
	{ 16245, "MT008 – Bobigny" },
	{ 16246, "MG001 – Crosne" },
	{ 16247, "MG002 – Bobigny" },
	{ 16248, "Sonus-GSX2 Košice" },
	{ 16249, "MSS MO2SK" },
	{ 16250, "MGW MG2SK" },
	{ 16256, "Telio1" },
	{ 16257, "Oslo3" },
	{ 16258, "C4MGW1" },
	{ 16260, "TGS-MGC01" },
	{ 16261, "TGS-MGC02" },
	{ 16262, "OXIA (MSS)" },
	{ 16263, "OXIB (MGW)" },
	{ 16264, "" },
	{ 16265, "Leganés MSS101" },
	{ 16266, "Hospitalet MSS201" },
	{ 16267, "Alicante MSS301" },
	{ 16268, "Málaga MSS501" },
	{ 16271, "" },
	{ 16273, "KSISC2" },
	{ 16275, "FRTKV1" },
	{ 16276, "INTER1" },
	{ 16277, "KIIS1" },
	{ 16278, "KHAISC3" },
	{ 16279, "DNIS1" },
	{ 16280, "Cloud9 MSC 1" },
	{ 16281, "Cloud9 MSC 2" },
	{ 16282, "SGWBE1" },
	{ 16283, "SGWKS1" },
	{ 16284, "SGWGL1" },
	{ 16285, "SGWMS1" },
	{ 16287, "DOUGLAS 1" },
	{ 16288, "OPL WAW 7" },
	{ 16289, "TMP WAW 6" },
	{ 16290, "TMP KOM 1" },
	{ 16291, "P4 WAW 1" },
	{ 16292, "P4 WAW 2" },
	{ 16293, "P4 KAT 1" },
	{ 16294, "P4 KAT 2" },
	{ 16295, "POL POZ 3" },
	{ 16296, "ECON2" },
	{ 16297, "" },
	{ 16298, "MSC-3" },
	{ 16299, "MSC-2" },
	{ 16300, "Riga MWTV 1" },
	{ 16301, "TGT 4" },
	{ 16302, "CM Riga ISC 1" },
	{ 16303, "AEO 1" },
	{ 16304, "TMP WAW 4" },
	{ 16305, "POL POZ 2" },
	{ 16306, "TMP WAW 5" },
	{ 16307, "GAL WAW" },
	{ 16308, "OPL WAW 6" },
	{ 16309, "AMD WAW" },
	{ 16310, "P4 WAW 6" },
	{ 16311, "AER WAW 3" },
	{ 16312, "Chiasso" },
	{ 16313, "Cham" },
	{ 16314, "Zürich" },
	{ 16315, "Chiasso" },
	{ 16316, "Zürich 2" },
	{ 16317, "Zurich" },
	{ 16318, "Zürich_4" },
	{ 16319, "Zürich_5" },
	{ 16320, "Oradea" },
	{ 16321, "Bucuresti" },
	{ 16322, "Bucuresti" },
	{ 16323, "Ploiesti" },
	{ 16324, "Bucuresti" },
	{ 16325, "Bucuresti" },
	{ 16326, "Bucuresti" },
	{ 16327, "Bucuresti" },
	{ 16331, "Frankfurt" },
	{ 16334, "Frankfurt" },
	{ 16335, "Frankfurt" },
	{ 16336, "Riga Gateway" },
	{ 16337, "" },
	{ 16338, "TGT 3" },
	{ 16339, "Riga" },
	{ 16340, "MPE RIGA" },
	{ 16341, "Riga" },
	{ 16342, "Riga Gateway 1" },
	{ 16343, "Adamasto 01" },
	{ 16344, "MSC-S 74" },
	{ 16346, "Birmingham M0S" },
	{ 16347, "MSC-S 17" },
	{ 16348, "UK Sonus" },
	{ 16349, "Meon" },
	{ 16350, "Rea" },
	{ 16352, "" },
	{ 16353, "" },
	{ 16354, "" },
	{ 16355, "" },
	{ 16356, "" },
	{ 16357, "" },
	{ 16358, "" },
	{ 16359, "" },
	{ 16360, "Manchester" },
	{ 16362, "Severn" },
	{ 16363, "BURUM 1" },
	{ 16364, "MSC 25" },
	{ 16365, "London" },
	{ 16366, "MSC 26" },
	{ 16367, "MSC-S15" },
	{ 16368, "Madrid" },
	{ 16369, "Barcelona-STP22" },
	{ 16371, "Madrid" },
	{ 16376, "Orange Balzers MGW" },
	{ 16377, "First Mobile Vaduz 01" },
	{ 16378, "First Mobile Vaduz 02" },
	{ 16379, "iMetrik HLR" },
	{ 16380, "Cubic Vaduz HLR 01" },
	{ 16381, "Cubic Vaduz HLR 02" },
	{ 16382, "Cubic Vaduz HSS 01" },
	{ 16383, "Cubic Vaduz HSS 02" },
	{ 0, NULL }
};

/*
 * List of International Signalling Point Codes (ISPC)
 * Annex to ITU Operational Bulletin No. 1199 - 1.VII.2020
 *
 * Mapping of ISPC to Name of the signalling point operator
 */
static const value_string q708_ispc_operator_name[] = {
	{  4096, "Telecom Liechtenstein AG" },
	{  4097, "Telecom Liechtenstein AG" },
	{  4099, "Telecom Liechtenstein AG" },
	{  4100, "Telecom Liechtenstein AG" },
	{  4101, "iMetrik Global (Europe) AG" },
	{  4102, "Orange (Liechtenstein) AG" },
	{  4103, "iMetrik Global (Europe) AG" },
	{  4104, "BT Italia S.p.A." },
	{  4105, "BT Italia S.p.A." },
	{  4106, "Mc Link S.p.A." },
	{  4107, "Wind Telecomunicazioni S.p.A." },
	{  4108, "Wind Telecomunicazioni S.p.A." },
	{  4109, "Clouditalia Telecomunicazioni S.p.A." },
	{  4110, "KPN Telecom BV" },
	{  4111, "Intermatica S.p.A." },
	{  4112, "KPN B.V." },
	{  4113, "ASpider Solutions Nederland B.V." },
	{  4114, "T-Mobile Netherlands B.V." },
	{  4115, "Highside Telecom B.V." },
	{  4116, "Level 3 Communications B.V." },
	{  4117, "ProRail B.V." },
	{  4118, "UPC Nederland B.V." },
	{  4119, "KPN B.V." },
	{  4120, "Clouditalia Telecomunicazioni S.p.A." },
	{  4121, "Fastweb S.p.A." },
	{  4122, "Vodafone Italia S.p.A." },
	{  4123, "Enter s.r.l." },
	{  4124, "Tiscali Italia S.p.A." },
	{  4125, "Parla.it S.p.A." },
	{  4126, "Parla.it S.p.A." },
	{  4127, "Go Mobile S.r.l." },
	{  4128, "OTE" },
	{  4130, "OTE" },
	{  4131, "OTE" },
	{  4132, "WIND" },
	{  4133, "VODAFONE-PANAFON" },
	{  4134, "COSMOTE" },
	{  4135, "VODAFONE-PANAFON" },
	{  4136, "COSMOLINE" },
	{  4137, "WIND" },
	{  4138, "FORTHNET" },
	{  4139, "WIND" },
	{  4140, "WIND" },
	{  4141, "WIND" },
	{  4142, "COSMOTE" },
	{  4143, "4G BUSINESS SOLUTIONS LTD" },
	{  4144, "Colt Technology Services B.V." },
	{  4145, "Orcavoice B.V." },
	{  4146, "Solaris Systems B.V." },
	{  4147, "Coolwave Communications B.V." },
	{  4148, "T-Mobile Netherlands B.V." },
	{  4149, "T-Mobile Netherlands B.V." },
	{  4150, "KPN B.V." },
	{  4151, "Tele2 Nederland B.V." },
	{  4152, "Tele2 Nederland B.V." },
	{  4153, "Roamware (Netherlands) B.V." },
	{  4154, "InterXion Holding N.V." },
	{  4155, "Tele2 Nederland B.V." },
	{  4156, "UPC Nederland B.V." },
	{  4157, "T-Mobile Netherlands B.V." },
	{  4158, "KPN B.V." },
	{  4159, "T-Mobile Netherlands B.V." },
	{  4160, "AT&T Global Network Services Nederland B.V." },
	{  4161, "KPN B.V." },
	{  4162, "KPN B.V." },
	{  4163, "KPN B.V." },
	{  4164, "BT NEDERLAND N.V." },
	{  4165, "T-Mobile Netherlands B.V." },
	{  4166, "BT NEDERLAND N.V." },
	{  4167, "KPN B.V." },
	{  4168, "KPN B.V." },
	{  4169, "KPN B.V." },
	{  4170, "KPN B.V." },
	{  4171, "AT&T Global Network Services Nederland B.V." },
	{  4172, "KPN B.V." },
	{  4173, "KPN B.V." },
	{  4174, "KPN B.V." },
	{  4175, "KPN B.V." },
	{  4176, "TISMI B.V." },
	{  4177, "Hilf Telecom B.V." },
	{  4178, "Vodafone Libertel B.V." },
	{  4179, "Vodafone Libertel B.V." },
	{  4180, "Syniverse Technologies Inc." },
	{  4181, "Visiontel V.o.f." },
	{  4182, "TeleSign Netherlands B.V." },
	{  4183, "VimpelCom International Services B.V." },
	{  4184, "BT NEDERLAND N.V." },
	{  4185, "BT NEDERLAND N.V." },
	{  4186, "BT NEDERLAND N.V." },
	{  4187, "Orange Business Netherlands B.V." },
	{  4188, "Orange Business Netherlands B.V." },
	{  4189, "Verizon Nederland B.V." },
	{  4190, "Elephant Talk Communications Premium Rate Services" },
	{  4191, "EspritXB B.V." },
	{  4193, "Belgacom International Carrier Services" },
	{  4194, "Belgacom International Carrier Services" },
	{  4195, "Belgacom International Carrier Services" },
	{  4197, "Orange Belgium" },
	{  4199, "Belgacom International Carrier Services" },
	{  4200, "Wind International Services" },
	{  4201, "Belgacom International Carrier Services" },
	{  4202, "Telenet" },
	{  4203, "Wind International Services" },
	{  4204, "Wind International Services" },
	{  4205, "Wind International Services" },
	{  4208, "Belgacom International Carrier Services" },
	{  4209, "COLT Technology Services" },
	{  4210, "Unleashed" },
	{  4211, "Unleashed" },
	{  4212, "Orange Belgium" },
	{  4213, "IP Nexia" },
	{  4215, "Belgacom International Carrier Services" },
	{  4216, "Belgacom International Carrier Services" },
	{  4217, "BT Ltd (Belgian Branch)" },
	{  4218, "Gateway Communications" },
	{  4219, "Telenet" },
	{  4220, "Telenet" },
	{  4222, "Telenet Group" },
	{  4223, "Roamware" },
	{  4224, "Sewan Communications" },
	{  4225, "SFR" },
	{  4226, "Orange" },
	{  4227, "Orange" },
	{  4228, "Free Mobile" },
	{  4229, "SFR" },
	{  4230, "Free Mo bile" },
	{  4231, "Orange" },
	{  4232, "SFR" },
	{  4233, "Vérizon France" },
	{  4235, "Wavecrest Communications France" },
	{  4236, "SFR" },
	{  4237, "SFR" },
	{  4238, "SFR" },
	{  4239, "SFR" },
	{  4240, "Orange" },
	{  4241, "Bouygues Telecom" },
	{  4242, "Bouygues Telecom" },
	{  4243, "Completel" },
	{  4244, "Orange" },
	{  4245, "SFR" },
	{  4246, "Vue Tel" },
	{  4247, "Orange" },
	{  4248, "Free Telecom" },
	{  4249, "Orange" },
	{  4250, "Free Telecom" },
	{  4251, "Orange" },
	{  4252, "Colt Telecommunications France" },
	{  4253, "SFR" },
	{  4254, "Colt Telecommunications France" },
	{  4255, "SFR" },
	{  4256, "Free Mobile" },
	{  4257, "SFR" },
	{  4258, "Cable & Wireless" },
	{  4259, "Viatel Operations SA" },
	{  4260, "Free Mobile" },
	{  4261, "Orange" },
	{  4262, "Orange" },
	{  4263, "Orange" },
	{  4264, "Société Française du Radiotéléphone" },
	{  4265, "Société Française du Radiotéléphone" },
	{  4266, "Société Française du Radiotéléphone" },
	{  4267, "Société Française du Radiotéléphone" },
	{  4268, "Jet comm telecom" },
	{  4269, "Jet comm telecom" },
	{  4270, "Bouygues Telecom" },
	{  4271, "SFR" },
	{  4272, "Orange" },
	{  4273, "Colt Telecommunications" },
	{  4274, "Equant" },
	{  4275, "SFR" },
	{  4276, "SFR" },
	{  4277, "SFR" },
	{  4278, "SFR" },
	{  4279, "SFR" },
	{  4280, "Budget Telecom" },
	{  4281, "Colt Telecommunications France" },
	{  4282, "BJT Partners" },
	{  4283, "SFR" },
	{  4284, "Viatel Operations SA" },
	{  4285, "BJT Partners" },
	{  4286, "Phone Systems & Networks" },
	{  4287, "Telecom Italia" },
	{  4288, "Monaco Telecom" },
	{  4289, "Monaco Telecom" },
	{  4290, "Monaco Telecom" },
	{  4291, "Monaco Telecom" },
	{  4292, "Mednet" },
	{  4293, "PTK" },
	{  4294, "Monaco Telecom" },
	{  4295, "Monaco Telecom" },
	{  4296, "T-Mobile Austria GmbH" },
	{  4301, "Hutchison Drei Austria GmbH" },
	{  4302, "Hutchison Drei Austria GmbH" },
	{  4304, "Colt Technology Services GmbH" },
	{  4305, "Brennercom Tirol GmbH" },
	{  4308, "Verizon Austria GmbH" },
	{  4309, "A1 Telekom Austria AG" },
	{  4311, "A1 Telekom Austria AG" },
	{  4312, "Grupalia Internet S.A." },
	{  4313, "ENTIDAD PÚBLICA EMPRESARIAL ADMINISTRADOR DE INFRAESTRUCTURAS FERROVIARIAS" },
	{  4314, "ENTIDAD PÚBLICA EMPRESARIAL ADMINISTRADOR DE INFRAESTRUCTURAS FERROVIARIAS" },
	{  4315, "SYMA MOBILE ESPAÑA, S.L." },
	{  4316, "SYMA MOBILE ESPAÑA, S.L." },
	{  4317, "Vodafone Enabler España, S.L." },
	{  4318, "Vodafone Enabler España, S.L." },
	{  4319, "Neo Sky 2002, S.A." },
	{  4327, "ADAMO TELECOM IBERIA, S.A." },
	{  4328, "Vodafone España, S.L." },
	{  4329, "Vodafone España, S.L." },
	{  4332, "Cableuropa, S.A." },
	{  4333, "Cableuropa, S.A." },
	{  4334, "Vodafone España" },
	{  4335, "Vodafone España" },
	{  4336, "ORANGE ESPAGNE, S.A.UNIPERSONAL" },
	{  4337, "ORANGE ESPAGNE, S.A.UNIPERSONAL" },
	{  4342, "France Telecom España,S.S. Unipersonal" },
	{  4343, "France Telecom España, S.A. Unipersonal" },
	{  4344, "France Telecom España, S.A. Unipersonal" },
	{  4345, "France Telecom España, S.A. Unipersonal" },
	{  4347, "COLT TECHNOLOGY SERVICES,S.A. UNIPERSONAL" },
	{  4348, "TELEFÓNICA INTERNATIONAL WHOLESALE SERVICES, S.L. UNIPERSONAL" },
	{  4349, "TELEFÓNICA INTERNATIONAL WHOLESALE SERVICES, S.L. UNIPERSONAL" },
	{  4351, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{  4352, "Telenor Hungary Ltd" },
	{  4354, "MÁV Co." },
	{  4358, "Türk Telekom International HU Ltd." },
	{  4359, "BT Limited Hungarian Branch Office" },
	{  4360, "Versatel Süd GmbH" },
	{  4361, "Versatel Süd GmbH" },
	{  4362, "Vodafone GmbH" },
	{  4363, "Vodafone GmbH" },
	{  4364, "NEXT-ID GmbH" },
	{  4365, "Versatel Germany GmbH" },
	{  4366, "Versatel Süd GmbH" },
	{  4367, "KPN International INS" },
	{  4368, "TeleConnect CZ s.r.o." },
	{  4369, "Vectone (Ireland) Ltd." },
	{  4370, "TYNTEC GmbH" },
	{  4371, "Vodafone GmbH" },
	{  4372, "SOTIS CO LLC" },
	{  4373, "Orange Business Germany GmbH" },
	{  4374, "Vodafone BW GmbH" },
	{  4375, "ProTel International LLC" },
	{  4376, "Cronford Trading Ltd" },
	{  4377, "Carrier 1 AG" },
	{  4378, "Carrier 1 AG" },
	{  4379, "Cube Communication GmbH" },
	{  4382, "Telefónica Germany GmbH & Co. OHG" },
	{  4383, "Telefónica Germany GmbH & Co. OHG" },
	{  4384, "Vodafone GmbH" },
	{  4385, "Vodafone GmbH" },
	{  4386, "S.C CreditCall S.R.L." },
	{  4387, "Versatel Süd GmbH" },
	{  4388, "Capital City Ltd" },
	{  4389, "TelcoVillage GmbH" },
	{  4390, "European Telecommunication Holding AG" },
	{  4391, "Datix Group Inc." },
	{  4392, "Unifi Communications Ltd" },
	{  4393, "OVH GmbH" },
	{  4394, "Colt Telecom GmbH" },
	{  4395, "Avelacom HK Ltd" },
	{  4396, "Angel Telecom AG" },
	{  4397, "EWE TEL GmbH" },
	{  4398, "Valpasera Ltd." },
	{  4400, "MTX Connect Limited" },
	{  4401, "Cronosell Telecom Ltd." },
	{  4402, "Verizon Deutschland GmbH" },
	{  4403, "Verizon Deutschland GmbH" },
	{  4404, "Ventelo GmbH" },
	{  4405, "Telefónica Germany GmbH & Co. OHG" },
	{  4406, "E-Plus Mobilfunk GmbH" },
	{  4407, "E-Plus Mobilfunk GmbH" },
	{  4408, "E-Plus Mobilfunk GmbH" },
	{  4409, "E-Plus Mobilfunk GmbH" },
	{  4410, "Express Teleservice Corp." },
	{  4411, "M'net Telekommunikations GmbH" },
	{  4412, "NAT.com Ltd" },
	{  4413, "TrueConnect Communications GmbH" },
	{  4414, "Colt Telecom GmbH" },
	{  4415, "hallo.tel Deutschland GmbH" },
	{  4416, "Telekom Srbija a.d." },
	{  4417, "Telekom Srbija a.d." },
	{  4418, "M" },
	{  4419, "Telekom Srbija a.d." },
	{  4420, "M" },
	{  4421, "M" },
	{  4422, "Telenor d.o.o." },
	{  4423, "M" },
	{  4424, "Daily Telecom Mobile S.r.l." },
	{  4425, "Tiscali Italia S.p.A." },
	{  4426, "Tiscali Italia S.p.A." },
	{  4427, "Wind Telecomunicazioni S.p.A." },
	{  4428, "Wind Telecomunicazioni S.p.A." },
	{  4429, "Welcome Italia S.p.A." },
	{  4430, "Intermatica S.p.A." },
	{  4431, "Colt Technology Services S.p.A." },
	{  4432, "BT Italia S.p.A." },
	{  4433, "BT Italia S.p.A." },
	{  4434, "Vodafone Italia S.p.A." },
	{  4435, "Planetel s.r.l." },
	{  4436, "B4 S.r.l." },
	{  4437, "Agile Telecom S.r.l." },
	{  4438, "Clouditalia Telecomunicazioni S.p.A." },
	{  4439, "Brennercom S.p.A." },
	{  4440, "Carrefour Italia Mobile" },
	{  4441, "ElsyNet S.r.l." },
	{  4442, "H3G S.p.A." },
	{  4443, "Momax" },
	{  4444, "Welcome Italia S.p.A." },
	{  4445, "Brennercom S.p.A." },
	{  4446, "Welcome Italia S.p.A." },
	{  4447, "Poste Mobile S.p.A." },
	{  4448, "Telecom Italia Sparkle" },
	{  4449, "Telecom Italia Sparkle" },
	{  4450, "Telecom Italia Sparkle" },
	{  4451, "Telecom Italia Sparkle" },
	{  4452, "Telecom Italia Sparkle" },
	{  4453, "Telecom Italia Sparkle" },
	{  4454, "Telecom Italia Sparkle" },
	{  4455, "NewVAS S.p.A." },
	{  4456, "Telecom Italia Sparkle" },
	{  4457, "Colt Technology Services S.p.A." },
	{  4458, "Wind Telecomunicazioni S.p.A." },
	{  4459, "Telecom Italia Sparkle" },
	{  4460, "Telecom Italia Sparkle" },
	{  4461, "Vodafone Italia S.p.A." },
	{  4462, "Vodafone Italia S.p.A." },
	{  4463, "Telecom Italia Sparkle" },
	{  4464, "Telecom Italia Sparkle" },
	{  4465, "Wind Telecomunicazioni S.p.A." },
	{  4466, "Telecom Italia Sparkle" },
	{  4467, "H3G S.p.A." },
	{  4468, "Telecom Italia Sparkle" },
	{  4469, "Orange Business Italy S.p.A." },
	{  4470, "BT Italia S.p.A." },
	{  4471, "BT Italia S.p.A." },
	{  4472, "Wind Telecomunicazioni S.p.A." },
	{  4473, "Wind Telecomunicazioni S.p.A." },
	{  4474, "Wind Telecomunicazioni S.p.A." },
	{  4475, "Telecom Italia S.p.A. - TIM" },
	{  4476, "Telecom Italia S.p.A. - TIM" },
	{  4477, "Verizon Italia S.p.A." },
	{  4478, "Planetel s.r.l." },
	{  4479, "Planetel s.r.l." },
	{  4480, "Brennercom S.p.A." },
	{  4481, "Vodafone Italia S.p.A." },
	{  4482, "Vodafone Italia S.p.A." },
	{  4483, "Cable & Wireless S.p.A." },
	{  4484, "Vodafone Italia S.p.A." },
	{  4485, "BT Italia S.p.A." },
	{  4486, "Vodafone Italia S.p.A." },
	{  4487, "Vodafone Italia S.p.A." },
	{  4488, "Vodafone Italia S.p.A." },
	{  4489, "Telecom Italia S.p.A." },
	{  4490, "Telecom Italia S.p.A." },
	{  4491, "Bellnet International S.r.l." },
	{  4492, "Vodafone Italia S.p.A." },
	{  4493, "Vodafone Italia S.p.A." },
	{  4494, "Clouditalia Telecomunicazioni S.p.A." },
	{  4495, "TWT S.p.A." },
	{  4496, "Vodafone Italia S.p.A." },
	{  4497, "Planetel s.r.l." },
	{  4498, "Planetel s.r.l." },
	{  4499, "Vodafone Italia S.p.A." },
	{  4500, "Orange Business Italy S.p.A." },
	{  4501, "Daily Telecom Mobile S.r.l." },
	{  4502, "H3G S.p.A." },
	{  4503, "Agile Telecom S.r.l." },
	{  4504, "Poste Mobile S.p.A." },
	{  4505, "Poste Mobile S.p.A." },
	{  4506, "LINEA COM S.r.l" },
	{  4507, "H3G S.p.A." },
	{  4508, "Digitel Italia S.p.A." },
	{  4509, "Daily Telecom Mobile S.r.l." },
	{  4510, "Noverca S.r.l." },
	{  4511, "Noverca S.r.l." },
	{  4512, "Romtelecom S.A." },
	{  4513, "Romtelecom S.A." },
	{  4514, "Romtelecom S.A." },
	{  4515, "Cosmote Romanian Mobile Telecommunications" },
	{  4516, "Romtelecom S.A." },
	{  4517, "Vodafone Romania" },
	{  4518, "Orange Romania" },
	{  4519, "Telemobil" },
	{  4520, "Interoute Managed Services" },
	{  4521, "Salt Mobile SA" },
	{  4522, "Belgacom International SA" },
	{  4524, "Switchover AG" },
	{  4526, "Belgacom International SA" },
	{  4527, "Salt Mobile SA" },
	{  4528, "Schweizerische Bundesbahnen SBB" },
	{  4529, "Salt Mobile SA" },
	{  4530, "Salt Mobile SA" },
	{  4531, "Phonegroup SA" },
	{  4532, "NTH AG" },
	{  4533, "NTH AG" },
	{  4534, "Belgacom International SA" },
	{  4535, "UPC Schweiz GmbH" },
	{  4536, "Swisscom (Schweiz) AG" },
	{  4537, "Swisscom (Schweiz) AG" },
	{  4538, "Swisscom (Schweiz) AG" },
	{  4539, "Beeone Communications SA" },
	{  4540, "Swisscom (Schweiz) AG" },
	{  4541, "Beeone Communications SA" },
	{  4542, "Colt Technology Services AG" },
	{  4543, "Salt Mobile SA" },
	{  4544, "Belgacom International SA" },
	{  4545, "Belgacom International Carrier" },
	{  4546, "Belgacom International Carrier" },
	{  4547, "Swisscom (Schweiz) AG" },
	{  4548, "Colt Technology Services AG" },
	{  4549, "Swisscom (Schweiz) AG" },
	{  4550, "Belgacom International Carrier" },
	{  4551, "Belgacom International Carrier" },
	{  4552, "Swisscom (Schweiz) AG" },
	{  4553, "Swisscom (Schweiz) AG" },
	{  4554, "Swisscom (Schweiz) AG" },
	{  4555, "Swisscom (Schweiz) AG" },
	{  4556, "Comfone AG" },
	{  4557, "Relario AG" },
	{  4558, "Comfone AG" },
	{  4559, "Calltrade Carrier Services AG" },
	{  4560, "Verizon Switzerland" },
	{  4561, "Sunrise Communications AG" },
	{  4562, "Sunrise Communications AG" },
	{  4563, "Calltrade Carrier Services AG" },
	{  4564, "Sunrise Communications AG" },
	{  4565, "LTN Liechtenstein Telenet AG" },
	{  4566, "Colt Technology Services AG" },
	{  4567, "Orange Business Switzerland AG" },
	{  4568, "Fink Telecom Services" },
	{  4569, "Belgacom International Carrier Service (Switzerland) AG" },
	{  4570, "Belgacom International SA" },
	{  4571, "Schweizerische Bundesbahnen SBB" },
	{  4572, "TelCommunication Services AG" },
	{  4573, "Swisscom (Schweiz) AG" },
	{  4574, "Swisscom (Schweiz) AG" },
	{  4575, "Swisscom (Schweiz) AG" },
	{  4577, "T-Mobile Czech Republic a.s." },
	{  4578, "T-Mobile Czech Republic a.s." },
	{  4579, "CD-Telematika a.s." },
	{  4580, "Sprava zeleznicni dopravni cesty, st org." },
	{  4581, "Telco pro Service, a.s." },
	{  4582, "Sprava zeleznicni dopravni cesty, st org." },
	{  4584, "TelServ BV" },
	{  4585, "Salt Mobile SA" },
	{  4586, "IVY Telecom SA" },
	{  4587, "UPC Schweiz GmbH" },
	{  4588, "IVY Telecom SA" },
	{  4590, "Comfone AG" },
	{  4591, "Comfone AG" },
	{  4592, "MITTO AG" },
	{  4593, "MITTO AG" },
	{  4594, "Sunrise Communications AG" },
	{  4595, "Calltrade Carrier Services AG" },
	{  4596, "Fink Telecom Services" },
	{  4597, "TelCommunication Services AG" },
	{  4598, "mgi networks gmbh" },
	{  4599, "UPC Schweiz GmbH" },
	{  4600, "Belgacom International Carrier Service (Switzerland) AG" },
	{  4601, "Sunrise Communications AG" },
	{  4603, "Calltrade Carrier Services AG" },
	{  4604, "IVY Telecom SA" },
	{  4606, "MITTO AG" },
	{  4607, "MITTO AG" },
	{  4608, "A1 Telekom Austria AG" },
	{  4609, "A1 Telekom Austria AG" },
	{  4610, "A1 Telekom Austria AG" },
	{  4611, "A1 Telekom Austria AG" },
	{  4612, "A1 Telekom Austria AG" },
	{  4613, "WNT Telecommunication GmbH" },
	{  4614, "MASS Response Service GmbH" },
	{  4615, "A1 Telekom Austria AG" },
	{  4616, "A1 Telekom Austria AG" },
	{  4617, "A1 Telekom Austria AG" },
	{  4618, "A1 Telekom Austria AG" },
	{  4619, "A1 Telekom Austria AG" },
	{  4620, "A1 Telekom Austria AG" },
	{  4622, "A1 Telekom Austria AG" },
	{  4623, "Tele2 Telecommunication GmbH" },
	{  4626, "Hutchison Drei Austria GmbH" },
	{  4627, "Hutchison Drei Austria GmbH" },
	{  4628, "Hutchison Drei Austria GmbH" },
	{  4629, "Tele2 Telecommunication GmbH" },
	{  4630, "1012-Festnetz-Service GmbH" },
	{  4632, "Orange Business Austria GmbH" },
	{  4633, "Orange Business Austria GmbH" },
	{  4634, "ÖBB - Infrastruktur AG" },
	{  4635, "ÖBB - Infrastruktur AG" },
	{  4636, "ÖBB - Infrastruktur AG" },
	{  4637, "Hutchison Drei Austria GmbH" },
	{  4638, "Hutchison Drei Austria GmbH" },
	{  4639, "UPC Telekabel Wien GmbH" },
	{  4641, "Vodafone Ltd (C&W)" },
	{  4642, "Communications Networking Services (UK)" },
	{  4643, "Vodafone Ltd (C&W)" },
	{  4644, "Epsilon Telecommunications Ltd" },
	{  4645, "British Telecom" },
	{  4647, "Fogg Mobile AB" },
	{  4648, "Truphone Ltd" },
	{  4649, "British Telecom" },
	{  4650, "British Telecom" },
	{  4651, "Yaana Technologies LLC" },
	{  4652, "Truphone Ltd" },
	{  4653, "Switchware Limited" },
	{  4654, "Switchware Limited" },
	{  4655, "Epsilon Telecommunications Ltd" },
	{  4656, "Communications Networking Services (UK)" },
	{  4657, "TalkTalk Communications Limited" },
	{  4658, "Communications Networking Services (UK)" },
	{  4659, "Communications Networking Services (UK)" },
	{  4660, "Communications Networking Services (UK)" },
	{  4661, "Communications Networking Services (UK)" },
	{  4662, "Communications Networking Services (UK)" },
	{  4663, "Communications Networking Services (UK)" },
	{  4664, "Communications Networking Services (UK)" },
	{  4665, "Communications Networking Services (UK)" },
	{  4666, "VODAFONE LIMITED" },
	{  4667, "VODAFONE LIMITED" },
	{  4668, "Jersey Airtel Limited" },
	{  4669, "Communications Networking Services (UK)" },
	{  4670, "Invicta Group FZE" },
	{  4671, "Greystone Telecom Limited" },
	{  4672, "Vodafone Ltd (C&W)" },
	{  4673, "Vodafone Ltd (C&W)" },
	{  4674, "Vodafone Ltd (C&W)" },
	{  4675, "Vodafone Ltd (C&W)" },
	{  4676, "Vodafone Ltd (C&W)" },
	{  4677, "Vodafone Ltd (C&W)" },
	{  4678, "Vodafone Ltd (C&W)" },
	{  4679, "Vodafone Ltd (C&W)" },
	{  4680, "Cloud9 Mobile Communications Ltd" },
	{  4681, "Cloud9 Mobile Communications Ltd" },
	{  4683, "Greystone Telecom Limited" },
	{  4684, "Atlas Interactive Group Limited" },
	{  4685, "QXTEL Ltd" },
	{  4686, "Global Electroteks Ltd" },
	{  4687, "(aq) Networks Limited" },
	{  4688, "Core Communication Services Ltd" },
	{  4689, "Fogg Mobile AB" },
	{  4690, "Orange Business Holdings UK Limited" },
	{  4691, "Nutel Communications Ltd" },
	{  4692, "GCI Network Solutions Limited" },
	{  4693, "Reach Europe Ltd" },
	{  4694, "Reach Europe Ltd" },
	{  4695, "Reach Europe Ltd" },
	{  4697, "EE Limited (Orange)" },
	{  4698, "C2C Ltd" },
	{  4699, "Idt Global Ltd" },
	{  4700, "Interoute Networks Limited" },
	{  4701, "EE Limited ( TM)" },
	{  4702, "JT (Jersey) Limited" },
	{  4703, "JT (Jersey) Limited" },
	{  4704, "TDC A/S" },
	{  4706, "TDC A/S" },
	{  4709, "TDC A/S" },
	{  4711, "TDC A/S" },
	{  4714, "Global One Communication A/S" },
	{  4715, "Banedanmark" },
	{  4716, "Banedanmark" },
	{  4719, "Banedanmark" },
	{  4721, "TeliaSonera AB" },
	{  4725, "Barablu Mobile Ltd" },
	{  4732, "TeliaSonera AB" },
	{  4733, "Digital Network" },
	{  4736, "Telia Sverige AB" },
	{  4737, "A3 Företag AB" },
	{  4738, "Tele2 Sverige AB" },
	{  4739, "Tele2 Sverige AB" },
	{  4740, "A3 Företag AB" },
	{  4741, "Telia Sverige AB" },
	{  4742, "Netett Sverige AB" },
	{  4743, "Telia Sverige AB" },
	{  4744, "Telia Sverige AB" },
	{  4745, "Telia Sverige AB" },
	{  4746, "Telia Sverige AB" },
	{  4747, "Telia Sverige AB" },
	{  4748, "HI3G Access AB" },
	{  4749, "Tele2 Business AB" },
	{  4750, "Tele2 Business AB" },
	{  4752, "Com Hem AB" },
	{  4753, "Tele2 Sverige AB" },
	{  4754, "Telia Sverige AB" },
	{  4755, "HI3G Access AB" },
	{  4756, "HI3G Access AB" },
	{  4758, "HI3G Access AB" },
	{  4760, "Tele2 Sverige AB" },
	{  4761, "Tele2 Sverige AB" },
	{  4762, "Verizon Sweden AB" },
	{  4763, "Verizon Sweden AB" },
	{  4764, "Telenor Sverige AB" },
	{  4765, "Telenor Sverige AB" },
	{  4766, "A3 Företag AB" },
	{  4768, "Marlink Enterprise AS" },
	{  4769, "Marlink Enterprise AS" },
	{  4770, "Telia Norge AS" },
	{  4771, "Orange Business Norway AS" },
	{  4772, "AeroMobile AS" },
	{  4773, "Telenor Norge AS" },
	{  4774, "Telenor Norge AS" },
	{  4775, "Orange Business Norway AS" },
	{  4776, "Telenor Global Services AS" },
	{  4779, "Telenor Global Services AS" },
	{  4780, "Telia Norge AS" },
	{  4781, "TDC AS" },
	{  4782, "Phonero AS" },
	{  4783, "Telia Norge AS" },
	{  4784, "Telia Norge AS" },
	{  4785, "Telia Norge AS" },
	{  4786, "TDC AS" },
	{  4787, "TDC AS" },
	{  4788, "Kvantel AS" },
	{  4789, "Telia Norge AS" },
	{  4790, "TDC AS" },
	{  4791, "TDC AS" },
	{  4793, "Telia Norge AS" },
	{  4794, "TDC AS" },
	{  4795, "Com4 AS" },
	{  4796, "Marlink Enterprise AS" },
	{  4797, "Telenor Maritime AS" },
	{  4799, "Telenor Maritime AS" },
	{  4803, "Elisa Oyj" },
	{  4805, "Telia Finland Oyj" },
	{  4806, "Telia Finland Oyj" },
	{  4809, "Telia Finland Oyj" },
	{  4811, "Telia Finland Oyj" },
	{  4812, "Telia Finland Oyj" },
	{  4813, "DNA Oyj" },
	{  4814, "DNA Oyj" },
	{  4815, "Telia Finland Oyj" },
	{  4816, "Ålands Telekommunikation Ab" },
	{  4817, "Ålands Telekommunikation Ab" },
	{  4818, "DNA Oyj" },
	{  4820, "Elisa Oyj" },
	{  4821, "Elisa Oyj" },
	{  4823, "Telia Finland Oyj" },
	{  4824, "Telia Finland Oyj" },
	{  4825, "Elisa Oyj" },
	{  4832, "AS Eesti Telekom" },
	{  4833, "AS Eesti Telekom" },
	{  4834, "Tele2 Eesti AS" },
	{  4835, "Tele2 Eesti AS" },
	{  4837, "OU Top Connect" },
	{  4838, "OU Top Connect" },
	{  4839, "OU Top Connect" },
	{  4840, "Messagenet S.p.A." },
	{  4841, "King.com S.p.A." },
	{  4842, "King.com S.p.A." },
	{  4843, "ADR Tel S.p.A." },
	{  4844, "Clouditalia Telecomunicazioni S.p.A." },
	{  4845, "Telespazio S.p.A." },
	{  4846, "Tiscali Italia S.p.A." },
	{  4847, "Itelsi S.r.l." },
	{  4848, "Colt Technology Services S.p.A." },
	{  4849, "BT Italia S.p.A." },
	{  4850, "Wind Telecomunicazioni S.p.A." },
	{  4851, "Wind Telecomunicazioni S.p.A." },
	{  4852, "Poste Mobile S.p.A." },
	{  4853, "Digitel Mobile Srl" },
	{  4854, "Poste Mobile S.p.A." },
	{  4855, "Telespazio S.p.A." },
	{  4856, "Vodafone Italia S.p.A." },
	{  4857, "Vodafone Italia S.p.A." },
	{  4858, "Vuelle Elettronica S.r.l." },
	{  4859, "Vuelle Elettronica S.r.l." },
	{  4860, "Wind Telecomunicazioni S.p.A." },
	{  4861, "Alena ICT S.R.L" },
	{  4862, "Qcom Interactive S.p.A." },
	{  4863, "Colt Technology Services S.p.A." },
	{  4864, "Lattelecom" },
	{  4865, "Lattelecom" },
	{  4866, "Lattelecom" },
	{  4867, "Latvenergo" },
	{  4868, "Latvijas Mobilais Telefons SIA" },
	{  4869, "Telekom Baltija" },
	{  4870, "Tele2" },
	{  4871, "Latvijas Mobilais Telefons SIA" },
	{  4872, "Orange Belgium" },
	{  4873, "Orange Belgium" },
	{  4875, "Telenet Group" },
	{  4876, "Telenet Group" },
	{  4877, "Telenet Group" },
	{  4879, "Telenet" },
	{  4880, "Vodafone Belgium" },
	{  4881, "Gateway Communications" },
	{  4882, "Gateway Communications" },
	{  4883, "Telenet Group" },
	{  4884, "Telenet Group" },
	{  4885, "Gateway Communications" },
	{  4886, "Nethys SA" },
	{  4887, "Nethys SA" },
	{  4888, "Wind International Services" },
	{  4890, "N.M.B.S." },
	{  4891, "N.M.B.S." },
	{  4892, "Orange Belgium" },
	{  4893, "Orange Belgium" },
	{  4895, "Voyacom" },
	{  4896, "OJSC Rostelecom" },
	{  4897, "OJSC Rostelecom" },
	{  4898, "OJSC Rostelecom" },
	{  4899, "OJSC Rostelecom" },
	{  4900, "OJSC Rostelecom" },
	{  4901, "OJSC Rostelecom" },
	{  4902, "OJSC Rostelecom" },
	{  4903, "OJSC Rostelecom" },
	{  4904, "OJSC Multiregional TransitTelecom" },
	{  4905, "OJSC Multiregional TransitTelecom" },
	{  4906, "OJSC Multiregional TransitTelecom" },
	{  4911, "OJSC Multiregional TransitTelecom" },
	{  4912, "Mobile TeleSystems" },
	{  4913, "North-West Branch of OJSC Megafon" },
	{  4917, "Mobile TeleSystems" },
	{  4920, "CSC Iridium Technologies" },
	{  4928, "OJSC Rostelecom" },
	{  4929, "OJSC Rostelecom" },
	{  4930, "OJSC Rostelecom" },
	{  4931, "OJSC Rostelecom" },
	{  4932, "OJSC Rostelecom" },
	{  4933, "OJSC Rostelecom" },
	{  4934, "OJSC Rostelecom" },
	{  4935, "OJSC Rostelecom" },
	{  5056, "Orange Polska S.A." },
	{  5057, "Orange Polska S.A." },
	{  5058, "Orange Polska S.A." },
	{  5059, "Orange Polska S.A." },
	{  5060, "Orange Polska S.A." },
	{  5061, "POLKOMTEL Sp. z o.o." },
	{  5062, "POLKOMTEL Sp. z o.o." },
	{  5063, "NORDISK POLSKA Sp. z o.o." },
	{  5064, "Vodafone GmbH" },
	{  5065, "Vodafone GmbH" },
	{  5066, "Verizon Deutschland GmbH" },
	{  5067, "Comistel s.r.o." },
	{  5068, "DIDWW Ireland Limited" },
	{  5069, "Vodafone GmbH" },
	{  5070, "Vintage Wireless Networks" },
	{  5071, "iBasis" },
	{  5072, "Telekom Deutschland GmbH" },
	{  5073, "P.T.I. GmbH" },
	{  5074, "Mobilcom Cityline GmbH" },
	{  5075, "Capital City Service Ltd" },
	{  5076, "Versatel West GmbH" },
	{  5077, "Versatel West GmbH" },
	{  5078, "NEXT-ID GmbH" },
	{  5079, "Verscom LLC" },
	{  5080, "mobilcom-debitel GmbH" },
	{  5081, "European Telecommunication Holding AG" },
	{  5082, "Rovex Management s.r.o" },
	{  5083, "interactive digital media GmbH" },
	{  5084, "AVS international s.r.o." },
	{  5085, "Ventelo GmbH" },
	{  5086, "Versatel West GmbH" },
	{  5087, "T-Mobile Deutschland GmbH" },
	{  5088, "Viocast Solutions Inc." },
	{  5089, "Telekom Deutschland GmbH" },
	{  5090, "Telekom Deutschland GmbH" },
	{  5091, "Telekom Deutschland GmbH" },
	{  5092, "Telekom Deutschland GmbH" },
	{  5093, "Telekom Deutschland GmbH" },
	{  5094, "Telekom Deutschland GmbH" },
	{  5095, "Telekom Deutschland GmbH" },
	{  5096, "Mega Satellitenfernsehen GmbH" },
	{  5097, "Colt Telecom GmbH" },
	{  5098, "Telekom Deutschland GmbH" },
	{  5099, "Emir Telecom Ltd" },
	{  5100, "interactive digital media GmbH" },
	{  5101, "Merkur Telecomservices GmbH" },
	{  5102, "MTT OY" },
	{  5103, "Level 3 Communications GmbH" },
	{  5104, "Telekom Deutschland GmbH" },
	{  5105, "EAD Telecom S.R.L." },
	{  5106, "Telekom Deutschland GmbH" },
	{  5107, "Telekom Deutschland GmbH" },
	{  5108, "Telekom Deutschland GmbH" },
	{  5109, "Telekom Deutschland GmbH" },
	{  5110, "Telekom Deutschland GmbH" },
	{  5111, "Alliance Telecom Ltd" },
	{  5112, "Express Teleservice Corp." },
	{  5113, "Orange Business Germany GmbH" },
	{  5114, "Telekom Deutschland GmbH" },
	{  5115, "Versatel West GmbH" },
	{  5117, "Closed Joint Stock Company TransTeleCom" },
	{  5118, "Telekom Deutschland GmbH" },
	{  5119, "Callax Telecom Services GmbH" },
	{  5120, "Telekom Deutschland GmbH" },
	{  5121, "Telekom Deutschland GmbH" },
	{  5122, "Telekom Deutschland GmbH" },
	{  5123, "Telekom Deutschland GmbH" },
	{  5124, "Telekom Deutschland GmbH" },
	{  5125, "Telekom Deutschland GmbH" },
	{  5126, "Switchover AG" },
	{  5127, "Cobalt Networks Ltd" },
	{  5128, "Telefónica o2 Germany GmbH & Co. KG" },
	{  5130, "Telekom Deutschland GmbH" },
	{  5131, "Versatel Süd GmbH" },
	{  5132, "Versatel Süd GmbH" },
	{  5133, "SAMA S.A.L" },
	{  5134, "DOCOMO Digital Germany GmbH" },
	{  5135, "IPXP Europe s.r.o." },
	{  5136, "Telekom Deutschland GmbH" },
	{  5137, "PrasMosCom s.r.o." },
	{  5138, "Awitel Inc." },
	{  5139, "Archway Srl" },
	{  5140, "Telekom Deutschland GmbH" },
	{  5141, "Telekom Deutschland GmbH" },
	{  5142, "Telekom Deutschland GmbH" },
	{  5143, "Telekom Deutschland GmbH" },
	{  5144, "Kabel Deutschland Vertrieb und Service GmbH & Co.KG" },
	{  5145, "Callax Telecom Services GmbH" },
	{  5146, "Deutsche Telekom AG" },
	{  5147, "Deutsche Telekom AG" },
	{  5148, "Telekom Deutschland GmbH" },
	{  5149, "Telekom Deutschland GmbH" },
	{  5150, "Telekom Deutschland GmbH" },
	{  5151, "Telekom Deutschland GmbH" },
	{  5152, "Gibtelecom (mobile service)" },
	{  5154, "Gibtelecom (fixed service)" },
	{  5155, "Sapphire Networks (fixed service)" },
	{  5156, "Gibtelecom" },
	{  5157, "Eazi Telecom Ltd (trading as “Limba”)" },
	{  5161, "Hutchison Drei Austria GmbH" },
	{  5162, "T-Mobile Austria GmbH" },
	{  5163, "T-Mobile Austria GmbH" },
	{  5164, "T-Mobile Austria GmbH" },
	{  5165, "T-Mobile Austria GmbH" },
	{  5166, "T-Mobile Austria GmbH" },
	{  5167, "ÖBB - Infrastruktur AG" },
	{  5168, "Orange Polska S.A." },
	{  5169, "MediaTel S.A." },
	{  5170, "T-MOBILE POLSKA S.A." },
	{  5171, "Netia S.A." },
	{  5172, "Netia S.A." },
	{  5173, "EXATEL S.A." },
	{  5174, "EXATEL S.A." },
	{  5175, "Orange Polska S.A." },
	{  5176, "Join Experience S.A." },
	{  5177, "Join Experience S.A." },
	{  5178, "MTX Connect S.à r.l." },
	{  5179, "EPT" },
	{  5180, "EPT" },
	{  5181, "EPT" },
	{  5182, "BLOCKED" },
	{  5183, "BLOCKED" },
	{  5184, "MEO (Fixed)" },
	{  5185, "MEO (Fixed)" },
	{  5186, "MEO (Fixed)" },
	{  5187, "MEO (Fixed)" },
	{  5188, "MEO (Fixed)" },
	{  5189, "MEO (Fixed)" },
	{  5190, "MEO (Fixed)" },
	{  5192, "NOS Comunicações, S.A." },
	{  5193, "MEO (Fixed)" },
	{  5194, "MEO (Fixed)" },
	{  5195, "MEO (Fixed)" },
	{  5196, "NOS Comunicações, S.A." },
	{  5197, "NOS Comunicações, S.A." },
	{  5198, "AR Telecom - Acessos e Redes de Telecomunicações, S.A." },
	{  5201, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5202, "NOS Comunicações, S.A." },
	{  5203, "ONITELECOM - Infocomunicações, S.A." },
	{  5204, "ONITELECOM - Infocomunicações, S.A." },
	{  5205, "ONITELECOM - Infocomunicações, S.A." },
	{  5206, "NOS Comunicações, S.A." },
	{  5207, "NOS Comunicações, S.A." },
	{  5208, "NOS Comunicações, S.A." },
	{  5209, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5210, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5211, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5212, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5213, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5214, "COLT Technology Services, Unipessoal, Lda." },
	{  5215, "Infraestruturas de Portugal, S.A." },
	{  5216, "EPT" },
	{  5217, "EPT" },
	{  5218, "EPT" },
	{  5219, "Tango S.A." },
	{  5220, "Syniverse Technologies S.à r.l." },
	{  5221, "Syniverse Technologies S.à r.l." },
	{  5222, "Orange Business Luxembourg S.A." },
	{  5223, "Tango S.A." },
	{  5224, "Telenet Solutions S.A." },
	{  5225, "Syniverse Technologies S.à r.l." },
	{  5226, "Cegecom S.A." },
	{  5227, "Tango S.A." },
	{  5228, "EPT" },
	{  5229, "NV Verizon Belgium Luxembourg S.A." },
	{  5230, "Orange Communications Luxembourg S.A." },
	{  5231, "Orange Communications Luxembourg S.A." },
	{  5232, "Syniverse Technologies Inc." },
	{  5233, "Verizon Nederland B.V." },
	{  5234, "Intercity Mobile Communications B.V." },
	{  5235, "Vodafone Libertel B.V." },
	{  5236, "Vodafone Libertel B.V." },
	{  5237, "Vodafone Libertel B.V." },
	{  5238, "Inmarsat Solutions B.V." },
	{  5239, "Elephant Talk Communications Premium Rate Services" },
	{  5240, "BT NEDERLAND N.V." },
	{  5241, "KPN B.V." },
	{  5242, "Hilf Telecom B.V." },
	{  5243, "Syniverse Technologies Inc." },
	{  5244, "Tele2 Nederland B.V." },
	{  5245, "T-Mobile Netherlands B.V." },
	{  5246, "Verizon Nederland B.V." },
	{  5247, "KPN B.V." },
	{  5248, "Eircom plc" },
	{  5249, "Eircom plc" },
	{  5250, "Eircell Ltd" },
	{  5251, "Eircell Ltd" },
	{  5252, "Eircom plc" },
	{  5253, "Three Ireland (Hutchison) Limited" },
	{  5254, "Three Ireland (Hutchison) Limited" },
	{  5255, "Esat Telecom" },
	{  5256, "Esat Telecom" },
	{  5257, "WorldCom" },
	{  5258, "Ocean" },
	{  5259, "ITL" },
	{  5260, "Interoute Irl" },
	{  5261, "Ocean" },
	{  5262, "WorldCom" },
	{  5263, "Budget Telecom" },
	{  5264, "Vodafone Ireland" },
	{  5265, "Three Ireland (Hutchison) Limited" },
	{  5266, "Magnet Networks" },
	{  5267, "Interoute" },
	{  5268, "Three Ireland (Hutchison) Limited" },
	{  5269, "Colt Telecommunications" },
	{  5270, "Colt Telecommunications" },
	{  5271, "ESL Consulting (trading as VoIP Ireland)" },
	{  5272, "Liquid Telecommunications Limited" },
	{  5273, "Fix Group Technologies" },
	{  5274, "Reliance Jio Infocomm UK Ltd" },
	{  5275, "Verizon UK Ltd" },
	{  5276, "Sky UK Limited" },
	{  5277, "Lan-Net Telecommunications Ltd" },
	{  5278, "Lan-Net Telecommunications Ltd" },
	{  5279, "Bellingham Telecommunications Limited" },
	{  5280, "Iceland Telecom Ltd" },
	{  5281, "Iceland Telecom Ltd" },
	{  5283, "IP Fjarskipti Ltd" },
	{  5284, "Hallo Frjals Fjarskipti Ltd" },
	{  5285, "Islandssimi Ltd" },
	{  5286, "Islandssimi Ltd" },
	{  5287, "Nova ehf" },
	{  5288, "MCI Worldcom" },
	{  5289, "Completel" },
	{  5290, "Intercall" },
	{  5291, "Telia France" },
	{  5292, "Cable & Wireless" },
	{  5293, "Coriolis Telecom" },
	{  5294, "Coriolis Telecom" },
	{  5295, "Numéricâble" },
	{  5296, "Orange" },
	{  5297, "Completel" },
	{  5298, "Mobiquithings" },
	{  5299, "Mobiquithings" },
	{  5300, "Mobiquithings" },
	{  5301, "Orange" },
	{  5302, "Orange" },
	{  5303, "Prosodie" },
	{  5304, "SAP France" },
	{  5305, "SAP France" },
	{  5306, "Bouygues Telecom" },
	{  5307, "Symacom" },
	{  5308, "Equant Telecommunications SA" },
	{  5309, "SFR" },
	{  5310, "GC Pan European Crossing France" },
	{  5311, "Multicoms" },
	{  5312, "ALBTelecom" },
	{  5313, "AMC (Albanian Mobile Communications)" },
	{  5315, "ALBtelecom" },
	{  5316, "ALBTelecom" },
	{  5318, "Mobile 4 AL" },
	{  5319, "PLUS COMMUNICATIONS" },
	{  5320, "Sky UK Limited" },
	{  5321, "Telesign Mobile Limited" },
	{  5322, "Lycamobile UK Limited" },
	{  5323, "Lycamobile UK Limited" },
	{  5325, "Tata Communications (UK) Ltd" },
	{  5326, "Jersey Airtel Limited" },
	{  5327, "Communications Networking Services (UK)" },
	{  5328, "AT&T Global Network Services (UK) B.V." },
	{  5329, "Magrathea Telecommunications Limited" },
	{  5331, "Lan-Net Telecommunications Ltd" },
	{  5332, "EE Limited ( TM)" },
	{  5333, "CenturyLink Communications UK Limited" },
	{  5334, "CenturyLink Communications UK Limited" },
	{  5335, "Marathon Telecom Limited" },
	{  5336, "Interoute Networks Limited" },
	{  5337, "Infiniroute Networks Inc" },
	{  5339, "Colt Technology Services Ltd" },
	{  5340, "CenturyLink Communications UK Limited" },
	{  5341, "Ematel Communications Inc" },
	{  5342, "Interoute Networks Limited" },
	{  5344, "Maltacom/GO plc" },
	{  5345, "Maltacom/GO plc" },
	{  5346, "GO plc – Mobile" },
	{  5347, "Vodafone Malta Ltd." },
	{  5348, "Vodafone Malta Ltd." },
	{  5351, "Melita plc - Mobile" },
	{  5352, "AGSM Telecomunicazioni srl" },
	{  5353, "Clouditalia Telecomunicazioni S.p.A." },
	{  5354, "Estracom S.p.A." },
	{  5355, "Wind Telecomunicazioni S.p.A." },
	{  5356, "Wind Telecomunicazioni S.p.A." },
	{  5357, "Wind Telecomunicazioni S.p.A." },
	{  5358, "Wind Telecomunicazioni S.p.A." },
	{  5359, "Poste Mobile S.p.A." },
	{  5360, "Teslatel" },
	{  5361, "H3G S.p.A." },
	{  5362, "ElsyNet S.r.l." },
	{  5363, "ElsyNet S.r.l." },
	{  5364, "Clouditalia Telecomunicazioni S.p.A." },
	{  5365, "H3G S.p.A." },
	{  5366, "Pagine Gialle Phone Service S.R.L." },
	{  5367, "TERRECABLATE Reti e Servizi srl" },
	{  5368, "TWT S.p.A." },
	{  5369, "Tiscali Italia S.p.A." },
	{  5370, "Telecom Italia S.p.A. - TIM" },
	{  5371, "Telecom Italia S.p.A. - TIM" },
	{  5372, "H3G S.p.A." },
	{  5373, "Tex 97 S.p.A." },
	{  5374, "Vodafone Italia S.p.A." },
	{  5375, "H3G S.p.A." },
	{  5376, "Cyprus Telecommunications Authority (CYTA)" },
	{  5377, "Cyprus Telecommunications Authority (CYTA)" },
	{  5378, "MTN Cyprus Limited" },
	{  5379, "CALLSAT INTERNATIONAL TELECOMMUNICATIONS" },
	{  5380, "MTN Cyprus Limited" },
	{  5381, "OTENet Telecommunications Ltd." },
	{  5382, "Primetel PLC" },
	{  5383, "D.S.T. Omega Telecom" },
	{  5384, "Communications Networking Services (UK)" },
	{  5386, "Globetouch AB" },
	{  5387, "Globetouch AB" },
	{  5388, "Tata Communications (UK) Ltd" },
	{  5389, "Verizon UK Ltd" },
	{  5390, "Eircom UK Ltd" },
	{  5391, "Tata Communications (UK) Ltd" },
	{  5392, "MANX TELECOM TRADING LIMITED" },
	{  5393, "Telesign Mobile Limited" },
	{  5394, "Colt Technology Services Ltd" },
	{  5395, "Colt Technology Services Ltd" },
	{  5397, "Sure (Guernsey) Limited" },
	{  5398, "Communications Networking Services (UK)" },
	{  5399, "EE Limited (Orange)" },
	{  5400, "EE Limited ( TM)" },
	{  5401, "LEBARA LIMITED" },
	{  5402, "Icron Network Limited" },
	{  5403, "MANX TELECOM TRADING LIMITED" },
	{  5404, "Gamma Telecom Holdings Ltd" },
	{  5405, "VueTel Italia S.p.A." },
	{  5407, "Spacetel UK Ltd" },
	{  5408, "Virgin Media Limited" },
	{  5409, "MOBIWEB TELECOM LIMITED" },
	{  5410, "Triaxcess" },
	{  5411, "Virgin Mobile Telecoms Limited" },
	{  5412, "Virgin Mobile Telecoms Limited" },
	{  5413, "China Mobile International (UK) Limited" },
	{  5414, "Verizon UK Ltd" },
	{  5415, "China Mobile International (UK) Limited" },
	{  5416, "CenturyLink Communications UK Limited" },
	{  5417, "CFL Communications Limited" },
	{  5418, "EE Limited (Orange)" },
	{  5419, "PCCW Global UK Limited" },
	{  5421, "LEBARA LIMITED" },
	{  5423, "Colt Technology Services Ltd" },
	{  5424, "Tata Communications (UK) Ltd" },
	{  5425, "CenturyLink Communications UK Limited" },
	{  5426, "Colt Technology Services Ltd" },
	{  5427, "Atlas Interactive Group Limited" },
	{  5428, "Hutchison Global Communications (UK) Limited" },
	{  5429, "TalkTalk Communications Limited" },
	{  5430, "Communications Networking Services (UK)" },
	{  5431, "EE Limited (Orange)" },
	{  5432, "SKD 4 Limited" },
	{  5433, "Communications Networking Services (UK)" },
	{  5434, "EE Limited (Orange)" },
	{  5437, "Communications Networking Services (UK)" },
	{  5438, "Communications Networking Services (UK)" },
	{  5439, "Hanhaa Limited" },
	{  5440, "Interoute Bulgaria" },
	{  5441, "Bulgarian Telecommunication Company" },
	{  5442, "Bulgarian Telecommunication Company" },
	{  5443, "Mobiltel" },
	{  5444, "Mobiltel" },
	{  5445, "Telenor Bulgaria" },
	{  5446, "Mobiltel" },
	{  5447, "Mobiltel" },
	{  5448, "Hutchison Global Communications (UK) Limited" },
	{  5449, "Verizon UK Ltd" },
	{  5450, "Global Electroteks Ltd" },
	{  5451, "Hanhaa Limited" },
	{  5452, "AEROMOBILE COMMUNICATIONS LIMITED" },
	{  5453, "EE Limited (Orange)" },
	{  5454, "AEROMOBILE COMMUNICATIONS LIMITED" },
	{  5455, "VODAFONE LIMITED" },
	{  5456, "Idt Global Ltd" },
	{  5457, "Idt Global Ltd" },
	{  5459, "EE Limited (Orange)" },
	{  5460, "EE Limited (Orange)" },
	{  5461, "Communications Networking Services (UK)" },
	{  5462, "Colt Technology Services Ltd" },
	{  5463, "Global Electroteks Ltd" },
	{  5464, "Eser Telekom" },
	{  5465, "Gisad" },
	{  5466, "Borusan" },
	{  5468, "Vianet" },
	{  5469, "Superonline" },
	{  5470, "Netone" },
	{  5472, "Türk Telekom" },
	{  5473, "Türk Telekom" },
	{  5474, "Türk Telekom" },
	{  5475, "Türk Telekom" },
	{  5476, "Vodafone" },
	{  5477, "Turkcell" },
	{  5478, "Turkcell" },
	{  5479, "Vodafone" },
	{  5481, "Avea" },
	{  5482, "Avea" },
	{  5483, "Avea" },
	{  5484, "Avea" },
	{  5485, "Vodafone" },
	{  5486, "Vodafone" },
	{  5487, "Millenicom" },
	{  5488, "Colt Technology Services Ltd" },
	{  5490, "EE Limited (Orange)" },
	{  5491, "Communications Networking Services (UK)" },
	{  5492, "Communications Networking Services (UK)" },
	{  5493, "VODAFONE LIMITED" },
	{  5495, "Wavecrest (UK) Ltd" },
	{  5497, "Citrus Telecommunications Ltd" },
	{  5498, "EE Limited (Orange)" },
	{  5499, "EE Limited (Orange)" },
	{  5500, "Communications Networking Services (UK)" },
	{  5501, "Symmetric Quorum Limited" },
	{  5502, "CenturyLink Communications UK Limited" },
	{  5503, "VODAFONE LIMITED" },
	{  5504, "Voicetec Systems Ltd" },
	{  5505, "EE Limited (Orange)" },
	{  5506, "EE Limited (Orange)" },
	{  5507, "EE Limited (Orange)" },
	{  5508, "SKD 4 Limited" },
	{  5509, "Sky UK Limited" },
	{  5510, "Sky UK Limited" },
	{  5511, "VODAFONE LIMITED" },
	{  5513, "VODAFONE LIMITED" },
	{  5514, "Idt Global Ltd" },
	{  5515, "Syniverse Technologies Inc" },
	{  5518, "VODAFONE LIMITED" },
	{  5519, "Syniverse Technologies Inc" },
	{  5520, "VODAFONE LIMITED" },
	{  5521, "EE Limited ( TM)" },
	{  5522, "Sure (Guernsey) Limited" },
	{  5523, "Sama S.A.L Offshore" },
	{  5524, "Tata Communications (UK) Ltd" },
	{  5525, "CenturyLink Communications UK Limited" },
	{  5526, "Sure (Jersey) Limited" },
	{  5527, "Wavecrest (UK) Ltd" },
	{  5528, "C2C Ltd" },
	{  5529, "Level 3 Communications Ltd" },
	{  5530, "VODAFONE LIMITED" },
	{  5531, "Verizon UK Ltd" },
	{  5532, "Vodafone Ltd (Energis)" },
	{  5533, "Jersey Airtel Limited" },
	{  5534, "Docklands Data Centre Ltd" },
	{  5536, "HT d.d." },
	{  5537, "VIPnet d.o.o." },
	{  5538, "TELE2 d.o.o." },
	{  5539, "HT d.d." },
	{  5540, "HT d.d." },
	{  5541, "HT d.d." },
	{  5542, "VIPnet d.o.o." },
	{  5543, "VIPnet d.o.o." },
	{  5544, "System House S.r.l." },
	{  5545, "Vodafone Italia S.p.A." },
	{  5546, "Telecom Italia S.p.A. - TIM" },
	{  5547, "Vodafone Italia S.p.A." },
	{  5548, "Poste Mobile S.p.A." },
	{  5549, "Go Mobile S.r.l." },
	{  5550, "Telecom Italia S.p.A. - TIM" },
	{  5551, "Telecom Italia S.p.A. - TIM" },
	{  5552, "Telekom Slovenije d.d." },
	{  5553, "Telekom Slovenije d.d." },
	{  5554, "A1 Slovenija d.d." },
	{  5555, "Telekom Slovenije d.d." },
	{  5556, "Telemach d.o.o." },
	{  5557, "Mega M d.o.o." },
	{  5558, "Detel Global d.o.o." },
	{  5559, "Telemach d.o.o." },
	{  5560, "Clouditalia Telecomunicazioni S.p.A." },
	{  5561, "Vodafone Italia S.p.A." },
	{  5562, "Digitel Italia S.p.A." },
	{  5563, "Poste Mobile S.p.A." },
	{  5564, "Poste Mobile S.p.A." },
	{  5565, "Poste Mobile S.p.A." },
	{  5566, "Poste Mobile S.p.A." },
	{  5567, "GC Pan European Crossing Italia S.r.l." },
	{  5569, "Intelcom" },
	{  5570, "SMT-San Marino Telecom" },
	{  5571, "SMT-San Marino Telecom" },
	{  5573, "Mega M, d.o.o." },
	{  5576, "Colt Technology Services Ltd" },
	{  5577, "TalkTalk Communications Limited" },
	{  5579, "KDDI Europe Limited" },
	{  5580, "Wavecrest (UK) Ltd" },
	{  5581, "Jersey Airtel Limited" },
	{  5582, "Telefonica UK Limited" },
	{  5584, "JT (Jersey) Limited" },
	{  5585, "JT (Jersey) Limited" },
	{  5586, "JT (Jersey) Limited" },
	{  5588, "CITIC Telecom 1616 (Uk) Ltd" },
	{  5589, "Switchware Limited" },
	{  5590, "Epsilon Telecommunications Ltd" },
	{  5591, "Mintaka Limited" },
	{  5592, "Orange Business Holdings UK Limited" },
	{  5593, "Jersey Airtel Limited" },
	{  5594, "Telefonica UK Limited" },
	{  5595, "C2C Ltd" },
	{  5596, "Teltac Worldwide Offshore" },
	{  5597, "Teltac Worldwide Offshore" },
	{  5598, "Docklands Data Centre Ltd" },
	{  5599, "LEBARA LIMITED" },
	{  5600, "Nexus Telecommunications Limited" },
	{  5601, "Telefonica UK Limited" },
	{  5607, "Teltac Worldwide Offshore" },
	{  5608, "Teltac Worldwide Offshore" },
	{  5609, "Telefonica UK Limited" },
	{  5610, "Gamma Telecom Holdings Ltd" },
	{  5611, "Telefonica UK Limited" },
	{  5612, "EE Limited ( TM)" },
	{  5613, "EE Limited ( TM)" },
	{  5614, "Sure (Isle of Man) Limited" },
	{  5615, "Instafone Plc" },
	{  5616, "Vodafone Ltd (Energis)" },
	{  5617, "MTN GlobalConnect Solutions Limited" },
	{  5619, "Vodafone Ltd (C&W)" },
	{  5621, "Wireless Solutions International" },
	{  5622, "Colt Technology Services Ltd" },
	{  5623, "Colt Technology Services Ltd" },
	{  5624, "PLDT (UK) Limited" },
	{  5625, "Communications Networking Services (UK)" },
	{  5626, "Virgin Media Limited" },
	{  5627, "CenturyLink Communications UK Limited" },
	{  5628, "CenturyLink Communications UK Limited" },
	{  5629, "Gamma Telecom Holdings Ltd" },
	{  5630, "JT (Jersey) Limited" },
	{  5631, "TalkTalk Communications Limited" },
	{  5634, "Telia Sverige AB" },
	{  5635, "Telia Sverige AB" },
	{  5636, "Telia Sverige AB" },
	{  5637, "Telia Sverige AB" },
	{  5639, "A3 Företag AB" },
	{  5640, "Verizon Sweden AB" },
	{  5641, "Telenor Sverige AB" },
	{  5642, "Telenor Sverige AB" },
	{  5643, "A3 Företag AB" },
	{  5644, "Tele2 Sverige AB" },
	{  5645, "Tele2 Sverige AB" },
	{  5646, "Primlight AB" },
	{  5647, "Lycamobile Sweden Limited" },
	{  5649, "Colt Technology Services AB" },
	{  5650, "Telenor Sverige AB" },
	{  5651, "Telenor Sverige AB" },
	{  5652, "Telenor Sverige AB" },
	{  5653, "Telenor Sverige AB" },
	{  5654, "Lycamobile Sweden Limited" },
	{  5655, "Netett Sverige AB" },
	{  5656, "HI3G Access AB" },
	{  5657, "HI3G Access AB" },
	{  5658, "Telenor Sverige AB" },
	{  5661, "Telenor Connexion AB" },
	{  5662, "Telenor Connexion AB" },
	{  5663, "Tele2 Sverige AB" },
	{  5665, "Servei de Telecomunicacions d'Andorra" },
	{  5680, "Ziggo B.V." },
	{  5681, "Ziggo B.V." },
	{  5682, "Vodafone Libertel B.V." },
	{  5683, "Interoute Managed Services Netherlands B.V." },
	{  5684, "Tele2 Nederland B.V." },
	{  5685, "Tele2 Nederland B.V." },
	{  5686, "Tele2 Nederland B.V." },
	{  5687, "TISMI B.V." },
	{  5688, "AS STV" },
	{  5691, "Top Connect OÜ" },
	{  5693, "CLOUD COMMUNICATIONS OÜ" },
	{  5694, "CLOUD COMMUNICATIONS OÜ" },
	{  5695, "Nord Connect OÜ" },
	{  5696, "Arminco" },
	{  5697, "Armentel JV CJSC" },
	{  5698, "Armentel JV CJSC" },
	{  5699, "Orange Armenia" },
	{  5700, "PMF-SAL" },
	{  5701, "K Telecom" },
	{  5702, "K Telecom" },
	{  5704, "Telecom Italia" },
	{  5705, "SFR" },
	{  5706, "Colt Telecommunications" },
	{  5707, "Colt Telecommunications" },
	{  5709, "SFR" },
	{  5710, "Dauphin Telecom" },
	{  5711, "Orange" },
	{  5712, "Telecom Italia" },
	{  5713, "SFR" },
	{  5714, "Completel" },
	{  5715, "Orange" },
	{  5716, "Orange" },
	{  5717, "VOIP Orange" },
	{  5718, "Mobiweb Telecom" },
	{  5719, "Mobiweb Telecom" },
	{  5720, "Orange" },
	{  5722, "Longphone" },
	{  5723, "Free Telecom" },
	{  5724, "Free Telecom" },
	{  5725, "Outremer Telecom" },
	{  5726, "LLEIDA" },
	{  5727, "SFR" },
	{  5728, "Beltelecom" },
	{  5729, "Beltelecom" },
	{  5730, "Beltelecom" },
	{  5731, "Beltelecom" },
	{  5733, "Republican Unitary Enterprise ""National Traffic Exchange Center""" },
	{  5734, "Republican Unitary Enterprise ""National Traffic Exchange Center""" },
	{  5736, "Götalandsnätet AB" },
	{  5737, "Götalandsnätet AB" },
	{  5738, "42 Telecom AB" },
	{  5739, "42 Telecom AB" },
	{  5740, "Twilio Sweden AB" },
	{  5741, "Eu Tel AB" },
	{  5742, "Eu Tel AB" },
	{  5743, "LINK Mobile A/S" },
	{  5745, "YUBOTO" },
	{  5746, "IΝΤΕRCONNECT" },
	{  5749, "WIND" },
	{  5752, "Decatel S.R.L." },
	{  5753, "Poste Mobile S.p.A." },
	{  5754, "SMS Italia" },
	{  5755, "Vodafone Italia S.p.A." },
	{  5756, "Vodafone Italia S.p.A." },
	{  5757, "Brennercom S.p.A." },
	{  5758, "Tiscali Italia S.p.A." },
	{  5759, "Agile Telecom S.r.l." },
	{  5760, "Magticom Ltd" },
	{  5761, "System Net Ltd" },
	{  5762, "MagtiCom Ltd" },
	{  5763, "Geocell Ltd" },
	{  5764, "Geocell Ltd" },
	{  5765, "My phone Ltd" },
	{  5766, "Mobilive Ltd" },
	{  5767, "Datahouse global Ltd" },
	{  5768, "Net2Phone Inc" },
	{  5769, "Virgin Media Limited" },
	{  5770, "Marathon Telecom Limited" },
	{  5771, "Zamir Telecom Limited" },
	{  5772, "Virgin Media Limited" },
	{  5773, "X-Xchange Telecommunications Signalling Services Gmbh" },
	{  5774, "X-Xchange Telecommunications Signalling Services Gmbh" },
	{  5775, "Epsilon Telecommunications Ltd" },
	{  5776, "Docklands Data Centre Ltd" },
	{  5777, "Docklands Data Centre Ltd" },
	{  5778, "Lan-Net Telecommunications Ltd" },
	{  5779, "Lycamobile UK Limited" },
	{  5781, "CenturyLink Communications UK Limited" },
	{  5783, "VODAFONE LIMITED" },
	{  5784, "Colt Technology Services Ltd" },
	{  5785, "EE Limited (Orange)" },
	{  5787, "VODAFONE LIMITED" },
	{  5791, "EE Limited ( TM)" },
	{  5793, "Vodafone Hungary Ltd" },
	{  5794, "MÁV Co." },
	{  5797, "MÁV Co." },
	{  5798, "Telenor Hungary Ltd" },
	{  5799, "MÁV Co." },
	{  5801, "Caucasus Online Ltd" },
	{  5802, "Central Georgian Communications Co. Ltd." },
	{  5803, "Silknet JSC" },
	{  5805, "Global 1 JSC" },
	{  5806, "Caucasus Online Ltd" },
	{  5807, "Caucasus Digital Ntework Ltd" },
	{  5808, "Ukrtelecom JSC" },
	{  5809, "Ukrtelecom JSC" },
	{  5810, "PrJSC VF Ukraine" },
	{  5812, "JSC ""Kyivstar""" },
	{  5814, "Lifecell LLC" },
	{  5815, "Lifecell LLC" },
	{  5816, "Rete Ferroviaria Italiana S.p.A." },
	{  5817, "Acantho S.p.A." },
	{  5818, "Infracom Italia S.p.A." },
	{  5819, "H3G S.p.A." },
	{  5820, "Sinergie srl" },
	{  5821, "Telecom Italia S.p.A. - TIM" },
	{  5822, "Telecom Italia S.p.A. - TIM" },
	{  5823, "Telecom Italia S.p.A. - TIM" },
	{  5824, "Poste Mobile S.p.A." },
	{  5825, "Poste Mobile S.p.A." },
	{  5826, "Cable & Wireless S.p.A." },
	{  5827, "Clouditalia Telecomunicazioni S.p.A." },
	{  5828, "Clouditalia Telecomunicazioni S.p.A." },
	{  5829, "Clouditalia Telecomunicazioni S.p.A." },
	{  5830, "PrJSC VF Ukraine" },
	{  5831, "Digi Italy S.r.l." },
	{  5833, "COLT Telecom" },
	{  5841, "BH Telecom d.d. Sarajevo" },
	{  5842, "BH Telecom d.d. Sarajevo" },
	{  5843, "JP Hrvatske telekomunikacije d.d. Mostar" },
	{  5844, "JP Hrvatske telekomunikacije d.d. Mostar" },
	{  5846, "BH Telecom d.d. Sarajevo" },
	{  5847, "BH Telecom d.d. Sarajevo" },
	{  5848, "Teledigital d.d. Sarajevo" },
	{  5850, "Logosoft d.o.o. Sarajevo" },
	{  5852, "AKT.ONLINE d.o.o. Sarajevo" },
	{  5853, "Europronet Bosnia d.o.o. Sarajevo" },
	{  5854, "Blicnet d.o.o. Banja Luka" },
	{  5855, "“M&H” Company d.o.o. Sarajevo" },
	{  5856, "Neotel" },
	{  5857, "AD Makedonski Telekomunikaci" },
	{  5858, "AD Makedonski Telekomunikaci" },
	{  5859, "AD Makedonski Telekomunikaci" },
	{  5860, "AD Makedonski Telekomunikaci" },
	{  5861, "One AD" },
	{  5862, "Akton" },
	{  5863, "AD T-Mobile" },
	{  5864, "VOIP Orange" },
	{  5865, "Orange" },
	{  5866, "Budget Telecom" },
	{  5867, "SFR" },
	{  5868, "SFR" },
	{  5870, "Transatel" },
	{  5871, "Orange" },
	{  5872, "Teleworld International Ltd" },
	{  5873, "Vodafone Enterprise Germany GmbH" },
	{  5874, "Vasudev Global Limited" },
	{  5875, "E-Plus Mobilfunk GmbH & Co. KG" },
	{  5876, "01051 Telecom GmbH" },
	{  5877, "OneTel Telecommunication GmbH" },
	{  5878, "Kabel Deutschland Vertrieb und Service GmbH & Co.KG" },
	{  5879, "DB Netz Aktiengesellschaft" },
	{  5880, "NOWO Communications, S.A." },
	{  5881, "NOWO Communications, S.A." },
	{  5882, "G9Telecom, S.A." },
	{  5883, "G9Telecom, S.A." },
	{  5884, "AR Telecom - Acessos e Redes de Telecomunicações, S.A." },
	{  5885, "AR Telecom - Acessos e Redes de Telecomunicações, S.A." },
	{  5886, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5887, "Vodafone Portugal - Comunicações Pessoais, S.A." },
	{  5888, "Moldtelecom" },
	{  5889, "Moldtelecom" },
	{  5890, "Moldtelecom CDMA" },
	{  5891, "JSC Moldcell" },
	{  5894, "Moldcell GSM" },
	{  5895, "Orange Moldova GSM" },
	{  5896, "BT (Germany) GmbH & Co. oHG" },
	{  5897, "E-Plus Mobilfunk GmbH & Co. KG" },
	{  5898, "BT (Germany) GmbH & Co. oHG" },
	{  5899, "Saltfix Group Ltd." },
	{  5900, "Kabel Deutschland Vertrieb und Service GmbH & Co.KG" },
	{  5901, "Multiconnect GmbH" },
	{  5902, "Multiconnect GmbH" },
	{  5903, "01051 Telecom GmbH" },
	{  5904, "Dentel Netzwerk Telefonie GmbH" },
	{  5905, "BT (Germany) GmbH & Co. oHG" },
	{  5906, "BT (Germany) GmbH & Co. oHG" },
	{  5907, "Telefónica Germany GmbH & Co. OHG" },
	{  5908, "freenet Cityline GmbH" },
	{  5909, "freenet Cityline GmbH" },
	{  5910, "Vodafone GmbH" },
	{  5911, "Novy Telecom s.r.o." },
	{  5912, "GTS Telecom" },
	{  5913, "Vodafone Romania" },
	{  5914, "Vodafone Romania" },
	{  5915, "Vodafone Romania" },
	{  5916, "Orange Romania" },
	{  5917, "Vodafone Romania" },
	{  5918, "Orange Romania" },
	{  5919, "SNRadiocomunicatii" },
	{  5921, "Česká telekomunikační infrastruktura a.s." },
	{  5922, "Česká telekomunikační infrastruktura a.s." },
	{  5925, "Sprava zeleznicni dopravni cesty, st org." },
	{  5926, "Telco pro Service, a.s." },
	{  5928, "BT (Worldwide) Ltd., organizacni slozka" },
	{  5929, "Česká telekomunikační infrastruktura a.s." },
	{  5930, "Česká telekomunikační infrastruktura a.s." },
	{  5932, "T-Mobile Czech Republic a.s." },
	{  5933, "T-Mobile Czech Republic a.s." },
	{  5937, "T-Mobile Czech Republic a.s." },
	{  5939, "O2 Czech Republic a.s." },
	{  5940, "O2 Czech Republic a.s." },
	{  5941, "O2 Czech Republic a.s." },
	{  5942, "O2 Czech Republic a.s." },
	{  5943, "T-Mobile Czech Republic a.s." },
	{  5947, "Sprava zeleznicni dopravni cesty, st org." },
	{  5948, "T-Mobile Czech Republic a.s." },
	{  5949, "T-Mobile Czech Republic a.s." },
	{  5950, "Dial Telecom, a..s." },
	{  5951, "T-Mobile Czech Republic a.s." },
	{  5952, "Zeleznice Slovenskej republiky" },
	{  5953, "Slovak Telekom, a.s." },
	{  5954, "Slovak Telekom, a.s." },
	{  5955, "4Call, s.r.o." },
	{  5956, "Slovak Telekom, a.s." },
	{  5957, "Slovak Telekom, a.s." },
	{  5958, "Slovak Telekom, a.s." },
	{  5959, "Slovak Telekom, a.s." },
	{  5960, "GTS Nextra s.r.o." },
	{  5961, "Telefónica O2 Slovakia, s.r.o." },
	{  5962, "eTel Slovensko, s.r.o." },
	{  5963, "Dial Telecom, a.s." },
	{  5964, "GTS Slovakia s.r.o." },
	{  5965, "Amtel Slovensko, s.r.o." },
	{  5967, "Slovanet, a.s." },
	{  5968, "UPC Slovensko, s.r.o." },
	{  5969, "Orange Slovensko, a.s." },
	{  5970, "Swan, s.r.o." },
	{  5971, "Orange Slovensko, a.s." },
	{  5972, "Orange Slovensko, a.s." },
	{  5973, "Orange Slovensko, a.s." },
	{  5974, "BT Slovakia, s.r.o." },
	{  5975, "Energotel, a.s." },
	{  5976, "T-Mobile Slovensko, a.s." },
	{  5977, "Orange Slovensko, a.s." },
	{  5978, "T-Mobile Slovensko, a.s." },
	{  5979, "Orange Slovensko, a.s." },
	{  5980, "T-Mobile Slovensko, a.s." },
	{  5981, "Orange Slovensko, a.s." },
	{  5982, "T-Mobile Slovensko, a.s." },
	{  5983, "Orange Slovensko, a.s." },
	{  5984, "TEO LT, AB (former Lietuvos Telekomas)" },
	{  5985, "UAB Mediafon" },
	{  5986, "UAB Tele2" },
	{  5987, "UAB Bité Lietuva" },
	{  5988, "UAB Omnitel" },
	{  5989, "UAB Tele2" },
	{  5990, "TEO LT, AB (former Lietuvos Telekomas)" },
	{  5991, "UAB Bité Lietuva" },
	{  5992, "Telefónica Móviles España, S.A.U." },
	{  5993, "Telefónica Móviles España, S.A.U." },
	{  5994, "Telefónica Móviles España, S.A.U." },
	{  5995, "Telefónica Móviles España, S.A.U." },
	{  5996, "Orange Business Spain, S.A." },
	{  5997, "Digi Spain Telecom, S.L." },
	{  5998, "XTRA TELECOM, S.A. UNIPERSONAL" },
	{  5999, "Orange Web Services, S.L." },
	{  6000, "XFERA MÓVILES, S.A.U." },
	{  6001, "Vodafone España S.A.U." },
	{  6002, "XFERA MÓVILES, S.A.U." },
	{  6003, "Tata Communications (Spain), S.L." },
	{  6004, "Cableuropa, S.A." },
	{  6005, "Xfera Móviles S.A." },
	{  6006, "Xfera Móviles S.A." },
	{  6007, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{  6009, "France Telecom España, S.A. Unipersonal" },
	{  6010, "France Telecom España, S.A. Unipersonal" },
	{  6014, "Cableuropa, S.A.U." },
	{  6015, "Vodafone España S.A.U." },
	{  6016, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{  6017, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{  6018, "ORANGE ESPAGNE, S.A.UNIPERSONAL" },
	{  6019, "System One World Communication Iberia" },
	{  6020, "ORANGE ESPAGNE, S.A.UNIPERSONAL" },
	{  6022, "Cable & Wireless, S.L.U." },
	{  6024, "Cableuropa, S.A.U." },
	{  6026, "COLT TECHNOLOGY SERVICES,S.A. UNIPERSONAL" },
	{  6027, "System One World Communication Iberia" },
	{  6028, "Tata Communications (Spain), S.L." },
	{  6029, "ALTA TECNOLOGIA EN COMUNICACIONS, S.L." },
	{  6030, "Verizón Spain, S.L." },
	{  6032, "Telekom Deutschland GmbH" },
	{  6033, "IPVOIP s.r.o." },
	{  6034, "freenet Cityline GmbH" },
	{  6035, "Kabel Deutschland Vertrieb und Service GmbH & Co.KG" },
	{  6036, "Ventelo GmbH" },
	{  6037, "Ventelo GmbH" },
	{  6038, "Telefónica International Wholesale Services, S.L." },
	{  6039, "China Mobile International (UK) Limited" },
	{  6040, "Versatel West GmbH" },
	{  6041, "Level 3 Communications GmbH" },
	{  6042, "Median Telecom GmbH" },
	{  6043, "Colt Telecom GmbH" },
	{  6044, "Colt Telecom GmbH" },
	{  6045, "Verizon Deutschland GmbH" },
	{  6046, "Stellford Ltd." },
	{  6047, "Caspian Telecommunication Ltd." },
	{  6048, "Versatel Süd GmbH" },
	{  6049, "argon Networks UG" },
	{  6050, "Vodafone GmbH" },
	{  6051, "Tropolys Service GmbH" },
	{  6052, "GTT GmbH" },
	{  6053, "NGC Next Generation Communications GmbH" },
	{  6054, "OSS Cronford Ltd." },
	{  6055, "01066 GmbH" },
	{  6056, "BT (Germany) GmbH & Co. oHG" },
	{  6057, "BT (Germany) GmbH & Co. oHG" },
	{  6058, "T-Systems Enterprise Services GmbH" },
	{  6059, "Kinnevik Telecommunications International SA" },
	{  6060, "VEON Wholesale Services B.V." },
	{  6061, "Ventelo GmbH" },
	{  6062, "EMnify GmbH" },
	{  6063, "Versatel Nord GmbH" },
	{  6064, "Telefónica Germany GmbH & Co. OHG" },
	{  6065, "Telefónica Germany GmbH & Co. OHG" },
	{  6066, "Vodafone GmbH" },
	{  6067, "Vodafone GmbH" },
	{  6068, "Telefónica Germany GmbH & Co. OHG" },
	{  6069, "PGmedia Telecom GmbH" },
	{  6070, "EMnify GmbH" },
	{  6071, "Versatel Süd GmbH" },
	{  6072, "Xtend new media Holding GmbH" },
	{  6073, "Sinergia Telecom" },
	{  6074, "GTT GmbH" },
	{  6075, "DTC Telecom s.r.o." },
	{  6076, "NEXT-ID GmbH" },
	{  6077, "MMD Smart Ltd." },
	{  6078, "Net Communications Ventures Ltd." },
	{  6079, "Ventelo GmbH" },
	{  6080, "BT (Germany) GmbH & Co. oHG" },
	{  6081, "emTex Gesellschaft für neue Medien, Telefon- und Audiotex- Dienstleistungen mbH" },
	{  6082, "DB Netz AG" },
	{  6083, "NetAachen GmbH" },
	{  6084, "Drillisch Online AG" },
	{  6085, "Westend Management GmbH" },
	{  6086, "AlpTelco e.K." },
	{  6087, "T-Systems International GmbH" },
	{  6088, "Verizon Deutschland GmbH" },
	{  6089, "Kinnevik Telecommunications International SA" },
	{  6090, "Softnet Trading PTE. LTD." },
	{  6091, "Quiston Limited" },
	{  6092, "CIS Voip Inc." },
	{  6093, "Ecotel Communication AG" },
	{  6094, "VSE Net GmbH" },
	{  6095, "mobilcom-debitel GmbH" },
	{  6096, "SIA Zigma Telecom" },
	{  6097, "Hansa Telecom SIA" },
	{  6098, "VSE Net GmbH" },
	{  6099, "InterXion Telecom BV" },
	{  6100, "DB Netz AG" },
	{  6101, "Apelby GmbH" },
	{  6102, "BUNGATEL PTE Ltd." },
	{  6103, "mobilcom-debitel GmbH" },
	{  6104, "mobilcom-debitel GmbH" },
	{  6105, "Vodafone GmbH" },
	{  6106, "Vodafone GmbH" },
	{  6107, "Vodafone GmbH" },
	{  6108, "Vodafone GmbH" },
	{  6109, "DOCOMO Digital Germany GmbH" },
	{  6110, "Drillisch Online AG" },
	{  6111, "Ventelo GmbH" },
	{  6112, "First Communication GmbH" },
	{  6113, "VR Telecom SL" },
	{  6114, "Ventelo GmbH" },
	{  6115, "Ventelo GmbH" },
	{  6116, "Ventelo GmbH" },
	{  6117, "Nobel LTA." },
	{  6118, "emTex Gesellschaft für neue Medien, Telefon- und Audiotex- Dienstleistungen mbH" },
	{  6119, "Vodafone BW GmbH" },
	{  6120, "Mobile Interactive Technology B.V." },
	{  6123, "T-Mobile Netherlands B.V." },
	{  6124, "T-Mobile Netherlands B.V." },
	{  6125, "KPN B.V." },
	{  6126, "ProRail B.V." },
	{  6127, "Globecomm Europe B.V." },
	{  6128, "Telia Finland Oyj" },
	{  6129, "Telia Finland Oyj" },
	{  6130, "Globetel Oy" },
	{  6133, "Telia Finland Oyj" },
	{  6135, "DNA Oyj" },
	{  6138, "Elisa Oyj" },
	{  6139, "DNA Oyj" },
	{  6141, "DNA Oyj" },
	{  6176, "Tata Communications (Canada) ULC" },
	{  6177, "Tata Communications (Canada) ULC" },
	{  6178, "Tata Communications (Canada) ULC" },
	{  6179, "Tata Communications (Canada) ULC" },
	{  6180, "Tata Communications (Canada) ULC" },
	{  6181, "Tata Communications (Canada) ULC" },
	{  6182, "Tata Communications (Canada) ULC" },
	{  6183, "Tata Communications (Canada) ULC" },
	{  6184, "Tata Communications (Canada) ULC" },
	{  6185, "Tata Communications (Canada) ULC" },
	{  6186, "Tata Communications (Canada) ULC" },
	{  6187, "Tata Communications (Canada) ULC" },
	{  6188, "Tata Communications (Canada) ULC" },
	{  6189, "Tata Communications (Canada) ULC" },
	{  6190, "Tata Communications (Canada) ULC" },
	{  6191, "Tata Communications (Canada) ULC" },
	{  6192, "Tata Communications (Canada) ULC" },
	{  6193, "Tata Communications (Canada) ULC" },
	{  6194, "Tata Communications (Canada) ULC" },
	{  6195, "Tata Communications (Canada) ULC" },
	{  6196, "Tata Communications (Canada) ULC" },
	{  6197, "Tata Communications (Canada) ULC" },
	{  6198, "Tata Communications (Canada) ULC" },
	{  6199, "Tata Communications (Canada) ULC" },
	{  6200, "Bell Canada" },
	{  6201, "Bell Canada" },
	{  6202, "Bell Canada" },
	{  6203, "Bell Canada" },
	{  6206, "BC Tel" },
	{  6207, "Telus Communications Inc." },
	{  6208, "Alphanet Telecom Inc." },
	{  6209, "Fonorola" },
	{  6210, "North American Gateway Inc." },
	{  6211, "Telus DMS" },
	{  6212, "Telus DMS" },
	{  6213, "Global One Communications" },
	{  6214, "AIC Asia International Service Corp." },
	{  6215, "Hongkong Telecom Pacific Ltd." },
	{  6216, "Hongkong Telecom Pacific Ltd." },
	{  6217, "Telus DMS" },
	{  6218, "Cescom" },
	{  6219, "Cescom" },
	{  6220, "Cescom" },
	{  6221, "Cescom" },
	{  6222, "Cescom" },
	{  6223, "China Mobile International (Canada) Inc." },
	{  6224, "Telus Communications Inc., London UK" },
	{  6225, "Globalstar Canada Satellite Co." },
	{  6226, "Tata Communications (Canada) ULC" },
	{  6227, "Tata Communications (Canada) ULC" },
	{  6228, "Tata Communications (Canada) ULC" },
	{  6229, "Tata Communications (Canada) ULC" },
	{  6230, "Tata Communications (Canada) ULC" },
	{  6231, "Tata Communications (Canada) ULC" },
	{  6232, "Tata Communications (Canada) ULC" },
	{  6233, "Tata Communications (Canada) ULC" },
	{  6234, "Tata Communications (Canada) ULC" },
	{  6235, "Tata Communications (Canada) ULC" },
	{  6236, "Tata Communications (Canada) ULC" },
	{  6237, "Tata Communications (Canada) ULC" },
	{  6238, "Tata Communications (Canada) ULC" },
	{  6239, "Tata Communications (Canada) ULC" },
	{  6240, "Tata Communications (Canada) ULC" },
	{  6241, "Tata Communications (Canada) ULC" },
	{  6242, "Rogers Cable Communications Incorporated" },
	{  6243, "Phonetime International Inc." },
	{  6245, "Iristel Inc." },
	{  6246, "Bell Mobility" },
	{  6247, "Bell Mobility" },
	{  6272, "France Telecom" },
	{  6280, "JSC Orange Moldova" },
	{  6288, "Tele Greenland" },
	{  6289, "Tele Greenland" },
	{  6290, "Tele Greenland" },
	{  6304, "AT&T" },
	{  6305, "AT&T" },
	{  6306, "Limitless Mobile, LLC" },
	{  6307, "AT&T" },
	{  6308, "AT&T" },
	{  6309, "AT&T" },
	{  6310, "AT&T" },
	{  6311, "AT&T" },
	{  6312, "BT North America" },
	{  6313, "Telnyx, LLC" },
	{  6314, "American International Networks LLC" },
	{  6315, "Midwest Network Solutions Hub, LLC" },
	{  6316, "WorldCom, Inc" },
	{  6317, "WorldCom, Inc" },
	{  6318, "WorldCom, Inc" },
	{  6319, "WorldCom, Inc" },
	{  6320, "Choice Wireless, LC" },
	{  6321, "WorldCom, Inc" },
	{  6322, "WorldCom, Inc" },
	{  6323, "Syniverse Technologies" },
	{  6324, "Syniverse Technologies" },
	{  6325, "Syniverse Technologies" },
	{  6326, "WorldCom, Inc" },
	{  6327, "Limitless Mobile, LLC" },
	{  6328, "AT&T" },
	{  6329, "AT&T" },
	{  6330, "AT&T" },
	{  6331, "AT&T" },
	{  6332, "US Sprint" },
	{  6333, "US Sprint" },
	{  6334, "US Sprint" },
	{  6335, "BT North America" },
	{  6336, "BT North America" },
	{  6337, "BT North America" },
	{  6338, "Syniverse Technologies, Inc." },
	{  6339, "Syniverse Technologies, Inc." },
	{  6340, "US Sprint" },
	{  6341, "Syniverse Technologies, Inc" },
	{  6342, "US Sprint" },
	{  6343, "AT&T" },
	{  6344, "Syniverse Technologies" },
	{  6345, "Syniverse Technologies" },
	{  6346, "Syniverse Technologies" },
	{  6347, "AT&T" },
	{  6348, "AT&T" },
	{  6349, "Verizon Hawaii International Inc" },
	{  6350, "Arbinet-thexchange, Inc" },
	{  6351, "Arbinet-thexchange, Inc" },
	{  6352, "Cable & Wireless, Inc (CWI)" },
	{  6353, "Asia Communications International, Inc" },
	{  6354, "Syniverse Technologies, Inc." },
	{  6355, "Syniverse Technologies, Inc." },
	{  6356, "Syniverse Technologies, Inc" },
	{  6357, "Syniverse Technologies" },
	{  6358, "TLDI" },
	{  6359, "ITC, Inc" },
	{  6360, "ITC, Inc" },
	{  6362, "WDT World Discount Telecommunications Co" },
	{  6363, "China Telecom (Americas) Corporation" },
	{  6364, "TCA Services Corp." },
	{  6365, "Inteliquent, Inc." },
	{  6366, "Inteliquent, Inc." },
	{  6367, "Teleglobe America, Inc" },
	{  6368, "IWL Communications Inc" },
	{  6369, "IWL Communications Inc" },
	{  6370, "Bharti Airtel Limited" },
	{  6371, "Latam Telecommunications, L.L.C." },
	{  6372, "BellSouth International" },
	{  6373, "UniPlex Telecom Technologies, Inc" },
	{  6374, "USTelenet, LLC" },
	{  6375, "TresCom International, Inc" },
	{  6376, "TresCom International, Inc" },
	{  6377, "TresCom International, Inc" },
	{  6378, "TresCom International, Inc" },
	{  6379, "TresCom International, Inc" },
	{  6380, "TresCom International, Inc" },
	{  6381, "Maycan Horizons Inc" },
	{  6382, "American Telesource International Inc" },
	{  6383, "Verisign Inc" },
	{  6384, "NP Telephony" },
	{  6385, "Telecommunications Services, Inc" },
	{  6386, "Telecommunications Services, Inc" },
	{  6387, "Telecommunications Services, Inc" },
	{  6388, "Telecommunications Services, Inc" },
	{  6389, "Telecommunications Services, Inc" },
	{  6390, "Telecommunications Services, Inc" },
	{  6391, "CTC Communications Corp" },
	{  6392, "Telecommunications Services, Inc" },
	{  6393, "PLD Telekom, Inc" },
	{  6394, "New Global Telecom, Inc" },
	{  6395, "Ameritech Global Gateway Services (AGGS)" },
	{  6396, "New Global Telecom, Inc" },
	{  6397, "Startec Global Communications Corporation" },
	{  6398, "Verizon Hawaii International Inc" },
	{  6399, "Verizon Hawaii International Inc" },
	{  6400, "Primus Telecommunications, Inc" },
	{  6401, "Primus Telecommunications, Inc" },
	{  6402, "BT North America" },
	{  6403, "BT North America" },
	{  6404, "WorldCom, Inc" },
	{  6405, "WorldCom, Inc" },
	{  6406, "U.S. Leo Services, Inc" },
	{  6407, "U.S. Leo Services, Inc" },
	{  6408, "U.S. Leo Services, Inc" },
	{  6409, "Bellsouth Carrier Professional Services, Inc (BCPS)" },
	{  6410, "Fusion Telecommunications International, Inc" },
	{  6411, "China Telecom (Americas) Corporation" },
	{  6412, "Mundetel Communications. Inc" },
	{  6413, "Newcom, Inc." },
	{  6414, "Comsat Mobile Communications" },
	{  6415, "Comsat Mobile Communications" },
	{  6416, "Convergia Inc" },
	{  6417, "Globespan Telecommunication LLC" },
	{  6418, "Communication Telesystems International" },
	{  6419, "Communication Telesystems International" },
	{  6420, "Communication Telesystems International" },
	{  6421, "Communication Telesystems International" },
	{  6422, "Switch Tel, Inc" },
	{  6423, "IDT Corporation" },
	{  6424, "IDT Corporation" },
	{  6425, "Intra Global Communications, Inc" },
	{  6426, "Sprint" },
	{  6427, "Sprint" },
	{  6428, "TotalTel" },
	{  6429, "WorldPoint Communications, Inc" },
	{  6430, "WorldPoint Communications, Inc" },
	{  6431, "Telecommunications Services, Inc" },
	{  6432, "Telecommunications Services, Inc" },
	{  6433, "America Movil" },
	{  6434, "America Movil" },
	{  6435, "America Movil" },
	{  6436, "Comsat, Inc." },
	{  6437, "GIGSKY MOBILE, LLC" },
	{  6438, "Eltopia Communications, LLC" },
	{  6439, "Team Telecom Holdings, Inc" },
	{  6440, "AT&T" },
	{  6441, "AT&T" },
	{  6442, "AT&T" },
	{  6443, "AT&T" },
	{  6444, "AT&T" },
	{  6445, "AT&T" },
	{  6446, "SATEL U.S.A. LLC" },
	{  6447, "Inteliquent, Inc." },
	{  6448, "Inteliquent, Inc." },
	{  6449, "Globaltron Communications Corporation" },
	{  6450, "Go2Tel.com, Inc" },
	{  6451, "Graphnet Inc" },
	{  6452, "Graphnet Inc" },
	{  6453, "Go2Tel.com, Inc" },
	{  6454, "Telintel Ltd" },
	{  6455, "MD Telecom, Inc" },
	{  6456, "Worldwide Telecom Services, LLC" },
	{  6457, "Orange Business Services" },
	{  6458, "Orange Business Services" },
	{  6459, "Telemedia International USA Inc" },
	{  6460, "Go2Tel.com, Inc" },
	{  6461, "Go2Tel.com, Inc" },
	{  6462, "Americatel Corporation" },
	{  6463, "Telia North America Inc" },
	{  6464, "IP Telecom Network Corp" },
	{  6465, "Global Telecommunications Services, Inc (d/b/a Global Voicecom Inc.)" },
	{  6466, "Star Telecommunications Inc" },
	{  6467, "Startec Global Communications Corporation" },
	{  6468, "IDT Corporation" },
	{  6469, "E-Z Connections, Inc" },
	{  6470, "Transaction Network Services, Inc." },
	{  6471, "ACC TeleCom" },
	{  6472, "IXC Communications, Inc" },
	{  6473, "Telegroup Inc" },
	{  6474, "Telegroup Inc" },
	{  6475, "GlobalStar International, Inc" },
	{  6476, "Telemedia International USA Inc" },
	{  6477, "KDD America, Inc" },
	{  6478, "Global Quest Communications Ltd" },
	{  6479, "Network Plus Inc" },
	{  6480, "Network Plus Inc" },
	{  6481, "Network Plus Inc" },
	{  6482, "Eltopia Communications, LLC" },
	{  6483, "Bharti Airtel Limited" },
	{  6484, "Five Star Telecom" },
	{  6485, "TeleCommunication Systems, Inc." },
	{  6486, "Cenoplex, Inc." },
	{  6487, "Cenoplex, Inc." },
	{  6488, "Switch Tel, Inc" },
	{  6489, "Meorat Natan LLC d/b/a Universal 400" },
	{  6490, "Global Transmedia Communications Corporation" },
	{  6491, "General Telecom, Inc" },
	{  6492, "General Telecom, Inc" },
	{  6493, "General Telecom, Inc" },
	{  6495, "New Millennium Communications Corporation" },
	{  6496, "New Millennium Communications Corporation" },
	{  6497, "New Millennium Communications Corporation" },
	{  6498, "Telecom North America Mobile, Inc." },
	{  6499, "Justice Technology Corporation" },
	{  6500, "VarTec Telecom, Inc" },
	{  6501, "Digicel Jamaica Limited" },
	{  6502, "North Atlantic Gateway, Inc" },
	{  6503, "Swisscom North America, Inc" },
	{  6504, "Swisscom North America, Inc" },
	{  6505, "WorldCom, Inc" },
	{  6506, "Digicel Jamaica Limited" },
	{  6507, "WorldCom, Inc" },
	{  6508, "Latam Telecommunications, L.L.C." },
	{  6509, "IXC Communications, Inc" },
	{  6510, "Qwest Communications International Corp" },
	{  6511, "Qwest Communications International Corp" },
	{  6512, "Qwest Communications International Corp" },
	{  6513, "Qwest Communications International Corp" },
	{  6514, "Qwest Communications International Corp" },
	{  6515, "Qwest Communications International Corp" },
	{  6516, "Qwest Communications International Corp" },
	{  6517, "Qwest Communications International Corp" },
	{  6518, "Comsat, Inc." },
	{  6519, "Comsat, Inc." },
	{  6520, "Asia Access Telecom, Inc" },
	{  6521, "Dacom America, Inc" },
	{  6522, "Telenor Global Services A.S." },
	{  6523, "Japan Telecom Co., Ltd" },
	{  6524, "International Discount Telecommunication (IDT)" },
	{  6525, "Allied Communication Holdings, LLC" },
	{  6526, "Allied Communication Holdings, LLC" },
	{  6527, "Sita" },
	{  6528, "Sita" },
	{  6529, "Sita" },
	{  6530, "PanAmSat Corporation" },
	{  6532, "TNZI USA LLC" },
	{  6533, "NetNumber, Inc." },
	{  6534, "ABS-CBN Telecom, North America Inc" },
	{  6535, "PCCW Pacific Ltd" },
	{  6536, "Compass Global, Inc" },
	{  6537, "PLDT (US), Ltd" },
	{  6538, "PLDT (US), Ltd" },
	{  6539, "PLDT (US), Ltd" },
	{  6540, "PLDT (US), Ltd" },
	{  6541, "IDT Telecom, Inc" },
	{  6542, "Diamond Link, Inc" },
	{  6543, "Teledirect Telecommunications Group, LLC" },
	{  6544, "Interoute Telecommunications, Inc" },
	{  6545, "KDD America, Inc" },
	{  6546, "Telco 214, Inc" },
	{  6547, "Orange Business Services" },
	{  6548, "Limitless Mobile, LLC" },
	{  6549, "Long Distance International, Inc" },
	{  6550, "Long Distance International, Inc" },
	{  6551, "Long Distance International, Inc" },
	{  6552, "Arktel LLC" },
	{  6554, "Singapore Telecom USA Inc" },
	{  6555, "VarTec Telecom, Inc" },
	{  6556, "WorldPort Communications, Inc" },
	{  6557, "WorldPort Communications, Inc" },
	{  6558, "IXC Communications, Inc" },
	{  6559, "Startec Global Communications Corporation" },
	{  6560, "Startec Global Communications Corporation" },
	{  6561, "Telecom Argentina USA, Inc" },
	{  6562, "TECNet, Inc" },
	{  6563, "TECNet, Inc" },
	{  6564, "ASEAN Telecom, LLC" },
	{  6565, "ASEAN Telecom, LLC" },
	{  6566, "Iusatel USA, Inc" },
	{  6567, "T-Systems North America, Inc" },
	{  6568, "T-Systems North America, Inc" },
	{  6569, "T-Systems North America, Inc" },
	{  6570, "MCI International, Inc" },
	{  6571, "Dial-Around Telecom, Inc" },
	{  6572, "NuLink, Inc" },
	{  6573, "Impsat USA, Inc" },
	{  6574, "Arbinet-thexchange, Inc" },
	{  6575, "Stratos Mobile Networks" },
	{  6576, "Globalstar, Inc." },
	{  6577, "Globalstar, Inc." },
	{  6578, "Globalstar, Inc." },
	{  6579, "TeleCommunication Systems, Inc." },
	{  6580, "TeleCommunication Systems, Inc." },
	{  6581, "Telecommunication Systems, Inc." },
	{  6582, "Iridium LLC" },
	{  6583, "Iridium LLC" },
	{  6584, "Iridium LLC" },
	{  6585, "VGM International" },
	{  6586, "Telecommunication Systems, Inc." },
	{  6587, "VarTec Telecom, Inc" },
	{  6588, "International Telecom, Ltd." },
	{  6589, "WorldPort Communications, Inc" },
	{  6590, "Teldelnort Communication LLC" },
	{  6591, "Savontel Communications" },
	{  6592, "WorldCom, Inc" },
	{  6593, "Innosys Communications, Inc." },
	{  6594, "Galaxy Telesyst Inc" },
	{  6595, "Simple Communications Technologies, Inc" },
	{  6596, "American Alliance Corporation" },
	{  6597, "ATC Teleports, Inc" },
	{  6598, "ATC Teleports, Inc" },
	{  6599, "Tele Danmark USA, Inc" },
	{  6600, "MediaTel Corporation" },
	{  6601, "International Satellite Telecommunications Inc (INSATEL)" },
	{  6602, "Digital Communications Consulting LLC" },
	{  6603, "AT&T" },
	{  6604, "Telecom North America Mobile, Inc." },
	{  6605, "AT&T" },
	{  6606, "Telecom North America Mobile, Inc." },
	{  6607, "Digicel USA, Inc" },
	{  6608, "WorldHub Inc" },
	{  6609, "WorldHub Inc" },
	{  6610, "Justice Technology Corporation" },
	{  6611, "I-21 USA Inc" },
	{  6612, "Arbinet, Inc" },
	{  6613, "AT&T" },
	{  6614, "AT&T" },
	{  6615, "Telecom Argentina USA, Inc" },
	{  6616, "Data Access America Inc" },
	{  6617, "WorldCom, Inc" },
	{  6618, "WorldCom, Inc" },
	{  6619, "ITC, Inc" },
	{  6620, "The Voice Box Corp." },
	{  6622, "Harp Trading Inc." },
	{  6623, "DCB International LLC" },
	{  6624, "Telefonica International Wholesale Services USA, Inc." },
	{  6688, "Marcatel Com, S.A. de C.V." },
	{  6689, "Teléfonos de México, S.A.B. de C.V." },
	{  6690, "Teléfonos de México, S.A.B. de C.V." },
	{  6691, "Marcatel Com, S.A. de C.V." },
	{  6692, "Marcatel Com, S.A. de C.V." },
	{  6693, "Teléfonos de México, S.A.B. de C.V." },
	{  6694, "Teléfonos de México, S.A.B. de C.V." },
	{  6695, "Maxcom Telecomunicaciones, S.A.B. de C.V." },
	{  6696, "Maxcom Telecomunicaciones, S.A.B. de C.V." },
	{  6697, "Teléfonos de México, S.A.B. de C.V." },
	{  6698, "Teléfonos de México, S.A.B. de C.V." },
	{  6699, "Teléfonos de México, S.A.B. de C.V." },
	{  6700, "Teléfonos del Noroeste, S.A. de C.V." },
	{  6701, "Teléfonos de México, S.A.B. de C.V." },
	{  6702, "Teléfonos de México, S.A.B. de C.V." },
	{  6703, "Operbes, S.A. de C.V." },
	{  6704, "Telecomunicaciones de México" },
	{  6705, "Teléfonos de México, S.A.B. de C.V." },
	{  6706, "Teléfonos de México, S.A.B. de C.V." },
	{  6707, "Teléfonos de México, S.A.B. de C.V." },
	{  6708, "Teléfonos de México, S.A.B. de C.V." },
	{  6709, "Teléfonos de México, S.A.B. de C.V." },
	{  6710, "Teléfonos de México, S.A.B. de C.V." },
	{  6711, "Teléfonos de México, S.A.B. de C.V." },
	{  6712, "Teléfonos del Noroeste, S.A. de C.V." },
	{  6713, "Teléfonos de México, S.A.B. de C.V." },
	{  6714, "Teléfonos de México, S.A.B. de C.V." },
	{  6715, "Teléfonos de México, S.A.B. de C.V." },
	{  6716, "Teléfonos de México, S.A.B. de C.V." },
	{  6717, "Teléfonos de México, S.A.B. de C.V." },
	{  6718, "Teléfonos de México, S.A.B. de C.V." },
	{  6719, "Teléfonos de México, S.A.B. de C.V." },
	{  6720, "Avantel, S. de R.L. de C.V." },
	{  6721, "Avantel, S. de R.L. de C.V." },
	{  6722, "Avantel, S. de R.L. de C.V." },
	{  6723, "Avantel, S. de R.L. de C.V." },
	{  6724, "Avantel, S. de R.L. de C.V." },
	{  6725, "Avantel, S. de R.L. de C.V." },
	{  6726, "Avantel, S. de R.L. de C.V." },
	{  6727, "Avantel, S. de R.L. de C.V." },
	{  6728, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6729, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6730, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6731, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6732, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6733, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6734, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6735, "Total Play Telecomunicaciones, S.A. de C.V." },
	{  6736, "Alestra, S. de R.L. de C.V." },
	{  6737, "Alestra, S. de R.L. de C.V." },
	{  6738, "Alestra, S. de R.L. de C.V." },
	{  6739, "Alestra, S. de R.L. de C.V." },
	{  6740, "Alestra, S. de R.L. de C.V." },
	{  6741, "Alestra, S. de R.L. de C.V." },
	{  6742, "Alestra, S. de R.L. de C.V." },
	{  6743, "Alestra, S. de R.L. de C.V." },
	{  6744, "Protel I-Next, S.A. de C.V." },
	{  6745, "Protel I-Next, S.A. de C.V." },
	{  6746, "Protel I-Next, S.A. de C.V." },
	{  6747, "Protel I-Next, S.A. de C.V." },
	{  6748, "Protel I-Next, S.A. de C.V." },
	{  6749, "Protel I-Next, S.A. de C.V." },
	{  6750, "Protel I-Next, S.A. de C.V." },
	{  6751, "Protel I-Next, S.A. de C.V." },
	{  6752, "Cable and Wireless Jamaica Ltd" },
	{  6753, "Cable and Wireless Jamaica Ltd" },
	{  6754, "Cable and Wireless Jamaica Ltd" },
	{  6755, "Cable and Wireless Jamaica Ltd" },
	{  6756, "Cable and Wireless Jamaica Ltd" },
	{  6757, "Cable and Wireless Jamaica Ltd" },
	{  6758, "Mossel Jamaica Ltd" },
	{  6759, "Mossel Jamaica Ltd" },
	{  6760, "Cable and Wireless Jamaica Ltd" },
	{  6761, "Cable and Wireless Jamaica Ltd" },
	{  6762, "Cable and Wireless Jamaica Ltd" },
	{  6763, "Cable and Wireless Jamaica Ltd" },
	{  6764, "Cable and Wireless Jamaica Ltd" },
	{  6765, "Cable and Wireless Jamaica Ltd" },
	{  6766, "Cable and Wireless Jamaica Ltd" },
	{  6770, "Cable and Wireless Jamaica Ltd" },
	{  6771, "Cable and Wireless Jamaica Ltd" },
	{  6772, "Cable and Wireless Jamaica Ltd" },
	{  6773, "Cable and Wireless Jamaica Ltd" },
	{  6774, "Cable and Wireless Jamaica Ltd" },
	{  6775, "Cable and Wireless Jamaica Ltd" },
	{  6776, "Columbus Communications Ltd" },
	{  6778, "Digicel (Jamaica) Ltd" },
	{  6779, "Digicel (Jamaica) Ltd" },
	{  6816, "Cable and Wireless (Barbados) Ltd" },
	{  6817, "Cable and Wireless (Barbados) Ltd" },
	{  6818, "Cable and Wireless (Barbados) Ltd" },
	{  6819, "Cable and Wireless (Barbados) Ltd" },
	{  6820, "Cable and Wireless (Barbados) Ltd" },
	{  6821, "Cable and Wireless (Barbados) Ltd" },
	{  6822, "Cable and Wireless (Barbados) Ltd" },
	{  6823, "Cable and Wireless (Barbados) Ltd" },
	{  6824, "Cable and Wireless (Barbados) Ltd" },
	{  6825, "Cable and Wireless (Barbados) Ltd" },
	{  6826, "Digicel (Barbados)" },
	{  6827, "Cable and Wireless (Barbados) Ltd" },
	{  6828, "TeleBarbados Inc" },
	{  6829, "Antilles Crossing Ltd" },
	{  6830, "Blus Communications Ltd" },
	{  6831, "Ozone Wireless Inc." },
	{  6832, "Sunbeach Inc." },
	{  6833, "Sunbeach Inc." },
	{  6834, "Sunbeach Inc." },
	{  6835, "Access One" },
	{  6836, "Access One" },
	{  6837, "Karib Cable Inc" },
	{  6848, "Cable & Wireless" },
	{  6849, "Digicel" },
	{  6850, "Cable & Wireless" },
	{  6851, "Cable & Wireless" },
	{  6852, "APUA/PCS" },
	{  6853, "APUA/PCS" },
	{  6854, "Cable & Wireless" },
	{  6855, "APUA/PCS" },
	{  6880, "Cable & Wireless" },
	{  6881, "Cable & Wireless" },
	{  6882, "Cable & Wireless" },
	{  6883, "Cable & Wireless" },
	{  6884, "Cable & Wireless" },
	{  6885, "Digicel (Cayman Isl.) Ltd" },
	{  6886, "Wireless Ventures (Cayman Islands) Ltd." },
	{  6889, "Westel Ltd" },
	{  6890, "E-Technologies Cayman Islands Ltd" },
	{  6891, "Infinity Broadband Ltd" },
	{  6892, "WestStar Ltd." },
	{  6912, "Caribbean Cellular Tel. Ltd" },
	{  6913, "Cable & Wireless (BVI) Ltd" },
	{  6914, "Caribbean Cellular Tel. Ltd" },
	{  6916, "Cable & Wireless (BVI) Ltd" },
	{  6917, "Cable & Wireless (BVI) Ltd" },
	{  6918, "Caribbean Cellular Tel. Ltd" },
	{  6919, "Cable & Wireless (BVI) Ltd" },
	{  6920, "Caribbean Cellular Tel. Ltd" },
	{  6921, "Digicel (BVI) Ltd" },
	{  6945, "LinkBermuda (formerly C&W)" },
	{  6946, "LinkBermuda (formerly C&W)" },
	{  6947, "TeleBermuda Ltd. (TBi)" },
	{  6948, "LinkBermuda (formerly C&W)" },
	{  6949, "LinkBermuda (formerly C&W)" },
	{  6976, "Cable & Wireless Grenada" },
	{  6978, "Global Network Providers Grenada" },
	{  6979, "TransWorld Telecommunications Grenada" },
	{  7040, "Cable & Wireless St. Kitts-Nevis" },
	{  7041, "Cariglobe Telecommunications" },
	{  7043, "St. Kitts Cable Communications" },
	{  7073, "Cable & Wireless St. Lucia" },
	{  7074, "Cable & Wireless St. Lucia" },
	{  7075, "Digicel St. Lucia" },
	{  7076, "AT&T Wireless Services St. Lucia" },
	{  7104, "Cable & Wireless St. Vincent" },
	{  7105, "Cable & Wireless St. Vincent" },
	{  7106, "Cable & Wireless St. Vincent" },
	{  7136, "Polycom" },
	{  7137, "Antelecom" },
	{  7138, "Antelecom" },
	{  7139, "Antillean Network Management" },
	{  7140, "Antelecom" },
	{  7141, "Telbo" },
	{  7142, "GSN International Telecom" },
	{  7143, "Smitcoms" },
	{  7144, "Antillean Network Management" },
	{  7145, "Setel" },
	{  7146, "Third Wave Int." },
	{  7147, "Third Wave Int." },
	{  7148, "Polycom" },
	{  7149, "Radcomm" },
	{  7157, "Curacao Cable TV d.b.a. Flow Curacao" },
	{  7159, "Eutel N.V." },
	{  7168, "Bahamas Telecommunications Company Ltd" },
	{  7169, "Bahamas Telecommunications Company Ltd" },
	{  7170, "Bahamas Telecommunications Company Ltd" },
	{  7171, "NEWCO 2015" },
	{  7172, "NEWCO 2015" },
	{  7200, "Cable & Wireless Dominica" },
	{  7201, "Cable & Wireless Dominica" },
	{  7203, "Marpin Telecoms & Broadcasting Co. Ltd." },
	{  7233, "ETECSA" },
	{  7234, "ETECSA" },
	{  7235, "ETECSA" },
	{  7236, "ETECSA" },
	{  7237, "ETECSA" },
	{  7238, "ETECSA" },
	{  7241, "ETECSA" },
	{  7242, "ETECSA" },
	{  7264, "Compañía Dominicana de Teléfonos, C. por A." },
	{  7265, "Compañía Dominicana de Teléfonos, C. por A." },
	{  7266, "Tricom S.A." },
	{  7267, "Tricom S.A." },
	{  7268, "Orange Dominicana, S.A." },
	{  7269, "Tricom S.A." },
	{  7270, "All America Cables & Radio Dominican Republic Inc." },
	{  7271, "All America Cables & Radio Dominican Republic Inc." },
	{  7272, "Orange" },
	{  7273, "Orange" },
	{  7274, "Orange" },
	{  7275, "Orange" },
	{  7276, "Orange" },
	{  7277, "Orange" },
	{  7278, "Codetel" },
	{  7279, "Codetel" },
	{  7296, "Haiti International Telecommuncation S.A. (HAITEL)" },
	{  7297, "Communication Cellulaire d'Haiti S.A. (COMCEL)" },
	{  7298, "Unigestion Holding S.A. (DIGICEL)" },
	{  7299, "Télécommunications d'Haiti S.A.M. (TELECO)" },
	{  7328, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7329, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7330, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7331, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7332, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7333, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7334, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7335, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7336, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7337, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7338, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7339, "Digicel Trinidad and Tobago Ltd" },
	{  7340, "Digicel Trinidad and Tobago Ltd" },
	{  7341, "Digicel Trinidad and Tobago Ltd" },
	{  7342, "Digicel Trinidad and Tobago Ltd" },
	{  7343, "Digicel Trinidad and Tobago Ltd" },
	{  7360, "Cable & Wireless Ltd" },
	{  7361, "Cable & Wireless Ltd" },
	{  7362, "Cable & Wireless Ltd" },
	{  7363, "Cable & Wireless Ltd" },
	{  7364, "Digicel (TCI) Ltd" },
	{  7365, "Cable & Wireless Ltd" },
	{  7366, "Andrew's Communications Ltd" },
	{  7367, "IslandCom Communications Ltd" },
	{  7368, "IslandCom Communications Ltd" },
	{  7369, "IslandCom Communications Ltd" },
	{  7370, "IslandCom Communications Ltd" },
	{  7371, "IslandCom Communications Ltd" },
	{  7372, "IslandCom Communications Ltd" },
	{  7373, "Digicel (TCI) Ltd" },
	{  7374, "Digicel (TCI) Ltd" },
	{  7375, "Digicel (TCI) Ltd" },
	{  7393, "Dauphin Télécom" },
	{  7394, "St. Martin et St. Barthélémy Tel Cell" },
	{  7395, "Dauphin Télécom" },
	{  7396, "Médiaserv" },
	{  7424, "Dauphin Télécom" },
	{  7425, "Outremer Télécom" },
	{  7426, "Dauphin Télécom" },
	{  7456, "Setar N.V." },
	{  7457, "Setar N.V." },
	{  7458, "New Millennium Telecom Services N.V./Digicel Aruba" },
	{  7459, "Setar N.V." },
	{  7460, "DTH Television & Telecommunications N.V./MIO Aruba" },
	{  7462, "Rainbow Internet Services group N.V./Scarlet" },
	{  7488, "Cable and Wireless" },
	{  7489, "Cable and Wireless" },
	{  7490, "Cable and Wireless" },
	{  7491, "Cable and Wireless" },
	{  7492, "Cable and Wireless" },
	{  7493, "Cable and Wireless" },
	{  7494, "Cable and Wireless" },
	{  7495, "Cable and Wireless" },
	{  7520, "Miditel, S.A. de C.V." },
	{  7521, "Teléfonos de México, S.A.B. de C.V." },
	{  7522, "Teléfonos de México, S.A.B. de C.V." },
	{  7523, "Teléfonos de México, S.A.B. de C.V." },
	{  7524, "Teléfonos de México, S.A.B. de C.V." },
	{  7525, "Operbes, S.A. de C.V." },
	{  7526, "Operbes, S.A. de C.V." },
	{  7527, "Grupo de Telecomunicaciones Méxicanas, S.A. de C.V." },
	{  7528, "RSL Com Net de México, S.A. de C.V." },
	{  7529, "RSL Com Net de México, S.A. de C.V." },
	{  7530, "Teléfonos de México, S.A.B. de C.V." },
	{  7531, "Teléfonos de México, S.A.B. de C.V." },
	{  7532, "Teléfonos de México, S.A.B. de C.V." },
	{  7533, "Teléfonos de México, S.A.B. de C.V." },
	{  7534, "Teléfonos de México, S.A.B. de C.V." },
	{  7536, "Qualtel, S.A. de C.V." },
	{  7537, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7538, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7539, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7540, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7541, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7542, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7543, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7544, "AXTEL, S.A.B. de C.V." },
	{  7545, "AXTEL, S.A.B. de C.V." },
	{  7546, "AXTEL, S.A.B. de C.V." },
	{  7547, "AXTEL, S.A.B. de C.V." },
	{  7548, "AXTEL, S.A.B. de C.V." },
	{  7549, "Grupo de Telecomunicaciones Méxicanas, S.A. de C.V." },
	{  7550, "Inversiones Nextel de México, S.A. de C.V." },
	{  7551, "Inversiones Nextel de México, S.A. de C.V." },
	{  7552, "B.Tel, S.A. de C.V." },
	{  7553, "B.Tel, S.A. de C.V." },
	{  7554, "B.Tel, S.A. de C.V." },
	{  7555, "Grupo de Telecomunicaciones Méxicanas, S.A. de C.V." },
	{  7556, "Grupo de Telecomunicaciones Méxicanas, S.A. de C.V." },
	{  7557, "Convergía de México, S.A. de C.V." },
	{  7558, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7559, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7560, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7561, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7562, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7563, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7564, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7565, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7566, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7567, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7568, "Alestra, S. de R.L. de C.V." },
	{  7569, "Alestra, S. de R.L. de C.V." },
	{  7570, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7571, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7572, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7573, "Radiomóvil DIPSA, S.A. de C.V." },
	{  7574, "Alestra, S. de R.L. de C.V." },
	{  7575, "Alestra, S. de R.L. de C.V." },
	{  7576, "Faroese Telecom P/F" },
	{  7577, "Faroese Telecom P/F" },
	{  7578, "Foroya Tele" },
	{  7581, "Kall P/F" },
	{  7582, "Kall P/F" },
	{  7583, "Kall P/F" },
	{  7584, "Lycamobile USA Inc." },
	{  7585, "Quickdial, INC." },
	{  7586, "Lycamobile USA Inc." },
	{  7587, "Belgacom International Carrier Services North America Inc." },
	{  7588, "Telmex International Ventures USA, Inc (DBA Telmex USA)" },
	{  7589, "Telstra Inc" },
	{  7590, "InternationalTalk.com, Inc" },
	{  7591, "InternationalTalk.com, Inc" },
	{  7592, "Telscape International, Inc (DBA TSCP International, Inc.)" },
	{  7593, "Teleglobe America, Inc" },
	{  7594, "Teleglobe America, Inc" },
	{  7595, "Pacific Telekey Network, Inc" },
	{  7596, "Fogg Mobile Inc." },
	{  7597, "Belgacom International Carrier Services North America Inc." },
	{  7598, "Belgacom International Carrier Services North America Inc." },
	{  7599, "Unified Worldwide Transport, LLC" },
	{  7600, "NextCarrier Telecom, Inc" },
	{  7601, "International Access, Inc (d/b/a Access international)" },
	{  7602, "Telefonica International Wholesale Services USA, Inc" },
	{  7603, "AT&T" },
	{  7605, "WorldCom, Inc" },
	{  7606, "Global Connect Partners L.L.C." },
	{  7607, "Telecom New Zealand USA Ltd" },
	{  7608, "Telecom New Zealand USA Ltd" },
	{  7609, "Far East Gateway, Inc" },
	{  7610, "Startec Global Communications Corporation" },
	{  7611, "Startec Global Communications Corporation" },
	{  7613, "AT&T" },
	{  7614, "SK Telink America, Inc" },
	{  7615, "iLine, LLC" },
	{  7616, "Tricom USA, Inc" },
	{  7618, "Orchard Telecom/dba UTS" },
	{  7619, "Global Communication Services, Inc" },
	{  7620, "GTS (UK) Ltd" },
	{  7621, "The Global TeleExchange Inc" },
	{  7622, "AT&T" },
	{  7623, "TMEX USA Inc" },
	{  7624, "InternationalTalk.com, Inc" },
	{  7625, "InternationalTalk.com, Inc" },
	{  7627, "KPN International Network Services Inc" },
	{  7628, "IDS Telcom" },
	{  7630, "Arbinet Communication, Inc" },
	{  7632, "New Global Telecom, Inc" },
	{  7633, "World-Link, Inc" },
	{  7634, "AT&T" },
	{  7635, "World Discount Telecommunications, Inc (WDT)" },
	{  7636, "Deutsche Telekom North America, Inc." },
	{  7637, "iBasis, Inc" },
	{  7638, "iBasis, Inc" },
	{  7639, "Vivavoip, Inc" },
	{  7640, "Global One Communications" },
	{  7641, "Global Connect Partners L.L.C." },
	{  7642, "ITXC Data Transport Services, LLC" },
	{  7643, "Tricom USA, Inc" },
	{  7644, "Integration Services International (ISI)" },
	{  7645, "Sakon, LLC" },
	{  7646, "Wholesale Telecom Corporation" },
	{  7647, "LC Communications" },
	{  7648, "ITC, Inc" },
	{  7649, "IDT Corporation" },
	{  7650, "Telstra Inc" },
	{  7651, "SuperTel Network, Inc" },
	{  7652, "Worldwide Communications Network LLC" },
	{  7653, "Network Communication International Corp" },
	{  7654, "Total Telecom International Inc" },
	{  7656, "Fusion Telecommunications International, Inc" },
	{  7657, "IDT Corporation" },
	{  7658, "Net Telephone Marketing, Inc" },
	{  7659, "Net Telephone Marketing, Inc" },
	{  7660, "AT&T" },
	{  7661, "AT&T" },
	{  7662, "Deutsche Telekom North America, Inc." },
	{  7663, "Ameritech Global Gateway Services (AGGS)" },
	{  7664, "Vertex Group, Inc" },
	{  7665, "Vertex Group, Inc" },
	{  7666, "OneSuite Corporation" },
	{  7667, "OneSuite Corporation" },
	{  7668, "TNZI USA LLC" },
	{  7669, "InterSviaz, Inc" },
	{  7670, "New Global Telecom, Inc" },
	{  7671, "Deutsche Telekom North America, Inc." },
	{  7673, "T-Systems North America, Inc" },
	{  7674, "Global Crossing Telecommunications, Inc" },
	{  7675, "BellSouth International" },
	{  7676, "BellSouth International" },
	{  7677, "Digital Communications Consulting LLC" },
	{  7678, "ComNet (USA) LLC" },
	{  7679, "Telefonica International Wholesale Services USA, Inc" },
	{  7682, "Level 3 Communications, LLC" },
	{  7683, "LD Telecommunications, Inc" },
	{  7684, "IP Deliver" },
	{  7685, "China Telecom (USA) Corporation" },
	{  7686, "Digital Communications Consulting LLC" },
	{  7687, "Reliance Communications, Inc" },
	{  7688, "Reliance Communications, Inc" },
	{  7690, "Orbitel S.A. E.S.P." },
	{  7691, "Orbitel S.A. E.S.P." },
	{  7692, "ComNet (USA) LLC" },
	{  7693, "Novolink Communications Inc" },
	{  7694, "Verisign Inc" },
	{  7695, "Verisign Inc" },
	{  7696, "Digital Communications Consulting LLC" },
	{  7697, "New World Telecom International Inc" },
	{  7698, "China Netcom (USA) Operations Ltd" },
	{  7699, "TSI Telecommunication Services, Inc" },
	{  7700, "Latin Node, Inc" },
	{  7701, "Global Crossing Telecommunications, Inc" },
	{  7702, "Global Crossing Telecommunications, Inc" },
	{  7703, "ComoreTel Holdings Ltd" },
	{  7704, "China Unicom USA Corporation" },
	{  7705, "Telco Group, Inc" },
	{  7706, "NetSat Express Inc" },
	{  7707, "NetNumber, Inc." },
	{  7708, "Ontus Telecommunications Corp" },
	{  7710, "Telecom Argentina USA, Inc" },
	{  7711, "Telmex USA, LLC" },
	{  7712, "American International Networks LLC" },
	{  7713, "Discovery Telecommunications LLC" },
	{  7714, "Reliance Communications, Inc" },
	{  7715, "Reliance Communications, Inc" },
	{  7716, "Telekom Malaysia (USA) Inc" },
	{  7717, "Corisat America Inc" },
	{  7718, "deltathree, Inc." },
	{  7719, "Equant Inc" },
	{  7720, "Reliance Communications, Inc" },
	{  7721, "Reliance Communications, Inc" },
	{  7722, "Teleglobe America, Inc" },
	{  7723, "Teleglobe America, Inc" },
	{  7724, "Jaina Systems Network, Inc" },
	{  7725, "Bridgeport Networks Inc" },
	{  7726, "Carrier PB Telco Inc" },
	{  7727, "IPIP Corp." },
	{  7728, "Telmex USA, LLC" },
	{  7729, "Datek Systems, Inc" },
	{  7730, "3U Telecom Inc" },
	{  7731, "Arbinet-thexchange, Inc" },
	{  7732, "Verisign Inc" },
	{  7733, "Los Angeles InternetExchange" },
	{  7734, "Aicent, Inc" },
	{  7735, "Aicent, Inc" },
	{  7736, "Worldstar Telecom Inc" },
	{  7737, "Touch-Tel USA, L.P." },
	{  7738, "China Unicom USA Corporation" },
	{  7739, "Verizon Business Group" },
	{  7740, "France Telecom Long Distance USA, LLC" },
	{  7741, "Local Fiber, LLC" },
	{  7742, "MD Telecom, Inc" },
	{  7743, "Digicel USA, Inc" },
	{  7744, "Syniverse Technologies, Inc" },
	{  7745, "Trilogy International Enterprises, LLC" },
	{  7746, "Secure IP Telecom, Inc" },
	{  7747, "Syniverse Technologies, Inc" },
	{  7748, "Syniverse Technologies, Inc" },
	{  7749, "Digicel USA, Inc" },
	{  7750, "Secure IP Telecom, Inc" },
	{  7751, "TNZI USA LLC" },
	{  7752, "France Telecom Long Distance USA, LLC" },
	{  7753, "Bharti Airtel Ltd" },
	{  7754, "Syniverse Technologies, Inc" },
	{  7755, "Syniverse Technologies, Inc" },
	{  7756, "Teleglobe America, Inc" },
	{  7757, "Teleglobe America, Inc" },
	{  7758, "Teleglobe America, Inc" },
	{  7759, "Digicel USA, Inc" },
	{  7760, "Verisign Inc" },
	{  7761, "Verisign Inc" },
	{  7762, "Dollar Phone Corp" },
	{  7763, "Iris Wireless, LLC" },
	{  7764, "Iris Wireless, LLC" },
	{  7765, "Iris Wireless, LLC" },
	{  7766, "Telefonica International Wholesale Services USA, Inc" },
	{  7767, "Qwest Communications Corporation" },
	{  7768, "Qwest Communications Corporation" },
	{  7769, "Qwest Communications Corporation" },
	{  7770, "MiNO Wireless USA, Inc" },
	{  7771, "MiNO Wireless USA, Inc" },
	{  7772, "MiNO Wireless USA, Inc" },
	{  7773, "MiNO Wireless USA, Inc" },
	{  7774, "TransPacific Telecom" },
	{  7775, "Telco 214, Inc" },
	{  7776, "Telco 214, Inc" },
	{  7777, "United Hubbing Inc." },
	{  7778, "United Hubbing Inc." },
	{  7779, "BT Americas Inc" },
	{  7780, "Globecomm Network Services Corp." },
	{  7781, "Dba Next Telecommunication Inc" },
	{  7782, "Telecom North America Mobile, Inc." },
	{  7783, "US Cambridge Group LLC" },
	{  7864, "Alestra, S. de R.L. de C.V." },
	{  7968, "Vodafone Albania" },
	{  7969, "Vodafone Albania" },
	{  7970, "Vodafone Albania" },
	{  7971, "Vodafone Albania" },
	{  7972, "PRIMO COMMUNICATIONS" },
	{  7973, "ALBANIA SATELLITE COMMUNICATIONS" },
	{  7974, "ABISSNET" },
	{  7975, "ALBON" },
	{  7976, "CLX Networks AB" },
	{  7977, "CLX Networks AB" },
	{  7978, "CLX Networks AB" },
	{  7979, "CLX Networks AB" },
	{  7980, "MobiWeb Ltd." },
	{  7981, "MobiWeb Ltd." },
	{  7982, "MobiWeb Ltd." },
	{  7983, "Primlight AB" },
	{  7984, "Network Rail Infrastructure Limited" },
	{  7985, "Network Rail Infrastructure Limited" },
	{  7986, "Liquid Telecommunications Limited" },
	{  7987, "Liquid Telecommunications Limited" },
	{  7989, "TNZI UK Ltd" },
	{  7992, "Telecable" },
	{  7993, "Telecable" },
	{  7994, "Net 1" },
	{  7995, "Net Is Sat" },
	{  7997, "Telenor Bulgaria" },
	{  7998, "Telenor Bulgaria" },
	{  7999, "Premium Net International" },
	{  8000, "P1 security" },
	{  8001, "P1 security" },
	{  8002, "NRJ Mobile" },
	{  8003, "NRJ Mobile" },
	{  8004, "M Target" },
	{  8005, "M Target" },
	{  8007, "Orange" },
	{  8008, "ALBtelecom" },
	{  8009, "AMC (Albanian Mobile Communications)" },
	{  8010, "INFO-Telecom" },
	{  8011, "NEOFONE" },
	{  8012, "NISATEL" },
	{  8013, "ABCom" },
	{  8014, "Vodafone Albania" },
	{  8015, "Vodafone Albania" },
	{  8016, "CSC Telecom" },
	{  8017, "Tele2" },
	{  8018, "Tele2" },
	{  8019, "Tele3" },
	{  8020, "Tele4" },
	{  8021, "INTELLICA" },
	{  8022, "Telenova" },
	{  8031, "TelcoVillage GmbH" },
	{  8033, "Verizon UK Ltd" },
	{  8034, "Telekom Malaysia (UK) Limited" },
	{  8035, "EE Limited (Orange)" },
	{  8036, "EE Limited (Orange)" },
	{  8037, "EE Limited (Orange)" },
	{  8038, "EE Limited (Orange)" },
	{  8040, "TNZI UK Ltd" },
	{  8041, "Telefonica UK Limited" },
	{  8042, "Telefonica UK Limited" },
	{  8043, "Telefonica UK Limited" },
	{  8046, "Synectiv Ltd" },
	{  8047, "Synectiv Ltd" },
	{  8048, "Combridge" },
	{  8049, "Telemobil" },
	{  8051, "Cosmote Romanian Mobile Telecommunications" },
	{  8052, "Romtelecom S.A." },
	{  8053, "Romtelecom S.A." },
	{  8054, "Romtelecom S.A." },
	{  8055, "Romtelecom S.A." },
	{  8056, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8057, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8058, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8059, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8060, "ELTA-KABEL d.o.o. Doboj" },
	{  8061, "Telemach d.o.o. Sarajevo" },
	{  8062, "SOFTNET d.o.o. Sarajevo" },
	{  8072, "S" },
	{  8073, "GLOBALTEL d.o.o." },
	{  8074, "S" },
	{  8075, "S" },
	{  8076, "T-Mobile Crna Gora Ltd" },
	{  8077, "MTEL d.o.o. Podgorica" },
	{  8078, "MTEL d.o.o. Podgorica" },
	{  8079, "GSM ProMonte Montenegro" },
	{  8080, "France Telecom España, S.A. Unipersonal" },
	{  8081, "France Telecom España, S.A. Unipersonal" },
	{  8082, "France Telecom España, S.A. Unipersonal" },
	{  8083, "France Telecom España, S.A. Unipersonal" },
	{  8084, "Lleida Networks Serveis Telematics, S.L." },
	{  8086, "Orange Business Spain, S.A." },
	{  8088, "mr. net services GmbH & Co. KG" },
	{  8090, "SKY Telekom AG" },
	{  8091, "Apelby GmbH" },
	{  8092, "Animatele Inc." },
	{  8093, "Telefónica Germany GmbH & Co. OHG" },
	{  8094, "OblCom SWISS AG" },
	{  8095, "TelcoVillage GmbH" },
	{  8096, "Novametro OÜ" },
	{  8100, "GoNetwork OÜ" },
	{  8101, "Tele2 Eesti AS" },
	{  8102, "Elisa Eesti AS" },
	{  8103, "Elisa Eesti AS" },
	{  8104, "Iskon Internet d.d." },
	{  8105, "Iskon Internet d.d." },
	{  8106, "Metronet telekomunikacije d.d." },
	{  8107, "TERRAKOM d.o.o." },
	{  8108, "HT d.d." },
	{  8109, "HT d.d." },
	{  8110, "HT d.d." },
	{  8111, "HT d.d." },
	{  8112, "Jodo telecommunications LTD" },
	{  8113, "GoodWillComm Ltd" },
	{  8114, "Service Net Ltd" },
	{  8115, "Black Sea Telecom Ltd" },
	{  8116, "Mobitel Ltd" },
	{  8117, "Warid Telecom Georgia Ltd" },
	{  8118, "Silknet JSC" },
	{  8119, "Alex Development Georgia Ltd" },
	{  8120, "Tele2" },
	{  8121, "Tellcom" },
	{  8123, "Global" },
	{  8124, "Mega" },
	{  8125, "Borusan" },
	{  8126, "Kocnet" },
	{  8127, "Dogan" },
	{  8128, "Primetel PLC" },
	{  8129, "D.Y. Worldnet Ltd." },
	{  8130, "Cyprus Telecommunications Authority (CYTA)" },
	{  8131, "Cyprus Telecommunications Authority (CYTA)" },
	{  8132, "Cyprus Telecommunications Authority (CYTA)" },
	{  8133, "Cablenet Communication Systems Ltd" },
	{  8134, "MTN Cyprus Limited" },
	{  8135, "MTN Cyprus Limited" },
	{  8136, "MEO (Fixed)" },
	{  8137, "MEO (Fixed)" },
	{  8144, "Telemobil" },
	{  8145, "Telemobil" },
	{  8146, "Vodafone Romania" },
	{  8148, """DA"" Phone Brand" },
	{  8149, "RCS & RDS" },
	{  8150, "Ines Group" },
	{  8151, "Overseas Global Communications" },
	{  8152, "P4 Sp. z o.o." },
	{  8153, "Telekomunikacja Novum S.A." },
	{  8154, "T-MOBILE POLSKA S.A." },
	{  8155, "POLKOMTEL Sp. z o.o." },
	{  8156, "EXATEL S.A." },
	{  8157, "PKP Polskie Linie Kolejowe S.A." },
	{  8158, "PKP Polskie Linie Kolejowe S.A." },
	{  8159, "PKP Polskie Linie Kolejowe S.A." },
	{  8160, "World Telecoms Network Ltd." },
	{  8161, "Telefónica Germany GmbH & Co. OHG" },
	{  8162, "envia.tel GmbH" },
	{  8163, "ITXC Corp." },
	{  8164, "Belcotel GmbH" },
	{  8165, "TelcoVillage GmbH" },
	{  8166, "Televeiling International BV" },
	{  8167, "Vodafone BW GmbH" },
	{  8168, "P4 Sp. z o.o." },
	{  8169, "P4 Sp. z o.o." },
	{  8170, "SFERIA S.A." },
	{  8171, "E-Telko Sp. z o.o." },
	{  8172, "Orange Polska S.A." },
	{  8173, "Orange Polska S.A." },
	{  8174, "P4 Sp. z o.o." },
	{  8175, "TK Telekom Sp. z o.o." },
	{  8176, "VSE Net GmbH" },
	{  8177, "Amet Ltd" },
	{  8178, "mr. net services GmbH & Co. KG" },
	{  8179, "Versatel West GmbH" },
	{  8180, "TelcoVillage GmbH" },
	{  8181, "Telekom Deutschland GmbH" },
	{  8182, "Vintage Wireless Networks" },
	{  8183, "1NCE GmbH" },
	{  8184, "BT (Germany) GmbH & Co. oHG" },
	{  8185, "Telegate AG" },
	{  8186, "Telegate AG" },
	{  8187, "1NCE GmbH" },
	{  8188, "Teleworld International Ltd." },
	{  8189, "3U Holding AG" },
	{  8190, "Televeiling International BV" },
	{  8191, "EMnify GmbH" },
	{  8216, "Barak Ltd" },
	{  8217, "Barak Ltd" },
	{  8218, "Barak Ltd" },
	{  8219, "Barak Ltd" },
	{  8220, "012 Smile" },
	{  8221, "012 Smile" },
	{  8224, "Bezeq International Ltd" },
	{  8225, "Bezeq International Ltd" },
	{  8226, "Golden Lines Ltd" },
	{  8227, "Golden Lines Ltd" },
	{  8228, "Barak Ltd" },
	{  8229, "Barak Ltd" },
	{  8230, "Barak Ltd" },
	{  8231, "Barak Ltd" },
	{  8232, "M/s Reliance Infocom Ltd" },
	{  8233, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8234, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8235, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8236, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8237, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8238, "M/s Reliance Infocom Ltd" },
	{  8239, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8240, "M/s Data Access Ltd" },
	{  8241, "M/s Data Access Ltd" },
	{  8242, "M/s Data Access Ltd" },
	{  8243, "M/s Data Access Ltd" },
	{  8244, "M/s Hutchison Essar South Ltd" },
	{  8245, "M/s Hutchison Essar South Ltd" },
	{  8246, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8247, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8248, "M/s Hutchison Essar South Ltd" },
	{  8249, "M/s Hutchison Essar South Ltd" },
	{  8250, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8251, "M/s Bharti Telesonic Ltd" },
	{  8252, "M/s Bharti Telesonic Ltd" },
	{  8253, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8254, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8255, "M/s Data Access Ltd" },
	{  8256, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8257, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8258, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8259, "M/s Vodafone Essar South Ltd" },
	{  8260, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8261, "M/s Vodafone Essar South Ltd" },
	{  8262, "M/s Vodafone Essar South Ltd" },
	{  8263, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8264, "ICO" },
	{  8265, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8266, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8267, "Iridium" },
	{  8268, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8269, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8270, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8271, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8272, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8273, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8274, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8275, "M/s Reliance Comm. Ltd." },
	{  8276, "M/s Reliance Comm. Ltd." },
	{  8277, "M/s Bharti Telesonic Ltd" },
	{  8278, "M/s Bharti Telesonic Ltd" },
	{  8279, "M/s Reliance Comm. Ltd." },
	{  8280, "M/s Data Access Ltd" },
	{  8281, "M/s Data Access Ltd" },
	{  8282, "M/s Reliance Comm. Ltd." },
	{  8283, "M/s Bharti Telesonic Ltd" },
	{  8284, "M/s Bharti Telesonic Ltd" },
	{  8285, "M/s Data Access Ltd" },
	{  8286, "M/s Data Access Ltd" },
	{  8287, "M/s Data Access Ltd" },
	{  8288, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8289, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8290, "M/s Reliance Comm. Ltd." },
	{  8291, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8292, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8293, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8294, "M/s Hutchison Essar South Ltd" },
	{  8295, "M/s Hutchison Essar South Ltd" },
	{  8296, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8297, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8298, "M/s Reliance Infocomm Ltd" },
	{  8299, "M/s Reliance Infocomm Ltd" },
	{  8300, "M/s Reliance Infocomm Ltd" },
	{  8301, "M/s Reliance Infocomm Ltd" },
	{  8302, "M/s Hutchison Essar South Ltd" },
	{  8303, "M/s Hutchison Essar South Ltd" },
	{  8304, "M/s Dishnet Wireless Ltd" },
	{  8305, "M/s Spice Communications Ltd" },
	{  8306, "M/s P3 Technologies Pvt Ltd" },
	{  8307, "M/s Reliance Communications Ltd" },
	{  8308, "M/s Bharti Airtel Ltd" },
	{  8309, "M/s Bharti Airtel Ltd" },
	{  8310, "M/s Tata Communications Ltd" },
	{  8311, "M/s Tata Communications Ltd" },
	{  8312, "M/s Bharti Airtel Ltd" },
	{  8313, "M/s Tata Communications Ltd" },
	{  8314, "M/s Tata Communications Ltd" },
	{  8315, "M/s Tata Communications Ltd" },
	{  8316, "M/s Vodafone Essar South Ltd" },
	{  8317, "M/s Vodafone Essar South Ltd" },
	{  8318, "M/s Vodafone Essar South Ltd" },
	{  8319, "M/s Tata Communications Ltd" },
	{  8320, "M/s Tata Communications Ltd" },
	{  8321, "M/s Dishnet Wireless Private Limited" },
	{  8322, "M/s Etisalat DB Telecom Private Limited" },
	{  8323, "M/s Etisalat DB Telecom Private Limited" },
	{  8324, "M/s Etisalat DB Telecom Private Limited" },
	{  8325, "M/s Tata Communications Ltd" },
	{  8326, "M/s Etisalat DB Telecom Private Limited" },
	{  8327, "M/s Tata Communications, Delhi" },
	{  8328, "M/s Etisalat DB Telecom Private Limited, Mumbai" },
	{  8329, "M/s Etisalat DB Telecom Private Limited, Chennai" },
	{  8330, "M/s Etisalat DB Telecom Private Limited, Chennai" },
	{  8331, "M/s Tulip Telecom Limited, Mumbai" },
	{  8332, "M/s Dishnet Wireless Private Limited" },
	{  8333, "M/s Dishnet Wireless Private Limited" },
	{  8334, "M/s Spice Communications Ltd" },
	{  8335, "M/s Videocon Telecommunications Ltd." },
	{  8336, "M/s Unitech Communication Private Limited" },
	{  8337, "M/s Tata Communications, Mumbai" },
	{  8338, "M/s Tata Communications, Mumbai" },
	{  8339, "M/s Videocon Telecommunications Ltd." },
	{  8340, "M/s Unitech Communication Private Limited" },
	{  8341, "M/s Citycom Network Pvt. Ltd" },
	{  8352, "M/s Pakistan Telecom Company Ltd" },
	{  8353, "M/s Pakistan Telecom Company Ltd" },
	{  8354, "M/s Pakistan Telecom Company Ltd" },
	{  8355, "M/s Pakistan Telecom Company Ltd" },
	{  8356, "M/s Worldcall Telecom Ltd" },
	{  8357, "M/s Link Direct International (Pvt) Ltd" },
	{  8358, "M/s Telecard Ltd" },
	{  8359, "M/s Special Communications Organization (SCO)" },
	{  8360, "M/s Dancom Pak Pvt Ltd" },
	{  8361, "M/s Wisecom System Pvt Ltd" },
	{  8362, "M/s Warid Telecom Pvt Ltd" },
	{  8363, "M/s Telenor Pak Ltd" },
	{  8364, "M/s Worldcall Telecom Ltd" },
	{  8365, "M/s DV Com Ltd" },
	{  8366, "M/s Telenor Pak Ltd" },
	{  8367, "M/s Redtone Pakistan Pvt Ltd" },
	{  8368, "M/s Link Direct International (Pvt) Ltd" },
	{  8369, "M/s Link Direct International (Pvt) Ltd" },
	{  8370, "M/s Warid Telecom Pvt Ltd" },
	{  8371, "M/s Callmate Telips Telecom Ltd" },
	{  8372, "M/s Circle Nett Communications Pvt Ltd." },
	{  8373, "M/s Burraq Telecom Ltd" },
	{  8374, "M/s DV Com Ltd" },
	{  8375, "M/s Warid Telecom Pvt Ltd" },
	{  8376, "M/s Redtone Pakistan Pvt Ltd" },
	{  8377, "M/s Telecard Ltd" },
	{  8378, "M/s Warid Telecom Pvt Ltd" },
	{  8379, "M/s LinkDirect" },
	{  8380, "M/s DV Com Ltd" },
	{  8381, "M/s CircleNet Comm" },
	{  8382, "M/s 4B Gentel" },
	{  8384, "AWCC" },
	{  8385, "AWCC" },
	{  8386, "AWCC" },
	{  8387, "Afghan Telecom" },
	{  8388, "MTN" },
	{  8389, "MTN" },
	{  8390, "TDCA (dba Roshan)" },
	{  8391, "TDCA (dba Roshan)" },
	{  8392, "TDCA (dba Roshan)" },
	{  8393, "TDCA (dba Roshan)" },
	{  8394, "TDCA (dba Roshan)" },
	{  8395, "AWCC" },
	{  8396, "AWCC" },
	{  8397, "Afghan Telecom" },
	{  8398, "Afghan Telecom" },
	{  8399, "Etisalat International" },
	{  8400, "Sri Lanka Telecom Ltd" },
	{  8401, "Sri Lanka Telecom Ltd" },
	{  8402, "Sri Lanka Telecom Ltd" },
	{  8403, "Sri Lanka Telecom Ltd" },
	{  8404, "Sri Lanka Telecom Ltd" },
	{  8405, "Mobitel (Pvt) Ltd" },
	{  8406, "Tigo Lanka (Pvt) Ltd" },
	{  8407, "Dialog Telecom Plc" },
	{  8408, "United Networks International" },
	{  8409, "VSNL Lanka Ltd" },
	{  8410, "Lanka Bell (Pvt) Ltd" },
	{  8411, "Dialog Telecom Plc" },
	{  8412, "Lanka Bell (Pvt) Ltd" },
	{  8413, "Tigo Lanka (Pvt) Ltd" },
	{  8414, "Suntel Ltd." },
	{  8415, "Dialog Broadband Networks" },
	{  8417, "Myanmar Posts and Telecommunications" },
	{  8418, "Myanmar Posts and Telecommunications" },
	{  8419, "Myanmar Posts and Telecommunications" },
	{  8421, "Myanmar Posts and Telecommunications" },
	{  8422, "Myanmar Posts and Telecommunications" },
	{  8423, "Myanmar Posts and Telecommunications" },
	{  8433, "Ministry of Posts and Telecommunications" },
	{  8434, "Ministry of Posts and Telecommunications" },
	{  8435, "Ministry of Posts and Telecommunications" },
	{  8440, "Umniah" },
	{  8441, "Jordan Mobile Telephone Services Company - Zain" },
	{  8442, "Al-Moakhah for Telecom" },
	{  8443, "Umniah Mobile Company (Umniah)" },
	{  8445, "Jordan Mobile Telephone Services Company - Zain" },
	{  8446, "Jordan Mobile Telephone Services Company - Zain" },
	{  8447, "Jordan Mobile Telephone Services Company - Zain" },
	{  8448, "Fastlink" },
	{  8449, "Jordan Telecommunications Company" },
	{  8450, "Jordan Telecommunications Company" },
	{  8451, "Fastlink" },
	{  8452, "Fastlink" },
	{  8453, "Fastlink" },
	{  8454, "MobileCom" },
	{  8455, "MobileCom" },
	{  8456, "Pella" },
	{  8457, "Jordan Telecommunications Company" },
	{  8458, "Jordan Mobile Telephone Services Company - Zain" },
	{  8459, "Pella" },
	{  8460, "Batelco Jordan" },
	{  8461, "Umniah" },
	{  8463, "Xpress" },
	{  8465, "Syrian Telecommunication Company" },
	{  8466, "Syrian Telecommunication Company" },
	{  8467, "Syriatel" },
	{  8468, "MTN Syria" },
	{  8469, "MTN Syria" },
	{  8470, "Syriatel" },
	{  8480, "ITPC" },
	{  8481, "Asia Cell" },
	{  8482, "Iraquna" },
	{  8483, "Atheer" },
	{  8496, "Ministry of Communications" },
	{  8497, "Ministry of Communications" },
	{  8498, "Ministry of Communications" },
	{  8499, "STC" },
	{  8500, "STC" },
	{  8501, "Zain" },
	{  8502, "Zain" },
	{  8503, "Wataniya" },
	{  8512, "Saudi Telecom Company (STC)" },
	{  8513, "Saudi Telecom Company (STC)" },
	{  8514, "Saudi Telecom Company (STC)" },
	{  8515, "Saudi Telecom Company (STC)" },
	{  8516, "Saudi Telecom Company (STC)" },
	{  8517, "Saudi Telecom Company (STC)" },
	{  8518, "Saudi Telecom Company (STC)" },
	{  8519, "Saudi Telecom Company (STC)" },
	{  8520, "Mobily" },
	{  8521, "Mobily" },
	{  8522, "Mobily" },
	{  8523, "Mobily" },
	{  8524, "Mobily" },
	{  8525, "Mobily" },
	{  8526, "Mobily" },
	{  8527, "Mobily" },
	{  8528, "Yemen International Telecommunications Company" },
	{  8529, "Spacetel Yemen" },
	{  8530, "SABA FON" },
	{  8531, "TeleYemen" },
	{  8532, "TeleYemen" },
	{  8533, "MOT" },
	{  8534, "MOT" },
	{  8535, "MOT" },
	{  8544, "Omantel" },
	{  8545, "Omantel" },
	{  8546, "Nawras" },
	{  8547, "Nawras" },
	{  8548, "Omantel" },
	{  8560, "TeleYemen" },
	{  8561, "TeleYemen" },
	{  8562, "TeleYemen" },
	{  8563, "Hits-Unitel-Y" },
	{  8564, "Hits-Unitel-Y" },
	{  8565, "Y-Telecom" },
	{  8566, "Y-Telecom" },
	{  8567, "Y-Telecom" },
	{  8576, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8577, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8578, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8579, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8580, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8582, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8583, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8584, "Emirates Integrated Telecommunications Company (du)" },
	{  8585, "Emirates Integrated Telecommunications Company (du)" },
	{  8586, "Emirates Integrated Telecommunications Company (du)" },
	{  8587, "Emirates Integrated Telecommunications Company (du)" },
	{  8592, "Internet Zahav" },
	{  8593, "Bezeq International Ltd" },
	{  8594, "Internet Gold - Golden Lines Ltd" },
	{  8595, "Bezeq International Ltd" },
	{  8596, "Barak Ltd" },
	{  8597, "Barak Ltd" },
	{  8598, "Golden Lines Ltd" },
	{  8599, "Golden Lines Ltd" },
	{  8600, "Bezeq International Ltd" },
	{  8601, "Bezeq International Ltd" },
	{  8602, "Partner" },
	{  8603, "Barak Ltd" },
	{  8604, "Bezeq International Ltd" },
	{  8605, "Bezeq International Ltd" },
	{  8606, "Xfone Communications Ltd" },
	{  8607, "Xfone Communications Ltd" },
	{  8608, "Bahrain Telecommunications Company (BATELCO) B.S.C." },
	{  8609, "Bahrain Telecommunications Company (BATELCO) B.S.C." },
	{  8610, "Infonas WLL" },
	{  8611, "Bahrain Telecommunications Company (BATELCO) B.S.C." },
	{  8612, "Nuetel Communications S.P.C." },
	{  8613, "Bahrain Telecommunications Company (BATELCO) B.S.C." },
	{  8614, "Zain Bahrain B.S.C. Closed" },
	{  8615, "Zain Bahrain B.S.C. Closed" },
	{  8617, "Zain Bahrain B.S.C. Closed" },
	{  8618, "stc Bahrain B.S.C. Closed" },
	{  8619, "Etisalcom Bahrain Company WLL" },
	{  8620, "stc Bahrain B.S.C. Closed" },
	{  8621, "stc Bahrain B.S.C. Closed" },
	{  8622, "stc Bahrain B.S.C. Closed" },
	{  8623, "Zain Bahrain B.S.C. Closed" },
	{  8624, "Qatar Telecom (QTEL)" },
	{  8625, "Qatar Telecom (QTEL)" },
	{  8626, "Qatar Telecom (QTEL)" },
	{  8627, "Qatar Telecom (QTEL)" },
	{  8628, "Qatar Telecom (QTEL)" },
	{  8629, "Qatar Telecom (QTEL)" },
	{  8630, "Qatar Telecom (QTEL)" },
	{  8631, "Qatar Telecom (QTEL)" },
	{  8632, "Vodafone Qatar" },
	{  8633, "Vodafone Qatar" },
	{  8641, "MONGOLIA TELECOM COMPANY" },
	{  8642, "UNITEL LLC" },
	{  8644, "UNITEL LLC" },
	{  8647, "G-MOBILE LLC" },
	{  8648, "Nepal Satellite Telecom Pvt. Ltd." },
	{  8649, "Ncell Pvt. Ltd" },
	{  8650, "Ncell Pvt. Ltd" },
	{  8656, "Nepal Doorsanchar Company Ltd." },
	{  8657, "Nepal Doorsanchar Company Ltd." },
	{  8658, "United Telecom Limited" },
	{  8659, "Ncell Pvt. Ltd" },
	{  8660, "Nepal Doorsanchar Company Ltd." },
	{  8661, "C. G. Communications Pvt. Ltd." },
	{  8662, "Nepal Doorsanchar Company Ltd." },
	{  8663, "United Telecom Limited" },
	{  8664, "United Telecom Limited" },
	{  8665, "United Telecom Limited" },
	{  8666, "Nepal Doorsanchar Company Ltd." },
	{  8667, "Ncell Pvt. Ltd" },
	{  8668, "Nepal Doorsanchar Company Ltd." },
	{  8669, "Smart Telecom Pvt. Ltd." },
	{  8670, "Nepal Doorsanchar Company Ltd." },
	{  8671, "Nepal Doorsanchar Company Ltd." },
	{  8672, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8673, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8674, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8675, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8676, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8677, "Emirates Integrated Telecommunications Company (du)" },
	{  8678, "Emirates Integrated Telecommunications Company (du)" },
	{  8679, "Emirates Integrated Telecommunications Company (du)" },
	{  8688, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8689, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8690, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8691, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8692, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8694, "Thuraya Satellite Network" },
	{  8704, "-" },
	{  8705, "TIC" },
	{  8706, "TIC" },
	{  8707, "TIC" },
	{  8708, "-" },
	{  8709, "TIC" },
	{  8710, "TIC" },
	{  8711, "MTN-Irancell" },
	{  8712, "MTN-Irancell" },
	{  8713, "-" },
	{  8714, "-" },
	{  8715, "-" },
	{  8716, "MCI" },
	{  8717, "MCI" },
	{  8718, "RighTel" },
	{  8719, "RighTel" },
	{  8752, "Aztelekom LLC" },
	{  8753, "Aztelekom LLC" },
	{  8754, "Aztelekom LLC" },
	{  8755, "Ministry of Communications and New Technologies of the Nakhchivan Autonomous Republic of Azerbaijan" },
	{  8756, "AzerTelecom LLC" },
	{  8757, "Azercell Telecom LLC" },
	{  8758, "Azercell Telecom LLC" },
	{  8759, "AzerTelecom LLC" },
	{  8760, "Azerfon LLC" },
	{  8761, "Azerfon LLC" },
	{  8762, "Bakcell LLC" },
	{  8763, "Bakcell LLC" },
	{  8764, "AzInTelecom MMC" },
	{  8765, "Aztelekom MMC" },
	{  8766, "Azercell Telecom LLC" },
	{  8767, "Azercell Telecom LLC" },
	{  8768, "Bhutan Telecom Ltd." },
	{  8784, "National Signalling Network Administration, Monitoring and Measurement" },
	{  8785, "JSC Kazakhtelecom" },
	{  8786, "JSC Kazakhtelecom" },
	{  8787, "JSC Kazakhtelecom" },
	{  8788, "GSM Kazakhstan (roaming)" },
	{  8789, "KaR-Tel LLP (roaming)" },
	{  8790, "JSC Altel (roaming)" },
	{  8791, "Mobile Telecom Service LLP network (roaming)" },
	{  8792, "JSC KazTransCom" },
	{  8793, "JSC TransTelecom" },
	{  8794, "Mobile Telecom Service LLP" },
	{  8795, "JSC Arna" },
	{  8796, "Mobile Telecom Service LLP" },
	{  8797, "JSC Astel" },
	{  8798, "JSC Astel" },
	{  8799, "Technical Information Centre LLP" },
	{  8800, "LLP TNS-Plus" },
	{  8801, "Joint Stock Company TransTelecom" },
	{  8802, "Joint Stock Company Arna" },
	{  8803, "LLP TNS-Plus" },
	{  8804, "LLP KazinterCom" },
	{  8805, "LLP TNS-Plus" },
	{  8806, "LLP Technical Information Centre" },
	{  8816, "JSC Kyrgyztelecom" },
	{  8817, "Nur Telecom Ltd" },
	{  8818, "Nur Telecom Ltd" },
	{  8819, "JS Saima Telecom" },
	{  8820, "MeGaCom Ltd" },
	{  8821, "Sky Mobile Ltd" },
	{  8822, "AkTen Ltd" },
	{  8824, "Kyrgyztelecom" },
	{  8825, "JSC Kyrgyztelecom" },
	{  8826, "reserved" },
	{  8827, "reserved" },
	{  8828, "MeGaCom Ltd" },
	{  8829, "reserved" },
	{  8830, "reserved" },
	{  8834, "KDDI Corporation" },
	{  8835, "Colt Technology Services Co., Ltd." },
	{  8836, "CITIC Telecom International Japan Limited" },
	{  8839, "KDDI Corporation" },
	{  8841, "KDDI Corporation" },
	{  8842, "KDDI Corporation" },
	{  8843, "KDDI Corporation" },
	{  8846, "NTT Communications Corporation" },
	{  8847, "NTT Communications Corporation" },
	{  8848, "Saiki-Tech Communication Japan Co. Ltd." },
	{  8849, "Saiki-Tech Communication Japan Co. Ltd." },
	{  8852, "IPS Inc." },
	{  8856, "SoftBank Corp." },
	{  8857, "SoftBank Corp." },
	{  8858, "SoftBank Corp." },
	{  8859, "NTT Communications Corporation" },
	{  8860, "RSLCom Japan K.K." },
	{  8861, "RSLCom Japan K.K." },
	{  8863, "Rakuten Mobile, Inc." },
	{  8864, "Rakuten Mobile, Inc." },
	{  8865, "Rakuten Mobile, Inc." },
	{  8866, "Rakuten Mobile, Inc." },
	{  8867, "Brastel Company Ltd." },
	{  8868, "Brastel Company Ltd." },
	{  8869, "SoftBank Corp." },
	{  8870, "SoftBank Corp." },
	{  8871, "Colt Technology Services Co., Ltd." },
	{  8872, "SoftBank Corp." },
	{  8873, "SoftBank Corp." },
	{  8874, "SoftBank Corp." },
	{  8875, "IPS Inc." },
	{  8877, "NTT Communications Corporation" },
	{  8879, "Cignal Telecommunications Japan K.K." },
	{  8882, "KDDI Corporation" },
	{  8883, "KDDI Corporation" },
	{  8884, "KDDI Corporation" },
	{  8885, "KDDI Corporation" },
	{  8886, "NTT Communications Corporation" },
	{  8887, "NTT Communications Corporation" },
	{  8888, "SoftBank Corp." },
	{  8889, "SoftBank Corp." },
	{  8890, "KDDI Corporation" },
	{  8891, "KDDI Corporation" },
	{  8892, "KDDI Corporation" },
	{  8893, "KDDI Corporation" },
	{  8894, "KDDI Corporation" },
	{  8895, "KDDI Corporation" },
	{  8896, "Zain Bahrain B.S.C. Closed" },
	{  8897, "Zain Bahrain B.S.C. Closed" },
	{  8898, "Zain Bahrain B.S.C. Closed" },
	{  8899, "Zain Bahrain B.S.C. Closed" },
	{  8900, "IMC Telecom" },
	{  8901, "IMC Telecom" },
	{  8903, "Zain Bahrain B.S.C. Closed" },
	{  8904, "Zain Bahrain B.S.C. Closed" },
	{  8905, "stc Bahrain B.S.C. Closed" },
	{  8906, "stc Bahrain B.S.C. Closed" },
	{  8912, "NTT DOCOMO, INC." },
	{  8913, "NTT DOCOMO, INC." },
	{  8914, "NTT Communications Corporation" },
	{  8915, "NTT Communications Corporation" },
	{  8916, "KDDI Corporation" },
	{  8917, "KDDI Corporation" },
	{  8918, "Internet Initiative Japan Inc." },
	{  8919, "Internet Initiative Japan Inc." },
	{  8992, "Korea Telecom" },
	{  8993, "Korea Telecom" },
	{  8994, "Korea Telecom" },
	{  8995, "Korea Telecom" },
	{  8996, "Korea Telecom" },
	{  8997, "Korea Telecom" },
	{  8998, "Korea Telecom" },
	{  8999, "Korea Telecom" },
	{  9000, "Dacom" },
	{  9001, "Dacom" },
	{  9002, "Dacom" },
	{  9003, "Dacom" },
	{  9004, "Dacom" },
	{  9005, "Dacom" },
	{  9006, "Dacom" },
	{  9007, "Dacom" },
	{  9016, "Vietel" },
	{  9017, "FPT" },
	{  9019, "Saigon Postel Corporation (SPT)" },
	{  9020, "Vietel" },
	{  9021, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9022, "Vietel" },
	{  9023, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9024, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9025, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9026, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9027, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9028, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9029, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9030, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9031, "Vietel" },
	{  9032, "Orange Business Services Hong Kong Limited" },
	{  9033, "Singapore Telecom Hong Kong Ltd" },
	{  9034, "Wharf T&T Ltd" },
	{  9035, "Hutchison Global Communications Ltd" },
	{  9036, "CITIC Telecom International Ltd" },
	{  9037, "Hutchison Telephone Company Ltd" },
	{  9038, "Verizon Hong Kong Ltd" },
	{  9039, "Wharf T&T Ltd" },
	{  9040, "Hong Kong Broadband Network Ltd" },
	{  9041, "Hutchison Global Communications Ltd" },
	{  9042, "KDDI Hong Kong Ltd" },
	{  9043, "HKBN Enterprise Solutions Limited" },
	{  9044, "HKBN Enterprise Solutions Limited" },
	{  9045, "Hong Kong Telecommunications (HKT) Ltd" },
	{  9046, "PCCW Global (HK) Ltd" },
	{  9047, "Sim2Travel (HK) Ltd" },
	{  9048, "Hong Kong Telecommunications (HKT) Ltd" },
	{  9049, "Hong Kong Telecommunications (HKT) Ltd" },
	{  9050, "Hong Kong Broadband Network Ltd" },
	{  9051, "Global Crossing Hong Kong Ltd" },
	{  9052, "SmarTone Mobile Communications Ltd" },
	{  9053, "China Unicom (Hong Kong) Operations Ltd" },
	{  9054, "Lucky Tone Communications Ltd" },
	{  9055, "China Unicom (Hong Kong) Operations Ltd" },
	{  9056, "Reach Networks Hong Kong Ltd and Reach Cable Networks Ltd" },
	{  9057, "Reach Networks Hong Kong Ltd and Reach Cable Networks Ltd" },
	{  9058, "Reach Networks Hong Kong Ltd and Reach Cable Networks Ltd" },
	{  9059, "Reach Networks Hong Kong Ltd and Reach Cable Networks Ltd" },
	{  9060, "PCCW Global (HK) Ltd" },
	{  9061, "PCCW Global (HK) Ltd" },
	{  9062, "Hong Kong Telecommunications (HKT) Ltd" },
	{  9063, "Hong Kong Telecommunications (HKT) Ltd" },
	{  9064, "Telekomunikasi Indonesia International (Hong Kong) Ltd" },
	{  9065, "China Unicom (Hong Kong) Operations Ltd" },
	{  9066, "PCCW Global (HK) Ltd" },
	{  9067, "Wharf T&T Ltd" },
	{  9068, "PCCW Global (HK) Ltd" },
	{  9069, "Donghwa Telecom Co. Ltd" },
	{  9070, "Centrex Telecom Co. Ltd" },
	{  9071, "Verizon Hong Kong Ltd" },
	{  9072, "Hutchison – Telefone (Macau), Limitada" },
	{  9073, "Companhia de Telecomunicações de Macau, S.A.R.L." },
	{  9074, "Companhia de Telecomunicações de Macau, S.A.R.L." },
	{  9075, "Companhia de Telecomunicações de Macau, S.A.R.L." },
	{  9076, "SmarTone - Comunicações Móveis, S.A." },
	{  9077, "Hutchison – Telefone (Macau), Limitada" },
	{  9078, "China Telecom (Macau) Limitada" },
	{  9079, "Companhia de Telecomunicações de Macau, S.A.R.L." },
	{  9080, "1582HK Ltd" },
	{  9081, "GTI (HK) Ltd" },
	{  9082, "China Unicom (Hong Kong) Operations Ltd" },
	{  9083, "China-Hongkong Telecom Ltd" },
	{  9085, "Telekom Malaysia (Hong Kong) Ltd" },
	{  9086, "Cable & Wireless Global Network (HK) Ltd" },
	{  9087, "China Mobile Hong Kong Co Ltd" },
	{  9088, "Telecom Cambodia" },
	{  9089, "Telecom Cambodia" },
	{  9090, "Royal Telecom International (RTI1)" },
	{  9091, "Royal Telecom International (RTI2)" },
	{  9093, "Royal Telecom International (RTI)" },
	{  9094, "Royal Telecom International (RTI)" },
	{  9095, "Telcotech Gateway" },
	{  9097, "Viettel Company (VTC)" },
	{  9104, "Enterprise of Telecommunications Lao" },
	{  9109, "Lao Asia Telecom State Enterprise (LAT)" },
	{  9110, "Sky Telecom Co., Ltd" },
	{  9144, "SmarTone - Comunicações Móveis, S.A." },
	{  9145, "Companhia de Telecomunicações de Mtel, Limitada" },
	{  9146, "Companhia de Telecomunicações de Mtel, Limitada" },
	{  9147, "SmarTone - Comunicações Móveis, S.A." },
	{  9152, "China Unicom" },
	{  9153, "China Unicom" },
	{  9154, "China Unicom" },
	{  9155, "China Telecom" },
	{  9156, "China Telecom" },
	{  9157, "China Telecom" },
	{  9158, "China Telecom" },
	{  9159, "China Telecom" },
	{  9160, "China Telecom" },
	{  9161, "China Unicom" },
	{  9162, "China Telecom" },
	{  9163, "China Telecom" },
	{  9164, "China Telecom" },
	{  9165, "China Telecom" },
	{  9166, "China Unicom" },
	{  9167, "China Telecom" },
	{  9168, "China Unicom" },
	{  9169, "China Unicom" },
	{  9170, "China Unicom" },
	{  9171, "China Telecom" },
	{  9172, "China Telecom" },
	{  9173, "China Telecom" },
	{  9174, "China Telecom" },
	{  9175, "China Unicom" },
	{  9176, "China Unicom" },
	{  9177, "China Unicom" },
	{  9178, "China Unicom" },
	{  9179, "China Unicom" },
	{  9180, "China Unicom" },
	{  9181, "China Unicom" },
	{  9182, "China Unicom" },
	{  9183, "China Unicom" },
	{  9184, "China Telecom" },
	{  9185, "China Unicom" },
	{  9186, "China Unicom" },
	{  9187, "China Unicom" },
	{  9188, "China Unicom" },
	{  9189, "China Unicom" },
	{  9190, "China Unicom" },
	{  9191, "China Unicom" },
	{  9192, "Beijing marine communications and navigation company" },
	{  9193, "Beijing marine communications and navigation company" },
	{  9194, "China Mobile" },
	{  9195, "China Mobile" },
	{  9196, "China Mobile" },
	{  9197, "China Mobile" },
	{  9198, "China Mobile" },
	{  9199, "China Telecom" },
	{  9200, "China Telecom" },
	{  9201, "China Mobile" },
	{  9202, "China Mobile" },
	{  9203, "China Mobile" },
	{  9204, "China Mobile" },
	{  9205, "China Tietong" },
	{  9206, "China Mobile" },
	{  9207, "China Telecom" },
	{  9208, "China Telecom" },
	{  9209, "China Telecom" },
	{  9210, "China Telecom" },
	{  9211, "China Telecom" },
	{  9212, "China Telecom" },
	{  9213, "China Telecom" },
	{  9214, "China Telecom" },
	{  9215, "China Mobile" },
	{  9216, "China Mobile" },
	{  9217, "China Mobile" },
	{  9218, "China Mobile" },
	{  9219, "China Mobile" },
	{  9220, "China Mobile" },
	{  9221, "China Telecom" },
	{  9222, "China Telecom" },
	{  9223, "China Telecom" },
	{  9224, "China Unicom" },
	{  9225, "China Unicom" },
	{  9226, "China Unicom" },
	{  9227, "China Unicom" },
	{  9228, "China Unicom" },
	{  9229, "China Unicom" },
	{  9280, "AWCC" },
	{  9281, "AWCC" },
	{  9282, "AWCC" },
	{  9283, "TDCA (dba Roshan)" },
	{  9284, "TDCA (dba Roshan)" },
	{  9285, "TDCA (dba Roshan)" },
	{  9286, "TDCA (dba Roshan)" },
	{  9287, "TDCA (dba Roshan)" },
	{  9288, "Etisalat" },
	{  9289, "Etisalat" },
	{  9290, "Etisalat" },
	{  9291, "Etisalat" },
	{  9292, "Etisalat" },
	{  9293, "Etisalat" },
	{  9294, "Etisalat" },
	{  9295, "Etisalat" },
	{  9296, "MTN" },
	{  9297, "MTN" },
	{  9298, "MTN" },
	{  9299, "AWCC" },
	{  9300, "AWCC" },
	{  9304, "DBL Telecom Limited" },
	{  9305, "1Asia Alliance Gateway Limited" },
	{  9306, "Mos5 Tel Limited" },
	{  9307, "Cel Telecom Limited" },
	{  9308, "BG Tel Limited" },
	{  9309, "Apple Global Tel Communications Limited" },
	{  9310, "Global Voice Telecom Limited" },
	{  9311, "VenusTelecom Limited" },
	{  9312, "Telex Limited" },
	{  9313, "Sheba Telecom (Pvt.) Limited" },
	{  9314, "Bangladesh Telegraph and Telephone Board" },
	{  9315, "Bangladesh Telegraph and Telephone Board" },
	{  9316, "Bangladesh Telegraph and Telephone Board" },
	{  9317, "Bangladesh Telegraph and Telephone Board" },
	{  9318, "Grameen Phone Limited" },
	{  9319, "TM International (Bangladesh) Limited" },
	{  9320, "Bangla Tel Limited" },
	{  9321, "Bangladesh Telegraph and Telephone Board" },
	{  9322, "Bangladesh Telegraph and Telephone Board" },
	{  9323, "Warid Telecom International L.L.C" },
	{  9324, "Warid Telecom International L.L.C" },
	{  9325, "Grameen Phone Limited" },
	{  9326, "Pacific Bangladesh Telecom Limited (PBTL)" },
	{  9327, "Teletalk Bangladesh Ltd" },
	{  9328, "Roots Communication Ltd." },
	{  9329, "Banglatrac Communication Ltd" },
	{  9330, "Novotel Limited" },
	{  9331, "Mir Telecom" },
	{  9332, "Banglatrac Communication Ltd" },
	{  9333, "Grameen Phone Limited" },
	{  9334, "Mir Telecom" },
	{  9335, "HRC Technologies Limited" },
	{  9336, "Ratul Telecom Limited" },
	{  9337, "Ranks Telecom Limited" },
	{  9338, "SM Communication Limited" },
	{  9339, "Vision Tel Limited" },
	{  9340, "Digicon Telecommunication Limited" },
	{  9341, "Unique Infoway Limited" },
	{  9342, "Teletalk Bangladesh Ltd" },
	{  9343, "First Communications Limited" },
	{  9345, "Dhiraagu" },
	{  9346, "Dhiraagu" },
	{  9347, "Wataniya Telecom Maldives" },
	{  9348, "Dhiraagu" },
	{  9349, "Wataniya Telecom Maldives" },
	{  9350, "Dhiraagu" },
	{  9351, "Dhiraagu" },
	{  9352, "SK Telecom" },
	{  9353, "KT Powertel" },
	{  9354, "KT Powertel" },
	{  9355, "KT Powertel" },
	{  9356, "KT Powertel" },
	{  9357, "KT Powertel" },
	{  9358, "KT Powertel" },
	{  9359, "KT Powertel" },
	{  9368, "Unitel" },
	{  9369, "HK Telecom" },
	{  9370, "Serome" },
	{  9371, "SK Tellink" },
	{  9372, "HIT" },
	{  9373, "Daewoo Information Systems" },
	{  9374, "HK Telecom" },
	{  9375, "HK Telecom" },
	{  9376, "Hyundai Telecom" },
	{  9377, "Onetel" },
	{  9378, "Onetel" },
	{  9379, "Naray Telecom" },
	{  9380, "Asia Telecom" },
	{  9381, "Korea International Telephone" },
	{  9382, "ICN Telecom" },
	{  9383, "Hanhwa" },
	{  9384, "Unitel" },
	{  9385, "InfoTel" },
	{  9386, "KT Networks" },
	{  9387, "HappyTelecom" },
	{  9388, "Inet Telecom" },
	{  9389, "Dizzocom" },
	{  9390, "Prism Communications" },
	{  9391, "Songa Telecom" },
	{  9392, "SK Tellink" },
	{  9393, "CPS Technology" },
	{  9394, "Dizzocom" },
	{  9395, "KTT" },
	{  9396, "GS Retail" },
	{  9397, "GNG Telecom" },
	{  9398, "M-Touch" },
	{  9399, "KT freetel" },
	{  9400, "ENTel" },
	{  9401, "Serome" },
	{  9402, "MCI Worldcom Korea" },
	{  9403, "Telinker" },
	{  9404, "SK Tellink" },
	{  9405, "Enterprise Networks" },
	{  9406, "Enterprise Networks" },
	{  9407, "Enterprise Networks" },
	{  9408, "CPS Telecom" },
	{  9409, "CPS Telecom" },
	{  9410, "CPS Telecom" },
	{  9411, "CPS Telecom" },
	{  9412, "CPS Telecom" },
	{  9413, "CPS Telecom" },
	{  9414, "CPS Telecom" },
	{  9415, "CPS Telecom" },
	{  9416, "Hanaro Telecom" },
	{  9417, "Hanaro Telecom" },
	{  9418, "Hanaro Telecom" },
	{  9419, "Hanaro Telecom" },
	{  9420, "Hanaro Telecom" },
	{  9421, "Hanaro Telecom" },
	{  9422, "Hanaro Telecom" },
	{  9423, "Hanaro Telecom" },
	{  9424, "SK Networks" },
	{  9425, "SK Networks" },
	{  9426, "SK Networks" },
	{  9427, "SK Networks" },
	{  9428, "Dreamline" },
	{  9429, "Dreamline" },
	{  9430, "Dreamline" },
	{  9431, "Dreamline" },
	{  9448, "Tajiktelecom" },
	{  9449, "Tajiktelecom" },
	{  9450, "Telecom Technology" },
	{  9451, "Babillon-T" },
	{  9452, "Babillon-T" },
	{  9453, "Servis Svyaz Komplect" },
	{  9454, "Servis Svyaz Komplect" },
	{  9455, "Somoncom" },
	{  9456, "Somoncom" },
	{  9457, "Tacom" },
	{  9458, "Tacom" },
	{  9459, "Indigo Tajikistan" },
	{  9460, "Indigo Tajikistan" },
	{  9461, "TT-mobile" },
	{  9462, "TT-mobile" },
	{  9463, "Telecom Technology" },
	{  9473, "Turkmentelecom" },
	{  9505, "UzInter Telecom (JSC Uzintel)" },
	{  9506, "UzInter Telecom (JSC Uzintel)" },
	{  9507, "UzInter Telecom (JSC Uzintel)" },
	{  9600, "China Mobile International Ltd" },
	{  9601, "CITIC Telecom International Ltd" },
	{  9602, "China Virtual (Hong Kong) Ltd" },
	{  9603, "M800 Ltd" },
	{  9604, "CITIC Telecom International Ltd" },
	{  9605, "CITIC Telecom International Ltd" },
	{  9606, "M800 Ltd" },
	{  9607, "Qwest Hong Kong Telecommunications Ltd" },
	{  9608, "HK Langsen International Communication Ltd" },
	{  9609, "CITIC Telecom International Ltd" },
	{  9610, "Hong Kong Broadband Network Ltd" },
	{  9611, "Frontier Network Technology Ltd" },
	{  9612, "ComNet Telecom International Limited" },
	{  9613, "Magitelecom Ltd" },
	{  9614, "Digital Pacific Ltd" },
	{  9615, "IDD 1628 Ltd" },
	{  9616, "China Mobile International Ltd" },
	{  9617, "ComNet Telecom (HK) Limited" },
	{  9618, "Syniverse Technologies (China) Ltd" },
	{  9619, "CITIC Telecom International Ltd" },
	{  9620, "Hong Kong Telecommunications (HKT) Ltd" },
	{  9621, "CTM (HK) Ltd" },
	{  9622, "Telenor Global Services Hong Kong Limited" },
	{  9623, "APT Telecom Services Ltd" },
	{  9624, "CITIC Telecom International Ltd" },
	{  9625, "CITIC Telecom International Ltd" },
	{  9626, "China Tietong HongKong Telecom Company Ltd" },
	{  9627, "IDT Telecom Asia Pacific Ltd" },
	{  9628, "China Tietong HongKong Telecom Co. Ltd." },
	{  9629, "HKC Network Ltd" },
	{  9630, "CITIC Telecom International Ltd" },
	{  9631, "M800 Ltd" },
	{  9632, "EC Telecom Ltd" },
	{  9633, "Telekom Malaysia (Hong Kong) Ltd" },
	{  9634, "Pacific IDD Ltd" },
	{  9635, "South China Telecommunications (HK) Ltd." },
	{  9636, "Hutchison Global Communications Ltd" },
	{  9637, "Systech Telecom Ltd" },
	{  9638, "NTT Com Asia Ltd" },
	{  9639, "HKBN Enterprise Solutions Limited" },
	{  9640, "Syniverse Technologies (China) Ltd" },
	{  9641, "China Mobile Hong Kong Co Ltd" },
	{  9642, "HKBN Enterprise Solutions Limited" },
	{  9644, "China Virtual (Hong Kong) Ltd" },
	{  9645, "M800 Ltd" },
	{  9648, "Maruma Networks Ltd" },
	{  9649, "SmarTone Mobile Communications Ltd" },
	{  9650, "CITIC Telecom International Ltd" },
	{  9651, "iBasis (Hong Kong) Ltd" },
	{  9652, "IDT Telecom Asia Pacific Ltd" },
	{  9653, "China Mobile International Ltd" },
	{  9654, "China Mobile International Ltd" },
	{  9655, "PLDT (HK) Ltd" },
	{  9656, "Hutchison Global Communications Ltd" },
	{  9657, "Hutchison Global Communications Ltd" },
	{  9658, "Telewhite (HK) Ltd" },
	{  9659, "China Telecom Global Limited" },
	{  9660, "China Telecom Global Limited" },
	{  9661, "Tilia Limited" },
	{  9662, "CMMobile Global Communications Ltd" },
	{  9663, "China Mobile International Ltd" },
	{  9664, "China Mobile International Ltd" },
	{  9665, "China Telecom Global Limited" },
	{  9666, "China Telecom Global Limited" },
	{  9667, "China Telecom Global Limited" },
	{  9668, "China Telecom Global Limited" },
	{  9712, "Dialog Telecom Plc" },
	{  9713, "Dialog Telecom Plc" },
	{  9714, "Mobitel (Pvt) Ltd" },
	{  9715, "Airtel Lanka Ltd" },
	{  9716, "TATA Communication Lanka Ltd" },
	{  9717, "Hutchison Telecommunication Ltd" },
	{  9718, "Etisalat Lanka (vt) Ltd" },
	{  9719, "Etisalat Lanka (vt) Ltd" },
	{  9752, "Umniah Mobile Company (Umniah)" },
	{  9754, "Umniah Mobile Company (Umniah)" },
	{  9755, "Umniah Mobile Company (Umniah)" },
	{  9792, "MOC Ministry of Communications" },
	{  9793, "MOC Ministry of Communications" },
	{  9794, "MOC Ministry of Communications" },
	{  9832, "Gtel" },
	{  9833, "Gtel" },
	{  9834, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9835, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9836, "Mobifone-VMS" },
	{  9837, "Mobifone-VMS" },
	{  9838, "Mobifone-VMS" },
	{  9839, "Mobifone-VMS" },
	{  9992, "Myanmar National Tele & Communication Co.,Ltd" },
	{  9993, "Myanmar National Tele & Communication Co.,Ltd" },
	{  9994, "Myanmar National Tele & Communication Co.,Ltd" },
	{  9995, "Myanmar National Tele & Communication Co.,Ltd" },
	{ 10000, "Telenor Myanmar Limited" },
	{ 10001, "Telenor Myanmar Limited" },
	{ 10002, "Telenor Myanmar Limited" },
	{ 10003, "Telenor Myanmar Limited" },
	{ 10004, "Ooredoo Myanmar Limited" },
	{ 10005, "Ooredoo Myanmar Limited" },
	{ 10006, "Ooredoo Myanmar Limited" },
	{ 10007, "Ooredoo Myanmar Limited" },
	{ 10008, "FBD" },
	{ 10009, "SELCOM SHPK" },
	{ 10016, "Free" },
	{ 10017, "Free" },
	{ 10018, "Completel" },
	{ 10019, "Completel" },
	{ 10020, "Bouygues Telecom" },
	{ 10021, "Bouygues Telecom" },
	{ 10022, "Bouygues Telecom" },
	{ 10024, "Limitless Mobile Ltd" },
	{ 10025, "TNZI UK Ltd" },
	{ 10026, "Zamir Telecom Limited" },
	{ 10027, "Bharti Airtel UK Limited" },
	{ 10028, "Interoute Networks Limited" },
	{ 10029, "Interoute Networks Limited" },
	{ 10030, "Truphone Ltd" },
	{ 10032, "Voiceworks B.V." },
	{ 10033, "Voiceworks B.V." },
	{ 10034, "Truphone B.V." },
	{ 10035, "Truphone B.V." },
	{ 10036, "Truphone B.V." },
	{ 10037, "Truphone B.V." },
	{ 10038, "iBasis Netherlands B.V." },
	{ 10039, "Teleena Holding B.V." },
	{ 10048, "Telemach d.o.o." },
	{ 10049, "Slovenske železnice - infrastruktura d.o.o" },
	{ 10050, "Slovenske železnice - infrastruktura d.o.o." },
	{ 10051, "Slovenske železnice - infrastruktura d.o.o." },
	{ 10052, "AKTON Telekomunikacijski inženiring d.o.o." },
	{ 10056, "UCOM" },
	{ 10057, "GRIAR TELECOM" },
	{ 10058, "GNC Alfa" },
	{ 10064, "AMD TELECOM" },
	{ 10065, "COSMOTE" },
	{ 10066, "VODAFONE-PANAFON" },
	{ 10067, "VODAFONE-PANAFON" },
	{ 10072, "KPN SPAIN,S.L. UNIPERSONAL" },
	{ 10073, "KPN SPAIN,S.L. UNIPERSONAL" },
	{ 10076, "COLT TECHNOLOGY SERVICES,S.A. UNIPERSONAL" },
	{ 10077, "Telefónica de España, S.A.U." },
	{ 10078, "Telefónica de España, S.A.U." },
	{ 10080, "UAB Omnitel" },
	{ 10081, "UAB Telco Consulting Group" },
	{ 10082, "UAB EcoFon" },
	{ 10083, "UAB EcoFon" },
	{ 10084, "UAB Omnitel" },
	{ 10085, "AB Lietuvos gelezinkelial" },
	{ 10086, "UAB Omnitel" },
	{ 10087, "UAB Omnitel" },
	{ 10088, "Sotus" },
	{ 10089, "Sotus" },
	{ 10090, "IT Baltija" },
	{ 10091, "Stream Networks" },
	{ 10092, "Telia Latvija" },
	{ 10093, "Telegrupa Baltija" },
	{ 10094, "Telegrupa Baltija" },
	{ 10095, "TG Transit" },
	{ 10096, "BT NEDERLAND N.V." },
	{ 10097, "iBasis Netherlands B.V." },
	{ 10098, "AT&T Global Network Services Nederland B.V." },
	{ 10099, "Ziggo B.V." },
	{ 10100, "Ziggo B.V." },
	{ 10101, "Ziggo B.V." },
	{ 10102, "Ziggo B.V." },
	{ 10103, "iBasis Netherlands B.V." },
	{ 10104, "Mundio Mobile (Denmark) Limited" },
	{ 10105, "Mundio Mobile (Denmark) Limited" },
	{ 10106, "Zamir Telecom Limited" },
	{ 10107, "TalkTalk Communications Limited" },
	{ 10108, "Wireless Solutions International" },
	{ 10109, "Communications Networking Services (UK)" },
	{ 10110, "Communications Networking Services (UK)" },
	{ 10111, "Icron Network Limited" },
	{ 10113, "ELCom Management Ltd" },
	{ 10116, "China Telecom (Europe) Ltd" },
	{ 10117, "Docklands Data Centre Ltd" },
	{ 10118, "CenturyLink Communications UK Limited" },
	{ 10119, "Inmarsat Global Limited" },
	{ 10120, "Three Ireland (Hutchison) Limited" },
	{ 10121, "Three Ireland (Hutchison) Limited" },
	{ 10122, "Access Telecom Ireland Ltd." },
	{ 10123, "Elephant Talk Communications Ltd." },
	{ 10124, "Vodafone Ireland" },
	{ 10125, "Vodafone Ireland" },
	{ 10126, "Vodafone Ireland" },
	{ 10127, "Vodafone Ireland" },
	{ 10130, "TryMob LTD" },
	{ 10131, "Ukrtelecom JSC" },
	{ 10132, "Ukrtelecom JSC" },
	{ 10133, "JSC ""Kyivstar""" },
	{ 10134, "PrJSC ""Farlep-Invest""" },
	{ 10135, "Eurotranstelecom LLC" },
	{ 10136, "Vodafone Hungary Ltd" },
	{ 10137, "Vodafone Hungary Ltd" },
	{ 10138, "Magyar Telekom Plc" },
	{ 10140, "DIGI Telecommunication Ltd" },
	{ 10141, "DIGI Telecommunication Ltd" },
	{ 10142, "DIGI Telecommunication Ltd" },
	{ 10143, "Vodafone Hungary Ltd" },
	{ 10144, "Camelot Telecom Ltd." },
	{ 10145, "DB Netz AG" },
	{ 10146, "MTBC Telecom Ltd" },
	{ 10147, "GlobalCarrier Telecom GmbH" },
	{ 10148, "TYNTEC GmbH" },
	{ 10149, "Limitless Mobile GmbH" },
	{ 10150, "Synterra UK Limited" },
	{ 10151, "Digital Alliance Consortium" },
	{ 10153, "OTEGLOBE S.A" },
	{ 10154, "OTEGLOBE S.A" },
	{ 10155, "ON TELECOMS" },
	{ 10156, "WIND" },
	{ 10157, "WIND" },
	{ 10158, "FORTHNET" },
	{ 10159, "OTEGLOBE S.A" },
	{ 10160, "TVI Connect BV" },
	{ 10161, "01058 Telecom GmbH" },
	{ 10162, "Vodafone GmbH" },
	{ 10163, "European Telecommunications Holding E.T.H. Aktiengesellschaft" },
	{ 10164, "TVI Connect BV" },
	{ 10165, "01057 Protel GmbH" },
	{ 10166, "01059 GmbH" },
	{ 10167, "Voice2Voice Carrier Services Ltd." },
	{ 10168, "Inmarsat Global Limited" },
	{ 10169, "Network Rail Infrastructure Limited" },
	{ 10170, "Network Rail Infrastructure Limited" },
	{ 10171, "Lycamobile UK Limited" },
	{ 10172, "Gold Telecom Limited" },
	{ 10173, "Switchware Limited" },
	{ 10174, "VODAFONE LIMITED" },
	{ 10175, "Communications Networking Services (UK)" },
	{ 10176, "Telekom Srbija a.d." },
	{ 10177, "Telekom Srbija a.d." },
	{ 10178, "Vip Mobile d.o.o." },
	{ 10179, "Vip Mobile d.o.o." },
	{ 10180, "Telenor d.o.o." },
	{ 10181, "Vip Mobile d.o.o." },
	{ 10182, "Telenor d.o.o." },
	{ 10183, "Telenor d.o.o." },
	{ 10184, "OT-Optima Telekom d.d." },
	{ 10185, "OT-Optima Telekom d.d." },
	{ 10186, "VIPnet d.o.o." },
	{ 10188, "H1 Telekom d.d." },
	{ 10189, "HT d.d." },
	{ 10190, "Metronet telekomunikacije d.d." },
	{ 10192, "Multimedia Polska S.A." },
	{ 10193, "Orange Polska S.A." },
	{ 10194, "Aero 2 Sp. z o.o." },
	{ 10195, "MNI Centrum Usług S.A." },
	{ 10196, "BT Poland Sp. z o.o." },
	{ 10197, "T-MOBILE POLSKA S.A." },
	{ 10198, "POLKOMTEL Sp. z o.o." },
	{ 10199, "Aero 2 Sp. z o.o." },
	{ 10200, "T-Mobile Slovensko, a.s." },
	{ 10201, "T-Mobile Slovensko, a.s." },
	{ 10202, "T-Mobile Slovensko, a.s." },
	{ 10203, "T-Mobile Slovensko, a.s." },
	{ 10204, "4Consult, s.r.o." },
	{ 10205, "Slovak Telekom, a.s." },
	{ 10206, "Slovak Telekom, a.s." },
	{ 10207, "Antik Computers and Communications, s.r.o." },
	{ 10208, "RCS & RDS" },
	{ 10209, "RCS & RDS" },
	{ 10210, "Trans Tel Services" },
	{ 10211, "CNCF CFR" },
	{ 10212, "Iristel Romania" },
	{ 10213, "Euroweb Romania" },
	{ 10215, "Digital Cable Systems" },
	{ 10216, "Inmarsat Global Limited" },
	{ 10218, "VODAFONE LIMITED" },
	{ 10219, "Network Rail Infrastructure Limited" },
	{ 10220, "PLDT (UK) Limited" },
	{ 10221, "Inmarsat Global Limited" },
	{ 10222, "Digitech Solutions Global Limited" },
	{ 10223, "United Connect Limited" },
	{ 10224, "Network Rail Infrastructure Limited" },
	{ 10225, "Liquid Telecommunications Limited" },
	{ 10228, "EE Limited (Orange)" },
	{ 10229, "EE Limited (Orange)" },
	{ 10231, "ZTA1" },
	{ 10232, "VODAFONE LIMITED" },
	{ 10233, "T-Systems Limited" },
	{ 10234, "Nexcom Telecommunications" },
	{ 10235, "Vodafone Ltd (Energis)" },
	{ 10237, "Gamma Telecom Holdings Ltd" },
	{ 10238, "British Telecom" },
	{ 10239, "Lycamobile UK Limited" },
	{ 10248, "Maxis Broadband Sdn Bhd" },
	{ 10256, "Digi Telecommunications Sdn Bhd" },
	{ 10257, "Digi Telecommunications Sdn Bhd" },
	{ 10258, "Digi Telecommunications Sdn Bhd" },
	{ 10259, "Digi Telecommunications Sdn Bhd" },
	{ 10260, "Webe Digital Sdn Bhd" },
	{ 10261, "Webe Digital Sdn Bhd" },
	{ 10262, "Altel Communications Sdn Bhd" },
	{ 10263, "Altel Communications Sdn Bhd" },
	{ 10264, "Telekom Malaysia Berhad" },
	{ 10268, "YTL Communication Sdn Bhd" },
	{ 10270, "U Mobile Sdn Bhd" },
	{ 10271, "Redtone Engineering & Network Services Sdn Bhd" },
	{ 10272, "Telekom Malaysia Berhad" },
	{ 10273, "Telekom Malaysia Berhad" },
	{ 10274, "Telekom Malaysia Berhad" },
	{ 10275, "Telekom Malaysia Berhad" },
	{ 10276, "Telekom Malaysia Berhad" },
	{ 10277, "Telekom Malaysia Berhad" },
	{ 10278, "Celcom Axiata Berhad" },
	{ 10279, "Celcom Axiata Berhad" },
	{ 10281, "Maxis Broadband Sdn Bhd" },
	{ 10282, "Maxis Broadband Sdn Bhd" },
	{ 10283, "Maxis Broadband Sdn Bhd" },
	{ 10286, "Digi Telecommunications Sdn Bhd" },
	{ 10287, "Digi Telecommunications Sdn Bhd" },
	{ 10290, "TT dotcom Sdn Bhd" },
	{ 10291, "TT dotcom Sdn Bhd" },
	{ 10293, "Telekom Malaysia Berhad" },
	{ 10294, "Telekom Malaysia Berhad" },
	{ 10295, "Telekom Malaysia Berhad" },
	{ 10299, "Telekom Malaysia Berhad" },
	{ 10300, "Digi Telecommunications Sdn Bhd" },
	{ 10301, "Digi Telecommunications Sdn Bhd" },
	{ 10302, "Digi Telecommunications Sdn Bhd" },
	{ 10303, "Digi Telecommunications Sdn Bhd" },
	{ 10304, "Telekom Malaysia Berhad" },
	{ 10308, "U Mobile Sdn Bhd" },
	{ 10312, "Celcom Axiata Berhad" },
	{ 10313, "Celcom Axiata Berhad" },
	{ 10314, "U Mobile Sdn Bhd" },
	{ 10315, "U Mobile Sdn Bhd" },
	{ 10316, "U Mobile Sdn Bhd" },
	{ 10317, "TT dotcom Sdn Bhd" },
	{ 10318, "Tune Talk Sdn Bhd" },
	{ 10320, "Telstra Corporation Ltd" },
	{ 10321, "Telstra Corporation Ltd" },
	{ 10322, "Telstra Corporation Ltd" },
	{ 10323, "Telstra Corporation Ltd" },
	{ 10324, "Telstra Corporation Ltd" },
	{ 10325, "Telstra Corporation Ltd" },
	{ 10326, "Telstra Corporation Ltd" },
	{ 10327, "Telstra Corporation Ltd" },
	{ 10328, "Optus Networks Ltd" },
	{ 10329, "TPG Telecom Ltd" },
	{ 10330, "Telstra Corporation Ltd" },
	{ 10331, "Telstra Corporation Ltd" },
	{ 10332, "Telstra Corporation Ltd" },
	{ 10333, "Telstra Corporation Ltd" },
	{ 10334, "Telstra Corporation Ltd" },
	{ 10335, "Telstra Corporation Ltd" },
	{ 10336, "PowerTel Ltd" },
	{ 10338, "PowerTel Ltd" },
	{ 10339, "RSLCom Australia Pty. Ltd" },
	{ 10340, "IP Systems" },
	{ 10341, "IP Systems" },
	{ 10342, "TNZI Australia Pty Ltd" },
	{ 10343, "Vodafone Network Pty Ltd" },
	{ 10344, "KDD Australia Pty Ltd" },
	{ 10345, "WorldCom Australia Pty Ltd" },
	{ 10346, "WorldCom Australia Pty Ltd" },
	{ 10347, "WorldCom Australia Pty Ltd" },
	{ 10348, "WorldCom Australia Pty Ltd" },
	{ 10349, "Primus Telecommunications Pty Ltd" },
	{ 10350, "Société Internationale de Télécommunications Aeronautiques (SITA)" },
	{ 10351, "BT Australasia PM-F2" },
	{ 10352, "PowerTel Ltd" },
	{ 10353, "Orange Business Services Australia Pty Ltd" },
	{ 10354, "BT Australasia Pty Ltd" },
	{ 10355, "Norfolk Telecom" },
	{ 10356, "Norfolk Telecom" },
	{ 10357, "IDT Telecom Asia Pacific (Australia) Pty Ltd" },
	{ 10358, "Pacific Gateway Exchange" },
	{ 10359, "WorldCom Asia Pacific Limited" },
	{ 10360, "AAPT Ltd" },
	{ 10361, "Primus" },
	{ 10362, "Pacific Teleports Pty Ltd" },
	{ 10363, "Globalstar Australia Pty Ltd" },
	{ 10364, "TPG Telecom Ltd" },
	{ 10365, "AAPT Ltd" },
	{ 10366, "AAPT Ltd" },
	{ 10367, "AAPT Ltd" },
	{ 10368, "Vodafone Pty Ltd" },
	{ 10369, "Vodafone Pty Ltd" },
	{ 10370, "Vodafone Pty Ltd" },
	{ 10371, "Vodafone Pty Ltd" },
	{ 10372, "Vodafone Pty Ltd" },
	{ 10373, "Vodafone Pty Ltd" },
	{ 10374, "AAPT Ltd" },
	{ 10375, "AAPT Ltd" },
	{ 10376, "Optus Ltd" },
	{ 10377, "Optus Ltd" },
	{ 10378, "Optus Ltd" },
	{ 10379, "Optus Ltd" },
	{ 10380, "Cell Wireless Corporation" },
	{ 10381, "Vodafone Network Pty Ltd" },
	{ 10382, "Globalstar Australia Pty Ltd" },
	{ 10383, "Globalstar Australia Pty Ltd" },
	{ 10384, "Telstra Corporation Ltd" },
	{ 10385, "Tata Communications (Australia) Pty Ltd" },
	{ 10386, "Net Telephone Marketing Pty Ltd" },
	{ 10387, "Net Telephone Marketing Pty Ltd" },
	{ 10388, "Net Telephone Marketing Pty Ltd" },
	{ 10389, "Net Telephone Marketing Pty Ltd" },
	{ 10390, "Net Telephone Marketing Pty Ltd" },
	{ 10391, "Net Telephone Marketing Pty Ltd" },
	{ 10392, "Optus Ltd" },
	{ 10393, "Optus Ltd" },
	{ 10394, "Optus Ltd" },
	{ 10395, "Optus Ltd" },
	{ 10396, "Optus Ltd" },
	{ 10397, "Optus Ltd" },
	{ 10398, "Optus Ltd" },
	{ 10399, "Optus Ltd" },
	{ 10400, "PT Indosat (Persero) Tbk." },
	{ 10401, "PT Indosat (Persero) Tbk." },
	{ 10402, "PT Indosat (Persero) Tbk." },
	{ 10403, "PT Indosat (Persero) Tbk." },
	{ 10404, "PT Indosat (Persero) Tbk." },
	{ 10405, "PT Telkomsel" },
	{ 10406, "PT Satelindo" },
	{ 10407, "PT Satelindo" },
	{ 10408, "PT Indosat (Persero) Tbk." },
	{ 10409, "PT Excelkomindo" },
	{ 10410, "PT Indosat (Persero) Tbk." },
	{ 10411, "PT Indosat (Persero) Tbk." },
	{ 10412, "PT Indosat (Persero) Tbk." },
	{ 10413, "PT Satelindo" },
	{ 10414, "PT Satelindo" },
	{ 10415, "PT Satelindo" },
	{ 10416, "PT Indosat" },
	{ 10417, "PT Indosat - M3" },
	{ 10418, "PT Indosat - M3" },
	{ 10419, "PT Pasifik Satelit Nusantara" },
	{ 10420, "PT Satelindo" },
	{ 10421, "PT Satelindo" },
	{ 10422, "PT Satelindo" },
	{ 10423, "PT Satelindo" },
	{ 10424, "PT Telkom" },
	{ 10425, "PT Telkom" },
	{ 10426, "PT Natrindo Telepon Seluler" },
	{ 10427, "PT Indosat" },
	{ 10428, "PT Telkom" },
	{ 10429, "PT Indosat" },
	{ 10430, "PT Telkom" },
	{ 10431, "PT Telkom" },
	{ 10432, "PT Telekomunikasi Indonesi TBK" },
	{ 10433, "PT Telekomunikasi Indonesi TBK" },
	{ 10434, "PT Telekomunikasi Indonesi TBK" },
	{ 10435, "PT Telekomunikasi Indonesi TBK" },
	{ 10436, "PT Telekomunikasi Indonesi TBK" },
	{ 10437, "PT Telekomunikasi Indonesi TBK" },
	{ 10440, "PT. Bakrie Telecom Tbk." },
	{ 10480, "Isla Communications (ISLACOM)" },
	{ 10481, "Philippine Long Distance Telephone Company (PLDT)" },
	{ 10482, "Philippine Long Distance Telephone Company (PLDT)" },
	{ 10483, "Philippine Long Distance Telephone Company (PLDT)" },
	{ 10484, "Philippine Long Distance Telephone Company (PLDT)" },
	{ 10485, "Philippine Long Distance Telephone Company (PLDT)" },
	{ 10486, "Philippine Global Communications Inc. (PHILCOM)" },
	{ 10487, "Philippine Global Communications Inc. (PHILCOM)" },
	{ 10488, "Bayantel" },
	{ 10489, "Bayantel" },
	{ 10490, "Globe Telecom Inc. (GMCR)" },
	{ 10491, "Globe Telecom Inc. (GMCR)" },
	{ 10492, "Isla Communications (ISLACOM)" },
	{ 10493, "CAPWIRE" },
	{ 10494, "CAPWIRE" },
	{ 10495, "CAPWIRE" },
	{ 10496, "SMART (Smart Communications inc)" },
	{ 10497, "SMART (Smart Communications inc)" },
	{ 10498, "SMART (Smart Communications inc)" },
	{ 10499, "SBMA" },
	{ 10500, "Isla Communications (ISLACOM)" },
	{ 10501, "Isla Communications (ISLACOM)" },
	{ 10502, "Globe Telecom Inc. (GMCR)" },
	{ 10503, "Isla Communications (ISLACOM)" },
	{ 10504, "Philippine Global Communications Inc. (PhilComsat)" },
	{ 10505, "Philippine Global Communications Inc. (PhilComsat)" },
	{ 10506, "Philippine Global Communications Inc. (PhilComsat)" },
	{ 10507, "Nextel" },
	{ 10508, "Aces" },
	{ 10509, "Aces" },
	{ 10510, "Capwire" },
	{ 10511, "BellTelecom" },
	{ 10512, "ETPI" },
	{ 10513, "ETPI" },
	{ 10514, "ETPI" },
	{ 10515, "Capwire" },
	{ 10516, "Digitel" },
	{ 10517, "Digitel" },
	{ 10518, "Digitel" },
	{ 10519, "Capwire" },
	{ 10520, "Capwire" },
	{ 10521, "Globe Telecom Inc. (GMCR)" },
	{ 10522, "Digitel" },
	{ 10523, "Globe Telecom Inc. (GMCR)" },
	{ 10524, "SMART (Smart Communications inc)" },
	{ 10525, "Digitel IGF" },
	{ 10526, "Digitel IGF" },
	{ 10527, "Philippine Global Communications Inc. (PHILCOM)" },
	{ 10528, "Philippine Global Communications Inc. (PHILCOM)" },
	{ 10529, "Digitel IGF" },
	{ 10530, "CURE CMTS" },
	{ 10531, "CURE CMTS" },
	{ 10532, "SMART (Smart Communications inc)" },
	{ 10533, "SMART (Smart Communications inc)" },
	{ 10534, "SMART (Smart Communications inc)" },
	{ 10535, "SMART (Smart Communications inc)" },
	{ 10536, "Bayantel" },
	{ 10537, "SMART (Smart Communications inc)" },
	{ 10538, "SMART (Smart Communications inc)" },
	{ 10539, "Digitel" },
	{ 10540, "Digitel" },
	{ 10541, "Digitel" },
	{ 10542, "FIBERTEL/Fiber Telecommunications, Inc." },
	{ 10543, "Philippines (SMART/Smart Communications, Inc.)" },
	{ 10544, "Philippines (SMART/Smart Communications, Inc.)" },
	{ 10546, "SMART (Smart Communications inc)" },
	{ 10552, "Advance Wireless Network" },
	{ 10553, "Advance Wireless Network" },
	{ 10554, "True International" },
	{ 10555, "True International" },
	{ 10556, "True International" },
	{ 10557, "True International" },
	{ 10560, "CAT" },
	{ 10561, "CAT" },
	{ 10562, "CAT" },
	{ 10563, "CAT" },
	{ 10564, "CAT" },
	{ 10565, "CAT" },
	{ 10566, "CAT" },
	{ 10567, "CAT" },
	{ 10568, "DTAC Network" },
	{ 10569, "TOT" },
	{ 10570, "TOT" },
	{ 10571, "TOT" },
	{ 10572, "TOT" },
	{ 10573, "TOT" },
	{ 10574, "TOT" },
	{ 10575, "Triple T Global Net" },
	{ 10576, "DTAC Network" },
	{ 10577, "AIN Globalcom" },
	{ 10578, "AIN Globalcom" },
	{ 10579, "True International" },
	{ 10580, "True International" },
	{ 10581, "True International" },
	{ 10582, "DTAC Network" },
	{ 10583, "DTAC Network" },
	{ 10584, "Triple T Global Net" },
	{ 10585, "Triple T Global Net" },
	{ 10586, "True International" },
	{ 10587, "True International" },
	{ 10588, "TOT" },
	{ 10589, "TOT" },
	{ 10590, "TOT" },
	{ 10591, "TOT" },
	{ 10592, "AIN Globalcom" },
	{ 10593, "AIN Globalcom" },
	{ 10594, "DTAC Network" },
	{ 10595, "DTAC Network" },
	{ 10596, "DTAC Network" },
	{ 10597, "DTAC Network" },
	{ 10598, "Advance Wireless Network" },
	{ 10599, "Advance Wireless Network" },
	{ 10600, "Singapore Telecommunications Ltd" },
	{ 10601, "Singapore Telecommunications Ltd" },
	{ 10602, "Singapore Telecommunications Ltd" },
	{ 10603, "Singapore Telecommunications Ltd" },
	{ 10604, "Telekom Malaysia (S) Pte Ltd" },
	{ 10605, "Telekom Malaysia (S) Pte Ltd" },
	{ 10606, "ComNet Telecom" },
	{ 10608, "StarHub Ltd" },
	{ 10609, "Singapore Telecommunications Ltd" },
	{ 10610, "Singapore Telecommunications Ltd" },
	{ 10611, "Singapore Telecommunications Ltd" },
	{ 10612, "Singapore Telecommunications Ltd" },
	{ 10613, "Singapore Telecommunications Ltd" },
	{ 10614, "Singapore Telecommunications Ltd" },
	{ 10615, "Singapore Telecommunications Ltd" },
	{ 10616, "Fixed & Mobile Pte Ltd" },
	{ 10617, "Fixed & Mobile Pte Ltd" },
	{ 10619, "Level 3 Communications Singapore Pte Ltd" },
	{ 10620, "StarHub Ltd" },
	{ 10621, "StarHub Ltd" },
	{ 10623, "StarHub Ltd" },
	{ 10624, "CITIC Telecom International (SEA) Pte Ltd" },
	{ 10625, "Nexwave Telecoms Pte Ltd" },
	{ 10626, "Bludot Communications Pte Ltd" },
	{ 10627, "Tata Communications International Pte Ltd" },
	{ 10628, "MobileOne Ltd" },
	{ 10629, "MobileOne Ltd" },
	{ 10630, "Telstra Global (Singapore) Pte Ltd" },
	{ 10631, "ComNet Telecom" },
	{ 10632, "StarHub Ltd" },
	{ 10633, "StarHub Ltd" },
	{ 10634, "Tata Communications International Pte Ltd" },
	{ 10635, "Blueberry Telecom Pte Ltd" },
	{ 10636, "Vodafone Enterprise Singapore Pte Ltd" },
	{ 10637, "Singapore Smart Telecommunications Pte Ltd." },
	{ 10638, "BT Singapore Pte Ltd" },
	{ 10639, "Singapore Telecommunications Ltd" },
	{ 10640, "Singapore Telecommunications Ltd" },
	{ 10641, "Singapore Telecommunications Ltd" },
	{ 10642, "Singapore Telecommunications Ltd" },
	{ 10643, "Singapore Telecommunications Ltd" },
	{ 10644, "Singapore Telecommunications Ltd" },
	{ 10645, "Singapore Telecommunications Ltd" },
	{ 10646, "Singapore Telecommunications Ltd" },
	{ 10647, "Singapore Telecommunications Ltd" },
	{ 10648, "Singapore Telecommunications Ltd" },
	{ 10649, "Singapore Telecommunications Ltd" },
	{ 10650, "Singapore Telecommunications Ltd" },
	{ 10651, "Singapore Telecommunications Ltd" },
	{ 10652, "Singapore Telecommunications Ltd" },
	{ 10653, "Singapore Telecommunications Ltd" },
	{ 10654, "PLDT (SG) Pte Ltd" },
	{ 10655, "Singapore Telecommunications Ltd" },
	{ 10656, "Singapore Telecommunications Ltd" },
	{ 10657, "Singapore Telecommunications Ltd" },
	{ 10658, "Singapore Telecommunications Ltd" },
	{ 10659, "Singapore Telecommunications Ltd" },
	{ 10660, "Verizon Communications Singapore Pte Ltd" },
	{ 10661, "MobileOne (Asia) Pte Ltd" },
	{ 10662, "MobileOne (Asia) Pte Ltd" },
	{ 10663, "Blueberry Telecom Pte Ltd" },
	{ 10664, "StarHub Ltd" },
	{ 10665, "StarHub Ltd" },
	{ 10666, "MediaRing Communications Pte Ltd" },
	{ 10667, "Redtone Technology Pte Ltd" },
	{ 10668, "ETN Singapore Pte Ltd" },
	{ 10669, "Verizon Communications Singapore Pte Ltd" },
	{ 10670, "Orange Carriers Singapore Pte Ltd" },
	{ 10673, "Telekom Malaysia (S) Pte Ltd" },
	{ 10674, "Telekom Malaysia (S) Pte Ltd" },
	{ 10675, "Itopia.Com Pte Ltd" },
	{ 10676, "Singapore Telecommunications Ltd" },
	{ 10679, "Nexwave Telecoms Pte Ltd" },
	{ 10680, "ETNS Singapore Pte Ltd" },
	{ 10681, "Interconnect Technology Pte Ltd" },
	{ 10682, "PLDT (SG) Pte Ltd" },
	{ 10683, "CTM (Singapore) Pte Ltd" },
	{ 10684, "MobileOne (Asia) Pte Ltd" },
	{ 10685, "MobileOne (Asia) Pte Ltd" },
	{ 10686, "Singapore Telecommunications Ltd" },
	{ 10687, "CITIC Telecom International (SEA) Pte Ltd" },
	{ 10688, "DST Communications Sdn Bhd" },
	{ 10689, "Telekom Brunei Berhad" },
	{ 10690, "Telekom Brunei Berhad" },
	{ 10691, "DST Communications Sdn Bhd" },
	{ 10692, "DST Communications Sdn Bhd" },
	{ 10693, "Telekom Brunei Berhad" },
	{ 10694, "Telekom Brunei Berhad" },
	{ 10695, "Telekom Brunei Berhad" },
	{ 10696, "DST Communications Sdn Bhd" },
	{ 10697, "DST Communications Sdn Bhd" },
	{ 10698, "Progresif Cellular Sdn Bhd" },
	{ 10720, "Spark New Zealand" },
	{ 10721, "Spark New Zealand" },
	{ 10723, "Two Degrees Mobile Limited" },
	{ 10726, "Spark New Zealand" },
	{ 10727, "TNZI New Zealand Ltd" },
	{ 10728, "Compass Communications" },
	{ 10729, "Vodafone NZ (TCL)" },
	{ 10730, "Two Degrees Mobile Limited" },
	{ 10731, "Two Degrees Mobile Limited" },
	{ 10733, "TNZI New Zealand Ltd" },
	{ 10734, "Vocus (CallPlus)" },
	{ 10735, "TNZI New Zealand Ltd" },
	{ 10736, "Spark New Zealand Mobile" },
	{ 10737, "Spark New Zealand Mobile" },
	{ 10738, "Spark New Zealand Mobile" },
	{ 10739, "Spark New Zealand Mobile" },
	{ 10740, "Spark New Zealand Mobile" },
	{ 10741, "Spark New Zealand Mobile" },
	{ 10742, "Vodafone NZ" },
	{ 10743, "Vodafone NZ" },
	{ 10745, "Vodafone NZ" },
	{ 10746, "Vodafone NZ" },
	{ 10747, "Vodafone NZ (TCL)" },
	{ 10748, "Vodafone NZ (TCL)" },
	{ 10749, "TNZI New Zealand Ltd" },
	{ 10750, "TNZI New Zealand Ltd" },
	{ 10751, "Two Degrees Mobile Limited" },
	{ 10761, "Vodafone NZ (TCL)" },
	{ 10762, "Vodafone NZ (TCL)" },
	{ 10766, "Spark New Zealand Mobile" },
	{ 10767, "Spark New Zealand Mobile" },
	{ 10777, "Vodafone NZ" },
	{ 10778, "VNGS (WXC)" },
	{ 10781, "Spark New Zealand Mobile" },
	{ 10782, "Spark New Zealand Mobile" },
	{ 10783, "Spark New Zealand Mobile" },
	{ 10800, "IT&E Overseas, Inc." },
	{ 10801, "Access Telecom" },
	{ 10803, "IT&E Overseas, Inc." },
	{ 10804, "IT&E Overseas, Inc." },
	{ 10805, "TelePacific Networks Inc." },
	{ 10818, "Digicel Nauru Ltd" },
	{ 10819, "Digicel Nauru Backup" },
	{ 10832, "Digicel PNG Ltd" },
	{ 10833, "Digicel PNG Ltd" },
	{ 10834, "B-Mobile Ltd" },
	{ 10835, "Telikom PNG" },
	{ 10836, "Telikom PNG" },
	{ 10837, "Digicel PNG Ltd" },
	{ 10838, "Digicel PNG Ltd" },
	{ 10839, "B-Mobile Ltd" },
	{ 10842, "Digicel PNG Ltd" },
	{ 10864, "Tonga Communications Corporation" },
	{ 10869, "Digicel (Tonga) Ltd" },
	{ 10896, "Telecom Vanuatu Limited" },
	{ 10897, "Telecom Vanuatu Limited" },
	{ 10899, "Telecom Vanuatu Limited" },
	{ 10900, "Can'l Holding Limited" },
	{ 10902, "Digicel Vanuatu Ltd" },
	{ 10903, "Digicel Vanuatu Ltd" },
	{ 10912, "Fintel" },
	{ 10913, "Fintel" },
	{ 10914, "Vodafone Fiji Ltd" },
	{ 10915, "Vodafone Fiji Ltd" },
	{ 10916, "Vodafone Fiji Ltd" },
	{ 10917, "Vodafone Fiji Ltd" },
	{ 10918, "Digicel Fiji Ltd" },
	{ 10919, "Digicel Fiji Ltd" },
	{ 10920, "Fintel" },
	{ 10921, "Fintel" },
	{ 10922, "Fintel" },
	{ 10923, "Fintel" },
	{ 10944, "American Samoa Telecommunications Authority (ASTCA) " },
	{ 10948, "AST Telecom, LLC" },
	{ 10976, "Office des postes et télécommunications" },
	{ 10977, "Office des postes et télécommunications" },
	{ 10978, "Office des postes et télécommunications" },
	{ 10979, "Office des postes et télécommunications" },
	{ 10980, "Office des postes et télécommunications" },
	{ 10981, "Office des postes et télécommunications" },
	{ 10992, "O.P.T." },
	{ 10993, "O.P.T." },
	{ 10994, "Tikiphone" },
	{ 10995, "VITI" },
	{ 10996, "Pacific Mobile Telecom" },
	{ 10997, "Pacific Mobile Telecom" },
	{ 10998, "Tikiphone" },
	{ 10999, "Tikiphone" },
	{ 11008, "Telecom Cook Islands" },
	{ 11009, "Telecom Cook Islands" },
	{ 11010, "Telecom Cook Islands" },
	{ 11011, "Telecom Cook Islands" },
	{ 11024, "SamoaTel" },
	{ 11028, "SamoaTel" },
	{ 11029, "SamoaTel" },
	{ 11040, "Amalgamated Telecom Holdings Kiribati Limited (ATHKL)" },
	{ 11096, "FSM Telecoms (FSMTC)" },
	{ 11097, "FSM Telecoms (FSMTC)" },
	{ 11120, "Palau Communication & Electronics Company" },
	{ 11125, "Palau Mobile Communications Inc. (PMCI)" },
	{ 11126, "Palau Mobile Communications Inc. (PMCI)" },
	{ 11144, "Verizon Pacifica" },
	{ 11160, "Optus Ltd" },
	{ 11161, "Optus Ltd" },
	{ 11162, "Optus Ltd" },
	{ 11163, "Optus Ltd" },
	{ 11164, "Telecorp Ltd" },
	{ 11165, "Telecorp Ltd" },
	{ 11166, "Telecorp Ltd" },
	{ 11167, "Telecorp Ltd" },
	{ 11168, "Telecorp Ltd" },
	{ 11169, "TransACT Ltd" },
	{ 11170, "Mibroadband Pty Ltd" },
	{ 11171, "Mibroadband Pty Ltd" },
	{ 11172, "Mibroadband Pty Ltd" },
	{ 11173, "Mibroadband Pty Ltd" },
	{ 11174, "Hutchinson 3G Sydney" },
	{ 11175, "Hutchinson 3G Melbourne" },
	{ 11176, "Primus Telecommunications Pty Ltd" },
	{ 11177, "Prodigy Telecom Pty Ltd" },
	{ 11178, "Prodigy Telecom Pty Ltd" },
	{ 11179, "Alpha Telecom Pty" },
	{ 11180, "HiTech Telecom Pty Ltd" },
	{ 11181, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11182, "Digiplus Pty Ltd" },
	{ 11183, "Digiplus Pty Ltd" },
	{ 11184, "Asia Netcom Australia Pty Ltd" },
	{ 11185, "Tata Communications (Australia) Pty Ltd" },
	{ 11186, "Tel.Pacific Ltd" },
	{ 11187, "Tel.Pacific Ltd" },
	{ 11188, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11189, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11190, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11191, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11192, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11193, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11194, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11195, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11196, "Australian Telecoms Exchange Pty. Ltd." },
	{ 11197, "Australian Telecoms Exchange Pty. Ltd." },
	{ 11198, "IP Systems" },
	{ 11199, "IP Systems" },
	{ 11200, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11201, "Tel.Pacific Pty Ltd (Telpacific)" },
	{ 11204, "IntraPower Terrestrial Pty Ltd" },
	{ 11205, "Symbio Networks P/L" },
	{ 11207, "Global Gossip Communications" },
	{ 11208, "Tata Communications (Australia) Pty Ltd" },
	{ 11209, "Tata Communications (Australia) Pty Ltd" },
	{ 11210, "Lycamobile Pty Ltd" },
	{ 11211, "Lycamobile Pty Ltd" },
	{ 11212, "Lycamobile Pty Ltd" },
	{ 11213, "Lycamobile Pty Ltd" },
	{ 11215, "Symbio Networks P/L" },
	{ 11216, "Primus" },
	{ 11217, "Inmarsat Solutions B.V." },
	{ 11218, "Pivotel Satellite Limited" },
	{ 11219, "Telstra Corporation Ltd" },
	{ 11220, "Telstra Corporation Ltd" },
	{ 11221, "Telstra Corporation Ltd" },
	{ 11222, "Stephen Dalmeida (Globetouch Inc)" },
	{ 11223, "Stephen Dalmeida (Globetouch Inc)" },
	{ 11224, "Concerotel Pty Ltd" },
	{ 11280, "Telin Timor-Leste" },
	{ 11281, "Timor Telecom, S.A." },
	{ 11282, "Timor Telecom, S.A." },
	{ 11283, "Timor Telecom, S.A." },
	{ 11284, "Timor Telecom, S.A." },
	{ 11285, "Viettel Timor-Leste" },
	{ 11286, "Viettel Timor-Leste" },
	{ 11287, "Telin Timor-Leste" },
	{ 11360, "MobileOne Ltd" },
	{ 11361, "MobileOne Ltd" },
	{ 11362, "Blueberry Telecom" },
	{ 11363, "Blueberry Telecom" },
	{ 11364, "Telewest Ventures Communication Pte Ltd" },
	{ 11365, "Absolute Telecom P/L" },
	{ 11367, "HOIIO Pte LTD" },
	{ 11369, "Telekomunikasi Indonesia International Pte Ltd" },
	{ 11370, "Epsilon Telecommunications Pte Ltd" },
	{ 11372, "Syniverse Technologies Network Solutions" },
	{ 11373, "M1 Limited" },
	{ 11374, "M1 Limited" },
	{ 11375, "M1 Limited" },
	{ 11376, "M1 Limited" },
	{ 11377, "First Technology Development Pte Ltd" },
	{ 11378, "Syniverse Technologies Network Solutions" },
	{ 11379, "B-Trac International Pte Ltd" },
	{ 11380, "B-Trac International Pte Ltd" },
	{ 11381, "Bharti International (Singapore) Pte Ltd" },
	{ 11382, "Hello Technology Pte Ltd" },
	{ 11383, "Hello Technology Pte Ltd" },
	{ 11384, "Mobifone Global Singapore Pte Ltd" },
	{ 11385, "Mobifone Global Singapore Pte Ltd" },
	{ 11386, "Reliance Jio Infocomm Pte Ltd" },
	{ 11387, "Hello Technology Pte Ltd" },
	{ 11388, "World Hub C-Cloud Pte Ltd" },
	{ 11389, "World Hub C-Cloud Pte Ltd" },
	{ 11390, "South China Telecom (S) Pte Ltd" },
	{ 11391, "Telenor Global Services Singapore Pte Limited" },
	{ 11392, "Hello Technology Pte Ltd" },
	{ 11393, "NGT Networks Pte Ltd" },
	{ 11394, "NGT Networks Pte Ltd" },
	{ 11395, "NGT Networks Pte Ltd" },
	{ 11396, "TPG Telecom Pte Ltd" },
	{ 11397, "TPG Telecom Pte Ltd" },
	{ 11398, "TPG Telecom Pte Ltd" },
	{ 11399, "TPG Telecom Pte Ltd" },
	{ 11400, "Belgacom International Carrier Services Asia Pte Ltd" },
	{ 11401, "Belgacom International Carrier Services Asia Pte Ltd" },
	{ 11402, "StarHub Ltd" },
	{ 11403, "StarHub Ltd" },
	{ 11960, "FEBO TELECOM LTD" },
	{ 11968, "SAP (UK) Ltd." },
	{ 11969, "SAP (UK) Ltd." },
	{ 11970, "Meteor Mobile Communications Ltd." },
	{ 11971, "Meteor Mobile Communications Ltd." },
	{ 11972, "Three Ireland (Hutchison) Limited" },
	{ 11973, "Three Ireland (Hutchison) Limited" },
	{ 11974, "Three Ireland (Hutchison) Limited" },
	{ 11975, "Three Ireland (Hutchison) Limited" },
	{ 11984, "Vodafone Hungary Ltd" },
	{ 12000, "AD T-Mobile" },
	{ 12001, "DynacomSouth Dooel" },
	{ 12002, "WTI Macedonia" },
	{ 12003, "AD T-Mobile" },
	{ 12004, "Makedonski Telekom AD - Skopje" },
	{ 12005, "Makedonski Telekom AD - Skopje" },
	{ 12006, "AD T-Mobile" },
	{ 12007, "AD T-Mobile" },
	{ 12048, "Gamma Telecom Holdings Ltd" },
	{ 12049, "Hutchison Global Communications (UK) Limited" },
	{ 12050, "Hutchison Global Communications (UK) Limited" },
	{ 12051, "Limitless Mobile Ltd" },
	{ 12052, "VODAFONE LIMITED" },
	{ 12053, "Protel S.A.L offshore" },
	{ 12054, "VODAFONE LIMITED" },
	{ 12055, "VODAFONE LIMITED" },
	{ 12056, "Hutchison 3G UK Ltd" },
	{ 12057, "Hutchison 3G UK Ltd" },
	{ 12058, "Yaana Technologies LLC" },
	{ 12059, "Truphone Ltd" },
	{ 12061, "Epsilon Telecommunications Ltd" },
	{ 12062, "China Mobile International (UK) Limited" },
	{ 12063, "China Mobile International (UK) Limited" },
	{ 12064, "Liffey Telecom" },
	{ 12065, "Liffey Telecom" },
	{ 12066, "Liffey Telecom" },
	{ 12067, "Vodafone Ireland" },
	{ 12068, "Vodafone Ireland" },
	{ 12069, "Vodafone Ireland" },
	{ 12070, "Vodafone Ireland" },
	{ 12071, "Vodafone Ireland" },
	{ 12072, "POLKOMTEL Sp. z o.o." },
	{ 12073, "POLKOMTEL Sp. z o.o." },
	{ 12074, "EZ PHONE MOBILE Sp. z o.o." },
	{ 12075, "EZ PHONE MOBILE Sp. z o.o." },
	{ 12080, "Elisa Eesti AS" },
	{ 12081, "Elisa Eesti AS" },
	{ 12082, "SmartTel Plus OÜ" },
	{ 12083, "Tele2 Eesti AS" },
	{ 12084, "Tele2 Eesti AS" },
	{ 12085, "Tele2 Eesti Aktsiaselts" },
	{ 12086, "Tele2 Eesti Aktsiaselts" },
	{ 12088, "AD T-Mobile" },
	{ 12089, "AD T-Mobile" },
	{ 12090, "AD T-Mobile" },
	{ 12091, "Makedonski Telekom AD - Skopje" },
	{ 12092, "Mobik Telekomunikacii Dooel" },
	{ 12093, "One AD" },
	{ 12094, "One AD" },
	{ 12096, "TERRAKOM d.o.o." },
	{ 12097, "TERRAKOM d.o.o." },
	{ 12098, "SOFTNET d.o.o." },
	{ 12099, "TELE2 d.o.o." },
	{ 12100, "HT d.d." },
	{ 12101, "SIOL d.o.o." },
	{ 12104, "Gmobile LTD" },
	{ 12105, "Silknet JSC" },
	{ 12106, "Geocell Ltd" },
	{ 12107, "Mobitel Ltd" },
	{ 12108, "Akhali Kselebi Ltd" },
	{ 12109, "Akhteli Ltd" },
	{ 12110, "System Net Ltd" },
	{ 12111, "Magticom Ltd" },
	{ 12112, "ICON" },
	{ 12113, "Orange Armenia" },
	{ 12115, "Crossnet" },
	{ 12116, "Dzoraxbyur Hamalir" },
	{ 12117, "Netsys" },
	{ 12118, "GLOBAL CALLINE" },
	{ 12119, "Interactive TV" },
	{ 12120, "Melita plc - Mobile" },
	{ 12121, "GO plc – Mobile" },
	{ 12122, "GO plc – Mobile" },
	{ 12123, "GO plc – Mobile" },
	{ 12124, "Vodafone Malta Ltd." },
	{ 12125, "Vodafone Malta Ltd." },
	{ 12126, "Vodafone Malta Ltd." },
	{ 12127, "Vodafone Malta Ltd." },
	{ 12128, "OTEGLOBE S.A" },
	{ 12129, "OTEGLOBE S.A" },
	{ 12130, "OTEGLOBE S.A" },
	{ 12131, "VODAFONE-PANAFON" },
	{ 12132, "VODAFONE-PANAFON" },
	{ 12133, "COSMOTE" },
	{ 12134, "FORTHNET" },
	{ 12135, "WIND" },
	{ 12136, "MTN Cyprus Limited" },
	{ 12137, "MTN Cyprus Limited" },
	{ 12138, "MTN Cyprus Limited" },
	{ 12139, "MTN Cyprus Limited" },
	{ 12140, "Primetel PLC" },
	{ 12141, "Primetel PLC" },
	{ 12142, "Primetel PLC" },
	{ 12143, "Primetel PLC" },
	{ 12144, "T-Mobile Crna Gora Ltd" },
	{ 12145, "T-Mobile Crna Gora Ltd" },
	{ 12152, "T-Mobile Netherlands B.V." },
	{ 12153, "T-Mobile Netherlands B.V." },
	{ 12154, "KPN B.V." },
	{ 12155, "KPN B.V." },
	{ 12156, "Inmarsat Solutions B.V." },
	{ 12157, "Mundio Mobile (Netherlands) Ltd" },
	{ 12158, "Mundio Mobile (Netherlands) Ltd" },
	{ 12159, "Highside Telecom B.V." },
	{ 12160, "Excel Ltd." },
	{ 12161, "Optel Technology Ltd." },
	{ 12162, "RCC Com Inc." },
	{ 12163, "NetCologne Gesellschaft für Telekommunikation mbH" },
	{ 12164, "Prioritel LLC" },
	{ 12165, "Sekom Telecom OY" },
	{ 12166, "Telstar Capital Corp." },
	{ 12167, "JSC KazTransCom" },
	{ 12168, "Bosphocom" },
	{ 12169, "Tellcom" },
	{ 12170, "Avea" },
	{ 12176, "Cosmote Romanian Mobile Telecommunications" },
	{ 12177, "Cosmote Romanian Mobile Telecommunications" },
	{ 12178, "2K Telecom" },
	{ 12179, "RCS & RDS" },
	{ 12180, "RCS & RDS" },
	{ 12181, "RCS & RDS" },
	{ 12182, "RCS & RDS" },
	{ 12183, "RCS & RDS" },
	{ 12186, "Lycamobile UK Limited" },
	{ 12187, "Communications Networking Services (UK)" },
	{ 12188, "Communications Networking Services (UK)" },
	{ 12189, "Switchware Limited" },
	{ 12190, "Symmetric Quorum Limited" },
	{ 12191, "Linx Telecom" },
	{ 12192, "Uno Communications S.p.A." },
	{ 12193, "Fastweb S.p.A." },
	{ 12194, "U - Compagnia Italiana di Telecomunicazioni" },
	{ 12195, "Intermatica S.p.A." },
	{ 12196, "Qcom Interactive S.p.A." },
	{ 12197, "Digi Italy S.r.l." },
	{ 12198, "Digi Italy S.r.l." },
	{ 12199, "Agile Telecom S.r.l." },
	{ 12200, "JSC KazTransCom" },
	{ 12201, "Ecotel Communication AG" },
	{ 12202, "Vodafone GmbH" },
	{ 12204, "Telecom 26 AG" },
	{ 12205, "First Telecom GmbH" },
	{ 12207, "Eagles Nest SL" },
	{ 12208, "Orange Business Switzerland AG" },
	{ 12209, "Orange Business Switzerland AG" },
	{ 12210, "TelCommunication Services AG" },
	{ 12211, "Comfone AG" },
	{ 12212, "Salt Mobile SA" },
	{ 12213, "Salt Mobile SA" },
	{ 12214, "IVY Telecom SA" },
	{ 12215, "Comfone AG" },
	{ 12216, "Softnet d.o.o." },
	{ 12217, "Akton d.o.o." },
	{ 12218, "Telemach d.o.o." },
	{ 12219, "Telemach d.o.o." },
	{ 12220, "Telekom Slovenije d.d." },
	{ 12221, "Telemach d.o.o." },
	{ 12222, "Telekom Slovenije d.d." },
	{ 12223, "Telekom Slovenije d.d." },
	{ 12224, "Interoute Networks Limited" },
	{ 12227, "Sabanci Telekomunikasyon Hizmetleri A.S." },
	{ 12229, "LEBARA LIMITED" },
	{ 12230, "EE Limited (Orange)" },
	{ 12231, "Invoco Ltd" },
	{ 12232, "Unistars" },
	{ 12233, "Telekom Baltija" },
	{ 12234, "Telenet" },
	{ 12235, "D-COM" },
	{ 12236, "ROAM" },
	{ 12237, "Telecentrs" },
	{ 12238, "Lattelecom" },
	{ 12239, "ECO Networks" },
	{ 12240, "Detel Global d.o.o." },
	{ 12241, "Detel Global d.o.o." },
	{ 12242, "Detel Global d.o.o." },
	{ 12243, "T-2 d.o.o." },
	{ 12244, "A1 Slovenija d.d." },
	{ 12245, "A1 Slovenija d.d." },
	{ 12247, "Telekom Slovenije d.d." },
	{ 12249, "Telefónica Germany GmbH & Co. OHG" },
	{ 12250, "M'net Telekommunikations GmbH" },
	{ 12253, "XOTel SIA" },
	{ 12254, "Communication Services Tele2 GmbH" },
	{ 12255, "Communication Services Tele2 GmbH" },
	{ 12256, "Telekomunikäciju grupa" },
	{ 12257, "Datagrupa.lv" },
	{ 12258, "IT Group" },
	{ 12259, "Latvijas dzelzcels" },
	{ 12260, "CSC Telecom" },
	{ 12261, "Baltkom TV SIA" },
	{ 12262, "Baltkom TV SIA" },
	{ 12263, "Finors Telekom" },
	{ 12264, "NORDISK POLSKA Sp. z o.o." },
	{ 12265, "EXATEL S.A." },
	{ 12266, "EXATEL S.A." },
	{ 12267, "POLKOMTEL Sp. z o.o." },
	{ 12268, "Netia S.A." },
	{ 12269, "Telefonia Dialog Sp. z o.o." },
	{ 12270, "POLKOMTEL Sp. z o.o." },
	{ 12271, "GlobeCom S.A." },
	{ 12272, "WIND" },
	{ 12273, "WIND" },
	{ 12274, "WIND" },
	{ 12275, "HELLAS ONLINE" },
	{ 12276, "HELLAS ONLINE" },
	{ 12277, "WIND" },
	{ 12278, "WIND" },
	{ 12279, "WIND" },
	{ 12280, "Rete Ferroviaria Italiana S.p.A." },
	{ 12281, "Agile Telecom S.r.l." },
	{ 12282, "Agile Telecom S.r.l." },
	{ 12283, "H3G S.p.A." },
	{ 12284, "Vodafone Italia S.p.A." },
	{ 12285, "Vodafone Italia S.p.A." },
	{ 12286, "Vodafone Italia S.p.A." },
	{ 12287, "Vodafone Italia S.p.A." },
	{ 12312, "Etisalat" },
	{ 12313, "Etisalat" },
	{ 12314, "Etisalat" },
	{ 12315, "Etisalat" },
	{ 12316, "Etisalat" },
	{ 12317, "Etisalat" },
	{ 12320, "Telecom Egypt" },
	{ 12321, "Telecom Egypt" },
	{ 12322, "Mobinil" },
	{ 12323, "Mobinil" },
	{ 12325, "Vodafone" },
	{ 12326, "Vodafone" },
	{ 12330, "Etisalat" },
	{ 12331, "Etisalat" },
	{ 12332, "Telecom Egypt" },
	{ 12333, "Telecom Egypt" },
	{ 12334, "Telecom Egypt" },
	{ 12336, "ex.Consortium Algérie Télécom" },
	{ 12337, "Algérie Télécom (AT)" },
	{ 12338, "Algérie Télécom (AT)" },
	{ 12339, "Algérie Télécom (AT)" },
	{ 12340, "Algérie Télécom (AT)" },
	{ 12341, "Orascom Télécom Algérie (OTA)" },
	{ 12342, "Wataniya Télécom Algérie (WTA)" },
	{ 12343, "Algérie Télécom Mobile (ATM)" },
	{ 12345, "Algérie Télécom (AT)" },
	{ 12346, "Orascom Télécom Algérie (OTA)" },
	{ 12347, "Orascom Télécom Algérie (OTA)" },
	{ 12348, "Wataniya Télécom Algérie (WTA)" },
	{ 12349, "Wataniya Télécom Algérie (WTA)" },
	{ 12350, "Wataniya Télécom Algérie (WTA)" },
	{ 12352, "Itassalat Al-Maghrib (Maroc Telecom)" },
	{ 12353, "Itassalat Al-Maghrib (Maroc Telecom)" },
	{ 12354, "Itassalat Al-Maghrib (Maroc Telecom)" },
	{ 12355, "Itassalat Al-Maghrib (Maroc Telecom)" },
	{ 12358, "Wana Corporate (Inwi)" },
	{ 12359, "Wana Corporate (Inwi)" },
	{ 12360, "Itassalat Al-Maghrib (Maroc Telecom)" },
	{ 12361, "Itassalat Al-Maghrib (Maroc Telecom)" },
	{ 12368, "Tunisie Telecom" },
	{ 12369, "Tunisie Telecom" },
	{ 12370, "Tunisie Telecom" },
	{ 12371, "Tunisie Telecom" },
	{ 12374, "Orascom Télécom Tunisie" },
	{ 12375, "Orascom Télécom Tunisie" },
	{ 12384, "Libyan International Telecommunication Company (LITC)" },
	{ 12385, "Libyan International Telecommunication Company (LITC)" },
	{ 12386, "Libyan International Telecommunication Company (LITC)" },
	{ 12387, "Libyan International Telecommunication Company (LITC)" },
	{ 12388, "Libyan International Telecommunication Company (LITC)" },
	{ 12389, "Libyan International Telecommunication Company (LITC)" },
	{ 12390, "Libyan International Telecommunication Company (LITC)" },
	{ 12391, "Libyan International Telecommunication Company (LITC)" },
	{ 12392, "Libyan International Telecommunication Company (LITC)" },
	{ 12393, "Libyan International Telecommunication Company (LITC)" },
	{ 12394, "Libyan International Telecommunication Company (LITC)" },
	{ 12395, "Libyan International Telecommunication Company (LITC)" },
	{ 12396, "Libyan International Telecommunication Company (LITC)" },
	{ 12397, "Libyan International Telecommunication Company (LITC)" },
	{ 12398, "Libyana Mobile Phone" },
	{ 12399, "Al-Jeel Al-Jadeed" },
	{ 12400, "GAMTEL" },
	{ 12401, "GAMTEL" },
	{ 12402, "GAMCEL" },
	{ 12403, "GAMCEL" },
	{ 12404, "AFRICELL" },
	{ 12405, "COMIUM" },
	{ 12406, "QCELL" },
	{ 12407, "GAMCEL" },
	{ 12416, "Expresso Sénégal" },
	{ 12417, "Sonatel (Orange)" },
	{ 12418, "Sonatel (Orange)" },
	{ 12419, "Expresso Sénégal" },
	{ 12420, "Expresso Sénégal" },
	{ 12421, "Sonatel (Orange)" },
	{ 12422, "Sonatel (Orange)" },
	{ 12423, "Expresso Sénégal" },
	{ 12424, "Sentel GSM (Tigo)" },
	{ 12425, "Sentel GSM (Tigo)" },
	{ 12426, "CSU" },
	{ 12427, "Sentel GSM (Tigo)" },
	{ 12428, "Sentel GSM (Tigo)" },
	{ 12432, "-" },
	{ 12433, "Mauritel SA" },
	{ 12434, "Mattel SA" },
	{ 12435, "Mauritel Mobiles" },
	{ 12436, "Mauritel Mobiles" },
	{ 12437, "Mauritel SA" },
	{ 12438, "Chinguitel SA" },
	{ 12439, "Chinguitel SA" },
	{ 12448, "SOTELMA SA" },
	{ 12449, "SOTELMA SA" },
	{ 12450, "SOTELMA SA" },
	{ 12451, "SOTELMA SA" },
	{ 12452, "ATEL SA" },
	{ 12453, "ATEL SA" },
	{ 12454, "Orange Mali SA" },
	{ 12455, "Orange Mali SA" },
	{ 12456, "GAMMA CONCEPT S.A." },
	{ 12464, "Sotelgui" },
	{ 12465, "Sotelgui" },
	{ 12466, "Intercell Guinée" },
	{ 12467, "Sotelgui" },
	{ 12468, "Orange Guinée" },
	{ 12469, "Orange Guinée" },
	{ 12470, "Areeba Guinée" },
	{ 12471, "Orange Guinée" },
	{ 12472, "Orange Guinée" },
	{ 12473, "Orange Guinée" },
	{ 12474, "Cellcom Guinée" },
	{ 12475, "ARPT" },
	{ 12476, "ARPT" },
	{ 12477, "Areeba Guinée" },
	{ 12478, "Areeba Guinée" },
	{ 12479, "Cellcom Guinée" },
	{ 12481, "Orange - Côte d'Ivoire" },
	{ 12482, "Côte d'Ivoire Telecom" },
	{ 12483, "Oricel - Côte d'Ivoire" },
	{ 12484, "Comium - Côte d'Ivoire" },
	{ 12485, "Arobase Telecom" },
	{ 12486, "Atlantique Telecom - Côte d'Ivoire" },
	{ 12487, "MTN - Côte d'Ivoire" },
	{ 12490, "Côte d'Ivoire Telecom" },
	{ 12492, "Atlantique Telecom - Côte d'Ivoire" },
	{ 12493, "MTN - Côte d'Ivoire" },
	{ 12494, "MTN - Côte d'Ivoire" },
	{ 12495, "MTN - Côte d'Ivoire" },
	{ 12496, "ONATEL S.A." },
	{ 12497, "ONATEL S.A." },
	{ 12498, "ORANGE BURKINA FASO SA" },
	{ 12499, "TELECEL FASO" },
	{ 12500, "ORANGE BURKINA FASO SA" },
	{ 12501, "ORANGE BURKINA FASO SA" },
	{ 12502, "ORANGE BURKINA FASO SA" },
	{ 12512, "SONITEL S.A." },
	{ 12513, "SAHELCOM" },
	{ 12514, "CELTEL NIGER S.A." },
	{ 12515, "ATLANTIC TELECOM" },
	{ 12516, "SONITEL S.A." },
	{ 12518, "Orange Niger S.A." },
	{ 12519, "Orange Niger S.A." },
	{ 12528, "TOGO TELECOM" },
	{ 12529, "TOGO TELECOM" },
	{ 12530, "ATLANTIQUE TELECOM TOGO" },
	{ 12531, "TOGO TELECOM" },
	{ 12532, "TOGO TELECOM" },
	{ 12533, "ATLANTIQUE TELECOM TOGO" },
	{ 12534, "TOGO CELLULAIRE" },
	{ 12535, "TOGO CELLULAIRE" },
	{ 12545, "BTSA" },
	{ 12546, "BTSA" },
	{ 12547, "SPACETEL BENIN" },
	{ 12548, "BELL BENIN" },
	{ 12549, "GLO MOBILE BENIN" },
	{ 12550, "ETISALAT BENIN" },
	{ 12551, "SPACETEL BENIN" },
	{ 12560, "Mauritius Telecom" },
	{ 12561, "Mauritius Telecom" },
	{ 12562, "Mauritius Telecom" },
	{ 12563, "Mauritius Telecom" },
	{ 12564, "Emtel Ltd." },
	{ 12565, "Emtel Ltd." },
	{ 12567, "Mahanagar Telephone (Mauritius)" },
	{ 12568, "Mahanagar Telephone (Mauritius)" },
	{ 12569, "Hot Link" },
	{ 12570, "Mauritius Telecom" },
	{ 12571, "Mauritius Telecom" },
	{ 12572, "Mauritius Telecom" },
	{ 12573, "Mauritius Telecom" },
	{ 12574, "Mauritius Telecom" },
	{ 12576, "Lonestarcell MTN" },
	{ 12592, "Sierratel" },
	{ 12593, "Airtel" },
	{ 12594, "Africell" },
	{ 12595, "Sierratel" },
	{ 12596, "Datatel/Cellcom" },
	{ 12597, "Comium" },
	{ 12598, "Africell" },
	{ 12599, "QCell(SL)" },
	{ 12608, "Ghana Telecommunications Company Ltd" },
	{ 12609, "Ghana Telecommunications Company Ltd" },
	{ 12610, "Zain Communications Ghana Ltd" },
	{ 12611, "Zain Communications Ghana Ltd" },
	{ 12612, "MTN Ghana Ltd" },
	{ 12613, "Globacom Ghana Ltd" },
	{ 12614, "Millicom Ghana Ltd" },
	{ 12616, "Visafone" },
	{ 12617, "EMTS" },
	{ 12618, "EMTS" },
	{ 12619, "G-Cell" },
	{ 12620, "EMTS" },
	{ 12621, "Multilinks" },
	{ 12624, "Nigerian Telecommunications Limited (NITEL)" },
	{ 12625, "Nigerian Telecommunications Limited (NITEL)" },
	{ 12626, "Nigerian Telecommunications Limited (NITEL)" },
	{ 12627, "Starcomms" },
	{ 12628, "MTN" },
	{ 12629, "MTN" },
	{ 12630, "MTN" },
	{ 12631, "Prestel" },
	{ 12632, "MTN" },
	{ 12633, "VEE Networks (Zain)" },
	{ 12634, "VEE Networks (Zain)" },
	{ 12635, "Globacom" },
	{ 12636, "Globacom" },
	{ 12637, "Globacom" },
	{ 12638, "Multilinks" },
	{ 12639, "Intercellular" },
	{ 12656, "Reserved" },
	{ 12657, "Telecel" },
	{ 12658, "Socatel" },
	{ 12659, "Orange" },
	{ 12660, "Socatel" },
	{ 12661, "Moov" },
	{ 12662, "Telsoft" },
	{ 12663, "Nationlink" },
	{ 12672, "Camtel" },
	{ 12673, "Camtel" },
	{ 12674, "Camtel" },
	{ 12675, "MTN Cameroon" },
	{ 12676, "MTN Cameroon" },
	{ 12677, "ORANGE Cameroun" },
	{ 12678, "ORANGE Cameroun" },
	{ 12679, "Camtel" },
	{ 12680, "MTN Cameroon" },
	{ 12681, "ORANGE Cameroun" },
	{ 12682, "ORANGE Cameroun" },
	{ 12683, "MTN Cameroon" },
	{ 12684, "MTN Cameroon" },
	{ 12685, "MTN Cameroon" },
	{ 12686, "MTN Cameroon" },
	{ 12688, "CV Telecom" },
	{ 12689, "T+Telecomunicações" },
	{ 12690, "T+Telecomunicações" },
	{ 12691, "CV Telecom" },
	{ 12693, "UNITEL T+ Telecomunicações" },
	{ 12694, "UNITEL T+ Telecomunicações" },
	{ 12695, "CVMultimédia" },
	{ 12696, "CVMóvel" },
	{ 12697, "CVMóvel" },
	{ 12704, "Companhia Sãotomense de Telecomunicações (CST)" },
	{ 12705, "Companhia Sãotomense de Telecomunicações (CST)" },
	{ 12706, "UNITEL STP" },
	{ 12707, "Companhia Sãotomense de Telecomunicações (CST)" },
	{ 12708, "Companhia Sãotomense de Telecomunicações (CST)" },
	{ 12720, "Orange (GETESA)" },
	{ 12721, "Orange (GETESA)" },
	{ 12722, "Orange (GETESA)" },
	{ 12723, "Orange (GETESA)" },
	{ 12724, "HiTsGE, S.A." },
	{ 12725, "HiTsGE, S.A." },
	{ 12726, "HiTsGE, S.A." },
	{ 12727, "HiTsGE, S.A." },
	{ 12736, "-" },
	{ 12737, "Gabon Telecom" },
	{ 12738, "Gabon Telecom" },
	{ 12739, "Gabon Telecom" },
	{ 12740, "Libertis" },
	{ 12741, "Atlantique Telecom" },
	{ 12742, "Celtel Gabon" },
	{ 12743, "Libertis" },
	{ 12744, "Système ARTEL" },
	{ 12745, "USAN Gabon" },
	{ 12746, "USAN Gabon" },
	{ 12747, "Système ARTEL" },
	{ 12748, "Système ARTEL" },
	{ 12749, "Atlantique Telecom 2" },
	{ 12750, "Système ARTEL" },
	{ 12751, "Système ARTEL" },
	{ 12752, "Congo Telecom" },
	{ 12753, "AIRTEL Congo" },
	{ 12754, "AIRTEL Congo" },
	{ 12755, "WARID Congo" },
	{ 12756, "MTN Congo" },
	{ 12757, "MTN Congo" },
	{ 12758, "Congo Telecom" },
	{ 12759, "AZUR Congo" },
	{ 12761, "Sematel" },
	{ 12762, "Supercell" },
	{ 12763, "Celtel Congo sarl RDC" },
	{ 12764, "Celtel Congo sarl RDC" },
	{ 12765, "Celtel Congo sarl RDC" },
	{ 12766, "Vodacom Congo RDC sprl" },
	{ 12767, "YOZMA Timeturns" },
	{ 12768, "Vodacom Congo RDC sprl" },
	{ 12769, "Celtel Congo RDC sprl" },
	{ 12770, "SAIT Telecom" },
	{ 12773, "Vodacom Congo RDC sprl" },
	{ 12775, "CCT" },
	{ 12777, "Vodacom Congo RDC sprl" },
	{ 12778, "Vodacom Congo RDC sprl" },
	{ 12779, "SAIT Telecom" },
	{ 12780, "Office Congolais des Postes et Télécommunications (OCPT)" },
	{ 12781, "Vodacom Congo RDC sprl" },
	{ 12782, "SAIT Telecom" },
	{ 12783, "Sematel" },
	{ 12784, "Angola Telecom" },
	{ 12785, "Angola Telecom" },
	{ 12786, "Unitel" },
	{ 12787, "Unitel" },
	{ 12788, "Nexus" },
	{ 12789, "Movicel" },
	{ 12790, "Mundo Startel" },
	{ 12791, "Mundo Startel" },
	{ 12792, "Unitel" },
	{ 12794, "Movicel" },
	{ 12795, "ItelNet" },
	{ 12816, "Cable and Wireless (Seychelles) Ltd." },
	{ 12817, "Cable and Wireless (Seychelles) Ltd." },
	{ 12818, "Cable and Wireless (Seychelles) Ltd." },
	{ 12820, "Intelvision Ltd" },
	{ 12821, "Airtel (Seychelles) Ltd" },
	{ 12822, "Airtel (Seychelles) Ltd" },
	{ 12823, "Airtel (Seychelles) Ltd" },
	{ 12824, "Kokonet Ltd" },
	{ 12826, "Airtel (Seychelles) Ltd" },
	{ 12827, "Airtel (Seychelles) Ltd" },
	{ 12828, "Intelvision Ltd" },
	{ 12829, "Intelvision Ltd" },
	{ 12830, "Intelvision Ltd" },
	{ 12831, "Intelvision Ltd" },
	{ 12832, "Sudanese Telephone Company Ltd. (Sudatel)" },
	{ 12833, "Sudanese Telephone Company Ltd. (Sudatel)" },
	{ 12834, "Sudanese Telephone Company Ltd. (Sudatel)" },
	{ 12835, "Kanartel Co." },
	{ 12836, "Kanartel Co." },
	{ 12837, "Kanartel Co." },
	{ 12838, "Zain (ex Mobitel)" },
	{ 12840, "Kanartel Co." },
	{ 12841, "Kanartel Co." },
	{ 12842, "Kanartel Co." },
	{ 12843, "Zain (ex Mobitel)" },
	{ 12844, "Kanartel Co." },
	{ 12848, "MTN Rwanda" },
	{ 12849, "Liquid Telecom" },
	{ 12850, "MTN Rwanda" },
	{ 12851, "MTN Rwanda" },
	{ 12852, "MTN Rwanda" },
	{ 12853, "Liquid Telecom" },
	{ 12854, "Tigo Rwanda" },
	{ 12855, "Tigo Rwanda" },
	{ 12856, "Airtel Rwanda" },
	{ 12857, "Airtel Rwanda" },
	{ 12858, "MTN Rwanda" },
	{ 12859, "MTN Rwanda" },
	{ 12860, "MTN Rwanda" },
	{ 12861, "Tigo Rwanda" },
	{ 12862, "Tigo Rwanda" },
	{ 12863, "Tigo Rwanda" },
	{ 12865, "Ethiopian Telecommunications Corporation" },
	{ 12872, "MTN Rwanda" },
	{ 12873, "MTN Rwanda" },
	{ 12874, "MTN Rwanda" },
	{ 12876, "MTN Rwanda" },
	{ 12877, "MTN Rwanda" },
	{ 12880, "Aerolite" },
	{ 12881, "Aerolite" },
	{ 12882, "Hormuud Telecom" },
	{ 12883, "Telesom Telecom" },
	{ 12884, "Golis Telecom" },
	{ 12887, "Nationlink" },
	{ 12912, "Telkom Kenya Limited" },
	{ 12913, "Telkom Kenya Limited" },
	{ 12914, "Safaricom PLC" },
	{ 12915, "Airtel Networks Kenya Limited" },
	{ 12916, "Safaricom PLC" },
	{ 12917, "Telkom Kenya Limited" },
	{ 12918, "Jamii Telecommunications Limited" },
	{ 12919, "Kenya Data Network" },
	{ 12920, "Airtel Networks Kenya Limited" },
	{ 12921, "Airtel Networks Kenya Limited" },
	{ 12928, "Tanzania Telecommunications Company Limited" },
	{ 12930, "MIC Tanzania Limited" },
	{ 12931, "Zanzibar Telecom Limited" },
	{ 12932, "Vodacom Tanzania Limited" },
	{ 12933, "Airtel Tanzania Limited" },
	{ 12935, "Zanzibar Telecom Limited" },
	{ 12936, "Tanzania Telecommunications Company Limited" },
	{ 12937, "Viettel Tanzania Limited" },
	{ 12939, "Vodacom Tanzania Limited" },
	{ 12940, "Viettel Tanzania Limited" },
	{ 12941, "Airtel Tanzania Limited" },
	{ 12942, "Airtel Tanzania Limited" },
	{ 12943, "Airtel Tanzania Limited" },
	{ 12944, "Uganda Telecom Ltd" },
	{ 12945, "Uganda Telecom Ltd" },
	{ 12946, "Celtel Uganda Ltd (Zain)" },
	{ 12947, "MTN Uganda Ltd" },
	{ 12948, "MTN Uganda Ltd" },
	{ 12949, "MTN Uganda Ltd" },
	{ 12950, "Celtel Uganda Ltd (Zain)" },
	{ 12951, "Celtel Uganda Ltd (Zain)" },
	{ 12952, "Uganda Telecom Ltd" },
	{ 12953, "Warid Telecom Uganda Ltd" },
	{ 12954, "Warid Telecom Uganda Ltd" },
	{ 12955, "Warid Telecom Uganda Ltd" },
	{ 12956, "Warid Telecom Uganda Ltd" },
	{ 12959, "House of Integrated Technology & Systems (U) Ltd" },
	{ 12960, "ONATEL" },
	{ 12961, "UCOM" },
	{ 12963, "LACELL" },
	{ 12964, "ONAMOB" },
	{ 12966, "AFRICELL" },
	{ 12967, "ECONET" },
	{ 12968, "ITS (International Telecom Services)" },
	{ 12969, "ITS (International Telecom Services)" },
	{ 12976, "TDM, SA" },
	{ 12977, "TDM, SA" },
	{ 12979, "Movitel, S.A." },
	{ 12980, "VM, SA" },
	{ 12981, "VM, SA" },
	{ 12982, "Mcel, SA" },
	{ 12983, "Mcel, SA" },
	{ 12988, "VM, SA" },
	{ 12992, "Congo Telecom" },
	{ 12993, "Congo Telecom" },
	{ 12994, "Congo Telecom" },
	{ 12995, "Congo Telecom" },
	{ 12996, "MTN Congo" },
	{ 12997, "MTN Congo" },
	{ 12998, "MTN Congo" },
	{ 12999, "MTN Congo" },
	{ 13008, "Zamtel" },
	{ 13009, "Zamcell" },
	{ 13010, "Zamtel" },
	{ 13011, "MTN Zambia" },
	{ 13024, "Celtel Madagascar" },
	{ 13025, "TELMA" },
	{ 13026, "Orange Madagascar" },
	{ 13027, "TELMA Mobile" },
	{ 13028, "Gulfsat Téléphonie" },
	{ 13030, "Celtel Madagascar" },
	{ 13031, "Celtel Madagascar" },
	{ 13032, "TELMA Mobile" },
	{ 13040, "SRR" },
	{ 13041, "SRR" },
	{ 13042, "Telco OI" },
	{ 13043, "Telco OI" },
	{ 13044, "Telco OI" },
	{ 13045, "Telco OI" },
	{ 13048, "Telecel Zimbabwe" },
	{ 13049, "Econet" },
	{ 13050, "Econet" },
	{ 13051, "NetOne (Pvt) Ltd" },
	{ 13056, "TelOne (Pvt) Ltd" },
	{ 13057, "TelOne (Pvt) Ltd" },
	{ 13058, "NetOne (Pvt) Ltd" },
	{ 13059, "NetOne (Pvt) Ltd" },
	{ 13060, "TelOne (Pvt) Ltd" },
	{ 13061, "Econet Wireless" },
	{ 13062, "TelOne (Pvt) Ltd" },
	{ 13063, "Data Control Systems (1996) (Pvt) Ltd" },
	{ 13064, "Econet Wireless" },
	{ 13065, "PowerTel Communications (Pvt) Ltd" },
	{ 13066, "Telecel Zimbabwe" },
	{ 13067, "Telecel Zimbabwe" },
	{ 13068, "Africom (Pvt) Ltd" },
	{ 13069, "Aquiva Wireless (Pvt) Ltd" },
	{ 13071, "Pecus Enterprises" },
	{ 13072, "Telecom Namibia Ltd." },
	{ 13073, "Mobile Telecommunications Ltd." },
	{ 13074, "Telecom Namibia Ltd." },
	{ 13075, "Telecom Namibia Ltd." },
	{ 13076, "Powercom Ltd." },
	{ 13077, "WIRELESS TECHNOLOGY NAMIBIA" },
	{ 13078, "Powercom Ltd." },
	{ 13079, "Demshi Investments CC" },
	{ 13080, "Paratus Telecommunications (PTY) Ltd" },
	{ 13081, "MTN Business Namibia" },
	{ 13082, "Mobile Telecommunications Ltd." },
	{ 13104, "Telecom Lesotho pty Ltd." },
	{ 13105, "Econet Telecom Lesotho (Pty) LTD" },
	{ 13106, "Econet Telecom Lesotho (Pty) LTD" },
	{ 13107, "Vodacom Lesotho (pty) ltd." },
	{ 13108, "Econet EZI - CEL Lesotho" },
	{ 13109, "Econet EZI - CEL Lesotho" },
	{ 13110, "Vodacom Lesotho (pty) ltd." },
	{ 13111, "Vodacom Lesotho (pty) ltd." },
	{ 13112, "VODACOM LESOTHO" },
	{ 13113, "VODACOM LESOTHO" },
	{ 13120, "Botswana Telecommunications Corporation" },
	{ 13121, "Botswana Telecommunications Corporation" },
	{ 13122, "Mascom Wireless" },
	{ 13123, "Orange Botswana" },
	{ 13124, "Orange Botswana" },
	{ 13125, "Botswana Telecommunications Corporation" },
	{ 13126, "Botswana Telecommunications Corporation" },
	{ 13127, "Mascom Wireless" },
	{ 13128, "Mascom Wireless" },
	{ 13129, "Mascom Wireless" },
	{ 13136, "Swaziland Posts & Telecommunications Co. (SPTC)" },
	{ 13137, "Swaziland Posts & Telecommunications Co. (SPTC)" },
	{ 13138, "Swaziland Posts & Telecommunications Co. (SPTC)" },
	{ 13139, "Swazi Mobile Limited" },
	{ 13141, "Swazi MTN Limited" },
	{ 13142, "Swazi MTN Limited" },
	{ 13152, "Comores Telecom" },
	{ 13153, "Comores Telecom" },
	{ 13154, "Comores Telecom" },
	{ 13155, "Comores Telecom" },
	{ 13156, "Telma Comores" },
	{ 13160, "Liquid Telecommunication South Africa (Pty) Ltd" },
	{ 13161, "Liquid Telecommunication South Africa (Pty) Ltd" },
	{ 13162, "Illizwi Telecommunications" },
	{ 13163, "MTN (Pty) Ltd" },
	{ 13164, "MTN (Pty) Ltd" },
	{ 13165, "Telkom SA Limited" },
	{ 13166, "Telkom SA Limited" },
	{ 13167, "Telkom SA Limited" },
	{ 13168, "Telkom SA Limited" },
	{ 13169, "Telkom SA Limited" },
	{ 13170, "Telkom SA Limited" },
	{ 13171, "Telkom SA Limited" },
	{ 13172, "Telkom SA Limited" },
	{ 13173, "MTN" },
	{ 13175, "ICO" },
	{ 13176, "Sentech (Pty) Ltd." },
	{ 13177, "Cell C (Pty) Ltd" },
	{ 13178, "Cell C (Pty) Ltd" },
	{ 13181, "MTN" },
	{ 13182, "Telkom SA Limited" },
	{ 13183, "Sentech (Pty) Ltd." },
	{ 13185, "SNO Telecommunications (Pty) Ltd" },
	{ 13186, "SNO Telecommunications (Pty) Ltd" },
	{ 13187, "Cell C (Pty) Ltd" },
	{ 13188, "Cell C (Pty) Ltd" },
	{ 13189, "Cell C (Pty) Ltd" },
	{ 13190, "Cell C (Pty) Ltd" },
	{ 13191, "Cell C (Pty) Ltd" },
	{ 13192, "Cell C (Pty) Ltd" },
	{ 13193, "Telkom SA Limited" },
	{ 13194, "Telkom SA Limited" },
	{ 13196, "Vodacom (Pty) Ltd" },
	{ 13197, "Vodacom (Pty) Ltd" },
	{ 13198, "Wirels Connect" },
	{ 13199, "Telkom SA Limited" },
	{ 13201, "Eritel Corporation" },
	{ 13272, "Smile Communications Tanzania Limited" },
	{ 13273, "Wiafrica Tanzania Limited" },
	{ 13328, "Smile Communications (U) Ltd" },
	{ 13329, "i-TEL Ltd" },
	{ 13332, "Smile Communications (U) Ltd" },
	{ 13333, "Celtel Uganda Ltd (Zain)" },
	{ 13334, "Celtel Uganda Ltd (Zain)" },
	{ 13336, "Airtel Uganda Limited" },
	{ 13337, "Airtel Uganda Limited" },
	{ 13338, "Sure Telecom" },
	{ 13339, "kmpms - 01/S2I" },
	{ 13340, "Sure Telecom" },
	{ 13341, "Warid Telecom Uganda Ltd" },
	{ 13342, "Datanet" },
	{ 13343, "Warid Telecom Uganda Ltd" },
	{ 13448, "Vodacom Pty Ltd" },
	{ 13449, "Vodacom Pty Ltd" },
	{ 13450, "Vodacom Pty Ltd" },
	{ 13451, "Vodacom Pty Ltd" },
	{ 13488, "Médi Telecom (Orange (Maroc))" },
	{ 13489, "Médi Telecom (Orange (Maroc))" },
	{ 13490, "Wana Corporate (Inwi)" },
	{ 13491, "Wana Corporate (Inwi)" },
	{ 13648, "MTN Sudan" },
	{ 13649, "MTN Sudan" },
	{ 13650, "MTN Sudan" },
	{ 13651, "MTN Sudan" },
	{ 13652, "MTN Sudan" },
	{ 13653, "MTN Sudan" },
	{ 13672, "Ministry of Telecommunication" },
	{ 13673, "Ministry of Telecommunication" },
	{ 13674, "Ministry of Telecommunication" },
	{ 13675, "Green Networks" },
	{ 13676, "NOW" },
	{ 13677, "MTN" },
	{ 13678, "Zain South Sudan" },
	{ 13679, "Sudani" },
	{ 13688, "GECOMSA" },
	{ 13689, "GECOMSA" },
	{ 13690, "GECOMSA" },
	{ 13691, "GECOMSA" },
	{ 13704, "Nexttel (ex VIETTEL Cameroun)" },
	{ 13705, "Nexttel (ex VIETTEL Cameroun)" },
	{ 13706, "MTN Cameroon Ltd" },
	{ 13707, "MTN Cameroon Ltd" },
	{ 13708, "MTN Cameroon Ltd" },
	{ 13709, "ORANGE Cameroun" },
	{ 13710, "ORANGE Cameroun" },
	{ 13720, "OASIS/TIGO" },
	{ 13721, "OASIS/TIGO" },
	{ 13722, "Africell" },
	{ 13723, "AIRTEL" },
	{ 13724, "CCT" },
	{ 13725, "CCT" },
	{ 13752, "Orange Mali SA" },
	{ 13753, "Orange Mali SA" },
	{ 13754, "Orange Mali SA" },
	{ 14048, "VIP Operator" },
	{ 14049, "One AD" },
	{ 14050, "One AD" },
	{ 14051, "AD T-Mobile" },
	{ 14052, "On-net Skopje" },
	{ 14053, "AD T-Mobile" },
	{ 14054, "AD T-Mobile" },
	{ 14055, "AD T-Mobile" },
	{ 14061, "SIOL, DOOEL, Skopje" },
	{ 14088, "Vodafone Ireland" },
	{ 14089, "Vodafone Ireland" },
	{ 14090, "Vodafone Ireland" },
	{ 14091, "Carphone Warehouse" },
	{ 14092, "Carphone Warehouse" },
	{ 14093, "Carphone Warehouse" },
	{ 14094, "Three Ireland (Hutchison) Limited" },
	{ 14095, "Three Ireland (Hutchison) Limited" },
	{ 14096, "Trafikverket centralfunktion IT" },
	{ 14097, "Trafikverket centralfunktion IT" },
	{ 14098, "Trafikverket centralfunktion IT" },
	{ 14099, "Trafikverket centralfunktion IT" },
	{ 14100, "Twilio Sweden AB" },
	{ 14101, "HI3G Access AB" },
	{ 14102, "HI3G Access AB" },
	{ 14103, "HI3G Access AB" },
	{ 14109, "Nord Connect OÜ" },
	{ 14110, "AS Eesti Telekom" },
	{ 14111, "AS Eesti Telekom" },
	{ 14120, "Mercury International Carrier Services" },
	{ 14121, "Mercury International Carrier Services" },
	{ 14123, "Sierra Wireless Sweden AB" },
	{ 14124, "Sierra Wireless Sweden AB" },
	{ 14125, "Sierra Wireless Sweden AB" },
	{ 14126, "HI3G Access AB" },
	{ 14128, "HI3G Access AB" },
	{ 14129, "HI3G Access AB" },
	{ 14130, "HI3G Access AB" },
	{ 14131, "HI3G Access AB" },
	{ 14132, "HI3G Access AB" },
	{ 14133, "HI3G Access AB" },
	{ 14134, "HI3G Access AB" },
	{ 14135, "HI3G Access AB" },
	{ 14136, "Primetel PLC" },
	{ 14137, "S.P. INTELLIGENT TELECOMS LTD" },
	{ 14138, "MTN Cyprus Ltd" },
	{ 14139, "MTN Cyprus Ltd" },
	{ 14140, "MTN Cyprus Ltd" },
	{ 14141, "MTN Cyprus Ltd" },
	{ 14142, "MTN Cyprus Ltd" },
	{ 14143, "MTN Cyprus Ltd" },
	{ 14144, "Telenor Sverige AB" },
	{ 14145, "Telenor Sverige AB" },
	{ 14146, "Mercury International Carrier Services" },
	{ 14147, "Mercury International Carrier Services" },
	{ 14150, "42 Telecom LTD" },
	{ 14151, "42 Telecom LTD" },
	{ 14154, "Completel" },
	{ 14155, "Completel" },
	{ 14156, "Wanatel" },
	{ 14157, "Mobiqui Things" },
	{ 14159, "Mobiqui Things" },
	{ 14160, "Vodafone Czech Republic a.s." },
	{ 14161, "Vodafone Czech Republic a.s." },
	{ 14162, "Vodafone Czech Republic a.s." },
	{ 14163, "Vodafone Czech Republic a.s." },
	{ 14168, "Mobik d.o.o." },
	{ 14169, "Mobik d.o.o." },
	{ 14170, "A1 Slovenija d.d." },
	{ 14171, "A1 Slovenija d.d." },
	{ 14172, "Telemach d.o.o." },
	{ 14173, "Eurotel d.o.o." },
	{ 14174, "A1 Slovenija d.d." },
	{ 14175, "A1 Slovenija d.d." },
	{ 14176, "T-MOBILE POLSKA S.A." },
	{ 14177, "T-MOBILE POLSKA S.A." },
	{ 14178, "T-MOBILE POLSKA S.A." },
	{ 14179, "T-MOBILE POLSKA S.A." },
	{ 14180, "Orange Polska S.A." },
	{ 14181, "Orange Polska S.A." },
	{ 14182, "EZ PHONE MOBILE Sp. z o.o." },
	{ 14183, "EZ PHONE MOBILE Sp. z o.o." },
	{ 14184, "Verizon Deutschland GmbH" },
	{ 14185, "Verizon Deutschland GmbH" },
	{ 14186, "BT (Germany) GmbH & Co. oHG" },
	{ 14187, "Tata Communications Deutschland GmbH" },
	{ 14189, "ProTel International LLC" },
	{ 14190, "NetCologne Gesellschaft für Telekommunikation mbH" },
	{ 14192, "Compatel Ltd." },
	{ 14193, "Compatel Ltd." },
	{ 14194, "Horisen AG" },
	{ 14195, "Netmore Group AB" },
	{ 14196, "Infobip LTD (UK)" },
	{ 14197, "Infobip LTD (UK)" },
	{ 14198, "Infobip LTD (UK)" },
	{ 14199, "Infobip LTD (UK)" },
	{ 14200, "Gold Telecom Bulgaria" },
	{ 14201, "Escom" },
	{ 14202, "BTCNet" },
	{ 14203, "Netfinity" },
	{ 14204, "Net-Connect Internet" },
	{ 14205, "BTCNet" },
	{ 14206, "BTCNet" },
	{ 14207, "Mobiltel" },
	{ 14217, "Ukrtelecom JSC" },
	{ 14219, "Ukrtelecom JSC" },
	{ 14220, "PrJSC VF Ukraine" },
	{ 14221, "PrJSC VF Ukraine" },
	{ 14222, "PrJSC VF Ukraine" },
	{ 14224, "Eircom UK Ltd" },
	{ 14225, "Inclarity Communications Limited" },
	{ 14227, "Spacetel UK Ltd" },
	{ 14228, "Spacetel UK Ltd" },
	{ 14231, "Truphone Ltd" },
	{ 14234, "Nova ehf" },
	{ 14235, "Nova ehf" },
	{ 14240, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{ 14241, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{ 14242, "Least Cost Routing Telecom, S.L." },
	{ 14243, "France Telecom España, S.A. Unipersonal" },
	{ 14244, "France Telecom España, S.A. Unipersonal" },
	{ 14245, "Xtra Telecom, S.L." },
	{ 14246, "Orange Catalunya Xarxes de Telecomunicaciones, S. A." },
	{ 14247, "Xtra Telecom, S.L." },
	{ 14248, "Digitel Mobile Srl" },
	{ 14249, "Rawal Telecom s.r.l." },
	{ 14250, "Rawal Telecom s.r.l." },
	{ 14251, "Fastweb S.p.A." },
	{ 14252, "Alcotek S.p.A." },
	{ 14253, "Fastweb S.p.A." },
	{ 14254, "Interoute S.p.A." },
	{ 14255, "Uno Communications S.p.A." },
	{ 14256, "ntl Communications (Ireland) Ltd." },
	{ 14257, "Meteor Communications Ltd." },
	{ 14258, "Swiftcall" },
	{ 14259, "Three Ireland (Hutchison) Limited" },
	{ 14260, "Three Ireland (Hutchison) Limited" },
	{ 14261, "Three Ireland (Hutchison) Limited" },
	{ 14262, "Three Ireland (Hutchison) Limited" },
	{ 14264, "Mobiltel" },
	{ 14265, "Bulgarian Telecommunication Company" },
	{ 14266, "Telenor Bulgaria" },
	{ 14267, "Bulgarian Telecommunication Company" },
	{ 14268, "Varna Net" },
	{ 14269, "National Railway Infrastructure Company" },
	{ 14270, "Mobiltel" },
	{ 14271, "Mobiltel" },
	{ 14272, "Globals Telekoms" },
	{ 14273, "TG Transit" },
	{ 14274, "OPTRON" },
	{ 14275, "MEGATEL" },
	{ 14276, "Telekom Baltija" },
	{ 14277, "Telekom Baltija" },
	{ 14278, "Telekom Baltija" },
	{ 14279, "Bite Mobile" },
	{ 14280, "KPN B.V." },
	{ 14281, "Tele2 Nederland B.V." },
	{ 14282, "Budget Phone Company B.V." },
	{ 14283, "Budget Phone Company B.V." },
	{ 14284, "KPN B.V." },
	{ 14285, "KPN B.V." },
	{ 14286, "KPN B.V." },
	{ 14287, "Ziggo Zakelijk Services B.V." },
	{ 14288, "Mobiltel" },
	{ 14289, "East Telecommunication Company" },
	{ 14290, "Vmobile" },
	{ 14291, "BTCNet" },
	{ 14292, "Mobiltel" },
	{ 14293, "Vestitel" },
	{ 14294, "Netfinity" },
	{ 14296, "DIGI Telecommunication Ltd" },
	{ 14298, "Vodafone Hungary Ltd" },
	{ 14299, "Vodafone Hungary Ltd" },
	{ 14300, "DIGI Telecommunication Ltd" },
	{ 14301, "Magyar Telekom Plc" },
	{ 14302, "Türk Telekom International HU Ltd." },
	{ 14303, "Magyar Telekom Plc" },
	{ 14304, "TalkTalk Communications Limited" },
	{ 14305, "TalkTalk Communications Limited" },
	{ 14306, "Inmarsat Global Limited" },
	{ 14307, "Samitel Limited" },
	{ 14308, "Cheers International Sales Limited" },
	{ 14309, "Vox Mundi d.o.o." },
	{ 14310, "Truphone Ltd" },
	{ 14311, "PCCW Global UK Limited" },
	{ 14312, "T-2 d.o.o." },
	{ 14314, "Mobik d.o.o." },
	{ 14315, "Telekom Slovenije d.d." },
	{ 14316, "Telekom Slovenije d.d." },
	{ 14317, "A1 Slovenija d.d." },
	{ 14318, "T-2 d.o.o." },
	{ 14319, "A1 Slovenija d.d." },
	{ 14322, "Hutchison Global Communications (UK) Limited" },
	{ 14323, "Syniverse Technologies Inc" },
	{ 14325, "Syniverse Technologies Inc" },
	{ 14329, "Vectone Mobile Limited" },
	{ 14330, "EE Limited (Orange)" },
	{ 14331, "EE Limited (Orange)" },
	{ 14333, "Telefonica UK Limited" },
	{ 14334, "Telefonica UK Limited" },
	{ 14335, "Idt Global Ltd" },
	{ 14368, "Belize Telemedia Limited (formerly Belize Telecommunications Ltd.)" },
	{ 14369, "Belize Telemedia Limited (formerly Belize Telecommunications Ltd.)" },
	{ 14370, "Belize Telemedia Limited (formerly Belize Telecommunications Ltd.)" },
	{ 14371, "Belize Telemedia Limited (formerly Belize Telecommunications Ltd.)" },
	{ 14372, "Belize Telemedia Limited (formerly Belize Telecommunications Ltd.)" },
	{ 14373, "Belize Telemedia Limited (formerly Belize Telecommunications Ltd.)" },
	{ 14374, "Speednet Communications Limited. (Speednet)" },
	{ 14375, "Speednet Communications Limited. (Speednet)" },
	{ 14400, "Cablenet S.A." },
	{ 14401, "Comunicaciones Celulares S.A." },
	{ 14402, "Telecomunicaciones de Guatemala S.A." },
	{ 14403, "Telecomunicaciones de Guatemala S.A." },
	{ 14404, "AT&T Servicios de Comunicaciones Guatemala S.A." },
	{ 14405, "Americatel Guatemala, S.A." },
	{ 14406, "Telefónica Móviles Guatemala S.A." },
	{ 14407, "Telefónica Móviles Guatemala S.A." },
	{ 14408, "Comunicaciones Celulares S.A." },
	{ 14409, "AT&T Servicios de Comunicaciones Guatemala S.A." },
	{ 14410, "Comunicaciones Celulares S.A." },
	{ 14411, "Servicios de Comunicaciones Personales Inalámbricas S.A." },
	{ 14412, "Servicios de Comunicaciones Personales Inalámbricas S.A." },
	{ 14413, "Servicios de Comunicaciones Personales Inalámbricas S.A." },
	{ 14414, "Comunicaciones Celulares S.A." },
	{ 14415, "Telefónica Móviles Guatemala S.A." },
	{ 14432, "CTE, S.A. de C.V." },
	{ 14433, "CTE, S.A. de C.V." },
	{ 14434, "CTE, S.A. de C.V." },
	{ 14435, "CTE Telecom Personal, S.A. de C.V." },
	{ 14436, "Telefónica El Salvador, S.A. de C.V." },
	{ 14437, "El Salvador Network S.A." },
	{ 14438, "Telemóvil El Salvador, S.A." },
	{ 14439, "Americatel El Salvador" },
	{ 14440, "Telefónica El Salvador, S.A. de C.V." },
	{ 14441, "Digicel, S.A. de C.V." },
	{ 14442, "AESTEL Salvadoreña y Cía, S. en C. de C.V." },
	{ 14443, "El Salvador Telecom, S.A. de C.V." },
	{ 14444, "GCA Telecom, S.A. de C.V." },
	{ 14445, "Telecomunicaciones de Ameríca S.A. de C.V." },
	{ 14446, "El Salvador Telecom, S.A. de C.V." },
	{ 14447, "Americana de Telecomunicaciones S.A. de C.V." },
	{ 14448, "Telefónica Móviles El Salvador, S.A. de C.V." },
	{ 14449, "Telemóvil El Salvador, S.A." },
	{ 14450, "Sky Technologies de El Salvador, S.A. de C.V." },
	{ 14451, "CTE, S.A. de C.V." },
	{ 14452, "CTE, S.A. de C.V." },
	{ 14453, "Telefónica Móviles El Salvador, S.A. de C.V." },
	{ 14454, "Telefónica Móviles El Salvador, S.A. de C.V." },
	{ 14455, "Telemóvil El Salvador, S.A." },
	{ 14456, "Telemóvil El Salvador, S.A." },
	{ 14457, "Digicel, S.A. de C.V." },
	{ 14459, "CTE Telecom Personal, S.A. de C.V." },
	{ 14464, "Sercom" },
	{ 14465, "Empresa Hondureña de Telecomunicaciones (HONDUTEL)" },
	{ 14466, "Celtel" },
	{ 14467, "Sercom" },
	{ 14468, "Empresa Hondureña de Telecomunicaciones (HONDUTEL)" },
	{ 14469, "Celtel" },
	{ 14470, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14471, "Sercom" },
	{ 14472, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14473, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14474, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14475, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14476, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14477, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14478, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14479, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14480, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14481, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14482, "SERVICIOS DE COMUNICACIONES DE HONDURAS S.A. DE C.V. (SERCOM DE HONDURAS)" },
	{ 14496, "ENITEL, S.A." },
	{ 14497, "ENITEL, S.A." },
	{ 14498, "SERCOM, S.A." },
	{ 14499, "ENITEL, S.A." },
	{ 14501, "Telefonía Celular de Nicaragua - (Bellsouth)" },
	{ 14503, "Globalstar Nicaragua, S.A." },
	{ 14520, "Telefonica de Costa Rica TC S.A" },
	{ 14521, "Telefonica de Costa Rica TC S.A" },
	{ 14522, "Telefonica de Costa Rica TC S.A" },
	{ 14523, "CLARO" },
	{ 14524, "CLARO" },
	{ 14525, "Telefonica de Costa Rica TC S.A" },
	{ 14526, "Telefónica" },
	{ 14527, "Telefónica" },
	{ 14528, "Instituto Costarricense de Electricidad" },
	{ 14529, "Instituto Costarricense de Electricidad" },
	{ 14530, "Instituto Costarricense de Electricidad" },
	{ 14531, "Instituto Costarricense de Electricidad" },
	{ 14532, "Instituto Costarricense de Electricidad" },
	{ 14533, "Instituto Costarricense de Electricidad" },
	{ 14534, "Telefonica de Costa Rica TC S.A" },
	{ 14535, "Instituto Costarricense de Electricidad" },
	{ 14547, "Telecomunicaciones NetUno de Panama SA" },
	{ 14548, "Cable and Wireless Panama S.A." },
	{ 14550, "Fortaleza Investment Group Corp." },
	{ 14551, "Telefónica Móviles Panamá, S.A." },
	{ 14553, "Cable Onda S.A." },
	{ 14554, "Mobil Red Inc." },
	{ 14556, "Cable and Wireless Panama S.A." },
	{ 14557, "Claro Panamá S.A." },
	{ 14558, "Claro Panamá S.A." },
	{ 14559, "Digicel Panamá S.A." },
	{ 14560, "Digicel MG INT" },
	{ 14561, "Cable and Wireless Panama S.A." },
	{ 14562, "Cable and Wireless Panama S.A." },
	{ 14563, "Cable and Wireless Panama S.A." },
	{ 14564, "Telefónica Móviles de Panamá" },
	{ 14565, "Cable and Wireless Panama S.A." },
	{ 14566, "Galaxy Communications Network S.A." },
	{ 14571, "Cable Onda, S.A." },
	{ 14572, "Claro Panamá, S.A." },
	{ 14573, "Claro Panamá S.A." },
	{ 14574, "Telefónica Móviles de Panamá" },
	{ 14576, "Digicel MG INT" },
	{ 14577, "Digicel MG INT" },
	{ 14578, "Cable Onda, S.A." },
	{ 14579, "Telefónica Móviles de Panamá" },
	{ 14580, "Digicel MG INT" },
	{ 14581, "Telefónica Móviles de Panamá" },
	{ 14582, "Telefónica Móviles de Panamá" },
	{ 14584, "Telecomunicaciones NetUno de Panama SA" },
	{ 14585, "Digicel (Panama), S.A." },
	{ 14586, "Digicel (Panama), S.A." },
	{ 14587, "Telefónica Móviles de Panamá" },
	{ 14588, "Telefónica Móviles de Panamá" },
	{ 14589, "Digicel (Panama), S.A." },
	{ 14590, "Telefónica Móviles Panamá, S.A." },
	{ 14591, "Cable and Wireless Panama S.A." },
	{ 14592, "Telefónica del Perú S.A.A." },
	{ 14593, "Telefónica del Perú S.A.A." },
	{ 14594, "Telefónica del Perú S.A.A." },
	{ 14595, "Telefónica del Perú S.A.A." },
	{ 14596, "Telefónica del Perú S.A.A." },
	{ 14597, "América Móvil Perú S.A.C." },
	{ 14598, "Gilat To Home Perú S.A." },
	{ 14599, "Ormeño Comunicaciones S.A." },
	{ 14600, "Infoductos y Telecomunicaciones del Perú S.A." },
	{ 14601, "Gamacom S.A.C." },
	{ 14602, "Compañia Telefónica Andina S.A." },
	{ 14603, "Entel Perú S.A." },
	{ 14604, "Telefónica del Perú S.A.A." },
	{ 14605, "Biper Express S.A." },
	{ 14606, "NetLine Perú S.A." },
	{ 14607, "Americatel Perú S.A." },
	{ 14608, "Level 3 Perú S.A." },
	{ 14609, "Telefónica del Perú S.A.A." },
	{ 14610, "Telefónica del Perú S.A.A." },
	{ 14611, "Telefónica del Perú S.A.A." },
	{ 14612, "Telefónica del Perú S.A.A." },
	{ 14613, "Convergía S.A." },
	{ 14614, "Telefónica del Perú S.A.A." },
	{ 14615, "Viettel Perú S.A.C." },
	{ 14616, "Vitcom Perú S.A." },
	{ 14617, "Telefónica del Perú S.A.A." },
	{ 14618, "Telefónica del Perú S.A.A." },
	{ 14619, "Telefónica del Perú S.A.A." },
	{ 14620, "System One World Communication Perú S.A." },
	{ 14621, "Velatel Perú S.A." },
	{ 14622, "Elnath S.A." },
	{ 14623, "Level 3 Perú S.A." },
	{ 14624, "Level 3 Perú S.A." },
	{ 14625, "Backbone Perú S.A." },
	{ 14626, "América Móvil Perú S.A.C." },
	{ 14627, "GLG Perú S.A.C." },
	{ 14628, "América Móvil Perú S.A.C." },
	{ 14629, "Etelix.Com Perú S.A.C." },
	{ 14630, "TE.SA.M. Perú S.A." },
	{ 14631, "Americatel Perú S.A." },
	{ 14632, "América Móvil Perú S.A.C." },
	{ 14633, "IDT Perú srl" },
	{ 14634, "Entel Perú S.A." },
	{ 14635, "Viettel Perú S.A.C." },
	{ 14636, "Entel Perú S.A." },
	{ 14637, "BT LATAM PERU S.A.C." },
	{ 14638, "Level 3 Perú S.A." },
	{ 14639, "TE.SA.M. Perú S.A." },
	{ 14640, "LA. & C. SISTEMAS S.A." },
	{ 14641, "Telefónica del Perú S.A.A." },
	{ 14642, "IDT Perú srl" },
	{ 14643, "Americatel Perú S.A." },
	{ 14644, "América Móvil Perú S.A.C." },
	{ 14645, "América Móvil Perú S.A.C." },
	{ 14646, "Inversiones Peruanas en Telecomunicaciones S.A.C." },
	{ 14647, "AMITEL TELECOMUNICACIONES S.A.C." },
	{ 14648, "Entel Perú S.A." },
	{ 14649, "Entel Perú S.A." },
	{ 14650, "Entel Perú S.A." },
	{ 14651, "INVERSIONES OSA S.A.C." },
	{ 14652, "GLOBAL BACKBONE S.A.C." },
	{ 14653, "COLINANET S.R.L." },
	{ 14654, "América Móvil Perú S.A.C." },
	{ 14655, "América Móvil Perú S.A.C." },
	{ 14656, "TESAM ARGENTINA S.A." },
	{ 14657, "AMX Argentina S.A. (ex CTI Compañia de Teléfonos del Interior S.A.)" },
	{ 14664, "Impsat S.A." },
	{ 14665, "Impsat S.A." },
	{ 14666, "Telefónica Comunicaciones Personales S.A." },
	{ 14667, "Telefónica Comunicaciones Personales S.A." },
	{ 14668, "Telecom Argentina S.A." },
	{ 14669, "Cableway S.A." },
	{ 14670, "Comte Communications Technology S.A." },
	{ 14671, "AMX Argentina S.A. (ex CTI Compañia de Teléfonos del Interior S.A.)" },
	{ 14672, "Tecoar S.A." },
	{ 14673, "Red Alternativa S.A." },
	{ 14674, "Telecom Personal S.A." },
	{ 14675, "Telecom Personal S.A." },
	{ 14676, "Techtel LMDS Comunicaciones Interactivas S.A." },
	{ 14677, "AT&T Argentina S.A." },
	{ 14678, "AT&T Argentina S.A." },
	{ 14679, "AT&T Argentina S.A." },
	{ 14680, "Nodalis s.p.a." },
	{ 14681, "DKA S.A." },
	{ 14682, "IDT Corporation de Argentina S.A." },
	{ 14683, "Wilson Construcciones S.A." },
	{ 14684, "GC SAC Argentina s.r.l." },
	{ 14685, "Infonexión Argentina S.A." },
	{ 14686, "Colubris S.A." },
	{ 14687, "Telesmart S.A." },
	{ 14688, "Telecom Argentina STET France Telecom S.A." },
	{ 14689, "Telefónica Larga Distancia de Argentina S.A. (TLDA)" },
	{ 14690, "Telecom Argentina STET France Telecom S.A." },
	{ 14691, "Telefónica Larga Distancia de Argentina S.A. (TLDA)" },
	{ 14692, "Telecom Argentina STET France Telecom S.A." },
	{ 14693, "Telefónica Larga Distancia de Argentina S.A. (TLDA)" },
	{ 14694, "Telecom Argentina STET France Telecom S.A." },
	{ 14695, "Telefónica Larga Distancia de Argentina S.A. (TLDA)" },
	{ 14696, "Compañía de Teléfonos Del Plata S.A." },
	{ 14697, "Compañía de Teléfonos Del Plata S.A." },
	{ 14698, "Compañía de Teléfonos Del Plata S.A." },
	{ 14699, "Compañía de Telecomunicaciones Integrales S.A." },
	{ 14700, "Compañía de Telecomunicaciones Integrales S.A." },
	{ 14701, "Compañía de Telecomunicaciones Integrales S.A." },
	{ 14702, "Compañía de Telecomunicaciones Integrales S.A." },
	{ 14703, "Orbistel S.A." },
	{ 14704, "AT&T Argentina S.A." },
	{ 14705, "AT&T Argentina S.A." },
	{ 14706, "Superfone S.A." },
	{ 14707, "SES Sistemas Electrónicos S.A." },
	{ 14708, "Techtel S.A." },
	{ 14709, "Metrored Telecomunicaciones S.A." },
	{ 14710, "Impsat S.A." },
	{ 14711, "Impsat S.A." },
	{ 14712, "Diveo Argentina S.A." },
	{ 14713, "Diveo Argentina S.A." },
	{ 14714, "Comsat Argentina S.A." },
	{ 14715, "Comsat Argentina S.A." },
	{ 14716, "NSS S.A." },
	{ 14717, "TTN S.A." },
	{ 14718, "Embratel Internacional S.A." },
	{ 14719, "Convergia Argentina S.A." },
	{ 14720, "Vivo" },
	{ 14721, "EMBRATEL" },
	{ 14722, "Transit" },
	{ 14723, "Primeira Escolha" },
	{ 14724, "EMBRATEL" },
	{ 14725, "Claro" },
	{ 14726, "Claro" },
	{ 14727, "Telefónica" },
	{ 14728, "Intelig" },
	{ 14729, "Intelig" },
	{ 14730, "Brasil Telecom" },
	{ 14731, "Telemig Celular" },
	{ 14732, "Telemig Celular" },
	{ 14733, "Globalstar Brasil" },
	{ 14734, "Intelig" },
	{ 14735, "Intelig" },
	{ 14736, "Telefónica" },
	{ 14737, "EMBRATEL" },
	{ 14738, "Globalstar Brasil" },
	{ 14739, "EMBRATEL" },
	{ 14740, "TNL PCS - Oi" },
	{ 14741, "Brasil Telecom" },
	{ 14742, "Telefónica" },
	{ 14743, "Telefónica" },
	{ 14744, "TIM" },
	{ 14745, "TNL PCS - Oi" },
	{ 14746, "TNL PCS - Oi" },
	{ 14747, "TIM" },
	{ 14748, "SERMATEL" },
	{ 14749, "Brasil Telecom" },
	{ 14750, "Brasil Telecom" },
	{ 14751, "Brasil Telecom" },
	{ 14752, "Brasil Telecom" },
	{ 14753, "Vivo" },
	{ 14754, "Telefónica" },
	{ 14755, "Telefónica" },
	{ 14756, "TNL PCS - Oi" },
	{ 14757, "Telemig Celular" },
	{ 14758, "Telemig Celular" },
	{ 14759, "TNL PCS - Oi" },
	{ 14760, "Vivo" },
	{ 14761, "TNL PCS - Oi" },
	{ 14762, "TNL PCS - Oi" },
	{ 14763, "TNL PCS - Oi" },
	{ 14764, "Vivo" },
	{ 14765, "CTBC Celular" },
	{ 14766, "TIM" },
	{ 14767, "TIM" },
	{ 14768, "Claro" },
	{ 14769, "TIM" },
	{ 14770, "TIM" },
	{ 14771, "CTBC Celular" },
	{ 14772, "TNL PCS - Oi" },
	{ 14773, "Brasil Telecom" },
	{ 14774, "Brasil Telecom" },
	{ 14775, "BT Communications" },
	{ 14776, "BT Communications" },
	{ 14777, "TNL PCS - Oi" },
	{ 14778, "TNL PCS - Oi" },
	{ 14779, "Claro" },
	{ 14780, "EMBRATEL" },
	{ 14781, "NEXTEL (SMP)" },
	{ 14782, "NEXTEL (SMP)" },
	{ 14783, "NEXTEL (SMP)" },
	{ 14785, "TIM" },
	{ 14786, "TIM" },
	{ 14787, "Claro" },
	{ 14788, "Claro" },
	{ 14789, "DATORA" },
	{ 14808, "Compañia de Telecomunicaciones de Chile Transmisiones Regionales S.A." },
	{ 14809, "Compañia de Telecomunicaciones de Chile Transmisiones Regionales S.A." },
	{ 14810, "IFX Larga Distancia Chile S.A." },
	{ 14811, "Telecomunicaciones Las Perdices S.A." },
	{ 14812, "Telephone2 S.A." },
	{ 14813, "TransAm S.A." },
	{ 14814, "Conect S.A." },
	{ 14815, "Conect S.A." },
	{ 14816, "CTC Transmisiones Regionales, S.A." },
	{ 14817, "Chilesat S.A." },
	{ 14818, "Empresa Nacional de Telecomunicaciones S.A. (ENTEL-CHILE)" },
	{ 14819, "Empresa Nacional de Telecomunicaciones S.A. (ENTEL-CHILE)" },
	{ 14820, "V.T.R. Telecomunicaciones S.A." },
	{ 14821, "Bellsouth Chile S.A." },
	{ 14822, "Compañia de Telefonos de Chile - Mundo S.A." },
	{ 14823, "IUSATEL Chile S.A." },
	{ 14824, "CTC Transmisiones Regionales, S.A." },
	{ 14825, "Manquehue Telecomunicaciones Larga Distancia" },
	{ 14826, "AT&T Chile S.A." },
	{ 14827, "PTT Chile S.A." },
	{ 14828, "Bellsouth Chile S.A." },
	{ 14829, "Bellsouth Chile S.A." },
	{ 14830, "Entel S.A." },
	{ 14831, "Entel S.A." },
	{ 14832, "Inversiones y Comunicaciones S.A." },
	{ 14833, "World Change Communications S.A." },
	{ 14834, "Inversiones y Comunicaciones S.A." },
	{ 14835, "The Telephone Company S.A." },
	{ 14836, "Entel S.A." },
	{ 14837, "Global One Communications S.A." },
	{ 14838, "Sur Comunicaciones S.A." },
	{ 14839, "Conexión Chile S.A." },
	{ 14840, "VTR Globalcarrier S.A." },
	{ 14841, "VTR Globalcarrier S.A." },
	{ 14842, "Conect S.A." },
	{ 14848, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14849, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14850, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14851, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14852, "ORBITEL S.A. ESP" },
	{ 14853, "ORBITEL S.A. ESP" },
	{ 14854, "EMPRESA DE TELECOMUNICACIONES DE BOGOTÁ S.A. ESP." },
	{ 14855, "EMPRESA DE TELECOMUNICACIONES DE BOGOTÁ S.A. ESP." },
	{ 14856, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14857, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14858, "ORBITEL S.A. ESP" },
	{ 14859, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14860, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14861, "AVANTEL S.A.S" },
	{ 14862, "AVANTEL S.A.S" },
	{ 14863, "AVANTEL S.A.S" },
	{ 14864, "INFRAESTRUCTURA CELULAR COLOMBIANA S A ESP" },
	{ 14865, "INFRAESTRUCTURA CELULAR COLOMBIANA S A ESP" },
	{ 14866, "TELMEX TELECOMUNICACIONES S.A. ESP" },
	{ 14867, "COMVOZ COMUNICACIONES DE COLOMBIA S.A. E.S.P." },
	{ 14868, "AVANTEL S.A.S" },
	{ 14869, "COLOMBIA MOVIL S.A. E.S.P." },
	{ 14870, "COLOMBIA MOVIL S.A. E.S.P." },
	{ 14871, "COLOMBIA MOVIL S.A. E.S.P." },
	{ 14872, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14873, "AVANTEL LD SA ESP" },
	{ 14874, "GRUPO TELINTEL SA EMPRESA DE SERVICIOS PUBLICOS" },
	{ 14875, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14876, "TECHNOLOGY SA ESP" },
	{ 14877, "AVANTEL S.A.S" },
	{ 14878, "COLOMBIA TELECOMUNICACIONES S.A. ESP" },
	{ 14879, "AVANTEL S.A.S" },
	{ 14881, "Compañía Anónima Nacional Teléfonos de Venezuela (CANTV)" },
	{ 14882, "Compañía Anónima Nacional Teléfonos de Venezuela (CANTV)" },
	{ 14883, "Compañía Anónima Nacional Teléfonos de Venezuela (CANTV)" },
	{ 14885, "TESAM de Venezuela, C.A." },
	{ 14886, "Corporación Digitel, C.A." },
	{ 14887, "Infonet Redes de Información, C.A." },
	{ 14888, "Digicel, C.A." },
	{ 14889, "Telcel Celular, C.A." },
	{ 14890, "Telecomunicaciones NGTV, S.A. (new Global Telecom)" },
	{ 14891, "Veninfotel Comunicaciones Vitcom, C.A." },
	{ 14892, "Compañía Anónima Nacional Teléfonos de Venezuela (CANTV)" },
	{ 14893, "Compañía Anónima Nacional Teléfonos de Venezuela (CANTV)" },
	{ 14894, "Entel Venezuela, C.A." },
	{ 14895, "Entel Venezuela, C.A." },
	{ 14896, "LDTeleCom Comunicaciones, C.A." },
	{ 14897, "Convergia Venezuela, SA" },
	{ 14898, "Convergia Venezuela, SA" },
	{ 14899, "Veninfotel Comunicaciones Vitcom, C.A." },
	{ 14900, "Corporación Telemig CA (INTERCABLE)" },
	{ 14901, "Telcel Celular, C.A." },
	{ 14902, "Multiphone Venezuela C.A." },
	{ 14903, "Compañía Anónima Nacional Teléfonos de Venezuela (CANTV)" },
	{ 14904, "Telecomunicaciones Movilnet, CA" },
	{ 14905, "Telecomunicaciones Movilnet, CA" },
	{ 14906, "Corporación Digitel, C.A." },
	{ 14907, "Corporación Digitel, C.A." },
	{ 14908, "Veninfotel Comunicaciones Vitcom, C.A." },
	{ 14909, "Soluciones Latincom,C.A." },
	{ 14910, "TELEFÓNICA VENEZOLANA, C.A." },
	{ 14911, "TELEFÓNICA VENEZOLANA, C.A." },
	{ 14912, "ENTEL S.A." },
	{ 14913, "ENTEL S.A." },
	{ 14914, "COTAS LTDA" },
	{ 14915, "ENTEL S.A." },
	{ 14916, "AES Communications Bolivia S.A." },
	{ 14917, "ENTEL S.A." },
	{ 14918, "COTAS LTDA" },
	{ 14919, "AES Communications Bolivia S.A." },
	{ 14920, "BOLIVIATEL SA" },
	{ 14921, "BOLIVIATEL SA" },
	{ 14922, "BOLIVIATEL SA" },
	{ 14923, "Nuevatel" },
	{ 14924, "Nuevatel" },
	{ 14925, "Nuevatel" },
	{ 14926, "COTEL LTDA" },
	{ 14927, "COTEL LTDA" },
	{ 14928, "COTEL LTDA" },
	{ 14929, "UTECOM SA" },
	{ 14930, "TELECEL SA" },
	{ 14931, "UNETE LTDA" },
	{ 14932, "COTAS LTDA" },
	{ 14933, "Transmedes S.A." },
	{ 14934, "Transmedes S.A." },
	{ 14935, "Transmedes S.A." },
	{ 14936, "Hablando Todos s.r.l." },
	{ 14937, "Hablando Todos s.r.l." },
	{ 14938, "Hablando Todos s.r.l." },
	{ 14939, "Bolitel s.r.l." },
	{ 14940, "Bolitel s.r.l." },
	{ 14941, "Bolitel s.r.l." },
	{ 14942, "ENTEL S.A." },
	{ 14943, "ENTEL S.A." },
	{ 14944, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14945, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14946, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14947, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14948, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14949, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14950, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14951, "Guyana Telephone and Telegraph Co. Ltd." },
	{ 14976, "Andinatel S.A." },
	{ 14977, "Pacifictel S.A." },
	{ 14978, "Pacifictel S.A." },
	{ 14979, "Conecel S.A." },
	{ 14980, "Conecel S.A." },
	{ 14981, "Conecel S.A." },
	{ 14982, "Otecel S.A." },
	{ 14983, "Otecel S.A." },
	{ 14984, "Telecsa S.A." },
	{ 14985, "Etapa Telecom S.A." },
	{ 14986, "Setel S.A." },
	{ 14987, "Andinatel S.A." },
	{ 14988, "Etapa Telecom S.A." },
	{ 14990, "Conecel S.A." },
	{ 14991, "Otecel S.A." },
	{ 14992, "Otecel S.A." },
	{ 14993, "Ecuador Telecom S.A." },
	{ 14994, "Telecsa S.A." },
	{ 14995, "Telecsa S.A." },
	{ 15009, "Dauphin Télécom" },
	{ 15040, "Copaco S.A." },
	{ 15041, "Hola Paraguay S.A." },
	{ 15042, "Amx Paraguay S.A." },
	{ 15043, "Telecel S.A." },
	{ 15044, "Núcleo S.A." },
	{ 15045, "Copaco S.A." },
	{ 15046, "Núcleo S.A." },
	{ 15047, "Núcleo S.A." },
	{ 15048, "Núcleo S.A." },
	{ 15049, "Telecel S.A." },
	{ 15050, "Telecel S.A." },
	{ 15052, "Copaco S.A." },
	{ 15053, "Copaco S.A." },
	{ 15072, "Telesur" },
	{ 15073, "Telesur" },
	{ 15074, "Telesur" },
	{ 15075, "Telesur" },
	{ 15078, "Digicel" },
	{ 15079, "Digicel" },
	{ 15105, "Administración Nacional de Telecomunicaciones (ANTEL)" },
	{ 15106, "Administración Nacional de Telecomunicaciones (ANTEL)" },
	{ 15107, "Administración Nacional de Telecomunicaciones (ANTEL)" },
	{ 15108, "Administración Nacional de Telecomunicaciones (ANTEL)" },
	{ 15109, "Telefónica Móviles del Uruguay S.A." },
	{ 15110, "AMINET S.A." },
	{ 15111, "Telstar S.A." },
	{ 15112, "Administración Nacional de Telecomunicaciones (ANTEL)" },
	{ 15114, "Telefónica Móviles del Uruguay S.A." },
	{ 15115, "Telefónica Móviles del Uruguay S.A." },
	{ 15116, "Telefónica Móviles del Uruguay S.A." },
	{ 15129, "Cable & Wireless" },
	{ 15130, "Cable & Wireless" },
	{ 15136, "TOP COMUNICATIONS ESTEGIA, C.A." },
	{ 15216, "LIBRE TECNOLOGIAS S.A.S" },
	{ 15217, "SETROC MOBILE GROUP SAS" },
	{ 15218, "SETROC MOBILE GROUP SAS" },
	{ 15536, "ENTEL S.A." },
	{ 15537, "COTAS LTDA" },
	{ 15538, "ENTEL S.A." },
	{ 15539, "ENTEL S.A." },
	{ 15540, "ENTEL S.A." },
	{ 15541, "ENTEL S.A." },
	{ 15542, "ENTEL S.A." },
	{ 15543, "ENTEL S.A." },
	{ 15544, "ENTEL S.A." },
	{ 15545, "ENTEL S.A." },
	{ 15546, "ENTEL S.A." },
	{ 15547, "ECOM S.A." },
	{ 15548, "AVTEL S.A." },
	{ 15549, "TELECEL SA" },
	{ 15550, "TELECEL SA" },
	{ 15551, "TELECEL SA" },
	{ 15552, "TELECEL SA" },
	{ 15553, "TELECEL SA" },
	{ 15554, "TELECEL SA" },
	{ 15555, "TELECEL SA" },
	{ 15556, "TELECEL SA" },
	{ 15557, "TELECEL SA" },
	{ 15558, "TELECEL SA" },
	{ 15559, "TELECEL SA" },
	{ 15616, "Viettel Perú S.A.C." },
	{ 15617, "Viettel Perú S.A.C." },
	{ 15618, "Entel Perú S.A." },
	{ 15619, "Entel Perú S.A." },
	{ 15620, "Entel Perú S.A." },
	{ 15621, "Entel Perú S.A." },
	{ 15622, "América Móvil Perú S.A.C." },
	{ 15623, "América Móvil Perú S.A.C." },
	{ 15992, "Monty UK Global Limited" },
	{ 15993, "Monty UK Global Limited" },
	{ 15994, "SMS Provider Corp." },
	{ 15995, "Monty UK Global Limited" },
	{ 15996, "Monty UK Global Limited" },
	{ 15997, "BSG Estonia OÜ" },
	{ 15998, "Fink Telecom Services" },
	{ 15999, "Fink Telecom Services" },
	{ 16048, "Telecom of Kosovo* J.S.C" },
	{ 16049, "Telecom of Kosovo* J.S.C" },
	{ 16050, "Telecom of Kosovo* J.S.C" },
	{ 16051, "IPKO Telecommunications LLC" },
	{ 16052, "IPKO Telecommunications LLC" },
	{ 16053, "IPKO Telecommunications LLC" },
	{ 16054, "Kujtesa.Net LLC" },
	{ 16055, "mts D.O.O." },
	{ 16064, "EMPRESA DE TELECOMUNICACIONES DE BOGOTÁ S.A. ESP." },
	{ 16065, "EMPRESA DE TELECOMUNICACIONES DE BOGOTÁ S.A. ESP." },
	{ 16066, "LLEIDA S.A.S." },
	{ 16067, "COMUNICACION CELULAR S.A." },
	{ 16068, "COMUNICACION CELULAR S.A." },
	{ 16069, "AVANTEL S.A.S" },
	{ 16070, "AVANTEL S.A.S" },
	{ 16071, "LIBRE TECNOLOGIAS S.A.S" },
	{ 16072, "ICE Communication Norge AS" },
	{ 16073, "ICE Communication Norge AS" },
	{ 16074, "ICE Communication Norge AS" },
	{ 16075, "ICE Communication Norge AS" },
	{ 16076, "Iristel Norway AS" },
	{ 16088, "Pegasus Communications Sh.p.k." },
	{ 16089, "Albanian Telecommunication Partners sh.p.k" },
	{ 16090, "Proton Communication Sh.p.k" },
	{ 16092, "UNIFI Holdings INC Dega në Shqiperi" },
	{ 16093, "BLETA ALBANIA" },
	{ 16096, "e-LUX Mobile Telecommunication Services S.A." },
	{ 16097, "Orange Communications Luxembourg S.A." },
	{ 16098, "Orange Communications Luxembourg S.A." },
	{ 16104, "Bulgarian Telecommunication Company" },
	{ 16105, "Rutelcom" },
	{ 16106, "T.com" },
	{ 16107, "T.com" },
	{ 16108, "Bulsatcom" },
	{ 16109, "Bulgarian Telecommunication Company" },
	{ 16110, "Bulgarian Telecommunication Company" },
	{ 16112, "Melita PLC" },
	{ 16128, "VODAFONE LIMITED" },
	{ 16129, "Neutrino Networks Limited" },
	{ 16130, "Neutrino Networks Limited" },
	{ 16136, "BodyTrace Netherlands B.V." },
	{ 16137, "BodyTrace Netherlands B.V." },
	{ 16138, "KPN B.V." },
	{ 16139, "KPN B.V." },
	{ 16140, "Ziggo B.V." },
	{ 16141, "Ziggo B.V." },
	{ 16142, "TISMI B.V." },
	{ 16143, "ASpider Solutions Nederland B.V." },
	{ 16144, "WIND" },
	{ 16145, "WIND" },
	{ 16146, "WIND" },
	{ 16147, "WIND" },
	{ 16148, "WIND" },
	{ 16149, "WIND" },
	{ 16150, "WIND" },
	{ 16151, "WIND" },
	{ 16160, "Comfone AG" },
	{ 16161, "Comfone AG" },
	{ 16162, "Sunrise Communications AG" },
	{ 16163, "Sunrise Communications AG" },
	{ 16164, "Global Message Services AG" },
	{ 16165, "Telecom26 AG" },
	{ 16166, "Telecom26 AG" },
	{ 16171, "Atlas Interactive Group Limited" },
	{ 16172, "Truphone Ltd" },
	{ 16173, "Inmarsat Global Limited" },
	{ 16174, "Inmarsat Global Limited" },
	{ 16175, "Samitel Limited" },
	{ 16176, "UAB Tele2" },
	{ 16177, "UAB Tele2" },
	{ 16178, "UAB Tele2" },
	{ 16179, "UAB Tele2" },
	{ 16180, "UAB Mediafon" },
	{ 16184, "Phonero AS" },
	{ 16185, "Phonero AS" },
	{ 16186, "Phonero AS" },
	{ 16187, "Phonero AS" },
	{ 16188, "Bane NOR SF" },
	{ 16189, "Bane NOR SF" },
	{ 16190, "Bane NOR SF" },
	{ 16191, "Bane NOR SF" },
	{ 16192, "Telefonica UK Limited" },
	{ 16193, "Telefonica UK Limited" },
	{ 16194, "KDDI Europe Limited" },
	{ 16195, "JT (Jersey) Limited" },
	{ 16196, "Telefonica UK Limited" },
	{ 16197, "Telefonica UK Limited" },
	{ 16198, "JT (Jersey) Limited" },
	{ 16199, "Telefonica UK Limited" },
	{ 16211, "Samitel Limited" },
	{ 16212, "Bangla Trac Communication Ltd" },
	{ 16214, "Stour Marine Limited" },
	{ 16215, "Stour Marine Limited" },
	{ 16216, "HT d.d." },
	{ 16217, "OPTIKA KABEL TV d.o.o." },
	{ 16218, "OPTIKA KABEL TV d.o.o." },
	{ 16219, "Akton d.o.o." },
	{ 16220, "VIPnet d.o.o." },
	{ 16221, "VIPnet d.o.o." },
	{ 16222, "VIPnet d.o.o." },
	{ 16223, "TERRAKOM d.o.o." },
	{ 16224, "BT España Compañía de servicios globales de telecomunicaciones, S.A.U." },
	{ 16226, "Xfera Móviles S.A." },
	{ 16227, "Xfera Móviles S.A." },
	{ 16228, "Digi Spain Telecom, S.L." },
	{ 16229, "Digi Spain Telecom, S.L." },
	{ 16234, "PTGI International Carrier Services Ltd" },
	{ 16235, "Tata Communications (UK) Ltd" },
	{ 16236, "Tata Communications (UK) Ltd" },
	{ 16237, "Tata Communications (UK) Ltd" },
	{ 16238, "Tata Communications (UK) Ltd" },
	{ 16240, "Transatel" },
	{ 16241, "SFR" },
	{ 16242, "Symacom" },
	{ 16243, "Bouygues Telecom" },
	{ 16244, "Bouygues Telecom" },
	{ 16245, "Bouygues Telecom" },
	{ 16246, "Bouygues Telecom" },
	{ 16247, "Bouygues Telecom" },
	{ 16248, "Slovak Telekom, a.s." },
	{ 16249, "Telefónica O2 Slovakia, s.r.o." },
	{ 16250, "Telefónica O2 Slovakia, s.r.o." },
	{ 16256, "NextGenTel AS" },
	{ 16257, "Verizon Norway AS" },
	{ 16258, "Com4 AS" },
	{ 16260, "Telenor Global Services AS" },
	{ 16261, "Telenor Global Services AS" },
	{ 16262, "Telia Norge AS" },
	{ 16263, "Telia Norge AS" },
	{ 16264, "KPN SPAIN,S.L. UNIPERSONAL" },
	{ 16265, "Vodafone España S.A.U." },
	{ 16266, "Vodafone España S.A.U." },
	{ 16267, "Vodafone España S.A.U." },
	{ 16268, "Vodafone España S.A.U." },
	{ 16271, "Digi Spain Telecom, S.L." },
	{ 16273, "JSC ""Kyivstar""" },
	{ 16275, "PrJSC ""Farlep-Invest""" },
	{ 16276, "JSC ""Intertelekom""" },
	{ 16277, "Lifecell LLC" },
	{ 16278, "Ukrtelecom JSC" },
	{ 16279, "Lifecell LLC" },
	{ 16280, "Cloud9 Communications Limited" },
	{ 16281, "Cloud9 Communications Limited" },
	{ 16282, "VODAFONE LIMITED" },
	{ 16283, "VODAFONE LIMITED" },
	{ 16284, "VODAFONE LIMITED" },
	{ 16285, "VODAFONE LIMITED" },
	{ 16287, "Wireless Solutions International" },
	{ 16288, "Orange Polska S.A." },
	{ 16289, "T-MOBILE POLSKA S.A." },
	{ 16290, "T-MOBILE POLSKA S.A." },
	{ 16291, "P4 Sp. z o.o." },
	{ 16292, "P4 Sp. z o.o." },
	{ 16293, "P4 Sp. z o.o." },
	{ 16294, "P4 Sp. z o.o." },
	{ 16295, "POLKOMTEL Sp. z o.o." },
	{ 16296, "ECO Networks" },
	{ 16297, "Simfree" },
	{ 16298, "Tele2" },
	{ 16299, "Tele2" },
	{ 16300, "MWTV" },
	{ 16301, "TG Transit" },
	{ 16302, "Camel Mobile" },
	{ 16303, "Advem" },
	{ 16304, "T-MOBILE POLSKA S.A." },
	{ 16305, "POLKOMTEL Sp. z o.o." },
	{ 16306, "T-MOBILE POLSKA S.A." },
	{ 16307, "Galena Sp. z o.o." },
	{ 16308, "Orange Polska S.A." },
	{ 16309, "AMD Telecom S.A." },
	{ 16310, "P4 Sp. z o.o." },
	{ 16311, "Aero 2 Sp. z o.o." },
	{ 16312, "Comunica I.T. Services" },
	{ 16313, "Global Message Services AG" },
	{ 16314, "IVY Telecom SA" },
	{ 16315, "Comunica I.T. Services" },
	{ 16316, "Horisen AG" },
	{ 16317, "Netstream AG" },
	{ 16318, "UPC Schweiz GmbH" },
	{ 16319, "UPC Schweiz GmbH" },
	{ 16320, "Atlas Telecom Interactive" },
	{ 16321, "UPC Romania" },
	{ 16322, "GTS Telecom" },
	{ 16323, "CNCF CFR" },
	{ 16324, "Alizee Telecom Network" },
	{ 16325, "Orange Romania" },
	{ 16326, "NetConnect Internet" },
	{ 16327, "A1 Telecom Network ISP" },
	{ 16331, "Dentel Netzwerk Telefonie GmbH" },
	{ 16334, "Teleplus Communications Ltd" },
	{ 16335, "Communication Services Tele2 GmbH" },
	{ 16336, "Datu Tikli" },
	{ 16337, "TELEGLOBAL" },
	{ 16338, "TG Transit" },
	{ 16339, "Sigis" },
	{ 16340, "MPE NETS" },
	{ 16341, "Interneta pasaule" },
	{ 16342, "Rigatta" },
	{ 16343, "Adamasto" },
	{ 16344, "Telefonica UK Limited" },
	{ 16346, "EE Limited (Orange)" },
	{ 16347, "Telefonica UK Limited" },
	{ 16348, "Idt Global Ltd" },
	{ 16349, "VODAFONE LIMITED" },
	{ 16350, "VODAFONE LIMITED" },
	{ 16352, "UAB Tele2 fiksuotas rysys" },
	{ 16353, "UAB Omnitel" },
	{ 16354, "UAB CSC Telecom" },
	{ 16355, "UAB Telekomunikaciju grupa" },
	{ 16356, "UAB Tele2" },
	{ 16357, "UAB Nacionanalinis telekomunikaciju tinklas" },
	{ 16358, "AB Lietuvos gelezinkeliai" },
	{ 16359, "UAB Omnitel" },
	{ 16360, "TalkTalk Communications Limited" },
	{ 16362, "VODAFONE LIMITED" },
	{ 16363, "Inmarsat Global Limited" },
	{ 16364, "Telefonica UK Limited" },
	{ 16365, "Modus Telecom Ltd" },
	{ 16366, "Telefonica UK Limited" },
	{ 16367, "Telefonica UK Limited" },
	{ 16368, "Vodafone España S.A.U." },
	{ 16369, "Vodafone España S.A.U." },
	{ 16371, "Marin Telecom, S.L.U." },
	{ 16376, "Orange (Liechtenstein) AG" },
	{ 16377, "First Mobile AG" },
	{ 16378, "First Mobile AG" },
	{ 16379, "iMetrik Global (Europe) AG" },
	{ 16380, "Cubic AG" },
	{ 16381, "Cubic AG" },
	{ 16382, "Cubic AG" },
	{ 16383, "Cubic AG" },
	{  0, NULL }
};

static value_string_ext q708_ispc_point_name_ext = VALUE_STRING_EXT_INIT(q708_ispc_point_name);
static value_string_ext q708_ispc_operator_name_ext = VALUE_STRING_EXT_INIT(q708_ispc_operator_name);
static value_string_ext q708_sanc_areas_ext = VALUE_STRING_EXT_INIT(q708_sanc_areas);

/*
 * International signalling point codes (i.e. PCs with ni = 0) are allocated by the ITU,
 * according to the processes described in Q.708. ITU keeps a database of all registered
 * ISPCs which is publically available, with updates being provided in the operational
 * bulletins. This function takes an ISPC and analyzes it according to these tables.
 */
void
analyze_q708_ispc(tvbuff_t *tvb, proto_tree *tree, int offset, int length, guint16 ispc)
{
	guint16 sanc;

	sanc = ispc >> 3;

	proto_tree_add_uint_format_value(tree, hf_q708_sanc, tvb, offset, length, sanc,
		"%s (%u-%03u)",
		val_to_str_ext_const(sanc, &q708_sanc_areas_ext, "Unknown"),
		sanc >> 8, sanc & 0xff);
	proto_tree_add_string(tree, hf_q708_ispc_name, tvb, offset, length,
		val_to_str_ext_const(ispc, &q708_ispc_point_name_ext, "Unknown"));
	proto_tree_add_string(tree, hf_q708_ispc_operator_name, tvb, offset, length,
		val_to_str_ext_const(ispc, &q708_ispc_operator_name_ext, "Unknown"));
}

void
proto_register_q708(void)
{
	static hf_register_info hf[] = {
	{ &hf_q708_sanc,
		{ "Signalling Area Network Code (SANC)","q708.sanc",
		FT_UINT16, BASE_DEC | BASE_EXT_STRING, &q708_sanc_areas_ext, 0x0,
		NULL, HFILL }
	},
	{ &hf_q708_ispc_name,
		{ "Unique Signalling Point Name","q708.ispc_name",
		FT_STRING, BASE_NONE, NULL, 0x0,
		NULL, HFILL }
	},
	{ &hf_q708_ispc_operator_name,
		{ "Signalling Point Operator Name", "q708.ispc_operator_name",
		FT_STRING, BASE_NONE, NULL, 0,
		NULL, HFILL }},
	};

	/*
	 * Register the protocol name and description
	 */
	proto_q708 = proto_register_protocol("ITU-T Q.708 ISPC Analysis", "Q.708", "q708");

	/*
	 * Required function calls to register
	 * the header fields and subtrees used.
	 */
	proto_register_field_array(proto_q708, hf, array_length(hf));

}

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: t
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 noexpandtab:
 * :indentSize=8:tabSize=8:noTabs=false:
 */
