/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;

public class AnimatorTool
extends ObjectConstructor
implements Runnable,
Selector {
    PointObject P;
    Vector V;
    ZirkelCanvas ZC;
    boolean Running = false;
    boolean Interactive = true;
    boolean Complete = false;
    boolean Negative = false;
    boolean Original = false;
    double Delay = 50.0;
    boolean Stopped = false;

    public AnimatorTool() {
        this.V = new Vector();
        this.P = null;
    }

    public AnimatorTool(PointObject pointObject, Vector vector, ZirkelCanvas zirkelCanvas, boolean bl, boolean bl2, String string) {
        this.P = pointObject;
        if (!this.P.moveable()) {
            return;
        }
        this.V = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = zirkelCanvas.getConstruction().find((String)enumeration.nextElement());
            if (!(constructionObject instanceof SegmentObject || constructionObject instanceof PrimitiveCircleObject || constructionObject instanceof PointObject)) {
                return;
            }
            this.V.addElement(constructionObject);
        }
        this.Stopped = false;
        this.ZC = zirkelCanvas;
        this.Complete = true;
        this.Negative = bl;
        this.Original = bl2;
        try {
            this.Delay = 50.0;
            this.Delay = new Double(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(this).start();
    }

    public void setInteractive(boolean bl) {
        this.Interactive = bl;
    }

    @Override
    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        if (constructionObject instanceof CircleObject && ((CircleObject)constructionObject).getP2() == this.P) {
            return true;
        }
        return !zirkelCanvas.depends(constructionObject, this.P);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        if (this.P == null) {
            this.P = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            this.Complete = false;
            if (this.P != null && this.P.moveable()) {
                this.P.setSelected(true);
                zirkelCanvas.repaint();
                this.showStatus(zirkelCanvas);
            }
        } else {
            if (!this.Complete && this.Interactive) {
                boolean bl;
                ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
                if (constructionObject == null) {
                    return;
                }
                boolean bl2 = bl = constructionObject == this.P;
                if (!bl) {
                    Enumeration enumeration = this.V.elements();
                    while (enumeration.hasMoreElements()) {
                        if (constructionObject != enumeration.nextElement()) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    if (!(constructionObject instanceof SegmentObject || constructionObject instanceof PrimitiveCircleObject || constructionObject instanceof PointObject)) {
                        return;
                    }
                    constructionObject.setSelected(true);
                    this.V.addElement(constructionObject);
                    zirkelCanvas.repaint();
                    this.showStatus(zirkelCanvas);
                    return;
                }
            }
            if (!this.Running) {
                this.Stopped = false;
                this.ZC = zirkelCanvas;
                zirkelCanvas.clearSelected();
                this.Complete = true;
                zirkelCanvas.clearIndicated();
                this.showStatus(zirkelCanvas);
                new Thread(this).start();
            } else if (mouseEvent.isShiftDown()) {
                this.Negative = !this.Negative;
            } else {
                this.Stopped = true;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (this.Complete || !this.Interactive) {
            return;
        }
        if (this.P == null) {
            zirkelCanvas.indicatePointObjects(mouseEvent.getX(), mouseEvent.getY());
        } else {
            zirkelCanvas.indicateObjects(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public synchronized void reset(ZirkelCanvas zirkelCanvas) {
        this.Stopped = true;
        this.Complete = false;
        super.reset(zirkelCanvas);
        this.P = null;
        this.Delay = 50.0;
        this.V = new Vector();
        this.showStatus(zirkelCanvas);
        zirkelCanvas.repaint();
    }

    @Override
    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.animator.point"));
        } else if (!this.Complete) {
            zirkelCanvas.showStatus(Zirkel.name("message.animator.segment"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.animator.running"));
        }
    }

    public void save(XmlWriter xmlWriter) {
        if (this.P == null) {
            return;
        }
        xmlWriter.startTagStart("Animate");
        xmlWriter.printArg("animate", this.P.getName());
        int n = 0;
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((ConstructionObject)enumeration.nextElement()).getName();
            xmlWriter.printArg("via" + n, string);
            ++n;
        }
        if (this.Negative) {
            xmlWriter.printArg("negative", "true");
        }
        if (this.Delay != 50.0) {
            xmlWriter.printArg("delay", "" + this.Delay);
        }
        xmlWriter.finishTagNewLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l;
        this.ZC.resetSum();
        if (this.Original) {
            this.ZC.getConstruction().setOriginalOrder(true);
        }
        this.Running = true;
        this.showStatus(this.ZC);
        Enumeration enumeration = this.V.elements();
        double d2 = 0.001;
        boolean bl = true;
        ConstructionObject constructionObject = null;
        long l2 = l = System.currentTimeMillis();
        double d3 = Math.PI * 2;
        boolean bl2 = false;
        while (!this.Stopped) {
            try {
                long l3 = System.currentTimeMillis();
                int n = (int)(l3 - l);
                if (n < 0) {
                    n = 0;
                }
                if ((double)n > this.Delay) {
                    n = (int)this.Delay;
                }
                Thread.sleep((int)(this.Delay - (double)n));
                l = System.currentTimeMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.Stopped) break;
            if (this.ZC.I == null) continue;
            AnimatorTool animatorTool = this;
            synchronized (animatorTool) {
                ConstructionObject constructionObject2;
                if (bl) {
                    if (!enumeration.hasMoreElements()) {
                        enumeration = this.V.elements();
                    }
                    constructionObject = (ConstructionObject)enumeration.nextElement();
                    bl = false;
                    d2 = 1.0E-4;
                    if (constructionObject instanceof SegmentObject) {
                        d2 = 0.001 * ((SegmentObject)constructionObject).getLength();
                    } else if (constructionObject instanceof PrimitiveCircleObject) {
                        constructionObject2 = (PrimitiveCircleObject)constructionObject;
                        if (((PrimitiveCircleObject)constructionObject2).hasRange()) {
                            ((PrimitiveCircleObject)constructionObject2).computeA1A2();
                            d2 = ((PrimitiveCircleObject)constructionObject2).getA1();
                            d3 = ((PrimitiveCircleObject)constructionObject2).getA2();
                            if (d3 < d2) {
                                d3 += Math.PI * 2;
                            }
                            bl2 = false;
                        } else {
                            d2 = 1.0E-4 * ((PrimitiveCircleObject)constructionObject2).getR();
                        }
                    } else if (constructionObject instanceof PointObject) {
                        constructionObject2 = (PointObject)constructionObject;
                        ZirkelCanvas zirkelCanvas = this.ZC;
                        synchronized (zirkelCanvas) {
                            this.P.move(((PointObject)constructionObject2).getX(), ((PointObject)constructionObject2).getY());
                            this.ZC.dovalidate();
                        }
                        this.ZC.repaint();
                        l2 = System.currentTimeMillis();
                    }
                }
                if (constructionObject instanceof SegmentObject) {
                    constructionObject2 = (SegmentObject)constructionObject;
                    ZirkelCanvas zirkelCanvas = this.ZC;
                    synchronized (zirkelCanvas) {
                        if (bl2) {
                            this.P.move(((PrimitiveLineObject)constructionObject2).getP1().getX() + (((SegmentObject)constructionObject2).getLength() - d2) * ((PrimitiveLineObject)constructionObject2).getDX(), ((PrimitiveLineObject)constructionObject2).getP1().getY() + (((SegmentObject)constructionObject2).getLength() - d2) * ((PrimitiveLineObject)constructionObject2).getDY());
                        } else {
                            this.P.move(((PrimitiveLineObject)constructionObject2).getP1().getX() + d2 * ((PrimitiveLineObject)constructionObject2).getDX(), ((PrimitiveLineObject)constructionObject2).getP1().getY() + d2 * ((PrimitiveLineObject)constructionObject2).getDY());
                        }
                        this.ZC.dovalidate();
                    }
                    this.ZC.repaint();
                    d2 += this.ZC.dx(2);
                    if (d2 > 0.99 * ((SegmentObject)constructionObject2).getLength()) {
                        if (this.Negative && !bl2) {
                            d2 = 1.0E-5;
                            bl2 = true;
                        } else {
                            bl2 = false;
                            bl = true;
                        }
                    }
                } else if (constructionObject instanceof PrimitiveCircleObject) {
                    constructionObject2 = (PrimitiveCircleObject)constructionObject;
                    if (((PrimitiveCircleObject)constructionObject2).getR() < 1.0E-10) {
                        bl = true;
                    } else {
                        ZirkelCanvas zirkelCanvas = this.ZC;
                        synchronized (zirkelCanvas) {
                            if (this.Negative && !((PrimitiveCircleObject)constructionObject2).hasRange()) {
                                this.P.move(((PrimitiveCircleObject)constructionObject2).getP1().getX() + Math.cos(d2) * ((PrimitiveCircleObject)constructionObject2).getR(), ((PrimitiveCircleObject)constructionObject2).getP1().getY() - Math.sin(d2) * ((PrimitiveCircleObject)constructionObject2).getR());
                            } else {
                                this.P.move(((PrimitiveCircleObject)constructionObject2).getP1().getX() + Math.cos(d2) * ((PrimitiveCircleObject)constructionObject2).getR(), ((PrimitiveCircleObject)constructionObject2).getP1().getY() + Math.sin(d2) * ((PrimitiveCircleObject)constructionObject2).getR());
                            }
                            this.ZC.dovalidate();
                        }
                        this.ZC.repaint();
                        d2 = bl2 ? (d2 -= this.ZC.dx(2) / ((PrimitiveCircleObject)constructionObject2).getR()) : (d2 += this.ZC.dx(2) / ((PrimitiveCircleObject)constructionObject2).getR());
                        if (d2 > d3 && !bl2) {
                            if (!this.Negative || bl2 || !((PrimitiveCircleObject)constructionObject2).hasRange()) {
                                bl = true;
                                bl2 = false;
                            } else {
                                bl2 = true;
                                d3 = ((PrimitiveCircleObject)constructionObject2).getA1();
                            }
                        }
                        if (bl2 && d2 < d3) {
                            bl = true;
                            bl2 = false;
                        }
                    }
                } else if (constructionObject instanceof PointObject && System.currentTimeMillis() - l2 > 5000L) {
                    bl = true;
                }
            }
        }
        this.Running = false;
        if (this.Original) {
            this.ZC.getConstruction().setOriginalOrder(false);
        }
    }

    @Override
    public synchronized void invalidate(ZirkelCanvas zirkelCanvas) {
        this.Stopped = true;
    }

    @Override
    public boolean useSmartBoard() {
        return false;
    }

    public void increaseSpeed() {
        if (this.Delay > 1.0) {
            this.Delay /= 1.5;
        }
    }

    public void decreaseSpeed() {
        if (this.Delay < 500.0) {
            this.Delay *= 1.5;
        }
    }
}

