/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.ComputeButton;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.DataTableInput;
import edu.hws.jcm.awt.DisplayLabel;
import edu.hws.jcm.awt.ExpressionInput;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.Axes;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.ScatterPlot;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;

public class ScatterPlotApplet
extends Applet
implements ActionListener {
    private Frame frame;
    private String frameTitle;
    private Button launchButton;
    private String launchButtonName;
    private DataTableInput table;
    private ScatterPlot scatterPlot;
    private DisplayCanvas canvas;
    private Button loadFileButton;
    private Choice fileMenu;
    private String[] fileNames;
    private Controller mainController;

    public void init() {
        int n;
        this.frameTitle = this.getParameter("FrameTitle");
        if (this.frameTitle == null) {
            this.frameTitle = "Scatter Plots";
            n = this.frameTitle.lastIndexOf(46);
            if (n > -1) {
                this.frameTitle = this.frameTitle.substring(n + 1);
            }
        }
        this.setLayout(new BorderLayout());
        n = this.getSize().height;
        this.launchButtonName = this.getParameter("LaunchButtonName");
        if (n > 0 && n <= 50 || this.launchButtonName != null) {
            if (this.launchButtonName == null) {
                this.launchButtonName = "Launch " + this.frameTitle;
            }
            this.launchButton = new Button(this.launchButtonName);
            this.add((Component)this.launchButton, "Center");
            this.launchButton.addActionListener(this);
        } else {
            this.add((Component)this.makeMainPanel(), "Center");
        }
    }

    public Panel makeMainPanel() {
        Component component;
        Object object;
        JCMPanel jCMPanel = new JCMPanel(2);
        this.mainController = jCMPanel.getController();
        jCMPanel.setBackground(new Color(0, 0, 180));
        jCMPanel.setInsetGap(2);
        this.setLayout(new BorderLayout());
        this.table = new DataTableInput(null, 2);
        this.table.setColumnName(0, this.getParameter("ColumnName1", "X"));
        this.table.setColumnName(1, this.getParameter("ColumnName2", "Y"));
        this.table.setThrowErrors(true);
        if ("yes".equalsIgnoreCase(this.getParameter("ShowColumnTitles", "yes"))) {
            this.table.setShowColumnTitles(true);
        }
        if ("yes".equalsIgnoreCase(this.getParameter("ShowRowNumbers", "yes"))) {
            this.table.setShowRowNumbers(true);
        }
        Parser parser = new Parser();
        this.table.addVariablesToParser(parser);
        ExpressionInput expressionInput = new ExpressionInput(this.table.getColumnName(0), parser);
        expressionInput.setOnUserAction(this.mainController);
        ExpressionInput expressionInput2 = new ExpressionInput(this.table.getColumnName(1), parser);
        expressionInput2.setOnUserAction(this.mainController);
        this.scatterPlot = new ScatterPlot(this.table, expressionInput.getExpression(), expressionInput2.getExpression());
        if (!"yes".equalsIgnoreCase(this.getParameter("ShowRegressionLine", "yes"))) {
            this.scatterPlot.setShowRegressionLine(false);
        }
        if (!"yes".equalsIgnoreCase(this.getParameter("MissingValueIsError", "yes"))) {
            this.scatterPlot.setMissingValueIsError(false);
        }
        this.canvas = new DisplayCanvas();
        this.canvas.add(new Axes());
        this.canvas.add(this.scatterPlot);
        this.mainController.setErrorReporter(this.canvas);
        ComputeButton computeButton = new ComputeButton("Update Display");
        computeButton.setOnUserAction(this.mainController);
        computeButton.setBackground(Color.lightGray);
        Panel panel = this.makefileMenu();
        JCMPanel jCMPanel2 = null;
        Panel panel2 = null;
        if ("yes".equalsIgnoreCase(this.getParameter("UseExpressionInputs", "yes"))) {
            jCMPanel2 = new JCMPanel(1, 2);
            jCMPanel2.setBackground(Color.lightGray);
            object = new JCMPanel();
            ((Container)object).add((Component)new Label("  Plot:  "), "West");
            ((Container)object).add((Component)expressionInput, "Center");
            jCMPanel2.add((Component)object);
            component = new JCMPanel();
            ((Container)component).add(new Label(" versus: "), "West");
            ((Container)component).add(expressionInput2, "Center");
            jCMPanel2.add(component);
            panel2 = new JCMPanel(new BorderLayout(12, 3));
            panel2.add((Component)jCMPanel2, "Center");
            panel2.add((Component)computeButton, "East");
        }
        if (this.scatterPlot.getShowRegressionLine() && "yes".equalsIgnoreCase(this.getParameter("ShowStats", "yes"))) {
            object = new DisplayLabel("Slope = #;  Intercept = #;  Correlation = #", new Value[]{this.scatterPlot.getValueObject(1), this.scatterPlot.getValueObject(0), this.scatterPlot.getValueObject(5)});
            ((Label)object).setAlignment(1);
            ((Component)object).setBackground(Color.lightGray);
            ((Component)object).setForeground(new Color(200, 0, 0));
            ((Component)object).setFont(new Font("Serif", 0, 14));
            if (panel2 != null) {
                panel2.add((Component)object, "South");
            } else {
                panel2 = new JCMPanel(new BorderLayout(12, 3));
                panel2.add((Component)object, "Center");
                panel2.add((Component)computeButton, "East");
            }
        }
        if (panel2 == null) {
            if (panel != null) {
                panel.add((Component)computeButton, "East");
            } else {
                panel2 = new Panel();
                panel2.add(computeButton);
            }
        }
        jCMPanel.add((Component)this.canvas, "Center");
        jCMPanel.add((Component)this.table, "West");
        if (panel2 != null) {
            jCMPanel.add((Component)panel2, "South");
        }
        if (panel != null) {
            jCMPanel.add((Component)panel, "North");
        } else {
            object = this.getParameter("PanelTitle");
            if (object != null) {
                component = new Label((String)object, 1);
                component.setBackground(Color.lightGray);
                component.setForeground(new Color(200, 0, 0));
                component.setFont(new Font("Serif", 0, 14));
                jCMPanel.add(component, "North");
            }
        }
        return jCMPanel;
    }

    private Panel makefileMenu() {
        int n;
        Vector<String> vector = new Vector<String>();
        this.fileMenu = new Choice();
        String string = this.getParameter("File");
        int n2 = 1;
        if (string == null) {
            string = this.getParameter("File1");
            n2 = 2;
        }
        while (string != null) {
            String string2;
            n = (string = string.trim()).indexOf(";");
            if (n == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            }
            vector.addElement(string);
            this.fileMenu.add(string2);
            string = this.getParameter("File" + n2);
            ++n2;
        }
        if (vector.size() == 0) {
            this.fileMenu = null;
            return null;
        }
        this.fileNames = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.fileNames[n] = (String)vector.elementAt(n);
        }
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)this.fileMenu, "Center");
        this.loadFileButton = new Button("Load Data File: ");
        this.loadFileButton.addActionListener(this);
        panel.add((Component)this.loadFileButton, "West");
        this.fileMenu.setBackground(Color.white);
        return panel;
    }

    private void doLoadFile(String string) {
        InputStream inputStream;
        Object object;
        try {
            object = new URL(this.getDocumentBase(), string);
            inputStream = ((URL)object).openStream();
        }
        catch (Exception exception) {
            this.canvas.setErrorMessage(null, "Unable to open file named \"" + string + "\": " + exception);
            return;
        }
        object = new InputStreamReader(inputStream);
        try {
            this.table.readFromStream((Reader)object);
            ((Reader)object).close();
        }
        catch (Exception exception) {
            this.canvas.setErrorMessage(null, "Unable to get data from file \"" + string + "\": " + exception.getMessage());
            return;
        }
        this.mainController.compute();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.loadFileButton != null && object == this.loadFileButton) {
            this.doLoadFile(this.fileNames[this.fileMenu.getSelectedIndex()]);
        } else if (object == this.launchButton && this.launchButton != null) {
            this.launchButton.setEnabled(false);
            if (this.frame == null) {
                this.frame = new Frame(this.frameTitle);
                this.frame.add(this.makeMainPanel());
                this.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        ScatterPlotApplet.this.frame.dispose();
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        ScatterPlotApplet.this.frameClosed();
                    }
                });
                this.frame.pack();
                this.frame.setLocation(50, 50);
                this.frame.setVisible(true);
                this.launchButton.setLabel("Close Window");
                this.launchButton.setEnabled(true);
            } else {
                this.frame.dispose();
            }
        }
    }

    private synchronized void frameClosed() {
        this.frame = null;
        this.launchButton.setLabel(this.launchButtonName);
        this.launchButton.setEnabled(true);
    }

    protected String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 == null ? string2 : string3;
    }
}

