/**
 * Rectangle.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente l'interieur de l'angle le plus petit forme par deux vecteurs
 * <code>(x1, y1)</code> et <code>(x2, y2)</code>. Si les vecteurs sont sur la meme
 * droite, l'ensemble est le plan entier.
 *
 * @author Nicolae
 */
public class Angle extends DefaultSet {

	private double x1;
	private double y1;
	private double x2;
	private double y2;
	private double sg1;
	private double sg2; // == -sg1, utilis pour la lisibilit
	
	/**
	 * Cache le constructor standard.
	 */
	private Angle() {}
		
	/**
	 * Constructor qui initialise les coefficients.
	 *
	 * @param x1 partie reele du premier vecteur.
	 * @param y1 partie imaginaire du premier vecteur.
	 * @param x2 partie reele du deuxieme vecteur.
	 * @param y2 partie imaginaire du deuxieme vecteur.
	 */
	public Angle(double x1, double y1, double x2, double y2) {
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;

		sg1 = x2 * y1 - y2 * x1;
		sg2 = x1 * y2 - y1 * x2;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultSet#contains(double, double)
	 */
	public boolean contains(double re, double im) {
		double s1 = re * y1 - im * x1;
		double s2 = re * y2 - im * x2;
		
		return s1 * sg1 >= 0 && s2 * sg2 >= 0;
	}
}
