# Перенаправления и псевдонимы

## Перенаправления

Перенаправления также определяются в конфигурации маршрутов в опции `routes`. Например, чтобы перенаправить с `/a` на `/b`:

```js
const router = new VueRouter({
  routes: [
    { path: '/a', redirect: '/b' }
  ]
})
```

Перенаправление может осуществляться и на именованный маршрут:

```js
const router = new VueRouter({
  routes: [
    { path: '/a', redirect: { name: 'foo' }}
  ]
})
```

Или даже можно указать функцию для организации динамического перенаправления:

```js
const router = new VueRouter({
  routes: [
    { path: '/a', redirect: to => {
      // в функцию в качестве аргумента передаётся маршрут
      // возвращаемым значением должна быть строка или объект пути
    }}
  ]
})
```

Обратите внимание, что [навигационные хуки](../advanced/navigation-guards.md) не применяются на маршруте, который служит для перенаправления, только на его цель. В приведённом ниже примере добавление хуков `beforeEnter` на маршрут `/a` не будет иметь никакого эффекта.

Для демонстрации более сложных возможностей, обратите внимание на [этот пример](https://github.com/vuejs/vue-router/blob/dev/examples/redirect/app.js).

## Псевдонимы

При перенаправлении, если пользователь переходит по пути `/a`, то URL заменяется на `/b` и затем уже `/b` рассматривается как основной путь. В чём отличие псевдонимов?

**В случае, когда псевдонимом `/a` является `/b`, при переходе пользователя на `/b`, URL останется равным `/b`, но маршрутизатор выполнит все действия так, как если бы он был равен `/a`.**

В виде конфигурации маршрутизатора вышесказанное может быть выражено так:

```js
const router = new VueRouter({
  routes: [
    { path: '/a', component: A, alias: '/b' }
  ]
})
```

Псевдонимы позволяют не ограничиваться вложенными структурами организуя связи URL и UI.

Этот [пример](https://github.com/vuejs/vue-router/blob/dev/examples/route-alias/app.js) демонстрирует более продвинутое использование возможностей.
