# Императивная навигация

Помимо декларативного использования `<router-link>` для создания ссылок, можно использовать роутер и императивно, напрямую вызывая методы его экземпляра.

#### `router.push(location, onComplete?, onAbort?)`

**Примечание: Внутри экземпляра Vue у вас есть доступ к экземпляру маршрутизатора через `$router`. Поэтому вы можете вызвать `this.$router.push`.**

Для перехода к новому URL, используйте `router.push`. Этот метод добавляет новую запись в стек истории навигации, что позволяет клику пользователя по кнопке "назад" в браузере сработать привычным образом.

При клике на `<router-link>` этот метод вызывается автоматически. Клик по `<router-link :to="...">` эквивалентен императивному вызову `router.push(...)`.

| Декларативная запись      | Императивная запись |
|---------------------------|---------------------|
| `<router-link :to="...">` | `router.push(...)`  |

В качестве аргумента можно передать строку или объект, описывающий путь. Например:

``` js
// строка
router.push('home')

// объект
router.push({ path: 'home' })

// именованный путь
router.push({ name: 'user', params: { userId: 123 }})

// со строкой запроса, получится /register?plan=private
router.push({ path: 'register', query: { plan: 'private' }})
```

**Примечание**: `params` игнорируются, если указан `path`, что не соответствует случаю с `query` показанному в примере выше.
Вместо этого, вам нужно указать `name` маршрута или вручную указать весь `path` с необходимыми параметрами:

```js
const userId = 123
router.push({ name: 'user', params: { userId }}) // -> /user/123
router.push({ path: `/user/${userId}` }) // -> /user/123
// Это НЕ БУДЕТ работать
router.push({ path: '/user', params: { userId }}) // -> /user
```

Те же правила применяются и к свойству `to` компонента `router-link`.

В версии 2.2.0+, можно указать опциональные `onComplete` и `onAbort` коллбеки в `router.push` или `router.replace` в качестве 2-го и 3-го аргументов. Эти коллбеки будут вызываться когда навигация либо успешно завершена (после того как все асинхронные хуки будут завершены), или прервана (переходом на этот же маршрут, или на другой маршрут прежде чем текущая навигация будет завершена), соответственно.

**Примечание:** Если путь назначения совпадает с текущим маршрутом и меняются только параметры (например, переход из одного профиля в другой `/users/1` -> `/users/2`), вам потребуется использовать [`beforeRouteUpdate`](./dynamic-matching.html#отслеживание-изменений-параметров) чтобы реагировать на изменения (например, получение информации о пользователе).

#### `router.replace(location, onComplete?, onAbort?)`

Действует подобно `router.push`, с той лишь разницей, что вместо добавления новой записи к стеку истории переходов, заменяет текущую запись в нём.

| Декларативная запись              |  Императивная запись  |
|-----------------------------------|-----------------------|
| `<router-link :to="..." replace>` | `router.replace(...)` |

#### `router.go(n)`

Единственным параметром этого метода является целое число, указывающее на сколько шагов необходимо перейти по стеку истории навигации (вперёд или назад, аналогично `window.history.go(n)`.

Примеры

``` js
// перейти на одну запись вперёд, эквивалентно history.forward()
router.go(1)

// перейти на одну запись назад, эквивалентно history.back()
router.go(-1)

// перейти на 3 записи вперёд
router.go(3)

// если записей в истории недостаточно много, перехода просто не произойдёт
router.go(-100)
router.go(100)
```

#### Манипулирование историей переходов

Вы могли заметить, что `router.push`, `router.replace` и `router.go` соответствуют [`window.history.pushState`, `window.history.replaceState` и `window.history.go`](https://developer.mozilla.org/en-US/docs/Web/API/History), имитируя таким образом API `window.history`.

По этой причине, если вы уже знакомы с [API истории переходов браузера](https://developer.mozilla.org/en-US/docs/Web/API/History_API), то и со Vue-router неожиданностей не возникнет.

Стоит отметить, что методы навигации Vue-router'а (`push`, `replace`, `go`) работают одинаково во всех режимах роутера (`history`, `hash` и `abstract`).
