/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.interpolator;

import java.util.HashMap;
import org.j3d.util.interpolator.ColorInterpolator;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseInterpolatorNode;

public abstract class BaseColorInterpolator
extends BaseInterpolatorNode {
    private static final int NUM_FIELDS = 5;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfKeyValue;
    protected int numKeyValue;
    protected float[] vfValue;
    private ColorInterpolator interpolator;

    protected BaseColorInterpolator() {
        super("ColorInterpolator");
        this.hasChanged = new boolean[5];
        this.vfKeyValue = FieldConstants.EMPTY_MFCOLOR;
        this.vfValue = new float[]{0.0f, 0.0f, 0.0f};
    }

    protected BaseColorInterpolator(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLInterpolatorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("keyValue");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfKeyValue = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfKeyValue, 0, vRMLFieldData.numElements * 3);
                this.numKeyValue = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setFraction(float f) {
        this.vfFraction = f;
        if (this.vfKey != null && this.vfKey.length > 0 && this.interpolator != null && this.numKeyValue > 0) {
            try {
                float[] fArray = this.interpolator.floatRGBValue(this.vfFraction);
                this.setValue(fArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Invalid h, skipping");
            }
        }
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setKey(float[] fArray, int n) {
        super.setKey(fArray, n);
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.rebuildInterpolator();
        this.inSetup = true;
        this.setFraction(this.vfFraction);
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfKeyValue;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numKeyValue / 3;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfValue;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfKeyValue, this.numKeyValue);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfValue, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 3) {
            super.setValue(n, f);
        }
        this.setFraction(f);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setKeyValue(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setKeyValue(float[] fArray, int n) {
        this.vfKeyValue = fArray;
        this.numKeyValue = n;
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public float[] getKeyValue() {
        return this.vfKeyValue;
    }

    protected void setValue(float[] fArray) {
        if (fArray != null) {
            this.vfValue[0] = fArray[0];
            this.vfValue[1] = fArray[1];
            this.vfValue[2] = fArray[2];
            if (!this.inSetup) {
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
            }
        }
    }

    public float[] getValue() {
        return this.vfValue;
    }

    private void rebuildInterpolator() {
        if (this.numKey == 0 || this.numKeyValue == 0) {
            this.interpolator = null;
            return;
        }
        int n = this.numKey < this.numKeyValue / 3 ? this.numKey : this.numKeyValue / 3;
        this.interpolator = new ColorInterpolator(n, 1);
        for (int i = 0; i < n; ++i) {
            this.interpolator.addRGBKeyFrame(this.vfKey[i], this.vfKeyValue[i * 3], this.vfKeyValue[i * 3 + 1], this.vfKeyValue[i * 3 + 2], 0.0f);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseColorInterpolator.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseColorInterpolator.fieldDecl[3] = new VRMLFieldDeclaration(1, "SFFloat", "set_fraction");
        BaseColorInterpolator.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFFloat", "key");
        BaseColorInterpolator.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFColor", "keyValue");
        BaseColorInterpolator.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFColor", "value_changed");
        fieldMap.put("set_fraction", new Integer(3));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("key", n);
        fieldMap.put("set_key", n);
        fieldMap.put("key_changed", n);
        n = new Integer(2);
        fieldMap.put("keyValue", n);
        fieldMap.put("set_keyValue", n);
        fieldMap.put("keyValue_changed", n);
        fieldMap.put("value_changed", new Integer(4));
    }
}

