// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_SUB_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_SUB_A32_H_

const byte kInstruction_sub_le_r4_r5_r14[] = {
  0x0e, 0x40, 0x45, 0xd0 // sub le r4 r5 r14
};
const byte kInstruction_sub_ge_r5_r11_r10[] = {
  0x0a, 0x50, 0x4b, 0xa0 // sub ge r5 r11 r10
};
const byte kInstruction_sub_ls_r0_r9_r9[] = {
  0x09, 0x00, 0x49, 0x90 // sub ls r0 r9 r9
};
const byte kInstruction_sub_le_r8_r7_r2[] = {
  0x02, 0x80, 0x47, 0xd0 // sub le r8 r7 r2
};
const byte kInstruction_sub_eq_r1_r10_r13[] = {
  0x0d, 0x10, 0x4a, 0x00 // sub eq r1 r10 r13
};
const byte kInstruction_sub_le_r9_r12_r2[] = {
  0x02, 0x90, 0x4c, 0xd0 // sub le r9 r12 r2
};
const byte kInstruction_sub_pl_r6_r1_r5[] = {
  0x05, 0x60, 0x41, 0x50 // sub pl r6 r1 r5
};
const byte kInstruction_sub_ge_r1_r12_r6[] = {
  0x06, 0x10, 0x4c, 0xa0 // sub ge r1 r12 r6
};
const byte kInstruction_sub_cc_r13_r12_r3[] = {
  0x03, 0xd0, 0x4c, 0x30 // sub cc r13 r12 r3
};
const byte kInstruction_sub_gt_r2_r4_r9[] = {
  0x09, 0x20, 0x44, 0xc0 // sub gt r2 r4 r9
};
const byte kInstruction_sub_le_r3_r9_r10[] = {
  0x0a, 0x30, 0x49, 0xd0 // sub le r3 r9 r10
};
const byte kInstruction_sub_gt_r11_r1_r9[] = {
  0x09, 0xb0, 0x41, 0xc0 // sub gt r11 r1 r9
};
const byte kInstruction_sub_cc_r8_r6_r11[] = {
  0x0b, 0x80, 0x46, 0x30 // sub cc r8 r6 r11
};
const byte kInstruction_sub_cs_r12_r9_r3[] = {
  0x03, 0xc0, 0x49, 0x20 // sub cs r12 r9 r3
};
const byte kInstruction_sub_eq_r9_r14_r10[] = {
  0x0a, 0x90, 0x4e, 0x00 // sub eq r9 r14 r10
};
const byte kInstruction_sub_gt_r9_r0_r1[] = {
  0x01, 0x90, 0x40, 0xc0 // sub gt r9 r0 r1
};
const byte kInstruction_sub_pl_r11_r8_r2[] = {
  0x02, 0xb0, 0x48, 0x50 // sub pl r11 r8 r2
};
const byte kInstruction_sub_mi_r7_r1_r2[] = {
  0x02, 0x70, 0x41, 0x40 // sub mi r7 r1 r2
};
const byte kInstruction_sub_vs_r8_r6_r7[] = {
  0x07, 0x80, 0x46, 0x60 // sub vs r8 r6 r7
};
const byte kInstruction_sub_ne_r14_r2_r13[] = {
  0x0d, 0xe0, 0x42, 0x10 // sub ne r14 r2 r13
};
const byte kInstruction_sub_hi_r3_r3_r8[] = {
  0x08, 0x30, 0x43, 0x80 // sub hi r3 r3 r8
};
const byte kInstruction_sub_vc_r10_r8_r14[] = {
  0x0e, 0xa0, 0x48, 0x70 // sub vc r10 r8 r14
};
const byte kInstruction_sub_ls_r2_r11_r0[] = {
  0x00, 0x20, 0x4b, 0x90 // sub ls r2 r11 r0
};
const byte kInstruction_sub_ge_r8_r10_r0[] = {
  0x00, 0x80, 0x4a, 0xa0 // sub ge r8 r10 r0
};
const byte kInstruction_sub_mi_r8_r10_r5[] = {
  0x05, 0x80, 0x4a, 0x40 // sub mi r8 r10 r5
};
const byte kInstruction_sub_pl_r1_r0_r9[] = {
  0x09, 0x10, 0x40, 0x50 // sub pl r1 r0 r9
};
const byte kInstruction_sub_gt_r6_r7_r3[] = {
  0x03, 0x60, 0x47, 0xc0 // sub gt r6 r7 r3
};
const byte kInstruction_sub_vs_r7_r9_r9[] = {
  0x09, 0x70, 0x49, 0x60 // sub vs r7 r9 r9
};
const byte kInstruction_sub_al_r9_r4_r2[] = {
  0x02, 0x90, 0x44, 0xe0 // sub al r9 r4 r2
};
const byte kInstruction_sub_le_r3_r1_r2[] = {
  0x02, 0x30, 0x41, 0xd0 // sub le r3 r1 r2
};
const byte kInstruction_sub_mi_r6_r14_r0[] = {
  0x00, 0x60, 0x4e, 0x40 // sub mi r6 r14 r0
};
const byte kInstruction_sub_vc_r7_r10_r11[] = {
  0x0b, 0x70, 0x4a, 0x70 // sub vc r7 r10 r11
};
const byte kInstruction_sub_hi_r13_r2_r10[] = {
  0x0a, 0xd0, 0x42, 0x80 // sub hi r13 r2 r10
};
const byte kInstruction_sub_cs_r5_r4_r12[] = {
  0x0c, 0x50, 0x44, 0x20 // sub cs r5 r4 r12
};
const byte kInstruction_sub_ls_r13_r9_r11[] = {
  0x0b, 0xd0, 0x49, 0x90 // sub ls r13 r9 r11
};
const byte kInstruction_sub_ne_r2_r10_r12[] = {
  0x0c, 0x20, 0x4a, 0x10 // sub ne r2 r10 r12
};
const byte kInstruction_sub_vc_r4_r6_r8[] = {
  0x08, 0x40, 0x46, 0x70 // sub vc r4 r6 r8
};
const byte kInstruction_sub_lt_r13_r0_r13[] = {
  0x0d, 0xd0, 0x40, 0xb0 // sub lt r13 r0 r13
};
const byte kInstruction_sub_pl_r11_r14_r5[] = {
  0x05, 0xb0, 0x4e, 0x50 // sub pl r11 r14 r5
};
const byte kInstruction_sub_cs_r8_r11_r3[] = {
  0x03, 0x80, 0x4b, 0x20 // sub cs r8 r11 r3
};
const byte kInstruction_sub_cs_r4_r1_r7[] = {
  0x07, 0x40, 0x41, 0x20 // sub cs r4 r1 r7
};
const byte kInstruction_sub_al_r0_r12_r13[] = {
  0x0d, 0x00, 0x4c, 0xe0 // sub al r0 r12 r13
};
const byte kInstruction_sub_gt_r3_r6_r0[] = {
  0x00, 0x30, 0x46, 0xc0 // sub gt r3 r6 r0
};
const byte kInstruction_sub_vc_r6_r9_r0[] = {
  0x00, 0x60, 0x49, 0x70 // sub vc r6 r9 r0
};
const byte kInstruction_sub_cc_r2_r2_r12[] = {
  0x0c, 0x20, 0x42, 0x30 // sub cc r2 r2 r12
};
const byte kInstruction_sub_cs_r4_r13_r1[] = {
  0x01, 0x40, 0x4d, 0x20 // sub cs r4 r13 r1
};
const byte kInstruction_sub_mi_r12_r12_r10[] = {
  0x0a, 0xc0, 0x4c, 0x40 // sub mi r12 r12 r10
};
const byte kInstruction_sub_hi_r8_r9_r14[] = {
  0x0e, 0x80, 0x49, 0x80 // sub hi r8 r9 r14
};
const byte kInstruction_sub_hi_r4_r3_r7[] = {
  0x07, 0x40, 0x43, 0x80 // sub hi r4 r3 r7
};
const byte kInstruction_sub_ne_r11_r10_r1[] = {
  0x01, 0xb0, 0x4a, 0x10 // sub ne r11 r10 r1
};
const byte kInstruction_sub_cc_r2_r6_r3[] = {
  0x03, 0x20, 0x46, 0x30 // sub cc r2 r6 r3
};
const byte kInstruction_sub_cs_r6_r6_r0[] = {
  0x00, 0x60, 0x46, 0x20 // sub cs r6 r6 r0
};
const byte kInstruction_sub_vc_r13_r2_r9[] = {
  0x09, 0xd0, 0x42, 0x70 // sub vc r13 r2 r9
};
const byte kInstruction_sub_vc_r7_r13_r14[] = {
  0x0e, 0x70, 0x4d, 0x70 // sub vc r7 r13 r14
};
const byte kInstruction_sub_pl_r11_r14_r4[] = {
  0x04, 0xb0, 0x4e, 0x50 // sub pl r11 r14 r4
};
const byte kInstruction_sub_lt_r12_r14_r8[] = {
  0x08, 0xc0, 0x4e, 0xb0 // sub lt r12 r14 r8
};
const byte kInstruction_sub_cs_r2_r11_r14[] = {
  0x0e, 0x20, 0x4b, 0x20 // sub cs r2 r11 r14
};
const byte kInstruction_sub_le_r12_r13_r2[] = {
  0x02, 0xc0, 0x4d, 0xd0 // sub le r12 r13 r2
};
const byte kInstruction_sub_le_r5_r6_r14[] = {
  0x0e, 0x50, 0x46, 0xd0 // sub le r5 r6 r14
};
const byte kInstruction_sub_vc_r3_r14_r8[] = {
  0x08, 0x30, 0x4e, 0x70 // sub vc r3 r14 r8
};
const byte kInstruction_sub_lt_r7_r6_r14[] = {
  0x0e, 0x70, 0x46, 0xb0 // sub lt r7 r6 r14
};
const byte kInstruction_sub_ls_r0_r13_r12[] = {
  0x0c, 0x00, 0x4d, 0x90 // sub ls r0 r13 r12
};
const byte kInstruction_sub_ge_r10_r9_r14[] = {
  0x0e, 0xa0, 0x49, 0xa0 // sub ge r10 r9 r14
};
const byte kInstruction_sub_le_r11_r12_r1[] = {
  0x01, 0xb0, 0x4c, 0xd0 // sub le r11 r12 r1
};
const byte kInstruction_sub_al_r2_r12_r14[] = {
  0x0e, 0x20, 0x4c, 0xe0 // sub al r2 r12 r14
};
const byte kInstruction_sub_cs_r6_r4_r0[] = {
  0x00, 0x60, 0x44, 0x20 // sub cs r6 r4 r0
};
const byte kInstruction_sub_vs_r5_r0_r3[] = {
  0x03, 0x50, 0x40, 0x60 // sub vs r5 r0 r3
};
const byte kInstruction_sub_le_r8_r8_r0[] = {
  0x00, 0x80, 0x48, 0xd0 // sub le r8 r8 r0
};
const byte kInstruction_sub_gt_r1_r5_r4[] = {
  0x04, 0x10, 0x45, 0xc0 // sub gt r1 r5 r4
};
const byte kInstruction_sub_le_r4_r3_r4[] = {
  0x04, 0x40, 0x43, 0xd0 // sub le r4 r3 r4
};
const byte kInstruction_sub_pl_r9_r7_r10[] = {
  0x0a, 0x90, 0x47, 0x50 // sub pl r9 r7 r10
};
const byte kInstruction_sub_ls_r8_r7_r14[] = {
  0x0e, 0x80, 0x47, 0x90 // sub ls r8 r7 r14
};
const byte kInstruction_sub_vc_r9_r10_r6[] = {
  0x06, 0x90, 0x4a, 0x70 // sub vc r9 r10 r6
};
const byte kInstruction_sub_hi_r2_r4_r9[] = {
  0x09, 0x20, 0x44, 0x80 // sub hi r2 r4 r9
};
const byte kInstruction_sub_cs_r0_r2_r13[] = {
  0x0d, 0x00, 0x42, 0x20 // sub cs r0 r2 r13
};
const byte kInstruction_sub_vs_r3_r6_r12[] = {
  0x0c, 0x30, 0x46, 0x60 // sub vs r3 r6 r12
};
const byte kInstruction_sub_cc_r14_r14_r7[] = {
  0x07, 0xe0, 0x4e, 0x30 // sub cc r14 r14 r7
};
const byte kInstruction_sub_vc_r10_r6_r4[] = {
  0x04, 0xa0, 0x46, 0x70 // sub vc r10 r6 r4
};
const byte kInstruction_sub_cc_r1_r6_r10[] = {
  0x0a, 0x10, 0x46, 0x30 // sub cc r1 r6 r10
};
const byte kInstruction_sub_vs_r13_r10_r11[] = {
  0x0b, 0xd0, 0x4a, 0x60 // sub vs r13 r10 r11
};
const byte kInstruction_sub_ls_r5_r7_r12[] = {
  0x0c, 0x50, 0x47, 0x90 // sub ls r5 r7 r12
};
const byte kInstruction_sub_eq_r6_r4_r3[] = {
  0x03, 0x60, 0x44, 0x00 // sub eq r6 r4 r3
};
const byte kInstruction_sub_mi_r5_r9_r2[] = {
  0x02, 0x50, 0x49, 0x40 // sub mi r5 r9 r2
};
const byte kInstruction_sub_lt_r7_r1_r9[] = {
  0x09, 0x70, 0x41, 0xb0 // sub lt r7 r1 r9
};
const byte kInstruction_sub_ne_r12_r7_r0[] = {
  0x00, 0xc0, 0x47, 0x10 // sub ne r12 r7 r0
};
const byte kInstruction_sub_eq_r0_r6_r7[] = {
  0x07, 0x00, 0x46, 0x00 // sub eq r0 r6 r7
};
const byte kInstruction_sub_pl_r7_r3_r9[] = {
  0x09, 0x70, 0x43, 0x50 // sub pl r7 r3 r9
};
const byte kInstruction_sub_pl_r11_r11_r13[] = {
  0x0d, 0xb0, 0x4b, 0x50 // sub pl r11 r11 r13
};
const byte kInstruction_sub_gt_r0_r10_r5[] = {
  0x05, 0x00, 0x4a, 0xc0 // sub gt r0 r10 r5
};
const byte kInstruction_sub_mi_r14_r1_r10[] = {
  0x0a, 0xe0, 0x41, 0x40 // sub mi r14 r1 r10
};
const byte kInstruction_sub_mi_r5_r14_r0[] = {
  0x00, 0x50, 0x4e, 0x40 // sub mi r5 r14 r0
};
const byte kInstruction_sub_ne_r12_r9_r13[] = {
  0x0d, 0xc0, 0x49, 0x10 // sub ne r12 r9 r13
};
const byte kInstruction_sub_hi_r8_r5_r11[] = {
  0x0b, 0x80, 0x45, 0x80 // sub hi r8 r5 r11
};
const byte kInstruction_sub_ls_r7_r0_r5[] = {
  0x05, 0x70, 0x40, 0x90 // sub ls r7 r0 r5
};
const byte kInstruction_sub_lt_r5_r1_r7[] = {
  0x07, 0x50, 0x41, 0xb0 // sub lt r5 r1 r7
};
const byte kInstruction_sub_cc_r2_r8_r4[] = {
  0x04, 0x20, 0x48, 0x30 // sub cc r2 r8 r4
};
const byte kInstruction_sub_lt_r3_r0_r5[] = {
  0x05, 0x30, 0x40, 0xb0 // sub lt r3 r0 r5
};
const byte kInstruction_sub_pl_r4_r9_r7[] = {
  0x07, 0x40, 0x49, 0x50 // sub pl r4 r9 r7
};
const byte kInstruction_sub_eq_r13_r8_r10[] = {
  0x0a, 0xd0, 0x48, 0x00 // sub eq r13 r8 r10
};
const byte kInstruction_sub_ge_r6_r10_r10[] = {
  0x0a, 0x60, 0x4a, 0xa0 // sub ge r6 r10 r10
};
const byte kInstruction_sub_lt_r5_r5_r7[] = {
  0x07, 0x50, 0x45, 0xb0 // sub lt r5 r5 r7
};
const byte kInstruction_sub_hi_r6_r3_r9[] = {
  0x09, 0x60, 0x43, 0x80 // sub hi r6 r3 r9
};
const byte kInstruction_sub_hi_r14_r12_r10[] = {
  0x0a, 0xe0, 0x4c, 0x80 // sub hi r14 r12 r10
};
const byte kInstruction_sub_lt_r9_r13_r14[] = {
  0x0e, 0x90, 0x4d, 0xb0 // sub lt r9 r13 r14
};
const byte kInstruction_sub_al_r0_r12_r7[] = {
  0x07, 0x00, 0x4c, 0xe0 // sub al r0 r12 r7
};
const byte kInstruction_sub_eq_r14_r8_r11[] = {
  0x0b, 0xe0, 0x48, 0x00 // sub eq r14 r8 r11
};
const byte kInstruction_sub_ne_r9_r11_r1[] = {
  0x01, 0x90, 0x4b, 0x10 // sub ne r9 r11 r1
};
const byte kInstruction_sub_ge_r5_r0_r3[] = {
  0x03, 0x50, 0x40, 0xa0 // sub ge r5 r0 r3
};
const byte kInstruction_sub_pl_r12_r0_r1[] = {
  0x01, 0xc0, 0x40, 0x50 // sub pl r12 r0 r1
};
const byte kInstruction_sub_lt_r13_r7_r11[] = {
  0x0b, 0xd0, 0x47, 0xb0 // sub lt r13 r7 r11
};
const byte kInstruction_sub_eq_r4_r6_r6[] = {
  0x06, 0x40, 0x46, 0x00 // sub eq r4 r6 r6
};
const byte kInstruction_sub_cs_r1_r14_r0[] = {
  0x00, 0x10, 0x4e, 0x20 // sub cs r1 r14 r0
};
const byte kInstruction_sub_hi_r7_r7_r6[] = {
  0x06, 0x70, 0x47, 0x80 // sub hi r7 r7 r6
};
const byte kInstruction_sub_hi_r1_r0_r3[] = {
  0x03, 0x10, 0x40, 0x80 // sub hi r1 r0 r3
};
const byte kInstruction_sub_pl_r12_r2_r0[] = {
  0x00, 0xc0, 0x42, 0x50 // sub pl r12 r2 r0
};
const byte kInstruction_sub_mi_r3_r0_r3[] = {
  0x03, 0x30, 0x40, 0x40 // sub mi r3 r0 r3
};
const byte kInstruction_sub_al_r14_r4_r3[] = {
  0x03, 0xe0, 0x44, 0xe0 // sub al r14 r4 r3
};
const byte kInstruction_sub_vs_r4_r2_r9[] = {
  0x09, 0x40, 0x42, 0x60 // sub vs r4 r2 r9
};
const byte kInstruction_sub_vs_r1_r9_r12[] = {
  0x0c, 0x10, 0x49, 0x60 // sub vs r1 r9 r12
};
const byte kInstruction_sub_vs_r3_r6_r9[] = {
  0x09, 0x30, 0x46, 0x60 // sub vs r3 r6 r9
};
const byte kInstruction_sub_cc_r4_r1_r8[] = {
  0x08, 0x40, 0x41, 0x30 // sub cc r4 r1 r8
};
const byte kInstruction_sub_ls_r10_r11_r14[] = {
  0x0e, 0xa0, 0x4b, 0x90 // sub ls r10 r11 r14
};
const byte kInstruction_sub_le_r11_r7_r2[] = {
  0x02, 0xb0, 0x47, 0xd0 // sub le r11 r7 r2
};
const byte kInstruction_sub_le_r6_r9_r14[] = {
  0x0e, 0x60, 0x49, 0xd0 // sub le r6 r9 r14
};
const byte kInstruction_sub_al_r1_r3_r11[] = {
  0x0b, 0x10, 0x43, 0xe0 // sub al r1 r3 r11
};
const byte kInstruction_sub_lt_r0_r2_r2[] = {
  0x02, 0x00, 0x42, 0xb0 // sub lt r0 r2 r2
};
const byte kInstruction_sub_eq_r11_r6_r8[] = {
  0x08, 0xb0, 0x46, 0x00 // sub eq r11 r6 r8
};
const byte kInstruction_sub_ls_r7_r12_r5[] = {
  0x05, 0x70, 0x4c, 0x90 // sub ls r7 r12 r5
};
const byte kInstruction_sub_vc_r4_r11_r0[] = {
  0x00, 0x40, 0x4b, 0x70 // sub vc r4 r11 r0
};
const byte kInstruction_sub_ls_r7_r14_r2[] = {
  0x02, 0x70, 0x4e, 0x90 // sub ls r7 r14 r2
};
const byte kInstruction_sub_le_r7_r12_r1[] = {
  0x01, 0x70, 0x4c, 0xd0 // sub le r7 r12 r1
};
const byte kInstruction_sub_le_r1_r14_r13[] = {
  0x0d, 0x10, 0x4e, 0xd0 // sub le r1 r14 r13
};
const byte kInstruction_sub_le_r11_r3_r9[] = {
  0x09, 0xb0, 0x43, 0xd0 // sub le r11 r3 r9
};
const byte kInstruction_sub_ne_r14_r13_r1[] = {
  0x01, 0xe0, 0x4d, 0x10 // sub ne r14 r13 r1
};
const byte kInstruction_sub_ne_r5_r1_r10[] = {
  0x0a, 0x50, 0x41, 0x10 // sub ne r5 r1 r10
};
const byte kInstruction_sub_cc_r7_r4_r3[] = {
  0x03, 0x70, 0x44, 0x30 // sub cc r7 r4 r3
};
const byte kInstruction_sub_lt_r8_r1_r1[] = {
  0x01, 0x80, 0x41, 0xb0 // sub lt r8 r1 r1
};
const byte kInstruction_sub_al_r5_r0_r1[] = {
  0x01, 0x50, 0x40, 0xe0 // sub al r5 r0 r1
};
const byte kInstruction_sub_ge_r11_r13_r9[] = {
  0x09, 0xb0, 0x4d, 0xa0 // sub ge r11 r13 r9
};
const byte kInstruction_sub_gt_r5_r9_r5[] = {
  0x05, 0x50, 0x49, 0xc0 // sub gt r5 r9 r5
};
const byte kInstruction_sub_cc_r2_r8_r3[] = {
  0x03, 0x20, 0x48, 0x30 // sub cc r2 r8 r3
};
const byte kInstruction_sub_eq_r6_r6_r12[] = {
  0x0c, 0x60, 0x46, 0x00 // sub eq r6 r6 r12
};
const byte kInstruction_sub_vc_r3_r10_r13[] = {
  0x0d, 0x30, 0x4a, 0x70 // sub vc r3 r10 r13
};
const byte kInstruction_sub_vc_r9_r13_r1[] = {
  0x01, 0x90, 0x4d, 0x70 // sub vc r9 r13 r1
};
const byte kInstruction_sub_lt_r7_r0_r0[] = {
  0x00, 0x70, 0x40, 0xb0 // sub lt r7 r0 r0
};
const byte kInstruction_sub_cc_r6_r6_r1[] = {
  0x01, 0x60, 0x46, 0x30 // sub cc r6 r6 r1
};
const byte kInstruction_sub_mi_r8_r1_r9[] = {
  0x09, 0x80, 0x41, 0x40 // sub mi r8 r1 r9
};
const byte kInstruction_sub_ls_r14_r10_r10[] = {
  0x0a, 0xe0, 0x4a, 0x90 // sub ls r14 r10 r10
};
const byte kInstruction_sub_ge_r7_r13_r1[] = {
  0x01, 0x70, 0x4d, 0xa0 // sub ge r7 r13 r1
};
const byte kInstruction_sub_le_r0_r4_r3[] = {
  0x03, 0x00, 0x44, 0xd0 // sub le r0 r4 r3
};
const byte kInstruction_sub_cc_r12_r10_r10[] = {
  0x0a, 0xc0, 0x4a, 0x30 // sub cc r12 r10 r10
};
const byte kInstruction_sub_ge_r5_r0_r10[] = {
  0x0a, 0x50, 0x40, 0xa0 // sub ge r5 r0 r10
};
const byte kInstruction_sub_vs_r8_r3_r10[] = {
  0x0a, 0x80, 0x43, 0x60 // sub vs r8 r3 r10
};
const byte kInstruction_sub_ge_r11_r12_r2[] = {
  0x02, 0xb0, 0x4c, 0xa0 // sub ge r11 r12 r2
};
const byte kInstruction_sub_ne_r14_r4_r8[] = {
  0x08, 0xe0, 0x44, 0x10 // sub ne r14 r4 r8
};
const byte kInstruction_sub_mi_r3_r0_r4[] = {
  0x04, 0x30, 0x40, 0x40 // sub mi r3 r0 r4
};
const byte kInstruction_sub_gt_r13_r9_r6[] = {
  0x06, 0xd0, 0x49, 0xc0 // sub gt r13 r9 r6
};
const byte kInstruction_sub_ls_r1_r14_r2[] = {
  0x02, 0x10, 0x4e, 0x90 // sub ls r1 r14 r2
};
const byte kInstruction_sub_eq_r11_r3_r12[] = {
  0x0c, 0xb0, 0x43, 0x00 // sub eq r11 r3 r12
};
const byte kInstruction_sub_ge_r4_r13_r4[] = {
  0x04, 0x40, 0x4d, 0xa0 // sub ge r4 r13 r4
};
const byte kInstruction_sub_al_r5_r9_r7[] = {
  0x07, 0x50, 0x49, 0xe0 // sub al r5 r9 r7
};
const byte kInstruction_sub_le_r11_r9_r0[] = {
  0x00, 0xb0, 0x49, 0xd0 // sub le r11 r9 r0
};
const byte kInstruction_sub_mi_r13_r10_r12[] = {
  0x0c, 0xd0, 0x4a, 0x40 // sub mi r13 r10 r12
};
const byte kInstruction_sub_hi_r5_r5_r10[] = {
  0x0a, 0x50, 0x45, 0x80 // sub hi r5 r5 r10
};
const byte kInstruction_sub_ge_r4_r6_r14[] = {
  0x0e, 0x40, 0x46, 0xa0 // sub ge r4 r6 r14
};
const byte kInstruction_sub_le_r5_r5_r7[] = {
  0x07, 0x50, 0x45, 0xd0 // sub le r5 r5 r7
};
const byte kInstruction_sub_pl_r12_r2_r8[] = {
  0x08, 0xc0, 0x42, 0x50 // sub pl r12 r2 r8
};
const byte kInstruction_sub_al_r7_r8_r10[] = {
  0x0a, 0x70, 0x48, 0xe0 // sub al r7 r8 r10
};
const byte kInstruction_sub_vc_r8_r11_r13[] = {
  0x0d, 0x80, 0x4b, 0x70 // sub vc r8 r11 r13
};
const byte kInstruction_sub_ne_r14_r2_r12[] = {
  0x0c, 0xe0, 0x42, 0x10 // sub ne r14 r2 r12
};
const byte kInstruction_sub_eq_r10_r4_r2[] = {
  0x02, 0xa0, 0x44, 0x00 // sub eq r10 r4 r2
};
const byte kInstruction_sub_al_r6_r2_r5[] = {
  0x05, 0x60, 0x42, 0xe0 // sub al r6 r2 r5
};
const byte kInstruction_sub_al_r1_r6_r2[] = {
  0x02, 0x10, 0x46, 0xe0 // sub al r1 r6 r2
};
const byte kInstruction_sub_vs_r0_r7_r14[] = {
  0x0e, 0x00, 0x47, 0x60 // sub vs r0 r7 r14
};
const byte kInstruction_sub_hi_r9_r7_r0[] = {
  0x00, 0x90, 0x47, 0x80 // sub hi r9 r7 r0
};
const byte kInstruction_sub_ne_r8_r11_r13[] = {
  0x0d, 0x80, 0x4b, 0x10 // sub ne r8 r11 r13
};
const byte kInstruction_sub_ne_r9_r8_r12[] = {
  0x0c, 0x90, 0x48, 0x10 // sub ne r9 r8 r12
};
const byte kInstruction_sub_al_r14_r8_r6[] = {
  0x06, 0xe0, 0x48, 0xe0 // sub al r14 r8 r6
};
const byte kInstruction_sub_vc_r8_r0_r3[] = {
  0x03, 0x80, 0x40, 0x70 // sub vc r8 r0 r3
};
const byte kInstruction_sub_pl_r11_r9_r0[] = {
  0x00, 0xb0, 0x49, 0x50 // sub pl r11 r9 r0
};
const byte kInstruction_sub_al_r7_r9_r9[] = {
  0x09, 0x70, 0x49, 0xe0 // sub al r7 r9 r9
};
const byte kInstruction_sub_ls_r0_r8_r3[] = {
  0x03, 0x00, 0x48, 0x90 // sub ls r0 r8 r3
};
const byte kInstruction_sub_lt_r5_r13_r6[] = {
  0x06, 0x50, 0x4d, 0xb0 // sub lt r5 r13 r6
};
const byte kInstruction_sub_ge_r6_r5_r13[] = {
  0x0d, 0x60, 0x45, 0xa0 // sub ge r6 r5 r13
};
const byte kInstruction_sub_cs_r11_r7_r3[] = {
  0x03, 0xb0, 0x47, 0x20 // sub cs r11 r7 r3
};
const byte kInstruction_sub_vs_r8_r0_r6[] = {
  0x06, 0x80, 0x40, 0x60 // sub vs r8 r0 r6
};
const byte kInstruction_sub_hi_r0_r12_r6[] = {
  0x06, 0x00, 0x4c, 0x80 // sub hi r0 r12 r6
};
const byte kInstruction_sub_eq_r14_r5_r12[] = {
  0x0c, 0xe0, 0x45, 0x00 // sub eq r14 r5 r12
};
const byte kInstruction_sub_lt_r1_r4_r13[] = {
  0x0d, 0x10, 0x44, 0xb0 // sub lt r1 r4 r13
};
const byte kInstruction_sub_hi_r6_r4_r2[] = {
  0x02, 0x60, 0x44, 0x80 // sub hi r6 r4 r2
};
const byte kInstruction_sub_lt_r10_r10_r9[] = {
  0x09, 0xa0, 0x4a, 0xb0 // sub lt r10 r10 r9
};
const byte kInstruction_sub_pl_r14_r7_r4[] = {
  0x04, 0xe0, 0x47, 0x50 // sub pl r14 r7 r4
};
const byte kInstruction_sub_ge_r8_r3_r4[] = {
  0x04, 0x80, 0x43, 0xa0 // sub ge r8 r3 r4
};
const byte kInstruction_sub_al_r11_r1_r14[] = {
  0x0e, 0xb0, 0x41, 0xe0 // sub al r11 r1 r14
};
const byte kInstruction_sub_ge_r7_r8_r9[] = {
  0x09, 0x70, 0x48, 0xa0 // sub ge r7 r8 r9
};
const byte kInstruction_sub_le_r10_r10_r8[] = {
  0x08, 0xa0, 0x4a, 0xd0 // sub le r10 r10 r8
};
const byte kInstruction_sub_hi_r3_r3_r7[] = {
  0x07, 0x30, 0x43, 0x80 // sub hi r3 r3 r7
};
const byte kInstruction_sub_cc_r3_r0_r14[] = {
  0x0e, 0x30, 0x40, 0x30 // sub cc r3 r0 r14
};
const byte kInstruction_sub_al_r8_r9_r1[] = {
  0x01, 0x80, 0x49, 0xe0 // sub al r8 r9 r1
};
const byte kInstruction_sub_gt_r6_r13_r7[] = {
  0x07, 0x60, 0x4d, 0xc0 // sub gt r6 r13 r7
};
const byte kInstruction_sub_ls_r11_r3_r1[] = {
  0x01, 0xb0, 0x43, 0x90 // sub ls r11 r3 r1
};
const byte kInstruction_sub_cc_r14_r0_r13[] = {
  0x0d, 0xe0, 0x40, 0x30 // sub cc r14 r0 r13
};
const byte kInstruction_sub_gt_r4_r4_r4[] = {
  0x04, 0x40, 0x44, 0xc0 // sub gt r4 r4 r4
};
const byte kInstruction_sub_al_r8_r13_r1[] = {
  0x01, 0x80, 0x4d, 0xe0 // sub al r8 r13 r1
};
const byte kInstruction_sub_mi_r8_r4_r6[] = {
  0x06, 0x80, 0x44, 0x40 // sub mi r8 r4 r6
};
const byte kInstruction_sub_vc_r12_r7_r11[] = {
  0x0b, 0xc0, 0x47, 0x70 // sub vc r12 r7 r11
};
const byte kInstruction_sub_cs_r0_r1_r0[] = {
  0x00, 0x00, 0x41, 0x20 // sub cs r0 r1 r0
};
const byte kInstruction_sub_cc_r13_r14_r0[] = {
  0x00, 0xd0, 0x4e, 0x30 // sub cc r13 r14 r0
};
const byte kInstruction_sub_eq_r4_r7_r11[] = {
  0x0b, 0x40, 0x47, 0x00 // sub eq r4 r7 r11
};
const byte kInstruction_sub_ls_r11_r2_r0[] = {
  0x00, 0xb0, 0x42, 0x90 // sub ls r11 r2 r0
};
const byte kInstruction_sub_gt_r10_r2_r3[] = {
  0x03, 0xa0, 0x42, 0xc0 // sub gt r10 r2 r3
};
const byte kInstruction_sub_al_r6_r1_r7[] = {
  0x07, 0x60, 0x41, 0xe0 // sub al r6 r1 r7
};
const byte kInstruction_sub_cs_r10_r13_r0[] = {
  0x00, 0xa0, 0x4d, 0x20 // sub cs r10 r13 r0
};
const byte kInstruction_sub_lt_r11_r2_r6[] = {
  0x06, 0xb0, 0x42, 0xb0 // sub lt r11 r2 r6
};
const byte kInstruction_sub_pl_r4_r13_r6[] = {
  0x06, 0x40, 0x4d, 0x50 // sub pl r4 r13 r6
};
const byte kInstruction_sub_cs_r3_r0_r9[] = {
  0x09, 0x30, 0x40, 0x20 // sub cs r3 r0 r9
};
const byte kInstruction_sub_gt_r4_r6_r14[] = {
  0x0e, 0x40, 0x46, 0xc0 // sub gt r4 r6 r14
};
const byte kInstruction_sub_eq_r6_r8_r0[] = {
  0x00, 0x60, 0x48, 0x00 // sub eq r6 r8 r0
};
const byte kInstruction_sub_cc_r5_r5_r2[] = {
  0x02, 0x50, 0x45, 0x30 // sub cc r5 r5 r2
};
const byte kInstruction_sub_al_r9_r3_r7[] = {
  0x07, 0x90, 0x43, 0xe0 // sub al r9 r3 r7
};
const byte kInstruction_sub_cc_r12_r0_r8[] = {
  0x08, 0xc0, 0x40, 0x30 // sub cc r12 r0 r8
};
const byte kInstruction_sub_le_r4_r1_r7[] = {
  0x07, 0x40, 0x41, 0xd0 // sub le r4 r1 r7
};
const byte kInstruction_sub_gt_r3_r12_r7[] = {
  0x07, 0x30, 0x4c, 0xc0 // sub gt r3 r12 r7
};
const byte kInstruction_sub_vc_r4_r3_r14[] = {
  0x0e, 0x40, 0x43, 0x70 // sub vc r4 r3 r14
};
const byte kInstruction_sub_le_r0_r7_r10[] = {
  0x0a, 0x00, 0x47, 0xd0 // sub le r0 r7 r10
};
const byte kInstruction_sub_vs_r14_r8_r13[] = {
  0x0d, 0xe0, 0x48, 0x60 // sub vs r14 r8 r13
};
const byte kInstruction_sub_hi_r9_r0_r11[] = {
  0x0b, 0x90, 0x40, 0x80 // sub hi r9 r0 r11
};
const byte kInstruction_sub_eq_r8_r13_r0[] = {
  0x00, 0x80, 0x4d, 0x00 // sub eq r8 r13 r0
};
const byte kInstruction_sub_vc_r10_r9_r2[] = {
  0x02, 0xa0, 0x49, 0x70 // sub vc r10 r9 r2
};
const byte kInstruction_sub_al_r0_r13_r10[] = {
  0x0a, 0x00, 0x4d, 0xe0 // sub al r0 r13 r10
};
const byte kInstruction_sub_ne_r5_r4_r6[] = {
  0x06, 0x50, 0x44, 0x10 // sub ne r5 r4 r6
};
const byte kInstruction_sub_cc_r7_r13_r1[] = {
  0x01, 0x70, 0x4d, 0x30 // sub cc r7 r13 r1
};
const byte kInstruction_sub_lt_r1_r14_r11[] = {
  0x0b, 0x10, 0x4e, 0xb0 // sub lt r1 r14 r11
};
const byte kInstruction_sub_vc_r13_r10_r14[] = {
  0x0e, 0xd0, 0x4a, 0x70 // sub vc r13 r10 r14
};
const byte kInstruction_sub_le_r3_r0_r4[] = {
  0x04, 0x30, 0x40, 0xd0 // sub le r3 r0 r4
};
const byte kInstruction_sub_al_r11_r4_r5[] = {
  0x05, 0xb0, 0x44, 0xe0 // sub al r11 r4 r5
};
const byte kInstruction_sub_lt_r0_r8_r8[] = {
  0x08, 0x00, 0x48, 0xb0 // sub lt r0 r8 r8
};
const byte kInstruction_sub_al_r13_r12_r7[] = {
  0x07, 0xd0, 0x4c, 0xe0 // sub al r13 r12 r7
};
const byte kInstruction_sub_ls_r12_r13_r13[] = {
  0x0d, 0xc0, 0x4d, 0x90 // sub ls r12 r13 r13
};
const byte kInstruction_sub_vc_r8_r2_r9[] = {
  0x09, 0x80, 0x42, 0x70 // sub vc r8 r2 r9
};
const byte kInstruction_sub_ne_r14_r9_r3[] = {
  0x03, 0xe0, 0x49, 0x10 // sub ne r14 r9 r3
};
const byte kInstruction_sub_pl_r12_r11_r6[] = {
  0x06, 0xc0, 0x4b, 0x50 // sub pl r12 r11 r6
};
const byte kInstruction_sub_eq_r0_r3_r5[] = {
  0x05, 0x00, 0x43, 0x00 // sub eq r0 r3 r5
};
const byte kInstruction_sub_hi_r11_r3_r14[] = {
  0x0e, 0xb0, 0x43, 0x80 // sub hi r11 r3 r14
};
const byte kInstruction_sub_le_r3_r7_r4[] = {
  0x04, 0x30, 0x47, 0xd0 // sub le r3 r7 r4
};
const byte kInstruction_sub_ne_r6_r9_r8[] = {
  0x08, 0x60, 0x49, 0x10 // sub ne r6 r9 r8
};
const byte kInstruction_sub_vc_r11_r11_r11[] = {
  0x0b, 0xb0, 0x4b, 0x70 // sub vc r11 r11 r11
};
const byte kInstruction_sub_ge_r3_r1_r10[] = {
  0x0a, 0x30, 0x41, 0xa0 // sub ge r3 r1 r10
};
const byte kInstruction_sub_gt_r5_r14_r13[] = {
  0x0d, 0x50, 0x4e, 0xc0 // sub gt r5 r14 r13
};
const byte kInstruction_sub_le_r7_r0_r13[] = {
  0x0d, 0x70, 0x40, 0xd0 // sub le r7 r0 r13
};
const byte kInstruction_sub_lt_r8_r5_r1[] = {
  0x01, 0x80, 0x45, 0xb0 // sub lt r8 r5 r1
};
const byte kInstruction_sub_le_r3_r4_r8[] = {
  0x08, 0x30, 0x44, 0xd0 // sub le r3 r4 r8
};
const byte kInstruction_sub_ne_r5_r11_r13[] = {
  0x0d, 0x50, 0x4b, 0x10 // sub ne r5 r11 r13
};
const byte kInstruction_sub_ge_r9_r8_r2[] = {
  0x02, 0x90, 0x48, 0xa0 // sub ge r9 r8 r2
};
const byte kInstruction_sub_gt_r9_r5_r12[] = {
  0x0c, 0x90, 0x45, 0xc0 // sub gt r9 r5 r12
};
const byte kInstruction_sub_pl_r9_r8_r1[] = {
  0x01, 0x90, 0x48, 0x50 // sub pl r9 r8 r1
};
const byte kInstruction_sub_le_r3_r12_r4[] = {
  0x04, 0x30, 0x4c, 0xd0 // sub le r3 r12 r4
};
const byte kInstruction_sub_eq_r5_r6_r9[] = {
  0x09, 0x50, 0x46, 0x00 // sub eq r5 r6 r9
};
const byte kInstruction_sub_ne_r14_r4_r13[] = {
  0x0d, 0xe0, 0x44, 0x10 // sub ne r14 r4 r13
};
const byte kInstruction_sub_ge_r3_r9_r2[] = {
  0x02, 0x30, 0x49, 0xa0 // sub ge r3 r9 r2
};
const byte kInstruction_sub_ls_r13_r0_r10[] = {
  0x0a, 0xd0, 0x40, 0x90 // sub ls r13 r0 r10
};
const byte kInstruction_sub_mi_r14_r0_r2[] = {
  0x02, 0xe0, 0x40, 0x40 // sub mi r14 r0 r2
};
const byte kInstruction_sub_cs_r11_r1_r3[] = {
  0x03, 0xb0, 0x41, 0x20 // sub cs r11 r1 r3
};
const byte kInstruction_sub_ne_r8_r9_r10[] = {
  0x0a, 0x80, 0x49, 0x10 // sub ne r8 r9 r10
};
const byte kInstruction_sub_gt_r9_r10_r4[] = {
  0x04, 0x90, 0x4a, 0xc0 // sub gt r9 r10 r4
};
const byte kInstruction_sub_le_r2_r8_r4[] = {
  0x04, 0x20, 0x48, 0xd0 // sub le r2 r8 r4
};
const byte kInstruction_sub_al_r6_r14_r11[] = {
  0x0b, 0x60, 0x4e, 0xe0 // sub al r6 r14 r11
};
const byte kInstruction_sub_eq_r3_r14_r14[] = {
  0x0e, 0x30, 0x4e, 0x00 // sub eq r3 r14 r14
};
const byte kInstruction_sub_pl_r9_r9_r3[] = {
  0x03, 0x90, 0x49, 0x50 // sub pl r9 r9 r3
};
const byte kInstruction_sub_ge_r5_r13_r12[] = {
  0x0c, 0x50, 0x4d, 0xa0 // sub ge r5 r13 r12
};
const byte kInstruction_sub_mi_r10_r6_r5[] = {
  0x05, 0xa0, 0x46, 0x40 // sub mi r10 r6 r5
};
const byte kInstruction_sub_ls_r14_r13_r12[] = {
  0x0c, 0xe0, 0x4d, 0x90 // sub ls r14 r13 r12
};
const byte kInstruction_sub_lt_r10_r9_r10[] = {
  0x0a, 0xa0, 0x49, 0xb0 // sub lt r10 r9 r10
};
const byte kInstruction_sub_ls_r7_r4_r9[] = {
  0x09, 0x70, 0x44, 0x90 // sub ls r7 r4 r9
};
const byte kInstruction_sub_cs_r9_r10_r7[] = {
  0x07, 0x90, 0x4a, 0x20 // sub cs r9 r10 r7
};
const byte kInstruction_sub_eq_r4_r2_r2[] = {
  0x02, 0x40, 0x42, 0x00 // sub eq r4 r2 r2
};
const byte kInstruction_sub_lt_r14_r13_r4[] = {
  0x04, 0xe0, 0x4d, 0xb0 // sub lt r14 r13 r4
};
const byte kInstruction_sub_al_r0_r3_r5[] = {
  0x05, 0x00, 0x43, 0xe0 // sub al r0 r3 r5
};
const byte kInstruction_sub_vs_r9_r6_r7[] = {
  0x07, 0x90, 0x46, 0x60 // sub vs r9 r6 r7
};
const byte kInstruction_sub_ls_r0_r6_r4[] = {
  0x04, 0x00, 0x46, 0x90 // sub ls r0 r6 r4
};
const byte kInstruction_sub_ne_r7_r10_r14[] = {
  0x0e, 0x70, 0x4a, 0x10 // sub ne r7 r10 r14
};
const byte kInstruction_sub_le_r2_r12_r1[] = {
  0x01, 0x20, 0x4c, 0xd0 // sub le r2 r12 r1
};
const byte kInstruction_sub_cs_r1_r5_r0[] = {
  0x00, 0x10, 0x45, 0x20 // sub cs r1 r5 r0
};
const byte kInstruction_sub_pl_r0_r9_r1[] = {
  0x01, 0x00, 0x49, 0x50 // sub pl r0 r9 r1
};
const byte kInstruction_sub_mi_r2_r2_r5[] = {
  0x05, 0x20, 0x42, 0x40 // sub mi r2 r2 r5
};
const byte kInstruction_sub_hi_r5_r1_r12[] = {
  0x0c, 0x50, 0x41, 0x80 // sub hi r5 r1 r12
};
const byte kInstruction_sub_ls_r13_r14_r7[] = {
  0x07, 0xd0, 0x4e, 0x90 // sub ls r13 r14 r7
};
const byte kInstruction_sub_lt_r0_r4_r3[] = {
  0x03, 0x00, 0x44, 0xb0 // sub lt r0 r4 r3
};
const byte kInstruction_sub_cc_r8_r13_r2[] = {
  0x02, 0x80, 0x4d, 0x30 // sub cc r8 r13 r2
};
const byte kInstruction_sub_ls_r7_r8_r14[] = {
  0x0e, 0x70, 0x48, 0x90 // sub ls r7 r8 r14
};
const byte kInstruction_sub_hi_r13_r11_r13[] = {
  0x0d, 0xd0, 0x4b, 0x80 // sub hi r13 r11 r13
};
const byte kInstruction_sub_ge_r13_r7_r6[] = {
  0x06, 0xd0, 0x47, 0xa0 // sub ge r13 r7 r6
};
const byte kInstruction_sub_mi_r3_r2_r0[] = {
  0x00, 0x30, 0x42, 0x40 // sub mi r3 r2 r0
};
const byte kInstruction_sub_cs_r12_r0_r10[] = {
  0x0a, 0xc0, 0x40, 0x20 // sub cs r12 r0 r10
};
const byte kInstruction_sub_vs_r9_r10_r8[] = {
  0x08, 0x90, 0x4a, 0x60 // sub vs r9 r10 r8
};
const byte kInstruction_sub_ls_r2_r8_r8[] = {
  0x08, 0x20, 0x48, 0x90 // sub ls r2 r8 r8
};
const byte kInstruction_sub_ge_r1_r11_r3[] = {
  0x03, 0x10, 0x4b, 0xa0 // sub ge r1 r11 r3
};
const byte kInstruction_sub_ge_r12_r3_r3[] = {
  0x03, 0xc0, 0x43, 0xa0 // sub ge r12 r3 r3
};
const byte kInstruction_sub_gt_r3_r8_r6[] = {
  0x06, 0x30, 0x48, 0xc0 // sub gt r3 r8 r6
};
const byte kInstruction_sub_ne_r13_r2_r9[] = {
  0x09, 0xd0, 0x42, 0x10 // sub ne r13 r2 r9
};
const byte kInstruction_sub_ls_r14_r9_r1[] = {
  0x01, 0xe0, 0x49, 0x90 // sub ls r14 r9 r1
};
const byte kInstruction_sub_cc_r2_r10_r2[] = {
  0x02, 0x20, 0x4a, 0x30 // sub cc r2 r10 r2
};
const byte kInstruction_sub_le_r9_r12_r1[] = {
  0x01, 0x90, 0x4c, 0xd0 // sub le r9 r12 r1
};
const byte kInstruction_sub_cs_r11_r10_r0[] = {
  0x00, 0xb0, 0x4a, 0x20 // sub cs r11 r10 r0
};
const byte kInstruction_sub_eq_r7_r0_r5[] = {
  0x05, 0x70, 0x40, 0x00 // sub eq r7 r0 r5
};
const byte kInstruction_sub_ne_r10_r4_r4[] = {
  0x04, 0xa0, 0x44, 0x10 // sub ne r10 r4 r4
};
const byte kInstruction_sub_pl_r13_r9_r6[] = {
  0x06, 0xd0, 0x49, 0x50 // sub pl r13 r9 r6
};
const byte kInstruction_sub_vc_r11_r3_r3[] = {
  0x03, 0xb0, 0x43, 0x70 // sub vc r11 r3 r3
};
const byte kInstruction_sub_al_r1_r13_r9[] = {
  0x09, 0x10, 0x4d, 0xe0 // sub al r1 r13 r9
};
const byte kInstruction_sub_cc_r13_r9_r14[] = {
  0x0e, 0xd0, 0x49, 0x30 // sub cc r13 r9 r14
};
const byte kInstruction_sub_vc_r5_r2_r3[] = {
  0x03, 0x50, 0x42, 0x70 // sub vc r5 r2 r3
};
const byte kInstruction_sub_ne_r12_r8_r10[] = {
  0x0a, 0xc0, 0x48, 0x10 // sub ne r12 r8 r10
};
const byte kInstruction_sub_cs_r11_r13_r6[] = {
  0x06, 0xb0, 0x4d, 0x20 // sub cs r11 r13 r6
};
const byte kInstruction_sub_al_r1_r11_r10[] = {
  0x0a, 0x10, 0x4b, 0xe0 // sub al r1 r11 r10
};
const byte kInstruction_sub_ne_r14_r6_r11[] = {
  0x0b, 0xe0, 0x46, 0x10 // sub ne r14 r6 r11
};
const byte kInstruction_sub_cs_r1_r14_r5[] = {
  0x05, 0x10, 0x4e, 0x20 // sub cs r1 r14 r5
};
const byte kInstruction_sub_al_r11_r11_r6[] = {
  0x06, 0xb0, 0x4b, 0xe0 // sub al r11 r11 r6
};
const byte kInstruction_sub_pl_r3_r6_r2[] = {
  0x02, 0x30, 0x46, 0x50 // sub pl r3 r6 r2
};
const byte kInstruction_sub_ne_r3_r9_r4[] = {
  0x04, 0x30, 0x49, 0x10 // sub ne r3 r9 r4
};
const byte kInstruction_sub_mi_r11_r4_r9[] = {
  0x09, 0xb0, 0x44, 0x40 // sub mi r11 r4 r9
};
const byte kInstruction_sub_al_r10_r1_r3[] = {
  0x03, 0xa0, 0x41, 0xe0 // sub al r10 r1 r3
};
const byte kInstruction_sub_vc_r2_r14_r11[] = {
  0x0b, 0x20, 0x4e, 0x70 // sub vc r2 r14 r11
};
const byte kInstruction_sub_mi_r9_r3_r0[] = {
  0x00, 0x90, 0x43, 0x40 // sub mi r9 r3 r0
};
const byte kInstruction_sub_vs_r9_r8_r1[] = {
  0x01, 0x90, 0x48, 0x60 // sub vs r9 r8 r1
};
const byte kInstruction_sub_lt_r2_r12_r5[] = {
  0x05, 0x20, 0x4c, 0xb0 // sub lt r2 r12 r5
};
const byte kInstruction_sub_al_r9_r8_r12[] = {
  0x0c, 0x90, 0x48, 0xe0 // sub al r9 r8 r12
};
const byte kInstruction_sub_vc_r3_r8_r0[] = {
  0x00, 0x30, 0x48, 0x70 // sub vc r3 r8 r0
};
const byte kInstruction_sub_mi_r10_r5_r1[] = {
  0x01, 0xa0, 0x45, 0x40 // sub mi r10 r5 r1
};
const byte kInstruction_sub_vc_r7_r14_r2[] = {
  0x02, 0x70, 0x4e, 0x70 // sub vc r7 r14 r2
};
const byte kInstruction_sub_ls_r0_r9_r7[] = {
  0x07, 0x00, 0x49, 0x90 // sub ls r0 r9 r7
};
const byte kInstruction_sub_cs_r3_r0_r10[] = {
  0x0a, 0x30, 0x40, 0x20 // sub cs r3 r0 r10
};
const byte kInstruction_sub_cc_r10_r8_r10[] = {
  0x0a, 0xa0, 0x48, 0x30 // sub cc r10 r8 r10
};
const byte kInstruction_sub_eq_r5_r4_r1[] = {
  0x01, 0x50, 0x44, 0x00 // sub eq r5 r4 r1
};
const byte kInstruction_sub_vc_r11_r13_r1[] = {
  0x01, 0xb0, 0x4d, 0x70 // sub vc r11 r13 r1
};
const byte kInstruction_sub_hi_r6_r5_r8[] = {
  0x08, 0x60, 0x45, 0x80 // sub hi r6 r5 r8
};
const byte kInstruction_sub_ne_r10_r5_r6[] = {
  0x06, 0xa0, 0x45, 0x10 // sub ne r10 r5 r6
};
const byte kInstruction_sub_al_r10_r12_r9[] = {
  0x09, 0xa0, 0x4c, 0xe0 // sub al r10 r12 r9
};
const byte kInstruction_sub_eq_r5_r1_r12[] = {
  0x0c, 0x50, 0x41, 0x00 // sub eq r5 r1 r12
};
const byte kInstruction_sub_le_r0_r14_r10[] = {
  0x0a, 0x00, 0x4e, 0xd0 // sub le r0 r14 r10
};
const byte kInstruction_sub_eq_r4_r2_r5[] = {
  0x05, 0x40, 0x42, 0x00 // sub eq r4 r2 r5
};
const byte kInstruction_sub_pl_r5_r8_r2[] = {
  0x02, 0x50, 0x48, 0x50 // sub pl r5 r8 r2
};
const byte kInstruction_sub_hi_r5_r14_r4[] = {
  0x04, 0x50, 0x4e, 0x80 // sub hi r5 r14 r4
};
const byte kInstruction_sub_le_r2_r7_r9[] = {
  0x09, 0x20, 0x47, 0xd0 // sub le r2 r7 r9
};
const byte kInstruction_sub_pl_r5_r12_r6[] = {
  0x06, 0x50, 0x4c, 0x50 // sub pl r5 r12 r6
};
const byte kInstruction_sub_vs_r11_r4_r14[] = {
  0x0e, 0xb0, 0x44, 0x60 // sub vs r11 r4 r14
};
const byte kInstruction_sub_eq_r0_r7_r14[] = {
  0x0e, 0x00, 0x47, 0x00 // sub eq r0 r7 r14
};
const byte kInstruction_sub_pl_r5_r2_r5[] = {
  0x05, 0x50, 0x42, 0x50 // sub pl r5 r2 r5
};
const byte kInstruction_sub_ne_r5_r11_r7[] = {
  0x07, 0x50, 0x4b, 0x10 // sub ne r5 r11 r7
};
const byte kInstruction_sub_pl_r7_r9_r10[] = {
  0x0a, 0x70, 0x49, 0x50 // sub pl r7 r9 r10
};
const byte kInstruction_sub_hi_r4_r2_r2[] = {
  0x02, 0x40, 0x42, 0x80 // sub hi r4 r2 r2
};
const byte kInstruction_sub_pl_r14_r9_r2[] = {
  0x02, 0xe0, 0x49, 0x50 // sub pl r14 r9 r2
};
const byte kInstruction_sub_le_r4_r11_r13[] = {
  0x0d, 0x40, 0x4b, 0xd0 // sub le r4 r11 r13
};
const byte kInstruction_sub_pl_r8_r8_r8[] = {
  0x08, 0x80, 0x48, 0x50 // sub pl r8 r8 r8
};
const byte kInstruction_sub_ge_r0_r6_r10[] = {
  0x0a, 0x00, 0x46, 0xa0 // sub ge r0 r6 r10
};
const byte kInstruction_sub_vc_r4_r4_r10[] = {
  0x0a, 0x40, 0x44, 0x70 // sub vc r4 r4 r10
};
const byte kInstruction_sub_cc_r11_r9_r12[] = {
  0x0c, 0xb0, 0x49, 0x30 // sub cc r11 r9 r12
};
const byte kInstruction_sub_pl_r14_r4_r12[] = {
  0x0c, 0xe0, 0x44, 0x50 // sub pl r14 r4 r12
};
const byte kInstruction_sub_vs_r8_r8_r8[] = {
  0x08, 0x80, 0x48, 0x60 // sub vs r8 r8 r8
};
const byte kInstruction_sub_ge_r14_r2_r12[] = {
  0x0c, 0xe0, 0x42, 0xa0 // sub ge r14 r2 r12
};
const byte kInstruction_sub_ge_r8_r2_r13[] = {
  0x0d, 0x80, 0x42, 0xa0 // sub ge r8 r2 r13
};
const byte kInstruction_sub_vs_r10_r0_r11[] = {
  0x0b, 0xa0, 0x40, 0x60 // sub vs r10 r0 r11
};
const byte kInstruction_sub_eq_r5_r1_r2[] = {
  0x02, 0x50, 0x41, 0x00 // sub eq r5 r1 r2
};
const byte kInstruction_sub_vs_r10_r11_r3[] = {
  0x03, 0xa0, 0x4b, 0x60 // sub vs r10 r11 r3
};
const byte kInstruction_sub_lt_r13_r13_r7[] = {
  0x07, 0xd0, 0x4d, 0xb0 // sub lt r13 r13 r7
};
const byte kInstruction_sub_le_r12_r7_r6[] = {
  0x06, 0xc0, 0x47, 0xd0 // sub le r12 r7 r6
};
const byte kInstruction_sub_eq_r4_r3_r3[] = {
  0x03, 0x40, 0x43, 0x00 // sub eq r4 r3 r3
};
const byte kInstruction_sub_pl_r0_r5_r8[] = {
  0x08, 0x00, 0x45, 0x50 // sub pl r0 r5 r8
};
const byte kInstruction_sub_vs_r10_r5_r3[] = {
  0x03, 0xa0, 0x45, 0x60 // sub vs r10 r5 r3
};
const byte kInstruction_sub_gt_r0_r11_r9[] = {
  0x09, 0x00, 0x4b, 0xc0 // sub gt r0 r11 r9
};
const byte kInstruction_sub_cc_r8_r5_r9[] = {
  0x09, 0x80, 0x45, 0x30 // sub cc r8 r5 r9
};
const byte kInstruction_sub_cs_r9_r12_r11[] = {
  0x0b, 0x90, 0x4c, 0x20 // sub cs r9 r12 r11
};
const byte kInstruction_sub_gt_r3_r4_r8[] = {
  0x08, 0x30, 0x44, 0xc0 // sub gt r3 r4 r8
};
const byte kInstruction_sub_ls_r8_r3_r10[] = {
  0x0a, 0x80, 0x43, 0x90 // sub ls r8 r3 r10
};
const byte kInstruction_sub_eq_r8_r14_r12[] = {
  0x0c, 0x80, 0x4e, 0x00 // sub eq r8 r14 r12
};
const byte kInstruction_sub_gt_r7_r1_r3[] = {
  0x03, 0x70, 0x41, 0xc0 // sub gt r7 r1 r3
};
const byte kInstruction_sub_al_r4_r4_r8[] = {
  0x08, 0x40, 0x44, 0xe0 // sub al r4 r4 r8
};
const byte kInstruction_sub_gt_r9_r14_r10[] = {
  0x0a, 0x90, 0x4e, 0xc0 // sub gt r9 r14 r10
};
const byte kInstruction_sub_lt_r3_r13_r2[] = {
  0x02, 0x30, 0x4d, 0xb0 // sub lt r3 r13 r2
};
const byte kInstruction_sub_le_r4_r11_r14[] = {
  0x0e, 0x40, 0x4b, 0xd0 // sub le r4 r11 r14
};
const byte kInstruction_sub_ge_r2_r14_r0[] = {
  0x00, 0x20, 0x4e, 0xa0 // sub ge r2 r14 r0
};
const byte kInstruction_sub_pl_r1_r8_r8[] = {
  0x08, 0x10, 0x48, 0x50 // sub pl r1 r8 r8
};
const byte kInstruction_sub_pl_r9_r2_r5[] = {
  0x05, 0x90, 0x42, 0x50 // sub pl r9 r2 r5
};
const byte kInstruction_sub_vs_r13_r13_r1[] = {
  0x01, 0xd0, 0x4d, 0x60 // sub vs r13 r13 r1
};
const byte kInstruction_sub_ge_r12_r14_r3[] = {
  0x03, 0xc0, 0x4e, 0xa0 // sub ge r12 r14 r3
};
const byte kInstruction_sub_vc_r0_r11_r4[] = {
  0x04, 0x00, 0x4b, 0x70 // sub vc r0 r11 r4
};
const byte kInstruction_sub_ge_r0_r2_r9[] = {
  0x09, 0x00, 0x42, 0xa0 // sub ge r0 r2 r9
};
const byte kInstruction_sub_vc_r12_r1_r6[] = {
  0x06, 0xc0, 0x41, 0x70 // sub vc r12 r1 r6
};
const byte kInstruction_sub_ne_r1_r3_r7[] = {
  0x07, 0x10, 0x43, 0x10 // sub ne r1 r3 r7
};
const byte kInstruction_sub_vs_r10_r3_r9[] = {
  0x09, 0xa0, 0x43, 0x60 // sub vs r10 r3 r9
};
const byte kInstruction_sub_cc_r14_r4_r1[] = {
  0x01, 0xe0, 0x44, 0x30 // sub cc r14 r4 r1
};
const byte kInstruction_sub_le_r9_r3_r7[] = {
  0x07, 0x90, 0x43, 0xd0 // sub le r9 r3 r7
};
const byte kInstruction_sub_le_r1_r0_r14[] = {
  0x0e, 0x10, 0x40, 0xd0 // sub le r1 r0 r14
};
const byte kInstruction_sub_le_r0_r14_r4[] = {
  0x04, 0x00, 0x4e, 0xd0 // sub le r0 r14 r4
};
const byte kInstruction_sub_hi_r13_r8_r11[] = {
  0x0b, 0xd0, 0x48, 0x80 // sub hi r13 r8 r11
};
const byte kInstruction_sub_cc_r10_r6_r11[] = {
  0x0b, 0xa0, 0x46, 0x30 // sub cc r10 r6 r11
};
const byte kInstruction_sub_cc_r0_r10_r14[] = {
  0x0e, 0x00, 0x4a, 0x30 // sub cc r0 r10 r14
};
const byte kInstruction_sub_le_r4_r4_r0[] = {
  0x00, 0x40, 0x44, 0xd0 // sub le r4 r4 r0
};
const byte kInstruction_sub_pl_r8_r14_r12[] = {
  0x0c, 0x80, 0x4e, 0x50 // sub pl r8 r14 r12
};
const byte kInstruction_sub_ge_r13_r12_r2[] = {
  0x02, 0xd0, 0x4c, 0xa0 // sub ge r13 r12 r2
};
const byte kInstruction_sub_al_r11_r11_r7[] = {
  0x07, 0xb0, 0x4b, 0xe0 // sub al r11 r11 r7
};
const byte kInstruction_sub_ls_r11_r12_r1[] = {
  0x01, 0xb0, 0x4c, 0x90 // sub ls r11 r12 r1
};
const byte kInstruction_sub_vs_r10_r14_r14[] = {
  0x0e, 0xa0, 0x4e, 0x60 // sub vs r10 r14 r14
};
const byte kInstruction_sub_pl_r2_r8_r12[] = {
  0x0c, 0x20, 0x48, 0x50 // sub pl r2 r8 r12
};
const byte kInstruction_sub_pl_r12_r7_r11[] = {
  0x0b, 0xc0, 0x47, 0x50 // sub pl r12 r7 r11
};
const byte kInstruction_sub_eq_r5_r8_r13[] = {
  0x0d, 0x50, 0x48, 0x00 // sub eq r5 r8 r13
};
const byte kInstruction_sub_vc_r6_r6_r6[] = {
  0x06, 0x60, 0x46, 0x70 // sub vc r6 r6 r6
};
const byte kInstruction_sub_vs_r0_r12_r1[] = {
  0x01, 0x00, 0x4c, 0x60 // sub vs r0 r12 r1
};
const byte kInstruction_sub_cs_r6_r0_r8[] = {
  0x08, 0x60, 0x40, 0x20 // sub cs r6 r0 r8
};
const byte kInstruction_sub_cc_r3_r4_r1[] = {
  0x01, 0x30, 0x44, 0x30 // sub cc r3 r4 r1
};
const byte kInstruction_sub_lt_r1_r10_r14[] = {
  0x0e, 0x10, 0x4a, 0xb0 // sub lt r1 r10 r14
};
const byte kInstruction_sub_le_r1_r3_r5[] = {
  0x05, 0x10, 0x43, 0xd0 // sub le r1 r3 r5
};
const byte kInstruction_sub_cc_r11_r1_r1[] = {
  0x01, 0xb0, 0x41, 0x30 // sub cc r11 r1 r1
};
const byte kInstruction_sub_vc_r1_r8_r7[] = {
  0x07, 0x10, 0x48, 0x70 // sub vc r1 r8 r7
};
const byte kInstruction_sub_eq_r3_r10_r13[] = {
  0x0d, 0x30, 0x4a, 0x00 // sub eq r3 r10 r13
};
const byte kInstruction_sub_hi_r14_r12_r12[] = {
  0x0c, 0xe0, 0x4c, 0x80 // sub hi r14 r12 r12
};
const byte kInstruction_sub_eq_r10_r1_r14[] = {
  0x0e, 0xa0, 0x41, 0x00 // sub eq r10 r1 r14
};
const byte kInstruction_sub_lt_r3_r1_r6[] = {
  0x06, 0x30, 0x41, 0xb0 // sub lt r3 r1 r6
};
const byte kInstruction_sub_cc_r9_r12_r10[] = {
  0x0a, 0x90, 0x4c, 0x30 // sub cc r9 r12 r10
};
const byte kInstruction_sub_lt_r13_r14_r14[] = {
  0x0e, 0xd0, 0x4e, 0xb0 // sub lt r13 r14 r14
};
const byte kInstruction_sub_ge_r2_r6_r9[] = {
  0x09, 0x20, 0x46, 0xa0 // sub ge r2 r6 r9
};
const byte kInstruction_sub_vs_r3_r9_r1[] = {
  0x01, 0x30, 0x49, 0x60 // sub vs r3 r9 r1
};
const byte kInstruction_sub_cc_r1_r9_r12[] = {
  0x0c, 0x10, 0x49, 0x30 // sub cc r1 r9 r12
};
const byte kInstruction_sub_ls_r5_r0_r6[] = {
  0x06, 0x50, 0x40, 0x90 // sub ls r5 r0 r6
};
const byte kInstruction_sub_hi_r6_r14_r10[] = {
  0x0a, 0x60, 0x4e, 0x80 // sub hi r6 r14 r10
};
const byte kInstruction_sub_al_r11_r10_r3[] = {
  0x03, 0xb0, 0x4a, 0xe0 // sub al r11 r10 r3
};
const byte kInstruction_sub_ne_r13_r4_r1[] = {
  0x01, 0xd0, 0x44, 0x10 // sub ne r13 r4 r1
};
const byte kInstruction_sub_hi_r13_r5_r14[] = {
  0x0e, 0xd0, 0x45, 0x80 // sub hi r13 r5 r14
};
const byte kInstruction_sub_ne_r8_r9_r11[] = {
  0x0b, 0x80, 0x49, 0x10 // sub ne r8 r9 r11
};
const byte kInstruction_sub_eq_r0_r13_r13[] = {
  0x0d, 0x00, 0x4d, 0x00 // sub eq r0 r13 r13
};
const byte kInstruction_sub_ne_r14_r11_r0[] = {
  0x00, 0xe0, 0x4b, 0x10 // sub ne r14 r11 r0
};
const byte kInstruction_sub_mi_r6_r8_r7[] = {
  0x07, 0x60, 0x48, 0x40 // sub mi r6 r8 r7
};
const byte kInstruction_sub_eq_r1_r7_r5[] = {
  0x05, 0x10, 0x47, 0x00 // sub eq r1 r7 r5
};
const byte kInstruction_sub_pl_r12_r9_r12[] = {
  0x0c, 0xc0, 0x49, 0x50 // sub pl r12 r9 r12
};
const byte kInstruction_sub_al_r4_r5_r14[] = {
  0x0e, 0x40, 0x45, 0xe0 // sub al r4 r5 r14
};
const byte kInstruction_sub_pl_r7_r0_r12[] = {
  0x0c, 0x70, 0x40, 0x50 // sub pl r7 r0 r12
};
const byte kInstruction_sub_mi_r5_r0_r13[] = {
  0x0d, 0x50, 0x40, 0x40 // sub mi r5 r0 r13
};
const byte kInstruction_sub_al_r10_r7_r11[] = {
  0x0b, 0xa0, 0x47, 0xe0 // sub al r10 r7 r11
};
const byte kInstruction_sub_gt_r2_r10_r0[] = {
  0x00, 0x20, 0x4a, 0xc0 // sub gt r2 r10 r0
};
const byte kInstruction_sub_ge_r11_r11_r8[] = {
  0x08, 0xb0, 0x4b, 0xa0 // sub ge r11 r11 r8
};
const byte kInstruction_sub_eq_r14_r7_r3[] = {
  0x03, 0xe0, 0x47, 0x00 // sub eq r14 r7 r3
};
const byte kInstruction_sub_ls_r0_r12_r4[] = {
  0x04, 0x00, 0x4c, 0x90 // sub ls r0 r12 r4
};
const byte kInstruction_sub_ne_r10_r1_r7[] = {
  0x07, 0xa0, 0x41, 0x10 // sub ne r10 r1 r7
};
const byte kInstruction_sub_hi_r14_r3_r13[] = {
  0x0d, 0xe0, 0x43, 0x80 // sub hi r14 r3 r13
};
const byte kInstruction_sub_le_r1_r5_r12[] = {
  0x0c, 0x10, 0x45, 0xd0 // sub le r1 r5 r12
};
const byte kInstruction_sub_ne_r8_r5_r11[] = {
  0x0b, 0x80, 0x45, 0x10 // sub ne r8 r5 r11
};
const byte kInstruction_sub_le_r5_r13_r0[] = {
  0x00, 0x50, 0x4d, 0xd0 // sub le r5 r13 r0
};
const byte kInstruction_sub_gt_r8_r12_r7[] = {
  0x07, 0x80, 0x4c, 0xc0 // sub gt r8 r12 r7
};
const byte kInstruction_sub_eq_r9_r14_r3[] = {
  0x03, 0x90, 0x4e, 0x00 // sub eq r9 r14 r3
};
const byte kInstruction_sub_cs_r10_r9_r9[] = {
  0x09, 0xa0, 0x49, 0x20 // sub cs r10 r9 r9
};
const byte kInstruction_sub_vc_r5_r13_r8[] = {
  0x08, 0x50, 0x4d, 0x70 // sub vc r5 r13 r8
};
const byte kInstruction_sub_eq_r4_r1_r8[] = {
  0x08, 0x40, 0x41, 0x00 // sub eq r4 r1 r8
};
const byte kInstruction_sub_lt_r12_r14_r9[] = {
  0x09, 0xc0, 0x4e, 0xb0 // sub lt r12 r14 r9
};
const byte kInstruction_sub_cc_r8_r8_r0[] = {
  0x00, 0x80, 0x48, 0x30 // sub cc r8 r8 r0
};
const byte kInstruction_sub_hi_r0_r14_r12[] = {
  0x0c, 0x00, 0x4e, 0x80 // sub hi r0 r14 r12
};
const byte kInstruction_sub_hi_r4_r1_r10[] = {
  0x0a, 0x40, 0x41, 0x80 // sub hi r4 r1 r10
};
const byte kInstruction_sub_gt_r2_r14_r12[] = {
  0x0c, 0x20, 0x4e, 0xc0 // sub gt r2 r14 r12
};
const byte kInstruction_sub_vs_r1_r8_r14[] = {
  0x0e, 0x10, 0x48, 0x60 // sub vs r1 r8 r14
};
const byte kInstruction_sub_cs_r4_r1_r6[] = {
  0x06, 0x40, 0x41, 0x20 // sub cs r4 r1 r6
};
const byte kInstruction_sub_hi_r7_r8_r7[] = {
  0x07, 0x70, 0x48, 0x80 // sub hi r7 r8 r7
};
const byte kInstruction_sub_hi_r3_r11_r8[] = {
  0x08, 0x30, 0x4b, 0x80 // sub hi r3 r11 r8
};
const byte kInstruction_sub_lt_r1_r12_r9[] = {
  0x09, 0x10, 0x4c, 0xb0 // sub lt r1 r12 r9
};
const byte kInstruction_sub_cs_r13_r4_r12[] = {
  0x0c, 0xd0, 0x44, 0x20 // sub cs r13 r4 r12
};
const byte kInstruction_sub_eq_r10_r10_r5[] = {
  0x05, 0xa0, 0x4a, 0x00 // sub eq r10 r10 r5
};
const byte kInstruction_sub_ge_r10_r14_r0[] = {
  0x00, 0xa0, 0x4e, 0xa0 // sub ge r10 r14 r0
};
const byte kInstruction_sub_lt_r3_r3_r2[] = {
  0x02, 0x30, 0x43, 0xb0 // sub lt r3 r3 r2
};
const byte kInstruction_sub_vs_r2_r13_r2[] = {
  0x02, 0x20, 0x4d, 0x60 // sub vs r2 r13 r2
};
const byte kInstruction_sub_ls_r6_r2_r12[] = {
  0x0c, 0x60, 0x42, 0x90 // sub ls r6 r2 r12
};
const byte kInstruction_sub_gt_r5_r11_r12[] = {
  0x0c, 0x50, 0x4b, 0xc0 // sub gt r5 r11 r12
};
const byte kInstruction_sub_al_r11_r10_r6[] = {
  0x06, 0xb0, 0x4a, 0xe0 // sub al r11 r10 r6
};
const byte kInstruction_sub_hi_r12_r14_r14[] = {
  0x0e, 0xc0, 0x4e, 0x80 // sub hi r12 r14 r14
};
const byte kInstruction_sub_ge_r12_r10_r6[] = {
  0x06, 0xc0, 0x4a, 0xa0 // sub ge r12 r10 r6
};
const byte kInstruction_sub_eq_r8_r3_r9[] = {
  0x09, 0x80, 0x43, 0x00 // sub eq r8 r3 r9
};
const byte kInstruction_sub_cc_r7_r5_r1[] = {
  0x01, 0x70, 0x45, 0x30 // sub cc r7 r5 r1
};
const byte kInstruction_sub_lt_r3_r0_r6[] = {
  0x06, 0x30, 0x40, 0xb0 // sub lt r3 r0 r6
};
const byte kInstruction_sub_le_r14_r4_r12[] = {
  0x0c, 0xe0, 0x44, 0xd0 // sub le r14 r4 r12
};
const byte kInstruction_sub_le_r9_r6_r4[] = {
  0x04, 0x90, 0x46, 0xd0 // sub le r9 r6 r4
};
const byte kInstruction_sub_hi_r6_r11_r0[] = {
  0x00, 0x60, 0x4b, 0x80 // sub hi r6 r11 r0
};
const byte kInstruction_sub_al_r3_r7_r6[] = {
  0x06, 0x30, 0x47, 0xe0 // sub al r3 r7 r6
};
const byte kInstruction_sub_lt_r10_r9_r12[] = {
  0x0c, 0xa0, 0x49, 0xb0 // sub lt r10 r9 r12
};
const byte kInstruction_sub_al_r14_r8_r4[] = {
  0x04, 0xe0, 0x48, 0xe0 // sub al r14 r8 r4
};
const byte kInstruction_sub_le_r14_r11_r14[] = {
  0x0e, 0xe0, 0x4b, 0xd0 // sub le r14 r11 r14
};
const byte kInstruction_sub_al_r14_r13_r8[] = {
  0x08, 0xe0, 0x4d, 0xe0 // sub al r14 r13 r8
};
const byte kInstruction_sub_ge_r5_r9_r10[] = {
  0x0a, 0x50, 0x49, 0xa0 // sub ge r5 r9 r10
};
const byte kInstruction_sub_eq_r1_r9_r4[] = {
  0x04, 0x10, 0x49, 0x00 // sub eq r1 r9 r4
};
const byte kInstruction_sub_cc_r5_r13_r8[] = {
  0x08, 0x50, 0x4d, 0x30 // sub cc r5 r13 r8
};
const byte kInstruction_sub_ne_r10_r0_r14[] = {
  0x0e, 0xa0, 0x40, 0x10 // sub ne r10 r0 r14
};
const byte kInstruction_sub_al_r2_r0_r10[] = {
  0x0a, 0x20, 0x40, 0xe0 // sub al r2 r0 r10
};
const byte kInstruction_sub_pl_r4_r0_r11[] = {
  0x0b, 0x40, 0x40, 0x50 // sub pl r4 r0 r11
};
const byte kInstruction_sub_gt_r13_r5_r12[] = {
  0x0c, 0xd0, 0x45, 0xc0 // sub gt r13 r5 r12
};
const byte kInstruction_sub_al_r2_r13_r8[] = {
  0x08, 0x20, 0x4d, 0xe0 // sub al r2 r13 r8
};
const byte kInstruction_sub_mi_r11_r3_r4[] = {
  0x04, 0xb0, 0x43, 0x40 // sub mi r11 r3 r4
};
const byte kInstruction_sub_le_r11_r8_r1[] = {
  0x01, 0xb0, 0x48, 0xd0 // sub le r11 r8 r1
};
const byte kInstruction_sub_hi_r12_r11_r1[] = {
  0x01, 0xc0, 0x4b, 0x80 // sub hi r12 r11 r1
};
const byte kInstruction_sub_ls_r6_r7_r2[] = {
  0x02, 0x60, 0x47, 0x90 // sub ls r6 r7 r2
};
const byte kInstruction_sub_cs_r7_r11_r2[] = {
  0x02, 0x70, 0x4b, 0x20 // sub cs r7 r11 r2
};
const byte kInstruction_sub_vc_r11_r13_r7[] = {
  0x07, 0xb0, 0x4d, 0x70 // sub vc r11 r13 r7
};
const byte kInstruction_sub_cs_r13_r0_r1[] = {
  0x01, 0xd0, 0x40, 0x20 // sub cs r13 r0 r1
};
const byte kInstruction_sub_cc_r5_r4_r6[] = {
  0x06, 0x50, 0x44, 0x30 // sub cc r5 r4 r6
};
const byte kInstruction_sub_gt_r4_r4_r13[] = {
  0x0d, 0x40, 0x44, 0xc0 // sub gt r4 r4 r13
};
const byte kInstruction_sub_al_r14_r8_r2[] = {
  0x02, 0xe0, 0x48, 0xe0 // sub al r14 r8 r2
};
const TestResult kReferencesub[] = {
  {
    ARRAY_SIZE(kInstruction_sub_le_r4_r5_r14),
    kInstruction_sub_le_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r5_r11_r10),
    kInstruction_sub_ge_r5_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r0_r9_r9),
    kInstruction_sub_ls_r0_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r8_r7_r2),
    kInstruction_sub_le_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r1_r10_r13),
    kInstruction_sub_eq_r1_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r9_r12_r2),
    kInstruction_sub_le_r9_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r6_r1_r5),
    kInstruction_sub_pl_r6_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r1_r12_r6),
    kInstruction_sub_ge_r1_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r13_r12_r3),
    kInstruction_sub_cc_r13_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r2_r4_r9),
    kInstruction_sub_gt_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r3_r9_r10),
    kInstruction_sub_le_r3_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r11_r1_r9),
    kInstruction_sub_gt_r11_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r8_r6_r11),
    kInstruction_sub_cc_r8_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r12_r9_r3),
    kInstruction_sub_cs_r12_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r9_r14_r10),
    kInstruction_sub_eq_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r9_r0_r1),
    kInstruction_sub_gt_r9_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r11_r8_r2),
    kInstruction_sub_pl_r11_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r7_r1_r2),
    kInstruction_sub_mi_r7_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r8_r6_r7),
    kInstruction_sub_vs_r8_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r2_r13),
    kInstruction_sub_ne_r14_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r3_r3_r8),
    kInstruction_sub_hi_r3_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r10_r8_r14),
    kInstruction_sub_vc_r10_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r2_r11_r0),
    kInstruction_sub_ls_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r8_r10_r0),
    kInstruction_sub_ge_r8_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r8_r10_r5),
    kInstruction_sub_mi_r8_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r1_r0_r9),
    kInstruction_sub_pl_r1_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r6_r7_r3),
    kInstruction_sub_gt_r6_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r7_r9_r9),
    kInstruction_sub_vs_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r9_r4_r2),
    kInstruction_sub_al_r9_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r3_r1_r2),
    kInstruction_sub_le_r3_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r6_r14_r0),
    kInstruction_sub_mi_r6_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r7_r10_r11),
    kInstruction_sub_vc_r7_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r13_r2_r10),
    kInstruction_sub_hi_r13_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r5_r4_r12),
    kInstruction_sub_cs_r5_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r13_r9_r11),
    kInstruction_sub_ls_r13_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r2_r10_r12),
    kInstruction_sub_ne_r2_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r4_r6_r8),
    kInstruction_sub_vc_r4_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r13_r0_r13),
    kInstruction_sub_lt_r13_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r11_r14_r5),
    kInstruction_sub_pl_r11_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r8_r11_r3),
    kInstruction_sub_cs_r8_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r4_r1_r7),
    kInstruction_sub_cs_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r0_r12_r13),
    kInstruction_sub_al_r0_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r3_r6_r0),
    kInstruction_sub_gt_r3_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r6_r9_r0),
    kInstruction_sub_vc_r6_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r2_r2_r12),
    kInstruction_sub_cc_r2_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r4_r13_r1),
    kInstruction_sub_cs_r4_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r12_r12_r10),
    kInstruction_sub_mi_r12_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r8_r9_r14),
    kInstruction_sub_hi_r8_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r4_r3_r7),
    kInstruction_sub_hi_r4_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r11_r10_r1),
    kInstruction_sub_ne_r11_r10_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r2_r6_r3),
    kInstruction_sub_cc_r2_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r6_r6_r0),
    kInstruction_sub_cs_r6_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r13_r2_r9),
    kInstruction_sub_vc_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r7_r13_r14),
    kInstruction_sub_vc_r7_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r11_r14_r4),
    kInstruction_sub_pl_r11_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r12_r14_r8),
    kInstruction_sub_lt_r12_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r2_r11_r14),
    kInstruction_sub_cs_r2_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r12_r13_r2),
    kInstruction_sub_le_r12_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r5_r6_r14),
    kInstruction_sub_le_r5_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r3_r14_r8),
    kInstruction_sub_vc_r3_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r7_r6_r14),
    kInstruction_sub_lt_r7_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r0_r13_r12),
    kInstruction_sub_ls_r0_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r10_r9_r14),
    kInstruction_sub_ge_r10_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r11_r12_r1),
    kInstruction_sub_le_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r2_r12_r14),
    kInstruction_sub_al_r2_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r6_r4_r0),
    kInstruction_sub_cs_r6_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r5_r0_r3),
    kInstruction_sub_vs_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r8_r8_r0),
    kInstruction_sub_le_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r1_r5_r4),
    kInstruction_sub_gt_r1_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r4_r3_r4),
    kInstruction_sub_le_r4_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r9_r7_r10),
    kInstruction_sub_pl_r9_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r8_r7_r14),
    kInstruction_sub_ls_r8_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r9_r10_r6),
    kInstruction_sub_vc_r9_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r2_r4_r9),
    kInstruction_sub_hi_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r0_r2_r13),
    kInstruction_sub_cs_r0_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r3_r6_r12),
    kInstruction_sub_vs_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r14_r14_r7),
    kInstruction_sub_cc_r14_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r10_r6_r4),
    kInstruction_sub_vc_r10_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r1_r6_r10),
    kInstruction_sub_cc_r1_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r13_r10_r11),
    kInstruction_sub_vs_r13_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r5_r7_r12),
    kInstruction_sub_ls_r5_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r6_r4_r3),
    kInstruction_sub_eq_r6_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r5_r9_r2),
    kInstruction_sub_mi_r5_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r7_r1_r9),
    kInstruction_sub_lt_r7_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r12_r7_r0),
    kInstruction_sub_ne_r12_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r0_r6_r7),
    kInstruction_sub_eq_r0_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r7_r3_r9),
    kInstruction_sub_pl_r7_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r11_r11_r13),
    kInstruction_sub_pl_r11_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r0_r10_r5),
    kInstruction_sub_gt_r0_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r14_r1_r10),
    kInstruction_sub_mi_r14_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r5_r14_r0),
    kInstruction_sub_mi_r5_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r12_r9_r13),
    kInstruction_sub_ne_r12_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r8_r5_r11),
    kInstruction_sub_hi_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r7_r0_r5),
    kInstruction_sub_ls_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r5_r1_r7),
    kInstruction_sub_lt_r5_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r2_r8_r4),
    kInstruction_sub_cc_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r3_r0_r5),
    kInstruction_sub_lt_r3_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r4_r9_r7),
    kInstruction_sub_pl_r4_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r13_r8_r10),
    kInstruction_sub_eq_r13_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r6_r10_r10),
    kInstruction_sub_ge_r6_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r5_r5_r7),
    kInstruction_sub_lt_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r6_r3_r9),
    kInstruction_sub_hi_r6_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r14_r12_r10),
    kInstruction_sub_hi_r14_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r9_r13_r14),
    kInstruction_sub_lt_r9_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r0_r12_r7),
    kInstruction_sub_al_r0_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r14_r8_r11),
    kInstruction_sub_eq_r14_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r9_r11_r1),
    kInstruction_sub_ne_r9_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r5_r0_r3),
    kInstruction_sub_ge_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r12_r0_r1),
    kInstruction_sub_pl_r12_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r13_r7_r11),
    kInstruction_sub_lt_r13_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r4_r6_r6),
    kInstruction_sub_eq_r4_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r1_r14_r0),
    kInstruction_sub_cs_r1_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r7_r7_r6),
    kInstruction_sub_hi_r7_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r1_r0_r3),
    kInstruction_sub_hi_r1_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r12_r2_r0),
    kInstruction_sub_pl_r12_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r3_r0_r3),
    kInstruction_sub_mi_r3_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r14_r4_r3),
    kInstruction_sub_al_r14_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r4_r2_r9),
    kInstruction_sub_vs_r4_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r1_r9_r12),
    kInstruction_sub_vs_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r3_r6_r9),
    kInstruction_sub_vs_r3_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r4_r1_r8),
    kInstruction_sub_cc_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r10_r11_r14),
    kInstruction_sub_ls_r10_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r11_r7_r2),
    kInstruction_sub_le_r11_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r6_r9_r14),
    kInstruction_sub_le_r6_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r1_r3_r11),
    kInstruction_sub_al_r1_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r0_r2_r2),
    kInstruction_sub_lt_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r11_r6_r8),
    kInstruction_sub_eq_r11_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r7_r12_r5),
    kInstruction_sub_ls_r7_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r4_r11_r0),
    kInstruction_sub_vc_r4_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r7_r14_r2),
    kInstruction_sub_ls_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r7_r12_r1),
    kInstruction_sub_le_r7_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r1_r14_r13),
    kInstruction_sub_le_r1_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r11_r3_r9),
    kInstruction_sub_le_r11_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r13_r1),
    kInstruction_sub_ne_r14_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r5_r1_r10),
    kInstruction_sub_ne_r5_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r7_r4_r3),
    kInstruction_sub_cc_r7_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r8_r1_r1),
    kInstruction_sub_lt_r8_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r5_r0_r1),
    kInstruction_sub_al_r5_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r11_r13_r9),
    kInstruction_sub_ge_r11_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r5_r9_r5),
    kInstruction_sub_gt_r5_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r2_r8_r3),
    kInstruction_sub_cc_r2_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r6_r6_r12),
    kInstruction_sub_eq_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r3_r10_r13),
    kInstruction_sub_vc_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r9_r13_r1),
    kInstruction_sub_vc_r9_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r7_r0_r0),
    kInstruction_sub_lt_r7_r0_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r6_r6_r1),
    kInstruction_sub_cc_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r8_r1_r9),
    kInstruction_sub_mi_r8_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r14_r10_r10),
    kInstruction_sub_ls_r14_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r7_r13_r1),
    kInstruction_sub_ge_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r0_r4_r3),
    kInstruction_sub_le_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r12_r10_r10),
    kInstruction_sub_cc_r12_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r5_r0_r10),
    kInstruction_sub_ge_r5_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r8_r3_r10),
    kInstruction_sub_vs_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r11_r12_r2),
    kInstruction_sub_ge_r11_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r4_r8),
    kInstruction_sub_ne_r14_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r3_r0_r4),
    kInstruction_sub_mi_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r13_r9_r6),
    kInstruction_sub_gt_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r1_r14_r2),
    kInstruction_sub_ls_r1_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r11_r3_r12),
    kInstruction_sub_eq_r11_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r4_r13_r4),
    kInstruction_sub_ge_r4_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r5_r9_r7),
    kInstruction_sub_al_r5_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r11_r9_r0),
    kInstruction_sub_le_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r13_r10_r12),
    kInstruction_sub_mi_r13_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r5_r5_r10),
    kInstruction_sub_hi_r5_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r4_r6_r14),
    kInstruction_sub_ge_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r5_r5_r7),
    kInstruction_sub_le_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r12_r2_r8),
    kInstruction_sub_pl_r12_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r7_r8_r10),
    kInstruction_sub_al_r7_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r8_r11_r13),
    kInstruction_sub_vc_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r2_r12),
    kInstruction_sub_ne_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r10_r4_r2),
    kInstruction_sub_eq_r10_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r6_r2_r5),
    kInstruction_sub_al_r6_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r1_r6_r2),
    kInstruction_sub_al_r1_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r0_r7_r14),
    kInstruction_sub_vs_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r9_r7_r0),
    kInstruction_sub_hi_r9_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r8_r11_r13),
    kInstruction_sub_ne_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r9_r8_r12),
    kInstruction_sub_ne_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r14_r8_r6),
    kInstruction_sub_al_r14_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r8_r0_r3),
    kInstruction_sub_vc_r8_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r11_r9_r0),
    kInstruction_sub_pl_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r7_r9_r9),
    kInstruction_sub_al_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r0_r8_r3),
    kInstruction_sub_ls_r0_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r5_r13_r6),
    kInstruction_sub_lt_r5_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r6_r5_r13),
    kInstruction_sub_ge_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r11_r7_r3),
    kInstruction_sub_cs_r11_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r8_r0_r6),
    kInstruction_sub_vs_r8_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r0_r12_r6),
    kInstruction_sub_hi_r0_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r14_r5_r12),
    kInstruction_sub_eq_r14_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r1_r4_r13),
    kInstruction_sub_lt_r1_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r6_r4_r2),
    kInstruction_sub_hi_r6_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r10_r10_r9),
    kInstruction_sub_lt_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r14_r7_r4),
    kInstruction_sub_pl_r14_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r8_r3_r4),
    kInstruction_sub_ge_r8_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r11_r1_r14),
    kInstruction_sub_al_r11_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r7_r8_r9),
    kInstruction_sub_ge_r7_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r10_r10_r8),
    kInstruction_sub_le_r10_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r3_r3_r7),
    kInstruction_sub_hi_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r3_r0_r14),
    kInstruction_sub_cc_r3_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r8_r9_r1),
    kInstruction_sub_al_r8_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r6_r13_r7),
    kInstruction_sub_gt_r6_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r11_r3_r1),
    kInstruction_sub_ls_r11_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r14_r0_r13),
    kInstruction_sub_cc_r14_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r4_r4_r4),
    kInstruction_sub_gt_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r8_r13_r1),
    kInstruction_sub_al_r8_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r8_r4_r6),
    kInstruction_sub_mi_r8_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r12_r7_r11),
    kInstruction_sub_vc_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r0_r1_r0),
    kInstruction_sub_cs_r0_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r13_r14_r0),
    kInstruction_sub_cc_r13_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r4_r7_r11),
    kInstruction_sub_eq_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r11_r2_r0),
    kInstruction_sub_ls_r11_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r10_r2_r3),
    kInstruction_sub_gt_r10_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r6_r1_r7),
    kInstruction_sub_al_r6_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r10_r13_r0),
    kInstruction_sub_cs_r10_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r11_r2_r6),
    kInstruction_sub_lt_r11_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r4_r13_r6),
    kInstruction_sub_pl_r4_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r3_r0_r9),
    kInstruction_sub_cs_r3_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r4_r6_r14),
    kInstruction_sub_gt_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r6_r8_r0),
    kInstruction_sub_eq_r6_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r5_r5_r2),
    kInstruction_sub_cc_r5_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r9_r3_r7),
    kInstruction_sub_al_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r12_r0_r8),
    kInstruction_sub_cc_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r4_r1_r7),
    kInstruction_sub_le_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r3_r12_r7),
    kInstruction_sub_gt_r3_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r4_r3_r14),
    kInstruction_sub_vc_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r0_r7_r10),
    kInstruction_sub_le_r0_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r14_r8_r13),
    kInstruction_sub_vs_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r9_r0_r11),
    kInstruction_sub_hi_r9_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r8_r13_r0),
    kInstruction_sub_eq_r8_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r10_r9_r2),
    kInstruction_sub_vc_r10_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r0_r13_r10),
    kInstruction_sub_al_r0_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r5_r4_r6),
    kInstruction_sub_ne_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r7_r13_r1),
    kInstruction_sub_cc_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r1_r14_r11),
    kInstruction_sub_lt_r1_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r13_r10_r14),
    kInstruction_sub_vc_r13_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r3_r0_r4),
    kInstruction_sub_le_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r11_r4_r5),
    kInstruction_sub_al_r11_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r0_r8_r8),
    kInstruction_sub_lt_r0_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r13_r12_r7),
    kInstruction_sub_al_r13_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r12_r13_r13),
    kInstruction_sub_ls_r12_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r8_r2_r9),
    kInstruction_sub_vc_r8_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r9_r3),
    kInstruction_sub_ne_r14_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r12_r11_r6),
    kInstruction_sub_pl_r12_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r0_r3_r5),
    kInstruction_sub_eq_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r11_r3_r14),
    kInstruction_sub_hi_r11_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r3_r7_r4),
    kInstruction_sub_le_r3_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r6_r9_r8),
    kInstruction_sub_ne_r6_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r11_r11_r11),
    kInstruction_sub_vc_r11_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r3_r1_r10),
    kInstruction_sub_ge_r3_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r5_r14_r13),
    kInstruction_sub_gt_r5_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r7_r0_r13),
    kInstruction_sub_le_r7_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r8_r5_r1),
    kInstruction_sub_lt_r8_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r3_r4_r8),
    kInstruction_sub_le_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r5_r11_r13),
    kInstruction_sub_ne_r5_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r9_r8_r2),
    kInstruction_sub_ge_r9_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r9_r5_r12),
    kInstruction_sub_gt_r9_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r9_r8_r1),
    kInstruction_sub_pl_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r3_r12_r4),
    kInstruction_sub_le_r3_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r5_r6_r9),
    kInstruction_sub_eq_r5_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r4_r13),
    kInstruction_sub_ne_r14_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r3_r9_r2),
    kInstruction_sub_ge_r3_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r13_r0_r10),
    kInstruction_sub_ls_r13_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r14_r0_r2),
    kInstruction_sub_mi_r14_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r11_r1_r3),
    kInstruction_sub_cs_r11_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r8_r9_r10),
    kInstruction_sub_ne_r8_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r9_r10_r4),
    kInstruction_sub_gt_r9_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r2_r8_r4),
    kInstruction_sub_le_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r6_r14_r11),
    kInstruction_sub_al_r6_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r3_r14_r14),
    kInstruction_sub_eq_r3_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r9_r9_r3),
    kInstruction_sub_pl_r9_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r5_r13_r12),
    kInstruction_sub_ge_r5_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r10_r6_r5),
    kInstruction_sub_mi_r10_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r14_r13_r12),
    kInstruction_sub_ls_r14_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r10_r9_r10),
    kInstruction_sub_lt_r10_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r7_r4_r9),
    kInstruction_sub_ls_r7_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r9_r10_r7),
    kInstruction_sub_cs_r9_r10_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r4_r2_r2),
    kInstruction_sub_eq_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r14_r13_r4),
    kInstruction_sub_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r0_r3_r5),
    kInstruction_sub_al_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r9_r6_r7),
    kInstruction_sub_vs_r9_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r0_r6_r4),
    kInstruction_sub_ls_r0_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r7_r10_r14),
    kInstruction_sub_ne_r7_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r2_r12_r1),
    kInstruction_sub_le_r2_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r1_r5_r0),
    kInstruction_sub_cs_r1_r5_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r0_r9_r1),
    kInstruction_sub_pl_r0_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r2_r2_r5),
    kInstruction_sub_mi_r2_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r5_r1_r12),
    kInstruction_sub_hi_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r13_r14_r7),
    kInstruction_sub_ls_r13_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r0_r4_r3),
    kInstruction_sub_lt_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r8_r13_r2),
    kInstruction_sub_cc_r8_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r7_r8_r14),
    kInstruction_sub_ls_r7_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r13_r11_r13),
    kInstruction_sub_hi_r13_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r13_r7_r6),
    kInstruction_sub_ge_r13_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r3_r2_r0),
    kInstruction_sub_mi_r3_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r12_r0_r10),
    kInstruction_sub_cs_r12_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r9_r10_r8),
    kInstruction_sub_vs_r9_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r2_r8_r8),
    kInstruction_sub_ls_r2_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r1_r11_r3),
    kInstruction_sub_ge_r1_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r12_r3_r3),
    kInstruction_sub_ge_r12_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r3_r8_r6),
    kInstruction_sub_gt_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r13_r2_r9),
    kInstruction_sub_ne_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r14_r9_r1),
    kInstruction_sub_ls_r14_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r2_r10_r2),
    kInstruction_sub_cc_r2_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r9_r12_r1),
    kInstruction_sub_le_r9_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r11_r10_r0),
    kInstruction_sub_cs_r11_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r7_r0_r5),
    kInstruction_sub_eq_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r10_r4_r4),
    kInstruction_sub_ne_r10_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r13_r9_r6),
    kInstruction_sub_pl_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r11_r3_r3),
    kInstruction_sub_vc_r11_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r1_r13_r9),
    kInstruction_sub_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r13_r9_r14),
    kInstruction_sub_cc_r13_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r5_r2_r3),
    kInstruction_sub_vc_r5_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r12_r8_r10),
    kInstruction_sub_ne_r12_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r11_r13_r6),
    kInstruction_sub_cs_r11_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r1_r11_r10),
    kInstruction_sub_al_r1_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r6_r11),
    kInstruction_sub_ne_r14_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r1_r14_r5),
    kInstruction_sub_cs_r1_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r11_r11_r6),
    kInstruction_sub_al_r11_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r3_r6_r2),
    kInstruction_sub_pl_r3_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r3_r9_r4),
    kInstruction_sub_ne_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r11_r4_r9),
    kInstruction_sub_mi_r11_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r10_r1_r3),
    kInstruction_sub_al_r10_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r2_r14_r11),
    kInstruction_sub_vc_r2_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r9_r3_r0),
    kInstruction_sub_mi_r9_r3_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r9_r8_r1),
    kInstruction_sub_vs_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r2_r12_r5),
    kInstruction_sub_lt_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r9_r8_r12),
    kInstruction_sub_al_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r3_r8_r0),
    kInstruction_sub_vc_r3_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r10_r5_r1),
    kInstruction_sub_mi_r10_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r7_r14_r2),
    kInstruction_sub_vc_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r0_r9_r7),
    kInstruction_sub_ls_r0_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r3_r0_r10),
    kInstruction_sub_cs_r3_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r10_r8_r10),
    kInstruction_sub_cc_r10_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r5_r4_r1),
    kInstruction_sub_eq_r5_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r11_r13_r1),
    kInstruction_sub_vc_r11_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r6_r5_r8),
    kInstruction_sub_hi_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r10_r5_r6),
    kInstruction_sub_ne_r10_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r10_r12_r9),
    kInstruction_sub_al_r10_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r5_r1_r12),
    kInstruction_sub_eq_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r0_r14_r10),
    kInstruction_sub_le_r0_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r4_r2_r5),
    kInstruction_sub_eq_r4_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r5_r8_r2),
    kInstruction_sub_pl_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r5_r14_r4),
    kInstruction_sub_hi_r5_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r2_r7_r9),
    kInstruction_sub_le_r2_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r5_r12_r6),
    kInstruction_sub_pl_r5_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r11_r4_r14),
    kInstruction_sub_vs_r11_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r0_r7_r14),
    kInstruction_sub_eq_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r5_r2_r5),
    kInstruction_sub_pl_r5_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r5_r11_r7),
    kInstruction_sub_ne_r5_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r7_r9_r10),
    kInstruction_sub_pl_r7_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r4_r2_r2),
    kInstruction_sub_hi_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r14_r9_r2),
    kInstruction_sub_pl_r14_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r4_r11_r13),
    kInstruction_sub_le_r4_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r8_r8_r8),
    kInstruction_sub_pl_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r0_r6_r10),
    kInstruction_sub_ge_r0_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r4_r4_r10),
    kInstruction_sub_vc_r4_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r11_r9_r12),
    kInstruction_sub_cc_r11_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r14_r4_r12),
    kInstruction_sub_pl_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r8_r8_r8),
    kInstruction_sub_vs_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r14_r2_r12),
    kInstruction_sub_ge_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r8_r2_r13),
    kInstruction_sub_ge_r8_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r10_r0_r11),
    kInstruction_sub_vs_r10_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r5_r1_r2),
    kInstruction_sub_eq_r5_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r10_r11_r3),
    kInstruction_sub_vs_r10_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r13_r13_r7),
    kInstruction_sub_lt_r13_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r12_r7_r6),
    kInstruction_sub_le_r12_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r4_r3_r3),
    kInstruction_sub_eq_r4_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r0_r5_r8),
    kInstruction_sub_pl_r0_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r10_r5_r3),
    kInstruction_sub_vs_r10_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r0_r11_r9),
    kInstruction_sub_gt_r0_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r8_r5_r9),
    kInstruction_sub_cc_r8_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r9_r12_r11),
    kInstruction_sub_cs_r9_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r3_r4_r8),
    kInstruction_sub_gt_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r8_r3_r10),
    kInstruction_sub_ls_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r8_r14_r12),
    kInstruction_sub_eq_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r7_r1_r3),
    kInstruction_sub_gt_r7_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r4_r4_r8),
    kInstruction_sub_al_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r9_r14_r10),
    kInstruction_sub_gt_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r3_r13_r2),
    kInstruction_sub_lt_r3_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r4_r11_r14),
    kInstruction_sub_le_r4_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r2_r14_r0),
    kInstruction_sub_ge_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r1_r8_r8),
    kInstruction_sub_pl_r1_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r9_r2_r5),
    kInstruction_sub_pl_r9_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r13_r13_r1),
    kInstruction_sub_vs_r13_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r12_r14_r3),
    kInstruction_sub_ge_r12_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r0_r11_r4),
    kInstruction_sub_vc_r0_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r0_r2_r9),
    kInstruction_sub_ge_r0_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r12_r1_r6),
    kInstruction_sub_vc_r12_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r1_r3_r7),
    kInstruction_sub_ne_r1_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r10_r3_r9),
    kInstruction_sub_vs_r10_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r14_r4_r1),
    kInstruction_sub_cc_r14_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r9_r3_r7),
    kInstruction_sub_le_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r1_r0_r14),
    kInstruction_sub_le_r1_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r0_r14_r4),
    kInstruction_sub_le_r0_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r13_r8_r11),
    kInstruction_sub_hi_r13_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r10_r6_r11),
    kInstruction_sub_cc_r10_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r0_r10_r14),
    kInstruction_sub_cc_r0_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r4_r4_r0),
    kInstruction_sub_le_r4_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r8_r14_r12),
    kInstruction_sub_pl_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r13_r12_r2),
    kInstruction_sub_ge_r13_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r11_r11_r7),
    kInstruction_sub_al_r11_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r11_r12_r1),
    kInstruction_sub_ls_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r10_r14_r14),
    kInstruction_sub_vs_r10_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r2_r8_r12),
    kInstruction_sub_pl_r2_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r12_r7_r11),
    kInstruction_sub_pl_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r5_r8_r13),
    kInstruction_sub_eq_r5_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r6_r6_r6),
    kInstruction_sub_vc_r6_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r0_r12_r1),
    kInstruction_sub_vs_r0_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r6_r0_r8),
    kInstruction_sub_cs_r6_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r3_r4_r1),
    kInstruction_sub_cc_r3_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r1_r10_r14),
    kInstruction_sub_lt_r1_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r1_r3_r5),
    kInstruction_sub_le_r1_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r11_r1_r1),
    kInstruction_sub_cc_r11_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r1_r8_r7),
    kInstruction_sub_vc_r1_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r3_r10_r13),
    kInstruction_sub_eq_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r14_r12_r12),
    kInstruction_sub_hi_r14_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r10_r1_r14),
    kInstruction_sub_eq_r10_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r3_r1_r6),
    kInstruction_sub_lt_r3_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r9_r12_r10),
    kInstruction_sub_cc_r9_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r13_r14_r14),
    kInstruction_sub_lt_r13_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r2_r6_r9),
    kInstruction_sub_ge_r2_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r3_r9_r1),
    kInstruction_sub_vs_r3_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r1_r9_r12),
    kInstruction_sub_cc_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r5_r0_r6),
    kInstruction_sub_ls_r5_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r6_r14_r10),
    kInstruction_sub_hi_r6_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r11_r10_r3),
    kInstruction_sub_al_r11_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r13_r4_r1),
    kInstruction_sub_ne_r13_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r13_r5_r14),
    kInstruction_sub_hi_r13_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r8_r9_r11),
    kInstruction_sub_ne_r8_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r0_r13_r13),
    kInstruction_sub_eq_r0_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r14_r11_r0),
    kInstruction_sub_ne_r14_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r6_r8_r7),
    kInstruction_sub_mi_r6_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r1_r7_r5),
    kInstruction_sub_eq_r1_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r12_r9_r12),
    kInstruction_sub_pl_r12_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r4_r5_r14),
    kInstruction_sub_al_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r7_r0_r12),
    kInstruction_sub_pl_r7_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r5_r0_r13),
    kInstruction_sub_mi_r5_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r10_r7_r11),
    kInstruction_sub_al_r10_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r2_r10_r0),
    kInstruction_sub_gt_r2_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r11_r11_r8),
    kInstruction_sub_ge_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r14_r7_r3),
    kInstruction_sub_eq_r14_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r0_r12_r4),
    kInstruction_sub_ls_r0_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r10_r1_r7),
    kInstruction_sub_ne_r10_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r14_r3_r13),
    kInstruction_sub_hi_r14_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r1_r5_r12),
    kInstruction_sub_le_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r8_r5_r11),
    kInstruction_sub_ne_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r5_r13_r0),
    kInstruction_sub_le_r5_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r8_r12_r7),
    kInstruction_sub_gt_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r9_r14_r3),
    kInstruction_sub_eq_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r10_r9_r9),
    kInstruction_sub_cs_r10_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r5_r13_r8),
    kInstruction_sub_vc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r4_r1_r8),
    kInstruction_sub_eq_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r12_r14_r9),
    kInstruction_sub_lt_r12_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r8_r8_r0),
    kInstruction_sub_cc_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r0_r14_r12),
    kInstruction_sub_hi_r0_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r4_r1_r10),
    kInstruction_sub_hi_r4_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r2_r14_r12),
    kInstruction_sub_gt_r2_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r1_r8_r14),
    kInstruction_sub_vs_r1_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r4_r1_r6),
    kInstruction_sub_cs_r4_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r7_r8_r7),
    kInstruction_sub_hi_r7_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r3_r11_r8),
    kInstruction_sub_hi_r3_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r1_r12_r9),
    kInstruction_sub_lt_r1_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r13_r4_r12),
    kInstruction_sub_cs_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r10_r10_r5),
    kInstruction_sub_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r10_r14_r0),
    kInstruction_sub_ge_r10_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r3_r3_r2),
    kInstruction_sub_lt_r3_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vs_r2_r13_r2),
    kInstruction_sub_vs_r2_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r6_r2_r12),
    kInstruction_sub_ls_r6_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r5_r11_r12),
    kInstruction_sub_gt_r5_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r11_r10_r6),
    kInstruction_sub_al_r11_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r12_r14_r14),
    kInstruction_sub_hi_r12_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r12_r10_r6),
    kInstruction_sub_ge_r12_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r8_r3_r9),
    kInstruction_sub_eq_r8_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r7_r5_r1),
    kInstruction_sub_cc_r7_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r3_r0_r6),
    kInstruction_sub_lt_r3_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r14_r4_r12),
    kInstruction_sub_le_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r9_r6_r4),
    kInstruction_sub_le_r9_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r6_r11_r0),
    kInstruction_sub_hi_r6_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r3_r7_r6),
    kInstruction_sub_al_r3_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_lt_r10_r9_r12),
    kInstruction_sub_lt_r10_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r14_r8_r4),
    kInstruction_sub_al_r14_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r14_r11_r14),
    kInstruction_sub_le_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r14_r13_r8),
    kInstruction_sub_al_r14_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ge_r5_r9_r10),
    kInstruction_sub_ge_r5_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_eq_r1_r9_r4),
    kInstruction_sub_eq_r1_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r5_r13_r8),
    kInstruction_sub_cc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ne_r10_r0_r14),
    kInstruction_sub_ne_r10_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r2_r0_r10),
    kInstruction_sub_al_r2_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sub_pl_r4_r0_r11),
    kInstruction_sub_pl_r4_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r13_r5_r12),
    kInstruction_sub_gt_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r2_r13_r8),
    kInstruction_sub_al_r2_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sub_mi_r11_r3_r4),
    kInstruction_sub_mi_r11_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sub_le_r11_r8_r1),
    kInstruction_sub_le_r11_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_hi_r12_r11_r1),
    kInstruction_sub_hi_r12_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_ls_r6_r7_r2),
    kInstruction_sub_ls_r6_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r7_r11_r2),
    kInstruction_sub_cs_r7_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sub_vc_r11_r13_r7),
    kInstruction_sub_vc_r11_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cs_r13_r0_r1),
    kInstruction_sub_cs_r13_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sub_cc_r5_r4_r6),
    kInstruction_sub_cc_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sub_gt_r4_r4_r13),
    kInstruction_sub_gt_r4_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sub_al_r14_r8_r2),
    kInstruction_sub_al_r14_r8_r2,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_SUB_A32_H_
