" VimTeX - LaTeX plugin for Vim
"
" Maintainer: Karl Yngve Lervåg
" Email:      karl.yngve@gmail.com
"

" This script has a lot of unicode characters (for conceals)
scriptencoding utf-8

function! vimtex#syntax#p#amssymb#load(cfg) abort " {{{1
  if !g:vimtex_syntax_conceal.math_symbols | return | endif

  syntax match texMathSymbol '\%#=1\\Bbbk\>'                contained conceal cchar=𝕜
  syntax match texMathSymbol '\%#=1\\Bumpeq\>'              contained conceal cchar=≎
  syntax match texMathSymbol '\%#=1\\Finv\>'                contained conceal cchar=Ⅎ
  syntax match texMathSymbol '\%#=1\\Game\>'                contained conceal cchar=⅁
  syntax match texMathSymbol '\%#=1\\Lleftarrow\>'          contained conceal cchar=⇚
  syntax match texMathSymbol '\%#=1\\Rrightarrow\>'         contained conceal cchar=⇛
  syntax match texMathSymbol '\%#=1\\Subset\>'              contained conceal cchar=⋐
  syntax match texMathSymbol '\%#=1\\Supset\>'              contained conceal cchar=⋑
  syntax match texMathSymbol '\%#=1\\Vdash\>'               contained conceal cchar=⊩
  syntax match texMathSymbol '\%#=1\\Vvdash\>'              contained conceal cchar=⊪
  syntax match texMathSymbol '\%#=1\\approxeq\>'            contained conceal cchar=≊
  syntax match texMathSymbol '\%#=1\\backepsilon\>'         contained conceal cchar=∍
  syntax match texMathSymbol '\%#=1\\backprime\>'           contained conceal cchar=‵
  syntax match texMathSymbol '\%#=1\\backsim\>'             contained conceal cchar=∽
  syntax match texMathSymbol '\%#=1\\backsimeq\>'           contained conceal cchar=⋍
  syntax match texMathSymbol '\%#=1\\barwedge\>'            contained conceal cchar=⊼
  syntax match texMathSymbol '\%#=1\\because\>'             contained conceal cchar=∵
  syntax match texMathSymbol '\%#=1\\beth\>'                contained conceal cchar=ℶ
  syntax match texMathSymbol '\%#=1\\between\>'             contained conceal cchar=≬
  syntax match texMathSymbol '\%#=1\\bigstar\>'             contained conceal cchar=★
  syntax match texMathSymbol '\%#=1\\blacklozenge\>'        contained conceal cchar=◆
  syntax match texMathSymbol '\%#=1\\blacksquare\>'         contained conceal cchar=■
  syntax match texMathSymbol '\%#=1\\blacktriangle\>'       contained conceal cchar=▲
  syntax match texMathSymbol '\%#=1\\blacktriangledown\>'   contained conceal cchar=▼
  syntax match texMathSymbol '\%#=1\\blacktriangleleft\>'   contained conceal cchar=◀
  syntax match texMathSymbol '\%#=1\\blacktriangleright\>'  contained conceal cchar=▶
  syntax match texMathSymbol '\%#=1\\boxdot\>'              contained conceal cchar=⊡
  syntax match texMathSymbol '\%#=1\\boxminus\>'            contained conceal cchar=⊟
  syntax match texMathSymbol '\%#=1\\boxplus\>'             contained conceal cchar=⊞
  syntax match texMathSymbol '\%#=1\\boxtimes\>'            contained conceal cchar=⊠
  syntax match texMathSymbol '\%#=1\\bumpeq\>'              contained conceal cchar=≏
  syntax match texMathSymbol '\%#=1\\centerdot\>'           contained conceal cchar=⋅
  syntax match texMathSymbol '\%#=1\\checkmark\>'           contained conceal cchar=✓
  syntax match texMathSymbol '\%#=1\\circeq\>'              contained conceal cchar=≗
  syntax match texMathSymbol '\%#=1\\circlearrowleft\>'     contained conceal cchar=↺
  syntax match texMathSymbol '\%#=1\\circlearrowright\>'    contained conceal cchar=↻
  syntax match texMathSymbol '\%#=1\\circledS\>'            contained conceal cchar=Ⓢ
  syntax match texMathSymbol '\%#=1\\circledast\>'          contained conceal cchar=⊛
  syntax match texMathSymbol '\%#=1\\circledcirc\>'         contained conceal cchar=⊚
  syntax match texMathSymbol '\%#=1\\circleddash\>'         contained conceal cchar=⊝
  syntax match texMathSymbol '\%#=1\\complement\>'          contained conceal cchar=∁
  syntax match texMathSymbol '\%#=1\\curlyeqprec\>'         contained conceal cchar=⋞
  syntax match texMathSymbol '\%#=1\\curlyeqsucc\>'         contained conceal cchar=⋟
  syntax match texMathSymbol '\%#=1\\curlyvee\>'            contained conceal cchar=⋎
  syntax match texMathSymbol '\%#=1\\curlywedge\>'          contained conceal cchar=⋏
  syntax match texMathSymbol '\%#=1\\curvearrowleft\>'      contained conceal cchar=↶
  syntax match texMathSymbol '\%#=1\\curvearrowright\>'     contained conceal cchar=↷
  syntax match texMathSymbol '\%#=1\\daleth\>'              contained conceal cchar=ℸ
  syntax match texMathSymbol '\%#=1\\diagdown\>'            contained conceal cchar=╲
  syntax match texMathSymbol '\%#=1\\diagup\>'              contained conceal cchar=╱
  syntax match texMathSymbol '\%#=1\\digamma\>'             contained conceal cchar=ϝ
  syntax match texMathSymbol '\%#=1\\divideontimes\>'       contained conceal cchar=⋇
  syntax match texMathSymbol '\%#=1\\doteqdot\>'            contained conceal cchar=≑
  syntax match texMathSymbol '\%#=1\\dotplus\>'             contained conceal cchar=∔
  syntax match texMathSymbol '\%#=1\\doublebarwedge\>'      contained conceal cchar=⩞
  syntax match texMathSymbol '\%#=1\\downdownarrows\>'      contained conceal cchar=⇊
  syntax match texMathSymbol '\%#=1\\downharpoonleft\>'     contained conceal cchar=⇃
  syntax match texMathSymbol '\%#=1\\downharpoonright\>'    contained conceal cchar=⇂
  syntax match texMathSymbol '\%#=1\\eqcirc\>'              contained conceal cchar=≖
  syntax match texMathSymbol '\%#=1\\eqsim\>'               contained conceal cchar=≂
  syntax match texMathSymbol '\%#=1\\eqslantgtr\>'          contained conceal cchar=⪖
  syntax match texMathSymbol '\%#=1\\eqslantless\>'         contained conceal cchar=⪕
  syntax match texMathSymbol '\%#=1\\fallingdotseq\>'       contained conceal cchar=≒
  syntax match texMathSymbol '\%#=1\\geqq\>'                contained conceal cchar=≧
  syntax match texMathSymbol '\%#=1\\geqslant\>'            contained conceal cchar=⩾
  syntax match texMathSymbol '\%#=1\\gimel\>'               contained conceal cchar=ℷ
  syntax match texMathSymbol '\%#=1\\gnapprox\>'            contained conceal cchar=⪊
  syntax match texMathSymbol '\%#=1\\gneq\>'                contained conceal cchar=⪈
  syntax match texMathSymbol '\%#=1\\gneqq\>'               contained conceal cchar=≩
  syntax match texMathSymbol '\%#=1\\gnsim\>'               contained conceal cchar=⋧
  syntax match texMathSymbol '\%#=1\\gtrapprox\>'           contained conceal cchar=⪆
  syntax match texMathSymbol '\%#=1\\gtrdot\>'              contained conceal cchar=⋗
  syntax match texMathSymbol '\%#=1\\gtreqless\>'           contained conceal cchar=⋛
  syntax match texMathSymbol '\%#=1\\gtreqqless\>'          contained conceal cchar=⪌
  syntax match texMathSymbol '\%#=1\\gtrless\>'             contained conceal cchar=≷
  syntax match texMathSymbol '\%#=1\\gtrsim\>'              contained conceal cchar=≳
  syntax match texMathSymbol '\%#=1\\gvertneqq\>'           contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\hslash\>'              contained conceal cchar=ℏ
  syntax match texMathSymbol '\%#=1\\intercal\>'            contained conceal cchar=⊺
  syntax match texMathSymbol '\%#=1\\leftarrowtail\>'       contained conceal cchar=↢
  syntax match texMathSymbol '\%#=1\\leftleftarrows\>'      contained conceal cchar=⇇
  syntax match texMathSymbol '\%#=1\\leftrightarrows\>'     contained conceal cchar=⇆
  syntax match texMathSymbol '\%#=1\\leftrightharpoons\>'   contained conceal cchar=⇋
  syntax match texMathSymbol '\%#=1\\leftrightsquigarrow\>' contained conceal cchar=↭
  syntax match texMathSymbol '\%#=1\\leftthreetimes\>'      contained conceal cchar=⋋
  syntax match texMathSymbol '\%#=1\\leqq\>'                contained conceal cchar=≦
  syntax match texMathSymbol '\%#=1\\leqslant\>'            contained conceal cchar=⩽
  syntax match texMathSymbol '\%#=1\\lessapprox\>'          contained conceal cchar=⪅
  syntax match texMathSymbol '\%#=1\\lessdot\>'             contained conceal cchar=⋖
  syntax match texMathSymbol '\%#=1\\lesseqgtr\>'           contained conceal cchar=⋚
  syntax match texMathSymbol '\%#=1\\lesseqqgtr\>'          contained conceal cchar=⪋
  syntax match texMathSymbol '\%#=1\\lessgtr\>'             contained conceal cchar=≶
  syntax match texMathSymbol '\%#=1\\lesssim\>'             contained conceal cchar=≲
  syntax match texMathSymbol '\%#=1\\lnapprox\>'            contained conceal cchar=⪉
  syntax match texMathSymbol '\%#=1\\lneq\>'                contained conceal cchar=⪇
  syntax match texMathSymbol '\%#=1\\lneqq\>'               contained conceal cchar=≨
  syntax match texMathSymbol '\%#=1\\lnsim\>'               contained conceal cchar=⋦
  syntax match texMathSymbol '\%#=1\\looparrowleft\>'       contained conceal cchar=↫
  syntax match texMathSymbol '\%#=1\\looparrowright\>'      contained conceal cchar=↬
  syntax match texMathSymbol '\%#=1\\lozenge\>'             contained conceal cchar=◊
  syntax match texMathSymbol '\%#=1\\ltimes\>'              contained conceal cchar=⋉
  syntax match texMathSymbol '\%#=1\\lvertneqq\>'           contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\maltese\>'             contained conceal cchar=✠
  syntax match texMathSymbol '\%#=1\\measuredangle\>'       contained conceal cchar=∡
  syntax match texMathSymbol '\%#=1\\multimap\>'            contained conceal cchar=⊸
  syntax match texMathSymbol '\%#=1\\nLeftarrow\>'          contained conceal cchar=⇍
  syntax match texMathSymbol '\%#=1\\nLeftrightarrow\>'     contained conceal cchar=⇎
  syntax match texMathSymbol '\%#=1\\nRightarrow\>'         contained conceal cchar=⇏
  syntax match texMathSymbol '\%#=1\\nVDash\>'              contained conceal cchar=⊯
  syntax match texMathSymbol '\%#=1\\nVdash\>'              contained conceal cchar=⊮
  syntax match texMathSymbol '\%#=1\\ncong\>'               contained conceal cchar=≆
  syntax match texMathSymbol '\%#=1\\nexists\>'             contained conceal cchar=∄
  syntax match texMathSymbol '\%#=1\\ngeq\>'                contained conceal cchar=≱
  syntax match texMathSymbol '\%#=1\\ngeqq\>'               contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\ngeqslant\>'           contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\ngtr\>'                contained conceal cchar=≯
  syntax match texMathSymbol '\%#=1\\nleftarrow\>'          contained conceal cchar=↚
  syntax match texMathSymbol '\%#=1\\nleftrightarrow\>'     contained conceal cchar=↮
  syntax match texMathSymbol '\%#=1\\nleq\>'                contained conceal cchar=≰
  syntax match texMathSymbol '\%#=1\\nleqq\>'               contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\nleqslant\>'           contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\nless\>'               contained conceal cchar=≮
  syntax match texMathSymbol '\%#=1\\nmid\>'                contained conceal cchar=∤
  syntax match texMathSymbol '\%#=1\\nparallel\>'           contained conceal cchar=∦
  syntax match texMathSymbol '\%#=1\\nprec\>'               contained conceal cchar=⊀
  syntax match texMathSymbol '\%#=1\\npreceq\>'             contained conceal cchar=⋠
  syntax match texMathSymbol '\%#=1\\nrightarrow\>'         contained conceal cchar=↛
  syntax match texMathSymbol '\%#=1\\nshortmid\>'           contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\nshortparallel\>'      contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\nsim\>'                contained conceal cchar=≁
  syntax match texMathSymbol '\%#=1\\nsubseteq\>'           contained conceal cchar=⊈
  syntax match texMathSymbol '\%#=1\\nsubseteqq\>'          contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\nsucc\>'               contained conceal cchar=⊁
  syntax match texMathSymbol '\%#=1\\nsucceq\>'             contained conceal cchar=⋡
  syntax match texMathSymbol '\%#=1\\nsupseteq\>'           contained conceal cchar=⊉
  syntax match texMathSymbol '\%#=1\\nsupseteqq\>'          contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\ntriangleleft\>'       contained conceal cchar=⋪
  syntax match texMathSymbol '\%#=1\\ntrianglelefteq\>'     contained conceal cchar=⋬
  syntax match texMathSymbol '\%#=1\\ntriangleright\>'      contained conceal cchar=⋫
  syntax match texMathSymbol '\%#=1\\ntrianglerighteq\>'    contained conceal cchar=⋭
  syntax match texMathSymbol '\%#=1\\nvDash\>'              contained conceal cchar=⊭
  syntax match texMathSymbol '\%#=1\\nvdash\>'              contained conceal cchar=⊬
  syntax match texMathSymbol '\%#=1\\pitchfork\>'           contained conceal cchar=⋔
  syntax match texMathSymbol '\%#=1\\precapprox\>'          contained conceal cchar=⪷
  syntax match texMathSymbol '\%#=1\\preccurlyeq\>'         contained conceal cchar=≼
  syntax match texMathSymbol '\%#=1\\precnapprox\>'         contained conceal cchar=⪹
  syntax match texMathSymbol '\%#=1\\precneqq\>'            contained conceal cchar=⪵
  syntax match texMathSymbol '\%#=1\\precnsim\>'            contained conceal cchar=⋨
  syntax match texMathSymbol '\%#=1\\precsim\>'             contained conceal cchar=≾
  syntax match texMathSymbol '\%#=1\\rightarrowtail\>'      contained conceal cchar=↣
  syntax match texMathSymbol '\%#=1\\rightleftarrows\>'     contained conceal cchar=⇄
  syntax match texMathSymbol '\%#=1\\rightrightarrows\>'    contained conceal cchar=⇉
  syntax match texMathSymbol '\%#=1\\rightsquigarrow\>'     contained conceal cchar=⇝
  syntax match texMathSymbol '\%#=1\\rightthreetimes\>'     contained conceal cchar=⋌
  syntax match texMathSymbol '\%#=1\\risingdotseq\>'        contained conceal cchar=≓
  syntax match texMathSymbol '\%#=1\\rtimes\>'              contained conceal cchar=⋊
  syntax match texMathSymbol '\%#=1\\shortmid\>'            contained conceal cchar=∣
  syntax match texMathSymbol '\%#=1\\shortparallel\>'       contained conceal cchar=∥
  syntax match texMathSymbol '\%#=1\\smallfrown\>'          contained conceal cchar=⌢
  syntax match texMathSymbol '\%#=1\\smallsetminus\>'       contained conceal cchar=∖
  syntax match texMathSymbol '\%#=1\\smallsmile\>'          contained conceal cchar=⌣
  syntax match texMathSymbol '\%#=1\\sphericalangle\>'      contained conceal cchar=∢
  syntax match texMathSymbol '\%#=1\\square\>'              contained conceal cchar=□
  syntax match texMathSymbol '\%#=1\\subseteqq\>'           contained conceal cchar=⫅
  syntax match texMathSymbol '\%#=1\\subsetneq\>'           contained conceal cchar=⊊
  syntax match texMathSymbol '\%#=1\\subsetneqq\>'          contained conceal cchar=⫋
  syntax match texMathSymbol '\%#=1\\succapprox\>'          contained conceal cchar=⪸
  syntax match texMathSymbol '\%#=1\\succcurlyeq\>'         contained conceal cchar=≽
  syntax match texMathSymbol '\%#=1\\succnapprox\>'         contained conceal cchar=⪺
  syntax match texMathSymbol '\%#=1\\succneqq\>'            contained conceal cchar=⪶
  syntax match texMathSymbol '\%#=1\\succnsim\>'            contained conceal cchar=⋩
  syntax match texMathSymbol '\%#=1\\succsim\>'             contained conceal cchar=≿
  syntax match texMathSymbol '\%#=1\\supseteqq\>'           contained conceal cchar=⫆
  syntax match texMathSymbol '\%#=1\\supsetneq\>'           contained conceal cchar=⊋
  syntax match texMathSymbol '\%#=1\\supsetneqq\>'          contained conceal cchar=⫌
  syntax match texMathSymbol '\%#=1\\therefore\>'           contained conceal cchar=∴
  syntax match texMathSymbol '\%#=1\\thickapprox\>'         contained conceal cchar=≈
  syntax match texMathSymbol '\%#=1\\thicksim\>'            contained conceal cchar=∼
  syntax match texMathSymbol '\%#=1\\triangledown\>'        contained conceal cchar=▽
  syntax match texMathSymbol '\%#=1\\trianglelefteq\>'      contained conceal cchar=⊴
  syntax match texMathSymbol '\%#=1\\triangleq\>'           contained conceal cchar=≜
  syntax match texMathSymbol '\%#=1\\trianglerighteq\>'     contained conceal cchar=⊵
  syntax match texMathSymbol '\%#=1\\twoheadleftarrow\>'    contained conceal cchar=↞
  syntax match texMathSymbol '\%#=1\\twoheadrightarrow\>'   contained conceal cchar=↠
  syntax match texMathSymbol '\%#=1\\upharpoonleft\>'       contained conceal cchar=↿
  syntax match texMathSymbol '\%#=1\\upharpoonright\>'      contained conceal cchar=↾
  syntax match texMathSymbol '\%#=1\\upuparrows\>'          contained conceal cchar=⇈
  syntax match texMathSymbol '\%#=1\\vDash\>'               contained conceal cchar=⊨
  syntax match texMathSymbol '\%#=1\\varkappa\>'            contained conceal cchar=ϰ
  syntax match texMathSymbol '\%#=1\\varnothing\>'          contained conceal cchar=∅
  syntax match texMathSymbol '\%#=1\\varpropto\>'           contained conceal cchar=∝
  syntax match texMathSymbol '\%#=1\\varsubsetneq\>'        contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\varsubsetneqq\>'       contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\varsupsetneq\>'        contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\varsupsetneqq\>'       contained conceal cchar=
  syntax match texMathSymbol '\%#=1\\vartriangle\>'         contained conceal cchar=△
  syntax match texMathSymbol '\%#=1\\vartriangleleft\>'     contained conceal cchar=⊲
  syntax match texMathSymbol '\%#=1\\vartriangleright\>'    contained conceal cchar=⊳
  syntax match texMathSymbol '\%#=1\\veebar\>'              contained conceal cchar=⊻
  syntax match texMathSymbol '\%#=1\\ulcorner\>'            contained conceal cchar=⌜
  syntax match texMathSymbol '\%#=1\\urcorner\>'            contained conceal cchar=⌝
  syntax match texMathSymbol '\%#=1\\llcorner\>'            contained conceal cchar=⌞
  syntax match texMathSymbol '\%#=1\\lrcorner\>'            contained conceal cchar=⌟
endfunction

" }}}1
