#include <vdkb2/vdkdclock.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
static  char buff[64];

DEFINE_SIGNAL_LIST(VDKDigitalClock,VDKEventBox);
DEFINE_EVENT_LIST(VDKDigitalClock,VDKEventBox);

/*
  constructor
*/
VDKDigitalClock::VDKDigitalClock(VDKForm* owner,bool activated):
  VDKEventBox(owner),activated(activated),
  ClockBackground("ClockBackground",this,clBlack,
		  &VDKDigitalClock::SetClockBackground),
  ClockForeground("ClockForeground",this,clGreen,
		  &VDKDigitalClock::SetClockForeground),
  Alarm("Alarm",this,VDKPoint(-1,-1),&VDKDigitalClock::SetAlarm)

{
    ConnectDefaultSignals();
}
/*
  fill the widget and initialize
 */
void
VDKDigitalClock::Setup(void)
{
    VDKFixed* fixed = new VDKFixed(Owner());
    // makes a timer with 1000 msecs thick
    timer = new VDKTimer(Owner(),1000,false);
    // 	since timer isn't added it has Owner() as
    //	default parent.
    // 	we change the parent to <this> in order to
    // 	receive timer_tick_signal
    timer->Parent(this);
    // 	add a canvas used to display time
    clock = new VDKCanvas(Owner(),60,20);
    clock->NormalBackground = ClockBackground;
    clock->Foreground = ClockForeground;
    clock->Font = new VDKFont(Owner(),"courier bold 10");
    fixed->Add(clock,0,0);
    // 	add a button
    set = new VDKCustomButton(Owner(),"Alarm");
    set->SetSize(60,20);
    fixed->Add(set,0,21);
    Add(fixed,l_justify,false,false,0);
    // by default disables alarm
    alarm_enabled = false;
    // initialize pop form to NULL
    popform = NULL;		
    //
    if(activated)
	Activate();
    
}
/*
 */
void
VDKDigitalClock::Activate()
{
    // starts timer
    timer->Start();
    // 	connect timer with <this>, since
    // 	"timer_tick_signal" isn't a gtk+
    // 	provided signal we have to set
    // 	<gtk> arg to false thus letting vdk to
    // 	handle signal internally.
    SignalConnect(timer,"timer_tick_signal",
		  &VDKDigitalClock::OnTimer,false);
    // connect button with
    SignalConnect(set,"clicked",&VDKDigitalClock::OnSetClick);
    // connect canvas event
    EventConnect(clock,"expose_event",&VDKDigitalClock::OnExpose);
    EventConnect(clock,"button_press_event",
		 &VDKDigitalClock::OnClockButtonPress);
    EventConnect(clock,"button_release_event",
	&VDKDigitalClock::OnClockButtonRelease);

}

/*
  destructor
 */
VDKDigitalClock::~VDKDigitalClock()
{
  timer->Stop();
}


/*
  sets background
 */
void
VDKDigitalClock::SetClockBackground(VDKRgb back)
{
  clock->NormalBackground = ClockBackground;
  OnTimer(NULL);
}
/*
  sets foreground
 */
void
VDKDigitalClock::SetClockForeground(VDKRgb back)
{
  OnTimer(NULL);
}

/*
  received when user clicks on
  "Alarm" button, emits a "clock_alarm_set"
  to parent.
 */
bool
VDKDigitalClock::OnSetClick(VDKObject*)
{
    SignalEmitParent("clock_alarm_set");
    return true;
}
/*
  received when timer ticks,
  displays time and send "clock_alarm"
  if applicable
 */
bool
VDKDigitalClock::OnTimer(VDKObject*)
{
  time_t t = time(&t);
  struct tm *loc_t = localtime(&t);
  sprintf(timebuff,"%02d:%02d:%02d",
	  loc_t->tm_hour,
	  loc_t->tm_min,
	  loc_t->tm_sec);
  clock->Foreground = ClockForeground;
  clock->Clear();
  clock->DrawString(8,15,timebuff);
  clock->Redraw();
  VDKPoint p = Alarm;
  if((alarm_enabled) &&
     (p.x >= 0) &&
     (p.y >= 0) &&
     (p.x == loc_t->tm_hour) &&
     (p.y == loc_t->tm_min)
     )
    {
	SignalEmitParent("clock_alarm");
    }

  return true;
}

/*
  call OnTimer with NULL so time
  will be redisplayed, The first time
  is received set current date as tip.
 */
bool
VDKDigitalClock::OnExpose(VDKObject *, GdkEvent* event)
{
  static bool exposed = false;
  if(!exposed)
    {
      calendardate today;
      sprintf(buff,"%s",today.CalendarDate());
      clock->SetTip(buff);
    }
  OnTimer(NULL);
  exposed = true;
  return true;
}
/*
  make a splash form displaying current alarm setting
 */
void
VDKDigitalClockPopForm::Setup()
{
NormalBackground = clWhite;
if(alarm.x < 0 || alarm.y < 0)
	sprintf(buff,"no alarm");
else
	sprintf(buff,"alarm at: %02d:%02d",alarm.x,alarm.y);
VDKLabel* label = new VDKLabel(this,buff);
Add(label,false,false,false);
}
/*
  display splash form
*/
bool
VDKDigitalClock::OnClockButtonPress(VDKObject *, GdkEvent* event)
{
    if(!popform)
	{
	    VDKPoint alarm = Alarm;
	    popform = new VDKDigitalClockPopForm(Owner(),alarm);
	    popform->Setup();
	    popform->Show(GTK_WIN_POS_MOUSE);
	}
    return true;
}
/*
  remove splash form
 */
bool
VDKDigitalClock::OnClockButtonRelease(VDKObject *, GdkEvent* event)
{
if(popform)
    {
	popform->Close();
	popform->Destroy();
	popform = NULL;
    }
return true;
}
