/*
 *   This file is part of VBA Express.
 *
 *   Copyright (c) 2005-2006 Achraf cherti <achrafcherti@gmail.com>
 * 
 *   VBA Express is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   VBA Express is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with VBA Express; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "interface.h"
#include <FL/Fl.H>
#include <FL/x.H>
#include <FL/fl_ask.H>
#include <stdlib.h>
#include <stdio.h>
#include "gba.xpm"
#include "vbaexpress.xpm"
#include "sdl_key.h"
extern Display *fl_display;

myWindow::myWindow(int w, int h, const char *str) : Fl_Double_Window(w,h,str) {
  event_enabled=1;
}

int myWindow::handle(int e) {
  if(!event_enabled) return 1;

if(e==FL_KEYBOARD && Fl::event_key()==FL_Escape) 
	return 1;

return Fl_Double_Window::handle(e);
}

void InterfaceConfig::cb_btn_ok_i(Fl_Button*, void*) {
  MainWindow->hide();
ok=1;
}
void InterfaceConfig::cb_btn_ok(Fl_Button* o, void* v) {
  ((InterfaceConfig*)(o->parent()->user_data()))->cb_btn_ok_i(o,v);
}

void InterfaceConfig::cb_btn_annuler_i(Fl_Button*, void*) {
  MainWindow->hide();
}
void InterfaceConfig::cb_btn_annuler(Fl_Button* o, void* v) {
  ((InterfaceConfig*)(o->parent()->user_data()))->cb_btn_annuler_i(o,v);
}

InterfaceConfig::InterfaceConfig() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = MainWindow = new Fl_Double_Window(355, 205, "Configuration");
    w = o;
    o->color((Fl_Color)146);
    o->user_data((void*)(this));
    { Fl_Box* o = new Fl_Box(113, 18, 55, 25, "VBA");
      o->labelfont(1);
      o->labelsize(22);
      o->labelcolor((Fl_Color)129);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(166, 18, 89, 25, "Express");
      o->labelfont(2);
      o->labelsize(22);
      o->labelcolor((Fl_Color)237);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = label_config_interface = new Fl_Box(90, 42, 175, 16, "Configuration de l\'interface");
      o->labelfont(1);
      o->labelsize(12);
      o->labelcolor((Fl_Color)196);
    }
    { Fl_Check_Button* o = check_fenetre_centree = new Fl_Check_Button(23, 70, 306, 20, "D\351marrer la fen\352tre centr\351""e");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
    }
    { Fl_Check_Button* o = check_sauvegarde_automatique = new Fl_Check_Button(23, 96, 306, 21, "Sauvegarde de la configuration automatique");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
    }
    { Fl_Check_Button* o = check_souvenir_onglet = new Fl_Check_Button(23, 124, 306, 21, "Se souvenir de l\'onglet actuel");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
    }
    { Fl_Button* o = btn_ok = new Fl_Button(80, 162, 90, 23, "&Ok");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelfont(1);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_btn_ok);
    }
    { Fl_Button* o = btn_annuler = new Fl_Button(184, 162, 90, 23, "&Annuler");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelfont(2);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_btn_annuler);
    }
    o->set_modal();
    o->end();
  }
}

InterfaceConfig::~InterfaceConfig() {
  delete MainWindow;
}

int InterfaceConfig::show() {
  MainWindow->show();
while(MainWindow->shown()) {
Fl::check();
}
return ok;
}

void TextViewer::cb_btn_fermer_i(Fl_Button*, void*) {
  MainWindow->hide();
}
void TextViewer::cb_btn_fermer(Fl_Button* o, void* v) {
  ((TextViewer*)(o->parent()->user_data()))->cb_btn_fermer_i(o,v);
}

TextViewer::TextViewer() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = MainWindow = new Fl_Double_Window(625, 495);
    w = o;
    o->color((Fl_Color)146);
    o->user_data((void*)(this));
    { Fl_Button* o = btn_fermer = new Fl_Button(250, 459, 125, 22, "Fermer");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_btn_fermer);
    }
    { Fl_Browser* o = browser = new Fl_Browser(7, 10, 608, 435);
      o->labelfont(4);
      o->labelsize(12);
      o->textfont(4);
      o->textsize(12);
    }
    o->set_modal();
    o->end();
    o->resizable(o);
  }
}

TextViewer::~TextViewer() {
  delete MainWindow;
}

void TextViewer::show() {
  MainWindow->show();
while(MainWindow->shown()) {
	Fl::wait();
}
}

void About::cb_btn_fermer1_i(Fl_Button*, void*) {
  MainWindow->hide();
}
void About::cb_btn_fermer1(Fl_Button* o, void* v) {
  ((About*)(o->parent()->user_data()))->cb_btn_fermer1_i(o,v);
}

#include <FL/Fl_Image.H>
static unsigned char idata_gba_mini[] =
{112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,
112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,
0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,
86,118,0,35,38,218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,
6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,
0,1,6,9,0,0,181,254,0,85,86,118,0,153,152,200,0,85,86,118,0,11,16,37,0,1,6,9,
0,153,152,200,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,122,124,
142,0,85,86,118,0,11,16,37,0,1,6,9,0,122,124,142,0,93,70,172,0,1,6,9,0,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,18,73,180,0,1,6,9,0,
136,136,183,0,85,86,118,0,25,123,254,0,93,70,172,0,94,94,102,0,85,86,118,0,1,6,
9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,
0,1,6,9,0,166,153,185,0,85,86,118,0,32,144,189,0,85,86,118,0,132,239,39,0,1,6,
9,0,18,73,180,0,1,6,9,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,166,153,185,
0,93,70,172,0,0,181,254,0,85,86,118,0,11,16,37,0,1,6,9,0,166,163,225,0,85,86,
118,0,35,38,218,0,1,6,9,0,16,99,248,0,1,6,9,0,38,42,54,0,85,86,118,0,112,86,153,
0,85,86,118,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,
2,66,183,0,1,6,9,0,153,152,200,0,93,70,172,0,136,136,183,0,85,86,118,0,11,16,
37,0,1,6,9,0,1,113,138,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,
64,65,86,0,85,86,118,0,11,16,37,0,1,6,9,0,166,163,225,0,93,70,172,0,1,6,9,0,1,
6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,136,136,183,0,1,6,9,0,64,65,86,0,1,
6,9,0,117,118,163,0,85,86,118,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,
1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,123,
115,163,0,1,6,9,0,132,239,39,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,
0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,
6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,
172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,181,
158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,
0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,0,0,181,
254,0,85,86,118,0,153,152,200,0,85,86,118,0,11,16,37,0,1,6,9,0,153,152,200,0,85,
86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,122,124,142,0,85,86,118,0,11,
16,37,0,1,6,9,0,122,124,142,0,93,70,172,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,18,73,180,0,1,6,9,0,136,136,183,0,85,86,
118,0,25,123,254,0,93,70,172,0,94,94,102,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,
1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,1,6,9,0,166,153,
185,0,85,86,118,0,32,144,189,0,85,86,118,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,
9,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,166,153,185,0,93,70,172,0,0,181,
254,0,85,86,118,0,11,16,37,0,1,6,9,0,166,163,225,0,85,86,118,0,35,38,218,0,1,6,
9,0,16,99,248,0,1,6,9,0,38,42,54,0,85,86,118,0,112,86,153,0,85,86,118,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,0,
153,152,200,0,93,70,172,0,136,136,183,0,85,86,118,0,11,16,37,0,1,6,9,0,1,113,
138,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,64,65,86,0,85,86,118,
0,11,16,37,0,1,6,9,0,166,163,225,0,93,70,172,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,
0,132,239,39,0,1,6,9,0,136,136,183,0,1,6,9,0,64,65,86,0,1,6,9,0,117,118,163,0,
85,86,118,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,
0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,123,115,163,0,1,6,9,0,132,
239,39,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,
0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,
16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,
135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,
51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,11,
16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,35,38,218,0,1,6,
9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,
9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,0,0,181,254,0,85,86,118,0,153,152,
200,0,85,86,118,0,11,16,37,0,1,6,9,0,153,152,200,0,85,86,118,0,117,118,163,0,1,
6,9,0,64,65,86,0,1,6,9,0,122,124,142,0,85,86,118,0,11,16,37,0,1,6,9,0,122,124,
142,0,93,70,172,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,18,73,180,0,1,6,9,0,136,136,183,0,85,86,118,0,25,123,254,0,93,70,
172,0,94,94,102,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,
9,0,18,73,180,0,1,6,9,0,11,16,37,0,1,6,9,0,166,153,185,0,85,86,118,0,32,144,
189,0,85,86,118,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,35,38,218,0,1,6,9,0,
51,116,221,0,1,6,9,0,166,153,185,0,93,70,172,0,0,181,254,0,85,86,118,0,11,16,
37,0,1,6,9,0,166,163,225,0,85,86,118,0,35,38,218,0,1,6,9,0,16,99,248,0,1,6,9,0,
38,42,54,0,85,86,118,0,112,86,153,0,85,86,118,0,132,239,39,0,1,6,9,0,18,73,180,
0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,0,153,152,200,0,93,70,172,0,
136,136,183,0,85,86,118,0,11,16,37,0,1,6,9,0,1,113,138,0,85,86,118,0,117,118,
163,0,1,6,9,0,64,65,86,0,1,6,9,0,64,65,86,0,85,86,118,0,11,16,37,0,1,6,9,0,166,
163,225,0,93,70,172,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,136,
136,183,0,1,6,9,0,64,65,86,0,1,6,9,0,117,118,163,0,85,86,118,0,11,16,37,0,1,6,9,
0,141,141,167,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,
9,0,18,73,180,0,1,6,9,0,123,115,163,0,1,6,9,0,132,239,39,0,85,86,118,0,181,
158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,
0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,
0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,
0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,
1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,
153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,
141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,
0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,
86,0,2,66,183,0,1,6,9,0,0,181,254,0,85,86,118,0,153,152,200,0,85,86,118,0,11,
16,37,0,1,6,9,0,153,152,200,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,
9,0,122,124,142,0,85,86,118,0,11,16,37,0,1,6,9,0,122,124,142,0,93,70,172,0,1,
6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,18,73,
180,0,1,6,9,0,136,136,183,0,85,86,118,0,25,123,254,0,93,70,172,0,94,94,102,0,85,
86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,
9,0,11,16,37,0,1,6,9,0,166,153,185,0,85,86,118,0,32,144,189,0,85,86,118,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,
166,153,185,0,93,70,172,0,0,181,254,0,85,86,118,0,11,16,37,0,1,6,9,0,166,163,
225,0,85,86,118,0,35,38,218,0,1,6,9,0,16,99,248,0,1,6,9,0,38,42,54,0,85,86,118,
0,112,86,153,0,85,86,118,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,
0,64,65,86,0,2,66,183,0,1,6,9,0,153,152,200,0,93,70,172,0,136,136,183,0,85,86,
118,0,11,16,37,0,1,6,9,0,1,113,138,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,
0,1,6,9,0,64,65,86,0,85,86,118,0,11,16,37,0,1,6,9,0,166,163,225,0,93,70,172,0,
1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,136,136,183,0,1,6,9,0,64,
65,86,0,1,6,9,0,117,118,163,0,85,86,118,0,11,16,37,0,1,6,9,0,141,141,167,0,85,
86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,
9,0,123,115,163,0,1,6,9,0,132,239,39,0,85,86,118,0,181,158,174,0,135,196,116,
0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,
1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,
0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,
148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,
0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,
118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,
35,38,218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,
0,0,181,254,0,85,86,118,0,153,152,200,0,85,86,118,0,11,16,37,0,1,6,9,0,153,
152,200,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,122,124,142,0,85,
86,118,0,11,16,37,0,1,6,9,0,122,124,142,0,93,70,172,0,1,6,9,0,1,6,9,0,1,6,9,0,
1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,18,73,180,0,1,6,9,0,136,136,
183,0,85,86,118,0,25,123,254,0,93,70,172,0,94,94,102,0,85,86,118,0,1,6,9,0,1,6,
9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,1,6,9,
0,166,153,185,0,85,86,118,0,32,144,189,0,85,86,118,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,166,153,185,0,93,70,
172,0,0,181,254,0,85,86,118,0,11,16,37,0,1,6,9,0,166,163,225,0,85,86,118,0,35,
38,218,0,1,6,9,0,16,99,248,0,1,6,9,0,38,42,54,0,85,86,118,0,112,86,153,0,85,86,
118,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,
1,6,9,0,153,152,200,0,93,70,172,0,136,136,183,0,85,86,118,0,11,16,37,0,1,6,9,
0,1,113,138,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,64,65,86,0,
85,86,118,0,11,16,37,0,1,6,9,0,166,163,225,0,93,70,172,0,1,6,9,0,1,6,9,0,1,6,9,
0,1,6,9,0,132,239,39,0,1,6,9,0,136,136,183,0,1,6,9,0,64,65,86,0,1,6,9,0,117,
118,163,0,85,86,118,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,1,6,9,0,1,6,
9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,123,115,163,0,1,
6,9,0,132,239,39,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,
141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,
118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,
0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,
0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,181,158,174,0,135,
196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,35,
38,218,0,1,6,9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,0,0,181,254,0,85,86,
118,0,153,152,200,0,85,86,118,0,11,16,37,0,1,6,9,0,153,152,200,0,85,86,118,0,
117,118,163,0,1,6,9,0,64,65,86,0,1,6,9,0,122,124,142,0,85,86,118,0,11,16,37,0,1,
6,9,0,122,124,142,0,215,213,240,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,204,199,
237,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,
229,255,200,201,225,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,206,200,229,255,191,186,
215,255,188,185,222,255,191,186,215,255,191,186,215,255,191,186,215,255,188,185,
222,255,188,185,222,255,188,185,222,255,188,185,222,255,188,185,222,255,188,185,
222,255,188,185,222,255,188,185,222,255,204,199,237,255,206,200,229,255,204,199,
237,255,204,199,237,255,204,199,237,255,204,199,237,255,204,199,237,255,204,199,
237,255,204,199,237,255,204,199,237,255,204,199,237,255,199,194,238,255,199,194,
238,255,199,194,238,255,199,194,238,255,199,194,238,255,199,194,238,255,199,194,
238,255,199,194,238,255,199,194,238,255,204,199,237,255,204,199,237,255,204,199,
237,255,204,199,237,255,204,199,237,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,
39,0,1,6,9,0,136,136,183,0,1,6,9,0,64,65,86,0,1,6,9,0,117,118,163,0,85,86,118,
0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,
0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,123,115,163,0,1,6,9,0,132,239,39,0,
85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,
118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,
9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,
9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,
0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,
0,1,6,9,0,153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,
6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,
0,85,86,118,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,
37,0,64,65,86,0,2,66,183,0,1,6,9,0,0,181,254,0,85,86,118,0,153,152,200,0,85,86,
118,0,11,16,37,0,1,6,9,0,153,152,200,0,85,86,118,0,117,118,163,0,1,6,9,0,64,65,
86,0,215,213,240,255,206,200,229,255,204,199,237,255,215,207,246,255,204,199,
237,255,204,199,237,255,206,202,246,255,206,202,246,255,199,194,238,255,188,184,
235,255,202,196,248,255,202,196,248,255,202,196,248,255,199,194,238,255,202,196,
248,255,202,196,248,255,204,199,237,255,204,199,237,255,214,198,232,255,221,206,
239,255,221,206,239,255,221,206,239,255,221,206,239,255,221,206,239,255,206,200,
229,255,221,206,239,255,206,200,229,255,221,206,239,255,221,206,239,255,221,206,
239,255,214,198,232,255,206,200,229,255,214,198,232,255,214,198,232,255,214,198,
232,255,206,200,229,255,214,198,232,255,206,200,229,255,221,206,239,255,221,206,
239,255,221,206,239,255,221,206,239,255,221,206,239,255,214,198,232,255,204,199,
237,255,199,194,238,255,188,184,227,255,199,194,238,255,206,202,246,255,199,194,
238,255,188,184,227,255,204,199,237,255,204,199,237,255,206,200,229,255,206,200,
229,255,191,186,215,255,191,186,215,255,191,186,215,255,191,186,215,255,206,200,
229,255,188,185,222,255,188,184,227,255,202,196,248,255,188,184,227,255,188,184,
235,255,188,184,235,255,188,184,227,255,199,194,238,255,199,194,238,255,199,194,
238,255,199,194,238,255,199,194,238,255,199,194,238,255,188,184,227,255,199,194,
238,255,202,196,248,255,188,184,227,255,199,194,238,255,199,194,238,255,188,184,
235,255,199,194,238,255,188,184,235,255,199,194,238,255,199,194,238,255,199,194,
238,255,199,194,238,255,199,194,238,255,199,194,238,255,1,6,9,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,136,136,183,0,1,6,9,0,64,65,86,0,1,6,9,0,117,118,163,0,85,
86,118,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,
1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,123,115,163,0,1,6,9,0,132,
239,39,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,
0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,
16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,
135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,
51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,11,
16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,35,38,218,0,1,6,
9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,
9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,0,0,181,254,0,85,86,118,0,153,152,
200,0,85,86,118,0,11,16,37,0,1,6,9,0,153,152,200,0,85,86,118,0,215,213,240,255,
215,213,240,255,214,198,232,255,204,199,237,255,202,196,248,255,202,196,248,255,
199,194,238,255,206,202,246,255,206,202,246,255,206,202,246,255,206,202,246,255,
202,196,248,255,202,196,248,255,199,194,238,255,206,202,246,255,206,202,246,255,
206,202,246,255,206,202,246,255,206,202,246,255,202,196,248,255,202,196,248,255,
206,202,246,255,204,199,237,255,215,207,246,255,214,198,232,255,221,206,239,255,
214,198,232,255,221,206,239,255,214,198,232,255,221,206,239,255,214,198,232,255,
214,198,232,255,221,206,239,255,221,206,239,255,221,206,239,255,221,206,239,255,
221,206,239,255,221,206,239,255,221,206,239,255,221,206,239,255,221,206,239,255,
214,198,232,255,214,198,232,255,214,198,232,255,204,199,237,255,215,207,246,255,
215,207,246,255,199,194,238,255,199,194,238,255,202,196,248,255,202,196,248,255,
199,194,238,255,215,207,246,255,212,208,253,255,204,199,237,255,188,185,222,255,
191,186,215,255,157,158,178,255,181,158,174,255,174,166,191,255,174,166,191,255,
199,194,238,255,188,184,235,255,206,202,246,255,202,196,248,255,206,202,246,255,
202,196,248,255,202,196,248,255,202,196,248,255,202,196,248,255,202,196,248,255,
202,196,248,255,202,196,248,255,206,202,246,255,202,196,248,255,202,196,248,255,
202,196,248,255,202,196,248,255,206,202,246,255,202,196,248,255,206,202,246,255,
206,202,246,255,212,208,253,255,202,196,248,255,202,196,248,255,202,196,248,255,
202,196,248,255,202,196,248,255,202,196,248,255,202,196,248,255,202,196,248,255,
199,194,238,255,199,194,238,255,1,6,9,0,132,239,39,0,1,6,9,0,136,136,183,0,1,6,
9,0,64,65,86,0,1,6,9,0,117,118,163,0,85,86,118,0,11,16,37,0,1,6,9,0,141,141,
167,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,123,115,163,0,1,6,9,0,132,239,39,0,85,86,118,0,181,158,174,0,135,
196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,64,
65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,
1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,
108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,
148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,
118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,
35,38,218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,11,16,37,0,64,65,86,0,2,66,183,0,1,6,9,
0,0,181,254,0,85,86,118,0,153,152,200,0,85,86,118,0,11,16,37,0,1,6,9,0,215,
213,240,255,206,200,229,255,204,199,237,255,199,194,238,255,202,196,248,255,202,
196,248,255,212,208,253,255,223,215,254,255,223,215,254,255,223,215,254,255,223,
215,254,255,212,208,253,255,223,215,254,255,212,208,253,255,212,208,253,255,223,
215,254,255,221,206,239,255,229,223,252,255,229,223,252,255,221,206,239,255,229,
223,252,255,223,215,254,255,212,208,253,255,223,215,254,255,221,206,239,255,223,
215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,
215,254,255,221,206,239,255,223,215,254,255,223,215,254,255,223,215,254,255,223,
215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,
215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,
215,254,255,223,215,254,255,212,208,253,255,223,215,254,255,223,215,254,255,212,
208,253,255,202,196,248,255,215,207,246,255,223,215,254,255,229,223,252,255,221,
206,239,255,215,207,246,255,212,208,253,255,229,223,252,255,178,174,211,255,178,
174,211,255,178,174,211,255,188,185,222,255,215,207,246,255,206,202,246,255,212,
208,253,255,212,208,253,255,223,215,254,255,212,208,253,255,202,196,248,255,202,
196,248,255,202,196,248,255,212,208,253,255,212,208,253,255,212,208,253,255,212,
208,253,255,212,208,253,255,212,208,253,255,202,196,248,255,223,215,254,255,223,
215,254,255,223,215,254,255,223,215,254,255,221,206,239,255,229,223,252,255,223,
215,254,255,212,208,253,255,202,196,248,255,212,208,253,255,212,208,253,255,202,
196,248,255,212,208,253,255,202,196,248,255,212,208,253,255,202,196,248,255,202,
196,248,255,199,194,238,255,199,194,238,255,188,184,227,255,206,200,229,255,206,
200,229,255,215,213,240,255,117,118,163,0,208,208,221,255,11,16,37,0,220,221,
234,255,220,221,234,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,123,115,163,0,1,6,9,0,132,239,39,0,85,86,118,0,
181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,
218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,
218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,
153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,
141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,
0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,220,221,234,255,
220,221,234,255,220,221,234,255,220,221,234,255,220,221,234,255,220,221,234,255,
220,221,234,255,220,221,234,255,229,230,244,255,215,213,240,255,215,213,240,255,
204,199,237,255,202,196,248,255,206,202,246,255,215,207,246,255,223,215,254,255,
215,207,246,255,212,208,253,255,223,215,254,255,229,223,252,255,243,231,251,255,
229,223,252,255,229,223,252,255,229,223,252,255,243,231,251,255,243,231,251,255,
248,245,250,255,243,231,251,255,243,231,251,255,238,238,251,255,243,231,251,255,
243,231,251,255,229,223,252,255,243,231,251,255,243,231,251,255,243,231,251,255,
243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,
243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,
243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,
243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,
243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,229,223,252,255,
221,206,239,255,229,223,252,255,243,231,251,255,238,238,251,255,248,245,250,255,
248,245,250,255,248,245,250,255,248,245,250,255,223,215,254,255,215,213,240,255,
223,215,254,255,223,215,254,255,248,245,250,255,248,245,250,255,248,245,250,255,
238,238,251,255,243,231,251,255,243,231,251,255,229,223,252,255,223,215,254,255,
223,215,254,255,229,223,252,255,229,223,252,255,229,223,252,255,243,231,251,255,
229,223,252,255,229,223,252,255,229,223,252,255,229,223,252,255,243,231,251,255,
243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,243,231,251,255,
223,215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,223,215,254,255,
223,215,254,255,223,215,254,255,202,196,248,255,206,202,246,255,202,196,248,255,
202,196,248,255,202,196,248,255,202,196,248,255,206,202,246,255,229,223,252,255,
229,230,244,255,229,230,244,255,229,223,252,255,229,230,244,255,220,221,234,255,
208,208,221,255,220,221,234,255,208,208,221,255,208,208,221,255,208,208,221,255,
208,208,221,255,220,221,234,255,208,208,221,255,220,221,234,255,208,208,221,255,
123,115,163,0,1,6,9,0,132,239,39,0,85,86,118,0,181,158,174,0,135,196,116,0,11,
16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,
0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,
9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,
135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,
70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,
181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,
218,0,1,6,9,0,35,38,218,0,1,6,9,0,1,6,9,0,85,86,118,0,1,6,9,0,220,221,234,255,
220,221,234,255,220,221,234,255,220,221,234,255,220,221,234,255,220,221,234,255,
220,221,234,255,229,230,244,255,229,230,244,255,243,231,251,255,238,238,251,255,
238,238,251,255,243,231,251,255,238,238,251,255,243,231,251,255,223,215,254,255,
215,207,246,255,212,208,253,255,212,208,253,255,223,215,254,255,229,223,252,255,
223,215,254,255,215,207,246,255,206,202,246,255,202,196,248,255,188,184,235,255,
175,171,227,255,188,184,235,255,202,196,248,255,202,196,248,255,202,196,248,255,
202,196,248,255,206,202,246,255,212,208,253,255,206,202,246,255,206,202,246,255,
202,196,248,255,202,196,248,255,188,185,222,255,205,176,193,255,214,198,232,255,
205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,
205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,
205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,
205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,205,176,193,255,
205,176,193,255,205,176,193,255,205,176,193,255,178,173,216,255,178,173,216,255,
175,171,227,255,188,184,227,255,188,184,235,255,188,184,227,255,199,194,238,255,
204,199,237,255,204,199,237,255,206,202,246,255,204,199,237,255,188,185,222,255,
191,186,215,255,188,184,227,255,212,208,253,255,199,194,238,255,199,194,238,255,
188,184,235,255,173,173,221,255,173,165,215,255,188,184,235,255,175,171,227,255,
175,171,227,255,188,184,235,255,175,171,227,255,175,171,227,255,175,171,227,255,
188,184,235,255,188,184,235,255,202,196,248,255,188,184,235,255,202,196,248,255,
202,196,248,255,202,196,248,255,202,196,248,255,202,196,248,255,202,196,248,255,
202,196,248,255,202,196,248,255,188,184,235,255,188,184,235,255,188,184,235,255,
188,184,235,255,202,196,248,255,202,196,248,255,212,208,253,255,212,208,253,255,
212,208,253,255,202,196,248,255,202,196,248,255,215,207,246,255,223,215,254,255,
229,223,252,255,248,245,250,255,238,238,251,255,238,238,251,255,238,238,251,255,
229,230,244,255,238,238,251,255,238,238,251,255,229,230,244,255,229,230,244,255,
220,221,234,255,220,221,234,255,208,208,221,255,220,221,234,255,220,221,234,255,
229,230,244,255,1,6,9,0,132,239,39,0,85,86,118,0,181,158,174,0,135,196,116,0,11,
16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,
0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,
9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,
135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,
70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,
181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,35,38,
218,0,1,6,9,0,35,38,218,0,1,6,9,0,220,221,234,255,220,221,234,255,220,221,234,
255,220,221,234,255,229,230,244,255,238,238,251,255,238,238,251,255,238,238,251,
255,229,230,244,255,229,230,244,255,229,230,244,255,220,221,234,255,220,221,234,
255,220,221,234,255,215,213,240,255,215,213,240,255,229,223,252,255,223,215,254,
255,229,223,252,255,212,208,253,255,212,208,253,255,221,206,239,255,215,207,246,
255,175,171,227,255,167,163,218,255,167,163,218,255,173,165,215,255,173,165,215,
255,178,173,216,255,178,173,216,255,175,171,227,255,175,171,227,255,175,171,227,
255,188,184,235,255,188,184,227,255,199,194,238,255,188,184,235,255,188,184,235,
255,188,184,235,255,188,184,235,255,175,171,227,255,172,168,198,255,205,176,193,
255,194,165,176,255,194,165,176,255,205,176,193,255,194,165,176,255,194,165,176,
255,205,176,193,255,194,165,176,255,194,165,176,255,205,176,193,255,194,165,176,
255,205,176,193,255,194,165,176,255,194,165,176,255,194,165,176,255,194,165,176,
255,194,165,176,255,205,176,193,255,194,165,176,255,205,176,193,255,205,176,193,
255,194,165,176,255,194,165,176,255,205,176,193,255,205,176,193,255,173,165,202,
255,169,165,207,255,169,165,207,255,162,158,200,255,166,157,194,255,166,166,201,
255,178,174,211,255,178,174,211,255,188,184,227,255,188,185,222,255,166,166,201,
255,178,174,211,255,188,185,222,255,188,185,222,255,202,196,248,255,188,184,227,
255,188,184,227,255,188,184,227,255,188,184,227,255,178,173,216,255,173,165,215,
255,175,171,227,255,175,171,227,255,173,165,215,255,178,173,216,255,178,173,216,
255,178,173,216,255,175,171,227,255,175,171,227,255,175,171,227,255,175,171,227,
255,188,184,235,255,188,184,235,255,188,184,235,255,188,184,235,255,188,184,235,
255,188,184,235,255,175,171,227,255,175,171,227,255,173,165,215,255,173,165,215,
255,173,165,215,255,173,165,215,255,167,163,218,255,167,163,218,255,166,163,225,
255,175,171,227,255,202,196,248,255,202,196,248,255,202,196,248,255,206,202,246,
255,215,207,246,255,229,223,252,255,223,215,254,255,215,213,240,255,200,201,225,
255,208,208,221,255,215,213,240,255,208,208,221,255,208,208,221,255,220,221,234,
255,220,221,234,255,229,230,244,255,229,230,244,255,238,238,251,255,229,230,244,
255,238,238,251,255,229,230,244,255,229,230,244,255,229,230,244,255,229,230,244,
255,229,230,244,255,135,196,116,0,11,16,37,0,1,6,9,0,141,141,167,0,85,86,118,0,
35,38,218,0,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,
35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,
18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,
16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,
9,0,153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,11,16,37,0,1,6,9,0,
220,221,234,255,220,221,234,255,229,230,244,255,229,230,244,255,35,38,218,0,238,
238,251,255,238,238,251,255,229,230,244,255,229,230,244,255,220,221,234,255,208,
208,221,255,208,208,221,255,200,201,225,255,208,208,221,255,200,201,225,255,191,
194,208,255,208,208,221,255,186,190,212,255,200,201,225,255,215,213,240,255,229,
223,252,255,229,223,252,255,229,223,252,255,223,215,254,255,215,207,246,255,202,
196,248,255,202,196,248,255,175,171,227,255,173,165,215,255,167,163,218,255,167,
163,218,255,188,184,235,255,161,157,212,255,167,163,218,255,173,165,215,255,188,
184,235,255,173,165,215,255,202,196,248,255,175,171,227,255,175,171,227,255,175,
171,227,255,173,165,215,255,173,165,215,255,175,171,227,255,173,165,215,255,188,
184,235,255,188,184,235,255,173,165,202,255,176,153,178,255,194,165,176,255,181,
158,174,255,194,165,176,255,194,165,176,255,194,165,176,255,194,165,176,255,194,
165,176,255,194,165,176,255,194,165,176,255,181,158,174,255,194,165,176,255,194,
165,176,255,194,165,176,255,194,165,176,255,194,165,176,255,194,165,176,255,194,
165,176,255,194,165,176,255,194,165,176,255,194,165,176,255,194,165,176,255,181,
158,174,255,181,158,174,255,205,176,193,255,166,153,185,255,162,158,200,255,173,
165,215,255,169,165,207,255,173,165,202,255,173,165,202,255,178,174,211,255,191,
186,215,255,188,185,222,255,204,199,237,255,191,186,215,255,166,166,201,255,178,
174,211,255,188,185,222,255,202,196,248,255,188,184,227,255,188,184,227,255,178,
173,216,255,178,173,216,255,169,165,207,255,173,165,215,255,175,171,227,255,175,
171,227,255,173,165,215,255,173,165,215,255,188,184,235,255,178,173,216,255,173,
165,215,255,175,171,227,255,202,196,248,255,175,171,227,255,175,171,227,255,175,
171,227,255,175,171,227,255,175,171,227,255,188,184,235,255,175,171,227,255,202,
196,248,255,175,171,227,255,188,184,235,255,173,173,221,255,175,171,227,255,161,
157,212,255,167,163,218,255,173,165,215,255,167,163,218,255,161,157,212,255,167,
163,218,255,166,163,225,255,188,184,235,255,202,196,248,255,206,202,246,255,204,
199,237,255,215,207,246,255,212,208,253,255,212,208,253,255,204,199,237,255,200,
201,225,255,200,201,225,255,186,190,212,255,191,194,208,255,191,194,208,255,191,
194,208,255,184,185,195,255,191,194,208,255,191,194,208,255,208,208,221,255,208,
208,221,255,208,208,221,255,220,221,234,255,220,221,234,255,229,230,244,255,229,
230,244,255,229,230,244,255,229,230,244,255,220,221,234,255,220,221,234,255,229,
230,244,255,1,6,9,0,64,65,86,0,1,6,9,0,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,
35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,
18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,
16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,
9,0,153,152,200,0,85,86,118,0,181,158,174,0,135,196,116,0,220,221,234,255,220,
221,234,255,229,230,244,255,220,221,234,255,220,221,234,255,208,208,221,255,208,
208,221,255,191,194,208,255,191,194,208,255,191,194,208,255,191,194,208,255,184,
185,195,255,191,194,208,255,183,187,202,255,184,185,195,255,183,187,202,255,183,
187,202,255,200,201,225,255,200,201,225,255,215,213,240,255,229,223,252,255,243,
231,251,255,243,231,251,255,229,223,252,255,223,215,254,255,215,207,246,255,202,
196,248,255,188,184,235,255,175,171,227,255,175,171,227,255,167,163,218,255,161,
157,212,255,173,165,215,255,188,184,235,255,165,156,206,255,161,157,212,255,173,
165,215,255,169,165,207,255,173,165,215,255,173,165,215,255,175,171,227,255,173,
165,215,255,173,165,215,255,166,163,225,255,173,165,215,255,165,156,206,255,165,
156,206,255,165,156,206,255,169,165,207,255,176,153,178,255,173,165,202,255,176,
153,178,255,176,153,178,255,176,153,178,255,181,158,174,255,176,153,178,255,176,
153,178,255,181,158,174,255,181,158,174,255,181,158,174,255,181,158,174,255,181,
158,174,255,181,158,174,255,181,158,174,255,176,153,178,255,181,158,174,255,176,
153,178,255,142,141,151,255,176,153,178,255,181,158,174,255,176,153,178,255,176,
153,178,255,181,158,174,255,176,153,178,255,176,153,178,255,166,153,185,255,166,
157,194,255,165,156,206,255,154,150,192,255,166,157,194,255,173,165,202,255,178,
174,211,255,173,165,202,255,188,185,222,255,188,185,222,255,178,174,211,255,178,
174,211,255,160,158,188,255,188,185,222,255,199,194,238,255,178,173,216,255,178,
173,216,255,178,173,216,255,169,165,207,255,169,165,207,255,166,165,214,255,173,
165,215,255,173,165,215,255,166,165,214,255,166,165,214,255,169,165,207,255,178,
173,216,255,173,173,221,255,173,165,215,255,173,165,215,255,167,163,218,255,167,
163,218,255,167,163,218,255,167,163,218,255,167,163,218,255,173,165,215,255,173,
165,215,255,173,165,215,255,173,165,215,255,166,165,214,255,159,158,206,255,173,
165,215,255,161,157,212,255,165,156,206,255,188,184,235,255,167,163,218,255,158,
156,218,255,173,165,215,255,166,163,225,255,166,163,225,255,173,173,221,255,188,
184,235,255,206,202,246,255,206,202,246,255,204,199,237,255,204,199,237,255,215,
207,246,255,206,202,246,255,206,202,246,255,200,201,225,255,186,190,212,255,191,
194,208,255,186,190,212,255,191,194,208,255,183,187,202,255,183,187,202,255,183,
187,202,255,183,187,202,255,183,187,202,255,183,187,202,255,184,185,195,255,183,
187,202,255,183,187,202,255,191,194,208,255,208,208,221,255,220,221,234,255,229,
230,244,255,220,221,234,255,220,221,234,255,64,65,86,0,1,6,9,0,1,6,9,0,85,86,
118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,
0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,
0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,85,86,118,0,208,208,221,255,208,
208,221,255,208,208,221,255,208,208,221,255,191,194,208,255,191,194,208,255,191,
194,208,255,183,187,202,255,183,187,202,255,191,194,208,255,191,194,208,255,184,
185,195,255,191,194,208,255,191,194,208,255,191,194,208,255,186,190,212,255,200,
201,225,255,200,201,225,255,200,201,225,255,229,223,252,255,243,231,251,255,243,
231,251,255,229,223,252,255,212,208,253,255,212,208,253,255,215,207,246,255,188,
184,235,255,178,173,216,255,169,165,207,255,175,171,227,255,175,171,227,255,165,
156,206,255,165,156,206,255,161,157,212,255,161,157,212,255,161,157,212,255,154,
151,205,255,161,157,212,255,165,156,206,255,162,158,200,255,169,165,207,255,169,
165,207,255,169,165,207,255,162,158,200,255,162,158,200,255,161,157,212,255,165,
156,206,255,155,147,196,255,154,150,192,255,154,150,192,255,162,158,200,255,166,
153,185,255,176,153,178,255,176,153,178,255,176,153,178,255,176,153,178,255,181,
158,174,255,181,158,174,255,176,153,178,255,176,153,178,255,176,153,178,255,176,
153,178,255,153,139,168,255,176,153,178,255,181,158,174,255,176,153,178,255,181,
158,174,255,176,153,178,255,176,153,178,255,176,153,178,255,176,153,178,255,153,
139,168,255,176,153,178,255,153,139,168,255,176,153,178,255,153,139,168,255,160,
158,188,255,166,153,185,255,145,142,177,255,169,165,207,255,145,141,183,255,155,
151,186,255,166,157,194,255,166,166,201,255,166,166,201,255,178,174,211,255,178,
174,211,255,172,168,198,255,172,168,198,255,160,160,195,255,178,174,211,255,188,
184,227,255,188,184,227,255,178,174,211,255,178,173,216,255,159,158,206,255,162,
158,200,255,159,158,206,255,167,163,218,255,167,163,218,255,159,158,206,255,166,
165,214,255,173,165,215,255,169,165,207,255,169,165,207,255,166,165,214,255,169,
165,207,255,169,165,207,255,169,165,207,255,169,165,207,255,169,165,207,255,166,
165,214,255,166,165,214,255,166,165,214,255,169,165,207,255,169,165,207,255,169,
165,207,255,162,158,200,255,165,156,206,255,161,157,212,255,154,151,205,255,149,
146,200,255,149,146,200,255,161,157,212,255,165,156,206,255,162,158,200,255,167,
163,218,255,167,163,218,255,173,165,215,255,173,173,221,255,188,184,235,255,199,
194,238,255,206,202,246,255,206,202,246,255,204,199,237,255,215,207,246,255,223,
215,254,255,212,208,253,255,206,200,229,255,200,201,225,255,200,201,225,255,183,
187,202,255,183,187,202,255,183,187,202,255,175,177,194,255,183,187,202,255,183,
187,202,255,184,185,195,255,183,187,202,255,183,187,202,255,175,177,194,255,183,
187,202,255,184,185,195,255,191,194,208,255,208,208,221,255,220,221,234,255,208,
208,221,255,229,230,244,255,1,6,9,0,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,
85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,
6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,
9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,
152,200,0,85,86,118,0,208,208,221,255,208,208,221,255,191,194,208,255,191,194,
208,255,191,194,208,255,183,187,202,255,183,187,202,255,183,187,202,255,191,194,
208,255,183,187,202,255,183,187,202,255,200,201,225,255,186,190,212,255,186,190,
212,255,200,201,225,255,206,200,229,255,215,213,240,255,243,231,251,255,238,238,
251,255,229,223,252,255,223,215,254,255,212,208,253,255,206,202,246,255,206,202,
246,255,188,184,227,255,173,173,221,255,173,173,221,255,178,173,216,255,178,173,
216,255,165,156,206,255,162,158,200,255,162,158,200,255,155,147,196,255,167,163,
218,255,165,156,206,255,154,151,205,255,158,156,218,255,165,156,206,255,153,152,
200,255,159,158,206,255,165,156,206,255,162,158,200,255,162,158,200,255,165,156,
206,255,165,156,206,255,165,156,206,255,154,151,205,255,154,150,192,255,154,150,
192,255,162,158,200,255,162,158,200,255,173,165,202,255,172,168,198,255,176,153,
178,255,176,153,178,255,176,153,178,255,153,139,168,255,176,153,178,255,176,153,
178,255,176,153,178,255,176,153,178,255,176,153,178,255,176,153,178,255,176,153,
178,255,176,153,178,255,176,153,178,255,153,139,168,255,181,158,174,255,153,139,
168,255,176,153,178,255,176,153,178,255,176,153,178,255,181,158,174,255,176,153,
178,255,166,153,185,255,181,158,174,255,176,153,178,255,166,157,194,255,162,158,
200,255,165,156,206,255,162,158,200,255,162,158,200,255,166,166,201,255,173,165,
202,255,178,174,211,255,191,186,215,255,172,168,198,255,141,141,167,255,145,142,
177,255,145,141,183,255,145,142,177,255,173,165,215,255,178,174,211,255,169,165,
207,255,169,165,207,255,162,158,200,255,154,150,192,255,153,152,200,255,165,156,
206,255,165,156,206,255,159,158,206,255,159,158,206,255,162,158,200,255,166,165,
214,255,169,165,207,255,169,165,207,255,169,165,207,255,169,165,207,255,169,165,
207,255,166,165,214,255,166,165,214,255,169,165,207,255,169,165,207,255,169,165,
207,255,166,165,214,255,166,165,214,255,166,165,214,255,169,165,207,255,159,158,
206,255,173,165,215,255,161,157,212,255,154,151,205,255,165,156,206,255,161,157,
212,255,153,152,200,255,165,156,206,255,155,147,196,255,155,147,196,255,178,173,
216,255,173,165,215,255,173,173,221,255,166,165,214,255,173,173,221,255,188,184,
227,255,199,194,238,255,204,199,237,255,199,194,238,255,206,200,229,255,223,215,
254,255,215,207,246,255,215,207,246,255,215,207,246,255,200,201,225,255,200,201,
225,255,186,190,212,255,186,190,212,255,191,186,215,255,191,194,208,255,183,187,
202,255,175,177,194,255,183,187,202,255,175,177,194,255,175,177,194,255,183,187,
202,255,183,187,202,255,191,194,208,255,220,221,234,255,208,208,221,255,220,221,
234,255,85,86,118,0,11,16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,
172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,0,153,152,200,0,208,208,221,255,
191,194,208,255,186,190,212,255,191,186,215,255,184,185,195,255,191,194,208,255,
191,194,208,255,191,194,208,255,183,187,202,255,200,201,225,255,186,190,212,255,
191,194,208,255,206,200,229,255,215,213,240,255,215,213,240,255,229,223,252,255,
243,231,251,255,229,230,244,255,221,206,239,255,215,207,246,255,215,207,246,255,
206,202,246,255,199,194,238,255,178,173,216,255,166,165,214,255,173,173,221,255,
178,173,216,255,188,184,227,255,188,184,227,255,178,173,216,255,155,147,196,255,
155,147,196,255,153,152,200,255,154,150,192,255,155,147,196,255,149,146,200,255,
149,146,200,255,148,148,195,255,148,148,195,255,148,148,195,255,154,150,192,255,
162,158,200,255,162,158,200,255,162,158,200,255,162,158,200,255,162,158,200,255,
155,147,196,255,165,156,206,255,153,152,200,255,154,150,192,255,162,158,200,255,
154,150,192,255,154,150,192,255,166,157,194,255,166,157,194,255,166,153,185,255,
176,153,178,255,166,157,194,255,176,153,178,255,153,139,168,255,176,153,178,255,
176,153,178,255,153,139,168,255,176,153,178,255,153,139,168,255,176,153,178,255,
153,139,168,255,176,153,178,255,176,153,178,255,153,139,168,255,153,139,168,255,
166,153,185,255,166,153,185,255,166,153,185,255,176,153,178,255,166,153,185,255,
166,153,185,255,153,139,168,255,145,142,177,255,145,141,183,255,154,150,192,255,
145,141,183,255,145,142,177,255,145,142,177,255,155,151,186,255,145,141,183,255,
154,150,192,255,138,134,175,255,117,118,163,255,129,126,165,255,117,118,163,255,
124,124,170,255,142,141,188,255,154,150,192,255,154,150,192,255,154,150,192,255,
153,152,200,255,154,150,192,255,148,148,195,255,154,151,205,255,153,152,200,255,
165,156,206,255,159,158,206,255,159,158,206,255,159,158,206,255,166,165,214,255,
166,165,214,255,169,165,207,255,159,158,206,255,169,165,207,255,162,158,200,255,
169,165,207,255,159,158,206,255,169,165,207,255,169,165,207,255,162,158,200,255,
162,158,200,255,159,158,206,255,162,158,200,255,162,158,200,255,155,147,196,255,
155,147,196,255,149,148,209,255,148,148,195,255,148,140,188,255,142,141,188,255,
153,152,200,255,153,152,200,255,153,152,200,255,188,185,222,255,188,184,227,255,
188,184,227,255,178,173,216,255,166,165,214,255,166,165,214,255,167,163,218,255,
188,184,235,255,188,184,235,255,199,194,238,255,199,194,238,255,204,199,237,255,
215,207,246,255,223,215,254,255,229,223,252,255,229,223,252,255,229,223,252,255,
200,201,225,255,200,201,225,255,186,190,212,255,191,194,208,255,186,190,212,255,
191,194,208,255,191,194,208,255,183,187,202,255,175,177,194,255,183,187,202,255,
183,187,202,255,184,185,195,255,208,208,221,255,208,208,221,255,85,86,118,0,11,
16,37,0,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,
135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,
51,116,221,0,1,6,9,0,191,194,208,255,183,187,202,255,186,190,212,255,191,186,
215,255,200,201,225,255,191,194,208,255,186,190,212,255,186,190,212,255,200,201,
225,255,200,201,225,255,215,213,240,255,243,231,251,255,229,223,252,255,229,230,
244,255,243,231,251,255,229,223,252,255,229,223,252,255,204,199,237,255,206,202,
246,255,206,202,246,255,206,202,246,255,188,184,227,255,166,166,201,255,159,158,
206,255,159,158,206,255,173,173,221,255,173,165,215,255,188,184,227,255,188,185,
222,255,188,184,227,255,178,173,216,255,153,152,200,255,148,148,195,255,148,148,
195,255,149,146,200,255,142,141,188,255,148,140,188,255,143,140,194,255,143,140,
194,255,148,140,188,255,142,141,188,255,148,148,195,255,155,147,196,255,153,152,
200,255,153,152,200,255,153,152,200,255,154,150,192,255,153,152,200,255,149,146,
200,255,154,150,192,255,155,147,196,255,166,153,185,255,155,147,196,255,155,147,
196,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,
168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,
168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,
168,255,153,139,168,255,176,153,178,255,153,139,168,255,153,139,168,255,153,139,
168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,168,255,153,139,
168,255,145,142,177,255,153,139,168,255,138,134,175,255,145,142,177,255,145,142,
177,255,145,142,177,255,145,142,177,255,129,126,165,255,129,126,165,255,119,117,
156,255,112,108,148,255,109,109,154,255,123,115,163,255,117,118,163,255,129,126,
165,255,132,132,179,255,136,136,183,255,142,141,188,255,142,141,188,255,148,148,
195,255,153,152,200,255,148,148,195,255,153,152,200,255,148,148,195,255,155,147,
196,255,154,150,192,255,159,158,206,255,154,150,192,255,162,158,200,255,153,152,
200,255,162,158,200,255,153,152,200,255,159,158,206,255,153,152,200,255,159,158,
206,255,153,152,200,255,153,152,200,255,162,158,200,255,159,158,206,255,153,152,
200,255,159,158,206,255,155,147,196,255,153,152,200,255,153,152,200,255,143,140,
194,255,148,140,188,255,148,148,195,255,148,148,195,255,148,148,195,255,148,148,
195,255,162,158,200,255,178,173,216,255,178,174,211,255,178,174,211,255,178,173,
216,255,169,165,207,255,162,158,200,255,162,158,200,255,162,158,200,255,178,174,
211,255,178,174,211,255,188,184,227,255,199,194,238,255,199,194,238,255,188,184,
227,255,199,194,238,255,215,207,246,255,206,200,229,255,229,223,252,255,229,223,
252,255,243,231,251,255,229,223,252,255,215,213,240,255,200,201,225,255,200,201,
225,255,200,201,225,255,186,190,212,255,186,190,212,255,186,190,212,255,183,187,
202,255,191,194,208,255,208,208,221,255,191,194,208,255,11,16,37,0,1,6,9,0,35,
38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,
0,191,194,208,255,191,186,215,255,175,177,194,255,191,186,215,255,215,213,240,
255,215,213,240,255,243,231,251,255,243,231,251,255,229,230,244,255,243,231,251,
255,215,213,240,255,215,213,240,255,221,206,239,255,188,184,227,255,204,199,237,
255,188,184,227,255,206,202,246,255,199,194,238,255,199,194,238,255,169,165,207,
255,169,165,207,255,169,165,207,255,162,158,200,255,153,152,200,255,153,152,200,
255,166,165,214,255,173,165,215,255,178,174,211,255,178,174,211,255,178,174,211,
255,165,156,206,255,155,147,196,255,148,140,188,255,142,141,188,255,149,146,200,
255,148,140,188,255,143,140,194,255,143,140,194,255,143,140,194,255,148,140,188,
255,143,140,194,255,142,141,188,255,148,140,188,255,148,148,195,255,155,147,196,
255,155,147,196,255,148,148,195,255,142,141,188,255,148,140,188,255,142,141,188,
255,155,147,196,255,145,141,183,255,145,141,183,255,145,141,183,255,153,139,168,
255,153,139,168,255,143,103,124,255,128,121,147,255,128,121,147,255,128,121,147,
255,143,103,124,255,110,108,129,255,110,108,129,255,128,121,147,255,110,108,129,
255,125,125,134,255,125,125,134,255,110,108,129,255,110,108,129,255,110,110,118,
255,110,110,118,255,94,94,102,255,81,81,88,255,94,94,102,255,81,81,88,255,81,81,
88,255,94,94,102,255,81,81,88,255,81,81,88,255,81,81,88,255,81,81,88,255,81,81,
88,255,81,81,88,255,81,81,88,255,81,81,88,255,94,94,102,255,81,81,88,255,81,81,
88,255,81,81,88,255,81,81,88,255,94,94,102,255,81,81,88,255,92,92,112,255,94,
94,102,255,94,94,102,255,94,94,102,255,94,94,102,255,92,92,112,255,110,108,129,
255,110,108,129,255,110,108,129,255,128,121,147,255,128,121,147,255,145,142,177,
255,129,126,165,255,145,142,177,255,145,141,183,255,154,150,192,255,159,158,206,
255,159,158,206,255,155,147,196,255,153,152,200,255,155,147,196,255,153,152,200,
255,153,152,200,255,154,151,205,255,153,152,200,255,153,152,200,255,149,146,200,
255,153,152,200,255,153,152,200,255,148,148,195,255,142,141,188,255,141,140,200,
255,138,135,189,255,143,140,194,255,148,140,188,255,148,140,188,255,155,147,196,
255,154,151,205,255,165,156,206,255,178,174,211,255,178,174,211,255,169,165,207,
255,159,158,206,255,148,148,195,255,162,158,200,255,154,150,192,255,159,158,206,
255,159,158,206,255,162,158,200,255,169,165,207,255,188,184,227,255,188,184,235,
255,188,184,235,255,188,184,235,255,188,184,227,255,188,185,222,255,188,184,227,
255,188,185,222,255,206,200,229,255,229,223,252,255,215,213,240,255,243,231,251,
255,243,231,251,255,243,231,251,255,220,221,234,255,215,213,240,255,191,186,215,
255,186,190,212,255,191,194,208,255,208,208,221,255,208,208,221,255,1,6,9,0,35,
38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,1,6,9,
0,186,190,212,255,172,168,198,255,206,200,229,255,221,206,239,255,215,213,240,
255,215,213,240,255,215,213,240,255,204,199,237,255,204,199,237,255,204,199,237,
255,199,194,238,255,188,184,227,255,178,174,211,255,188,184,227,255,188,184,235,
255,188,184,227,255,178,173,216,255,178,174,211,255,166,166,201,255,162,158,200,
255,154,150,192,255,148,148,195,255,148,148,195,255,142,141,188,255,142,141,188,
255,148,140,188,255,159,158,206,255,173,165,215,255,173,165,202,255,162,158,200,
255,149,146,200,255,143,140,194,255,143,140,194,255,138,135,189,255,138,135,189,
255,141,140,200,255,143,140,194,255,134,131,185,255,138,135,189,255,138,135,189,
255,138,135,189,255,138,135,189,255,143,140,194,255,148,140,188,255,142,141,188,
255,138,134,175,255,119,117,156,255,128,121,147,255,111,110,143,255,122,124,142,
255,122,124,142,255,128,121,147,255,125,125,134,255,94,94,102,255,92,92,112,255,
81,81,88,255,79,80,102,255,67,66,72,255,67,66,72,255,67,66,72,255,67,66,72,255,
67,66,72,255,54,52,55,255,54,52,55,255,34,34,42,255,30,34,46,255,29,30,37,255,
34,34,42,255,29,30,37,255,30,34,46,255,30,34,46,255,34,34,42,255,38,42,54,255,
35,39,51,255,46,49,63,255,38,42,54,255,35,39,51,255,38,42,54,255,46,49,63,255,
38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,30,34,46,255,46,49,63,255,
34,34,42,255,34,34,42,255,38,42,54,255,35,39,51,255,35,39,51,255,29,30,37,255,
34,34,42,255,29,30,37,255,34,34,42,255,34,34,42,255,38,42,54,255,46,49,63,255,
54,52,55,255,67,66,72,255,50,51,59,255,50,51,59,255,50,51,59,255,50,51,59,255,
67,66,72,255,81,81,88,255,81,81,88,255,81,81,88,255,81,81,88,255,94,94,102,255,
81,81,88,255,94,94,102,255,92,92,112,255,110,108,129,255,128,121,147,255,128,
121,147,255,128,121,147,255,129,126,165,255,140,132,180,255,142,141,188,255,138,
135,189,255,138,135,189,255,134,131,185,255,138,135,189,255,134,131,185,255,141,
140,200,255,134,131,185,255,138,135,189,255,143,140,194,255,154,151,205,255,153,
152,200,255,149,146,200,255,155,147,196,255,162,158,200,255,165,156,206,255,155,
147,196,255,148,148,195,255,142,141,188,255,148,148,195,255,154,150,192,255,145,
142,177,255,154,150,192,255,162,158,200,255,162,158,200,255,173,165,202,255,178,
173,216,255,178,173,216,255,188,184,235,255,175,171,227,255,166,165,214,255,178,
173,216,255,188,184,235,255,188,184,227,255,188,184,227,255,178,174,211,255,188,
185,222,255,204,199,237,255,215,207,246,255,229,223,252,255,215,213,240,255,206,
200,229,255,186,190,212,255,191,194,208,255,184,185,195,255,1,6,9,0,35,38,218,0,
85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,
6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,
9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,51,116,221,0,175,177,194,
255,175,177,194,255,188,185,222,255,206,200,229,255,204,199,237,255,188,185,222,
255,188,184,227,255,188,185,222,255,178,173,216,255,188,184,235,255,188,184,227,
255,188,184,227,255,167,163,218,255,166,165,214,255,169,165,207,255,169,165,207,
255,166,166,201,255,173,165,202,255,162,158,200,255,160,160,195,255,154,150,192,
255,154,150,192,255,145,141,183,255,142,141,188,255,142,141,188,255,142,141,188,
255,148,140,188,255,142,141,188,255,149,146,200,255,148,140,188,255,143,140,194,
255,138,135,189,255,134,131,185,255,134,131,185,255,140,132,180,255,134,131,185,
255,140,132,180,255,134,131,185,255,128,125,178,255,134,131,185,255,131,124,172,
255,112,108,148,255,122,124,142,255,122,124,142,255,94,94,102,255,81,81,88,255,
67,66,72,255,81,81,88,255,64,65,86,255,67,66,72,255,67,66,72,255,50,51,59,255,
30,34,46,255,34,34,42,255,34,34,42,255,46,49,63,255,50,51,59,255,46,49,63,255,
50,51,59,255,46,49,63,255,38,42,54,255,46,49,63,255,46,49,63,255,46,49,63,255,
46,49,63,255,46,49,63,255,46,49,63,255,34,34,42,255,46,49,63,255,50,51,59,255,
34,34,42,255,46,49,63,255,50,51,59,255,38,42,54,255,35,39,51,255,38,36,40,255,
38,42,54,255,38,42,54,255,34,34,42,255,46,49,63,255,38,42,54,255,38,42,54,255,
38,42,54,255,38,36,40,255,46,49,63,255,34,34,42,255,46,49,63,255,38,42,54,255,
50,51,59,255,30,34,46,255,38,42,54,255,38,42,54,255,38,42,54,255,35,39,51,255,
38,42,54,255,50,51,59,255,50,51,59,255,38,42,54,255,38,42,54,255,46,49,63,255,
46,49,63,255,50,51,59,255,50,51,59,255,38,42,54,255,38,42,54,255,50,51,59,255,
34,34,42,255,38,36,40,255,34,34,42,255,28,32,43,255,50,51,59,255,54,52,55,255,
54,52,55,255,50,51,59,255,50,51,59,255,67,66,72,255,81,81,88,255,81,81,88,255,
94,94,102,255,64,65,86,255,79,80,102,255,111,110,143,255,134,131,185,255,128,
125,178,255,131,124,172,255,119,117,169,255,128,125,178,255,134,131,185,255,138,
135,189,255,143,140,194,255,136,136,183,255,136,136,183,255,134,131,185,255,142,
141,188,255,138,135,189,255,132,132,179,255,136,136,183,255,136,136,183,255,142,
141,188,255,148,148,195,255,148,148,195,255,145,142,177,255,154,150,192,255,154,
150,192,255,155,151,186,255,166,166,201,255,160,160,195,255,173,165,202,255,169,
165,207,255,153,152,200,255,153,152,200,255,167,163,218,255,173,173,221,255,175,
171,227,255,173,173,221,255,178,174,211,255,178,174,211,255,178,173,216,255,188,
184,235,255,199,194,238,255,221,206,239,255,204,199,237,255,183,187,202,255,191,
194,208,255,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,
135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,1,6,9,0,
175,177,194,255,191,186,215,255,178,174,211,255,188,185,222,255,199,194,238,255,
199,194,238,255,199,194,238,255,188,185,222,255,178,174,211,255,178,174,211,255,
162,158,200,255,142,141,188,255,138,135,189,255,136,136,183,255,148,148,195,255,
162,158,200,255,162,158,200,255,162,158,200,255,154,150,192,255,155,151,186,255,
154,150,192,255,154,150,192,255,142,141,188,255,142,141,188,255,145,141,183,255,
145,141,183,255,136,136,183,255,136,136,183,255,140,132,180,255,140,132,180,255,
138,135,189,255,138,135,189,255,132,132,179,255,134,131,185,255,134,131,185,255,
128,128,175,255,132,132,179,255,138,135,189,255,138,134,175,255,138,134,175,255,
119,117,156,255,110,108,129,255,94,94,102,255,46,49,63,255,30,34,46,255,35,39,
51,255,38,42,54,255,46,49,63,255,46,49,63,255,50,51,59,255,46,49,63,255,46,49,
63,255,34,34,42,255,50,51,59,255,46,49,63,255,46,49,63,255,34,34,42,255,38,42,
54,255,34,34,42,255,35,39,51,255,35,39,51,255,38,42,54,255,46,49,63,255,38,36,
40,255,34,34,42,255,50,51,59,255,34,34,42,255,34,34,42,255,46,49,63,255,34,34,
42,255,35,39,51,255,46,49,63,255,34,34,42,255,35,39,51,255,34,34,42,255,46,49,
63,255,46,49,63,255,34,34,42,255,50,51,59,255,38,42,54,255,34,34,42,255,34,34,
42,255,46,49,63,255,34,34,42,255,46,49,63,255,34,34,42,255,38,42,54,255,34,34,
42,255,34,34,42,255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,35,39,
51,255,38,42,54,255,34,34,42,255,35,39,51,255,35,39,51,255,35,39,51,255,38,42,
54,255,38,42,54,255,38,42,54,255,35,39,51,255,35,39,51,255,50,51,59,255,34,34,
42,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,
54,255,50,51,59,255,46,49,63,255,50,51,59,255,46,49,63,255,38,42,54,255,35,39,
51,255,34,34,42,255,38,36,40,255,50,51,59,255,67,66,72,255,81,81,88,255,79,80,
102,255,124,124,170,255,128,125,178,255,128,125,178,255,128,125,178,255,128,125,
178,255,128,125,178,255,128,128,175,255,140,132,180,255,138,135,189,255,143,140,
194,255,134,131,185,255,132,132,179,255,136,136,183,255,132,132,179,255,136,136,
183,255,138,135,189,255,138,135,189,255,142,141,188,255,136,136,183,255,142,141,
188,255,142,141,188,255,154,150,192,255,154,150,192,255,155,151,186,255,154,150,
192,255,154,150,192,255,145,142,177,255,136,136,183,255,136,136,183,255,143,140,
194,255,154,150,192,255,166,166,201,255,178,173,216,255,178,173,216,255,188,184,
235,255,188,184,227,255,199,194,238,255,188,184,227,255,188,185,222,255,186,190,
212,255,184,185,195,255,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,
1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,
112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,
218,0,1,6,9,0,175,177,194,255,172,168,198,255,178,174,211,255,188,185,222,255,
199,194,238,255,178,173,216,255,173,165,202,255,166,166,201,255,173,165,202,255,
155,151,186,255,142,141,188,255,136,136,183,255,132,132,179,255,138,134,175,255,
136,136,183,255,145,142,177,255,145,141,183,255,145,142,177,255,148,148,195,255,
142,141,188,255,142,141,188,255,145,141,183,255,142,141,188,255,142,141,188,255,
142,141,188,255,142,141,188,255,136,136,183,255,143,140,194,255,142,141,188,255,
132,132,179,255,138,134,175,255,134,131,185,255,140,132,180,255,128,125,178,255,
128,125,178,255,132,132,179,255,138,134,175,255,148,140,188,255,132,132,179,255,
129,126,165,255,64,65,86,255,50,51,59,255,46,49,63,255,50,51,59,255,46,49,63,
255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,35,39,51,
255,38,42,54,255,35,39,51,255,34,34,42,255,34,34,42,255,35,39,51,255,34,34,42,
255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,255,35,39,51,255,35,39,51,
255,46,49,63,255,35,39,51,255,38,42,54,255,38,36,40,255,38,42,54,255,38,42,54,
255,34,34,42,255,38,42,54,255,38,42,54,255,46,49,63,255,38,42,54,255,34,34,42,
255,35,39,51,255,38,42,54,255,35,39,51,255,38,42,54,255,38,42,54,255,46,49,63,
255,34,34,42,255,46,49,63,255,35,39,51,255,38,42,54,255,38,42,54,255,46,49,63,
255,38,42,54,255,38,42,54,255,38,42,54,255,38,36,40,255,38,42,54,255,34,34,42,
255,34,34,42,255,38,42,54,255,34,34,42,255,38,42,54,255,34,34,42,255,38,36,40,
255,38,42,54,255,34,34,42,255,35,39,51,255,35,39,51,255,35,39,51,255,38,42,54,
255,34,34,42,255,46,49,63,255,35,39,51,255,38,42,54,255,34,34,42,255,38,42,54,
255,35,39,51,255,35,39,51,255,35,39,51,255,34,34,42,255,50,51,59,255,30,34,46,
255,35,39,51,255,35,39,51,255,34,34,42,255,38,42,54,255,46,49,63,255,46,49,63,
255,50,51,59,255,64,65,86,255,128,125,178,255,119,117,169,255,119,117,169,255,
119,117,169,255,134,131,185,255,128,128,175,255,136,136,183,255,140,132,180,255,
143,140,194,255,128,128,175,255,128,125,178,255,134,131,185,255,143,140,194,255,
145,141,183,255,154,150,192,255,143,140,194,255,142,141,188,255,145,142,177,255,
142,141,188,255,142,141,188,255,136,136,183,255,148,140,188,255,132,132,179,255,
136,136,183,255,142,141,188,255,140,132,180,255,132,132,179,255,132,132,179,255,
136,136,183,255,142,141,188,255,154,150,192,255,169,165,207,255,166,166,201,255,
169,165,207,255,178,174,211,255,188,184,227,255,212,208,253,255,188,185,222,255,
191,186,215,255,220,221,234,255,1,6,9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,
172,0,35,38,218,0,175,177,194,255,172,168,198,255,172,168,198,255,178,174,211,
255,199,194,238,255,173,165,202,255,173,165,202,255,178,174,211,255,173,165,202,
255,155,151,186,255,154,150,192,255,145,141,183,255,145,141,183,255,145,141,183,
255,136,136,183,255,136,136,183,255,128,125,178,255,128,128,175,255,136,136,183,
255,136,136,183,255,145,141,183,255,145,142,177,255,136,136,183,255,138,134,175,
255,138,134,175,255,132,132,179,255,138,135,189,255,140,132,180,255,136,136,183,
255,136,136,183,255,132,132,179,255,128,128,175,255,132,132,179,255,128,125,178,
255,128,125,178,255,128,125,178,255,140,132,180,255,136,136,183,255,132,132,179,
255,138,134,175,255,92,92,112,255,34,34,42,255,46,49,63,255,34,34,42,255,35,39,
51,255,34,34,42,255,34,34,42,255,34,34,42,255,35,39,51,255,38,42,54,255,34,34,
42,255,34,34,42,255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,38,42,
54,255,38,42,54,255,34,34,42,255,34,34,42,255,38,42,54,255,34,34,42,255,35,39,
51,255,35,39,51,255,38,42,54,255,34,34,42,255,38,42,54,255,35,39,51,255,50,51,
59,255,34,34,42,255,46,49,63,255,34,34,42,255,38,42,54,255,34,34,42,255,34,34,
42,255,46,49,63,255,38,36,40,255,35,39,51,255,38,42,54,255,34,34,42,255,34,34,
42,255,34,34,42,255,46,49,63,255,34,34,42,255,34,34,42,255,38,42,54,255,34,34,
42,255,34,34,42,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,34,34,
42,255,38,42,54,255,50,51,59,255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,
54,255,38,42,54,255,34,34,42,255,46,49,63,255,34,34,42,255,34,34,42,255,50,51,
59,255,34,34,42,255,38,42,54,255,34,34,42,255,34,34,42,255,38,42,54,255,38,42,
54,255,38,42,54,255,38,42,54,255,38,42,54,255,34,34,42,255,35,39,51,255,35,39,
51,255,34,34,42,255,38,42,54,255,34,34,42,255,38,42,54,255,35,39,51,255,35,39,
51,255,34,34,42,255,46,49,63,255,38,42,54,255,85,86,118,255,119,117,169,255,
119,117,169,255,128,125,178,255,119,117,169,255,134,131,185,255,140,132,180,255,
143,140,194,255,136,136,183,255,128,128,175,255,132,132,179,255,134,131,185,255,
122,124,142,255,112,209,70,255,112,209,70,255,139,141,157,255,132,132,179,255,
138,135,189,255,153,152,200,255,148,148,195,255,153,152,200,255,148,148,195,255,
142,141,188,255,136,136,183,255,138,135,189,255,138,135,189,255,142,141,188,255,
148,148,195,255,132,132,179,255,145,141,183,255,145,142,177,255,154,150,192,255,
160,160,195,255,166,166,201,255,178,174,211,255,178,174,211,255,188,185,222,255,
188,184,227,255,191,186,215,255,220,221,234,0,1,6,9,0,35,38,218,0,85,86,118,0,1,
6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,
108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,
148,0,93,70,172,0,35,38,218,0,175,177,194,255,166,153,185,255,178,174,211,255,
178,174,211,255,178,173,216,255,166,166,201,255,166,166,201,255,160,160,195,255,
160,160,195,255,145,142,177,255,132,132,179,255,128,128,175,255,128,128,175,255,
124,124,170,255,124,124,170,255,117,118,163,255,124,124,170,255,128,125,178,255,
132,132,179,255,132,132,179,255,138,135,189,255,142,141,188,255,142,141,188,255,
136,136,183,255,145,141,183,255,138,134,175,255,138,135,189,255,138,135,189,255,
136,136,183,255,132,132,179,255,132,132,179,255,129,126,165,255,134,131,185,255,
128,125,178,255,128,125,178,255,128,125,178,255,124,124,170,255,132,132,179,255,
138,134,175,255,145,142,177,255,38,42,54,255,50,51,59,255,38,42,54,255,38,42,54,
255,38,42,54,255,35,39,51,255,34,34,42,255,38,36,40,255,38,42,54,255,35,39,51,
255,38,42,54,255,34,34,42,255,46,49,63,255,30,34,46,255,34,34,42,255,34,34,42,
255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,35,39,51,
255,35,39,51,255,34,34,42,255,38,42,54,255,34,34,42,255,46,49,63,255,30,34,46,
255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,
255,35,39,51,255,38,42,54,255,38,42,54,255,38,36,40,255,46,49,63,255,38,42,54,
255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,50,51,59,255,34,34,42,
255,46,49,63,255,35,39,51,255,34,34,42,255,46,49,63,255,35,39,51,255,35,39,51,
255,38,42,54,255,35,39,51,255,34,34,42,255,34,34,42,255,38,42,54,255,38,42,54,
255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,35,39,51,
255,35,39,51,255,34,34,42,255,38,42,54,255,38,42,54,255,38,42,54,255,34,34,42,
255,34,34,42,255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,
255,34,34,42,255,50,51,59,255,35,39,51,255,34,34,42,255,50,51,59,255,34,34,42,
255,38,42,54,255,34,34,42,255,38,42,54,255,50,51,59,255,46,49,63,255,119,117,
169,255,119,117,169,255,119,117,169,255,128,125,178,255,128,125,178,255,128,128,
175,255,138,135,189,255,128,128,175,255,124,124,170,255,128,125,178,255,134,131,
185,255,134,170,123,255,132,239,39,255,132,239,39,255,125,164,136,255,124,124,
170,255,132,132,179,255,148,140,188,255,136,136,183,255,132,132,179,255,136,136,
183,255,138,135,189,255,136,136,183,255,128,125,178,255,128,125,178,255,128,125,
178,255,132,132,179,255,117,118,163,255,128,128,175,255,128,128,175,255,145,141,
183,255,154,150,192,255,160,160,195,255,166,166,201,255,166,166,201,255,178,174,
211,255,188,184,227,255,191,186,215,255,220,221,234,255,1,6,9,0,35,38,218,0,85,
86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,
9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,
0,112,108,148,0,93,70,172,0,35,38,218,0,172,168,198,255,172,168,198,255,178,
174,211,255,188,184,227,255,178,174,211,255,173,165,202,255,166,157,194,255,155,
151,186,255,154,150,192,255,142,141,188,255,124,124,170,255,124,124,170,255,117,
118,163,255,117,118,163,255,117,118,163,255,123,115,163,255,155,151,186,255,138,
134,175,255,136,136,183,255,136,136,183,255,136,136,183,255,136,136,183,255,136,
136,183,255,142,141,188,255,136,136,183,255,136,136,183,255,136,136,183,255,132,
132,179,255,134,131,185,255,138,134,175,255,138,134,175,255,132,132,179,255,129,
126,165,255,134,131,185,255,128,125,178,255,131,124,172,255,128,128,175,255,140,
132,180,255,128,128,175,255,119,117,156,255,50,51,59,255,46,49,63,255,34,34,42,
255,35,39,51,255,34,34,42,255,38,42,54,255,38,42,54,255,35,39,51,255,35,39,51,
255,38,42,54,255,38,42,54,255,34,34,42,255,34,34,42,255,34,34,42,255,38,42,54,
255,38,42,54,255,34,34,42,255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,
255,38,36,40,255,34,34,42,255,38,42,54,255,35,39,51,255,38,42,54,255,34,34,42,
255,50,51,59,255,34,34,42,255,35,39,51,255,34,34,42,255,50,51,59,255,34,34,42,
255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,35,39,51,
255,35,39,51,255,50,51,59,255,38,42,54,255,38,36,40,255,34,34,42,255,35,39,51,
255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,255,34,34,42,255,34,34,42,
255,38,36,40,255,34,34,42,255,34,34,42,255,38,42,54,255,38,42,54,255,38,42,54,
255,34,34,42,255,38,42,54,255,34,34,42,255,50,51,59,255,34,34,42,255,34,34,42,
255,38,42,54,255,34,34,42,255,38,42,54,255,34,34,42,255,50,51,59,255,34,34,42,
255,38,42,54,255,38,42,54,255,34,34,42,255,38,42,54,255,35,39,51,255,50,51,59,
255,34,34,42,255,35,39,51,255,34,34,42,255,35,39,51,255,35,39,51,255,30,34,46,
255,38,42,54,255,38,42,54,255,38,42,54,255,38,42,54,255,46,49,63,255,46,49,63,
255,114,107,154,255,110,109,161,255,128,125,178,255,124,124,170,255,128,125,178,
255,134,131,185,255,140,132,180,255,131,124,172,255,128,128,175,255,124,124,170,
255,119,117,169,255,141,141,167,255,112,197,96,255,112,197,96,255,160,160,195,
255,128,125,178,255,128,125,178,255,141,140,200,255,134,131,185,255,149,146,200,
255,143,140,194,255,142,141,188,255,138,135,189,255,145,142,177,255,124,124,170,
255,124,124,170,255,128,125,178,255,119,117,169,255,119,117,169,255,124,124,170,
255,148,140,188,255,142,141,188,255,154,150,192,255,154,150,192,255,173,165,202,
255,173,165,202,255,188,184,227,255,191,186,215,255,220,221,234,0,1,6,9,0,35,38,
218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,93,70,172,0,35,38,218,0,160,158,188,255,166,157,194,
255,173,165,202,255,188,184,227,255,160,160,195,255,160,160,195,255,155,147,196,
255,140,132,180,255,136,136,183,255,132,132,179,255,128,128,175,255,155,151,186,
255,117,118,163,255,123,115,163,255,117,118,163,255,117,118,163,255,145,142,177,
255,145,142,177,255,138,135,189,255,132,132,179,255,132,132,179,255,136,136,183,
255,136,136,183,255,145,142,177,255,136,136,183,255,138,134,175,255,136,136,183,
255,132,132,179,255,128,128,175,255,132,132,179,255,132,132,179,255,132,132,179,
255,140,132,180,255,128,125,178,255,128,125,178,255,124,124,170,255,124,124,170,
255,128,128,175,255,131,124,172,255,111,110,143,255,46,49,63,255,38,42,54,255,
34,34,42,255,38,42,54,255,34,34,42,255,24,25,32,255,24,25,32,255,23,22,25,255,
23,22,25,255,24,25,32,255,24,25,32,255,24,25,32,255,29,30,37,255,23,22,25,255,
29,30,37,255,24,25,32,255,23,22,25,255,29,30,37,255,24,25,32,255,23,22,25,255,
29,30,37,255,29,30,37,255,24,25,32,255,23,22,25,255,23,22,25,255,29,30,37,255,
24,25,32,255,24,25,32,255,24,25,32,255,29,30,37,255,24,25,32,255,24,25,32,255,
23,22,25,255,23,22,25,255,29,30,37,255,23,22,25,255,24,25,32,255,23,22,25,255,
29,30,37,255,24,25,32,255,24,25,32,255,24,25,32,255,29,30,37,255,29,30,37,255,
24,25,32,255,23,22,25,255,29,30,37,255,29,30,37,255,29,30,37,255,29,30,37,255,
29,30,37,255,29,30,37,255,29,30,37,255,29,30,37,255,23,22,25,255,29,30,37,255,
29,30,37,255,23,22,25,255,29,30,37,255,24,25,32,255,24,25,32,255,29,30,37,255,
29,30,37,255,29,30,37,255,29,30,37,255,29,30,37,255,24,25,32,255,24,25,32,255,
23,22,25,255,34,34,42,255,23,22,25,255,38,36,40,255,23,22,25,255,24,25,32,255,
24,25,32,255,29,30,37,255,29,30,37,255,23,22,25,255,29,30,37,255,29,30,37,255,
23,22,25,255,24,25,32,255,34,34,42,255,34,34,42,255,34,34,42,255,50,51,59,255,
50,51,59,255,96,95,132,255,123,115,163,255,119,117,169,255,131,124,172,255,128,
125,178,255,134,131,185,255,134,131,185,255,129,126,165,255,132,132,179,255,128,
128,175,255,128,125,178,255,128,128,175,255,153,152,200,255,154,151,205,255,128,
125,178,255,128,125,178,255,124,124,170,255,129,126,165,255,131,124,172,255,128,
128,175,255,132,132,179,255,138,135,189,255,124,124,170,255,155,151,186,255,119,
117,169,255,117,118,163,255,114,107,154,255,117,118,163,255,145,142,177,255,124,
124,170,255,132,132,179,255,140,132,180,255,140,132,180,255,136,136,183,255,162,
158,200,255,166,166,201,255,188,185,222,255,191,186,215,255,191,194,208,255,1,6,
9,0,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,
9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,
0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,175,177,194,255,166,166,201,
255,160,160,195,255,178,174,211,255,178,173,216,255,166,157,194,255,154,150,192,
255,132,132,179,255,138,135,189,255,148,140,188,255,132,132,179,255,128,128,175,
255,160,158,188,255,131,124,172,255,124,124,170,255,131,124,172,255,128,128,175,
255,132,132,179,255,140,132,180,255,138,134,175,255,138,134,175,255,136,136,183,
255,136,136,183,255,145,141,183,255,136,136,183,255,145,141,183,255,142,141,188,
255,142,141,188,255,140,132,180,255,134,131,185,255,132,132,179,255,138,134,175,
255,138,134,175,255,129,126,165,255,128,125,178,255,119,117,169,255,128,125,178,
255,128,128,175,255,124,124,170,255,124,124,170,255,111,110,143,255,46,49,63,
255,34,34,42,255,38,42,54,255,34,34,42,255,23,22,25,255,16,18,27,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,255,15,11,59,
255,15,11,59,255,15,11,59,255,15,11,59,255,29,30,37,255,38,42,54,255,35,39,51,
255,30,34,46,255,46,49,63,255,85,86,118,255,110,109,161,255,119,117,169,255,128,
125,178,255,128,125,178,255,128,125,178,255,128,128,175,255,128,125,178,255,131,
124,172,255,128,128,175,255,128,125,178,255,128,125,178,255,119,117,169,255,124,
124,170,255,124,124,170,255,124,124,170,255,124,124,170,255,124,124,170,255,124,
124,170,255,129,126,165,255,128,128,175,255,129,126,165,255,128,128,175,255,128,
128,175,255,128,128,175,255,128,125,178,255,124,124,170,255,123,115,163,255,145,
142,177,255,138,134,175,255,128,128,175,255,132,132,179,255,136,136,183,255,138,
135,189,255,155,151,186,255,173,165,202,255,178,173,216,255,188,185,222,255,172,
168,198,255,186,190,212,255,35,38,218,0,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,
9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,93,70,172,0,174,166,
191,255,160,160,195,255,154,150,192,255,166,166,201,255,178,173,216,255,166,157,
194,255,162,158,200,255,136,136,183,255,132,132,179,255,145,141,183,255,138,134,
175,255,129,126,165,255,129,126,165,255,128,128,175,255,132,132,179,255,140,132,
180,255,145,141,183,255,138,134,175,255,138,134,175,255,132,132,179,255,132,132,
179,255,140,132,180,255,138,135,189,255,145,141,183,255,138,134,175,255,145,142,
177,255,136,136,183,255,132,132,179,255,128,125,178,255,128,125,178,255,128,125,
178,255,128,128,175,255,132,132,179,255,129,126,165,255,140,132,180,255,119,117,
169,255,119,117,169,255,131,124,172,255,124,124,170,255,123,115,163,255,92,92,
112,255,46,49,63,255,34,34,42,255,46,49,63,255,35,39,51,255,24,25,32,255,11,16,
37,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,
145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,
145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,
145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,
145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,
145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,
145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,
15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,15,11,145,255,23,22,25,
255,35,39,51,255,38,42,54,255,35,39,51,255,46,49,63,255,71,72,102,255,110,109,
161,255,123,115,163,255,123,115,163,255,124,124,170,255,124,124,170,255,124,124,
170,255,124,124,170,255,124,124,170,255,128,128,175,255,119,117,169,255,134,131,
185,255,128,125,178,255,128,125,178,255,131,124,172,255,128,128,175,255,128,128,
175,255,138,134,175,255,140,132,180,255,132,132,179,255,128,128,175,255,128,128,
175,255,128,128,175,255,138,134,175,255,138,134,175,255,134,131,185,255,138,135,
189,255,138,134,175,255,132,132,179,255,138,134,175,255,136,136,183,255,132,132,
179,255,128,128,175,255,134,131,185,255,155,151,186,255,160,160,195,255,169,165,
207,255,173,165,202,255,172,168,198,255,191,186,215,255,35,38,218,0,85,86,118,0,
1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,
108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,
148,0,93,70,172,0,174,166,191,255,155,151,186,255,148,148,195,255,162,158,200,
255,178,174,211,255,160,160,195,255,166,157,194,255,138,135,189,255,132,132,179,
255,145,142,177,255,145,142,177,255,138,134,175,255,132,132,179,255,129,126,165,
255,134,131,185,255,134,131,185,255,136,136,183,255,145,142,177,255,138,134,175,
255,138,134,175,255,138,134,175,255,132,132,179,255,138,134,175,255,136,136,183,
255,142,141,188,255,142,141,188,255,140,132,180,255,134,131,185,255,145,141,183,
255,145,142,177,255,124,124,170,255,134,131,185,255,128,128,175,255,138,134,175,
255,124,124,170,255,128,125,178,255,119,117,169,255,117,118,163,255,123,115,163,
255,129,126,165,255,85,86,118,255,38,42,54,255,35,39,51,255,34,34,42,255,30,34,
46,255,34,34,42,255,11,16,37,255,6,20,186,255,6,20,186,255,25,21,206,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,
186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,6,20,186,255,15,11,
145,255,6,20,186,255,6,20,186,255,6,20,186,255,15,11,145,255,6,20,186,255,15,11,
145,255,24,25,32,255,38,42,54,255,34,34,42,255,34,34,42,255,46,49,63,255,71,72,
102,255,114,107,154,255,119,117,169,255,124,124,170,255,123,115,163,255,123,115,
163,255,131,124,172,255,124,124,170,255,124,124,170,255,128,125,178,255,128,125,
178,255,188,184,235,255,158,156,218,255,119,117,169,255,128,125,178,255,129,126,
165,255,132,132,179,255,128,128,175,255,128,128,175,255,138,134,175,255,132,132,
179,255,132,132,179,255,136,136,183,255,145,142,177,255,142,141,188,255,134,131,
185,255,132,132,179,255,132,132,179,255,138,134,175,255,138,134,175,255,138,134,
175,255,145,141,183,255,140,132,180,255,136,136,183,255,166,157,194,255,160,160,
195,255,173,165,202,255,169,165,207,255,160,160,195,255,175,177,194,255,175,177,
194,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,175,177,194,255,160,160,195,255,154,150,192,255,142,
141,188,255,148,148,195,255,173,165,202,255,160,160,195,255,160,158,188,255,148,
140,188,255,132,132,179,255,138,135,189,255,138,134,175,255,132,132,179,255,132,
132,179,255,132,132,179,255,132,132,179,255,128,128,175,255,138,135,189,255,142,
141,188,255,145,142,177,255,138,135,189,255,136,136,183,255,132,132,179,255,136,
136,183,255,145,142,177,255,136,136,183,255,145,142,177,255,138,135,189,255,140,
132,180,255,145,141,183,255,145,141,183,255,131,124,172,255,140,132,180,255,131,
124,172,255,128,128,175,255,129,126,165,255,128,125,178,255,119,117,169,255,124,
124,170,255,123,115,163,255,129,126,165,255,79,80,102,255,38,36,40,255,38,42,54,
255,34,34,42,255,34,34,42,255,29,30,37,255,11,16,37,255,25,21,206,255,25,21,206,
255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,
206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,
25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,
206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,
25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,
206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,
25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,6,20,186,
255,25,21,206,255,25,21,206,255,6,20,186,255,25,21,206,255,6,20,186,255,25,21,
206,255,6,20,186,255,25,21,206,255,25,21,206,255,25,21,206,255,6,20,186,255,25,
21,206,255,6,20,186,255,6,20,186,255,6,20,186,255,25,21,206,255,6,20,186,255,
25,21,206,255,6,20,186,255,25,21,206,255,6,20,186,255,35,38,218,255,6,20,186,
255,6,20,186,255,25,21,206,255,6,20,186,255,25,21,206,255,25,21,206,255,25,21,
206,255,25,21,206,255,6,20,186,255,25,21,206,255,35,38,218,255,25,21,206,255,6,
20,186,255,29,30,37,255,34,34,42,255,46,49,63,255,30,34,46,255,46,49,63,255,64,
65,86,255,114,107,154,255,110,109,161,255,124,124,170,255,124,124,170,255,124,
124,170,255,131,124,172,255,131,124,172,255,124,124,170,255,128,125,178,255,119,
117,169,255,155,147,196,255,143,140,194,255,128,125,178,255,128,128,175,255,128,
128,175,255,129,126,165,255,138,134,175,255,132,132,179,255,132,132,179,255,132,
132,179,255,132,132,179,255,132,132,179,255,136,136,183,255,138,134,175,255,140,
132,180,255,136,136,183,255,136,136,183,255,145,141,183,255,138,134,175,255,138,
134,175,255,145,141,183,255,140,132,180,255,142,141,188,255,166,157,194,255,160,
160,195,255,162,158,200,255,169,165,207,255,148,140,188,255,174,166,191,255,186,
190,212,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,174,166,191,255,160,158,188,255,148,148,195,255,155,
147,196,255,154,151,205,255,169,165,207,255,166,157,194,255,154,150,192,255,142,
141,188,255,138,135,189,255,145,142,177,255,136,136,183,255,132,132,179,255,140,
132,180,255,132,132,179,255,132,132,179,255,134,131,185,255,136,136,183,255,142,
141,188,255,138,135,189,255,142,141,188,255,136,136,183,255,142,141,188,255,136,
136,183,255,136,136,183,255,145,141,183,255,142,141,188,255,138,134,175,255,134,
131,185,255,134,131,185,255,134,131,185,255,128,125,178,255,128,125,178,255,128,
125,178,255,140,132,180,255,128,125,178,255,131,124,172,255,128,125,178,255,119,
117,156,255,124,124,170,255,123,115,163,255,71,72,102,255,46,49,63,255,35,39,51,
255,38,42,54,255,30,34,46,255,34,34,42,255,16,18,27,255,25,21,206,255,25,21,206,
255,25,21,206,255,25,21,206,255,25,21,206,255,8,30,219,255,25,21,206,255,25,21,
206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,
25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,
206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,
25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,
206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,
25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,8,30,219,
255,25,21,206,255,25,21,206,255,25,21,206,255,25,21,206,255,8,30,219,255,25,21,
206,255,25,21,206,255,25,21,206,255,35,38,218,255,25,21,206,255,25,21,206,255,
35,38,218,255,25,21,206,255,8,30,219,255,25,21,206,255,25,21,206,255,25,21,206,
255,25,21,206,255,8,30,219,255,35,38,218,255,25,21,206,255,25,21,206,255,25,21,
206,255,8,30,219,255,35,38,218,255,25,21,206,255,25,21,206,255,35,38,218,255,25,
21,206,255,35,38,218,255,25,21,206,255,25,21,206,255,25,21,206,255,35,38,218,
255,6,20,186,255,29,30,37,255,35,39,51,255,34,34,42,255,38,42,54,255,38,36,40,
255,52,55,78,255,110,109,161,255,123,115,163,255,119,117,169,255,119,117,169,
255,119,117,169,255,119,117,169,255,128,125,178,255,128,125,178,255,128,125,178,
255,119,117,169,255,128,125,178,255,128,125,178,255,124,124,170,255,132,132,179,
255,128,128,175,255,132,132,179,255,128,128,175,255,129,126,165,255,132,132,179,
255,132,132,179,255,140,132,180,255,138,135,189,255,138,135,189,255,138,135,189,
255,132,132,179,255,132,132,179,255,136,136,183,255,132,132,179,255,142,141,188,
255,142,141,188,255,145,142,177,255,143,140,194,255,142,141,188,255,155,151,186,
255,166,157,194,255,162,158,200,255,167,163,218,255,142,141,188,255,160,158,188,
255,175,177,194,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,
6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,
116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,194,255,166,157,194,255,142,141,
188,255,149,146,200,255,154,151,205,255,159,158,206,255,160,160,195,255,166,157,
194,255,142,141,188,255,138,135,189,255,136,136,183,255,136,136,183,255,138,135,
189,255,140,132,180,255,138,135,189,255,138,135,189,255,138,135,189,255,134,131,
185,255,142,141,188,255,136,136,183,255,142,141,188,255,136,136,183,255,136,136,
183,255,142,141,188,255,136,136,183,255,136,136,183,255,136,136,183,255,138,134,
175,255,138,134,175,255,138,134,175,255,140,132,180,255,128,128,175,255,124,124,
170,255,124,124,170,255,128,125,178,255,119,117,169,255,119,117,169,255,119,117,
169,255,123,115,163,255,119,117,169,255,117,118,163,255,64,65,86,255,38,42,54,
255,30,34,46,255,34,34,42,255,34,34,42,255,30,34,46,255,11,16,37,255,25,21,206,
255,8,30,219,255,35,38,218,255,8,30,219,255,8,30,219,255,25,21,206,255,8,30,219,
255,8,30,219,255,8,30,219,255,8,30,219,255,35,38,218,255,8,30,219,255,35,38,218,
255,8,30,219,255,35,38,218,255,8,30,219,255,8,30,219,255,8,30,219,255,8,30,219,
255,35,38,218,255,8,30,219,255,35,38,218,255,8,30,219,255,35,38,218,255,35,38,
218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,
25,21,206,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,
218,255,35,38,218,255,35,38,218,255,8,30,219,255,35,38,218,255,25,21,206,255,8,
30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,8,30,219,255,35,38,218,
255,35,38,218,255,25,21,206,255,35,38,218,255,25,21,206,255,8,30,219,255,8,30,
219,255,35,38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,35,
38,218,255,25,21,206,255,8,30,219,255,8,30,219,255,35,38,218,255,35,38,218,255,
25,21,206,255,8,30,219,255,8,30,219,255,35,38,218,255,25,21,206,255,8,30,219,
255,35,38,218,255,35,38,218,255,35,38,218,255,25,21,206,255,35,38,218,255,6,20,
186,255,23,22,25,255,38,42,54,255,35,39,51,255,38,42,54,255,46,49,63,255,46,49,
63,255,110,109,161,255,110,109,161,255,119,117,169,255,117,118,163,255,117,118,
163,255,119,117,169,255,114,107,154,255,119,117,169,255,119,117,169,255,119,117,
169,255,123,115,163,255,128,125,178,255,124,124,170,255,128,128,175,255,128,128,
175,255,129,126,165,255,132,132,179,255,138,134,175,255,132,132,179,255,138,134,
175,255,132,132,179,255,132,132,179,255,132,132,179,255,134,131,185,255,138,135,
189,255,134,131,185,255,138,135,189,255,132,132,179,255,136,136,183,255,148,140,
188,255,138,134,175,255,148,140,188,255,148,140,188,255,154,150,192,255,155,151,
186,255,155,151,186,255,166,165,214,255,148,148,195,255,174,166,191,255,174,166,
191,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,175,177,194,255,160,158,188,255,155,147,196,255,148,
140,188,255,161,157,212,255,159,158,206,255,162,158,200,255,154,150,192,255,154,
150,192,255,138,135,189,255,138,135,189,255,140,132,180,255,138,135,189,255,138,
135,189,255,138,135,189,255,134,131,185,255,134,131,185,255,134,131,185,255,134,
131,185,255,138,135,189,255,134,131,185,255,138,135,189,255,143,140,194,255,134,
131,185,255,138,135,189,255,138,135,189,255,136,136,183,255,136,136,183,255,140,
132,180,255,140,132,180,255,132,132,179,255,128,128,175,255,124,124,170,255,124,
124,170,255,131,124,172,255,131,124,172,255,131,124,172,255,119,117,169,255,117,
118,163,255,129,126,165,255,123,115,163,255,52,55,78,255,34,34,42,255,50,51,59,
255,30,34,46,255,30,34,46,255,38,36,40,255,16,18,27,255,35,38,218,255,35,38,218,
255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,
218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,
35,38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,
255,35,38,218,255,35,38,218,255,8,30,219,255,35,38,218,255,8,30,219,255,35,38,
218,255,8,30,219,255,35,38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,35,
38,218,255,35,38,218,255,35,38,218,255,25,21,206,255,35,38,218,255,35,38,218,
255,35,38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,8,30,219,255,35,38,
218,255,8,30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,
38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,
255,35,38,218,255,35,38,218,255,8,30,219,255,35,38,218,255,8,30,219,255,35,38,
218,255,8,30,219,255,35,38,218,255,35,38,218,255,8,30,219,255,35,38,218,255,8,
30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,
255,35,38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,25,21,206,255,19,50,
182,255,29,30,37,255,34,34,42,255,35,39,51,255,35,39,51,255,38,36,40,255,46,49,
63,255,114,107,154,255,109,109,154,255,109,109,154,255,123,115,163,255,114,107,
154,255,109,109,154,255,117,118,163,255,123,115,163,255,123,115,163,255,117,118,
163,255,119,117,169,255,124,124,170,255,128,128,175,255,138,134,175,255,138,134,
175,255,136,136,183,255,132,132,179,255,128,128,175,255,138,134,175,255,136,136,
183,255,132,132,179,255,132,132,179,255,132,132,179,255,138,135,189,255,136,136,
183,255,136,136,183,255,136,136,183,255,136,136,183,255,142,141,188,255,138,135,
189,255,143,140,194,255,143,140,194,255,142,141,188,255,154,150,192,255,162,158,
200,255,159,158,206,255,161,157,212,255,142,141,188,255,160,158,188,255,175,177,
194,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,175,177,194,255,160,160,195,255,149,146,200,255,148,
148,195,255,154,151,205,255,155,147,196,255,162,158,200,255,154,150,192,255,154,
150,192,255,142,141,188,255,143,140,194,255,136,136,183,255,138,135,189,255,132,
132,179,255,134,131,185,255,134,131,185,255,134,131,185,255,141,140,200,255,143,
140,194,255,155,147,196,255,148,140,188,255,148,140,188,255,153,152,200,255,148,
148,195,255,148,140,188,255,143,140,194,255,138,135,189,255,134,131,185,255,132,
132,179,255,134,131,185,255,132,132,179,255,140,132,180,255,128,128,175,255,129,
126,165,255,129,126,165,255,124,124,170,255,119,117,169,255,119,117,169,255,119,
117,169,255,117,118,163,255,119,117,156,255,46,49,63,255,35,39,51,255,34,34,42,
255,35,39,51,255,30,34,46,255,29,30,37,255,16,18,27,255,35,38,218,255,8,30,219,
255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,
218,255,35,38,218,255,8,30,219,255,35,38,218,255,35,38,218,255,35,38,218,255,35,
38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,
255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,
218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,8,30,219,255,35,
38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,
255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,
218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,
35,38,218,255,27,48,224,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,
218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,35,38,218,255,
27,48,224,255,35,38,218,255,27,48,224,255,35,38,218,255,27,48,224,255,35,38,
218,255,27,48,224,255,35,38,218,255,27,48,224,255,35,38,218,255,35,38,218,255,
35,38,218,255,35,38,218,255,35,38,218,255,27,48,224,255,35,38,218,255,35,38,
218,255,19,50,182,255,30,34,46,255,34,34,42,255,38,42,54,255,35,39,51,255,38,42,
54,255,46,49,63,255,110,109,161,255,123,115,163,255,117,118,163,255,117,118,
163,255,117,118,163,255,123,115,163,255,117,118,163,255,117,118,163,255,123,115,
163,255,117,118,163,255,117,118,163,255,124,124,170,255,128,128,175,255,132,132,
179,255,132,132,179,255,138,134,175,255,132,132,179,255,132,132,179,255,132,132,
179,255,138,134,175,255,138,134,175,255,136,136,183,255,138,134,175,255,136,136,
183,255,132,132,179,255,136,136,183,255,136,136,183,255,136,136,183,255,145,141,
183,255,145,141,183,255,145,141,183,255,142,141,188,255,145,141,183,255,153,152,
200,255,154,150,192,255,154,150,192,255,165,156,206,255,153,152,200,255,160,158,
188,255,168,170,187,255,85,86,118,0,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,194,255,160,158,188,255,148,
148,195,255,143,140,194,255,155,147,196,255,153,152,200,255,154,150,192,255,154,
150,192,255,143,140,194,255,138,135,189,255,132,132,179,255,136,136,183,255,132,
132,179,255,134,131,185,255,138,135,189,255,138,135,189,255,143,140,194,255,142,
141,188,255,155,147,196,255,153,152,200,255,154,151,205,255,159,158,206,255,154,
150,192,255,153,152,200,255,153,152,200,255,148,148,195,255,142,141,188,255,143,
140,194,255,134,131,185,255,132,132,179,255,140,132,180,255,132,132,179,255,128,
128,175,255,128,128,175,255,124,124,170,255,131,124,172,255,131,124,172,255,119,
117,169,255,123,115,163,255,117,118,163,255,123,115,163,255,46,49,63,255,35,39,
51,255,46,49,63,255,30,34,46,255,30,34,46,255,34,34,42,255,16,18,27,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,
224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,27,48,224,255,
27,48,224,255,27,48,224,255,8,30,219,255,19,50,182,255,24,25,32,255,35,39,51,
255,30,34,46,255,35,39,51,255,35,39,51,255,46,49,63,255,109,109,154,255,110,109,
161,255,117,118,163,255,124,124,170,255,131,124,172,255,117,118,163,255,124,124,
170,255,124,124,170,255,124,124,170,255,124,124,170,255,131,124,172,255,124,124,
170,255,132,132,179,255,136,136,183,255,145,142,177,255,136,136,183,255,145,142,
177,255,138,134,175,255,138,134,175,255,136,136,183,255,142,141,188,255,142,141,
188,255,142,141,188,255,136,136,183,255,142,141,188,255,142,141,188,255,148,140,
188,255,148,140,188,255,142,141,188,255,142,141,188,255,142,141,188,255,142,141,
188,255,148,148,195,255,145,141,183,255,153,152,200,255,155,147,196,255,149,146,
200,255,153,152,200,255,141,141,167,255,175,177,194,255,183,187,202,255,1,6,9,0,
1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,
0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,
175,177,194,255,160,158,188,255,155,147,196,255,149,146,200,255,149,146,200,255,
148,148,195,255,154,150,192,255,145,141,183,255,148,140,188,255,138,135,189,255,
134,131,185,255,138,135,189,255,134,131,185,255,140,132,180,255,148,140,188,255,
142,141,188,255,153,152,200,255,154,150,192,255,145,142,177,255,145,142,177,255,
145,142,177,255,145,142,177,255,141,141,167,255,145,142,177,255,153,139,168,255,
155,147,196,255,154,150,192,255,148,140,188,255,148,140,188,255,134,131,185,255,
134,131,185,255,132,132,179,255,140,132,180,255,128,128,175,255,129,126,165,255,
129,126,165,255,119,117,169,255,123,115,163,255,123,115,163,255,117,118,163,255,
112,108,148,255,38,42,54,255,34,34,42,255,34,34,42,255,34,34,42,255,30,34,46,
255,29,30,37,255,16,18,27,255,27,48,224,255,14,56,229,255,14,56,229,255,27,48,
224,255,14,56,229,255,14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,
14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,27,48,224,255,14,56,
229,255,14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,27,48,224,255,
14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,27,48,224,255,14,56,
229,255,14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,27,48,224,255,
14,56,229,255,14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,14,56,
229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,
14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,14,56,229,255,27,48,
224,255,14,56,229,255,14,56,229,255,14,56,229,255,27,48,224,255,14,56,229,255,
14,56,229,255,14,56,229,255,27,48,224,255,14,56,229,255,14,56,229,255,14,56,
229,255,27,48,224,255,14,56,229,255,14,56,229,255,14,56,229,255,27,48,224,255,
14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,27,48,
224,255,14,56,229,255,14,56,229,255,27,48,224,255,14,56,229,255,27,48,224,255,
19,50,182,255,34,34,42,255,34,34,42,255,34,34,42,255,34,34,42,255,34,34,42,255,
46,49,63,255,109,109,154,255,110,109,161,255,124,124,170,255,129,126,165,255,
124,124,170,255,124,124,170,255,124,124,170,255,124,124,170,255,129,126,165,255,
129,126,165,255,138,134,175,255,138,134,175,255,138,134,175,255,136,136,183,255,
145,142,177,255,136,136,183,255,136,136,183,255,145,142,177,255,142,141,188,255,
145,142,177,255,136,136,183,255,142,141,188,255,148,140,188,255,148,140,188,255,
142,141,188,255,142,141,188,255,142,141,188,255,142,141,188,255,148,140,188,255,
138,135,189,255,143,140,194,255,140,132,180,255,142,141,188,255,136,136,183,255,
142,141,188,255,153,152,200,255,149,146,200,255,161,157,212,255,145,141,183,255,
168,170,187,255,184,185,195,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,
6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,
116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,194,255,160,158,188,255,148,148,
195,255,142,141,188,255,148,140,188,255,155,147,196,255,154,150,192,255,155,151,
186,255,145,141,183,255,132,132,179,255,134,131,185,255,134,131,185,255,143,140,
194,255,142,141,188,255,148,148,195,255,153,152,200,255,159,158,206,255,128,121,
147,255,141,141,167,255,139,141,157,255,157,158,178,255,157,158,178,255,160,158,
188,255,141,141,167,255,122,124,142,255,129,126,165,255,148,148,195,255,153,152,
200,255,148,148,195,255,142,141,188,255,128,128,175,255,134,131,185,255,128,128,
175,255,140,132,180,255,128,128,175,255,124,124,170,255,131,124,172,255,128,125,
178,255,117,118,163,255,117,118,163,255,112,108,148,255,34,34,42,255,35,39,51,
255,30,34,46,255,46,49,63,255,34,34,42,255,24,25,32,255,24,25,32,255,0,63,234,
255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,0,63,234,255,14,56,
229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,
14,56,229,255,0,63,234,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,
255,14,56,229,255,0,63,234,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,
229,255,14,56,229,255,14,56,229,255,0,63,234,255,14,56,229,255,14,56,229,255,0,
63,234,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,
255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,
229,255,14,56,229,255,0,63,234,255,14,56,229,255,14,56,229,255,14,56,229,255,14,
56,229,255,0,63,234,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,
255,14,56,229,255,14,56,229,255,0,63,234,255,14,56,229,255,14,56,229,255,14,56,
229,255,0,63,234,255,14,56,229,255,14,56,229,255,14,56,229,255,0,63,234,255,14,
56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,
255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,14,56,229,255,27,48,
224,255,19,50,182,255,34,34,42,255,34,34,42,255,38,42,54,255,35,39,51,255,35,39,
51,255,38,42,54,255,96,95,132,255,123,115,163,255,119,117,156,255,124,124,170,
255,129,126,165,255,129,126,165,255,129,126,165,255,129,126,165,255,136,136,183,
255,136,136,183,255,132,132,179,255,132,132,179,255,142,141,188,255,142,141,188,
255,143,140,194,255,142,141,188,255,142,141,188,255,142,141,188,255,136,136,183,
255,143,140,194,255,142,141,188,255,142,141,188,255,143,140,194,255,138,135,189,
255,148,140,188,255,143,140,194,255,142,141,188,255,142,141,188,255,138,135,189,
255,143,140,194,255,138,135,189,255,141,140,200,255,138,135,189,255,148,140,188,
255,142,141,188,255,154,150,192,255,143,140,194,255,154,151,205,255,155,151,186,
255,168,170,187,255,191,194,208,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,194,255,172,168,198,255,148,
148,195,255,149,146,200,255,143,140,194,255,148,140,188,255,154,150,192,255,145,
141,183,255,148,140,188,255,138,135,189,255,138,135,189,255,140,132,180,255,148,
148,195,255,145,141,183,255,162,158,200,255,153,152,200,255,159,158,206,255,160,
160,195,255,238,238,251,255,238,238,251,255,238,238,251,255,238,238,251,255,248,
245,250,255,229,230,244,255,139,141,157,255,119,117,156,255,155,147,196,255,155,
147,196,255,154,150,192,255,153,152,200,255,148,140,188,255,132,132,179,255,128,
125,178,255,134,131,185,255,140,132,180,255,129,126,165,255,124,124,170,255,119,
117,169,255,123,115,163,255,123,115,163,255,96,95,132,255,50,51,59,255,34,34,42,
255,34,34,42,255,30,34,46,255,35,39,51,255,24,25,32,255,18,16,20,255,14,56,229,
255,17,71,235,255,0,63,234,255,0,63,234,255,0,63,234,255,0,63,234,255,17,71,235,
255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,
255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,
255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,
255,0,63,234,255,0,63,234,255,0,63,234,255,0,63,234,255,0,63,234,255,0,63,234,
255,0,63,234,255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,
255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,
255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,0,63,234,
255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,
255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,0,63,234,255,17,71,235,
255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,
255,0,63,234,255,17,71,235,255,0,63,234,255,0,63,234,255,17,71,235,255,0,63,234,
255,17,71,235,255,14,56,229,255,19,50,182,255,29,30,37,255,34,34,42,255,38,42,
54,255,38,42,54,255,35,39,51,255,46,49,63,255,96,95,132,255,119,117,169,255,
117,118,163,255,129,126,165,255,124,124,170,255,124,124,170,255,128,128,175,255,
129,126,165,255,138,134,175,255,145,142,177,255,145,142,177,255,145,142,177,255,
142,141,188,255,142,141,188,255,143,140,194,255,143,140,194,255,138,135,189,255,
142,141,188,255,145,141,183,255,145,141,183,255,138,135,189,255,136,136,183,255,
143,140,194,255,138,135,189,255,143,140,194,255,143,140,194,255,143,140,194,255,
149,146,200,255,148,140,188,255,162,158,200,255,169,165,207,255,143,140,194,255,
138,135,189,255,143,140,194,255,142,141,188,255,154,150,192,255,155,147,196,255,
154,151,205,255,145,141,183,255,168,170,187,255,191,194,208,255,1,6,9,0,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,177,177,
187,255,160,158,188,255,153,152,200,255,149,146,200,255,148,148,195,255,149,146,
200,255,145,141,183,255,142,141,188,255,136,136,183,255,138,135,189,255,138,135,
189,255,148,148,195,255,155,147,196,255,165,156,206,255,162,158,200,255,162,158,
200,255,159,158,206,255,172,168,198,255,220,221,234,255,208,208,221,255,208,208,
221,255,208,208,221,255,208,208,221,255,208,208,221,255,139,141,157,255,119,117,
156,255,148,148,195,255,162,158,200,255,162,158,200,255,162,158,200,255,154,150,
192,255,142,141,188,255,132,132,179,255,128,125,178,255,128,128,175,255,128,125,
178,255,131,124,172,255,131,124,172,255,117,118,163,255,117,118,163,255,96,95,
132,255,38,42,54,255,35,39,51,255,35,39,51,255,30,34,46,255,30,34,46,255,29,30,
37,255,23,22,25,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,
71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,
255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,
235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,
17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,
235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,
17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,
235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,
17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,
235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,
17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,
235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,
17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,
235,255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,19,50,182,255,
28,32,43,255,35,39,51,255,34,34,42,255,34,34,42,255,34,34,42,255,38,42,54,255,
96,95,132,255,109,109,154,255,129,126,165,255,124,124,170,255,129,126,165,255,
129,126,165,255,138,134,175,255,136,136,183,255,145,142,177,255,136,136,183,255,
142,141,188,255,142,141,188,255,145,141,183,255,138,135,189,255,138,135,189,255,
143,140,194,255,138,135,189,255,142,141,188,255,136,136,183,255,140,132,180,255,
148,140,188,255,143,140,194,255,142,141,188,255,162,158,200,255,153,152,200,255,
149,146,200,255,142,141,188,255,145,141,183,255,148,148,195,255,178,173,216,255,
206,202,246,255,169,165,207,255,138,135,189,255,132,132,179,255,142,141,188,255,
142,141,188,255,143,140,194,255,161,157,212,255,148,140,188,255,168,170,187,255,
184,185,195,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,
0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,
1,6,9,0,112,108,148,0,184,185,195,255,174,166,191,255,145,141,183,255,149,146,
200,255,142,141,188,255,155,147,196,255,154,150,192,255,136,136,183,255,138,135,
189,255,140,132,180,255,148,148,195,255,162,158,200,255,154,150,192,255,166,157,
194,255,173,165,202,255,162,158,200,255,159,158,206,255,157,158,178,255,177,177,
187,255,158,159,169,255,158,159,169,255,158,159,169,255,168,170,187,255,168,170,
187,255,139,141,157,255,119,117,156,255,148,148,195,255,153,152,200,255,162,158,
200,255,162,158,200,255,162,158,200,255,162,158,200,255,145,141,183,255,128,128,
175,255,140,132,180,255,131,124,172,255,131,124,172,255,128,125,178,255,117,118,
163,255,123,115,163,255,85,86,118,255,46,49,63,255,34,34,42,255,34,34,42,255,34,
34,42,255,35,39,51,255,29,30,37,255,18,16,20,255,17,71,235,255,17,71,235,255,
17,71,235,255,0,81,240,255,17,71,235,255,17,71,235,255,17,71,235,255,0,81,240,
255,17,71,235,255,17,71,235,255,0,81,240,255,17,71,235,255,17,71,235,255,17,71,
235,255,53,80,211,255,125,67,142,255,112,86,153,255,93,70,172,255,53,80,211,255,
17,71,235,255,17,71,235,255,48,92,213,255,48,92,213,255,53,80,211,255,17,71,
235,255,17,71,235,255,17,71,235,255,57,100,210,255,57,100,210,255,17,71,235,255,
17,71,235,255,17,71,235,255,57,100,210,255,57,100,210,255,53,80,211,255,17,71,
235,255,53,80,211,255,57,100,210,255,58,91,185,255,57,100,210,255,57,100,210,
255,48,92,213,255,17,71,235,255,0,81,240,255,0,81,240,255,48,92,213,255,48,92,
213,255,48,92,213,255,53,80,211,255,17,71,235,255,17,71,235,255,0,81,240,255,17,
71,235,255,17,71,235,255,53,80,211,255,57,100,210,255,17,71,235,255,0,81,240,
255,57,100,210,255,48,92,213,255,17,71,235,255,17,71,235,255,17,71,235,255,48,
92,213,255,48,92,213,255,14,87,241,255,17,71,235,255,17,71,235,255,17,71,235,
255,17,71,235,255,17,71,235,255,17,71,235,255,17,71,235,255,0,81,240,255,0,81,
240,255,2,66,183,255,29,30,37,255,35,39,51,255,35,39,51,255,35,39,51,255,34,34,
42,255,46,49,63,255,96,95,132,255,110,109,161,255,124,124,170,255,128,128,175,
255,132,132,179,255,132,132,179,255,138,134,175,255,136,136,183,255,136,136,183,
255,136,136,183,255,142,141,188,255,142,141,188,255,145,141,183,255,136,136,183,
255,148,140,188,255,178,173,216,255,138,135,189,255,138,135,189,255,138,135,189,
255,138,135,189,255,134,131,185,255,148,140,188,255,169,165,207,255,199,194,238,
255,173,165,202,255,174,166,191,255,208,208,221,255,229,230,244,255,229,230,244,
255,200,201,225,255,178,174,211,255,154,150,192,255,138,135,189,255,140,132,180,
255,142,141,188,255,154,150,192,255,142,141,188,255,154,151,205,255,148,140,188,
255,168,170,187,255,184,185,195,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,255,160,158,188,255,148,
148,195,255,149,146,200,255,149,146,200,255,142,141,188,255,142,141,188,255,140,
132,180,255,138,135,189,255,143,140,194,255,155,147,196,255,162,158,200,255,173,
165,202,255,169,165,207,255,169,165,207,255,173,165,202,255,166,165,214,255,172,
168,198,255,168,170,187,255,158,159,169,255,158,159,169,255,158,159,169,255,169,
170,180,255,177,177,187,255,139,141,157,255,119,117,156,255,155,147,196,255,162,
158,200,255,169,165,207,255,173,165,202,255,173,165,202,255,162,158,200,255,154,
150,192,255,148,140,188,255,128,125,178,255,128,128,175,255,131,124,172,255,119,
117,169,255,123,115,163,255,119,117,156,255,85,86,118,255,38,36,40,255,38,42,54,
255,34,34,42,255,30,34,46,255,34,34,42,255,24,25,32,255,23,22,25,255,14,87,241,
255,0,81,240,255,0,81,240,255,0,81,240,255,14,87,241,255,14,87,241,255,14,87,
241,255,17,71,235,255,14,87,241,255,0,81,240,255,0,81,240,255,0,81,240,255,93,
70,172,255,205,50,55,255,254,39,0,255,254,39,0,255,255,79,2,255,255,79,2,255,
163,88,99,255,0,81,240,255,114,107,154,255,251,125,0,255,254,147,0,255,125,125,
134,255,0,81,240,255,14,87,241,255,57,100,210,255,254,219,0,255,254,219,0,255,
57,100,210,255,0,81,240,255,33,101,181,255,254,253,0,255,254,253,0,255,125,164,
136,255,14,87,241,255,171,194,92,255,254,253,0,255,254,253,0,255,254,253,0,255,
254,253,0,255,181,205,81,255,0,81,240,255,14,87,241,255,139,141,157,255,226,250,
25,255,208,252,20,255,208,252,20,255,172,249,32,255,150,202,97,255,53,80,211,
255,14,87,241,255,48,92,213,255,135,196,116,255,132,239,39,255,100,218,49,255,
112,209,70,255,89,131,175,255,48,189,72,255,65,199,62,255,89,131,175,255,0,81,
240,255,33,101,181,255,48,189,72,255,29,179,85,255,53,80,211,255,0,81,240,255,
14,87,241,255,0,81,240,255,0,81,240,255,0,81,240,255,0,81,240,255,0,81,240,255,
0,81,240,255,17,71,235,255,2,66,183,255,29,30,37,255,34,34,42,255,34,34,42,
255,34,34,42,255,38,42,54,255,38,36,40,255,85,86,118,255,117,118,163,255,117,
118,163,255,129,126,165,255,129,126,165,255,138,134,175,255,138,134,175,255,136,
136,183,255,138,135,189,255,143,140,194,255,136,136,183,255,142,141,188,255,142,
141,188,255,143,140,194,255,143,140,194,255,138,135,189,255,143,140,194,255,142,
141,188,255,136,136,183,255,132,132,179,255,134,131,185,255,138,135,189,255,153,
152,200,255,166,153,185,255,208,208,221,255,248,245,250,255,238,238,251,255,220,
221,234,255,220,221,234,255,229,230,244,255,238,238,251,255,166,166,201,255,140,
132,180,255,138,135,189,255,136,136,183,255,142,141,188,255,148,148,195,255,153,
152,200,255,142,141,188,255,157,158,178,255,183,187,202,255,1,6,9,0,1,6,9,0,1,6,
9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,
116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,
0,168,170,187,255,155,151,186,255,155,147,196,255,149,146,200,255,142,141,188,
255,142,141,188,255,138,135,189,255,143,140,194,255,148,148,195,255,159,158,206,
255,166,165,214,255,169,165,207,255,169,165,207,255,178,173,216,255,173,165,202,
255,166,165,214,255,172,168,198,255,169,170,180,255,158,159,169,255,158,159,169,
255,158,159,169,255,158,159,169,255,168,170,187,255,139,141,157,255,128,121,147,
255,154,151,205,255,165,156,206,255,169,165,207,255,169,165,207,255,169,165,207,
255,169,165,207,255,162,158,200,255,154,150,192,255,134,131,185,255,128,125,178,
255,131,124,172,255,131,124,172,255,119,117,169,255,123,115,163,255,71,72,102,
255,38,42,54,255,35,39,51,255,34,34,42,255,35,39,51,255,34,34,42,255,24,25,32,
255,18,16,20,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,
241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,
14,87,241,255,125,67,142,255,254,39,0,255,254,39,0,255,228,61,29,255,163,88,99,
255,146,90,116,255,163,88,99,255,112,86,153,255,0,81,240,255,201,104,62,255,254,
147,0,255,254,147,0,255,169,137,95,255,0,81,240,255,14,87,241,255,139,147,125,
255,254,219,0,255,254,219,0,255,89,131,175,255,14,87,241,255,171,194,92,255,254,
253,0,255,254,253,0,255,134,170,123,255,0,81,240,255,215,231,44,255,254,253,0,
255,215,231,44,255,205,221,55,255,205,221,55,255,139,147,125,255,14,87,241,255,
14,87,241,255,134,170,123,255,208,252,20,255,208,252,20,255,177,228,66,255,172,
249,32,255,172,249,32,255,134,170,123,255,23,101,231,255,148,225,63,255,132,239,
39,255,112,209,70,255,65,176,113,255,112,209,70,255,100,218,49,255,99,174,139,
255,65,199,62,255,65,176,113,255,27,88,228,255,29,179,85,255,48,189,72,255,33,
101,181,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,
255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,2,66,
183,255,34,34,42,255,35,39,51,255,38,42,54,255,30,34,46,255,38,42,54,255,38,42,
54,255,85,86,118,255,117,118,163,255,119,117,169,255,128,128,175,255,129,126,
165,255,136,136,183,255,132,132,179,255,136,136,183,255,136,136,183,255,138,135,
189,255,138,135,189,255,143,140,194,255,142,141,188,255,142,141,188,255,143,140,
194,255,140,132,180,255,138,135,189,255,132,132,179,255,132,132,179,255,140,132,
180,255,132,132,179,255,134,131,185,255,128,128,175,255,175,177,194,255,229,230,
244,255,191,194,208,255,184,185,195,255,184,185,195,255,184,185,195,255,184,185,
195,255,208,208,221,255,229,230,244,255,145,142,177,255,140,132,180,255,136,136,
183,255,142,141,188,255,155,147,196,255,155,147,196,255,155,147,196,255,160,158,
188,255,177,177,187,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,183,187,202,0,175,177,194,255,154,150,192,255,153,
152,200,255,149,146,200,255,155,147,196,255,136,136,183,255,138,135,189,255,142,
141,188,255,149,146,200,255,165,156,206,255,162,158,200,255,178,173,216,255,169,
165,207,255,173,165,202,255,178,174,211,255,172,168,198,255,139,141,157,255,175,
177,194,255,169,170,180,255,175,177,194,255,183,187,202,255,169,170,180,255,183,
187,202,255,139,141,157,255,111,110,143,255,154,150,192,255,166,157,194,255,162,
158,200,255,169,165,207,255,169,165,207,255,162,158,200,255,153,152,200,255,142,
141,188,255,132,132,179,255,124,124,170,255,128,125,178,255,117,118,163,255,123,
115,163,255,109,109,154,255,71,72,102,255,50,51,59,255,34,34,42,255,30,34,46,
255,30,34,46,255,35,39,51,255,23,22,25,255,23,22,25,255,14,87,241,255,14,87,241,
255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,
241,255,14,87,241,255,14,87,241,255,53,80,211,255,254,39,0,255,254,39,0,255,125,
67,142,255,14,87,241,255,0,81,240,255,0,81,240,255,16,99,248,255,14,87,241,255,
119,117,169,255,251,125,0,255,254,147,0,255,254,147,0,255,211,144,48,255,14,87,
241,255,14,87,241,255,217,180,43,255,253,201,0,255,254,219,0,255,134,170,123,
255,57,100,210,255,254,253,0,255,254,253,0,255,254,253,0,255,160,181,104,255,14,
87,241,255,254,253,0,255,254,253,0,255,16,99,248,255,14,87,241,255,14,87,241,
255,14,87,241,255,14,87,241,255,16,99,248,255,170,208,88,255,208,252,20,255,89,
131,175,255,14,87,241,255,99,174,139,255,172,249,32,255,121,186,122,255,121,186,
122,255,100,218,49,255,112,197,96,255,14,87,241,255,14,87,241,255,74,149,178,
255,65,199,62,255,65,176,113,255,48,189,72,255,65,199,62,255,57,168,129,255,48,
189,72,255,57,168,129,255,16,99,248,255,14,87,241,255,14,87,241,255,14,87,241,
255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,
241,255,14,87,241,255,2,66,183,255,29,30,37,255,34,34,42,255,30,34,46,255,35,39,
51,255,30,34,46,255,50,51,59,255,71,72,102,255,109,109,154,255,129,126,165,255,
128,128,175,255,128,128,175,255,128,128,175,255,132,132,179,255,138,135,189,255,
148,140,188,255,153,152,200,255,148,148,195,255,142,141,188,255,143,140,194,255,
143,140,194,255,136,136,183,255,136,136,183,255,136,136,183,255,136,136,183,255,
138,135,189,255,132,132,179,255,128,125,178,255,128,125,178,255,129,126,165,255,
220,221,234,255,191,194,208,255,184,185,195,255,177,177,187,255,169,170,180,255,
177,177,187,255,184,185,195,255,177,177,187,255,191,194,208,255,186,190,212,255,
134,131,185,255,140,132,180,255,148,140,188,255,142,141,188,255,148,148,195,255,
148,140,188,255,157,158,178,255,168,170,187,255,1,6,9,0,1,6,9,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,
148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,0,175,177,194,
255,155,151,186,255,155,147,196,255,142,141,188,255,142,141,188,255,136,136,183,
255,134,131,185,255,142,141,188,255,153,152,200,255,128,121,147,255,141,141,167,
255,141,141,167,255,157,158,178,255,141,141,167,255,141,141,167,255,157,158,178,
255,157,158,178,255,175,177,194,255,158,159,169,255,169,170,180,255,169,170,180,
255,169,170,180,255,169,170,180,255,169,170,180,255,141,141,167,255,122,124,142,
255,141,141,167,255,141,141,167,255,141,141,167,255,157,158,178,255,110,108,129,
255,110,108,129,255,142,141,188,255,134,131,185,255,123,115,163,255,128,125,178,
255,117,118,163,255,123,115,163,255,112,108,148,255,64,65,86,255,38,42,54,255,
34,34,42,255,34,34,42,255,35,39,51,255,34,34,42,255,29,30,37,255,1,6,9,255,53,
80,211,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,255,14,87,241,
255,16,99,248,255,14,87,241,255,14,87,241,255,14,87,241,255,155,56,110,255,254,
39,0,255,155,56,110,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,248,
255,16,99,248,255,14,87,241,255,201,104,62,255,251,125,0,255,128,121,147,255,
254,147,0,255,255,170,0,255,16,99,248,255,40,128,223,255,253,201,0,255,254,219,
0,255,254,219,0,255,171,194,92,255,134,170,123,255,254,253,0,255,215,231,44,
255,254,253,0,255,160,181,104,255,28,125,228,255,254,253,0,255,254,253,0,255,
171,194,92,255,171,194,92,255,134,170,123,255,16,99,248,255,14,87,241,255,14,87,
241,255,215,231,44,255,208,252,20,255,135,196,116,255,121,186,122,255,172,249,
32,255,172,249,32,255,47,133,202,255,172,249,32,255,132,239,39,255,12,118,235,
255,14,87,241,255,27,88,228,255,23,101,231,255,100,218,49,255,48,189,72,255,74,
149,178,255,65,199,62,255,65,199,62,255,29,179,85,255,23,101,231,255,14,87,241,
255,14,87,241,255,27,88,228,255,14,87,241,255,16,99,248,255,14,87,241,255,27,88,
228,255,14,87,241,255,16,99,248,255,14,87,241,255,16,99,248,255,18,73,180,255,
30,34,46,255,35,39,51,255,30,34,46,255,34,34,42,255,35,39,51,255,38,36,40,255,
71,72,102,255,117,118,163,255,117,118,163,255,124,124,170,255,129,126,165,255,
128,128,175,255,128,128,175,255,143,140,194,255,178,173,216,255,199,194,238,255,
173,165,215,255,149,146,200,255,143,140,194,255,143,140,194,255,143,140,194,255,
132,132,179,255,140,132,180,255,132,132,179,255,134,131,185,255,132,132,179,255,
128,128,175,255,128,125,178,255,128,121,147,255,191,194,208,255,184,185,195,255,
177,177,187,255,169,170,180,255,158,159,169,255,169,170,180,255,175,177,194,255,
175,177,194,255,177,177,187,255,183,187,202,255,128,128,175,255,134,131,185,255,
138,135,189,255,138,135,189,255,143,140,194,255,143,140,194,255,153,139,168,255,
168,170,187,255,184,185,195,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,183,187,202,0,177,177,187,255,160,158,188,255,148,
148,195,255,149,146,200,255,149,146,200,255,138,135,189,255,138,135,189,255,143,
140,194,255,154,150,192,255,141,141,167,255,229,230,244,255,229,230,244,255,229,
230,244,255,238,238,251,255,229,230,244,255,229,230,244,255,229,230,244,255,175,
177,194,255,169,170,180,255,168,170,187,255,158,159,169,255,168,170,187,255,183,
187,202,255,220,221,234,255,238,238,251,255,238,238,251,255,248,245,250,255,248,
245,250,255,248,245,250,255,238,238,251,255,175,177,194,255,92,92,112,255,134,
131,185,255,128,128,175,255,128,125,178,255,123,115,163,255,123,115,163,255,119,
117,156,255,114,107,154,255,64,65,86,255,38,42,54,255,35,39,51,255,30,34,46,255,
34,34,42,255,34,34,42,255,38,36,40,255,23,22,25,255,16,99,248,255,23,112,254,
255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,
248,255,16,99,248,255,16,99,248,255,205,50,55,255,254,39,0,255,48,92,213,255,16,
99,248,255,125,67,142,255,163,88,99,255,163,88,99,255,146,90,116,255,51,116,
221,255,251,125,0,255,251,125,0,255,169,137,95,255,254,147,0,255,255,170,0,255,
58,91,185,255,139,147,125,255,253,201,0,255,184,160,76,255,254,219,0,255,227,
217,27,255,254,253,0,255,254,253,0,255,125,164,136,255,254,253,0,255,181,205,81,
255,74,149,178,255,254,253,0,255,254,253,0,255,254,253,0,255,254,253,0,255,171,
194,92,255,16,99,248,255,16,99,248,255,0,119,255,255,226,250,25,255,226,250,25,
255,208,252,20,255,208,252,20,255,172,249,32,255,148,225,63,255,40,128,223,255,
172,249,32,255,112,209,70,255,16,99,248,255,16,99,248,255,16,99,248,255,12,118,
235,255,100,218,49,255,65,199,62,255,23,101,231,255,65,199,62,255,65,199,62,255,
47,133,202,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,
248,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,248,255,16,99,248,255,
27,88,228,255,16,99,248,255,18,73,180,255,34,34,42,255,34,34,42,255,34,34,42,
255,35,39,51,255,35,39,51,255,46,49,63,255,64,65,86,255,110,109,161,255,124,124,
170,255,124,124,170,255,128,128,175,255,128,128,175,255,134,131,185,255,136,136,
183,255,169,165,207,255,206,200,229,255,200,201,225,255,200,201,225,255,200,201,
225,255,166,166,201,255,148,140,188,255,138,135,189,255,128,128,175,255,140,132,
180,255,132,132,179,255,131,124,172,255,128,125,178,255,134,131,185,255,139,141,
157,255,177,177,187,255,183,187,202,255,169,170,180,255,168,170,187,255,175,177,
194,255,169,170,180,255,169,170,180,255,169,170,180,255,175,177,194,255,184,185,
195,255,128,128,175,255,124,124,170,255,128,128,175,255,140,132,180,255,140,132,
180,255,148,148,195,255,145,142,177,255,168,170,187,255,191,194,208,255,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,
202,0,175,177,194,255,160,158,188,255,153,152,200,255,142,141,188,255,148,148,
195,255,138,135,189,255,140,132,180,255,143,140,194,255,148,148,195,255,157,158,
178,255,220,221,234,255,208,208,221,255,208,208,221,255,208,208,221,255,208,208,
221,255,208,208,221,255,208,208,221,255,169,170,180,255,158,159,169,255,139,141,
157,255,139,141,157,255,158,159,169,255,175,177,194,255,200,201,225,255,220,221,
234,255,208,208,221,255,208,208,221,255,220,221,234,255,208,208,221,255,220,221,
234,255,168,170,187,255,79,80,102,255,132,132,179,255,124,124,170,255,124,124,
170,255,119,117,169,255,123,115,163,255,117,118,163,255,114,107,154,255,52,55,
78,255,34,34,42,255,35,39,51,255,30,34,46,255,30,34,46,255,34,34,42,255,29,30,
37,255,18,16,20,255,23,101,231,255,16,99,248,255,23,112,254,255,16,99,248,255,
23,112,254,255,16,99,248,255,23,112,254,255,23,112,254,255,16,99,248,255,16,99,
248,255,205,50,55,255,254,39,0,255,48,92,213,255,23,112,254,255,228,61,29,255,
254,39,0,255,255,79,2,255,201,104,62,255,163,88,99,255,251,125,0,255,251,125,0,
255,254,147,0,255,254,147,0,255,255,170,0,255,141,141,167,255,217,180,43,255,
253,201,0,255,47,133,202,255,227,217,27,255,254,253,0,255,254,253,0,255,171,194,
92,255,89,131,175,255,254,253,0,255,181,205,81,255,134,170,123,255,254,253,0,
255,170,208,88,255,74,149,178,255,74,149,178,255,40,128,223,255,23,112,254,255,
16,99,248,255,47,133,202,255,226,250,25,255,177,228,66,255,74,149,178,255,74,
149,178,255,148,225,63,255,172,249,32,255,121,186,122,255,172,249,32,255,112,
209,70,255,23,112,254,255,16,99,248,255,23,112,254,255,51,157,168,255,65,199,62,
255,65,176,113,255,12,118,235,255,65,199,62,255,29,179,85,255,27,88,228,255,16,
99,248,255,23,112,254,255,16,99,248,255,23,112,254,255,16,99,248,255,23,112,
254,255,16,99,248,255,23,112,254,255,16,99,248,255,23,112,254,255,16,99,248,255,
16,99,248,255,18,73,180,255,29,30,37,255,35,39,51,255,35,39,51,255,30,34,46,
255,35,39,51,255,38,42,54,255,64,65,86,255,117,118,163,255,117,118,163,255,124,
124,170,255,124,124,170,255,128,128,175,255,134,131,185,255,142,141,188,255,186,
190,212,255,238,238,251,255,248,245,250,255,248,245,250,255,229,230,244,255,238,
238,251,255,200,201,225,255,153,152,200,255,134,131,185,255,131,124,172,255,128,
128,175,255,124,124,170,255,117,118,163,255,119,117,169,255,128,121,147,255,175,
177,194,255,169,170,180,255,169,170,180,255,158,159,169,255,183,187,202,255,169,
170,180,255,169,170,180,255,169,170,180,255,169,170,180,255,169,170,180,255,117,
118,163,255,131,124,172,255,145,141,183,255,142,141,188,255,138,135,189,255,149,
146,200,255,138,134,175,255,157,158,178,255,184,185,195,255,1,6,9,0,1,6,9,0,1,6,
9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,0,183,187,
202,255,157,158,178,255,155,147,196,255,149,146,200,255,148,140,188,255,136,136,
183,255,138,135,189,255,136,136,183,255,149,146,200,255,157,158,178,255,184,185,
195,255,175,177,194,255,169,170,180,255,158,159,169,255,169,170,180,255,175,177,
194,255,169,170,180,255,169,170,180,255,142,141,151,255,125,125,134,255,125,125,
134,255,142,141,151,255,183,187,202,255,184,185,195,255,183,187,202,255,175,177,
194,255,169,170,180,255,169,170,180,255,184,185,195,255,177,177,187,255,168,170,
187,255,81,81,88,255,131,124,172,255,124,124,170,255,119,117,169,255,123,115,
163,255,109,109,154,255,109,109,154,255,117,118,163,255,46,49,63,255,46,49,63,
255,34,34,42,255,34,34,42,255,30,34,46,255,34,34,42,255,38,36,40,255,23,22,25,
255,23,101,231,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,
23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,125,
67,142,255,254,39,0,255,205,50,55,255,23,101,231,255,0,119,255,255,146,90,116,
255,255,79,2,255,173,113,88,255,251,106,5,255,251,106,5,255,51,116,221,255,51,
116,221,255,169,137,95,255,255,170,0,255,184,160,76,255,255,170,0,255,253,201,0,
255,23,112,254,255,160,181,104,255,254,219,0,255,254,253,0,255,47,133,202,255,
47,133,202,255,254,253,0,255,177,228,66,255,170,208,88,255,254,253,0,255,125,
164,136,255,40,128,223,255,51,116,221,255,8,126,237,255,23,112,254,255,23,112,
254,255,100,166,169,255,226,250,25,255,150,202,97,255,23,112,254,255,0,119,255,
255,135,196,116,255,172,249,32,255,99,174,139,255,112,209,70,255,172,249,32,255,
32,144,189,255,0,119,255,255,40,128,223,255,112,209,70,255,100,218,49,255,8,
137,197,255,47,133,202,255,65,199,62,255,65,176,113,255,23,112,254,255,23,112,
254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,
255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,
23,112,254,255,58,91,185,255,34,34,42,255,30,34,46,255,34,34,42,255,35,39,51,
255,34,34,42,255,38,42,54,255,64,65,86,255,114,107,154,255,117,118,163,255,124,
124,170,255,124,124,170,255,124,124,170,255,128,128,175,255,186,190,212,255,238,
238,251,255,220,221,234,255,191,194,208,255,191,194,208,255,184,185,195,255,208,
208,221,255,220,221,234,255,200,201,225,255,132,132,179,255,128,125,178,255,131,
124,172,255,123,115,163,255,123,115,163,255,123,115,163,255,111,110,143,255,158,
159,169,255,168,170,187,255,169,170,180,255,158,159,169,255,158,159,169,255,158,
159,169,255,169,170,180,255,168,170,187,255,169,170,180,255,157,158,178,255,123,
115,163,255,138,134,175,255,145,142,177,255,142,141,188,255,143,140,194,255,148,
148,195,255,136,136,183,255,181,158,174,255,175,177,194,255,1,6,9,0,1,6,9,0,1,6,
9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,0,175,177,
194,255,174,166,191,255,154,150,192,255,149,146,200,255,148,140,188,255,132,132,
179,255,134,131,185,255,132,132,179,255,142,141,188,255,141,141,167,255,184,185,
195,255,168,170,187,255,169,170,180,255,168,170,187,255,169,170,180,255,183,187,
202,255,175,177,194,255,169,170,180,255,158,159,169,255,157,158,178,255,168,170,
187,255,168,170,187,255,183,187,202,255,183,187,202,255,184,185,195,255,183,187,
202,255,169,170,180,255,175,177,194,255,169,170,180,255,177,177,187,255,167,164,
169,255,79,80,102,255,128,125,178,255,124,124,170,255,117,118,163,255,119,117,
169,255,123,115,163,255,112,108,148,255,123,115,163,255,46,49,63,255,35,39,51,
255,30,34,46,255,34,34,42,255,30,34,46,255,34,34,42,255,24,25,32,255,18,16,20,
255,23,101,231,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,
23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,
101,231,255,205,50,55,255,254,39,0,255,254,39,0,255,228,61,29,255,254,39,0,255,
255,79,2,255,251,106,5,255,251,106,5,255,143,103,124,255,0,119,255,255,23,112,
254,255,122,124,142,255,255,170,0,255,255,170,0,255,253,201,0,255,134,170,123,
255,23,112,254,255,125,164,136,255,254,253,0,255,205,221,55,255,23,112,254,255,
22,144,225,255,254,253,0,255,205,221,55,255,205,221,55,255,254,253,0,255,254,
253,0,255,254,253,0,255,254,253,0,255,160,181,104,255,0,119,255,255,0,119,255,
255,121,186,122,255,226,250,25,255,226,250,25,255,208,252,20,255,172,249,32,255,
172,249,32,255,148,225,63,255,0,146,255,255,32,144,189,255,132,239,39,255,132,
239,39,255,112,209,70,255,100,218,49,255,100,218,49,255,57,168,129,255,23,112,
254,255,51,157,168,255,48,189,72,255,51,157,168,255,28,125,228,255,32,144,189,
255,25,123,254,255,23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,
23,112,254,255,23,112,254,255,23,112,254,255,23,112,254,255,0,119,255,255,23,
112,254,255,58,91,185,255,24,25,32,255,35,39,51,255,30,34,46,255,35,39,51,255,
34,34,42,255,38,42,54,255,64,65,86,255,112,108,148,255,119,117,156,255,119,117,
156,255,124,124,170,255,131,124,172,255,145,142,177,255,220,221,234,255,208,208,
221,255,184,185,195,255,177,177,187,255,184,185,195,255,184,185,195,255,184,185,
195,255,184,185,195,255,208,208,221,255,157,158,178,255,119,117,169,255,124,124,
170,255,124,124,170,255,124,124,170,255,109,109,154,255,117,118,163,255,122,124,
142,255,158,159,169,255,158,159,169,255,175,177,194,255,186,190,212,255,158,159,
169,255,169,170,180,255,158,159,169,255,158,159,169,255,119,117,156,255,117,118,
163,255,138,134,175,255,145,142,177,255,145,141,183,255,138,135,189,255,153,152,
200,255,136,136,183,255,157,158,178,255,177,177,187,255,1,6,9,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,
148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,0,183,187,202,
255,160,158,188,255,153,152,200,255,149,146,200,255,148,148,195,255,134,131,185,
255,128,125,178,255,138,135,189,255,153,152,200,255,141,141,167,255,184,185,195,
255,183,187,202,255,169,170,180,255,175,177,194,255,169,170,180,255,169,170,180,
255,169,170,180,255,183,187,202,255,191,194,208,255,191,194,208,255,191,194,208,
255,208,208,221,255,183,187,202,255,184,185,195,255,169,170,180,255,177,177,187,
255,175,177,194,255,184,185,195,255,183,187,202,255,183,187,202,255,168,170,187,
255,92,92,112,255,117,118,163,255,117,118,163,255,119,117,169,255,117,118,163,
255,119,117,156,255,112,108,148,255,112,108,148,255,46,49,63,255,35,39,51,255,
34,34,42,255,30,34,46,255,34,34,42,255,30,34,46,255,38,36,40,255,23,22,25,255,
57,100,210,255,0,119,255,255,25,123,254,255,0,119,255,255,0,119,255,255,25,123,
254,255,25,123,254,255,0,119,255,255,0,119,255,255,0,119,255,255,0,119,255,255,
25,123,254,255,130,81,139,255,205,50,55,255,228,61,29,255,205,50,55,255,146,90,
116,255,201,104,62,255,201,104,62,255,4,133,255,255,23,112,254,255,0,119,255,
255,22,144,225,255,211,144,48,255,217,180,43,255,217,180,43,255,47,133,202,255,
23,112,254,255,22,144,225,255,205,221,55,255,74,149,178,255,25,123,254,255,40,
128,223,255,215,231,44,255,170,208,88,255,205,221,55,255,215,231,44,255,215,231,
44,255,215,231,44,255,215,231,44,255,100,166,169,255,0,119,255,255,23,112,254,
255,135,196,116,255,177,228,66,255,177,228,66,255,177,228,66,255,177,228,66,255,
135,196,116,255,40,128,223,255,25,123,254,255,0,119,255,255,74,149,178,255,112,
209,70,255,100,218,49,255,112,209,70,255,51,157,168,255,25,123,254,255,0,119,
255,255,51,157,168,255,29,179,85,255,32,144,189,255,40,128,223,255,74,149,178,
255,28,125,228,255,0,119,255,255,25,123,254,255,25,123,254,255,0,119,255,255,25,
123,254,255,0,119,255,255,0,119,255,255,25,123,254,255,23,101,231,255,0,119,255,
255,58,91,185,255,28,32,43,255,30,34,46,255,34,34,42,255,30,34,46,255,35,39,51,
255,34,34,42,255,46,49,63,255,123,115,163,255,117,118,163,255,123,115,163,255,
119,117,156,255,119,117,169,255,160,158,188,255,208,208,221,255,184,185,195,255,
168,170,187,255,158,159,169,255,158,159,169,255,169,170,180,255,169,170,180,255,
177,177,187,255,177,177,187,255,175,177,194,255,119,117,156,255,119,117,169,255,
123,115,163,255,119,117,156,255,117,118,163,255,114,107,154,255,110,109,161,255,
110,108,129,255,158,159,169,255,169,170,180,255,158,159,169,255,183,187,202,255,
157,158,178,255,142,141,151,255,111,110,143,255,109,109,154,255,129,126,165,255,
145,142,177,255,145,142,177,255,154,150,192,255,142,141,188,255,148,148,195,255,
142,141,188,255,155,151,186,255,168,170,187,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,
39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,183,187,202,0,175,177,194,255,160,
158,188,255,153,152,200,255,149,146,200,255,145,141,183,255,148,140,188,255,128,
125,178,255,128,128,175,255,149,146,200,255,141,141,167,255,175,177,194,255,169,
170,180,255,175,177,194,255,183,187,202,255,183,187,202,255,169,170,180,255,169,
170,180,255,183,187,202,255,191,194,208,255,229,230,244,255,238,238,251,255,220,
221,234,255,183,187,202,255,169,170,180,255,169,170,180,255,183,187,202,255,183,
187,202,255,183,187,202,255,177,177,187,255,177,177,187,255,157,158,178,255,92,
92,112,255,123,115,163,255,129,126,165,255,123,115,163,255,110,109,161,255,119,
117,169,255,109,109,154,255,114,107,154,255,38,42,54,255,35,39,51,255,34,34,42,
255,30,34,46,255,34,34,42,255,28,32,43,255,29,30,37,255,18,16,20,255,12,118,235,
255,25,123,254,255,25,123,254,255,25,123,254,255,25,123,254,255,25,123,254,255,
25,123,254,255,25,123,254,255,0,127,255,255,0,127,255,255,0,127,255,255,0,127,
255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,127,255,255,0,
127,255,255,25,123,254,255,0,127,255,255,25,123,254,255,25,123,254,255,0,127,
255,255,25,123,254,255,0,119,255,255,25,123,254,255,0,127,255,255,0,127,255,255,
25,123,254,255,0,119,255,255,25,123,254,255,0,127,255,255,0,127,255,255,0,127,
255,255,0,127,255,255,0,127,255,255,25,123,254,255,0,127,255,255,0,127,255,255,
25,123,254,255,0,127,255,255,0,127,255,255,0,127,255,255,0,119,255,255,0,119,
255,255,25,123,254,255,0,127,255,255,0,127,255,255,4,133,255,255,25,123,254,255,
0,127,255,255,0,127,255,255,25,123,254,255,25,123,254,255,0,127,255,255,0,127,
255,255,0,127,255,255,0,127,255,255,0,127,255,255,0,127,255,255,0,127,255,255,0,
127,255,255,0,127,255,255,25,123,254,255,0,127,255,255,25,123,254,255,25,123,
254,255,25,123,254,255,0,127,255,255,25,123,254,255,0,127,255,255,25,123,254,
255,0,127,255,255,0,127,255,255,0,127,255,255,33,101,181,255,28,32,43,255,30,34,
46,255,35,39,51,255,34,34,42,255,35,39,51,255,38,42,54,255,46,49,63,255,114,
107,154,255,119,117,156,255,119,117,156,255,119,117,156,255,123,115,163,255,160,
158,188,255,184,185,195,255,184,185,195,255,175,177,194,255,183,187,202,255,169,
170,180,255,183,187,202,255,169,170,180,255,169,170,180,255,183,187,202,255,175,
177,194,255,119,117,156,255,123,115,163,255,123,115,163,255,123,115,163,255,119,
117,156,255,119,117,156,255,109,109,154,255,110,109,161,255,96,95,132,255,110,
108,129,255,110,110,118,255,110,110,118,255,110,108,129,255,111,110,143,255,119,
117,156,255,129,126,165,255,145,142,177,255,145,142,177,255,145,142,177,255,145,
141,183,255,148,140,188,255,148,148,195,255,145,141,183,255,157,158,178,255,168,
170,187,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,
112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,
108,148,0,183,187,202,0,175,177,194,255,160,158,188,255,154,150,192,255,155,147,
196,255,154,150,192,255,142,141,188,255,128,125,178,255,128,125,178,255,136,136,
183,255,129,126,165,255,139,141,157,255,125,125,134,255,125,125,134,255,110,110,
118,255,125,125,134,255,122,124,142,255,125,125,134,255,168,170,187,255,191,194,
208,255,191,194,208,255,191,194,208,255,183,187,202,255,169,170,180,255,139,141,
157,255,110,110,118,255,110,110,118,255,110,110,118,255,122,124,142,255,110,110,
118,255,122,124,142,255,92,92,112,255,111,110,143,255,123,115,163,255,123,115,
163,255,110,109,161,255,110,109,161,255,114,107,154,255,109,109,154,255,109,109,
154,255,38,42,54,255,34,34,42,255,30,34,46,255,34,34,42,255,30,34,46,255,30,34,
46,255,34,34,42,255,23,22,25,255,51,116,221,255,4,133,255,255,4,133,255,255,4,
133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,127,255,255,4,133,255,
255,4,133,255,255,0,127,255,255,4,133,255,255,0,127,255,255,0,127,255,255,0,127,
255,255,4,133,255,255,0,127,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,
133,255,255,4,133,255,255,0,127,255,255,4,133,255,255,0,127,255,255,4,133,255,
255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,127,
255,255,0,127,255,255,4,133,255,255,0,127,255,255,4,133,255,255,4,133,255,255,4,
133,255,255,0,127,255,255,4,133,255,255,4,133,255,255,0,127,255,255,4,133,255,
255,0,127,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,127,
255,255,4,133,255,255,0,127,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,
133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,
255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,
255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,127,255,255,4,133,255,255,4,
133,255,255,4,133,255,255,4,133,255,255,25,123,254,255,33,101,181,255,34,34,42,
255,34,34,42,255,30,34,46,255,30,34,46,255,35,39,51,255,34,34,42,255,46,49,63,
255,119,117,156,255,119,117,156,255,119,117,156,255,117,118,163,255,109,109,154,
255,157,158,178,255,184,185,195,255,168,170,187,255,169,170,180,255,168,170,187,
255,169,170,180,255,183,187,202,255,168,170,187,255,169,170,180,255,169,170,180,
255,169,170,180,255,117,118,163,255,109,109,154,255,117,118,163,255,119,117,156,
255,117,118,163,255,109,109,154,255,117,118,163,255,109,109,154,255,109,109,154,
255,109,109,154,255,109,109,154,255,109,109,154,255,110,109,161,255,109,109,154,
255,119,117,156,255,129,126,165,255,145,142,177,255,155,151,186,255,155,151,186,
255,154,150,192,255,143,140,194,255,149,146,200,255,142,141,188,255,141,141,167,
255,177,177,187,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,
6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,
9,0,112,108,148,0,183,187,202,0,175,177,194,255,166,157,194,255,154,151,205,
255,153,152,200,255,155,151,186,255,155,151,186,255,132,132,179,255,128,125,178,
255,128,128,175,255,136,136,183,255,132,132,179,255,124,124,170,255,117,118,163,
255,109,109,154,255,109,109,154,255,109,109,154,255,111,110,143,255,183,187,202,
255,183,187,202,255,191,194,208,255,191,194,208,255,191,194,208,255,184,185,195,
255,125,125,134,255,52,55,78,255,96,95,132,255,96,95,132,255,109,109,154,255,96,
95,132,255,112,108,148,255,114,107,154,255,117,118,163,255,110,109,161,255,117,
118,163,255,123,115,163,255,109,109,154,255,114,107,154,255,96,95,132,255,112,
108,148,255,35,39,51,255,35,39,51,255,30,34,46,255,34,34,42,255,34,34,42,255,29,
30,37,255,34,34,42,255,18,16,20,255,28,125,228,255,4,133,255,255,4,133,255,255,
4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,141,255,255,4,133,
255,255,4,133,255,255,4,133,255,255,0,141,255,255,4,133,255,255,0,141,255,255,4,
133,255,255,0,141,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,
255,4,133,255,255,0,141,255,255,4,133,255,255,0,141,255,255,4,133,255,255,0,141,
255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,141,255,255,4,
133,255,255,4,133,255,255,0,141,255,255,4,133,255,255,4,133,255,255,4,133,255,
255,0,141,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,141,
255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,141,255,255,4,
133,255,255,0,141,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,
255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,
255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,4,
133,255,255,4,133,255,255,4,133,255,255,4,133,255,255,0,141,255,255,4,133,255,
255,4,133,255,255,4,133,255,255,8,126,237,255,4,133,255,255,33,101,181,255,16,
18,27,255,34,34,42,255,30,34,46,255,34,34,42,255,30,34,46,255,35,39,51,255,38,
42,54,255,119,117,156,255,123,115,163,255,111,110,143,255,111,110,143,255,114,
107,154,255,129,126,165,255,178,176,180,255,169,170,180,255,169,170,180,255,175,
177,194,255,169,170,180,255,169,170,180,255,168,170,187,255,169,170,180,255,168,
170,187,255,139,141,157,255,114,107,154,255,109,109,154,255,123,115,163,255,123,
115,163,255,123,115,163,255,119,117,169,255,117,118,163,255,110,109,161,255,110,
109,161,255,109,109,154,255,109,109,154,255,109,109,154,255,109,109,154,255,117,
118,163,255,129,126,165,255,138,134,175,255,145,142,177,255,155,151,186,255,155,
151,186,255,155,151,186,255,148,140,188,255,154,151,205,255,155,147,196,255,141,
141,167,255,175,177,194,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,183,187,202,0,174,166,191,255,162,158,200,255,149,146,
200,255,155,147,196,255,154,150,192,255,154,150,192,255,148,140,188,255,128,125,
178,255,128,128,175,255,128,128,175,255,128,128,175,255,117,118,163,255,109,109,
154,255,109,109,154,255,109,109,154,255,96,95,132,255,111,110,143,255,183,187,
202,255,183,187,202,255,183,187,202,255,183,187,202,255,184,185,195,255,184,185,
195,255,139,141,157,255,52,55,78,255,96,95,132,255,96,95,132,255,96,95,132,255,
109,109,154,255,109,109,154,255,112,108,148,255,117,118,163,255,119,117,156,255,
109,109,154,255,110,109,161,255,109,109,154,255,110,109,161,255,110,109,161,255,
96,95,132,255,38,42,54,255,34,34,42,255,34,34,42,255,30,34,46,255,34,34,42,255,
30,34,46,255,24,25,32,255,23,22,25,255,40,128,223,255,0,141,255,255,0,141,255,
255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,
255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,
141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,146,255,
255,0,141,255,255,0,141,255,255,4,133,255,255,0,141,255,255,0,141,255,255,0,141,
255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,
141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,
255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,
255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,
141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,
255,0,141,255,255,0,141,255,255,0,141,255,255,0,146,255,255,0,141,255,255,0,141,
255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,146,255,255,0,141,255,255,0,
141,255,255,0,141,255,255,0,146,255,255,4,133,255,255,0,141,255,255,0,141,255,
255,0,141,255,255,0,141,255,255,0,141,255,255,8,126,237,255,33,101,181,255,34,
34,42,255,35,39,51,255,34,34,42,255,30,34,46,255,34,34,42,255,35,39,51,255,38,
42,54,255,111,110,143,255,119,117,156,255,119,117,156,255,119,117,156,255,119,
117,156,255,119,117,156,255,139,141,157,255,169,170,180,255,158,159,169,255,169,
170,180,255,158,159,169,255,175,177,194,255,169,170,180,255,158,159,169,255,158,
159,169,255,119,117,156,255,109,109,154,255,112,108,148,255,117,118,163,255,117,
118,163,255,119,117,169,255,117,118,163,255,123,115,163,255,117,118,163,255,117,
118,163,255,110,109,161,255,110,109,161,255,109,109,154,255,117,118,163,255,131,
124,172,255,129,126,165,255,145,142,177,255,155,151,186,255,155,151,186,255,166,
157,194,255,154,150,192,255,148,148,195,255,149,146,200,255,142,141,188,255,157,
158,178,255,169,170,180,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,177,177,187,255,157,158,178,255,162,158,200,255,154,
151,205,255,153,152,200,255,166,157,194,255,155,151,186,255,154,150,192,255,134,
131,185,255,134,131,185,255,132,132,179,255,140,132,180,255,128,128,175,255,129,
126,165,255,119,117,156,255,117,118,163,255,110,109,161,255,111,110,143,255,183,
187,202,255,183,187,202,255,175,177,194,255,169,170,180,255,175,177,194,255,184,
185,195,255,142,141,151,255,71,72,102,255,96,95,132,255,109,109,154,255,112,108,
148,255,112,108,148,255,117,118,163,255,119,117,156,255,117,118,163,255,123,115,
163,255,123,115,163,255,109,109,154,255,112,108,148,255,114,107,154,255,110,109,
161,255,96,95,132,255,30,34,46,255,35,39,51,255,34,34,42,255,30,34,46,255,30,34,
46,255,30,34,46,255,29,30,37,255,18,16,20,255,40,128,223,255,0,146,255,255,0,
146,255,255,0,146,255,255,0,146,255,255,0,146,255,255,0,146,255,255,0,146,255,
255,0,141,255,255,0,146,255,255,0,141,255,255,0,146,255,255,0,141,255,255,0,146,
255,255,0,146,255,255,0,141,255,255,0,146,255,255,0,146,255,255,0,141,255,255,0,
146,255,255,0,146,255,255,0,146,255,255,0,141,255,255,0,141,255,255,0,146,255,
255,0,141,255,255,0,141,255,255,20,150,252,255,0,141,255,255,0,141,255,255,0,
146,255,255,0,146,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,146,255,
255,0,141,255,255,0,146,255,255,0,146,255,255,0,146,255,255,0,146,255,255,0,141,
255,255,0,146,255,255,0,141,255,255,0,146,255,255,0,141,255,255,0,141,255,255,0,
141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,255,0,141,255,
255,0,146,255,255,0,146,255,255,0,141,255,255,0,146,255,255,0,146,255,255,0,146,
255,255,0,146,255,255,0,146,255,255,0,146,255,255,0,141,255,255,0,146,255,255,0,
146,255,255,0,146,255,255,0,141,255,255,0,146,255,255,0,146,255,255,0,141,255,
255,0,146,255,255,0,141,255,255,0,146,255,255,0,146,255,255,0,146,255,255,33,
101,181,255,23,22,25,255,30,34,46,255,35,39,51,255,35,39,51,255,34,34,42,255,35,
39,51,255,35,39,51,255,111,110,143,255,112,108,148,255,112,108,148,255,119,117,
156,255,112,108,148,255,109,109,154,255,119,117,156,255,139,141,157,255,169,170,
180,255,183,187,202,255,183,187,202,255,169,170,180,255,157,158,178,255,158,159,
169,255,122,124,142,255,112,108,148,255,114,107,154,255,114,107,154,255,123,115,
163,255,117,118,163,255,119,117,156,255,117,118,163,255,117,118,163,255,117,118,
163,255,119,117,156,255,117,118,163,255,119,117,169,255,119,117,169,255,124,124,
170,255,132,132,179,255,138,134,175,255,145,142,177,255,155,151,186,255,166,157,
194,255,166,157,194,255,166,157,194,255,148,148,195,255,154,151,205,255,149,146,
200,255,141,141,167,255,168,170,187,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,
6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,
116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,194,255,160,158,188,255,154,150,
192,255,154,151,205,255,153,152,200,255,154,150,192,255,166,157,194,255,155,151,
186,255,136,136,183,255,128,125,178,255,128,128,175,255,128,128,175,255,128,128,
175,255,129,126,165,255,129,126,165,255,129,126,165,255,124,124,170,255,117,118,
163,255,186,190,212,255,184,185,195,255,184,185,195,255,183,187,202,255,191,194,
208,255,191,194,208,255,142,141,151,255,71,72,102,255,114,107,154,255,112,108,
148,255,119,117,156,255,129,126,165,255,119,117,156,255,129,126,165,255,119,117,
156,255,119,117,169,255,110,109,161,255,109,109,154,255,117,118,163,255,114,107,
154,255,114,107,154,255,96,95,132,255,46,49,63,255,30,34,46,255,30,34,46,255,34,
34,42,255,34,34,42,255,34,34,42,255,29,30,37,255,23,22,25,255,40,128,223,255,
20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,0,
146,255,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,
252,255,20,150,252,255,0,146,255,255,20,150,252,255,20,150,252,255,20,150,252,
255,20,150,252,255,20,150,252,255,20,150,252,255,0,146,255,255,20,150,252,255,0,
157,255,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,
252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,
255,20,150,252,255,0,157,255,255,20,150,252,255,20,150,252,255,20,150,252,255,
20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,0,
157,255,255,20,150,252,255,20,150,252,255,0,157,255,255,20,150,252,255,20,150,
252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,0,146,255,
255,0,146,255,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,
20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,
150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,
252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,255,20,150,252,
255,0,111,164,255,29,30,37,255,34,34,42,255,29,30,37,255,28,32,43,255,30,34,46,
255,30,34,46,255,35,39,51,255,109,109,154,255,119,117,156,255,119,117,156,255,
112,108,148,255,111,110,143,255,110,109,161,255,111,110,143,255,111,110,143,255,
122,124,142,255,125,125,134,255,142,141,151,255,125,125,134,255,125,125,134,255,
92,92,112,255,111,110,143,255,109,109,154,255,109,109,154,255,109,109,154,255,
109,109,154,255,119,117,156,255,123,115,163,255,119,117,156,255,123,115,163,255,
129,126,165,255,124,124,170,255,131,124,172,255,123,115,163,255,129,126,165,255,
131,124,172,255,140,132,180,255,138,134,175,255,154,150,192,255,155,151,186,255,
160,160,195,255,160,160,195,255,154,150,192,255,153,152,200,255,143,140,194,255,
154,150,192,255,155,151,186,255,169,170,180,255,1,6,9,0,1,6,9,0,1,6,9,0,132,239,
39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,194,255,160,158,188,255,159,
158,206,255,165,156,206,255,162,158,200,255,162,158,200,255,155,151,186,255,166,
157,194,255,145,141,183,255,134,131,185,255,128,125,178,255,140,132,180,255,134,
131,185,255,132,132,179,255,128,128,175,255,138,134,175,255,129,126,165,255,129,
126,165,255,191,194,208,255,183,187,202,255,183,187,202,255,183,187,202,255,191,
194,208,255,191,194,208,255,158,159,169,255,64,65,86,255,109,109,154,255,119,
117,156,255,129,126,165,255,129,126,165,255,124,124,170,255,131,124,172,255,117,
118,163,255,117,118,163,255,117,118,163,255,119,117,156,255,117,118,163,255,109,
109,154,255,110,109,161,255,85,86,118,255,35,39,51,255,34,34,42,255,30,34,46,
255,30,34,46,255,30,34,46,255,30,34,46,255,29,30,37,255,18,16,20,255,22,144,225,
255,0,157,255,255,20,150,252,255,0,157,255,255,20,150,252,255,0,157,255,255,0,
157,255,255,0,157,255,255,0,157,255,255,20,150,252,255,0,157,255,255,20,150,252,
255,0,161,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,
255,255,0,157,255,255,0,161,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,
157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,20,150,252,255,0,157,255,
255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,20,
150,252,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,
255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,20,150,252,255,0,
157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,
255,0,157,255,255,0,161,255,255,0,161,255,255,20,150,252,255,20,150,252,255,20,
150,252,255,20,150,252,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,
255,0,157,255,255,20,150,252,255,0,157,255,255,0,157,255,255,20,150,252,255,0,
157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,157,255,
255,0,157,255,255,20,150,252,255,0,111,164,255,30,34,46,255,30,34,46,255,30,34,
46,255,34,34,42,255,34,34,42,255,30,34,46,255,34,34,42,255,96,95,132,255,112,
108,148,255,119,117,156,255,117,118,163,255,109,109,154,255,110,109,161,255,109,
109,154,255,109,109,154,255,109,109,154,255,96,95,132,255,96,95,132,255,85,86,
118,255,109,109,154,255,96,95,132,255,112,108,148,255,110,109,161,255,114,107,
154,255,109,109,154,255,117,118,163,255,117,118,163,255,117,118,163,255,129,126,
165,255,123,115,163,255,124,124,170,255,124,124,170,255,124,124,170,255,128,125,
178,255,128,125,178,255,124,124,170,255,128,125,178,255,140,132,180,255,154,150,
192,255,166,153,185,255,166,157,194,255,166,157,194,255,166,157,194,255,153,152,
200,255,149,146,200,255,148,148,195,255,141,141,167,255,168,170,187,255,1,6,9,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,175,177,
194,255,160,158,188,255,153,152,200,255,154,151,205,255,162,158,200,255,160,160,
195,255,160,160,195,255,155,151,186,255,145,142,177,255,145,141,183,255,140,132,
180,255,128,125,178,255,128,128,175,255,132,132,179,255,136,136,183,255,129,126,
165,255,132,132,179,255,129,126,165,255,183,187,202,255,183,187,202,255,184,185,
195,255,183,187,202,255,183,187,202,255,183,187,202,255,158,159,169,255,85,86,
118,255,123,115,163,255,123,115,163,255,124,124,170,255,124,124,170,255,131,124,
172,255,117,118,163,255,123,115,163,255,123,115,163,255,123,115,163,255,117,118,
163,255,119,117,156,255,110,109,161,255,114,107,154,255,96,95,132,255,34,34,42,
255,30,34,46,255,34,34,42,255,34,34,42,255,34,34,42,255,34,34,42,255,38,36,40,
255,18,16,20,255,22,144,225,255,10,166,254,255,10,166,254,255,0,161,255,255,10,
166,254,255,0,157,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,
255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,
255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,
157,255,255,0,161,255,255,0,157,255,255,0,161,255,255,0,161,255,255,0,161,255,
255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,157,255,255,0,161,
255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,157,255,255,0,
161,255,255,0,161,255,255,0,157,255,255,0,161,255,255,0,161,255,255,0,161,255,
255,0,161,255,255,0,157,255,255,0,157,255,255,0,157,255,255,0,161,255,255,0,161,
255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,
161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,157,255,
255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,255,255,0,161,
255,255,0,161,255,255,0,161,255,255,0,157,255,255,0,161,255,255,0,157,255,255,0,
161,255,255,0,157,255,255,0,157,255,255,0,111,164,255,28,32,43,255,30,34,46,255,
34,34,42,255,35,39,51,255,34,34,42,255,38,42,54,255,38,42,54,255,96,95,132,255,
111,110,143,255,117,118,163,255,111,110,143,255,119,117,156,255,109,109,154,255,
109,109,154,255,109,109,154,255,109,109,154,255,96,95,132,255,109,109,154,255,
96,95,132,255,96,95,132,255,110,109,161,255,110,109,161,255,109,109,154,255,
110,109,161,255,119,117,156,255,117,118,163,255,119,117,156,255,129,126,165,255,
124,124,170,255,124,124,170,255,124,124,170,255,124,124,170,255,128,128,175,255,
131,124,172,255,124,124,170,255,148,148,195,255,142,141,188,255,128,125,178,255,
145,141,183,255,160,160,195,255,160,160,195,255,166,166,201,255,162,158,200,255,
162,158,200,255,149,146,200,255,154,151,205,255,153,139,168,255,169,170,180,255,
1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,
0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,
175,177,194,255,166,157,194,255,154,151,205,255,154,151,205,255,162,158,200,255,
166,157,194,255,166,166,201,255,160,160,195,255,155,151,186,255,145,142,177,255,
142,141,188,255,134,131,185,255,128,125,178,255,128,128,175,255,132,132,179,255,
132,132,179,255,132,132,179,255,128,128,175,255,122,124,142,255,139,141,157,255,
125,125,134,255,125,125,134,255,125,125,134,255,122,124,142,255,110,108,129,255,
96,95,132,255,124,124,170,255,124,124,170,255,124,124,170,255,117,118,163,255,
128,125,178,255,119,117,169,255,119,117,169,255,119,117,156,255,117,118,163,255,
117,118,163,255,119,117,156,255,109,109,154,255,114,107,154,255,85,86,118,255,
38,42,54,255,35,39,51,255,30,34,46,255,30,34,46,255,30,34,46,255,28,32,43,255,
29,30,37,255,18,16,20,255,47,133,202,255,0,161,255,255,10,166,254,255,0,161,
255,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,
255,10,166,254,255,10,166,254,255,0,161,255,255,10,166,254,255,10,166,254,255,
10,166,254,255,10,166,254,255,0,161,255,255,10,166,254,255,10,166,254,255,10,
166,254,255,10,166,254,255,10,166,254,255,47,133,202,255,8,77,110,255,10,166,
254,255,47,133,202,255,8,77,110,255,47,133,202,255,8,77,110,255,10,166,254,255,
10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,47,133,202,255,10,
166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,
254,255,10,166,254,255,0,161,255,255,10,166,254,255,10,166,254,255,10,166,254,
255,8,77,110,255,22,144,225,255,10,166,254,255,10,166,254,255,10,166,254,255,22,
144,225,255,8,77,110,255,8,137,197,255,10,166,254,255,10,166,254,255,10,166,254,
255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,
10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,
166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,254,255,10,166,
254,255,10,166,254,255,10,166,254,255,0,111,164,255,34,34,42,255,30,34,46,255,
34,34,42,255,30,34,46,255,34,34,42,255,35,39,51,255,38,42,54,255,96,95,132,255,
119,117,156,255,109,109,154,255,119,117,156,255,119,117,156,255,109,109,154,255,
109,109,154,255,109,109,154,255,110,109,161,255,110,109,161,255,96,95,132,255,
110,109,161,255,96,95,132,255,112,108,148,255,114,107,154,255,112,108,148,255,
109,109,154,255,119,117,156,255,124,124,170,255,117,118,163,255,129,126,165,255,
124,124,170,255,124,124,170,255,124,124,170,255,124,124,170,255,132,132,179,255,
134,131,185,255,131,124,172,255,199,194,238,255,188,184,227,255,134,131,185,255,
142,141,188,255,166,157,194,255,173,165,202,255,166,157,194,255,169,165,207,255,
162,158,200,255,154,151,205,255,161,157,212,255,145,142,177,255,168,170,187,255,
1,6,9,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,
0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,
168,170,187,255,160,160,195,255,154,151,205,255,154,151,205,255,165,156,206,255,
166,166,201,255,173,165,202,255,173,165,202,255,162,158,200,255,154,150,192,255,
145,142,177,255,138,134,175,255,134,131,185,255,128,125,178,255,128,125,178,255,
128,128,175,255,128,128,175,255,132,132,179,255,128,128,175,255,117,118,163,255,
119,117,169,255,109,109,154,255,109,109,154,255,114,107,154,255,117,118,163,255,
117,118,163,255,119,117,169,255,131,124,172,255,131,124,172,255,119,117,169,255,
123,115,163,255,119,117,169,255,124,124,170,255,124,124,170,255,131,124,172,255,
129,126,165,255,131,124,172,255,110,109,161,255,114,107,154,255,85,86,118,255,
38,42,54,255,30,34,46,255,34,34,42,255,34,34,42,255,29,30,37,255,34,34,42,255,
29,30,37,255,18,16,20,255,0,154,215,255,10,166,254,255,0,174,254,255,0,174,254,
255,10,166,254,255,0,174,254,255,0,174,254,255,10,166,254,255,0,174,254,255,10,
166,254,255,10,166,254,255,0,174,254,255,10,166,254,255,10,166,254,255,10,166,
254,255,10,166,254,255,0,174,254,255,10,166,254,255,10,166,254,255,10,166,254,
255,10,166,254,255,10,166,254,255,5,112,153,255,1,6,9,255,8,77,110,255,0,111,
164,255,16,18,27,255,0,154,215,255,5,112,153,255,22,144,225,255,8,137,197,255,8,
137,197,255,47,133,202,255,0,111,164,255,1,6,9,255,0,111,164,255,0,154,215,255,
0,111,164,255,47,133,202,255,10,166,254,255,8,137,197,255,47,133,202,255,8,
137,197,255,0,174,254,255,8,137,197,255,0,111,164,255,18,16,20,255,8,137,197,
255,8,137,197,255,0,111,164,255,8,137,197,255,8,137,197,255,8,77,110,255,5,112,
153,255,0,174,254,255,0,174,254,255,0,174,254,255,10,166,254,255,10,166,254,255,
0,174,254,255,10,166,254,255,0,174,254,255,0,174,254,255,10,166,254,255,0,174,
254,255,0,174,254,255,0,174,254,255,10,166,254,255,0,174,254,255,10,166,254,255,
0,174,254,255,0,174,254,255,0,174,254,255,10,166,254,255,10,166,254,255,0,111,
164,255,30,34,46,255,34,34,42,255,28,32,43,255,34,34,42,255,30,34,46,255,30,34,
46,255,38,42,54,255,96,95,132,255,109,109,154,255,119,117,156,255,117,118,163,
255,119,117,156,255,109,109,154,255,112,108,148,255,109,109,154,255,109,109,154,
255,109,109,154,255,109,109,154,255,109,109,154,255,109,109,154,255,109,109,154,
255,109,109,154,255,117,118,163,255,123,115,163,255,119,117,169,255,124,124,170,
255,128,128,175,255,128,125,178,255,128,128,175,255,128,128,175,255,138,134,175,
255,138,134,175,255,132,132,179,255,132,132,179,255,134,131,185,255,148,148,195,
255,148,148,195,255,140,132,180,255,154,150,192,255,172,168,198,255,166,153,185,
255,166,166,201,255,166,157,194,255,165,156,206,255,149,146,200,255,154,151,205,
255,145,142,177,255,168,170,187,255,184,185,195,255,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,168,170,187,255,162,158,200,255,161,
157,212,255,153,152,200,255,162,158,200,255,166,157,194,255,166,166,201,255,172,
168,198,255,166,166,201,255,154,150,192,255,148,140,188,255,136,136,183,255,134,
131,185,255,134,131,185,255,128,125,178,255,128,125,178,255,128,128,175,255,128,
125,178,255,124,124,170,255,117,118,163,255,119,117,169,255,109,109,154,255,117,
118,163,255,119,117,169,255,119,117,169,255,117,118,163,255,119,117,169,255,119,
117,169,255,119,117,169,255,124,124,170,255,123,115,163,255,124,124,170,255,128,
125,178,255,131,124,172,255,128,125,178,255,124,124,170,255,129,126,165,255,110,
109,161,255,110,109,161,255,71,72,102,255,34,34,42,255,30,34,46,255,30,34,46,
255,30,34,46,255,30,34,46,255,30,34,46,255,29,30,37,255,18,16,20,255,0,154,215,
255,0,174,254,255,0,181,254,255,0,174,254,255,0,181,254,255,0,174,254,255,0,181,
254,255,0,174,254,255,0,181,254,255,0,181,254,255,0,174,254,255,0,181,254,255,0,
181,254,255,0,181,254,255,0,181,254,255,0,174,254,255,0,181,254,255,0,181,254,
255,0,181,254,255,0,181,254,255,0,181,254,255,0,174,254,255,0,111,164,255,0,30,
41,255,8,77,110,255,8,77,110,255,1,6,9,255,0,111,164,255,0,30,41,255,5,112,153,
255,16,18,27,255,8,137,197,255,1,6,9,255,32,144,189,255,1,6,9,255,5,112,153,255,
1,6,9,255,5,112,153,255,1,6,9,255,5,112,153,255,1,6,9,255,8,137,197,255,1,6,9,
255,0,111,164,255,1,6,9,255,0,154,215,255,1,6,9,255,5,112,153,255,1,6,9,255,0,
169,230,255,1,6,9,255,8,137,197,255,8,137,197,255,0,154,215,255,0,174,254,255,0,
174,254,255,0,181,254,255,0,174,254,255,0,174,254,255,0,181,254,255,0,174,254,
255,0,174,254,255,0,181,254,255,0,174,254,255,0,174,254,255,0,174,254,255,0,181,
254,255,0,174,254,255,0,181,254,255,0,174,254,255,0,174,254,255,0,174,254,255,0,
174,254,255,0,181,254,255,0,174,254,255,5,112,153,255,28,32,43,255,30,34,46,255,
30,34,46,255,34,34,42,255,34,34,42,255,35,39,51,255,38,42,54,255,85,86,118,255,
119,117,156,255,111,110,143,255,109,109,154,255,119,117,156,255,117,118,163,255,
109,109,154,255,109,109,154,255,117,118,163,255,117,118,163,255,117,118,163,255,
117,118,163,255,119,117,169,255,119,117,169,255,117,118,163,255,119,117,169,255,
131,124,172,255,119,117,169,255,128,125,178,255,128,128,175,255,132,132,179,255,
128,128,175,255,128,128,175,255,132,132,179,255,132,132,179,255,138,134,175,255,
132,132,179,255,138,135,189,255,134,131,185,255,138,135,189,255,145,141,183,255,
154,150,192,255,166,166,201,255,172,168,198,255,166,166,201,255,166,166,201,255,
165,156,206,255,154,151,205,255,165,156,206,255,145,142,177,255,168,170,187,255,
184,185,195,255,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,
108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,
148,0,168,170,187,255,160,160,195,255,165,156,206,255,154,151,205,255,165,156,
206,255,169,165,207,255,173,165,202,255,173,165,202,255,166,157,194,255,143,140,
194,255,138,135,189,255,134,131,185,255,138,135,189,255,128,128,175,255,128,125,
178,255,128,125,178,255,128,125,178,255,128,125,178,255,128,125,178,255,128,125,
178,255,124,124,170,255,119,117,169,255,123,115,163,255,123,115,163,255,123,115,
163,255,119,117,169,255,119,117,169,255,123,115,163,255,131,124,172,255,119,117,
169,255,128,125,178,255,119,117,169,255,123,115,163,255,119,117,169,255,123,115,
163,255,131,124,172,255,119,117,169,255,117,118,163,255,114,107,154,255,71,72,
102,255,38,42,54,255,34,34,42,255,34,34,42,255,34,34,42,255,30,34,46,255,34,34,
42,255,34,34,42,255,18,16,20,255,0,154,215,255,0,181,254,255,0,181,254,255,0,
181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,
255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,
254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,
181,254,255,0,181,254,255,5,112,153,255,0,30,41,255,0,169,230,255,0,30,41,255,1,
6,9,255,5,112,153,255,16,18,27,255,5,112,153,255,0,30,41,255,0,169,230,255,1,
6,9,255,0,111,164,255,1,6,9,255,5,112,153,255,1,6,9,255,0,169,230,255,8,77,
110,255,5,112,153,255,1,6,9,255,4,187,254,255,16,18,27,255,1,113,138,255,1,6,9,
255,32,144,189,255,1,6,9,255,8,77,110,255,1,6,9,255,0,169,230,255,1,6,9,255,0,
154,215,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,
255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,
254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,
181,254,255,0,174,254,255,0,181,254,255,0,181,254,255,0,181,254,255,0,181,254,
255,0,181,254,255,5,112,153,255,34,34,42,255,34,34,42,255,30,34,46,255,35,39,51,
255,34,34,42,255,34,34,42,255,38,42,54,255,85,86,118,255,110,109,161,255,117,
118,163,255,117,118,163,255,109,109,154,255,117,118,163,255,119,117,156,255,117,
118,163,255,117,118,163,255,117,118,163,255,123,115,163,255,117,118,163,255,109,
109,154,255,109,109,154,255,123,115,163,255,117,118,163,255,109,109,154,255,124,
124,170,255,124,124,170,255,128,125,178,255,128,125,178,255,138,135,189,255,138,
135,189,255,136,136,183,255,138,134,175,255,136,136,183,255,138,134,175,255,138,
134,175,255,145,141,183,255,145,142,177,255,155,151,186,255,166,157,194,255,166,
153,185,255,173,165,202,255,173,165,202,255,162,158,200,255,169,165,207,255,149,
146,200,255,161,157,212,255,145,142,177,255,181,158,174,255,184,185,195,255,1,6,
9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,
116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,174,166,191,
255,154,150,192,255,165,156,206,255,159,158,206,255,162,158,200,255,173,165,202,
255,172,168,198,255,166,166,201,255,154,150,192,255,138,135,189,255,145,141,183,
255,140,132,180,255,134,131,185,255,134,131,185,255,132,132,179,255,128,125,178,
255,128,128,175,255,131,124,172,255,128,125,178,255,128,125,178,255,128,125,178,
255,119,117,169,255,119,117,169,255,119,117,169,255,119,117,169,255,123,115,163,
255,124,124,170,255,124,124,170,255,124,124,170,255,124,124,170,255,131,124,172,
255,128,125,178,255,140,132,180,255,154,150,192,255,128,125,178,255,124,124,170,
255,123,115,163,255,123,115,163,255,114,107,154,255,71,72,102,255,38,42,54,255,
35,39,51,255,30,34,46,255,34,34,42,255,34,34,42,255,34,34,42,255,29,30,37,255,
18,16,20,255,32,144,189,255,0,181,254,255,4,187,254,255,0,181,254,255,4,187,
254,255,0,181,254,255,4,187,254,255,0,181,254,255,0,181,254,255,4,187,254,255,0,
181,254,255,0,181,254,255,0,181,254,255,0,181,254,255,4,187,254,255,0,181,254,
255,0,181,254,255,0,181,254,255,0,181,254,255,4,187,254,255,4,187,254,255,4,187,
254,255,0,154,215,255,32,144,189,255,4,187,254,255,0,154,215,255,32,144,189,255,
0,154,215,255,32,144,189,255,0,154,215,255,32,144,189,255,4,187,254,255,5,112,
153,255,0,169,230,255,5,112,153,255,0,169,230,255,32,144,189,255,1,113,138,255,
32,144,189,255,0,169,230,255,5,112,153,255,0,193,255,255,5,112,153,255,0,169,
230,255,32,144,189,255,5,112,153,255,32,144,189,255,0,169,230,255,32,144,189,
255,5,112,153,255,32,144,189,255,4,187,254,255,0,181,254,255,0,181,254,255,4,
187,254,255,0,181,254,255,4,187,254,255,4,187,254,255,0,181,254,255,4,187,254,
255,4,187,254,255,0,181,254,255,4,187,254,255,0,181,254,255,4,187,254,255,0,181,
254,255,0,181,254,255,4,187,254,255,4,187,254,255,4,187,254,255,4,187,254,255,4,
187,254,255,0,181,254,255,4,187,254,255,0,181,254,255,5,112,153,255,29,30,37,
255,34,34,42,255,30,34,46,255,30,34,46,255,35,39,51,255,34,34,42,255,38,42,54,
255,85,86,118,255,117,118,163,255,119,117,156,255,117,118,163,255,119,117,156,
255,119,117,169,255,128,125,178,255,119,117,169,255,119,117,169,255,117,118,163,
255,123,115,163,255,117,118,163,255,119,117,156,255,119,117,156,255,109,109,154,
255,117,118,163,255,117,118,163,255,119,117,169,255,117,118,163,255,124,124,170,
255,131,124,172,255,132,132,179,255,134,131,185,255,138,135,189,255,142,141,188,
255,136,136,183,255,136,136,183,255,132,132,179,255,136,136,183,255,145,141,183,
255,155,151,186,255,160,160,195,255,160,158,188,255,172,168,198,255,172,168,198,
255,169,165,207,255,162,158,200,255,149,146,200,255,161,157,212,255,145,142,177,
255,157,158,178,255,184,185,195,255,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,168,170,187,255,162,158,200,255,161,157,212,255,154,
151,205,255,169,165,207,255,169,165,207,255,173,165,202,255,173,165,202,255,155,
147,196,255,138,135,189,255,173,165,215,255,169,165,207,255,134,131,185,255,141,
140,200,255,134,131,185,255,138,135,189,255,134,131,185,255,132,132,179,255,132,
132,179,255,132,132,179,255,131,124,172,255,128,125,178,255,128,128,175,255,128,
128,175,255,124,124,170,255,128,125,178,255,128,125,178,255,131,124,172,255,128,
128,175,255,128,128,175,255,128,128,175,255,128,125,178,255,134,131,185,255,143,
140,194,255,131,124,172,255,134,131,185,255,128,125,178,255,117,118,163,255,119,
117,169,255,71,72,102,255,38,36,40,255,34,34,42,255,34,34,42,255,29,30,37,255,
28,32,43,255,28,32,43,255,34,34,42,255,18,16,20,255,0,169,230,255,0,193,255,
255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,198,
255,255,0,198,255,255,0,193,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,
198,255,255,0,193,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,
255,0,193,255,255,0,193,255,255,4,187,254,255,4,187,254,255,0,193,255,255,0,193,
255,255,0,198,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,
193,255,255,0,193,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,193,255,
255,4,187,254,255,4,187,254,255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,
255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,
193,255,255,4,187,254,255,0,198,255,255,0,193,255,255,0,193,255,255,0,198,255,
255,0,198,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,193,255,255,0,198,
255,255,4,187,254,255,0,198,255,255,4,187,254,255,0,198,255,255,0,193,255,255,0,
193,255,255,0,193,255,255,0,198,255,255,0,193,255,255,0,193,255,255,4,187,254,
255,4,187,254,255,0,193,255,255,0,193,255,255,4,187,254,255,0,193,255,255,5,112,
153,255,35,39,51,255,34,34,42,255,34,34,42,255,34,34,42,255,30,34,46,255,35,39,
51,255,46,49,63,255,85,86,118,255,112,108,148,255,109,109,154,255,119,117,156,
255,119,117,169,255,124,124,170,255,123,115,163,255,124,124,170,255,119,117,156,
255,117,118,163,255,117,118,163,255,119,117,156,255,124,124,170,255,124,124,170,
255,128,128,175,255,128,128,175,255,129,126,165,255,129,126,165,255,124,124,170,
255,124,124,170,255,136,136,183,255,142,141,188,255,132,132,179,255,136,136,183,
255,140,132,180,255,143,140,194,255,132,132,179,255,136,136,183,255,145,142,177,
255,154,150,192,255,154,150,192,255,166,157,194,255,173,165,202,255,166,153,185,
255,172,168,198,255,166,166,201,255,169,165,207,255,154,151,205,255,161,157,212,
255,154,150,192,255,157,158,178,255,184,185,195,255,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,168,170,187,255,173,165,202,255,161,
157,212,255,154,151,205,255,169,165,207,255,169,165,207,255,173,165,202,255,178,
174,211,255,162,158,200,255,143,140,194,255,143,140,194,255,143,140,194,255,134,
131,185,255,138,135,189,255,132,132,179,255,136,136,183,255,134,131,185,255,136,
136,183,255,134,131,185,255,134,131,185,255,134,131,185,255,134,131,185,255,131,
124,172,255,128,125,178,255,124,124,170,255,124,124,170,255,128,125,178,255,128,
128,175,255,128,128,175,255,128,128,175,255,128,128,175,255,128,128,175,255,134,
131,185,255,128,125,178,255,128,125,178,255,128,128,175,255,128,125,178,255,123,
115,163,255,110,109,161,255,71,72,102,255,35,39,51,255,35,39,51,255,30,34,46,
255,34,34,42,255,34,34,42,255,34,34,42,255,34,34,42,255,18,16,20,255,32,144,189,
255,0,202,253,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,
255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,
198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,
255,0,198,255,255,0,198,255,255,0,202,253,255,0,202,253,255,0,198,255,255,0,198,
255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,
198,255,255,0,202,253,255,0,193,255,255,0,198,255,255,0,198,255,255,0,202,253,
255,0,202,253,255,0,198,255,255,0,202,253,255,0,202,253,255,0,198,255,255,0,198,
255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,
198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,
255,0,198,255,255,0,198,255,255,0,198,255,255,0,202,253,255,0,198,255,255,0,198,
255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,
198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,255,0,198,255,
255,0,198,255,255,0,198,255,255,0,202,253,255,0,202,253,255,0,198,255,255,0,198,
255,255,1,113,138,255,35,39,51,255,30,34,46,255,30,34,46,255,34,34,42,255,34,34,
42,255,34,34,42,255,38,42,54,255,96,95,132,255,117,118,163,255,117,118,163,255,
117,118,163,255,119,117,169,255,117,118,163,255,129,126,165,255,119,117,169,255,
124,124,170,255,129,126,165,255,132,132,179,255,124,124,170,255,128,128,175,255,
128,128,175,255,128,128,175,255,132,132,179,255,138,134,175,255,145,141,183,255,
145,141,183,255,145,142,177,255,145,142,177,255,145,142,177,255,128,128,175,255,
124,124,170,255,128,128,175,255,148,140,188,255,136,136,183,255,142,141,188,255,
145,142,177,255,155,151,186,255,160,158,188,255,166,153,185,255,174,166,191,255,
173,165,202,255,173,165,202,255,169,165,207,255,166,165,214,255,154,151,205,255,
167,163,218,255,154,150,192,255,168,170,187,255,184,185,195,255,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,
148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,174,166,191,255,160,160,
195,255,165,156,206,255,161,157,212,255,159,158,206,255,169,165,207,255,173,165,
202,255,166,166,201,255,166,157,194,255,148,148,195,255,155,147,196,255,143,140,
194,255,148,148,195,255,142,141,188,255,136,136,183,255,138,135,189,255,136,136,
183,255,138,135,189,255,142,141,188,255,142,141,188,255,134,131,185,255,134,131,
185,255,143,140,194,255,136,136,183,255,132,132,179,255,132,132,179,255,132,132,
179,255,134,131,185,255,132,132,179,255,134,131,185,255,136,136,183,255,134,131,
185,255,140,132,180,255,132,132,179,255,132,132,179,255,128,125,178,255,128,125,
178,255,119,117,169,255,123,115,163,255,71,72,102,255,38,42,54,255,30,34,46,255,
30,34,46,255,30,34,46,255,30,34,46,255,28,32,43,255,34,34,42,255,18,16,20,255,
0,169,192,255,0,198,255,255,0,202,253,255,0,202,253,255,0,198,255,255,0,202,
253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,
202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,
255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,198,255,255,0,202,
253,255,0,198,255,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,
202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,
255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,198,255,255,0,202,
253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,
202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,
255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,198,255,255,0,202,
253,255,0,198,255,255,0,209,254,255,0,198,255,255,0,209,254,255,0,198,255,255,0,
202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,
255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,253,255,0,202,
253,255,0,202,253,255,1,113,138,255,29,30,37,255,34,34,42,255,35,39,51,255,30,
34,46,255,34,34,42,255,35,39,51,255,38,36,40,255,85,86,118,255,109,109,154,255,
110,109,161,255,123,115,163,255,124,124,170,255,124,124,170,255,124,124,170,255,
128,128,175,255,132,132,179,255,132,132,179,255,132,132,179,255,142,141,188,255,
142,141,188,255,154,150,192,255,154,150,192,255,154,150,192,255,154,150,192,255,
155,151,186,255,155,151,186,255,145,142,177,255,129,126,165,255,141,141,167,255,
128,121,147,255,129,126,165,255,134,131,185,255,128,128,175,255,148,140,188,255,
142,141,188,255,154,150,192,255,155,151,186,255,166,157,194,255,166,153,185,255,
166,157,194,255,172,168,198,255,173,165,202,255,173,165,202,255,169,165,207,255,
154,151,205,255,161,157,212,255,154,150,192,255,157,158,178,255,177,177,187,255,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,174,166,
191,255,160,160,195,255,159,158,206,255,161,157,212,255,162,158,200,255,169,165,
207,255,162,158,200,255,166,166,201,255,173,165,202,255,162,158,200,255,154,150,
192,255,162,158,200,255,148,148,195,255,148,148,195,255,142,141,188,255,142,141,
188,255,136,136,183,255,136,136,183,255,142,141,188,255,136,136,183,255,138,135,
189,255,128,128,175,255,128,128,175,255,134,131,185,255,138,135,189,255,138,135,
189,255,136,136,183,255,138,135,189,255,136,136,183,255,138,135,189,255,136,136,
183,255,138,135,189,255,134,131,185,255,134,131,185,255,140,132,180,255,131,124,
172,255,124,124,170,255,119,117,169,255,110,109,161,255,64,65,86,255,35,39,51,
255,34,34,42,255,30,34,46,255,34,34,42,255,30,34,46,255,28,32,43,255,29,30,37,
255,18,16,20,255,74,149,178,255,0,209,254,255,0,209,254,255,0,209,254,255,0,209,
254,255,0,202,253,255,0,209,254,255,0,209,254,255,0,202,253,255,0,209,254,255,0,
209,254,255,0,202,253,255,0,209,254,255,0,209,254,255,0,202,253,255,0,209,254,
255,0,202,253,255,0,209,254,255,0,209,254,255,0,202,253,255,0,209,254,255,0,209,
254,255,0,209,254,255,0,202,253,255,0,209,254,255,0,209,254,255,0,202,253,255,0,
209,254,255,0,202,253,255,0,202,253,255,0,209,254,255,0,209,254,255,0,202,253,
255,0,202,253,255,0,202,253,255,0,209,254,255,0,202,253,255,0,209,254,255,0,209,
254,255,0,202,253,255,0,209,254,255,0,209,254,255,0,209,254,255,0,209,254,255,0,
209,254,255,0,209,254,255,0,209,254,255,0,202,253,255,0,209,254,255,0,209,254,
255,0,202,253,255,0,209,254,255,0,209,254,255,0,209,254,255,0,209,254,255,0,209,
254,255,0,209,254,255,0,209,254,255,0,209,254,255,0,209,254,255,0,209,254,255,0,
209,254,255,0,209,254,255,0,209,254,255,0,202,253,255,0,209,254,255,0,209,254,
255,0,209,254,255,0,214,255,255,0,202,253,255,0,202,253,255,0,202,253,255,0,209,
254,255,0,209,254,255,0,202,253,255,1,113,138,255,30,34,46,255,28,32,43,255,34,
34,42,255,30,34,46,255,30,34,46,255,35,39,51,255,38,42,54,255,85,86,118,255,
109,109,154,255,117,118,163,255,117,118,163,255,123,115,163,255,124,124,170,255,
138,134,175,255,138,134,175,255,142,141,188,255,145,141,183,255,155,151,186,255,
155,151,186,255,154,150,192,255,160,160,195,255,155,151,186,255,141,141,167,255,
141,141,167,255,141,141,167,255,128,121,147,255,141,141,167,255,160,158,188,255,
155,151,186,255,160,160,195,255,153,152,200,255,128,125,178,255,128,125,178,255,
140,132,180,255,143,140,194,255,142,141,188,255,166,153,185,255,160,158,188,255,
166,153,185,255,173,165,202,255,173,165,202,255,173,165,202,255,173,165,202,255,
166,165,214,255,165,156,206,255,161,157,212,255,155,147,196,255,174,166,191,255,
184,185,195,255,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,
108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,
148,0,157,158,178,255,166,166,201,255,161,157,212,255,159,158,206,255,165,156,
206,255,162,158,200,255,169,165,207,255,169,165,207,255,162,158,200,255,166,157,
194,255,162,158,200,255,162,158,200,255,154,150,192,255,148,148,195,255,148,148,
195,255,143,140,194,255,142,141,188,255,142,141,188,255,132,132,179,255,136,136,
183,255,132,132,179,255,143,140,194,255,138,135,189,255,132,132,179,255,132,132,
179,255,132,132,179,255,132,132,179,255,136,136,183,255,143,140,194,255,142,141,
188,255,143,140,194,255,143,140,194,255,143,140,194,255,138,135,189,255,134,131,
185,255,134,131,185,255,128,125,178,255,117,118,163,255,110,109,161,255,71,72,
102,255,50,51,59,255,30,34,46,255,34,34,42,255,29,30,37,255,34,34,42,255,30,34,
46,255,30,34,46,255,24,25,32,255,0,169,192,255,0,214,255,255,0,214,255,255,0,
214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,
255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,
255,255,0,214,255,255,0,214,255,255,0,209,254,255,0,214,255,255,0,214,255,255,0,
214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,
255,0,214,255,255,0,209,254,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,
255,255,0,220,255,255,0,214,255,255,0,214,255,255,0,209,254,255,0,214,255,255,0,
214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,209,254,255,0,209,254,
255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,220,255,255,0,214,
255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,
214,255,255,0,209,254,255,0,214,255,255,0,214,255,255,0,214,255,255,0,209,254,
255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,
255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,214,255,255,0,
214,255,255,0,214,255,255,0,209,254,255,0,220,255,255,1,113,138,255,34,34,42,
255,30,34,46,255,30,34,46,255,30,34,46,255,34,34,42,255,35,39,51,255,38,42,54,
255,85,86,118,255,109,109,154,255,119,117,169,255,123,115,163,255,117,118,163,
255,136,136,183,255,145,142,177,255,145,142,177,255,154,150,192,255,169,165,207,
255,162,158,200,255,154,150,192,255,141,141,167,255,145,142,177,255,145,142,177,
255,160,158,188,255,191,186,215,255,172,168,198,255,178,174,211,255,178,173,216,
255,145,142,177,255,142,141,188,255,145,142,177,255,148,148,195,255,124,124,170,
255,119,117,169,255,134,131,185,255,138,134,175,255,155,147,196,255,166,153,185,
255,166,153,185,255,166,153,185,255,166,157,194,255,174,166,191,255,166,166,201,
255,169,165,207,255,169,165,207,255,154,151,205,255,173,165,215,255,154,150,192,
255,157,158,178,255,178,176,180,255,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,174,166,191,255,166,166,201,255,161,157,212,255,166,
165,214,255,165,156,206,255,165,156,206,255,162,158,200,255,169,165,207,255,169,
165,207,255,162,158,200,255,162,158,200,255,162,158,200,255,153,152,200,255,154,
150,192,255,148,148,195,255,142,141,188,255,143,140,194,255,143,140,194,255,132,
132,179,255,132,132,179,255,128,128,175,255,132,132,179,255,128,128,175,255,132,
132,179,255,136,136,183,255,138,135,189,255,142,141,188,255,136,136,183,255,142,
141,188,255,138,135,189,255,134,131,185,255,141,140,200,255,155,147,196,255,154,
151,205,255,148,148,195,255,140,132,180,255,128,125,178,255,117,118,163,255,114,
107,154,255,52,55,78,255,35,39,51,255,28,32,43,255,30,34,46,255,29,30,37,255,34,
34,42,255,30,34,46,255,29,30,37,255,18,16,20,255,0,169,192,255,0,214,255,255,0,
220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,
255,0,220,255,255,0,214,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,
255,255,0,214,255,255,0,220,255,255,21,223,254,255,0,220,255,255,0,220,255,255,
0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,
255,255,21,223,254,255,21,223,254,255,0,220,255,255,0,220,255,255,0,220,255,255,
0,220,255,255,0,214,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,
255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,
220,255,255,0,220,255,255,0,220,255,255,0,214,255,255,0,220,255,255,0,214,255,
255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,214,255,255,0,220,
255,255,0,220,255,255,21,223,254,255,0,220,255,255,0,220,255,255,0,220,255,255,
0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,
255,255,0,220,255,255,0,214,255,255,21,223,254,255,0,214,255,255,0,220,255,255,
21,223,254,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,
255,255,1,113,138,255,34,34,42,255,35,39,51,255,30,34,46,255,35,39,51,255,28,32,
43,255,35,39,51,255,38,42,54,255,85,86,118,255,109,109,154,255,110,109,161,255,
117,118,163,255,129,126,165,255,142,141,188,255,145,142,177,255,141,141,167,255,
141,141,167,255,145,142,177,255,141,141,167,255,160,158,188,255,186,190,212,255,
191,186,215,255,191,186,215,255,188,185,222,255,166,166,201,255,166,166,201,255,
166,166,201,255,166,165,214,255,162,158,200,255,154,150,192,255,145,142,177,255,
129,126,165,255,132,132,179,255,124,124,170,255,136,136,183,255,154,150,192,255,
154,150,192,255,166,157,194,255,166,153,185,255,166,153,185,255,166,157,194,255,
173,165,202,255,173,165,202,255,173,165,202,255,166,165,214,255,154,151,205,255,
167,163,218,255,153,152,200,255,157,158,178,255,191,194,208,255,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,
148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,174,166,191,255,166,153,
185,255,173,165,215,255,161,157,212,255,159,158,206,255,162,158,200,255,173,165,
215,255,169,165,207,255,162,158,200,255,169,165,207,255,166,157,194,255,162,158,
200,255,162,158,200,255,153,152,200,255,154,150,192,255,148,148,195,255,136,136,
183,255,143,140,194,255,132,132,179,255,132,132,179,255,138,135,189,255,132,132,
179,255,128,128,175,255,128,128,175,255,138,135,189,255,132,132,179,255,138,135,
189,255,142,141,188,255,138,135,189,255,138,135,189,255,141,140,200,255,148,148,
195,255,200,201,225,255,220,221,234,255,175,177,194,255,136,136,183,255,124,124,
170,255,110,109,161,255,110,109,161,255,71,72,102,255,35,39,51,255,34,34,42,255,
34,34,42,255,30,34,46,255,29,30,37,255,34,34,42,255,30,34,46,255,18,16,20,255,
0,169,192,255,21,223,254,255,21,223,254,255,21,223,254,255,0,220,255,255,0,
220,255,255,21,223,254,255,0,220,255,255,21,223,254,255,21,223,254,255,21,223,
254,255,0,220,255,255,21,223,254,255,21,223,254,255,21,223,254,255,21,223,254,
255,21,223,254,255,0,220,255,255,21,223,254,255,21,223,254,255,21,223,254,255,
21,223,254,255,21,223,254,255,0,220,255,255,0,220,255,255,0,220,255,255,0,220,
255,255,0,220,255,255,21,223,254,255,0,220,255,255,21,223,254,255,21,223,254,
255,21,223,254,255,0,220,255,255,21,223,254,255,21,223,254,255,0,220,255,255,21,
223,254,255,0,220,255,255,21,223,254,255,21,223,254,255,21,223,254,255,0,220,
255,255,0,220,255,255,21,223,254,255,21,223,254,255,21,223,254,255,21,223,254,
255,21,223,254,255,21,223,254,255,21,223,254,255,21,223,254,255,0,220,255,255,0,
220,255,255,21,223,254,255,21,223,254,255,21,223,254,255,0,220,255,255,21,223,
254,255,21,223,254,255,21,223,254,255,0,220,255,255,21,223,254,255,21,223,254,
255,21,223,254,255,21,223,254,255,21,223,254,255,21,223,254,255,21,223,254,255,
21,223,254,255,0,220,255,255,21,223,254,255,21,223,254,255,0,220,255,255,21,
223,254,255,6,120,128,255,34,34,42,255,29,30,37,255,34,34,42,255,29,30,37,255,
34,34,42,255,34,34,42,255,38,42,54,255,85,86,118,255,110,109,161,255,117,118,
163,255,117,118,163,255,117,118,163,255,128,121,147,255,141,141,167,255,141,141,
167,255,172,168,198,255,186,190,212,255,188,185,222,255,191,186,215,255,178,174,
211,255,188,185,222,255,199,194,238,255,188,185,222,255,188,185,222,255,191,186,
215,255,178,174,211,255,157,158,178,255,141,141,167,255,141,141,167,255,160,158,
188,255,169,165,207,255,132,132,179,255,131,124,172,255,132,132,179,255,142,141,
188,255,148,140,188,255,154,150,192,255,166,157,194,255,166,153,185,255,166,153,
185,255,166,153,185,255,172,168,198,255,169,165,207,255,169,165,207,255,161,157,
212,255,161,157,212,255,162,158,200,255,168,170,187,255,184,185,195,255,1,6,9,0,
1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,
112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,174,166,191,255,
166,166,201,255,165,156,206,255,173,165,215,255,161,157,212,255,162,158,200,255,
162,158,200,255,173,165,215,255,162,158,200,255,159,158,206,255,153,152,200,255,
162,158,200,255,162,158,200,255,153,152,200,255,148,148,195,255,142,141,188,255,
136,136,183,255,138,135,189,255,154,151,205,255,132,132,179,255,128,128,175,255,
134,131,185,255,128,128,175,255,128,125,178,255,132,132,179,255,132,132,179,255,
128,128,175,255,136,136,183,255,138,135,189,255,134,131,185,255,142,141,188,255,
215,213,240,255,208,208,221,255,208,208,221,255,220,221,234,255,158,159,169,255,
129,126,165,255,117,118,163,255,114,107,154,255,52,55,78,255,35,39,51,255,30,34,
46,255,34,34,42,255,30,34,46,255,30,34,46,255,30,34,46,255,34,34,42,255,18,16,
20,255,0,169,192,255,24,229,253,255,24,229,253,255,0,235,255,255,24,229,253,
255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,
24,229,253,255,24,229,253,255,24,229,253,255,0,235,255,255,24,229,253,255,24,
229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,
253,255,24,229,253,255,24,229,253,255,0,235,255,255,24,229,253,255,0,235,255,
255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,
24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,
229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,
253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,
255,24,229,253,255,21,223,254,255,24,229,253,255,0,235,255,255,24,229,253,255,
24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,
229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,
253,255,24,229,253,255,0,235,255,255,21,223,254,255,0,235,255,255,24,229,253,
255,21,223,254,255,24,229,253,255,24,229,253,255,24,229,253,255,24,229,253,255,
24,229,253,255,24,229,253,255,6,120,128,255,30,34,46,255,28,32,43,255,30,34,46,
255,28,32,43,255,28,32,43,255,35,39,51,255,38,36,40,255,85,86,118,255,109,109,
154,255,109,109,154,255,117,118,163,255,132,132,179,255,169,165,207,255,169,165,
207,255,155,151,186,255,162,158,200,255,178,174,211,255,188,185,222,255,204,199,
237,255,204,199,237,255,188,185,222,255,188,185,222,255,191,186,215,255,188,184,
227,255,191,186,215,255,191,186,215,255,200,201,225,255,175,177,194,255,166,166,
201,255,148,148,195,255,149,146,200,255,132,132,179,255,128,125,178,255,128,125,
178,255,128,125,178,255,148,140,188,255,154,150,192,255,154,150,192,255,155,151,
186,255,160,160,195,255,169,165,207,255,173,165,202,255,178,173,216,255,173,165,
215,255,161,157,212,255,161,157,212,255,162,158,200,255,168,170,187,255,184,185,
195,255,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,
135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,172,
168,198,255,160,158,188,255,166,165,214,255,161,157,212,255,159,158,206,255,161,
157,212,255,165,156,206,255,165,156,206,255,165,156,206,255,159,158,206,255,159,
158,206,255,162,158,200,255,162,158,200,255,162,158,200,255,153,152,200,255,149,
146,200,255,138,135,189,255,138,135,189,255,138,135,189,255,149,146,200,255,158,
156,218,255,143,140,194,255,138,135,189,255,128,125,178,255,124,124,170,255,128,
125,178,255,132,132,179,255,134,131,185,255,132,132,179,255,141,140,200,255,142,
141,188,255,191,194,208,255,183,187,202,255,175,177,194,255,183,187,202,255,167,
164,169,255,114,107,154,255,114,107,154,255,110,109,161,255,64,65,86,255,35,39,
51,255,34,34,42,255,28,32,43,255,34,34,42,255,29,30,37,255,34,34,42,255,29,30,
37,255,23,22,25,255,0,169,192,255,0,235,255,255,0,235,255,255,24,229,253,255,0,
235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,
255,0,235,255,255,0,235,255,255,0,235,255,255,24,229,253,255,0,235,255,255,0,
235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,
255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,
255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,
235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,
255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,
255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,
235,255,255,24,229,253,255,0,235,255,255,0,235,255,255,0,235,255,255,24,229,253,
255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,
255,255,0,235,255,255,0,235,255,255,0,235,255,255,24,229,253,255,0,235,255,255,
0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,
255,255,0,235,255,255,24,229,253,255,0,235,255,255,6,120,128,255,28,32,43,255,
30,34,46,255,35,39,51,255,30,34,46,255,34,34,42,255,35,39,51,255,38,42,54,255,
85,86,118,255,114,107,154,255,117,118,163,255,117,118,163,255,132,132,179,255,
148,148,195,255,154,150,192,255,169,165,207,255,178,174,211,255,178,174,211,255,
178,174,211,255,186,190,212,255,188,185,222,255,206,202,246,255,215,213,240,255,
200,201,225,255,204,199,237,255,204,199,237,255,202,196,248,255,188,184,227,255,
169,165,207,255,162,158,200,255,169,165,207,255,148,148,195,255,134,131,185,255,
134,131,185,255,123,115,163,255,128,125,178,255,140,132,180,255,154,150,192,255,
142,141,188,255,148,148,195,255,153,152,200,255,166,157,194,255,169,165,207,255,
169,165,207,255,169,165,207,255,161,157,212,255,167,163,218,255,166,153,185,255,
168,170,187,255,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,
1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,
6,9,0,112,108,148,0,172,168,198,255,166,166,201,255,159,158,206,255,161,157,
212,255,165,156,206,255,159,158,206,255,159,158,206,255,166,165,214,255,169,165,
207,255,162,158,200,255,162,158,200,255,159,158,206,255,159,158,206,255,162,158,
200,255,154,150,192,255,148,148,195,255,138,135,189,255,138,135,189,255,138,135,
189,255,128,128,175,255,138,135,189,255,132,132,179,255,143,140,194,255,154,151,
205,255,154,151,205,255,149,146,200,255,143,140,194,255,138,135,189,255,134,131,
185,255,134,131,185,255,132,132,179,255,175,177,194,255,175,177,194,255,177,177,
187,255,175,177,194,255,125,125,134,255,109,109,154,255,109,109,154,255,110,109,
161,255,52,55,78,255,35,39,51,255,30,34,46,255,30,34,46,255,30,34,46,255,30,34,
46,255,34,34,42,255,29,30,37,255,23,22,25,255,0,174,175,255,0,235,255,255,0,
240,255,255,0,235,255,255,0,235,255,255,0,240,255,255,0,235,255,255,0,240,255,
255,0,235,255,255,0,240,255,255,0,235,255,255,0,235,255,255,0,240,255,255,0,235,
255,255,0,235,255,255,0,240,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,
235,255,255,0,240,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,
255,0,235,255,255,0,240,255,255,0,235,255,255,0,240,255,255,0,235,255,255,0,240,
255,255,0,235,255,255,0,240,255,255,0,235,255,255,0,240,255,255,0,240,255,255,0,
235,255,255,0,240,255,255,0,235,255,255,0,240,255,255,0,240,255,255,0,240,255,
255,0,235,255,255,0,240,255,255,0,240,255,255,0,235,255,255,0,235,255,255,0,240,
255,255,0,240,255,255,0,240,255,255,0,240,255,255,0,235,255,255,0,235,255,255,0,
240,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,235,255,
255,0,240,255,255,0,235,255,255,0,235,255,255,0,235,255,255,0,240,255,255,0,240,
255,255,0,240,255,255,0,240,255,255,0,240,255,255,0,240,255,255,0,235,255,255,0,
240,255,255,0,235,255,255,0,240,255,255,0,240,255,255,0,235,255,255,6,120,128,
255,34,34,42,255,29,30,37,255,34,34,42,255,30,34,46,255,34,34,42,255,30,34,46,
255,38,42,54,255,85,86,118,255,109,109,154,255,119,117,169,255,117,118,163,255,
136,136,183,255,145,142,177,255,141,141,167,255,139,141,157,255,157,158,178,255,
188,185,222,255,200,201,225,255,204,199,237,255,200,201,225,255,204,199,237,255,
206,202,246,255,199,194,238,255,199,194,238,255,204,199,237,255,199,194,238,255,
188,184,227,255,172,168,198,255,157,158,178,255,141,141,167,255,145,142,177,255,
132,132,179,255,128,128,175,255,119,117,169,255,128,125,178,255,140,132,180,255,
148,140,188,255,143,140,194,255,142,141,188,255,153,152,200,255,162,158,200,255,
169,165,207,255,178,173,216,255,166,165,214,255,161,157,212,255,161,157,212,255,
160,158,188,255,175,177,194,255,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,
9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,
0,11,16,37,0,1,6,9,0,112,108,148,0,174,166,191,255,166,153,185,255,166,165,
214,255,167,163,218,255,159,158,206,255,165,156,206,255,165,156,206,255,162,158,
200,255,165,156,206,255,165,156,206,255,159,158,206,255,169,165,207,255,162,158,
200,255,159,158,206,255,159,158,206,255,148,148,195,255,136,136,183,255,138,135,
189,255,128,125,178,255,134,131,185,255,128,125,178,255,128,128,175,255,134,131,
185,255,138,135,189,255,134,131,185,255,132,132,179,255,149,146,200,255,161,157,
212,255,161,157,212,255,149,148,209,255,149,146,200,255,129,126,165,255,158,159,
169,255,158,159,169,255,139,141,157,255,112,108,148,255,117,118,163,255,114,107,
154,255,114,107,154,255,52,55,78,255,35,39,51,255,34,34,42,255,30,34,46,255,34,
34,42,255,34,34,42,255,30,34,46,255,30,34,46,255,23,22,25,255,0,174,175,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,240,255,255,0,247,255,
255,0,247,255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,247,255,255,0,240,255,
255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,240,255,255,0,
247,255,255,0,240,255,255,0,247,255,255,0,247,255,255,0,240,255,255,0,247,255,
255,0,240,255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,
255,0,247,255,255,0,240,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,240,255,255,0,240,255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,240,255,255,0,247,255,255,0,247,255,
255,6,120,128,255,30,34,46,255,30,34,46,255,30,34,46,255,34,34,42,255,34,34,42,
255,30,34,46,255,38,42,54,255,85,86,118,255,117,118,163,255,117,118,163,255,124,
124,170,255,136,136,183,255,160,160,195,255,172,168,198,255,172,168,198,255,206,
200,229,255,200,201,225,255,206,202,246,255,199,194,238,255,202,196,248,255,206,
202,246,255,202,196,248,255,206,202,246,255,188,185,222,255,204,199,237,255,188,
185,222,255,191,186,215,255,191,186,215,255,172,168,198,255,160,160,195,255,161,
157,212,255,134,131,185,255,134,131,185,255,128,125,178,255,119,117,169,255,134,
131,185,255,155,147,196,255,148,140,188,255,148,148,195,255,154,150,192,255,162,
158,200,255,162,158,200,255,169,165,207,255,178,173,216,255,161,157,212,255,167,
163,218,255,160,158,188,255,177,177,187,255,184,185,195,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,
135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,172,168,198,255,173,165,202,255,
165,156,206,255,167,163,218,255,159,158,206,255,162,158,200,255,165,156,206,255,
159,158,206,255,159,158,206,255,165,156,206,255,159,158,206,255,159,158,206,255,
169,165,207,255,162,158,200,255,159,158,206,255,153,152,200,255,136,136,183,255,
138,135,189,255,132,132,179,255,138,135,189,255,141,140,200,255,138,135,189,255,
138,135,189,255,128,125,178,255,138,135,189,255,128,125,178,255,138,135,189,255,
143,140,194,255,143,140,194,255,138,135,189,255,141,140,200,255,138,135,189,255,
117,118,163,255,119,117,156,255,117,118,163,255,114,107,154,255,109,109,154,255,
123,115,163,255,110,109,161,255,52,55,78,255,38,42,54,255,34,34,42,255,28,32,43,
255,28,32,43,255,29,30,37,255,30,34,46,255,28,32,43,255,18,16,20,255,0,174,175,
255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,
255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,
255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,
255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,
247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,
255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,255,255,0,247,
255,255,6,120,128,255,34,34,42,255,28,32,43,255,28,32,43,255,34,34,42,255,34,34,
42,255,34,34,42,255,38,42,54,255,85,86,118,255,110,109,161,255,119,117,169,255,
124,124,170,255,138,135,189,255,178,174,211,255,148,148,195,255,154,150,192,255,
178,174,211,255,188,184,235,255,204,199,237,255,206,202,246,255,188,185,222,255,
206,202,246,255,188,185,222,255,200,201,225,255,212,208,253,255,215,213,240,255,
212,208,253,255,215,213,240,255,188,184,227,255,160,160,195,255,159,158,206,255,
149,146,200,255,134,131,185,255,128,125,178,255,128,125,178,255,119,117,169,255,
128,125,178,255,138,135,189,255,148,140,188,255,143,140,194,255,153,152,200,255,
162,158,200,255,169,165,207,255,169,165,207,255,178,173,216,255,161,157,212,255,
159,158,206,255,157,158,178,255,175,177,194,255,184,185,195,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,
148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,160,158,188,255,166,166,
201,255,167,163,218,255,167,163,218,255,166,165,214,255,166,165,214,255,169,165,
207,255,169,165,207,255,169,165,207,255,169,165,207,255,162,158,200,255,169,165,
207,255,159,158,206,255,159,158,206,255,159,158,206,255,149,146,200,255,143,140,
194,255,143,140,194,255,138,135,189,255,138,135,189,255,128,125,178,255,128,125,
178,255,138,135,189,255,143,140,194,255,138,135,189,255,143,140,194,255,138,135,
189,255,141,140,200,255,141,140,200,255,134,131,185,255,134,131,185,255,138,135,
189,255,134,131,185,255,128,125,178,255,119,117,169,255,117,118,163,255,119,117,
169,255,110,109,161,255,114,107,154,255,64,65,86,255,35,39,51,255,28,32,43,255,
28,32,43,255,34,34,42,255,30,34,46,255,29,30,37,255,34,34,42,255,23,22,25,255,
6,120,128,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,
175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,
174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,
255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,
175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,
174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,
255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,
175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,
174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,
255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,
175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,
174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,
255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,175,255,0,174,
175,255,0,174,175,255,16,86,90,255,28,32,43,255,34,34,42,255,35,39,51,255,29,30,
37,255,30,34,46,255,30,34,46,255,34,34,42,255,96,95,132,255,117,118,163,255,
117,118,163,255,128,128,175,255,136,136,183,255,153,152,200,255,160,160,195,255,
160,160,195,255,172,168,198,255,188,185,222,255,186,190,212,255,200,201,225,255,
215,213,240,255,215,213,240,255,215,213,240,255,215,213,240,255,204,199,237,255,
188,184,235,255,206,202,246,255,199,194,238,255,188,185,222,255,178,174,211,255,
155,151,186,255,142,141,188,255,134,131,185,255,134,131,185,255,119,117,169,255,
128,125,178,255,134,131,185,255,143,140,194,255,143,140,194,255,148,148,195,255,
153,152,200,255,166,165,214,255,169,165,207,255,178,173,216,255,173,165,215,255,
161,157,212,255,165,156,206,255,157,158,178,255,178,176,180,255,184,185,195,0,1,
6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,
116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,172,168,198,
255,173,165,202,255,167,163,218,255,167,163,218,255,169,165,207,255,166,165,214,
255,169,165,207,255,166,165,214,255,162,158,200,255,166,165,214,255,159,158,206,
255,159,158,206,255,166,165,214,255,160,160,195,255,159,158,206,255,153,152,200,
255,143,140,194,255,143,140,194,255,138,135,189,255,132,132,179,255,132,132,179,
255,138,135,189,255,132,132,179,255,134,131,185,255,128,128,175,255,128,128,175,
255,138,135,189,255,143,140,194,255,141,140,200,255,141,140,200,255,141,140,200,
255,134,131,185,255,134,131,185,255,134,131,185,255,128,125,178,255,131,124,172,
255,123,115,163,255,119,117,169,255,110,109,161,255,64,65,86,255,30,34,46,255,
34,34,42,255,28,32,43,255,29,30,37,255,34,34,42,255,28,32,43,255,30,34,46,255,
24,25,32,255,24,25,32,255,29,30,37,255,24,25,32,255,29,30,37,255,29,30,37,255,
29,30,37,255,24,25,32,255,24,25,32,255,24,25,32,255,29,30,37,255,24,25,32,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,16,18,27,255,
23,22,25,255,24,25,32,255,16,18,27,255,24,25,32,255,23,22,25,255,24,25,32,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,
24,25,32,255,24,25,32,255,29,30,37,255,24,25,32,255,29,30,37,255,29,30,37,255,
24,25,32,255,23,22,25,255,29,30,37,255,24,25,32,255,24,25,32,255,29,30,37,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,
24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,
24,25,32,255,24,25,32,255,23,22,25,255,23,22,25,255,24,25,32,255,35,39,51,255,
29,30,37,255,30,34,46,255,34,34,42,255,30,34,46,255,30,34,46,255,34,34,42,255,
96,95,132,255,117,118,163,255,117,118,163,255,124,124,170,255,136,136,183,255,
145,142,177,255,141,141,167,255,157,158,178,255,186,190,212,255,215,213,240,255,
215,213,240,255,212,208,253,255,206,202,246,255,202,196,248,255,212,208,253,255,
202,196,248,255,212,208,253,255,206,202,246,255,188,185,222,255,188,185,222,255,
172,168,198,255,157,158,178,255,157,158,178,255,166,165,214,255,134,131,185,255,
134,131,185,255,128,125,178,255,128,125,178,255,134,131,185,255,143,140,194,255,
148,148,195,255,153,152,200,255,153,152,200,255,166,165,214,255,165,156,206,255,
169,165,207,255,173,173,221,255,167,163,218,255,159,158,206,255,174,166,191,255,
184,185,195,255,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,
1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,
6,9,0,112,108,148,0,166,157,194,255,162,158,200,255,173,165,215,255,167,163,
218,255,173,165,215,255,169,165,207,255,169,165,207,255,169,165,207,255,166,165,
214,255,159,158,206,255,162,158,200,255,166,165,214,255,159,158,206,255,167,163,
218,255,169,165,207,255,153,152,200,255,149,146,200,255,149,146,200,255,136,136,
183,255,138,135,189,255,138,135,189,255,143,140,194,255,143,140,194,255,143,140,
194,255,138,135,189,255,142,141,188,255,132,132,179,255,138,135,189,255,138,135,
189,255,141,140,200,255,134,131,185,255,141,140,200,255,149,146,200,255,143,140,
194,255,138,135,189,255,140,132,180,255,124,124,170,255,123,115,163,255,114,107,
154,255,71,72,102,255,34,34,42,255,30,34,46,255,30,34,46,255,29,30,37,255,30,34,
46,255,29,30,37,255,34,34,42,255,28,32,43,255,30,34,46,255,28,32,43,255,30,34,
46,255,29,30,37,255,29,30,37,255,34,34,42,255,34,34,42,255,35,39,51,255,34,34,
42,255,28,32,43,255,30,34,46,255,30,34,46,255,28,32,43,255,28,32,43,255,28,32,
43,255,28,32,43,255,34,34,42,255,28,32,43,255,29,30,37,255,34,34,42,255,29,30,
37,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,
43,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,
43,255,35,39,51,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,34,34,
42,255,0,30,41,255,28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,30,34,
46,255,28,32,43,255,28,32,43,255,29,30,37,255,34,34,42,255,29,30,37,255,30,34,
46,255,30,34,46,255,29,30,37,255,34,34,42,255,30,34,46,255,34,34,42,255,30,34,
46,255,34,34,42,255,28,32,43,255,34,34,42,255,30,34,46,255,35,39,51,255,28,32,
43,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,
37,255,28,32,43,255,28,32,43,255,28,32,43,255,29,30,37,255,34,34,42,255,28,32,
43,255,29,30,37,255,28,32,43,255,30,34,46,255,28,32,43,255,28,32,43,255,34,34,
42,255,34,34,42,255,38,42,54,255,96,95,132,255,110,109,161,255,124,124,170,255,
128,128,175,255,142,141,188,255,178,174,211,255,169,165,207,255,160,160,195,255,
166,166,201,255,188,185,222,255,186,190,212,255,206,202,246,255,212,208,253,255,
212,208,253,255,188,185,222,255,206,202,246,255,200,201,225,255,200,201,225,255,
204,199,237,255,200,201,225,255,172,168,198,255,169,165,207,255,154,151,205,255,
149,146,200,255,140,132,180,255,134,131,185,255,119,117,169,255,128,125,178,255,
134,131,185,255,143,140,194,255,155,147,196,255,153,152,200,255,162,158,200,255,
162,158,200,255,169,165,207,255,173,173,221,255,173,165,215,255,161,157,212,255,
160,160,195,255,168,170,187,255,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,
239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,
135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,166,166,201,255,162,158,200,255,
173,165,215,255,166,163,225,255,166,165,214,255,173,165,215,255,169,165,207,255,
169,165,207,255,165,156,206,255,161,157,212,255,161,157,212,255,166,165,214,255,
159,158,206,255,159,158,206,255,166,165,214,255,153,152,200,255,153,152,200,255,
154,151,205,255,148,148,195,255,138,135,189,255,142,141,188,255,143,140,194,255,
143,140,194,255,143,140,194,255,143,140,194,255,143,140,194,255,148,148,195,255,
149,146,200,255,143,140,194,255,141,140,200,255,141,140,200,255,141,140,200,255,
154,150,192,255,172,168,198,255,145,142,177,255,136,136,183,255,128,125,178,255,
119,117,169,255,114,107,154,255,71,72,102,255,34,34,42,255,34,34,42,255,30,34,
46,255,29,30,37,255,30,34,46,255,29,30,37,255,29,30,37,255,29,30,37,255,29,30,
37,255,34,34,42,255,30,34,46,255,30,34,46,255,29,30,37,255,30,34,46,255,29,30,
37,255,28,32,43,255,34,34,42,255,34,34,42,255,29,30,37,255,34,34,42,255,30,34,
46,255,29,30,37,255,29,30,37,255,29,30,37,255,35,39,51,255,28,32,43,255,29,30,
37,255,35,39,51,255,34,34,42,255,35,39,51,255,28,32,43,255,28,32,43,255,29,30,
37,255,28,32,43,255,29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,29,30,
37,255,29,30,37,255,29,30,37,255,29,30,37,255,0,30,41,255,34,34,42,255,28,32,
43,255,28,32,43,255,29,30,37,255,34,34,42,255,29,30,37,255,28,32,43,255,34,34,
42,255,28,32,43,255,28,32,43,255,34,34,42,255,28,32,43,255,28,32,43,255,30,34,
46,255,34,34,42,255,28,32,43,255,28,32,43,255,30,34,46,255,34,34,42,255,28,32,
43,255,29,30,37,255,30,34,46,255,29,30,37,255,28,32,43,255,30,34,46,255,29,30,
37,255,29,30,37,255,34,34,42,255,35,39,51,255,28,32,43,255,35,39,51,255,29,30,
37,255,28,32,43,255,34,34,42,255,29,30,37,255,29,30,37,255,35,39,51,255,28,32,
43,255,35,39,51,255,30,34,46,255,30,34,46,255,34,34,42,255,35,39,51,255,28,32,
43,255,30,34,46,255,29,30,37,255,29,30,37,255,38,42,54,255,85,86,118,255,119,
117,169,255,119,117,169,255,124,124,170,255,138,135,189,255,169,165,207,255,162,
158,200,255,166,165,214,255,173,173,221,255,173,173,221,255,186,190,212,255,166,
166,201,255,186,190,212,255,200,201,225,255,212,208,253,255,215,213,240,255,200,
201,225,255,204,199,237,255,204,199,237,255,188,185,222,255,160,160,195,255,159,
158,206,255,169,165,207,255,154,151,205,255,128,128,175,255,128,128,175,255,128,
125,178,255,128,125,178,255,141,140,200,255,141,140,200,255,149,146,200,255,149,
148,209,255,161,157,212,255,166,165,214,255,165,156,206,255,166,165,214,255,173,
173,221,255,165,156,206,255,160,158,188,255,177,177,187,255,184,185,195,0,184,
185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,
0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,
173,165,202,255,169,165,207,255,165,156,206,255,161,157,212,255,173,165,215,255,
166,165,214,255,167,163,218,255,154,151,205,255,149,148,209,255,154,151,205,255,
149,146,200,255,154,151,205,255,166,165,214,255,166,165,214,255,159,158,206,255,
159,158,206,255,161,157,212,255,153,152,200,255,166,165,214,255,149,146,200,255,
143,140,194,255,148,148,195,255,143,140,194,255,143,140,194,255,154,151,205,255,
143,140,194,255,143,140,194,255,143,140,194,255,149,148,209,255,141,140,200,255,
143,140,194,255,153,152,200,255,229,230,244,255,220,221,234,255,220,221,234,255,
157,158,178,255,129,126,165,255,123,115,163,255,110,109,161,255,71,72,102,255,
35,39,51,255,30,34,46,255,30,34,46,255,30,34,46,255,29,30,37,255,28,32,43,255,
30,34,46,255,30,34,46,255,28,32,43,255,29,30,37,255,29,30,37,255,30,34,46,255,
30,34,46,255,29,30,37,255,30,34,46,255,30,34,46,255,29,30,37,255,28,32,43,255,
34,34,42,255,29,30,37,255,29,30,37,255,28,32,43,255,35,39,51,255,28,32,43,255,
29,30,37,255,35,39,51,255,28,32,43,255,29,30,37,255,35,39,51,255,30,34,46,255,
34,34,42,255,30,34,46,255,28,32,43,255,34,34,42,255,30,34,46,255,30,34,46,255,
29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,34,34,42,255,
29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,
28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,29,30,37,255,30,34,46,255,
29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,
24,25,32,255,28,32,43,255,29,30,37,255,30,34,46,255,28,32,43,255,28,32,43,255,
30,34,46,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,
29,30,37,255,28,32,43,255,30,34,46,255,28,32,43,255,29,30,37,255,30,34,46,255,
30,34,46,255,29,30,37,255,29,30,37,255,29,30,37,255,29,30,37,255,34,34,42,255,
28,32,43,255,28,32,43,255,30,34,46,255,29,30,37,255,35,39,51,255,28,32,43,255,
50,51,59,255,85,86,118,255,119,117,169,255,119,117,169,255,124,124,170,255,136,
136,183,255,148,148,195,255,145,142,177,255,141,141,167,255,139,141,157,255,160,
160,195,255,186,190,212,255,186,190,212,255,186,190,212,255,186,190,212,255,206,
202,246,255,188,185,222,255,188,185,222,255,188,185,222,255,188,185,222,255,173,
173,221,255,160,160,195,255,141,141,167,255,145,142,177,255,142,141,188,255,128,
128,175,255,128,125,178,255,128,125,178,255,134,131,185,255,138,135,189,255,138,
135,189,255,141,140,200,255,149,146,200,255,143,140,194,255,154,151,205,255,169,
165,207,255,178,173,216,255,167,163,218,255,162,158,200,255,174,166,191,255,177,
177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,173,165,202,255,169,165,207,255,173,165,215,255,167,
163,218,255,167,163,218,255,169,165,207,255,167,163,218,255,154,151,205,255,154,
151,205,255,166,157,194,255,154,151,205,255,149,146,200,255,166,165,214,255,166,
165,214,255,166,165,214,255,159,158,206,255,166,165,214,255,159,158,206,255,166,
165,214,255,173,173,221,255,173,173,221,255,159,158,206,255,153,152,200,255,148,
148,195,255,148,148,195,255,148,148,195,255,148,148,195,255,143,140,194,255,141,
140,200,255,141,140,200,255,143,140,194,255,178,174,211,255,191,194,208,255,183,
187,202,255,184,185,195,255,191,194,208,255,119,117,156,255,117,118,163,255,110,
109,161,255,85,86,118,255,34,34,42,255,30,34,46,255,30,34,46,255,30,34,46,255,
28,32,43,255,29,30,37,255,29,30,37,255,34,34,42,255,28,32,43,255,30,34,46,255,
29,30,37,255,28,32,43,255,30,34,46,255,34,34,42,255,29,30,37,255,30,34,46,255,
29,30,37,255,28,32,43,255,30,34,46,255,30,34,46,255,34,34,42,255,29,30,37,255,
29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,
34,34,42,255,35,39,51,255,34,34,42,255,34,34,42,255,28,32,43,255,29,30,37,255,
29,30,37,255,28,32,43,255,28,32,43,255,24,25,32,255,24,25,32,255,29,30,37,255,
28,32,43,255,24,25,32,255,29,30,37,255,28,32,43,255,24,25,32,255,30,34,46,255,
29,30,37,255,29,30,37,255,28,32,43,255,29,30,37,255,29,30,37,255,28,32,43,255,
29,30,37,255,28,32,43,255,29,30,37,255,29,30,37,255,24,25,32,255,28,32,43,255,
29,30,37,255,29,30,37,255,24,25,32,255,28,32,43,255,29,30,37,255,29,30,37,255,
28,32,43,255,29,30,37,255,29,30,37,255,29,30,37,255,35,39,51,255,29,30,37,255,
29,30,37,255,30,34,46,255,29,30,37,255,34,34,42,255,28,32,43,255,28,32,43,255,
28,32,43,255,30,34,46,255,28,32,43,255,28,32,43,255,30,34,46,255,28,32,43,255,
29,30,37,255,29,30,37,255,34,34,42,255,30,34,46,255,30,34,46,255,28,32,43,255,
34,34,42,255,28,32,43,255,35,39,51,255,111,110,143,255,119,117,169,255,128,125,
178,255,128,125,178,255,132,132,179,255,145,142,177,255,175,177,194,255,166,166,
201,255,178,174,211,255,204,199,237,255,173,173,221,255,148,148,195,255,166,166,
201,255,188,184,235,255,188,185,222,255,188,185,222,255,166,166,201,255,166,166,
201,255,160,160,195,255,145,142,177,255,160,160,195,255,178,174,211,255,166,165,
214,255,158,156,218,255,128,125,178,255,119,117,169,255,134,131,185,255,141,140,
200,255,141,140,200,255,141,140,200,255,178,173,216,255,199,194,238,255,143,140,
194,255,149,148,209,255,165,156,206,255,173,165,215,255,166,165,214,255,160,160,
195,255,168,170,187,255,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,
0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,
194,255,162,158,200,255,161,157,212,255,173,165,215,255,167,163,218,255,173,165,
215,255,154,151,205,255,161,157,212,255,173,165,215,255,154,151,205,255,154,151,
205,255,161,157,212,255,166,165,214,255,173,173,221,255,173,173,221,255,166,165,
214,255,166,165,214,255,166,165,214,255,166,165,214,255,166,165,214,255,173,173,
221,255,188,184,235,255,173,173,221,255,173,173,221,255,161,157,212,255,148,148,
195,255,143,140,194,255,143,140,194,255,134,131,185,255,143,140,194,255,172,168,
198,255,184,185,195,255,177,177,187,255,175,177,194,255,177,177,187,255,111,110,
143,255,123,115,163,255,110,109,161,255,96,95,132,255,38,42,54,255,29,30,37,255,
34,34,42,255,30,34,46,255,34,34,42,255,30,34,46,255,29,30,37,255,28,32,43,255,
29,30,37,255,29,30,37,255,28,32,43,255,29,30,37,255,30,34,46,255,28,32,43,255,
30,34,46,255,29,30,37,255,30,34,46,255,29,30,37,255,29,30,37,255,29,30,37,255,
28,32,43,255,29,30,37,255,30,34,46,255,29,30,37,255,28,32,43,255,29,30,37,255,
34,34,42,255,35,39,51,255,34,34,42,255,34,34,42,255,35,39,51,255,35,39,51,255,
34,34,42,255,30,34,46,255,35,39,51,255,34,34,42,255,34,34,42,255,28,32,43,255,
28,32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,29,30,37,255,24,25,32,255,
28,32,43,255,24,25,32,255,29,30,37,255,28,32,43,255,24,25,32,255,28,32,43,255,
28,32,43,255,24,25,32,255,28,32,43,255,24,25,32,255,29,30,37,255,24,25,32,255,
28,32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,28,32,43,255,24,25,32,255,
28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,30,34,46,255,28,32,43,255,
29,30,37,255,28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,30,34,46,255,
28,32,43,255,30,34,46,255,28,32,43,255,29,30,37,255,34,34,42,255,28,32,43,255,
34,34,42,255,29,30,37,255,28,32,43,255,30,34,46,255,28,32,43,255,28,32,43,255,
30,34,46,255,28,32,43,255,28,32,43,255,28,32,43,255,35,39,51,255,110,109,161,
255,117,118,163,255,128,125,178,255,128,125,178,255,136,136,183,255,173,173,221,
255,148,148,195,255,148,148,195,255,166,166,201,255,166,165,214,255,173,173,221,
255,173,173,221,255,160,160,195,255,166,166,201,255,89,131,175,255,160,160,195,
255,166,166,201,255,178,174,211,255,167,163,218,255,161,157,212,255,161,157,212,
255,149,146,200,255,143,140,194,255,138,135,189,255,128,125,178,255,128,125,178,
255,134,131,185,255,138,135,189,255,143,140,194,255,143,140,194,255,149,148,209,
255,165,156,206,255,141,140,200,255,161,157,212,255,166,165,214,255,166,165,214,
255,159,158,206,255,160,158,188,255,175,177,194,255,177,177,187,0,184,185,195,0,
184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,
148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,
0,173,165,202,0,166,157,194,0,166,166,201,255,159,158,206,255,173,165,215,255,
161,157,212,255,167,163,218,255,161,157,212,255,154,151,205,255,158,156,218,255,
158,156,218,255,166,165,214,255,166,165,214,255,166,165,214,255,166,165,214,255,
173,173,221,255,166,165,214,255,166,165,214,255,167,163,218,255,166,165,214,255,
166,165,214,255,166,165,214,255,166,165,214,255,159,158,206,255,159,158,206,255,
167,163,218,255,173,173,221,255,159,158,206,255,161,157,212,255,141,140,200,255,
134,131,185,255,145,142,177,255,168,170,187,255,169,170,180,255,175,177,194,255,
139,141,157,255,114,107,154,255,123,115,163,255,110,109,161,255,109,109,154,255,
35,39,51,255,30,34,46,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,
29,30,37,255,28,32,43,255,28,32,43,255,29,30,37,255,29,30,37,255,29,30,37,255,
29,30,37,255,29,30,37,255,30,34,46,255,29,30,37,255,30,34,46,255,28,32,43,255,
30,34,46,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,23,22,25,255,
23,22,25,255,24,25,32,255,18,16,20,255,24,25,32,255,29,30,37,255,23,22,25,255,
23,22,25,255,24,25,32,255,24,25,32,255,16,18,27,255,18,16,20,255,16,18,27,255,
18,16,20,255,1,6,9,255,16,18,27,255,28,32,43,255,16,18,27,255,1,6,9,255,16,18,
27,255,16,18,27,255,18,16,20,255,16,18,27,255,16,18,27,255,29,30,37,255,24,25,
32,255,28,32,43,255,28,32,43,255,24,25,32,255,29,30,37,255,28,32,43,255,28,32,
43,255,24,25,32,255,28,32,43,255,28,32,43,255,24,25,32,255,24,25,32,255,28,32,
43,255,24,25,32,255,29,30,37,255,28,32,43,255,29,30,37,255,29,30,37,255,28,32,
43,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,29,30,37,255,29,30,
37,255,29,30,37,255,34,34,42,255,28,32,43,255,30,34,46,255,30,34,46,255,29,30,
37,255,34,34,42,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,29,30,
37,255,28,32,43,255,34,34,42,255,29,30,37,255,29,30,37,255,29,30,37,255,38,42,
54,255,124,124,170,255,128,125,178,255,128,125,178,255,138,135,189,255,138,135,
189,255,148,148,195,255,162,158,200,255,160,160,195,255,148,148,195,255,145,142,
177,255,141,141,167,255,141,141,167,255,160,160,195,255,178,174,211,255,173,173,
221,255,173,173,221,255,161,157,212,255,154,151,205,255,149,146,200,255,143,140,
194,255,143,140,194,255,143,140,194,255,128,128,175,255,134,131,185,255,134,131,
185,255,134,131,185,255,141,140,200,255,149,146,200,255,155,147,196,255,154,151,
205,255,149,148,209,255,149,148,209,255,155,147,196,255,167,163,218,255,167,163,
218,255,161,157,212,255,162,158,200,255,174,166,191,255,175,177,194,0,177,177,
187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,
180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,
0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,173,165,202,
255,165,156,206,255,173,165,215,255,173,165,215,255,173,165,215,255,167,163,218,
255,165,156,206,255,165,156,206,255,169,165,207,255,169,165,207,255,178,173,216,
255,178,173,216,255,166,165,214,255,173,173,221,255,166,165,214,255,166,165,214,
255,166,165,214,255,166,165,214,255,166,165,214,255,166,165,214,255,166,165,214,
255,166,165,214,255,153,152,200,255,149,146,200,255,149,146,200,255,143,140,194,
255,149,146,200,255,149,146,200,255,138,135,189,255,129,126,165,255,122,124,142,
255,128,121,147,255,117,118,163,255,119,117,169,255,119,117,169,255,119,117,169,
255,123,115,163,255,64,65,86,255,30,34,46,255,30,34,46,255,30,34,46,255,30,34,
46,255,29,30,37,255,29,30,37,255,29,30,37,255,34,34,42,255,30,34,46,255,28,32,
43,255,30,34,46,255,28,32,43,255,30,34,46,255,28,32,43,255,28,32,43,255,29,30,
37,255,28,32,43,255,29,30,37,255,30,34,46,255,28,32,43,255,24,25,32,255,110,
110,118,255,183,187,202,255,169,170,180,255,54,52,55,255,191,194,208,255,67,66,
72,255,81,81,88,255,178,176,180,255,50,51,59,255,208,208,221,255,67,66,72,255,
208,208,221,255,191,194,208,255,54,52,55,255,110,110,118,255,177,177,187,255,
158,159,169,255,38,36,40,255,142,141,151,255,169,170,180,255,142,141,151,255,81,
81,88,255,142,141,151,255,67,66,72,255,1,6,9,255,67,66,72,255,18,16,20,255,38,
36,40,255,67,66,72,255,81,81,88,255,50,51,59,255,38,36,40,255,16,18,27,255,54,
52,55,255,38,36,40,255,50,51,59,255,1,6,9,255,50,51,59,255,16,18,27,255,24,25,
32,255,50,51,59,255,67,66,72,255,67,66,72,255,67,66,72,255,54,52,55,255,67,66,
72,255,81,81,88,255,38,36,40,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,
43,255,29,30,37,255,28,32,43,255,28,32,43,255,34,34,42,255,28,32,43,255,28,32,
43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,
43,255,28,32,43,255,28,32,43,255,28,32,43,255,30,34,46,255,79,80,102,255,128,
125,178,255,128,125,178,255,138,135,189,255,138,135,189,255,138,135,189,255,117,
118,163,255,117,118,163,255,141,141,167,255,166,166,201,255,166,165,214,255,166,
165,214,255,173,173,221,255,167,163,218,255,154,151,205,255,141,140,200,255,143,
140,194,255,142,141,188,255,143,140,194,255,142,141,188,255,143,140,194,255,142,
141,188,255,128,125,178,255,134,131,185,255,134,131,185,255,134,131,185,255,141,
140,200,255,149,148,209,255,149,146,200,255,149,146,200,255,165,156,206,255,162,
158,200,255,165,156,206,255,167,163,218,255,166,165,214,255,167,163,218,255,159,
158,206,255,166,166,201,255,157,158,178,255,175,177,194,0,177,177,187,0,184,185,
195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,
112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,
108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,166,166,201,255,169,165,207,
255,166,165,214,255,173,165,215,255,173,165,215,255,173,165,215,255,166,165,214,
255,167,163,218,255,166,165,214,255,173,173,221,255,173,173,221,255,175,171,227,
255,167,163,218,255,167,163,218,255,166,165,214,255,167,163,218,255,167,163,218,
255,159,158,206,255,166,165,214,255,166,165,214,255,159,158,206,255,161,157,212,
255,154,151,205,255,153,152,200,255,148,148,195,255,149,146,200,255,143,140,194,
255,138,135,189,255,141,140,200,255,128,125,178,255,128,125,178,255,119,117,169,
255,128,125,178,255,119,117,169,255,119,117,169,255,128,125,178,255,128,125,178,
255,112,108,148,255,38,42,54,255,30,34,46,255,34,34,42,255,30,34,46,255,30,34,
46,255,28,32,43,255,28,32,43,255,29,30,37,255,29,30,37,255,29,30,37,255,29,30,
37,255,28,32,43,255,28,32,43,255,34,34,42,255,28,32,43,255,30,34,46,255,30,34,
46,255,29,30,37,255,29,30,37,255,24,25,32,255,81,81,88,255,142,141,151,255,16,
18,27,255,1,6,9,255,110,110,118,255,184,185,195,255,110,110,118,255,139,141,
157,255,208,208,221,255,142,141,151,255,208,208,221,255,110,110,118,255,178,176,
180,255,81,81,88,255,18,16,20,255,139,141,157,255,110,110,118,255,184,185,195,
255,142,141,151,255,81,81,88,255,67,66,72,255,158,159,169,255,184,185,195,255,
142,141,151,255,1,6,9,255,50,51,59,255,169,170,180,255,110,110,118,255,125,125,
134,255,110,110,118,255,81,81,88,255,183,187,202,255,169,170,180,255,29,30,37,
255,158,159,169,255,142,141,151,255,168,170,187,255,54,52,55,255,184,185,195,
255,125,125,134,255,67,66,72,255,168,170,187,255,158,159,169,255,81,81,88,255,
139,141,157,255,158,159,169,255,158,159,169,255,94,94,102,255,38,36,40,255,28,
32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,29,30,37,255,34,34,42,255,28,
32,43,255,30,34,46,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,29,
30,37,255,30,34,46,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,28,
32,43,255,30,34,46,255,117,118,163,255,128,125,178,255,128,125,178,255,141,140,
200,255,138,135,189,255,141,140,200,255,154,151,205,255,148,148,195,255,159,158,
206,255,149,146,200,255,143,140,194,255,141,140,200,255,138,135,189,255,138,135,
189,255,141,140,200,255,143,140,194,255,143,140,194,255,143,140,194,255,143,140,
194,255,143,140,194,255,138,135,189,255,138,135,189,255,138,135,189,255,138,135,
189,255,134,131,185,255,141,140,200,255,149,146,200,255,154,151,205,255,159,158,
206,255,165,156,206,255,154,151,205,255,159,158,206,255,166,165,214,255,173,165,
215,255,161,157,212,255,167,163,218,255,162,158,200,255,160,158,188,255,168,170,
187,255,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,
132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,
148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,
0,166,166,201,0,172,168,198,255,173,165,202,255,169,165,207,255,173,165,215,
255,173,165,215,255,173,173,221,255,175,171,227,255,173,165,215,255,173,165,215,
255,166,165,214,255,173,173,221,255,173,173,221,255,166,163,225,255,158,156,218,
255,158,156,218,255,161,157,212,255,161,157,212,255,167,163,218,255,167,163,218,
255,167,163,218,255,161,157,212,255,161,157,212,255,161,157,212,255,154,151,205,
255,154,151,205,255,149,146,200,255,149,146,200,255,149,146,200,255,149,146,200,
255,149,146,200,255,138,135,189,255,138,135,189,255,134,131,185,255,128,125,178,
255,134,131,185,255,119,117,169,255,128,125,178,255,134,131,185,255,79,80,102,
255,34,34,42,255,30,34,46,255,29,30,37,255,29,30,37,255,29,30,37,255,30,34,46,
255,28,32,43,255,28,32,43,255,28,32,43,255,29,30,37,255,29,30,37,255,29,30,37,
255,29,30,37,255,29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,30,34,46,
255,28,32,43,255,110,110,118,255,94,94,102,255,142,141,151,255,169,170,180,255,
184,185,195,255,184,185,195,255,158,159,169,255,178,176,180,255,167,164,169,255,
178,176,180,255,167,164,169,255,167,164,169,255,167,164,169,255,94,94,102,255,
18,16,20,255,184,185,195,255,110,110,118,255,175,177,194,255,169,170,180,255,
34,34,42,255,67,66,72,255,142,141,151,255,177,177,187,255,23,22,25,255,18,16,
20,255,158,159,169,255,50,51,59,255,158,159,169,255,158,159,169,255,94,94,102,
255,67,66,72,255,184,185,195,255,110,110,118,255,177,177,187,255,122,124,142,
255,142,141,151,255,67,66,72,255,142,141,151,255,158,159,169,255,81,81,88,255,
183,187,202,255,158,159,169,255,142,141,151,255,54,52,55,255,125,125,134,255,
158,159,169,255,142,141,151,255,81,81,88,255,23,22,25,255,24,25,32,255,29,30,37,
255,29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,
255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,
255,30,34,46,255,29,30,37,255,24,25,32,255,28,32,43,255,28,32,43,255,85,86,118,
255,141,140,200,255,134,131,185,255,141,140,200,255,138,135,189,255,143,140,194,
255,143,140,194,255,141,140,200,255,138,135,189,255,141,140,200,255,128,125,178,
255,128,125,178,255,134,131,185,255,134,131,185,255,134,131,185,255,138,135,189,
255,138,135,189,255,143,140,194,255,138,135,189,255,138,135,189,255,138,135,189,
255,138,135,189,255,138,135,189,255,134,131,185,255,138,135,189,255,141,140,200,
255,149,148,209,255,165,156,206,255,166,165,214,255,169,165,207,255,166,165,214,
255,166,165,214,255,173,165,215,255,166,165,214,255,161,157,212,255,167,163,218,
255,165,156,206,255,173,165,202,255,157,158,178,255,168,170,187,0,175,177,194,0,
177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,
18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,
16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,
168,198,0,166,157,194,255,173,165,202,255,178,173,216,255,178,173,216,255,169,
165,207,255,178,173,216,255,173,173,221,255,173,165,215,255,173,165,215,255,173,
165,215,255,165,156,206,255,165,156,206,255,149,146,200,255,149,148,209,255,149,
148,209,255,158,156,218,255,158,156,218,255,161,157,212,255,161,157,212,255,149,
148,209,255,154,151,205,255,149,148,209,255,158,156,218,255,154,151,205,255,154,
151,205,255,154,151,205,255,153,152,200,255,153,152,200,255,153,152,200,255,155,
147,196,255,145,141,183,255,143,140,194,255,140,132,180,255,138,135,189,255,134,
131,185,255,132,132,179,255,134,131,185,255,138,135,189,255,64,65,86,255,35,39,
51,255,30,34,46,255,30,34,46,255,34,34,42,255,34,34,42,255,29,30,37,255,29,30,
37,255,28,32,43,255,30,34,46,255,30,34,46,255,28,32,43,255,29,30,37,255,29,30,
37,255,29,30,37,255,29,30,37,255,29,30,37,255,29,30,37,255,28,32,43,255,38,36,
40,255,169,170,180,255,177,177,187,255,191,194,208,255,110,110,118,255,38,36,
40,255,191,194,208,255,125,125,134,255,110,110,118,255,94,94,102,255,142,141,
151,255,177,177,187,255,184,185,195,255,142,141,151,255,1,6,9,255,208,208,221,
255,158,159,169,255,158,159,169,255,81,81,88,255,168,170,187,255,169,170,180,
255,50,51,59,255,184,185,195,255,1,6,9,255,38,36,40,255,94,94,102,255,67,66,72,
255,38,36,40,255,94,94,102,255,94,94,102,255,94,94,102,255,35,39,51,255,1,6,9,
255,94,94,102,255,81,81,88,255,94,94,102,255,23,22,25,255,81,81,88,255,81,81,88,
255,1,6,9,255,50,51,59,255,67,66,72,255,94,94,102,255,110,110,118,255,94,94,102,
255,81,81,88,255,110,110,118,255,110,110,118,255,54,52,55,255,24,25,32,255,28,
32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,29,30,37,255,29,
30,37,255,29,30,37,255,29,30,37,255,30,34,46,255,30,34,46,255,28,32,43,255,28,
32,43,255,30,34,46,255,30,34,46,255,28,32,43,255,28,32,43,255,79,80,102,255,
136,136,183,255,134,131,185,255,134,131,185,255,141,140,200,255,141,140,200,255,
149,148,209,255,143,140,194,255,143,140,194,255,141,140,200,255,141,140,200,255,
141,140,200,255,138,135,189,255,141,140,200,255,138,135,189,255,134,131,185,255,
134,131,185,255,138,135,189,255,138,135,189,255,141,140,200,255,138,135,189,255,
138,135,189,255,141,140,200,255,138,135,189,255,141,140,200,255,149,148,209,255,
161,157,212,255,165,156,206,255,169,165,207,255,173,173,221,255,173,173,221,255,
173,165,215,255,173,173,221,255,173,165,215,255,167,163,218,255,165,156,206,255,
162,158,200,255,160,160,195,255,160,158,188,255,157,158,178,0,168,170,187,0,175,
177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,
0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,
201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,
165,207,0,178,173,216,255,178,173,216,255,173,165,215,255,173,165,215,255,173,
165,215,255,167,163,218,255,166,165,214,255,148,148,195,255,138,135,189,255,138,
135,189,255,138,135,189,255,149,146,200,255,149,148,209,255,158,156,218,255,154,
151,205,255,141,140,200,255,143,140,194,255,141,140,200,255,149,148,209,255,149,
148,209,255,154,151,205,255,149,148,209,255,154,151,205,255,154,151,205,255,153,
152,200,255,154,151,205,255,155,147,196,255,149,146,200,255,155,147,196,255,148,
148,195,255,149,146,200,255,143,140,194,255,138,135,189,255,148,140,188,255,96,
95,132,255,34,34,42,255,35,39,51,255,28,32,43,255,29,30,37,255,30,34,46,255,30,
34,46,255,29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,30,
34,46,255,28,32,43,255,28,32,43,255,28,32,43,255,29,30,37,255,29,30,37,255,29,
30,37,255,16,18,27,255,24,25,32,255,18,16,20,255,18,16,20,255,16,18,27,255,24,
25,32,255,23,22,25,255,1,6,9,255,18,16,20,255,1,6,9,255,23,22,25,255,23,22,25,
255,18,16,20,255,1,6,9,255,16,18,27,255,23,22,25,255,1,6,9,255,16,18,27,255,23,
22,25,255,16,18,27,255,18,16,20,255,16,18,27,255,18,16,20,255,29,30,37,255,23,
22,25,255,0,30,41,255,29,30,37,255,29,30,37,255,24,25,32,255,29,30,37,255,29,
30,37,255,29,30,37,255,24,25,32,255,24,25,32,255,28,32,43,255,24,25,32,255,28,
32,43,255,28,32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,24,25,32,255,24,
25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,16,18,27,255,28,32,43,255,28,
32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,28,
32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,29,30,37,255,29,30,37,255,29,
30,37,255,34,34,42,255,30,34,46,255,30,34,46,255,34,34,42,255,85,86,118,255,
155,147,196,255,138,135,189,255,138,135,189,255,141,140,200,255,141,140,200,255,
141,140,200,255,143,140,194,255,149,148,209,255,149,146,200,255,149,146,200,255,
143,140,194,255,141,140,200,255,141,140,200,255,141,140,200,255,138,135,189,255,
141,140,200,255,149,146,200,255,149,146,200,255,143,140,194,255,143,140,194,255,
141,140,200,255,138,135,189,255,141,140,200,255,149,148,209,255,149,148,209,255,
166,165,214,255,169,165,207,255,173,173,221,255,173,173,221,255,167,163,218,255,
173,165,215,255,166,165,214,255,161,157,212,255,159,158,206,255,162,158,200,255,
155,151,186,255,160,158,188,255,157,158,178,255,160,158,188,0,157,158,178,0,168,
170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,
0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,
108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,
194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,173,216,0,178,
173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,216,255,173,173,221,
255,173,173,221,255,161,157,212,255,161,157,212,255,166,165,214,255,159,158,206,
255,154,151,205,255,149,146,200,255,153,152,200,255,154,151,205,255,149,148,209,
255,143,140,194,255,138,135,189,255,138,135,189,255,138,135,189,255,149,146,200,
255,149,148,209,255,154,151,205,255,141,140,200,255,141,140,200,255,149,148,209,
255,149,146,200,255,149,146,200,255,149,146,200,255,149,146,200,255,149,146,200,
255,153,152,200,255,153,152,200,255,155,147,196,255,143,140,194,255,142,141,188,
255,138,135,189,255,129,126,165,255,79,80,102,255,46,49,63,255,34,34,42,255,34,
34,42,255,35,39,51,255,30,34,46,255,30,34,46,255,28,32,43,255,29,30,37,255,29,
30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,30,34,46,255,28,
32,43,255,29,30,37,255,30,34,46,255,30,34,46,255,28,32,43,255,29,30,37,255,28,
32,43,255,24,25,32,255,29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,24,
25,32,255,29,30,37,255,29,30,37,255,29,30,37,255,28,32,43,255,28,32,43,255,34,
34,42,255,28,32,43,255,29,30,37,255,29,30,37,255,29,30,37,255,29,30,37,255,28,
32,43,255,28,32,43,255,24,25,32,255,29,30,37,255,24,25,32,255,28,32,43,255,28,
32,43,255,29,30,37,255,29,30,37,255,24,25,32,255,28,32,43,255,24,25,32,255,28,
32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,29,30,37,255,24,25,32,255,28,
32,43,255,28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,28,32,43,255,28,
32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,
32,43,255,28,32,43,255,28,32,43,255,30,34,46,255,29,30,37,255,30,34,46,255,30,
34,46,255,30,34,46,255,30,34,46,255,30,34,46,255,34,34,42,255,64,65,86,255,129,
126,165,255,148,148,195,255,143,140,194,255,143,140,194,255,143,140,194,255,141,
140,200,255,141,140,200,255,141,140,200,255,141,140,200,255,149,146,200,255,149,
146,200,255,149,146,200,255,149,146,200,255,149,148,209,255,149,146,200,255,149,
148,209,255,149,148,209,255,149,148,209,255,149,148,209,255,143,140,194,255,149,
146,200,255,149,146,200,255,158,156,218,255,158,156,218,255,167,163,218,255,166,
165,214,255,166,165,214,255,167,163,218,255,166,165,214,255,167,163,218,255,173,
165,215,255,166,165,214,255,159,158,206,255,162,158,200,255,162,158,200,255,154,
150,192,255,155,151,186,255,141,141,167,255,160,158,188,255,157,158,178,0,160,
158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,
184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,
148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,
0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,
165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,174,211,255,178,173,216,255,178,173,216,255,178,173,216,255,
173,165,215,255,161,157,212,255,161,157,212,255,159,158,206,255,165,156,206,255,
166,165,214,255,159,158,206,255,159,158,206,255,155,147,196,255,155,147,196,255,
149,146,200,255,149,146,200,255,149,146,200,255,143,140,194,255,140,132,180,255,
138,135,189,255,138,135,189,255,141,140,200,255,149,148,209,255,154,151,205,255,
154,151,205,255,154,151,205,255,154,151,205,255,165,156,206,255,159,158,206,255,
154,151,205,255,148,140,188,255,138,135,189,255,134,131,185,255,138,135,189,255,
138,135,189,255,119,117,156,255,92,92,112,255,52,55,78,255,38,42,54,255,34,34,
42,255,30,34,46,255,35,39,51,255,30,34,46,255,30,34,46,255,28,32,43,255,28,32,
43,255,28,32,43,255,28,32,43,255,29,30,37,255,28,32,43,255,30,34,46,255,29,30,
37,255,29,30,37,255,24,25,32,255,24,25,32,255,28,32,43,255,28,32,43,255,24,25,
32,255,24,25,32,255,24,25,32,255,28,32,43,255,28,32,43,255,29,30,37,255,24,25,
32,255,28,32,43,255,28,32,43,255,28,32,43,255,24,25,32,255,28,32,43,255,28,32,
43,255,24,25,32,255,24,25,32,255,24,25,32,255,24,25,32,255,29,30,37,255,28,32,
43,255,28,32,43,255,29,30,37,255,24,25,32,255,28,32,43,255,28,32,43,255,28,32,
43,255,24,25,32,255,28,32,43,255,24,25,32,255,28,32,43,255,24,25,32,255,28,32,
43,255,24,25,32,255,28,32,43,255,28,32,43,255,24,25,32,255,28,32,43,255,28,32,
43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,28,32,
43,255,30,34,46,255,30,34,46,255,30,34,46,255,30,34,46,255,28,32,43,255,34,34,
42,255,35,39,51,255,34,34,42,255,34,34,42,255,46,49,63,255,64,65,86,255,111,
110,143,255,145,142,177,255,153,152,200,255,148,140,188,255,143,140,194,255,143,
140,194,255,154,151,205,255,154,151,205,255,154,151,205,255,149,148,209,255,149,
148,209,255,149,148,209,255,149,146,200,255,161,157,212,255,161,157,212,255,161,
157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,149,
148,209,255,149,146,200,255,143,140,194,255,154,151,205,255,167,163,218,255,167,
163,218,255,166,165,214,255,167,163,218,255,167,163,218,255,167,163,218,255,166,
165,214,255,167,163,218,255,165,156,206,255,162,158,200,255,162,158,200,255,166,
157,194,255,155,151,186,255,160,158,188,255,157,158,178,255,157,158,178,255,141,
141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,
175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,
39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,
201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,
165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,
178,173,216,0,178,173,216,255,178,173,216,255,166,165,214,255,167,163,218,255,
161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,
161,157,212,255,159,158,206,255,159,158,206,255,161,157,212,255,154,151,205,255,
149,146,200,255,142,141,188,255,143,140,194,255,143,140,194,255,141,140,200,255,
141,140,200,255,149,148,209,255,149,146,200,255,154,151,205,255,154,151,205,255,
159,158,206,255,161,157,212,255,161,157,212,255,154,151,205,255,141,140,200,255,
143,140,194,255,138,135,189,255,138,135,189,255,138,135,189,255,143,140,194,255,
155,147,196,255,148,148,195,255,129,126,165,255,92,92,112,255,79,80,102,255,46,
49,63,255,30,34,46,255,30,34,46,255,30,34,46,255,30,34,46,255,30,34,46,255,28,
32,43,255,30,34,46,255,28,32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,24,
25,32,255,24,25,32,255,28,32,43,255,28,32,43,255,24,25,32,255,24,25,32,255,24,
25,32,255,28,32,43,255,0,30,41,255,24,25,32,255,24,25,32,255,24,25,32,255,28,
32,43,255,28,32,43,255,24,25,32,255,28,32,43,255,28,32,43,255,28,32,43,255,29,
30,37,255,28,32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,24,25,32,255,24,
25,32,255,24,25,32,255,24,25,32,255,28,32,43,255,24,25,32,255,28,32,43,255,24,
25,32,255,28,32,43,255,24,25,32,255,28,32,43,255,24,25,32,255,24,25,32,255,28,
32,43,255,29,30,37,255,29,30,37,255,28,32,43,255,29,30,37,255,30,34,46,255,29,
30,37,255,28,32,43,255,29,30,37,255,34,34,42,255,30,34,46,255,34,34,42,255,35,
39,51,255,35,39,51,255,35,39,51,255,38,42,54,255,79,80,102,255,96,95,132,255,
119,117,156,255,142,141,188,255,138,135,189,255,141,140,200,255,143,140,194,255,
141,140,200,255,149,146,200,255,153,152,200,255,154,151,205,255,153,152,200,255,
154,151,205,255,149,146,200,255,149,148,209,255,149,148,209,255,149,148,209,255,
149,148,209,255,149,146,200,255,161,157,212,255,161,157,212,255,167,163,218,255,
167,163,218,255,167,163,218,255,166,165,214,255,161,157,212,255,167,163,218,255,
167,163,218,255,167,163,218,255,166,165,214,255,167,163,218,255,166,165,214,255,
166,165,214,255,166,165,214,255,162,158,200,255,162,158,200,255,166,166,201,255,
160,160,195,255,160,160,195,255,160,158,188,255,157,158,178,255,157,158,178,255,
160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,
178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,
185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,
0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,
112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,
194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,188,185,222,255,169,165,207,255,178,173,216,255,173,165,215,255,
173,165,215,255,165,156,206,255,161,157,212,255,167,163,218,255,161,157,212,255,
161,157,212,255,161,157,212,255,161,157,212,255,159,158,206,255,165,156,206,255,
165,156,206,255,154,151,205,255,143,140,194,255,141,140,200,255,141,140,200,255,
149,148,209,255,149,148,209,255,149,148,209,255,158,156,218,255,161,157,212,255,
161,157,212,255,161,157,212,255,153,152,200,255,149,146,200,255,153,152,200,255,
148,148,195,255,149,146,200,255,142,141,188,255,142,141,188,255,145,141,183,255,
142,141,188,255,142,141,188,255,155,147,196,255,155,147,196,255,145,141,183,255,
119,117,156,255,110,108,129,255,79,80,102,255,52,55,78,255,38,42,54,255,30,34,
46,255,30,34,46,255,30,34,46,255,24,25,32,255,28,32,43,255,28,32,43,255,28,32,
43,255,24,25,32,255,24,25,32,255,28,32,43,255,28,32,43,255,28,32,43,255,29,30,
37,255,24,25,32,255,29,30,37,255,28,32,43,255,28,32,43,255,24,25,32,255,24,25,
32,255,28,32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,28,32,43,255,29,30,
37,255,28,32,43,255,28,32,43,255,24,25,32,255,28,32,43,255,28,32,43,255,28,32,
43,255,28,32,43,255,29,30,37,255,28,32,43,255,29,30,37,255,29,30,37,255,28,32,
43,255,28,32,43,255,29,30,37,255,30,34,46,255,30,34,46,255,30,34,46,255,28,32,
43,255,35,39,51,255,35,39,51,255,30,34,46,255,30,34,46,255,35,39,51,255,34,34,
42,255,38,42,54,255,38,42,54,255,50,51,59,255,79,80,102,255,92,92,112,255,111,
110,143,255,129,126,165,255,143,140,194,255,138,135,189,255,142,141,188,255,148,
140,188,255,155,147,196,255,148,148,195,255,142,141,188,255,154,151,205,255,153,
152,200,255,154,151,205,255,154,151,205,255,159,158,206,255,159,158,206,255,161,
157,212,255,161,157,212,255,161,157,212,255,158,156,218,255,149,148,209,255,158,
156,218,255,161,157,212,255,161,157,212,255,161,157,212,255,167,163,218,255,166,
165,214,255,167,163,218,255,167,163,218,255,166,165,214,255,161,157,212,255,166,
165,214,255,166,165,214,255,166,165,214,255,166,165,214,255,162,158,200,255,169,
165,207,255,173,165,202,255,173,165,202,255,172,168,198,255,160,158,188,255,160,
158,188,255,174,166,191,255,160,158,188,0,157,158,178,0,157,158,178,0,160,158,
188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,
158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,
184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,
148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,
0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,
165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,188,185,222,0,169,165,207,0,191,186,215,255,178,174,211,255,188,185,222,
255,178,173,216,255,169,165,207,255,169,165,207,255,173,165,215,255,161,157,212,
255,161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,
255,161,157,212,255,154,151,205,255,143,140,194,255,134,131,185,255,143,140,194,
255,161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,158,156,218,
255,161,157,212,255,165,156,206,255,159,158,206,255,161,157,212,255,159,158,206,
255,166,165,214,255,162,158,200,255,165,156,206,255,154,150,192,255,155,147,196,
255,145,141,183,255,142,141,188,255,155,147,196,255,145,141,183,255,148,140,188,
255,145,141,183,255,154,150,192,255,154,150,192,255,154,150,192,255,145,141,183,
255,129,126,165,255,111,110,143,255,92,92,112,255,64,65,86,255,52,55,78,255,38,
42,54,255,35,39,51,255,28,32,43,255,24,25,32,255,24,25,32,255,28,32,43,255,28,
32,43,255,28,32,43,255,28,32,43,255,28,32,43,255,30,34,46,255,34,34,42,255,29,
30,37,255,35,39,51,255,30,34,46,255,29,30,37,255,30,34,46,255,28,32,43,255,34,
34,42,255,34,34,42,255,35,39,51,255,29,30,37,255,28,32,43,255,29,30,37,255,29,
30,37,255,28,32,43,255,28,32,43,255,28,32,43,255,30,34,46,255,30,34,46,255,30,
34,46,255,28,32,43,255,29,30,37,255,30,34,46,255,30,34,46,255,35,39,51,255,30,
34,46,255,46,49,63,255,64,65,86,255,92,92,112,255,110,108,129,255,128,121,147,
255,129,126,165,255,145,142,177,255,154,150,192,255,162,158,200,255,155,147,196,
255,155,147,196,255,142,141,188,255,136,136,183,255,143,140,194,255,141,140,200,
255,149,146,200,255,148,148,195,255,165,156,206,255,159,158,206,255,153,152,200,
255,161,157,212,255,159,158,206,255,159,158,206,255,159,158,206,255,166,165,214,
255,161,157,212,255,166,165,214,255,161,157,212,255,158,156,218,255,149,148,209,
255,158,156,218,255,158,156,218,255,158,156,218,255,161,157,212,255,167,163,218,
255,167,163,218,255,167,163,218,255,167,163,218,255,167,163,218,255,166,165,214,
255,167,163,218,255,166,165,214,255,166,165,214,255,178,174,211,255,178,174,211,
255,178,174,211,255,172,168,198,255,175,177,194,255,173,165,202,0,172,168,198,0,
160,158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,
178,0,160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,
158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,
184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,
6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,
9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,
157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,
185,222,0,178,173,216,0,188,185,222,255,188,184,227,255,178,173,216,255,178,173,
216,255,166,165,214,255,167,163,218,255,167,163,218,255,167,163,218,255,161,157,
212,255,173,165,215,255,158,156,218,255,165,156,206,255,161,157,212,255,173,165,
215,255,166,165,214,255,165,156,206,255,173,165,215,255,167,163,218,255,161,157,
212,255,167,163,218,255,166,165,214,255,173,165,215,255,166,165,214,255,173,165,
215,255,173,165,215,255,173,165,215,255,173,165,215,255,173,165,215,255,166,165,
214,255,165,156,206,255,153,152,200,255,153,152,200,255,155,147,196,255,155,147,
196,255,154,150,192,255,145,141,183,255,145,141,183,255,145,141,183,255,145,141,
183,255,145,141,183,255,145,141,183,255,148,148,195,255,153,152,200,255,162,158,
200,255,153,152,200,255,153,152,200,255,145,142,177,255,145,142,177,255,129,126,
165,255,111,110,143,255,111,110,143,255,110,108,129,255,85,86,118,255,79,80,102,
255,79,80,102,255,79,80,102,255,64,65,86,255,64,65,86,255,64,65,86,255,64,65,86,
255,67,66,72,255,64,65,86,255,67,66,72,255,64,65,86,255,67,66,72,255,64,65,86,
255,64,65,86,255,64,65,86,255,64,65,86,255,64,65,86,255,79,80,102,255,79,80,102,
255,92,92,112,255,92,92,112,255,110,108,129,255,128,121,147,255,128,121,147,255,
129,126,165,255,145,142,177,255,154,150,192,255,160,160,195,255,162,158,200,255,
162,158,200,255,142,141,188,255,136,136,183,255,142,141,188,255,142,141,188,255,
142,141,188,255,148,148,195,255,142,141,188,255,142,141,188,255,154,150,192,255,
155,147,196,255,154,151,205,255,153,152,200,255,149,146,200,255,154,151,205,255,
154,151,205,255,161,157,212,255,161,157,212,255,159,158,206,255,159,158,206,255,
159,158,206,255,167,163,218,255,167,163,218,255,159,158,206,255,166,165,214,255,
167,163,218,255,167,163,218,255,161,157,212,255,166,163,225,255,149,148,209,255,
158,156,218,255,158,156,218,255,167,163,218,255,161,157,212,255,167,163,218,255,
167,163,218,255,167,163,218,255,167,163,218,255,173,173,221,255,169,165,207,255,
188,184,227,255,172,168,198,255,178,174,211,0,178,174,211,0,178,174,211,0,172,
168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,
174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,
178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,
158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,
1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,
196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,
202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,
173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,188,185,
222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,
185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,255,178,173,216,
255,166,165,214,255,166,165,214,255,161,157,212,255,167,163,218,255,161,157,212,
255,165,156,206,255,167,163,218,255,167,163,218,255,166,165,214,255,173,165,215,
255,173,165,215,255,166,163,225,255,161,157,212,255,167,163,218,255,173,165,215,
255,173,165,215,255,175,171,227,255,167,163,218,255,175,171,227,255,167,163,218,
255,175,171,227,255,167,163,218,255,166,165,214,255,161,157,212,255,165,156,206,
255,154,151,205,255,159,158,206,255,165,156,206,255,165,156,206,255,165,156,206,
255,165,156,206,255,154,150,192,255,154,150,192,255,153,152,200,255,148,148,195,
255,154,150,192,255,145,141,183,255,145,141,183,255,142,141,188,255,142,141,188,
255,142,141,188,255,142,141,188,255,145,142,177,255,142,141,188,255,148,140,188,
255,142,141,188,255,154,150,192,255,148,148,195,255,154,150,192,255,154,150,192,
255,154,150,192,255,154,150,192,255,148,148,195,255,154,150,192,255,148,148,195,
255,148,148,195,255,153,152,200,255,153,152,200,255,153,152,200,255,154,150,192,
255,154,150,192,255,159,158,206,255,162,158,200,255,154,150,192,255,153,152,200,
255,159,158,206,255,155,147,196,255,155,147,196,255,143,140,194,255,142,141,188,
255,142,141,188,255,142,141,188,255,145,141,183,255,148,140,188,255,142,141,188,
255,142,141,188,255,145,141,183,255,148,148,195,255,148,148,195,255,154,150,192,
255,153,152,200,255,155,147,196,255,159,158,206,255,165,156,206,255,154,151,205,
255,161,157,212,255,153,152,200,255,154,151,205,255,154,151,205,255,161,157,212,
255,161,157,212,255,161,157,212,255,167,163,218,255,166,165,214,255,166,165,214,
255,167,163,218,255,166,165,214,255,167,163,218,255,167,163,218,255,166,165,214,
255,167,163,218,255,173,173,221,255,166,165,214,255,166,163,225,255,166,163,225,
255,158,156,218,255,158,156,218,255,167,163,218,255,166,163,225,255,167,163,218,
255,167,163,218,255,166,165,214,255,169,165,207,255,178,173,216,255,188,185,222,
255,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,
174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,
160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,
188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,
158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,
184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,
148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,
0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,
165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,
173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,166,165,214,255,173,173,221,255,173,165,215,255,173,165,215,255,
167,163,218,255,167,163,218,255,161,157,212,255,167,163,218,255,167,163,218,255,
167,163,218,255,175,171,227,255,165,156,206,255,173,165,215,255,173,165,215,255,
175,171,227,255,167,163,218,255,161,157,212,255,167,163,218,255,165,156,206,255,
173,165,215,255,165,156,206,255,161,157,212,255,161,157,212,255,161,157,212,255,
154,151,205,255,159,158,206,255,161,157,212,255,159,158,206,255,159,158,206,255,
162,158,200,255,162,158,200,255,159,158,206,255,153,152,200,255,162,158,200,255,
162,158,200,255,154,150,192,255,162,158,200,255,153,152,200,255,154,150,192,255,
153,152,200,255,153,152,200,255,154,150,192,255,154,151,205,255,145,141,183,255,
142,141,188,255,145,141,183,255,148,140,188,255,142,141,188,255,142,141,188,255,
148,148,195,255,148,148,195,255,145,141,183,255,145,141,183,255,148,140,188,255,
148,140,188,255,142,141,188,255,145,141,183,255,142,141,188,255,145,141,183,255,
142,141,188,255,142,141,188,255,142,141,188,255,145,141,183,255,155,147,196,255,
145,141,183,255,145,141,183,255,148,148,195,255,142,141,188,255,145,141,183,255,
148,148,195,255,154,150,192,255,153,152,200,255,155,147,196,255,153,152,200,255,
154,150,192,255,153,152,200,255,159,158,206,255,165,156,206,255,159,158,206,255,
165,156,206,255,162,158,200,255,159,158,206,255,159,158,206,255,161,157,212,255,
159,158,206,255,166,165,214,255,167,163,218,255,161,157,212,255,161,157,212,255,
158,156,218,255,161,157,212,255,159,158,206,255,166,165,214,255,167,163,218,255,
167,163,218,255,167,163,218,255,167,163,218,255,166,165,214,255,175,171,227,255,
167,163,218,255,175,171,227,255,166,165,214,255,175,171,227,255,167,163,218,255,
166,163,225,255,166,163,225,255,166,163,225,255,158,156,218,255,166,165,214,255,
167,163,218,255,178,173,216,255,178,174,211,255,188,185,222,255,178,173,216,0,
188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,
211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,
158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,
160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,
178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,
185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,
0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,
112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,
194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,
222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,
173,216,0,178,173,216,0,166,165,214,0,173,173,221,255,173,165,215,255,173,173,
221,255,167,163,218,255,173,165,215,255,161,157,212,255,167,163,218,255,167,163,
218,255,161,157,212,255,167,163,218,255,167,163,218,255,167,163,218,255,165,156,
206,255,167,163,218,255,167,163,218,255,161,157,212,255,167,163,218,255,161,157,
212,255,167,163,218,255,166,165,214,255,173,165,215,255,165,156,206,255,167,163,
218,255,161,157,212,255,165,156,206,255,165,156,206,255,165,156,206,255,173,165,
215,255,165,156,206,255,169,165,207,255,169,165,207,255,162,158,200,255,165,156,
206,255,166,165,214,255,159,158,206,255,169,165,207,255,162,158,200,255,162,158,
200,255,165,156,206,255,165,156,206,255,162,158,200,255,165,156,206,255,165,156,
206,255,165,156,206,255,153,152,200,255,162,158,200,255,154,150,192,255,154,150,
192,255,154,150,192,255,153,152,200,255,153,152,200,255,153,152,200,255,154,150,
192,255,154,150,192,255,154,150,192,255,154,150,192,255,154,150,192,255,155,147,
196,255,153,152,200,255,154,150,192,255,148,148,195,255,154,150,192,255,153,152,
200,255,162,158,200,255,154,150,192,255,153,152,200,255,153,152,200,255,155,147,
196,255,153,152,200,255,165,156,206,255,153,152,200,255,159,158,206,255,165,156,
206,255,169,165,207,255,159,158,206,255,169,165,207,255,162,158,200,255,166,165,
214,255,173,165,215,255,166,165,214,255,173,165,215,255,169,165,207,255,169,165,
207,255,173,165,215,255,166,165,214,255,166,165,214,255,161,157,212,255,167,163,
218,255,167,163,218,255,167,163,218,255,167,163,218,255,175,171,227,255,166,165,
214,255,175,171,227,255,173,173,221,255,175,171,227,255,175,171,227,255,175,171,
227,255,167,163,218,255,175,171,227,255,166,163,225,255,166,163,225,255,161,157,
212,255,161,157,212,255,167,163,218,255,166,165,214,255,167,163,218,255,178,174,
211,255,191,186,215,255,178,173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,
188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,
211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,
158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,
160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,
178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,
185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,
0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,
112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,
194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,
222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,
173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,
178,173,216,255,173,165,215,255,173,165,215,255,167,163,218,255,161,157,212,255,
161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,167,163,218,255,
167,163,218,255,167,163,218,255,173,165,215,255,166,165,214,255,166,165,214,255,
159,158,206,255,173,165,215,255,159,158,206,255,167,163,218,255,166,165,214,255,
166,165,214,255,166,165,214,255,173,173,221,255,166,165,214,255,166,165,214,255,
166,165,214,255,166,165,214,255,169,165,207,255,173,165,215,255,169,165,207,255,
169,165,207,255,169,165,207,255,169,165,207,255,173,165,215,255,166,165,214,255,
162,158,200,255,166,165,214,255,165,156,206,255,166,165,214,255,159,158,206,255,
159,158,206,255,165,156,206,255,165,156,206,255,159,158,206,255,159,158,206,255,
165,156,206,255,162,158,200,255,162,158,200,255,154,150,192,255,165,156,206,255,
155,147,196,255,165,156,206,255,165,156,206,255,153,152,200,255,162,158,200,255,
154,150,192,255,165,156,206,255,165,156,206,255,165,156,206,255,162,158,200,255,
165,156,206,255,165,156,206,255,162,158,200,255,166,165,214,255,166,165,214,255,
165,156,206,255,159,158,206,255,173,165,215,255,169,165,207,255,166,165,214,255,
165,156,206,255,169,165,207,255,166,165,214,255,173,165,215,255,169,165,207,255,
166,165,214,255,173,165,215,255,178,173,216,255,173,165,215,255,175,171,227,255,
178,173,216,255,173,165,215,255,173,165,215,255,173,165,215,255,167,163,218,255,
166,165,214,255,166,163,225,255,175,171,227,255,166,165,214,255,173,173,221,255,
175,171,227,255,175,171,227,255,175,171,227,255,167,163,218,255,175,171,227,255,
166,163,225,255,166,163,225,255,166,163,225,255,161,157,212,255,166,163,225,255,
167,163,218,255,166,165,214,255,188,185,222,255,191,186,215,255,178,174,211,0,
191,186,215,0,178,173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,
222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,
174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,
160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,
188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,
158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,
184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,
148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,
0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,
165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,
173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,178,173,
216,0,173,165,215,0,173,165,215,0,178,173,216,255,173,165,215,255,173,165,215,
255,167,163,218,255,173,165,215,255,158,156,218,255,161,157,212,255,161,157,212,
255,158,156,218,255,161,157,212,255,167,163,218,255,167,163,218,255,161,157,212,
255,167,163,218,255,159,158,206,255,161,157,212,255,167,163,218,255,167,163,218,
255,161,157,212,255,173,165,215,255,173,165,215,255,173,165,215,255,173,165,215,
255,173,165,215,255,169,165,207,255,173,165,215,255,173,165,215,255,166,165,214,
255,173,165,215,255,169,165,207,255,169,165,207,255,169,165,207,255,169,165,207,
255,166,165,214,255,169,165,207,255,169,165,207,255,169,165,207,255,169,165,207,
255,166,165,214,255,173,165,215,255,162,158,200,255,162,158,200,255,166,165,214,
255,159,158,206,255,166,165,214,255,162,158,200,255,162,158,200,255,159,158,206,
255,162,158,200,255,172,168,198,255,162,158,200,255,161,157,212,255,165,156,206,
255,159,158,206,255,159,158,206,255,165,156,206,255,169,165,207,255,159,158,206,
255,166,165,214,255,159,158,206,255,166,165,214,255,169,165,207,255,166,165,214,
255,166,165,214,255,173,165,215,255,169,165,207,255,166,165,214,255,173,165,215,
255,173,173,221,255,178,173,216,255,178,173,216,255,173,165,215,255,173,173,221,
255,173,173,221,255,173,173,221,255,173,173,221,255,173,173,221,255,173,173,221,
255,173,165,215,255,175,171,227,255,175,171,227,255,166,163,225,255,175,171,227,
255,166,163,225,255,166,163,225,255,166,163,225,255,166,163,225,255,166,163,225,
255,166,163,225,255,166,163,225,255,166,163,225,255,166,163,225,255,167,163,218,
255,161,157,212,255,167,163,218,255,173,165,215,255,173,173,221,255,188,185,222,
255,191,186,215,255,188,185,222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,
173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,
188,184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,172,168,
198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,
166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,
157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,
178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,
9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,
116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,
0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,
173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,188,185,
222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,
185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,
166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,178,173,216,0,173,165,
215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,165,215,0,167,163,218,0,178,
173,216,255,173,173,221,255,173,165,215,255,173,165,215,255,173,165,215,255,167,
163,218,255,161,157,212,255,161,157,212,255,161,157,212,255,161,157,212,255,167,
163,218,255,167,163,218,255,161,157,212,255,167,163,218,255,167,163,218,255,167,
163,218,255,161,157,212,255,167,163,218,255,165,156,206,255,161,157,212,255,167,
163,218,255,165,156,206,255,165,156,206,255,165,156,206,255,161,157,212,255,161,
157,212,255,167,163,218,255,161,157,212,255,161,157,212,255,165,156,206,255,161,
157,212,255,161,157,212,255,161,157,212,255,167,163,218,255,169,165,207,255,169,
165,207,255,173,165,215,255,166,165,214,255,169,165,207,255,169,165,207,255,169,
165,207,255,166,165,214,255,173,165,215,255,165,156,206,255,178,174,211,255,205,
176,193,255,191,186,215,255,155,147,196,255,165,156,206,255,165,156,206,255,169,
165,207,255,166,165,214,255,166,165,214,255,169,165,207,255,169,165,207,255,178,
173,216,255,173,165,215,255,173,173,221,255,178,173,216,255,173,165,215,255,178,
173,216,255,173,165,215,255,178,173,216,255,173,165,215,255,178,173,216,255,173,
165,215,255,175,171,227,255,173,173,221,255,173,165,215,255,173,165,215,255,175,
171,227,255,167,163,218,255,166,163,225,255,166,163,225,255,175,171,227,255,166,
163,225,255,167,163,218,255,166,163,225,255,166,163,225,255,167,163,218,255,166,
163,225,255,166,163,225,255,166,163,225,255,167,163,218,255,167,163,218,255,175,
171,227,255,175,171,227,255,173,173,221,255,178,173,216,255,188,185,222,255,188,
185,222,255,191,186,215,255,173,173,221,0,188,185,222,0,191,186,215,0,188,185,
222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,173,216,0,178,174,211,0,188,
185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,
178,174,211,0,178,174,211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,
202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,
158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,
160,158,188,0,157,158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,
194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,
6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,
116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,
0,172,168,198,0,166,157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,
165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,188,185,222,0,169,165,207,0,191,186,
215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,
173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,
173,165,215,0,173,173,221,0,178,173,216,0,173,165,215,0,173,165,215,0,178,173,
216,0,173,165,215,0,173,165,215,0,167,163,218,0,178,173,216,0,173,173,221,0,173,
165,215,0,173,165,215,0,173,165,215,0,167,163,218,0,188,185,222,255,173,165,215,
255,173,165,215,255,173,165,215,255,173,165,215,255,173,165,215,255,173,165,215,
255,173,165,215,255,167,163,218,255,173,165,215,255,167,163,218,255,167,163,218,
255,173,165,215,255,165,156,206,255,167,163,218,255,167,163,218,255,167,163,218,
255,173,165,215,255,167,163,218,255,167,163,218,255,167,163,218,255,165,156,206,
255,167,163,218,255,167,163,218,255,173,165,215,255,165,156,206,255,165,156,206,
255,161,157,212,255,161,157,212,255,165,156,206,255,173,165,215,255,161,157,212,
255,167,163,218,255,161,157,212,255,173,165,215,255,166,165,214,255,169,165,207,
255,165,156,206,255,165,156,206,255,191,186,215,255,178,173,216,255,165,156,206,
255,159,158,206,255,173,165,215,255,173,165,215,255,165,156,206,255,175,171,227,
255,167,163,218,255,173,165,215,255,166,165,214,255,167,163,218,255,167,163,218,
255,173,165,215,255,167,163,218,255,167,163,218,255,175,171,227,255,175,171,227,
255,167,163,218,255,175,171,227,255,167,163,218,255,166,163,225,255,175,171,227,
255,166,163,225,255,166,163,225,255,166,163,225,255,167,163,218,255,166,163,225,
255,166,163,225,255,166,163,225,255,166,163,225,255,175,171,227,255,175,171,227,
255,175,171,227,255,173,173,221,255,188,184,227,255,188,185,222,255,199,194,238,
255,204,199,237,255,188,185,222,255,175,171,227,0,175,171,227,0,173,173,221,0,
178,173,216,0,188,185,222,0,188,185,222,0,191,186,215,0,173,173,221,0,188,185,
222,0,191,186,215,0,188,185,222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,
173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,
188,184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,172,168,
198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,
166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,
157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,
178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,
9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,
116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,
0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,
173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,188,185,
222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,
185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,
166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,178,173,216,0,173,165,
215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,165,215,0,167,163,218,0,178,
173,216,0,173,173,221,0,173,165,215,0,173,165,215,0,173,165,215,0,167,163,218,0,
188,185,222,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,
215,0,173,165,215,0,188,185,222,255,188,185,222,255,178,173,216,255,178,173,216,
255,178,173,216,255,173,173,221,255,173,173,221,255,166,165,214,255,173,173,221,
255,166,165,214,255,166,165,214,255,178,173,216,255,178,173,216,255,178,173,216,
255,178,173,216,255,178,173,216,255,178,173,216,255,178,173,216,255,173,173,221,
255,178,174,211,255,178,173,216,255,173,165,215,255,167,163,218,255,154,151,205,
255,149,148,209,255,154,151,205,255,161,157,212,255,154,151,205,255,154,151,205,
255,158,156,218,255,149,148,209,255,161,157,212,255,165,156,206,255,161,157,212,
255,154,151,205,255,158,156,218,255,158,156,218,255,158,156,218,255,166,163,225,
255,161,157,212,255,166,163,225,255,166,163,225,255,161,157,212,255,167,163,218,
255,166,163,225,255,158,156,218,255,166,163,225,255,166,163,225,255,167,163,218,
255,167,163,218,255,166,163,225,255,166,163,225,255,167,163,218,255,166,163,225,
255,166,163,225,255,167,163,218,255,167,163,218,255,175,171,227,255,166,163,225,
255,173,165,215,255,173,165,215,255,188,184,227,255,188,185,222,255,188,185,222,
255,191,186,215,255,175,171,227,0,173,173,221,0,188,184,227,0,188,185,222,0,199,
194,238,0,204,199,237,0,188,185,222,0,175,171,227,0,175,171,227,0,173,173,221,0,
178,173,216,0,188,185,222,0,188,185,222,0,191,186,215,0,173,173,221,0,188,185,
222,0,191,186,215,0,188,185,222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,
173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,
188,184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,172,168,
198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,
166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,
157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,
178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,
9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,
116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,
0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,
173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,188,185,
222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,
185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,
166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,178,173,216,0,173,165,
215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,165,215,0,167,163,218,0,178,
173,216,0,173,173,221,0,173,165,215,0,173,165,215,0,173,165,215,0,167,163,218,0,
188,185,222,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,
215,0,173,165,215,0,188,185,222,0,188,185,222,0,178,173,216,0,178,173,216,0,178,
173,216,0,173,173,221,0,173,173,221,0,166,165,214,0,173,173,221,0,166,165,214,0,
166,165,214,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,173,216,0,178,173,216,0,173,173,221,0,178,174,211,0,191,186,215,255,
191,186,215,255,188,185,222,255,188,185,222,255,178,173,216,255,178,173,216,255,
178,173,216,255,178,173,216,255,178,173,216,255,165,156,206,255,161,157,212,255,
149,148,209,255,158,156,218,255,158,156,218,255,161,157,212,255,161,157,212,255,
161,157,212,255,161,157,212,255,158,156,218,255,161,157,212,255,161,157,212,255,
166,163,225,255,158,156,218,255,161,157,212,255,167,163,218,255,167,163,218,255,
167,163,218,255,167,163,218,255,167,163,218,255,173,165,215,255,173,165,215,255,
175,171,227,255,173,165,215,255,173,165,215,255,188,184,235,255,188,184,227,255,
188,185,222,255,188,185,222,255,188,185,222,255,173,165,215,0,173,165,215,0,188,
184,227,0,188,185,222,0,188,185,222,0,191,186,215,0,175,171,227,0,173,173,221,0,
188,184,227,0,188,185,222,0,199,194,238,0,204,199,237,0,188,185,222,0,175,171,
227,0,175,171,227,0,173,173,221,0,178,173,216,0,188,185,222,0,188,185,222,0,191,
186,215,0,173,173,221,0,188,185,222,0,191,186,215,0,188,185,222,0,191,186,215,0,
178,174,211,0,191,186,215,0,178,173,216,0,178,174,211,0,188,185,222,0,178,173,
216,0,188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,
174,211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,
160,158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,
178,0,160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,
158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,
184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,
6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,
9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,
157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,
185,222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,173,165,215,0,173,173,
221,0,178,173,216,0,173,165,215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,
165,215,0,167,163,218,0,178,173,216,0,173,173,221,0,173,165,215,0,173,165,215,0,
173,165,215,0,167,163,218,0,188,185,222,0,173,165,215,0,173,165,215,0,173,165,
215,0,173,165,215,0,173,165,215,0,173,165,215,0,188,185,222,0,188,185,222,0,178,
173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,173,173,221,0,166,165,214,0,
173,173,221,0,166,165,214,0,166,165,214,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,178,
174,211,0,191,186,215,0,191,186,215,0,188,185,222,0,188,185,222,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,200,201,225,255,206,200,
229,255,206,200,229,255,208,208,221,255,206,200,229,255,206,200,229,255,206,200,
229,255,206,200,229,255,206,200,229,255,206,200,229,255,191,186,215,255,206,200,
229,255,191,186,215,255,188,185,222,255,188,185,222,255,188,184,227,255,178,174,
211,255,188,184,227,255,188,185,222,255,188,185,222,255,188,185,222,255,188,184,
227,255,188,185,222,255,173,165,215,0,173,165,215,0,188,184,235,0,188,184,227,0,
188,185,222,0,188,185,222,0,188,185,222,0,173,165,215,0,173,165,215,0,188,184,
227,0,188,185,222,0,188,185,222,0,191,186,215,0,175,171,227,0,173,173,221,0,188,
184,227,0,188,185,222,0,199,194,238,0,204,199,237,0,188,185,222,0,175,171,227,0,
175,171,227,0,173,173,221,0,178,173,216,0,188,185,222,0,188,185,222,0,191,186,
215,0,173,173,221,0,188,185,222,0,191,186,215,0,188,185,222,0,191,186,215,0,178,
174,211,0,191,186,215,0,178,173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,
188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,
211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,
158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,
160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,
178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,
185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,
0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,
112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,
194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,
222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,
173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,
178,173,216,0,173,165,215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,165,
215,0,167,163,218,0,178,173,216,0,173,173,221,0,173,165,215,0,173,165,215,0,173,
165,215,0,167,163,218,0,188,185,222,0,173,165,215,0,173,165,215,0,173,165,215,0,
173,165,215,0,173,165,215,0,173,165,215,0,188,185,222,0,188,185,222,0,178,173,
216,0,178,173,216,0,178,173,216,0,173,173,221,0,173,173,221,0,166,165,214,0,173,
173,221,0,166,165,214,0,166,165,214,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,178,174,
211,0,191,186,215,0,191,186,215,0,188,185,222,0,188,185,222,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,200,201,225,0,206,200,229,0,
206,200,229,0,208,208,221,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,
229,0,206,200,229,0,206,200,229,0,191,186,215,0,206,200,229,0,191,186,215,0,188,
185,222,0,188,185,222,0,188,184,227,0,178,174,211,0,188,184,227,0,188,185,222,0,
188,185,222,0,188,185,222,0,188,184,227,0,188,185,222,0,173,165,215,0,173,165,
215,0,188,184,235,0,188,184,227,0,188,185,222,0,188,185,222,0,188,185,222,0,173,
165,215,0,173,165,215,0,188,184,227,0,188,185,222,0,188,185,222,0,191,186,215,0,
175,171,227,0,173,173,221,0,188,184,227,0,188,185,222,0,199,194,238,0,204,199,
237,0,188,185,222,0,175,171,227,0,175,171,227,0,173,173,221,0,178,173,216,0,188,
185,222,0,188,185,222,0,191,186,215,0,173,173,221,0,188,185,222,0,191,186,215,0,
188,185,222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,173,216,0,178,174,
211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,188,184,227,0,172,
168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,172,168,198,0,175,177,194,0,
173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,166,191,0,160,158,
188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,157,158,178,0,141,
141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,
175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,
39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,
196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,
201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,
165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,188,185,222,0,169,165,207,0,191,186,
215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,
173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,
173,165,215,0,173,173,221,0,178,173,216,0,173,165,215,0,173,165,215,0,178,173,
216,0,173,165,215,0,173,165,215,0,167,163,218,0,178,173,216,0,173,173,221,0,173,
165,215,0,173,165,215,0,173,165,215,0,167,163,218,0,188,185,222,0,173,165,215,0,
173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,188,185,
222,0,188,185,222,0,178,173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,173,
173,221,0,166,165,214,0,173,173,221,0,166,165,214,0,166,165,214,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,173,173,221,0,178,174,211,0,191,186,215,0,191,186,215,0,188,185,222,0,188,
185,222,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,
200,201,225,0,206,200,229,0,206,200,229,0,208,208,221,0,206,200,229,0,206,200,
229,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,229,0,191,186,215,0,206,
200,229,0,191,186,215,0,188,185,222,0,188,185,222,0,188,184,227,0,178,174,211,0,
188,184,227,0,188,185,222,0,188,185,222,0,188,185,222,0,188,184,227,0,188,185,
222,0,173,165,215,0,173,165,215,0,188,184,235,0,188,184,227,0,188,185,222,0,188,
185,222,0,188,185,222,0,173,165,215,0,173,165,215,0,188,184,227,0,188,185,222,0,
188,185,222,0,191,186,215,0,175,171,227,0,173,173,221,0,188,184,227,0,188,185,
222,0,199,194,238,0,204,199,237,0,188,185,222,0,175,171,227,0,175,171,227,0,173,
173,221,0,178,173,216,0,188,185,222,0,188,185,222,0,191,186,215,0,173,173,221,0,
188,185,222,0,191,186,215,0,188,185,222,0,191,186,215,0,178,174,211,0,191,186,
215,0,178,173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,
165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,
172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,160,158,
188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,
158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,
157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,
195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,
135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,
165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,
178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,188,
185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,173,216,0,
188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,178,173,216,0,173,
165,215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,165,215,0,167,163,218,0,
178,173,216,0,173,173,221,0,173,165,215,0,173,165,215,0,173,165,215,0,167,163,
218,0,188,185,222,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,173,
165,215,0,173,165,215,0,188,185,222,0,188,185,222,0,178,173,216,0,178,173,216,0,
178,173,216,0,173,173,221,0,173,173,221,0,166,165,214,0,173,173,221,0,166,165,
214,0,166,165,214,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,178,174,211,0,191,186,215,0,
191,186,215,0,188,185,222,0,188,185,222,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,173,216,0,178,173,216,0,200,201,225,0,206,200,229,0,206,200,229,0,208,
208,221,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,229,0,
206,200,229,0,191,186,215,0,206,200,229,0,191,186,215,0,188,185,222,0,188,185,
222,0,188,184,227,0,178,174,211,0,188,184,227,0,188,185,222,0,188,185,222,0,188,
185,222,0,188,184,227,0,188,185,222,0,173,165,215,0,173,165,215,0,188,184,235,0,
188,184,227,0,188,185,222,0,188,185,222,0,188,185,222,0,173,165,215,0,173,165,
215,0,188,184,227,0,188,185,222,0,188,185,222,0,191,186,215,0,175,171,227,0,173,
173,221,0,188,184,227,0,188,185,222,0,199,194,238,0,204,199,237,0,188,185,222,0,
175,171,227,0,175,171,227,0,173,173,221,0,178,173,216,0,188,185,222,0,188,185,
222,0,191,186,215,0,173,173,221,0,188,185,222,0,191,186,215,0,188,185,222,0,191,
186,215,0,178,174,211,0,191,186,215,0,178,173,216,0,178,174,211,0,188,185,222,0,
178,173,216,0,188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,
211,0,178,174,211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,
168,198,0,160,158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,
157,158,178,0,160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,
188,0,157,158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,
177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,
73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,
37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,
198,0,166,157,194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,
173,216,0,178,173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,
211,0,188,185,222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,173,165,215,0,
173,173,221,0,178,173,216,0,173,165,215,0,173,165,215,0,178,173,216,0,173,165,
215,0,173,165,215,0,167,163,218,0,178,173,216,0,173,173,221,0,173,165,215,0,173,
165,215,0,173,165,215,0,167,163,218,0,188,185,222,0,173,165,215,0,173,165,215,0,
173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,188,185,222,0,188,185,
222,0,178,173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,173,173,221,0,166,
165,214,0,173,173,221,0,166,165,214,0,166,165,214,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,173,173,
221,0,178,174,211,0,191,186,215,0,191,186,215,0,188,185,222,0,188,185,222,0,178,
173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,200,201,225,0,
206,200,229,0,206,200,229,0,208,208,221,0,206,200,229,0,206,200,229,0,206,200,
229,0,206,200,229,0,206,200,229,0,206,200,229,0,191,186,215,0,206,200,229,0,191,
186,215,0,188,185,222,0,188,185,222,0,188,184,227,0,178,174,211,0,188,184,227,0,
188,185,222,0,188,185,222,0,188,185,222,0,188,184,227,0,188,185,222,0,173,165,
215,0,173,165,215,0,188,184,235,0,188,184,227,0,188,185,222,0,188,185,222,0,188,
185,222,0,173,165,215,0,173,165,215,0,188,184,227,0,188,185,222,0,188,185,222,0,
191,186,215,0,175,171,227,0,173,173,221,0,188,184,227,0,188,185,222,0,199,194,
238,0,204,199,237,0,188,185,222,0,175,171,227,0,175,171,227,0,173,173,221,0,178,
173,216,0,188,185,222,0,188,185,222,0,191,186,215,0,173,173,221,0,188,185,222,0,
191,186,215,0,188,185,222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,173,
216,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,188,
184,227,0,172,168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,172,168,198,0,
175,177,194,0,173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,166,
191,0,160,158,188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,157,
158,178,0,141,141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,178,0,
168,170,187,0,175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,
6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,0,112,108,148,0,135,196,116,0,
112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,112,108,148,0,173,165,202,0,166,
157,194,0,166,166,201,0,172,168,198,0,166,157,194,0,173,165,202,0,178,173,216,0,
178,173,216,0,169,165,207,0,178,173,216,0,178,173,216,0,178,173,216,0,178,174,
211,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,188,185,222,0,169,
165,207,0,191,186,215,0,178,174,211,0,188,185,222,0,178,173,216,0,188,185,222,0,
188,184,227,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,166,165,
214,0,173,173,221,0,173,165,215,0,173,173,221,0,178,173,216,0,173,165,215,0,173,
165,215,0,178,173,216,0,173,165,215,0,173,165,215,0,167,163,218,0,178,173,216,0,
173,173,221,0,173,165,215,0,173,165,215,0,173,165,215,0,167,163,218,0,188,185,
222,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,173,165,215,0,173,
165,215,0,188,185,222,0,188,185,222,0,178,173,216,0,178,173,216,0,178,173,216,0,
173,173,221,0,173,173,221,0,166,165,214,0,173,173,221,0,166,165,214,0,166,165,
214,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,178,
173,216,0,178,173,216,0,173,173,221,0,178,174,211,0,191,186,215,0,191,186,215,0,
188,185,222,0,188,185,222,0,178,173,216,0,178,173,216,0,178,173,216,0,178,173,
216,0,178,173,216,0,200,201,225,0,206,200,229,0,206,200,229,0,208,208,221,0,206,
200,229,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,229,0,
191,186,215,0,206,200,229,0,191,186,215,0,188,185,222,0,188,185,222,0,188,184,
227,0,178,174,211,0,188,184,227,0,188,185,222,0,188,185,222,0,188,185,222,0,188,
184,227,0,188,185,222,0,173,165,215,0,173,165,215,0,188,184,235,0,188,184,227,0,
188,185,222,0,188,185,222,0,188,185,222,0,173,165,215,0,173,165,215,0,188,184,
227,0,188,185,222,0,188,185,222,0,191,186,215,0,175,171,227,0,173,173,221,0,188,
184,227,0,188,185,222,0,199,194,238,0,204,199,237,0,188,185,222,0,175,171,227,0,
175,171,227,0,173,173,221,0,178,173,216,0,188,185,222,0,188,185,222,0,191,186,
215,0,173,173,221,0,188,185,222,0,191,186,215,0,188,185,222,0,191,186,215,0,178,
174,211,0,191,186,215,0,178,173,216,0,178,174,211,0,188,185,222,0,178,173,216,0,
188,185,222,0,169,165,207,0,188,184,227,0,172,168,198,0,178,174,211,0,178,174,
211,0,178,174,211,0,172,168,198,0,175,177,194,0,173,165,202,0,172,168,198,0,160,
158,188,0,160,158,188,0,174,166,191,0,160,158,188,0,157,158,178,0,157,158,178,0,
160,158,188,0,157,158,178,0,157,158,178,0,141,141,167,0,160,158,188,0,157,158,
178,0,160,158,188,0,157,158,178,0,168,170,187,0,175,177,194,0,177,177,187,0,184,
185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,39,0,1,6,9,0,18,73,180,0,1,6,9,
0,112,108,148,0,135,196,116,0,112,108,148,0,135,196,116,0,11,16,37,0,1,6,9,0,
112,108,148,0,173,165,202,0,166,157,194,0,166,166,201,0,172,168,198,0,166,157,
194,0,173,165,202,0,178,173,216,0,178,173,216,0,169,165,207,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,174,211,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,188,185,222,0,169,165,207,0,191,186,215,0,178,174,211,0,188,185,
222,0,178,173,216,0,188,185,222,0,188,184,227,0,178,173,216,0,178,173,216,0,178,
173,216,0,178,173,216,0,166,165,214,0,173,173,221,0,173,165,215,0,173,173,221,0,
178,173,216,0,173,165,215,0,173,165,215,0,178,173,216,0,173,165,215,0,173,165,
215,0,167,163,218,0,178,173,216,0,173,173,221,0,173,165,215,0,173,165,215,0,173,
165,215,0,167,163,218,0,188,185,222,0,173,165,215,0,173,165,215,0,173,165,215,0,
173,165,215,0,173,165,215,0,173,165,215,0,188,185,222,0,188,185,222,0,178,173,
216,0,178,173,216,0,178,173,216,0,173,173,221,0,173,173,221,0,166,165,214,0,173,
173,221,0,166,165,214,0,166,165,214,0,178,173,216,0,178,173,216,0,178,173,216,0,
178,173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,173,173,221,0,178,174,
211,0,191,186,215,0,191,186,215,0,188,185,222,0,188,185,222,0,178,173,216,0,178,
173,216,0,178,173,216,0,178,173,216,0,178,173,216,0,200,201,225,0,206,200,229,0,
206,200,229,0,208,208,221,0,206,200,229,0,206,200,229,0,206,200,229,0,206,200,
229,0,206,200,229,0,206,200,229,0,191,186,215,0,206,200,229,0,191,186,215,0,188,
185,222,0,188,185,222,0,188,184,227,0,178,174,211,0,188,184,227,0,188,185,222,0,
188,185,222,0,188,185,222,0,188,184,227,0,188,185,222,0,173,165,215,0,173,165,
215,0,188,184,235,0,188,184,227,0,188,185,222,0,188,185,222,0,188,185,222,0,173,
165,215,0,173,165,215,0,188,184,227,0,188,185,222,0,188,185,222,0,191,186,215,0,
175,171,227,0,173,173,221,0,188,184,227,0,188,185,222,0,199,194,238,0,204,199,
237,0,188,185,222,0,175,171,227,0,175,171,227,0,173,173,221,0,178,173,216,0,188,
185,222,0,188,185,222,0,191,186,215,0,173,173,221,0,188,185,222,0,191,186,215,0,
188,185,222,0,191,186,215,0,178,174,211,0,191,186,215,0,178,173,216,0,178,174,
211,0,188,185,222,0,178,173,216,0,188,185,222,0,169,165,207,0,188,184,227,0,172,
168,198,0,178,174,211,0,178,174,211,0,178,174,211,0,172,168,198,0,175,177,194,0,
173,165,202,0,172,168,198,0,160,158,188,0,160,158,188,0,174,166,191,0,160,158,
188,0,157,158,178,0,157,158,178,0,160,158,188,0,157,158,178,0,157,158,178,0,141,
141,167,0,160,158,188,0,157,158,178,0,160,158,188,0,157,158,178,0,168,170,187,0,
175,177,194,0,177,177,187,0,184,185,195,0,184,185,195,0,1,6,9,0,1,6,9,0,132,239,
39,0,1,6,9,0,18,73,180,0,1,6,9,0};
static Fl_RGB_Image image_gba_mini(idata_gba_mini, 186, 110, 4, 0);

About::About() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = MainWindow = new Fl_Double_Window(450, 510, "A propos...");
    w = o;
    o->color((Fl_Color)146);
    o->selection_color((Fl_Color)41);
    o->user_data((void*)(this));
    { Fl_Button* o = btn_fermer = new Fl_Button(165, 467, 125, 25, "Fermer");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelfont(1);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_btn_fermer1);
    }
    { Fl_Box* o = image_gba = new Fl_Box(93, 46, 263, 159, "VBA Express est un Logiciel qui vous facilitera la configuration de Visual Bo\
y Advance pour Linux.");
      o->image(image_gba_mini);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->align(129|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(159, 7, 55, 25, "VBA");
      o->labelfont(1);
      o->labelsize(22);
      o->labelcolor((Fl_Color)129);
    }
    { Fl_Box* o = new Fl_Box(218, 7, 70, 25, "Express");
      o->labelfont(2);
      o->labelsize(22);
      o->labelcolor((Fl_Color)237);
    }
    { Fl_Box* o = new Fl_Box(123, 31, 203, 15, "Version 1.2 (1/2006) BETA");
      o->labelsize(10);
      o->labelcolor((Fl_Color)196);
    }
    { Fl_Box* o = new Fl_Box(55, 243, 359, 105);
      o->box(FL_DOWN_BOX);
      o->color((Fl_Color)146);
    }
    { Fl_Box* o = label_auteur = new Fl_Box(81, 254, 64, 25, "Auteur:");
      o->labelfont(1);
      o->labelcolor((Fl_Color)69);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(149, 254, 110, 25, "Achraf cherti");
      o->labelfont(1);
      o->labelcolor((Fl_Color)207);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Button* o = btn_plus_info = new Fl_Button(125, 209, 200, 18, "Cliquez ici pour plus d\'infos...");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelsize(10);
      o->labelcolor((Fl_Color)215);
    }
    { Fl_Box* o = label_licence = new Fl_Box(45, 380, 360, 40, "VBA Express est un logiciel libre. Sa licence est la licence GPL Version 2 ou\
 ult\351rieure. Pour lire la licence:");
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = label_titre_licence = new Fl_Box(137, 358, 175, 25, "Licence:");
      o->labelfont(1);
      o->labelsize(20);
      o->labelcolor((Fl_Color)135);
    }
    { Fl_Button* o = btn_lire_licence = new Fl_Button(125, 423, 200, 18, "Cliquez ici pour lire la licence...");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelsize(10);
      o->labelcolor((Fl_Color)215);
    }
    { Fl_Box* o = label_site = new Fl_Box(81, 279, 55, 25, "Site:");
      o->labelfont(1);
      o->labelcolor((Fl_Color)69);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(149, 279, 190, 25, "http://vbaexpress.tuxfamily.org");
      o->labelfont(1);
      o->labelcolor((Fl_Color)207);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(81, 307, 55, 25, "Email:");
      o->labelfont(1);
      o->labelcolor((Fl_Color)69);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(149, 307, 190, 25, "achrafcherti@@gmail.com");
      o->labelfont(1);
      o->labelcolor((Fl_Color)207);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    o->set_modal();
    o->end();
  }
}

About::~About() {
  delete MainWindow;
}

void About::show() {
  MainWindow->show();
while(MainWindow->shown()) {
	Fl::wait();
}
}

Fl_Menu_Item Interface::menu_[] = {
 {"&Fichier", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Ouvrir un jeu...", 0x4006f,  0, 0, 128, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Enregistrer la configuration...", 0x40073,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Enregistrer la configuration sous...", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Importer une configuration...", 0x40069,  0, 0, 128, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Quitter", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {0,0,0,0,0,0,0,0,0},
 {"&Langage", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Fran\347""ais", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {"&English", 0,  0, 0, 4, FL_NORMAL_LABEL, 0, 10, 7},
 {0,0,0,0,0,0,0,0,0},
 {"&Configuration", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Interface", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {"&Skins", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {0,0,0,0,0,0,0,0,0},
 {"&Aide", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 10, 7},
 {"A &propos de VBA Express", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 7},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* Interface::mnu_fichier = Interface::menu_ + 0;
Fl_Menu_Item* Interface::mnu_ouvrir_jeu = Interface::menu_ + 1;
Fl_Menu_Item* Interface::mnu_enregistrer_config = Interface::menu_ + 2;
Fl_Menu_Item* Interface::mnu_enregistrer_config_sous = Interface::menu_ + 3;
Fl_Menu_Item* Interface::mnu_importer_config = Interface::menu_ + 4;
Fl_Menu_Item* Interface::mnu_quitter = Interface::menu_ + 5;
Fl_Menu_Item* Interface::mnu_lang = Interface::menu_ + 7;
Fl_Menu_Item* Interface::mnu_lang_fr = Interface::menu_ + 8;
Fl_Menu_Item* Interface::mnu_lang_en = Interface::menu_ + 9;
Fl_Menu_Item* Interface::mnu_config = Interface::menu_ + 11;
Fl_Menu_Item* Interface::mnu_config_interface = Interface::menu_ + 12;
Fl_Menu_Item* Interface::mnu_config_skin = Interface::menu_ + 13;
Fl_Menu_Item* Interface::mnu_aide_menu = Interface::menu_ + 15;
Fl_Menu_Item* Interface::mnu_a_propos = Interface::menu_ + 16;

void Interface::cb_check_plein_ecran_i(Fl_Check_Button*, void*) {
  changed=1;
/* if(check_plein_ecran->value())
slide_video->deactivate();
else
slide_video->activate(); */;
}
void Interface::cb_check_plein_ecran(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_plein_ecran_i(o,v);
}

void Interface::cb_check_interframe_aucune_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_check_interframe_aucune(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_interframe_aucune_i(o,v);
}

void Interface::cb_check_interframe_motion_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_check_interframe_motion(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_interframe_motion_i(o,v);
}

void Interface::cb_check_interframe_smart_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_check_interframe_smart(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_interframe_smart_i(o,v);
}

void Interface::cb_slide_video_i(Fl_Counter*, void*) {
  changed=1;
}
void Interface::cb_slide_video(Fl_Counter* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_slide_video_i(o,v);
}

void Interface::cb_check_auto_skip_i(Fl_Check_Button*, void*) {
  changed=1;
if(check_auto_skip->value()) {
slide_frame_skip->deactivate();
slide_gb_skip->deactivate();
}
else {
slide_frame_skip->activate();
slide_gb_skip->activate();
};
}
void Interface::cb_check_auto_skip(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_auto_skip_i(o,v);
}

void Interface::cb_slide_frame_skip_i(Fl_Counter*, void*) {
  changed=1;
}
void Interface::cb_slide_frame_skip(Fl_Counter* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_slide_frame_skip_i(o,v);
}

void Interface::cb_slide_gb_skip_i(Fl_Counter*, void*) {
  changed=1;
}
void Interface::cb_slide_gb_skip(Fl_Counter* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_slide_gb_skip_i(o,v);
}

void Interface::cb_browser_filter_i(Fl_Browser*, void*) {
  changed=1;
}
void Interface::cb_browser_filter(Fl_Browser* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_browser_filter_i(o,v);
}

void Interface::cb_check_son_active_i(Fl_Check_Button*, void*) {
  changed=1;

if(!check_son_active->value()) {
group_sound_qualite->deactivate();
group_sound_divers->deactivate();
slide_volume->deactivate();
}
else {
group_sound_qualite->activate();
group_sound_divers->activate();
slide_volume->activate();
};
}
void Interface::cb_check_son_active(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_son_active_i(o,v);
}

void Interface::cb_radio_44_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_radio_44(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_44_i(o,v);
}

void Interface::cb_radio_22_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_radio_22(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_22_i(o,v);
}

void Interface::cb_radio_11_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_radio_11(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_11_i(o,v);
}

void Interface::cb_check_reverse_stereo_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_reverse_stereo(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_reverse_stereo_i(o,v);
}

void Interface::cb_check_low_pass_filter_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_low_pass_filter(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_low_pass_filter_i(o,v);
}

void Interface::cb_check_echo_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_echo(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_echo_i(o,v);
}

void Interface::cb_slide_volume_i(Fl_Counter*, void*) {
  changed=1;
}
void Interface::cb_slide_volume(Fl_Counter* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_slide_volume_i(o,v);
}

void Interface::cb_Speed_i(Fl_Button*, void*) {
  changed=1;
getkey(output_key_speed);
}
void Interface::cb_Speed(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_Speed_i(o,v);
}

void Interface::cb_Capture_i(Fl_Button*, void*) {
  changed=1;
getkey(output_key_capture);
}
void Interface::cb_Capture(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_Capture_i(o,v);
}

void Interface::cb_L_i(Fl_Button*, void*) {
  changed=1;
getkey(output_key_l);
}
void Interface::cb_L(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_L_i(o,v);
}

void Interface::cb_R_i(Fl_Button*, void*) {
  changed=1;
getkey(output_key_r);
}
void Interface::cb_R(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_R_i(o,v);
}

void Interface::cb_2_i(Fl_Button*, void*) {
  getkey(output_key_up);
changed=1;
}
void Interface::cb_2(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_2_i(o,v);
}

void Interface::cb__i(Fl_Button*, void*) {
  getkey(output_key_left);
changed=1;
}
void Interface::cb_(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb__i(o,v);
}

void Interface::cb_21_i(Fl_Button*, void*) {
  getkey(output_key_down);
changed=1;
}
void Interface::cb_21(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_21_i(o,v);
}

void Interface::cb_1_i(Fl_Button*, void*) {
  getkey(output_key_right);
changed=1;
}
void Interface::cb_1(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_1_i(o,v);
}

void Interface::cb_A_i(Fl_Button*, void*) {
  getkey(output_key_a);
changed=1;
}
void Interface::cb_A(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_A_i(o,v);
}

void Interface::cb_B_i(Fl_Button*, void*) {
  getkey(output_key_b);
changed=1;
}
void Interface::cb_B(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_B_i(o,v);
}

void Interface::cb_Select_i(Fl_Button*, void*) {
  getkey(output_key_select);
changed=1;
}
void Interface::cb_Select(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_Select_i(o,v);
}

void Interface::cb_Start_i(Fl_Button*, void*) {
  getkey(output_key_start);
changed=1;
}
void Interface::cb_Start(Fl_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_Start_i(o,v);
}

void Interface::cb_radio_capture_bmp_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_radio_capture_bmp(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_capture_bmp_i(o,v);
}

void Interface::cb_radio_capture_png_i(Fl_Round_Button*, void*) {
  changed=1;
}
void Interface::cb_radio_capture_png(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_capture_png_i(o,v);
}

void Interface::cb_check_color_option_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_color_option(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_color_option_i(o,v);
}

void Interface::cb_check_pause_si_inactif_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_pause_si_inactif(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_pause_si_inactif_i(o,v);
}

void Interface::cb_check_agb_print_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_agb_print(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_agb_print_i(o,v);
}

void Interface::cb_radio_speed_none_i(Fl_Round_Button*, void*) {
  changed=1;
check_speed_transparent->deactivate();
}
void Interface::cb_radio_speed_none(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_speed_none_i(o,v);
}

void Interface::cb_radio_speed_percentage_i(Fl_Round_Button*, void*) {
  changed=1;
check_speed_transparent->activate();
}
void Interface::cb_radio_speed_percentage(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_speed_percentage_i(o,v);
}

void Interface::cb_radio_speed_detailed_i(Fl_Round_Button*, void*) {
  changed=1;
check_speed_transparent->activate();
}
void Interface::cb_radio_speed_detailed(Fl_Round_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_radio_speed_detailed_i(o,v);
}

void Interface::cb_check_speed_transparent_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_speed_transparent(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_check_speed_transparent_i(o,v);
}

void Interface::cb_check_disable_status_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_disable_status(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_disable_status_i(o,v);
}

void Interface::cb_check_enable_mmx_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_enable_mmx(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_enable_mmx_i(o,v);
}

void Interface::cb_check_enable_rtc_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_enable_rtc(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_enable_rtc_i(o,v);
}

void Interface::cb_check_enhanced_detection_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_enhanced_detection(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_enhanced_detection_i(o,v);
}

void Interface::cb_check_bordure_auto_i(Fl_Check_Button*, void*) {
  changed=1;
}
void Interface::cb_check_bordure_auto(Fl_Check_Button* o, void* v) {
  ((Interface*)(o->parent()->parent()->parent()->user_data()))->cb_check_bordure_auto_i(o,v);
}

Interface::Interface() {
  myWindow* w;
  { myWindow* o = MainWindow = new myWindow(720, 425, "VBA Express - 1.2 BETA");
    w = o;
    o->box(FL_FLAT_BOX);
    o->color(FL_BACKGROUND_COLOR);
    o->selection_color(FL_BACKGROUND_COLOR);
    o->labeltype(FL_NO_LABEL);
    o->labelfont(0);
    o->labelsize(14);
    o->labelcolor(FL_FOREGROUND_COLOR);
    o->user_data((void*)(this));
    o->align(FL_ALIGN_TOP);
    o->when(FL_WHEN_RELEASE);
    { Fl_Box* o = image_fond = new Fl_Box(0, 0, 724, 429);
      o->box(FL_FLAT_BOX);
      o->color((Fl_Color)146);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(205, 104, 313, 23);
      o->box(FL_FLAT_BOX);
      o->color((Fl_Color)146);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->textcolor(7);
      o->menu(menu_);
    }
    { Fl_Tabs* o = onglets = new Fl_Tabs(205, 129, 314, 175);
      o->box(FL_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelsize(10);
      o->labelcolor((Fl_Color)55);
      { Fl_Group* o = tab_affichage = new Fl_Group(206, 156, 312, 147, "Affichage");
        o->color((Fl_Color)146);
        o->selection_color((Fl_Color)146);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->hide();
        { Fl_Check_Button* o = check_plein_ecran = new Fl_Check_Button(216, 169, 92, 16, "&Plein Ecran");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_plein_ecran);
        }
        { Fl_Group* o = new Fl_Group(217, 193, 91, 76);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Round_Button* o = check_interframe_aucune = new Fl_Round_Button(226, 206, 71, 15, "Aucune");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_interframe_aucune);
          }
          { Fl_Round_Button* o = check_interframe_motion = new Fl_Round_Button(226, 221, 71, 19, "Motion Blur");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_interframe_motion);
          }
          { Fl_Round_Button* o = check_interframe_smart = new Fl_Round_Button(226, 239, 71, 18, "Intelligent");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->value(1);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_interframe_smart);
          }
          o->end();
        }
        { Fl_Box* o = label_interframe = new Fl_Box(226, 188, 62, 12, "Interframe");
          o->box(FL_FLAT_BOX);
          o->color((Fl_Color)146);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
        }
        { Fl_Counter* o = slide_video = new Fl_Counter(247, 278, 61, 15, "Video");
          o->type(1);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->minimum(0);
          o->maximum(3);
          o->step(1);
          o->value(3);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_slide_video);
          o->align(FL_ALIGN_LEFT);
        }
        { Fl_Group* o = new Fl_Group(315, 170, 85, 123);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Check_Button* o = check_auto_skip = new Fl_Check_Button(325, 185, 65, 15, "&Auto Skip");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_auto_skip);
          }
          { Fl_Counter* o = slide_frame_skip = new Fl_Counter(329, 219, 56, 15, "Frame skip");
            o->type(1);
            o->color((Fl_Color)53);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->minimum(0);
            o->maximum(5);
            o->step(1);
            o->value(3);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_slide_frame_skip);
            o->align(FL_ALIGN_TOP);
          }
          { Fl_Counter* o = slide_gb_skip = new Fl_Counter(328, 256, 56, 15, "GB Frameskip");
            o->type(1);
            o->color((Fl_Color)53);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->minimum(0);
            o->maximum(5);
            o->step(1);
            o->textsize(10);
            o->callback((Fl_Callback*)cb_slide_gb_skip);
            o->align(FL_ALIGN_TOP);
          }
          o->end();
        }
        { Fl_Browser* o = browser_filter = new Fl_Browser(408, 181, 100, 111, "Filtre Graphique:");
          o->type(2);
          o->selection_color((Fl_Color)246);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_browser_filter);
          o->align(FL_ALIGN_TOP_LEFT);
        }
        o->end();
      }
      { Fl_Group* o = tab_son = new Fl_Group(206, 156, 312, 147, "Son");
        o->color((Fl_Color)146);
        o->selection_color((Fl_Color)146);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->hide();
        { Fl_Check_Button* o = check_son_active = new Fl_Check_Button(260, 174, 80, 17, "&Le son activ\351");
          o->down_box(FL_DOWN_BOX);
          o->value(1);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_son_active);
        }
        { Fl_Group* o = group_sound_qualite = new Fl_Group(260, 201, 80, 80);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Round_Button* o = radio_44 = new Fl_Round_Button(269, 214, 54, 17, "44 Khz");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->value(1);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_44);
          }
          { Fl_Round_Button* o = radio_22 = new Fl_Round_Button(269, 234, 54, 17, "22 Khz");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_22);
          }
          { Fl_Round_Button* o = radio_11 = new Fl_Round_Button(270, 256, 54, 17, "11 Khz");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_11);
          }
          o->end();
        }
        { Fl_Box* o = label_qualite_son = new Fl_Box(265, 195, 40, 12, "Qualit\351");
          o->box(FL_FLAT_BOX);
          o->color((Fl_Color)146);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
        }
        { Fl_Group* o = group_sound_divers = new Fl_Group(357, 183, 111, 77);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Check_Button* o = check_reverse_stereo = new Fl_Check_Button(363, 190, 90, 20, "&Reverse Stereo");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_reverse_stereo);
          }
          { Fl_Check_Button* o = check_low_pass_filter = new Fl_Check_Button(363, 212, 90, 20, "&Low Pass Filter");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_low_pass_filter);
          }
          { Fl_Check_Button* o = check_echo = new Fl_Check_Button(363, 235, 90, 20, "&Echo");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_echo);
          }
          o->end();
        }
        { Fl_Box* o = label_divers = new Fl_Box(366, 178, 39, 12, "Divers");
          o->box(FL_FLAT_BOX);
          o->color((Fl_Color)146);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
        }
        { Fl_Counter* o = slide_volume = new Fl_Counter(393, 268, 75, 15, "Volume:");
          o->type(1);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->minimum(0);
          o->maximum(3);
          o->step(1);
          o->textsize(10);
          o->callback((Fl_Callback*)cb_slide_volume);
          o->align(FL_ALIGN_LEFT);
        }
        o->end();
      }
      { Fl_Group* o = tab_controle = new Fl_Group(206, 156, 312, 147, "Contr\364le");
        o->color((Fl_Color)146);
        o->selection_color((Fl_Color)146);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->hide();
        { Fl_Group* o = new Fl_Group(213, 168, 95, 125);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Output* o = output_key_left = new Fl_Output(262, 176, 35, 13, "Left");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_right = new Fl_Output(262, 195, 35, 13, "Right");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_up = new Fl_Output(262, 214, 35, 13, "Up");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_down = new Fl_Output(262, 232, 35, 13, "Down");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_speed = new Fl_Output(262, 251, 35, 13, "Speed");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_capture = new Fl_Output(262, 269, 35, 13, "Capture");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          o->end();
        }
        { Fl_Button* o = new Fl_Button(317, 172, 45, 15, "Speed");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Speed);
        }
        { Fl_Button* o = new Fl_Button(367, 172, 45, 15, "Capture");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Capture);
        }
        { Fl_Button* o = new Fl_Button(365, 192, 20, 15, "L");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_L);
        }
        { Fl_Button* o = new Fl_Button(389, 192, 21, 15, "R");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_R);
        }
        { Fl_Button* o = new Fl_Button(336, 203, 18, 23, "@2<");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_2);
          o->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
        }
        { Fl_Button* o = new Fl_Button(315, 222, 23, 16, "@<");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_);
          o->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
        }
        { Fl_Button* o = new Fl_Button(336, 234, 18, 23, "@2>");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_21);
          o->align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE);
        }
        { Fl_Button* o = new Fl_Button(350, 222, 25, 16, "@>");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_1);
          o->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
        }
        { Fl_Button* o = new Fl_Button(392, 229, 25, 20, "A");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_A);
        }
        { Fl_Button* o = new Fl_Button(369, 246, 25, 20, "B");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_B);
        }
        { Fl_Button* o = new Fl_Button(316, 278, 45, 15, "Select");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Select);
        }
        { Fl_Button* o = new Fl_Button(369, 278, 45, 15, "Start");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
          o->callback((Fl_Callback*)cb_Start);
        }
        { Fl_Group* o = new Fl_Group(423, 168, 85, 125);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Output* o = output_key_a = new Fl_Output(465, 176, 35, 13, "A");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_b = new Fl_Output(465, 195, 35, 13, "B");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_start = new Fl_Output(465, 214, 35, 13, "Start");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_select = new Fl_Output(465, 232, 35, 13, "Select");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_l = new Fl_Output(464, 250, 35, 13, "L");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          { Fl_Output* o = output_key_r = new Fl_Output(464, 268, 35, 13, "R");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->textsize(10);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = tab_autre = new Fl_Group(206, 156, 312, 147, "Autre");
        o->color((Fl_Color)146);
        o->selection_color((Fl_Color)146);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        { Fl_Group* o = new Fl_Group(218, 176, 90, 48);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Round_Button* o = radio_capture_bmp = new Fl_Round_Button(231, 184, 47, 17, "BMP");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->value(1);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_capture_bmp);
          }
          { Fl_Round_Button* o = radio_capture_png = new Fl_Round_Button(231, 203, 47, 17, "PNG");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_capture_png);
          }
          o->end();
        }
        { Fl_Box* o = label_screenshot = new Fl_Box(225, 171, 63, 12, "Screenshot");
          o->box(FL_FLAT_BOX);
          o->color((Fl_Color)146);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
        }
        { Fl_Check_Button* o = check_color_option = new Fl_Check_Button(218, 235, 95, 16, "&Color Option");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_color_option);
        }
        { Fl_Check_Button* o = check_pause_si_inactif = new Fl_Check_Button(218, 254, 95, 16, "&Pause si inactif");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_pause_si_inactif);
        }
        { Fl_Check_Button* o = check_agb_print = new Fl_Check_Button(218, 275, 95, 15, "&Imprimante");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_agb_print);
        }
        { Fl_Group* o = new Fl_Group(323, 176, 94, 88);
          o->box(FL_ENGRAVED_FRAME);
          { Fl_Round_Button* o = radio_speed_none = new Fl_Round_Button(328, 185, 75, 17, "Non affich\351""e");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->value(1);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_speed_none);
          }
          { Fl_Round_Button* o = radio_speed_percentage = new Fl_Round_Button(328, 203, 75, 17, "Pourcentage");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_speed_percentage);
          }
          { Fl_Round_Button* o = radio_speed_detailed = new Fl_Round_Button(328, 221, 75, 17, "D\351taill\351""e");
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_radio_speed_detailed);
          }
          { Fl_Check_Button* o = check_speed_transparent = new Fl_Check_Button(328, 242, 80, 16, "&Transparente");
            o->down_box(FL_DOWN_BOX);
            o->labelsize(10);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_check_speed_transparent);
          }
          o->end();
        }
        { Fl_Box* o = label_afficher_rapidite = new Fl_Box(331, 171, 62, 12, " Rapidite");
          o->box(FL_FLAT_BOX);
          o->color((Fl_Color)146);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        }
        { Fl_Check_Button* o = check_disable_status = new Fl_Check_Button(322, 275, 161, 15, "&D\351sactiver Message Status");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_disable_status);
        }
        { Fl_Check_Button* o = check_enable_mmx = new Fl_Check_Button(423, 176, 45, 15, "&MMX");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_enable_mmx);
          o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        }
        { Fl_Check_Button* o = check_enable_rtc = new Fl_Check_Button(423, 200, 45, 15, "&RTC");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_enable_rtc);
          o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
        }
        { Fl_Check_Button* o = check_enhanced_detection = new Fl_Check_Button(423, 225, 59, 15, "E.Detect");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_enhanced_detection);
        }
        { Fl_Check_Button* o = check_bordure_auto = new Fl_Check_Button(423, 249, 90, 15, "Bordure Auto");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_check_bordure_auto);
        }
        o->end();
      }
      { Fl_Group* o = tab_path = new Fl_Group(206, 156, 311, 147, "Chemins");
        o->color((Fl_Color)146);
        o->selection_color((Fl_Color)146);
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
        o->hide();
        { Fl_Button* o = btn_effacer_sauvegardes = new Fl_Button(219, 180, 20, 16, "x");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
        }
        { Fl_Output* o = output_chemin_sauvegardes = new Fl_Output(246, 180, 221, 15, "Chemin des sauvegardes (save state)");
          o->box(FL_THIN_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->textsize(10);
          o->align(FL_ALIGN_TOP_LEFT);
        }
        { Fl_Button* o = btn_chemin_sauvegardes = new Fl_Button(475, 180, 25, 16, "...");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelfont(1);
          o->labelsize(10);
        }
        { Fl_Button* o = btn_effacer_gameboy = new Fl_Button(219, 211, 20, 16, "x");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
        }
        { Fl_Output* o = output_chemin_gameboy = new Fl_Output(246, 211, 221, 15, "Chemin des sauvegardes GameBoy");
          o->box(FL_THIN_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->textsize(10);
          o->align(FL_ALIGN_TOP_LEFT);
        }
        { Fl_Button* o = btn_chemin_gameboy = new Fl_Button(475, 211, 25, 16, "...");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelfont(1);
          o->labelsize(10);
        }
        { Fl_Button* o = btn_effacer_captures = new Fl_Button(219, 242, 20, 16, "x");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
        }
        { Fl_Output* o = output_chemin_captures = new Fl_Output(246, 242, 221, 15, "Chemin des captures d\'\351""cran");
          o->box(FL_THIN_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->textsize(10);
          o->align(FL_ALIGN_TOP_LEFT);
        }
        { Fl_Button* o = btn_chemin_captures = new Fl_Button(475, 242, 25, 16, "...");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelfont(1);
          o->labelsize(10);
        }
        { Fl_Button* o = btn_effacer_bios = new Fl_Button(220, 275, 20, 16, "x");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelsize(10);
        }
        { Fl_Output* o = output_chemin_bios = new Fl_Output(247, 275, 221, 15, "Chemin du BIOS (STARLING)");
          o->box(FL_THIN_DOWN_BOX);
          o->labelsize(10);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->textsize(10);
          o->align(FL_ALIGN_TOP_LEFT);
        }
        { Fl_Button* o = btn_chemin_bios = new Fl_Button(476, 275, 25, 16, "...");
          o->box(FL_ROUND_UP_BOX);
          o->color((Fl_Color)53);
          o->labelfont(1);
          o->labelsize(10);
        }
        o->end();
      }
      o->end();
    }
    { Fl_Button* o = btn_quitter = new Fl_Button(626, 153, 50, 50, "&Quitter");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)53);
      o->labelfont(2);
      o->labelsize(10);
    }
    { Fl_Button* o = btn_jouer = new Fl_Button(561, 175, 50, 50, "&Jouer!");
      o->box(FL_ROUND_UP_BOX);
      o->color(FL_LIGHT3);
      o->labelfont(1);
      o->labelsize(10);
      o->labelcolor((Fl_Color)130);
    }
    o->end();
  }
  _actual_skin=0;
default_skin();

browser_filter->add("None");
browser_filter->add("TV Mode");
browser_filter->add("2xSai");
browser_filter->add("Super 2xSai");
browser_filter->add("Super Eagle");
browser_filter->add("Pixelate");
browser_filter->add("Motion Blur");
browser_filter->add("AMAME2x");
browser_filter->add("Simple2x");
browser_filter->add("Bilinear");
browser_filter->add("Bilinear+");
browser_filter->add("hq2x");
browser_filter->add("lq2x");
browser_filter->value(1);
changed=0;

#ifdef __linux__
XpmCreatePixmapFromData(fl_display, DefaultRootWindow(fl_display), vbaexpress_xpm, &icon_pixmap, &icon_mask, NULL);
MainWindow->icon((char *)icon_pixmap);
#endif
}

Interface::~Interface() {
  delete _actual_skin;
_actual_skin=0;
delete MainWindow;
}

void Interface::getkey(Fl_Output *output) {
  char tmp[256];
const char *str = output->value();
int actual = (int)strtol(str,(char **)0,16);
int newkey = vba_getkey(actual);
sprintf(tmp,"%04x",newkey);
output->value(tmp);
}

void Interface::dommage() {
  MainWindow->redraw();
}

void Interface::show(int argc, char **argv) {
  MainWindow->show(argc,argv);

#ifdef __linux__
XWMHints *hints = XGetWMHints(fl_display,fl_xid(MainWindow));
hints->flags|=IconMaskHint;
hints->icon_mask = icon_mask;
XSetWMHints(fl_display,fl_xid(MainWindow),hints);
XFree(hints);
#endif
}

void Interface::default_skin() {
  if(_actual_skin) 
	delete _actual_skin;

//allocation d'un nouveau skin
_actual_skin = new Fl_Pixmap(gba_xpm);

//application du skin
image_fond->image(_actual_skin);

//refresh de la fentre
MainWindow->redraw();
}

void Interface::change_skin(const char *filename) {
  //on teste l'existence du fichier
FILE *f = fopen(filename,"r");
// !f alors mettre l'image par dfaut
if(!f) {
	default_skin();
	return;
}
else
	fclose(f);


if(_actual_skin) 
	delete _actual_skin;

//allocation d'un nouveau skin
_actual_skin = new Fl_PNG_Image(filename);

//application du skin
image_fond->image(_actual_skin);

//refresh de la fentre
MainWindow->redraw();
}

void SkinManager::cb_btn_ok1_i(Fl_Button*, void*) {
  if(list->value()==0) {
	fl_alert(msg_skin);
	return;
}

MainWindow->hide();
ok=1;
}
void SkinManager::cb_btn_ok1(Fl_Button* o, void* v) {
  ((SkinManager*)(o->parent()->user_data()))->cb_btn_ok1_i(o,v);
}

void SkinManager::cb_btn_annuler1_i(Fl_Button*, void*) {
  MainWindow->hide();
}
void SkinManager::cb_btn_annuler1(Fl_Button* o, void* v) {
  ((SkinManager*)(o->parent()->user_data()))->cb_btn_annuler1_i(o,v);
}

SkinManager::SkinManager() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = MainWindow = new Fl_Double_Window(265, 305, "Revetement");
    w = o;
    o->color((Fl_Color)146);
    o->user_data((void*)(this));
    { Fl_Box* o = new Fl_Box(62, 15, 55, 25, "VBA");
      o->labelfont(1);
      o->labelsize(22);
      o->labelcolor((Fl_Color)129);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(113, 15, 89, 25, "Express");
      o->labelfont(2);
      o->labelsize(22);
      o->labelcolor((Fl_Color)237);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = label_config_skin = new Fl_Box(17, 39, 233, 16, "Configuration du rev\352tement");
      o->labelfont(1);
      o->labelsize(12);
      o->labelcolor((Fl_Color)196);
    }
    { Fl_Button* o = btn_ok = new Fl_Button(40, 262, 90, 23, "&Ok");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelfont(1);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_btn_ok1);
    }
    { Fl_Button* o = btn_annuler = new Fl_Button(140, 262, 90, 23, "&Annuler");
      o->box(FL_ROUND_UP_BOX);
      o->color((Fl_Color)146);
      o->selection_color((Fl_Color)146);
      o->labelfont(2);
      o->labelsize(12);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_btn_annuler1);
    }
    { Fl_Browser* o = list = new Fl_Browser(29, 65, 210, 180);
      o->type(2);
      o->labelsize(12);
      o->textsize(12);
    }
    o->set_modal();
    o->end();
  }
  msg_skin="";
}

int SkinManager::show(const char *msg) {
  ok=0;
msg_skin=msg;
MainWindow->show();
while(MainWindow->shown()) {
	Fl::wait();
}
return ok;
}
