/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};


static gpointer vala_property_accessor_parent_class = NULL;

#define VALA_PROPERTY_ACCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorPrivate))
static void vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                              gboolean value);
static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                            ValaDataType* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                                 ValaParameter* value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                                gboolean value);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);


/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor*
vala_property_accessor_construct (GType object_type,
                                  gboolean readable,
                                  gboolean writable,
                                  gboolean construction,
                                  ValaDataType* value_type,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference,
                                  ValaComment* comment)
{
	ValaPropertyAccessor* self = NULL;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, source_reference, comment);
	vala_property_accessor_set_readable (self, readable);
	vala_property_accessor_set_writable (self, writable);
	vala_property_accessor_set_construction (self, construction);
	vala_property_accessor_set_value_type (self, value_type);
	vala_subroutine_set_body ((ValaSubroutine*) self, body);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaPropertyAccessor*
vala_property_accessor_new (gboolean readable,
                            gboolean writable,
                            gboolean construction,
                            ValaDataType* value_type,
                            ValaBlock* body,
                            ValaSourceReference* source_reference,
                            ValaComment* comment)
{
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}


static void
vala_property_accessor_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property_accessor (visitor, self);
}


static void
vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaLocalVariable* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaLocalVariable* _tmp4_;
		ValaLocalVariable* _tmp5_;
		_tmp4_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod*
vala_property_accessor_get_method (ValaPropertyAccessor* self)
{
	ValaMethod* result = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_writable;
		if (_tmp14_) {
			ValaProperty* _tmp15_;
			ValaProperty* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaComment* _tmp25_;
			ValaComment* _tmp26_;
			ValaMethod* _tmp27_;
			ValaMethod* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			_tmp15_ = vala_property_accessor_get_prop (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("set_%s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_method_new (_tmp20_, (ValaDataType*) _tmp22_, _tmp24_, _tmp26_);
			_vala_code_node_unref0 (m);
			m = _tmp27_;
			_vala_code_node_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp28_ = m;
			_tmp29_ = self->priv->_value_parameter;
			_tmp30_ = vala_parameter_copy (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_callable_add_parameter ((ValaCallable*) _tmp28_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
		}
	}
	_tmp32_ = m;
	if (_tmp32_ != NULL) {
		ValaMethod* _tmp33_;
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaScope* _tmp36_;
		ValaScope* _tmp37_;
		ValaMethod* _tmp38_;
		ValaSymbolAccessibility _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaMethod* _tmp41_;
		ValaProperty* _tmp42_;
		ValaProperty* _tmp43_;
		ValaMemberBinding _tmp44_;
		ValaMemberBinding _tmp45_;
		ValaMethod* _tmp46_;
		ValaProperty* _tmp47_;
		ValaProperty* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		ValaMethod* _tmp51_;
		ValaProperty* _tmp52_;
		ValaProperty* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		_tmp33_ = m;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_owner ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp33_, _tmp37_);
		_tmp38_ = m;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		vala_symbol_set_access ((ValaSymbol*) _tmp38_, _tmp40_);
		_tmp41_ = m;
		_tmp42_ = vala_property_accessor_get_prop (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_property_get_binding (_tmp43_);
		_tmp45_ = _tmp44_;
		vala_method_set_binding (_tmp41_, _tmp45_);
		_tmp46_ = m;
		_tmp47_ = vala_property_accessor_get_prop (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_get_is_abstract (_tmp48_);
		_tmp50_ = _tmp49_;
		vala_method_set_is_abstract (_tmp46_, _tmp50_);
		_tmp51_ = m;
		_tmp52_ = vala_property_accessor_get_prop (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_property_get_is_virtual (_tmp53_);
		_tmp55_ = _tmp54_;
		vala_method_set_is_virtual (_tmp51_, _tmp55_);
	}
	result = m;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_property_accessor_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaPropertyAccessor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaSourceFileType _tmp24_;
	ValaSourceFileType _tmp25_;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaProperty* _tmp84_;
	ValaProperty* _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	ValaBlock* _tmp106_;
	ValaBlock* _tmp107_;
	ValaSemanticAnalyzer* _tmp144_;
	ValaSemanticAnalyzer* _tmp145_;
	ValaSymbol* _tmp146_;
	gboolean _tmp147_;
	gboolean _tmp148_;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_semantic_analyzer_get_current_symbol (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (_tmp9_);
	old_symbol = _tmp10_;
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	_tmp14_ = self->priv->_writable;
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_;
		_tmp15_ = self->priv->_construction;
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		_tmp16_ = vala_property_accessor_get_value_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("value", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_property_accessor_set_value_parameter (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
	}
	_tmp22_ = vala_property_accessor_get_prop (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaBlock* _tmp28_;
		ValaBlock* _tmp29_;
		_tmp28_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			ValaProperty* _tmp30_;
			ValaProperty* _tmp31_;
			gboolean _tmp32_;
			gboolean _tmp33_;
			_tmp30_ = vala_property_accessor_get_prop (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_property_get_interface_only (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp27_ = !_tmp33_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaProperty* _tmp34_;
			ValaProperty* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
			_tmp34_ = vala_property_accessor_get_prop (self);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_property_get_is_abstract (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp26_ = !_tmp37_;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			ValaSourceReference* _tmp38_;
			ValaSourceReference* _tmp39_;
			ValaBlock* _tmp40_;
			ValaBlock* _tmp41_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp42_;
			ValaProperty* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			ValaSourceReference* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaMemberAccess* _tmp50_;
			ValaMemberAccess* _tmp51_;
			gboolean _tmp52_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_block_new (_tmp39_);
			_tmp41_ = _tmp40_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp41_);
			_vala_code_node_unref0 (_tmp41_);
			_tmp42_ = vala_property_accessor_get_prop (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_symbol_get_name ((ValaSymbol*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup_printf ("_%s", _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_member_access_new_simple (_tmp47_, _tmp49_);
			_tmp51_ = _tmp50_;
			_g_free0 (_tmp47_);
			ma = _tmp51_;
			_tmp52_ = self->priv->_readable;
			if (_tmp52_) {
				ValaBlock* _tmp53_;
				ValaBlock* _tmp54_;
				ValaMemberAccess* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaReturnStatement* _tmp58_;
				ValaReturnStatement* _tmp59_;
				_tmp53_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = ma;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_return_statement_new ((ValaExpression*) _tmp55_, _tmp57_);
				_tmp59_ = _tmp58_;
				vala_block_add_statement (_tmp54_, (ValaStatement*) _tmp59_);
				_vala_code_node_unref0 (_tmp59_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaMemberAccess* _tmp62_;
				ValaDataType* _tmp63_;
				ValaDataType* _tmp64_;
				gboolean _tmp65_;
				gboolean _tmp66_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp71_;
				ValaExpression* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaAssignment* _tmp75_;
				ValaBlock* _tmp76_;
				ValaBlock* _tmp77_;
				ValaAssignment* _tmp78_;
				ValaExpressionStatement* _tmp79_;
				ValaExpressionStatement* _tmp80_;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_member_access_new_simple ("value", _tmp61_);
				value = (ValaExpression*) _tmp62_;
				_tmp63_ = vala_property_accessor_get_value_type (self);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_data_type_get_value_owned (_tmp64_);
				_tmp66_ = _tmp65_;
				if (_tmp66_) {
					ValaExpression* _tmp67_;
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					ValaReferenceTransferExpression* _tmp70_;
					_tmp67_ = value;
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_reference_transfer_expression_new (_tmp67_, _tmp69_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp70_;
				}
				_tmp71_ = ma;
				_tmp72_ = value;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_assignment_new ((ValaExpression*) _tmp71_, _tmp72_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp74_);
				assignment = _tmp75_;
				_tmp76_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp77_ = _tmp76_;
				_tmp78_ = assignment;
				_tmp79_ = vala_expression_statement_new ((ValaExpression*) _tmp78_, NULL);
				_tmp80_ = _tmp79_;
				vala_block_add_statement (_tmp77_, (ValaStatement*) _tmp80_);
				_vala_code_node_unref0 (_tmp80_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp84_ = vala_property_accessor_get_prop (self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_property_get_is_abstract (_tmp85_);
	_tmp87_ = _tmp86_;
	if (_tmp87_) {
		_tmp83_ = TRUE;
	} else {
		ValaProperty* _tmp88_;
		ValaProperty* _tmp89_;
		gboolean _tmp90_;
		gboolean _tmp91_;
		_tmp88_ = vala_property_accessor_get_prop (self);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_property_get_is_virtual (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp83_ = _tmp91_;
	}
	if (_tmp83_) {
		_tmp82_ = TRUE;
	} else {
		ValaProperty* _tmp92_;
		ValaProperty* _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp95_;
		_tmp92_ = vala_property_accessor_get_prop (self);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_property_get_overrides (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp82_ = _tmp95_;
	}
	if (_tmp82_) {
		ValaSymbolAccessibility _tmp96_;
		ValaSymbolAccessibility _tmp97_;
		_tmp96_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp97_ = _tmp96_;
		_tmp81_ = _tmp97_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp81_ = FALSE;
	}
	if (_tmp81_) {
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaProperty* _tmp100_;
		ValaProperty* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_property_accessor_get_prop (self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = g_strdup_printf ("Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp103_);
		_tmp105_ = _tmp104_;
		vala_report_error (_tmp99_, _tmp105_);
		_g_free0 (_tmp105_);
		_g_free0 (_tmp103_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp106_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp107_ = _tmp106_;
	if (_tmp107_ != NULL) {
		gboolean _tmp108_ = FALSE;
		gboolean _tmp109_;
		ValaBlock* _tmp119_;
		ValaBlock* _tmp120_;
		_tmp109_ = self->priv->_writable;
		if (_tmp109_) {
			_tmp108_ = TRUE;
		} else {
			gboolean _tmp110_;
			_tmp110_ = self->priv->_construction;
			_tmp108_ = _tmp110_;
		}
		if (_tmp108_) {
			ValaBlock* _tmp111_;
			ValaBlock* _tmp112_;
			ValaScope* _tmp113_;
			ValaScope* _tmp114_;
			ValaParameter* _tmp115_;
			const gchar* _tmp116_;
			const gchar* _tmp117_;
			ValaParameter* _tmp118_;
			_tmp111_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_symbol_get_scope ((ValaSymbol*) _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = self->priv->_value_parameter;
			_tmp116_ = vala_symbol_get_name ((ValaSymbol*) _tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = self->priv->_value_parameter;
			vala_scope_add (_tmp114_, _tmp117_, (ValaSymbol*) _tmp118_);
		}
		_tmp119_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp120_ = _tmp119_;
		vala_code_node_check ((ValaCodeNode*) _tmp120_, context);
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp121_;
			ValaBlock* _tmp122_;
			ValaList* _tmp123_;
			gint _body_error_type_size = 0;
			ValaList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _body_error_type_index = 0;
			_tmp121_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp122_);
			_body_error_type_list = _tmp123_;
			_tmp124_ = _body_error_type_list;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
			_tmp126_ = _tmp125_;
			_body_error_type_size = _tmp126_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp127_;
				gint _tmp128_;
				gint _tmp129_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp130_;
				gint _tmp131_;
				gpointer _tmp132_;
				ValaDataType* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				_tmp127_ = _body_error_type_index;
				_body_error_type_index = _tmp127_ + 1;
				_tmp128_ = _body_error_type_index;
				_tmp129_ = _body_error_type_size;
				if (!(_tmp128_ < _tmp129_)) {
					break;
				}
				_tmp130_ = _body_error_type_list;
				_tmp131_ = _body_error_type_index;
				_tmp132_ = vala_list_get (_tmp130_, _tmp131_);
				body_error_type = (ValaDataType*) _tmp132_;
				_tmp133_ = body_error_type;
				_tmp134_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp135_ = _tmp134_;
				if (!_tmp135_) {
					ValaDataType* _tmp136_;
					ValaSourceReference* _tmp137_;
					ValaSourceReference* _tmp138_;
					ValaDataType* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					gchar* _tmp142_;
					gchar* _tmp143_;
					_tmp136_ = body_error_type;
					_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp136_);
					_tmp138_ = _tmp137_;
					_tmp139_ = body_error_type;
					_tmp140_ = vala_code_node_to_string ((ValaCodeNode*) _tmp139_);
					_tmp141_ = _tmp140_;
					_tmp142_ = g_strdup_printf ("unhandled error `%s'", _tmp141_);
					_tmp143_ = _tmp142_;
					vala_report_warning (_tmp138_, _tmp143_);
					_g_free0 (_tmp143_);
					_g_free0 (_tmp141_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp144_ = vala_code_context_get_analyzer (context);
	_tmp145_ = _tmp144_;
	_tmp146_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp145_, _tmp146_);
	_tmp147_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp148_ = _tmp147_;
	result = !_tmp148_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}


static void
vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_accessor_set_value_type (self, new_type);
	}
}


ValaProperty*
vala_property_accessor_get_prop (ValaPropertyAccessor* self)
{
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}


ValaDataType*
vala_property_accessor_get_value_type (ValaPropertyAccessor* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}


gboolean
vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_readable = value;
}


gboolean
vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_writable;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_writable = value;
}


gboolean
vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_construction;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_construction = value;
}


gboolean
vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_automatic_body;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_automatic_body = value;
}


static gboolean
vala_property_accessor_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}


ValaParameter*
vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                            ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp0_;
}


static void
vala_property_accessor_class_init (ValaPropertyAccessorClass * klass)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyAccessorPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_property_accessor_real_get_has_result;
}


static void
vala_property_accessor_instance_init (ValaPropertyAccessor * self)
{
	self->priv = VALA_PROPERTY_ACCESSOR_GET_PRIVATE (self);
}


static void
vala_property_accessor_finalize (ValaCodeNode * obj)
{
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}


/**
 * Represents a get or set accessor of a property in the source code.
 */
GType
vala_property_accessor_get_type (void)
{
	static volatile gsize vala_property_accessor_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
		g_once_init_leave (&vala_property_accessor_type_id__volatile, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__volatile;
}



