/* valaintegertype.c generated by valac, the Vala compiler
 * generated from valaintegertype.vala, do not modify */

/* valaintegertype.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaIntegerTypePrivate {
	gchar* literal_value;
	gchar* literal_type_name;
};


static gpointer vala_integer_type_parent_class = NULL;

#define VALA_INTEGER_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypePrivate))
static ValaDataType* vala_integer_type_real_copy (ValaDataType* base);
static gboolean vala_integer_type_real_compatible (ValaDataType* base,
                                            ValaDataType* target_type);
static void vala_integer_type_finalize (ValaCodeNode * obj);


ValaIntegerType*
vala_integer_type_construct (GType object_type,
                             ValaStruct* type_symbol,
                             const gchar* literal_value,
                             const gchar* literal_type_name)
{
	ValaIntegerType* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (type_symbol != NULL, NULL);
	self = (ValaIntegerType*) vala_value_type_construct (object_type, (ValaTypeSymbol*) type_symbol);
	_tmp0_ = g_strdup (literal_value);
	_g_free0 (self->priv->literal_value);
	self->priv->literal_value = _tmp0_;
	_tmp1_ = g_strdup (literal_type_name);
	_g_free0 (self->priv->literal_type_name);
	self->priv->literal_type_name = _tmp1_;
	return self;
}


ValaIntegerType*
vala_integer_type_new (ValaStruct* type_symbol,
                       const gchar* literal_value,
                       const gchar* literal_type_name)
{
	return vala_integer_type_construct (VALA_TYPE_INTEGER_TYPE, type_symbol, literal_value, literal_type_name);
}


static ValaDataType*
vala_integer_type_real_copy (ValaDataType* base)
{
	ValaIntegerType * self;
	ValaDataType* result = NULL;
	ValaIntegerType* _result_ = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaIntegerType* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	self = (ValaIntegerType*) base;
	_tmp0_ = vala_value_type_get_type_symbol ((ValaValueType*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->literal_value;
	_tmp3_ = self->priv->literal_type_name;
	_tmp4_ = vala_integer_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_STRUCT, ValaStruct), _tmp2_, _tmp3_);
	_result_ = _tmp4_;
	_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _result_, _tmp6_);
	_tmp7_ = vala_data_type_get_value_owned ((ValaDataType*) self);
	_tmp8_ = _tmp7_;
	vala_data_type_set_value_owned ((ValaDataType*) _result_, _tmp8_);
	_tmp9_ = vala_data_type_get_nullable ((ValaDataType*) self);
	_tmp10_ = _tmp9_;
	vala_data_type_set_nullable ((ValaDataType*) _result_, _tmp10_);
	result = (ValaDataType*) _result_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_integer_type_real_compatible (ValaDataType* base,
                                   ValaDataType* target_type)
{
	ValaIntegerType * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	self = (ValaIntegerType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_data_type (target_type);
	_tmp2_ = _tmp1_;
	if (VALA_IS_STRUCT (_tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->literal_type_name;
		_tmp0_ = g_strcmp0 (_tmp3_, "int") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaStruct* target_st = NULL;
		ValaTypeSymbol* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaStruct* _tmp6_;
		ValaStruct* _tmp7_;
		_tmp4_ = vala_data_type_get_data_type (target_type);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_STRUCT, ValaStruct));
		target_st = _tmp6_;
		_tmp7_ = target_st;
		if (vala_struct_is_integer_type (_tmp7_)) {
			ValaAttribute* int_attr = NULL;
			ValaStruct* _tmp8_;
			ValaAttribute* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaAttribute* _tmp12_;
			_tmp8_ = target_st;
			_tmp9_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp8_, "IntegerType");
			int_attr = _tmp9_;
			_tmp12_ = int_attr;
			if (_tmp12_ != NULL) {
				ValaAttribute* _tmp13_;
				_tmp13_ = int_attr;
				_tmp11_ = vala_attribute_has_argument (_tmp13_, "min");
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaAttribute* _tmp14_;
				_tmp14_ = int_attr;
				_tmp10_ = vala_attribute_has_argument (_tmp14_, "max");
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gint val = 0;
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gint _tmp17_;
				ValaAttribute* _tmp18_;
				_tmp15_ = self->priv->literal_value;
				val = atoi (_tmp15_);
				_tmp17_ = val;
				_tmp18_ = int_attr;
				if (_tmp17_ >= vala_attribute_get_integer (_tmp18_, "min", 0)) {
					gint _tmp19_;
					ValaAttribute* _tmp20_;
					_tmp19_ = val;
					_tmp20_ = int_attr;
					_tmp16_ = _tmp19_ <= vala_attribute_get_integer (_tmp20_, "max", 0);
				} else {
					_tmp16_ = FALSE;
				}
				result = _tmp16_;
				_vala_code_node_unref0 (int_attr);
				_vala_code_node_unref0 (target_st);
				return result;
			} else {
				result = TRUE;
				_vala_code_node_unref0 (int_attr);
				_vala_code_node_unref0 (target_st);
				return result;
			}
			_vala_code_node_unref0 (int_attr);
		}
		_vala_code_node_unref0 (target_st);
	} else {
		gboolean _tmp21_ = FALSE;
		ValaTypeSymbol* _tmp22_;
		ValaTypeSymbol* _tmp23_;
		_tmp22_ = vala_data_type_get_data_type (target_type);
		_tmp23_ = _tmp22_;
		if (VALA_IS_ENUM (_tmp23_)) {
			gboolean _tmp24_ = FALSE;
			const gchar* _tmp25_;
			_tmp25_ = self->priv->literal_type_name;
			if (g_strcmp0 (_tmp25_, "int") == 0) {
				_tmp24_ = TRUE;
			} else {
				const gchar* _tmp26_;
				_tmp26_ = self->priv->literal_type_name;
				_tmp24_ = g_strcmp0 (_tmp26_, "uint") == 0;
			}
			_tmp21_ = _tmp24_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			const gchar* _tmp27_;
			_tmp27_ = self->priv->literal_value;
			if (atoi (_tmp27_) == 0) {
				result = TRUE;
				return result;
			}
		}
	}
	result = VALA_DATA_TYPE_CLASS (vala_integer_type_parent_class)->compatible ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_VALUE_TYPE, ValaValueType), target_type);
	return result;
}


static void
vala_integer_type_class_init (ValaIntegerTypeClass * klass)
{
	vala_integer_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_integer_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaIntegerTypePrivate));
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType*)) vala_integer_type_real_copy;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_integer_type_real_compatible;
}


static void
vala_integer_type_instance_init (ValaIntegerType * self)
{
	self->priv = VALA_INTEGER_TYPE_GET_PRIVATE (self);
}


static void
vala_integer_type_finalize (ValaCodeNode * obj)
{
	ValaIntegerType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTEGER_TYPE, ValaIntegerType);
	_g_free0 (self->priv->literal_value);
	_g_free0 (self->priv->literal_type_name);
	VALA_CODE_NODE_CLASS (vala_integer_type_parent_class)->finalize (obj);
}


/**
 * An integer type.
 */
GType
vala_integer_type_get_type (void)
{
	static volatile gsize vala_integer_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_integer_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaIntegerTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_integer_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaIntegerType), 0, (GInstanceInitFunc) vala_integer_type_instance_init, NULL };
		GType vala_integer_type_type_id;
		vala_integer_type_type_id = g_type_register_static (VALA_TYPE_VALUE_TYPE, "ValaIntegerType", &g_define_type_info, 0);
		g_once_init_leave (&vala_integer_type_type_id__volatile, vala_integer_type_type_id);
	}
	return vala_integer_type_type_id__volatile;
}



