// Copyright 2017 Ryan Wick (rrwick@gmail.com)
// https://github.com/rrwick/Unicycler

// This file is part of Unicycler. Unicycler is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later version. Unicycler is
// distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details. You should have received a copy of the GNU General Public
// License along with Unicycler. If not, see <http://www.gnu.org/licenses/>.

#ifndef MINIMAP_ALIGN_H
#define MINIMAP_ALIGN_H

#include "minimap/minimap.h"
#include "minimap/kseq.h"
#include <string>

// Functions that are called by the Python script must have C linkage, not C++ linkage.
extern "C" {

    char * minimapAlignReads(char * referenceFasta, char * readsFastq, int n_threads,
                             int sensitivityLevel, int preset);

    char * minimapAlignReadsWithSettings(char * referenceFasta, char * readsFastq, int n_threads,
                                         bool allVsAll, int kmerSize, int minimiserSize,
                                         float mergeFrac, int minMatchLength, int maxGap,
                                         int bandwidth, int minMinimiserCount);
}

#endif // MINIMAP_ALIGN_H

