/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef POWERTRAY_H
#define POWERTRAY_H

#include <QMainWindow>
#include <QGSettings>
#include <QSystemTrayIcon>
#include <QMenu>
#include <QTimer>

#include "powerwindow.h"
#include "powersupplydev.h"
#include "criticalpercentageaction.h"

class PowerTray : public QObject
{
    Q_OBJECT
public:
    explicit PowerTray(QObject *parent = 0);
    ~PowerTray();

    void initPowerTray();

private:
    void setTrayIconToolTipForAcOnlineChanged(bool acOnlineState, double percentage);
    void setTrayIconToolTipForBatteryInfoChanged(double percentage);
    void setTrayIcon(QString strIconName);
    void initTrayMenuUI();
    void initPowerWindowUI();
    void setPowerWindowProperties();
    void updateBatteryInfo();
    void acOnlineStateChangedAction();

private:
    PowerSupplyDev  *m_powerSupplyDev;

    QTimer          *m_acChangeTimer;
    bool            m_isPowerSupplyChange;

    QGSettings      *m_settings;
    int             m_showBatteryLeftTime;
    QMenu           *m_TrayMenu;

    powerwindow     *m_powerWindow;
    QSystemTrayIcon *m_trayIcon;

    bool            m_acOnlineState;
    int             m_batteryState;
    double          m_batteryPercentage;
    QString         m_trayIconName;
    CriticalPercentageAction *m_criticalPercentageAction;
    NotificationDialog *m_dialog;
private Q_SLOTS:
    void onActivatedIcon(QSystemTrayIcon::ActivationReason reason);

    void dealAcOnlineStateChanged(int, bool);
    void dealBatteryInfoChanged(int, QStringList);

};

#endif // POWERTRAY_H
