/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef CRITICALPERCENTAGEACTION_H
#define CRITICALPERCENTAGEACTION_H

#include <QObject>
#include <QTimer>
#include <QGSettings>

#include "powersupplydev.h"
#include "notificationdialog.h"
#include "fullscreenmask.h"

class CriticalPercentageAction : public QObject
{
    Q_OBJECT
public:
    explicit CriticalPercentageAction(PowerSupplyDev *powerSupplyDev, QObject *parent = nullptr);
    ~CriticalPercentageAction();
private:
    PowerSupplyDev  *m_powerSupplyDev;
    bool            m_acOnlineState;
    double          m_batteryPercentage;

    QGSettings      *m_settings;
    QTimer          *m_timer;
    int             m_criticalPercentage;
    QString         m_action;

    NotificationDialog *m_notificationDialog;
    FullScreenMask *m_fullScreenMask;
    bool            m_criticalState;

    void dealAction();
    void stopAction();
    void doAction();

private Q_SLOTS:
    void dealAcOnlineStateChanged(int, bool);
    void dealBatteryInfoChanged(int, QStringList);

};

#endif // CRITICALPERCENTAGEACTION_H
