//
// Copyright 2021 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: lo_control_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // LO_SPI_SETUP/LO_SPI_STATUS : 0x0 (lo_control.v, lo_control.v)
  // LO_PULSE_SYNC              : 0x4 (lo_control.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group LO_SPI_REGISTERS
//===============================================================================

  // Enumerated type LO_CHIP_SELECT
  localparam LO_CHIP_SELECT_SIZE = 8;
  localparam TX0_LO1  = 'h0;  // LO_CHIP_SELECT:TX0_LO1
  localparam TX0_LO2  = 'h1;  // LO_CHIP_SELECT:TX0_LO2
  localparam TX1_LO1  = 'h2;  // LO_CHIP_SELECT:TX1_LO1
  localparam TX1_LO2  = 'h3;  // LO_CHIP_SELECT:TX1_LO2
  localparam RX0_LO1  = 'h4;  // LO_CHIP_SELECT:RX0_LO1
  localparam RX0_LO2  = 'h5;  // LO_CHIP_SELECT:RX0_LO2
  localparam RX1_LO1  = 'h6;  // LO_CHIP_SELECT:RX1_LO1
  localparam RX1_LO2  = 'h7;  // LO_CHIP_SELECT:RX1_LO2

  // LO_SPI_SETUP Register (from lo_control.v)
  localparam LO_SPI_SETUP = 'h0; // Register Offset
  localparam LO_SPI_SETUP_SIZE = 32;  // register width in bits
  localparam LO_SPI_SETUP_MASK = 32'h17FFFFFF;
  localparam LO_SPI_WT_DATA_SIZE = 16;  //LO_SPI_SETUP:LO_SPI_WT_DATA
  localparam LO_SPI_WT_DATA_MSB  = 15;  //LO_SPI_SETUP:LO_SPI_WT_DATA
  localparam LO_SPI_WT_DATA      =  0;  //LO_SPI_SETUP:LO_SPI_WT_DATA
  localparam LO_SPI_WT_ADDR_SIZE =  7;  //LO_SPI_SETUP:LO_SPI_WT_ADDR
  localparam LO_SPI_WT_ADDR_MSB  = 22;  //LO_SPI_SETUP:LO_SPI_WT_ADDR
  localparam LO_SPI_WT_ADDR      = 16;  //LO_SPI_SETUP:LO_SPI_WT_ADDR
  localparam LO_SPI_RD_SIZE =  1;  //LO_SPI_SETUP:LO_SPI_RD
  localparam LO_SPI_RD_MSB  = 23;  //LO_SPI_SETUP:LO_SPI_RD
  localparam LO_SPI_RD      = 23;  //LO_SPI_SETUP:LO_SPI_RD
  localparam LO_SELECT_SIZE =  3;  //LO_SPI_SETUP:LO_SELECT
  localparam LO_SELECT_MSB  = 26;  //LO_SPI_SETUP:LO_SELECT
  localparam LO_SELECT      = 24;  //LO_SPI_SETUP:LO_SELECT
  localparam LO_SPI_START_TRANSACTION_SIZE =  1;  //LO_SPI_SETUP:LO_SPI_START_TRANSACTION
  localparam LO_SPI_START_TRANSACTION_MSB  = 28;  //LO_SPI_SETUP:LO_SPI_START_TRANSACTION
  localparam LO_SPI_START_TRANSACTION      = 28;  //LO_SPI_SETUP:LO_SPI_START_TRANSACTION

  // LO_SPI_STATUS Register (from lo_control.v)
  localparam LO_SPI_STATUS = 'h0; // Register Offset
  localparam LO_SPI_STATUS_SIZE = 32;  // register width in bits
  localparam LO_SPI_STATUS_MASK = 32'hC77FFFFF;
  localparam LO_SPI_RD_DATA_SIZE = 16;  //LO_SPI_STATUS:LO_SPI_RD_DATA
  localparam LO_SPI_RD_DATA_MSB  = 15;  //LO_SPI_STATUS:LO_SPI_RD_DATA
  localparam LO_SPI_RD_DATA      =  0;  //LO_SPI_STATUS:LO_SPI_RD_DATA
  localparam LO_SPI_RD_ADDR_SIZE =  7;  //LO_SPI_STATUS:LO_SPI_RD_ADDR
  localparam LO_SPI_RD_ADDR_MSB  = 22;  //LO_SPI_STATUS:LO_SPI_RD_ADDR
  localparam LO_SPI_RD_ADDR      = 16;  //LO_SPI_STATUS:LO_SPI_RD_ADDR
  localparam LO_SELECT_STATUS_SIZE =  3;  //LO_SPI_STATUS:LO_SELECT_STATUS
  localparam LO_SELECT_STATUS_MSB  = 26;  //LO_SPI_STATUS:LO_SELECT_STATUS
  localparam LO_SELECT_STATUS      = 24;  //LO_SPI_STATUS:LO_SELECT_STATUS
  localparam LO_SPI_READY_SIZE =  1;  //LO_SPI_STATUS:LO_SPI_READY
  localparam LO_SPI_READY_MSB  = 30;  //LO_SPI_STATUS:LO_SPI_READY
  localparam LO_SPI_READY      = 30;  //LO_SPI_STATUS:LO_SPI_READY
  localparam LO_SPI_DATA_VALID_SIZE =  1;  //LO_SPI_STATUS:LO_SPI_DATA_VALID
  localparam LO_SPI_DATA_VALID_MSB  = 31;  //LO_SPI_STATUS:LO_SPI_DATA_VALID
  localparam LO_SPI_DATA_VALID      = 31;  //LO_SPI_STATUS:LO_SPI_DATA_VALID

//===============================================================================
// Register Group LO_SYNC_REGS
//===============================================================================

  // LO_PULSE_SYNC Register (from lo_control.v)
  localparam LO_PULSE_SYNC = 'h4; // Register Offset
  localparam LO_PULSE_SYNC_SIZE = 32;  // register width in bits
  localparam LO_PULSE_SYNC_MASK = 32'h1FF;
  localparam PULSE_TX0_LO1_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_TX0_LO1_SYNC
  localparam PULSE_TX0_LO1_SYNC_MSB  = 0;  //LO_PULSE_SYNC:PULSE_TX0_LO1_SYNC
  localparam PULSE_TX0_LO1_SYNC      = 0;  //LO_PULSE_SYNC:PULSE_TX0_LO1_SYNC
  localparam PULSE_TX0_LO2_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_TX0_LO2_SYNC
  localparam PULSE_TX0_LO2_SYNC_MSB  = 1;  //LO_PULSE_SYNC:PULSE_TX0_LO2_SYNC
  localparam PULSE_TX0_LO2_SYNC      = 1;  //LO_PULSE_SYNC:PULSE_TX0_LO2_SYNC
  localparam PULSE_TX1_LO1_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_TX1_LO1_SYNC
  localparam PULSE_TX1_LO1_SYNC_MSB  = 2;  //LO_PULSE_SYNC:PULSE_TX1_LO1_SYNC
  localparam PULSE_TX1_LO1_SYNC      = 2;  //LO_PULSE_SYNC:PULSE_TX1_LO1_SYNC
  localparam PULSE_TX1_LO2_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_TX1_LO2_SYNC
  localparam PULSE_TX1_LO2_SYNC_MSB  = 3;  //LO_PULSE_SYNC:PULSE_TX1_LO2_SYNC
  localparam PULSE_TX1_LO2_SYNC      = 3;  //LO_PULSE_SYNC:PULSE_TX1_LO2_SYNC
  localparam PULSE_RX0_LO1_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_RX0_LO1_SYNC
  localparam PULSE_RX0_LO1_SYNC_MSB  = 4;  //LO_PULSE_SYNC:PULSE_RX0_LO1_SYNC
  localparam PULSE_RX0_LO1_SYNC      = 4;  //LO_PULSE_SYNC:PULSE_RX0_LO1_SYNC
  localparam PULSE_RX0_LO2_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_RX0_LO2_SYNC
  localparam PULSE_RX0_LO2_SYNC_MSB  = 5;  //LO_PULSE_SYNC:PULSE_RX0_LO2_SYNC
  localparam PULSE_RX0_LO2_SYNC      = 5;  //LO_PULSE_SYNC:PULSE_RX0_LO2_SYNC
  localparam PULSE_RX1_LO1_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_RX1_LO1_SYNC
  localparam PULSE_RX1_LO1_SYNC_MSB  = 6;  //LO_PULSE_SYNC:PULSE_RX1_LO1_SYNC
  localparam PULSE_RX1_LO1_SYNC      = 6;  //LO_PULSE_SYNC:PULSE_RX1_LO1_SYNC
  localparam PULSE_RX1_LO2_SYNC_SIZE = 1;  //LO_PULSE_SYNC:PULSE_RX1_LO2_SYNC
  localparam PULSE_RX1_LO2_SYNC_MSB  = 7;  //LO_PULSE_SYNC:PULSE_RX1_LO2_SYNC
  localparam PULSE_RX1_LO2_SYNC      = 7;  //LO_PULSE_SYNC:PULSE_RX1_LO2_SYNC
  localparam BYPASS_SYNC_REGISTER_SIZE = 1;  //LO_PULSE_SYNC:BYPASS_SYNC_REGISTER
  localparam BYPASS_SYNC_REGISTER_MSB  = 8;  //LO_PULSE_SYNC:BYPASS_SYNC_REGISTER
  localparam BYPASS_SYNC_REGISTER      = 8;  //LO_PULSE_SYNC:BYPASS_SYNC_REGISTER
