
#
# Build settings that are independent of compiler version.
#

# Base of Trilinos/cmake/ctest then BUILD_DIR_NAME

SET( CTEST_DASHBOARD_ROOT "${TRILINOS_CMAKE_DIR}/../../${BUILD_DIR_NAME}" )

SET( CTEST_NOTES_FILES "${CTEST_SCRIPT_DIRECTORY}/${CTEST_SCRIPT_NAME}" )

SET( CTEST_BUILD_FLAGS "-j10 -i" )

SET_DEFAULT( CTEST_PARALLEL_LEVEL "11" )

SET_DEFAULT( Trilinos_ENABLE_SECONDARY_TESTED_CODE ON)

# Only turn on PyTrilinos for shared libraries
SET_DEFAULT( Trilinos_EXCLUDE_PACKAGES ${EXTRA_EXCLUDE_PACKAGES} PyTrilinos TriKota Optika)
  
IF (COMM_TYPE STREQUAL MPI)
    SET(TPL_ENABLE_MPI ON)
ENDIF()

SET( EXTRA_SYSTEM_CONFIGURE_OPTIONS
  "-DCMAKE_BUILD_TYPE:STRING=${BUILD_TYPE}"
  "-DTrilinos_ENABLE_DEPENCENCY_UNIT_TESTS:BOOL=OFF"
  "-DCMAKE_VERBOSE_MAKEFILE:BOOL=TRUE"
  "-DTrilinos_ENABLE_TriKota:BOOL=OFF"
  "-DSuperLU_INCLUDE_DIRS:PATH=/home/trilinos/tpl/gcc/SuperLU_4.3/SRC"
  "-DSuperLU_LIBRARY_DIRS:PATH=/home/trilinos/tpl/gcc/SuperLU_4.3/lib"
  "-DSuperLU_LIBRARY_NAMES:STRING=superlu_4.3"
  "-DTPL_ENABLE_BinUtils=ON"
  "-DTPL_ENABLE_Matio=OFF"
  "-DTPL_ENABLE_SuperLU=ON"
  "-DIntrepid_ENABLE_DEBUG_INF_CHECK=OFF"
  )

