/* Copyright (C) 2006,2007 Daiki Ueno <ueno@unixuser.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

typedef struct heap_entry {
  long rank;
  void *value;
} *heap_entry_t;

typedef struct heap {
  long len, cap;
  heap_entry_t *array;
} *heap_t;

heap_t heap_new (long cap);
void heap_free (heap_t heap);

long heap_insert (heap_t heap, heap_entry_t entry);
heap_entry_t heap_delete (heap_t heap);
