/***********************************************************************
* File name:                                                           *
* Written by:                                                          *
* Created:                                                             *
* Language: C                                                          *
* Version: 1.0                                                         *
* Purpose:                                                             *
* Callable Module:                                                     *
*                                                                      *
* Parameters:                                                          *
*   Input:                                                             *
*                                                                      *
*   Input/Output:                                                      *
*                                                                      *
*   Output:                                                            *
*                                                                      *
*                                                                      *
*                                                                      *
***********************************************************************/


/*$Log: tpconfig.h,v $
 *Revision 1.3  2000/10/31 18:03:46  cph
 *Move variable declarations from .h file to .c file.  Add exports for utilities.
 *
 *Revision 1.2  2000/10/31 15:20:54  cph
 *Define PS/2 mouse commands.  Add support for Linux kernel patch.  Put
 *newline at end of fatal error message.
 *
 *Revision 1.1  2000/09/28 18:50:57  bruce
 *Initial revision
 **/

/* $Header: /usr/local/src/tpconfig-3.0.1/RCS/tpconfig.h,v 1.3 2000/10/31 18:03:46 cph Exp $ */

#define DEBUG_HIGH 3
#define DEBUG_MEDIUM 2
#define DEBUG_LOW 1
#define DEBUG_NONE 0 
 
#define TRUE 1
#define FALSE 0
#define ERROR 1
#define NO_ERROR 0

#ifdef __linux
/* Define this if you've patched your kernel. */
#define PATCHED_LINUX_KERNEL
#endif

/* Standard PS/2 mouse commands */
#define AUX_SET_SCALE11		0xE6	/* Set 1:1 scaling */
#define AUX_SET_SCALE21		0xE7	/* Set 2:1 scaling */
#define AUX_SET_RES		0xE8	/* Set resolution */
#define AUX_GET_STATUS		0xE9	/* Get scaling factor */
#define AUX_SET_STREAM		0xEA	/* Set stream mode */
#define AUX_SET_SAMPLE		0xF3	/* Set sample rate */
#define AUX_ENABLE_DEV		0xF4	/* Enable aux device */
#define AUX_DISABLE_DEV		0xF5	/* Disable aux device */
#define AUX_ACK			0xFA	/* Command byte ACK. */
#define AUX_RESET		0xFF	/* Reset aux device */
#define AUX_RESET_ACK1		0xAA
#define AUX_RESET_ACK2		0x00

#define SYNAPTICS_TOUCHPAD 1
#define ALPS_GLIDEPAD 2
#define ALPS_STICKPOINTER_AND_GLIDEPOINT 3

#define fatal(string) \
{ fprintf(stderr, "fatal: %s\n", string); exit(1); }

/* Prototypes for PS/2 utility functions */
typedef unsigned char byte;

extern int DEBUG_LEVEL;
extern int silent;
extern float firmware_rev;
extern char single_mode_byte;
extern int touchpad_type;

extern void version_info (void);
extern void copyright (void);
extern void putbyte (int fd, byte b);
extern byte getbyte (int fd);
extern void getbyte_expected (int fd, byte expected, const char * what);
