-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2017  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Ada.Text_IO;
with Misc;        use Misc;

package body Externals.Ops is

   function Get_MD5Sum_Of_File (Filename : String) return UBS is
      CH         : Ada.Text_IO.File_Type;
      MD5        : UBS;
      Cache_File : constant String         := Temp_File_Name("cachename");
      E1, E2     : Integer;
   begin
      ForkExec2_Out(Value_Nonempty(Config.Binary(Md5sum)),
                    UBS_Array'(0 => ToUBS("md5sum"),
                               1 => ToUBS(Filename)),
                    E1,
                    Value_Nonempty(Config.Binary(Sed)),
                    UBS_Array'(0 => ToUBS("sed"),
                               1 => ToUBS("s/ .*//")),
                    E2,
                    Target => Cache_File);
      if E1 /= 0 then
         Error("md5sum failed! (ff8)");
      elsif E2 /= 0 then
         Error("sed failed! (ff9)");
      end if;
      Ada.Text_IO.Open(File => CH,
                       Mode => Ada.Text_IO.In_File,
                       Name => Cache_File);
      MD5 := Unbounded_Get_Line(CH);
      Ada.Text_IO.Close(CH);
      return MD5;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Externals.Ops.Get_MD5Sum_Of_File");
         raise;
   end Get_MD5Sum_Of_File;

   function Test_Decrypt_Prerequisite return Integer is
   begin
      return ForkExec(ToStr(Config.UBS_Opts(Decrypt_Prereq)),
                      Config.UBS_Opts(Decrypt_Prereq));
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Externals.Ops.Test_Decrypt_Prequisite");
         raise;
   end Test_Decrypt_Prerequisite;

   procedure Open_TTY is
      TTY_FD : Integer;
   begin
      CClose(0);
      CClose(1);
      CClose(2);
      TTY_FD := Open_In("/dev/tty");
      Dup2(TTY_FD, 0);
      TTY_FD := Open_Out("/dev/tty");
      Dup2(TTY_FD, 1);
      Dup2(TTY_FD, 2);
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Externals.Ops.Open_TTY");
         raise;
   end Open_TTY;




end Externals.Ops;
