/*
 * Copyright 2013 Trend Micro Incorporated
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Util definition and functions
 */
 
#include <cmath> 

// Pearson's sample random table
static unsigned char v_table[256] = {
    1, 87, 49, 12, 176, 178, 102, 166, 121, 193, 6, 84, 249, 230, 44, 163,
    14, 197, 213, 181, 161, 85, 218, 80, 64, 239, 24, 226, 236, 142, 38, 200,
    110, 177, 104, 103, 141, 253, 255, 50, 77, 101, 81, 18, 45, 96, 31, 222,
    25, 107, 190, 70, 86, 237, 240, 34, 72, 242, 20, 214, 244, 227, 149, 235,
    97, 234, 57, 22, 60, 250, 82, 175, 208, 5, 127, 199, 111, 62, 135, 248,
    174, 169, 211, 58, 66, 154, 106, 195, 245, 171, 17, 187, 182, 179, 0, 243,
    132, 56, 148, 75, 128, 133, 158, 100, 130, 126, 91, 13, 153, 246, 216, 219,
    119, 68, 223, 78, 83, 88, 201, 99, 122, 11, 92, 32, 136, 114, 52, 10,
    138, 30, 48, 183, 156, 35, 61, 26, 143, 74, 251, 94, 129, 162, 63, 152,
    170, 7, 115, 167, 241, 206, 3, 150, 55, 59, 151, 220, 90, 53, 23, 131,
    125, 173, 15, 238, 79, 95, 89, 16, 105, 137, 225, 224, 217, 160, 37, 123,
    118, 73, 2, 157, 46, 116, 9, 145, 134, 228, 207, 212, 202, 215, 69, 229,
    27, 188, 67, 124, 168, 252, 42, 4, 29, 108, 21, 247, 19, 205, 39, 203,
    233, 40, 186, 147, 198, 192, 155, 33, 164, 191, 98, 204, 165, 180, 117, 76,
    140, 36, 210, 172, 41, 54, 159, 8, 185, 232, 113, 196, 231, 47, 146, 120,
    51, 65, 28, 144, 254, 221, 93, 189, 194, 139, 112, 43, 71, 109, 184, 209
};

// Compile and run gen_arr2.cpp to generate bit_pairs_diff_table
static unsigned char bit_pairs_diff_table[][256] = {
{
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 18, 19, 20, 24
},
{
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 19, 18, 19, 20
},
{
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 20, 19, 18, 19
},
{
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 24, 20, 19, 18
},
{
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20
},
{
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16
},
{
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15
},
{
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14
},
{
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19
},
{
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15
},
{
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14
},
{
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13
},
{
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
18, 19, 20, 24, 14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18
},
{
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
19, 18, 19, 20, 15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14
},
{
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
20, 19, 18, 19, 16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13
},
{
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
24, 20, 19, 18, 20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12
},
{
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20
},
{
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16
},
{
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15
},
{
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14
},
{
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16
},
{
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12
},
{
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11
},
{
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10
},
{
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15
},
{
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11
},
{
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10
},
{
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9
},
{
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14
},
{
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10
},
{
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9
},
{
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8
},
{
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19
},
{
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15
},
{
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14
},
{
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13
},
{
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15
},
{
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11
},
{
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10
},
{
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9
},
{
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14
},
{
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10
},
{
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9
},
{
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8
},
{
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13
},
{
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9
},
{
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8
},
{
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7
},
{
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 18, 19, 20, 24, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18
},
{
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 19, 18, 19, 20, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14
},
{
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 20, 19, 18, 19, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13
},
{
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 24, 20, 19, 18, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12
},
{
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14
},
{
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10
},
{
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9
},
{
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8
},
{
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13
},
{
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9
},
{
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8
},
{
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7
},
{
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
18, 19, 20, 24, 14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12
},
{
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
19, 18, 19, 20, 15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8
},
{
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
20, 19, 18, 19, 16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7
},
{
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
24, 20, 19, 18, 20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6
},
{
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20
},
{
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16
},
{
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15
},
{
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14
},
{
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16
},
{
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12
},
{
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11
},
{
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10
},
{
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15
},
{
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11
},
{
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10
},
{
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9
},
{
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14
},
{
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10
},
{
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9
},
{
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8
},
{
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16
},
{
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12
},
{
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11
},
{
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10
},
{
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12
},
{
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8
},
{
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7
},
{
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6
},
{
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11
},
{
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7
},
{
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6
},
{
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5
},
{
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10
},
{
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6
},
{
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5
},
{
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4
},
{
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15
},
{
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11
},
{
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10
},
{
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9
},
{
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11
},
{
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7
},
{
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6
},
{
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5
},
{
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10
},
{
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6
},
{
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5
},
{
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4
},
{
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9
},
{
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5
},
{
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4
},
{
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3
},
{
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14
},
{
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10
},
{
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9
},
{
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8
},
{
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10
},
{
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6
},
{
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5
},
{
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4
},
{
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9
},
{
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5
},
{
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4
},
{
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3
},
{
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8
},
{
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4
},
{
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3
},
{
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2
},
{
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19
},
{
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15
},
{
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14
},
{
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13
},
{
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15
},
{
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11
},
{
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10
},
{
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9
},
{
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14
},
{
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10
},
{
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9
},
{
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8
},
{
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13
},
{
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9
},
{
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8
},
{
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7
},
{
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15
},
{
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11
},
{
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10
},
{
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9
},
{
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11
},
{
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7
},
{
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6
},
{
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5
},
{
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10
},
{
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6
},
{
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5
},
{
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4
},
{
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9
},
{
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5
},
{
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4
},
{
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3
},
{
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14
},
{
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10
},
{
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9
},
{
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8
},
{
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10
},
{
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6
},
{
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5
},
{
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4
},
{
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9
},
{
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5
},
{
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4
},
{
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3
},
{
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8
},
{
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4
},
{
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3
},
{
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2
},
{
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13
},
{
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9
},
{
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8
},
{
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7
},
{
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9
},
{
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5
},
{
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4
},
{
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3
},
{
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8
},
{
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4
},
{
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3
},
{
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2
},
{
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7
},
{
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3
},
{
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2
},
{
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1
},
{
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 18, 19, 20, 24, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18
},
{
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 19, 18, 19, 20, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14
},
{
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 20, 19, 18, 19, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13
},
{
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 24, 20, 19, 18, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12
},
{
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14
},
{
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10
},
{
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9
},
{
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8
},
{
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13
},
{
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9
},
{
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8
},
{
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7
},
{
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
18, 19, 20, 24, 14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12
},
{
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
19, 18, 19, 20, 15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8
},
{
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
20, 19, 18, 19, 16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7
},
{
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
24, 20, 19, 18, 20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6
},
{
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14
},
{
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10
},
{
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9
},
{
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8
},
{
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10
},
{
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6
},
{
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5
},
{
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4
},
{
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9
},
{
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5
},
{
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4
},
{
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3
},
{
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8
},
{
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4
},
{
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3
},
{
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2
},
{
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13
},
{
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9
},
{
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8
},
{
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7
},
{
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9
},
{
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5
},
{
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4
},
{
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3
},
{
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8
},
{
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4
},
{
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3
},
{
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2
},
{
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7
},
{
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3
},
{
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2
},
{
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1
},
{
12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 18, 19, 20, 24, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 14, 15, 16, 20, 
4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 10, 11, 12, 16, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 13, 14, 15, 19, 
3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 9, 10, 11, 15, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 12, 13, 14, 18, 
2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 8, 9, 10, 14, 
1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 7, 8, 9, 13, 
0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8, 6, 7, 8, 12
},
{
13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 19, 18, 19, 20, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 15, 14, 15, 16, 
5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 11, 10, 11, 12, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 14, 13, 14, 15, 
4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 10, 9, 10, 11, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 13, 12, 13, 14, 
3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 9, 8, 9, 10, 
2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 8, 7, 8, 9, 
1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4, 7, 6, 7, 8
},
{
14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 20, 19, 18, 19, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 16, 15, 14, 15, 
6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 12, 11, 10, 11, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 15, 14, 13, 14, 
5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 11, 10, 9, 10, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 14, 13, 12, 13, 
4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 10, 9, 8, 9, 
3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 9, 8, 7, 8, 
2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3, 8, 7, 6, 7
},
{
18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 24, 20, 19, 18, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 20, 16, 15, 14, 
10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 16, 12, 11, 10, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 19, 15, 14, 13, 
9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 15, 11, 10, 9, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 18, 14, 13, 12, 
8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 14, 10, 9, 8, 
7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 13, 9, 8, 7, 
6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2, 12, 8, 7, 6
},
{
13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 14, 15, 16, 20, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 10, 11, 12, 16, 
5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 6, 7, 8, 12, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 9, 10, 11, 15, 
4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 5, 6, 7, 11, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 8, 9, 10, 14, 
3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 4, 5, 6, 10, 
2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 3, 4, 5, 9, 
1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7, 2, 3, 4, 8
},
{
14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 15, 14, 15, 16, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 11, 10, 11, 12, 
6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 7, 6, 7, 8, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 10, 9, 10, 11, 
5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 6, 5, 6, 7, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 9, 8, 9, 10, 
4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 5, 4, 5, 6, 
3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 4, 3, 4, 5, 
2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3, 3, 2, 3, 4
},
{
15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 16, 15, 14, 15, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 12, 11, 10, 11, 
7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 8, 7, 6, 7, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 11, 10, 9, 10, 
6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 7, 6, 5, 6, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 10, 9, 8, 9, 
5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 6, 5, 4, 5, 
4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 5, 4, 3, 4, 
3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2, 4, 3, 2, 3
},
{
19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 20, 16, 15, 14, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 16, 12, 11, 10, 
11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 12, 8, 7, 6, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 15, 11, 10, 9, 
10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 11, 7, 6, 5, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 14, 10, 9, 8, 
9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 10, 6, 5, 4, 
8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 9, 5, 4, 3, 
7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1, 8, 4, 3, 2
},
{
14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 13, 14, 15, 19, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 9, 10, 11, 15, 
6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 5, 6, 7, 11, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 8, 9, 10, 14, 
5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 4, 5, 6, 10, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 7, 8, 9, 13, 
4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 3, 4, 5, 9, 
3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 2, 3, 4, 8, 
2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6, 1, 2, 3, 7
},
{
15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 14, 13, 14, 15, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 10, 9, 10, 11, 
7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 6, 5, 6, 7, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 9, 8, 9, 10, 
6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 5, 4, 5, 6, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 8, 7, 8, 9, 
5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 4, 3, 4, 5, 
4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 3, 2, 3, 4, 
3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2, 2, 1, 2, 3
},
{
16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 15, 14, 13, 14, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 11, 10, 9, 10, 
8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 7, 6, 5, 6, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 10, 9, 8, 9, 
7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 6, 5, 4, 5, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 9, 8, 7, 8, 
6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 5, 4, 3, 4, 
5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 4, 3, 2, 3, 
4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1, 3, 2, 1, 2
},
{
20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 19, 15, 14, 13, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 15, 11, 10, 9, 
12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 11, 7, 6, 5, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 14, 10, 9, 8, 
11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 10, 6, 5, 4, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 13, 9, 8, 7, 
10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 9, 5, 4, 3, 
9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 8, 4, 3, 2, 
8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0, 7, 3, 2, 1
},
{
18, 19, 20, 24, 14, 15, 16, 20, 13, 14, 15, 19, 12, 13, 14, 18, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
14, 15, 16, 20, 10, 11, 12, 16, 9, 10, 11, 15, 8, 9, 10, 14, 
10, 11, 12, 16, 6, 7, 8, 12, 5, 6, 7, 11, 4, 5, 6, 10, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
13, 14, 15, 19, 9, 10, 11, 15, 8, 9, 10, 14, 7, 8, 9, 13, 
9, 10, 11, 15, 5, 6, 7, 11, 4, 5, 6, 10, 3, 4, 5, 9, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
12, 13, 14, 18, 8, 9, 10, 14, 7, 8, 9, 13, 6, 7, 8, 12, 
8, 9, 10, 14, 4, 5, 6, 10, 3, 4, 5, 9, 2, 3, 4, 8, 
7, 8, 9, 13, 3, 4, 5, 9, 2, 3, 4, 8, 1, 2, 3, 7, 
6, 7, 8, 12, 2, 3, 4, 8, 1, 2, 3, 7, 0, 1, 2, 6
},
{
19, 18, 19, 20, 15, 14, 15, 16, 14, 13, 14, 15, 13, 12, 13, 14, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
15, 14, 15, 16, 11, 10, 11, 12, 10, 9, 10, 11, 9, 8, 9, 10, 
11, 10, 11, 12, 7, 6, 7, 8, 6, 5, 6, 7, 5, 4, 5, 6, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
14, 13, 14, 15, 10, 9, 10, 11, 9, 8, 9, 10, 8, 7, 8, 9, 
10, 9, 10, 11, 6, 5, 6, 7, 5, 4, 5, 6, 4, 3, 4, 5, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
13, 12, 13, 14, 9, 8, 9, 10, 8, 7, 8, 9, 7, 6, 7, 8, 
9, 8, 9, 10, 5, 4, 5, 6, 4, 3, 4, 5, 3, 2, 3, 4, 
8, 7, 8, 9, 4, 3, 4, 5, 3, 2, 3, 4, 2, 1, 2, 3, 
7, 6, 7, 8, 3, 2, 3, 4, 2, 1, 2, 3, 1, 0, 1, 2
},
{
20, 19, 18, 19, 16, 15, 14, 15, 15, 14, 13, 14, 14, 13, 12, 13, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
16, 15, 14, 15, 12, 11, 10, 11, 11, 10, 9, 10, 10, 9, 8, 9, 
12, 11, 10, 11, 8, 7, 6, 7, 7, 6, 5, 6, 6, 5, 4, 5, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
15, 14, 13, 14, 11, 10, 9, 10, 10, 9, 8, 9, 9, 8, 7, 8, 
11, 10, 9, 10, 7, 6, 5, 6, 6, 5, 4, 5, 5, 4, 3, 4, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
14, 13, 12, 13, 10, 9, 8, 9, 9, 8, 7, 8, 8, 7, 6, 7, 
10, 9, 8, 9, 6, 5, 4, 5, 5, 4, 3, 4, 4, 3, 2, 3, 
9, 8, 7, 8, 5, 4, 3, 4, 4, 3, 2, 3, 3, 2, 1, 2, 
8, 7, 6, 7, 4, 3, 2, 3, 3, 2, 1, 2, 2, 1, 0, 1
},
{
24, 20, 19, 18, 20, 16, 15, 14, 19, 15, 14, 13, 18, 14, 13, 12, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
20, 16, 15, 14, 16, 12, 11, 10, 15, 11, 10, 9, 14, 10, 9, 8, 
16, 12, 11, 10, 12, 8, 7, 6, 11, 7, 6, 5, 10, 6, 5, 4, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
19, 15, 14, 13, 15, 11, 10, 9, 14, 10, 9, 8, 13, 9, 8, 7, 
15, 11, 10, 9, 11, 7, 6, 5, 10, 6, 5, 4, 9, 5, 4, 3, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
18, 14, 13, 12, 14, 10, 9, 8, 13, 9, 8, 7, 12, 8, 7, 6, 
14, 10, 9, 8, 10, 6, 5, 4, 9, 5, 4, 3, 8, 4, 3, 2, 
13, 9, 8, 7, 9, 5, 4, 3, 8, 4, 3, 2, 7, 3, 2, 1, 
12, 8, 7, 6, 8, 4, 3, 2, 7, 3, 2, 1, 6, 2, 1, 0
}
};

// Pearson's algorithm
unsigned char b_mapping(unsigned char salt, unsigned char i, unsigned char j, unsigned char k) {
    unsigned char h = 0;
    
    h = v_table[h ^ salt];
    h = v_table[h ^ i];
    h = v_table[h ^ j];
    h = v_table[h ^ k];
    return h;
}

#define LOG_1_5 0.4054651
#define LOG_1_3 0.26236426
#define LOG_1_1 0.095310180

unsigned char l_capturing(unsigned int len) {
    int i;
    if( len <= 656 ) {
        i = (int) floor( std::log((float) len) / LOG_1_5 );
    } else if( len <= 3199 ) {
        i = (int) floor( std::log((float) len) / LOG_1_3 - 8.72777 );
    } else {
        i = (int) floor( std::log((float) len) / LOG_1_1 - 62.5472 );
    }
    
    return (unsigned char) (i & 0xFF);
}

int mod_diff(unsigned int x, unsigned int y, unsigned int R)
{
    int dl = 0;
    int dr = 0;
    if ( y > x ){
        dl = (int)(y - x);
        dr = (int)(x + R - y);
    }else{
        dl = (int)(x - y);
        dr = (int)(y + R - x);
    }
    return (dl > dr ? dr : dl);
}

int h_distance( int len, const unsigned char x[], const unsigned char y[])
{
    int diff = 0;
    for( int i=0; i<len; i++ ){
        diff += bit_pairs_diff_table[ x[i] ][ y[i] ];
    }
    return diff;
}

unsigned char swap_byte( const unsigned char in )
{
	unsigned char byte = 0;
	byte = ((in & 0xF0) >> 4) & 0x0F;
	byte |= ((in & 0x0F) << 4) & 0xF0;
	return byte;
}

void to_hex( unsigned char * psrc, int len, char* pdest )
{
    static unsigned char HexLookup[513]= {
	"000102030405060708090A0B0C0D0E0F"
	"101112131415161718191A1B1C1D1E1F"
	"202122232425262728292A2B2C2D2E2F"
	"303132333435363738393A3B3C3D3E3F"
	"404142434445464748494A4B4C4D4E4F"
	"505152535455565758595A5B5C5D5E5F"
	"606162636465666768696A6B6C6D6E6F"
	"707172737475767778797A7B7C7D7E7F"
	"808182838485868788898A8B8C8D8E8F"
	"909192939495969798999A9B9C9D9E9F"
	"A0A1A2A3A4A5A6A7A8A9AAABACADAEAF"
	"B0B1B2B3B4B5B6B7B8B9BABBBCBDBEBF"
	"C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF"
	"D0D1D2D3D4D5D6D7D8D9DADBDCDDDEDF"
	"E0E1E2E3E4E5E6E7E8E9EAEBECEDEEEF"
	"F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF"
    };
    unsigned short* pwHex = (unsigned short*)HexLookup; 
	unsigned short* pwDest= (unsigned short*)pdest;

	for (int i=0; i<len; i++ ) {
		*pwDest= pwHex[*psrc];
		pwDest++; psrc++;
	}
	*((unsigned char*)pwDest)= 0;  // terminate the string
}

void from_hex( const char* psrc, int len, unsigned char* pdest )
{
    static unsigned char DecLookup[] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, // gap before first hex digit
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
	0,1,2,3,4,5,6,7,8,9,       // 0123456789
	0,0,0,0,0,0,0,             // :;<=>?@ (gap)
	10,11,12,13,14,15,         // ABCDEF 
	0,0,0,0,0,0,0,0,0,0,0,0,0, // GHIJKLMNOPQRS (gap)
	0,0,0,0,0,0,0,0,0,0,0,0,0, // TUVWXYZ[/]^_` (gap)
	10,11,12,13,14,15          // abcdef 
    };

    for (int i=0; i<len; i += 2 ) {
	unsigned d =  DecLookup[*(unsigned char *)(psrc + i)] << 4;
	d |= DecLookup[*(unsigned char *)(psrc + i + 1)];
	*pdest++ = d;
    }
}

