'\"
'\" Generated from file '/home/aku/Projects/Tcllib/tklib/embedded/man/files/modules/widgetv/widget_validator\&.n' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "widget_validator" n 0\&.1 tklib "widget::validator behaviour"
.BS
.SH NAME
widget_validator \- widget::validator behaviour
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBwidget::validator  ?0\&.1?\fR
.sp
\fBwidget::validator\fR \fBattach\fR \fIw\fR \fIcolor\fR \fIcmdprefix\fR
.sp
\fBwidget::validator\fR \fBdetach\fR \fIw\fR
.sp
\fBwidget::validator\fR \fBvalidate\fR \fIw\fR
.sp
.BE
.SH DESCRIPTION
This package provides a unified validation API
for \fBttk\fR's entry and combobox widgets\&.
.PP
Please note that the validation behaviour
defined in this package will not reject invalid
edits\&. It will only highlight the entry containing
invalid data and set the proper state flag\&.
.PP
It is the responsibility of the using package
or application to decide how and when to actually
reject such invalid content\&.
.PP
.TP
\fBwidget::validator\fR \fBattach\fR \fIw\fR \fIcolor\fR \fIcmdprefix\fR
This method adds a validating behaviour to the widget \fIw\fR\&.
.sp
Whenever the content of the widget's entry field changes
the specified \fIcmdprefix\fR is invoked and has to return a
boolean value, where \fBtrue\fR means that content is ok, and
\fBfalse\fR that the content is invalid\&. For more information
on the command prefix see section \fBValidation\fR\&.
In case of the latter the background color of the entry field
is changed to \fIcolor\fR to indicate the invalidity\&.
.sp
The system does not support nesting of validators on a
widget, nor the attachment of multiple validators\&. To change
validating conditions \fBdetach\fR the current validator first
before attaching the new\&.
.sp
An error is thrown if the widget has already
validating behaviour attached to it\&.
.sp
The result of the method is the empty string\&.
.sp
To achieve its aims the package overrides various
configuration options of the widget the behaviour is
attached to\&. These options are restored to their previous
values on \fBdetach\fR\&.
.sp
If other behaviours are attached the validator
may be rendered temporarily (partially) non-functional\&.
Similarly, if the validator is detached while a different
behaviour is also attached its restoration of configuration
settings may render the other non-functional
.TP
\fBwidget::validator\fR \fBdetach\fR \fIw\fR
This method removes the validating behaviour from
the widget \fIw\fR and restores it to its original
state\&.
.sp
An error is thrown if the widget has no
validating behaviour attached to it\&.
.sp
The result of the method is the empty string\&.
.TP
\fBwidget::validator\fR \fBvalidate\fR \fIw\fR
Invoking this method forces a validation of the
widget \fIw\fR, assuming that it has a validator
behaviour attached to it\&.
.sp
The result of the method is the empty string\&.
.PP
.SH VALIDATION
The command prefix for used for validation has to
have the following signature:
.TP
{*}\fIcmdprefix\fR \fItext\fR
The argument is the text to validate\&.
.sp
The result of the callback has to be a boolean value
where \fBtrue\fR means that \fItext\fR is ok, and
\fBfalse\fR that \fItext\fR is invalid\&.
.PP
.SH EXAMPLE
.CS


package require Tk 8\&.5
package require widget::validator

set TE {}
set TC {}

ttk::entry    \&.e -textvariable TE
ttk::combobox \&.c -textvariable TC -values {fruit vegetable corn}
ttk::combobox \&.n -values {fruit vegetable corn}
ttk::button   \&.x -command ::exit -text Exit

pack \&.e -expand 1 -fill both -side top
pack \&.c -expand 1 -fill both -side top
pack \&.n -expand 1 -fill both -side top
pack \&.x -expand 1 -fill both -side top

widget::validator attach \&.e lightblue {apply {text {
    expr {$text ne {}}
}}}

widget::validator attach \&.c yellow {apply {text {
    expr {$text ni {{} hello world}}
}}}

widget::validator attach \&.n pink {apply {text {
    expr {$text ni {{} blub}}
}}}

.CE
.SH KEYWORDS
invalid, state management, ttk::combobox, ttk::entry, validation, widget validation