/*
 * Copyright (c) 2009 Communication Group and Eislab at
 * Lulea University of Technology
 *
 * Contact: Laurynas Riliskis, LTU
 * Mail: laurynas.riliskis@ltu.se
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of Communication Group at Lulea University of Technology
 *   nor the names of its contributors may be used to endorse or promote
 *    products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL STANFORD
 * UNIVERSITY OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Interface for the RV-8564-C2 real time clock.
 *
 * @author Henrik Makitaavola <henrik.makitaavola@gmail.com>
 */
interface HplRV8564
{
  /**
   * Enables/disables the interrupts generated by the RV8564 chip.
   */
  command void enableInterrupt();
  command void disableInterrupt();

  /**
   * Enables/disable CLKOUT from the RTC.
   */
  command void enableCLKOUT();
  command void disableCLKOUT();

  /**
   * Reads from a register.
   *
   * @param reg The register to be read.
   * @return The value of the register.
   */
  command error_t readRegister(uint8_t reg);

  /**
   * Writes to a register.
   *
   * @param reg The register that is written to.
   * @param value The value that is written to the register.
   */
  command error_t writeRegister(uint8_t reg, uint8_t value);

  /**
   * Signals when a register read finished.
   *
   * @param val The value read from the register.
   * @param reg The register the value was read from.
   */
  async event void readRegisterDone(error_t error, uint8_t reg, uint8_t val);

  /**
   * Signals when a register write finished.
   *
   * @param reg The register the value was written to.
   */
  async event void writeRegisterDone(error_t error, uint8_t reg);

  /**
   * Signal when an interrupt occurs.
   */
  async event void fired();
}
