/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

class Window {
    Oscilloscope parent;
    Graph graph;
    Font smallFont = new Font("Dialog", 0, 8);
    Font boldFont = new Font("Dialog", 1, 12);
    Font normalFont = new Font("Dialog", 0, 12);
    MoteTableModel moteListModel;
    JLabel xLabel;
    JTextField sampleText;
    JTextField yText;
    JFrame frame;

    Window(Oscilloscope oscilloscope) {
        this.parent = oscilloscope;
    }

    JButton makeButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton();
        jButton.setText(string);
        jButton.setFont(this.boldFont);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    JLabel makeLabel(String string, int n) {
        JLabel jLabel = new JLabel(string, n);
        jLabel.setFont(this.boldFont);
        return jLabel;
    }

    JLabel makeSmallLabel(String string, int n) {
        JLabel jLabel = new JLabel(string, n);
        jLabel.setFont(this.smallFont);
        return jLabel;
    }

    JTextField makeTextField(int n, ActionListener actionListener) {
        JTextField jTextField = new JTextField(n);
        jTextField.setFont(this.normalFont);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jTextField.addActionListener(actionListener);
        return jTextField;
    }

    void setup() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(500, 250));
        jPanel.setPreferredSize(new Dimension(800, 400));
        this.moteListModel = new MoteTableModel();
        JTable jTable = new JTable(this.moteListModel);
        jTable.setDefaultRenderer(Color.class, new MoteColor());
        jTable.setDefaultEditor(Color.class, new ColorCellEditor("Pick Mote Color"));
        jTable.setPreferredScrollableViewportSize(new Dimension(100, 400));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)jTable, null);
        jPanel.add((Component)jScrollPane, "West");
        this.graph = new Graph(this);
        jPanel.add((Component)this.graph, "Center");
        JLabel jLabel = this.makeLabel("Sample period (ms):", 4);
        this.sampleText = this.makeTextField(6, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Window.this.setSamplePeriod();
            }
        });
        this.updateSamplePeriod();
        JButton jButton = this.makeButton("Clear data", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Window.this.clearData();
            }
        });
        Box box = new Box(1);
        this.xLabel = this.makeLabel("", 0);
        final JSlider jSlider = new JSlider(0, 0, 8, this.graph.scale);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 8; i += 2) {
            hashtable.put(new Integer(i), this.makeSmallLabel("" + (50 << i), 0));
        }
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        this.graph.updateXLabel();
        this.graph.setScale(this.graph.scale);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Window.this.graph.setScale(jSlider.getValue());
            }
        });
        box.add(this.xLabel);
        box.add(jSlider);
        JLabel jLabel2 = this.makeLabel("Y:", 4);
        this.yText = this.makeTextField(12, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Window.this.setYAxis();
            }
        });
        this.yText.setText(this.graph.gy0 + " - " + this.graph.gy1);
        Box box2 = new Box(0);
        box2.add(jButton);
        box2.add(Box.createHorizontalGlue());
        box2.add(Box.createRigidArea(new Dimension(20, 0)));
        box2.add(jLabel);
        box2.add(this.sampleText);
        box2.add(Box.createHorizontalGlue());
        box2.add(Box.createRigidArea(new Dimension(20, 0)));
        box2.add(box);
        box2.add(jLabel2);
        box2.add(this.yText);
        jPanel.add((Component)box2, "South");
        this.frame = new JFrame("Oscilloscope");
        this.frame.setSize(jPanel.getPreferredSize());
        this.frame.getContentPane().add(jPanel);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearData() {
        Oscilloscope oscilloscope = this.parent;
        synchronized (oscilloscope) {
            this.moteListModel.clear();
            this.parent.clear();
            this.graph.newData();
        }
    }

    void setYAxis() {
        String string = this.yText.getText();
        try {
            int n = string.indexOf(45);
            if (n >= 0) {
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                if (!this.graph.setYAxis(Integer.parseInt(string2), Integer.parseInt(string3))) {
                    this.error("Invalid range " + string2 + " - " + string3 + " (expected values between 0 and 65535)");
                }
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.error("Invalid range " + string + " (expected NN-MM)");
    }

    void setSamplePeriod() {
        String string = this.sampleText.getText().trim();
        try {
            int n = Integer.parseInt(string);
            if (this.parent.setInterval(n)) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.error("Invalid sample period " + string);
    }

    void updateSamplePeriod() {
        this.sampleText.setText("" + this.parent.interval);
    }

    void newNode(int n) {
        this.moteListModel.newNode(n);
    }

    void newData() {
        this.graph.newData();
    }

    void error(String string) {
        JOptionPane.showMessageDialog(this.frame, string, "Error", 0);
    }

    static class MoteColor
    extends JLabel
    implements TableCellRenderer {
        public MoteColor() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((Color)object);
            return this;
        }
    }

    class MoteTableModel
    extends AbstractTableModel {
        private ArrayList motes = new ArrayList();
        private ArrayList colors = new ArrayList();
        private Color[] cycle = new Color[]{Color.RED, Color.WHITE, Color.GREEN, Color.MAGENTA, Color.YELLOW, Color.GRAY, Color.YELLOW};
        int cycleIndex;

        MoteTableModel() {
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Mote";
            }
            return "Color";
        }

        public int getColumnCount() {
            return 2;
        }

        public synchronized int getRowCount() {
            return this.motes.size();
        }

        public synchronized Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.motes.get(n);
            }
            return this.colors.get(n);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public synchronized void setValueAt(Object object, int n, int n2) {
            this.colors.set(n, object);
            this.fireTableCellUpdated(n, n2);
            Window.this.graph.repaint();
        }

        int get(int n) {
            return (Integer)this.motes.get(n);
        }

        Color getColor(int n) {
            return (Color)this.colors.get(n);
        }

        int size() {
            return this.motes.size();
        }

        synchronized void newNode(int n) {
            int n2 = this.motes.size();
            int n3 = 0;
            while (true) {
                if (n3 == n2 || n < this.get(n3)) break;
                ++n3;
            }
            this.motes.add(n3, new Integer(n));
            this.colors.add(n3, this.cycle[this.cycleIndex++ % this.cycle.length]);
            this.fireTableRowsInserted(n3, n3);
        }

        void clear() {
            this.motes = new ArrayList();
            this.colors = new ArrayList();
            this.fireTableDataChanged();
        }
    }
}

