---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, positionnement, fin de document, 
              endlfoat, newfloat
---

# Comment faire apparaître toutes les figures en fin de document ?

## Avec l'extension <ctanpkg:endfloat>

L'extension <ctanpkg:endfloat> renvoie tous les flottants en fin de document.
Elle dispose d'options permettant notamment :

- de placer les tables avant les figures avec `tablesfirst` et inversement 
  avec `figuresfirst` ;
- de ne pas afficher les tables avec `notables` ou de ne pas afficher 
  les figures avec `nofigures` ;
- de ne pas afficher de liste des tables avec `notablist` ou de liste 
  des figures avec `nofiglist`.
- de ne pas afficher les marques indiquant la position des figures 
  dans le texte, avec `nomarking`. En effet, comme le précise 
  la [documentation](texdoc:endfloat) de l'extension, <ctanpkg:endfloat> 
  était pensée pour préparer des documents de relecture de publications 
  dans des journaux scientifiques.

Voici un exemple montrant le comportement par défaut. Il comprend 
un correctif permettant d'avoir la marque de figure mise en français 
(une démarche similaire serait nécessaire pour la marque de table 
avec la redéfinition de la commande `̀\tableplace`).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{endfloat}

  % Redéfinition de la marque des figures pour la franciser
  \renewcommand{\figureplace}{%
    \begin{center}
      [\figurename~\thepostfigure~ici.]
    \end{center}%
  }

\begin{document}
Donner des exemples peut aider.
\begin{figure}[h!]
  \centering\framebox{\Huge Un exemple}
  \caption{Exemple exemplaire}
\end{figure}

Il faut les rendre aussi précis que possible.
\begin{figure}[h!]
\centering\framebox{\Huge Un autre exemple}
\caption{Exemplaire d'exemple}
\end{figure}
\end{document}
```

Cette extension ne fonctionne par défaut qu'avec les flottants `figure` 
et `table`. Si vous avez créé d'autres flottants (voir la question 
"[](/3_composition/flottants/definir_de_nouveaux_flottants)"), les intégrer 
à la logique de l'extension <ctanpkg:endfloat> se fait avec la commmande 
`\DeclareDelayedFloat`. Voici un exemple (issu de la 
[documentation](texdoc:endfloat) de l'extension) avec l'extension 
<ctanpkg:newfloat> :

```{noedit}
\usepackage{newfloat} % Une des extensions permettant de créer des flottants
\usepackage{endfloat}
\DeclareFloatingEnvironment{carte}  % La commande de création de flottant de
                                    % 'newfloat'
\DeclareDelayedFloat{carte}{Cartes}
```