## TFSA-2021-074: Division by zero in optimized pooling implementations in TFLite

### CVE Number
CVE-2021-29586

### Impact
Optimized pooling implementations in TFLite fail to check that the stride
arguments are not 0 before calling
[`ComputePaddingHeightWidth`](https://github.com/tensorflow/tensorflow/blob/3f24ccd932546416ec906a02ddd183b48a1d2c83/tensorflow/lite/kernels/pooling.cc#L90).

Since users can craft special models which will have
`params->stride_{height,width}` be zero, this will result in a division by zero.

### Patches
We have patched the issue in GitHub commit
[5f7975d09eac0f10ed8a17dbb6f5964977725adc](https://github.com/tensorflow/tensorflow/commit/5f7975d09eac0f10ed8a17dbb6f5964977725adc).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
