## TFSA-2021-023: Heap buffer overflow in `QuantizedMul`

### CVE Number
CVE-2021-29535

### Impact
An attacker can cause a heap buffer overflow in `QuantizedMul` by passing in
invalid thresholds for the quantization:

```python
import tensorflow as tf

x = tf.constant([256, 328], shape=[1, 2], dtype=tf.quint8)
y = tf.constant([256, 328], shape=[1, 2], dtype=tf.quint8)
min_x = tf.constant([], dtype=tf.float32)
max_x = tf.constant([], dtype=tf.float32)
min_y = tf.constant([], dtype=tf.float32)
max_y = tf.constant([], dtype=tf.float32)

tf.raw_ops.QuantizedMul(x=x, y=y, min_x=min_x, max_x=max_x, min_y=min_y, max_y=max_y)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/87cf4d3ea9949051e50ca3f071fc909538a51cd0/tensorflow/core/kernels/quantized_mul_op.cc#L287-L290)
assumes that the 4 arguments are always valid scalars and tries to access the
numeric value directly:

```cc
const float min_x = context->input(2).flat<float>()(0);
const float max_x = context->input(3).flat<float>()(0);
const float min_y = context->input(4).flat<float>()(0);
const float max_y = context->input(5).flat<float>()(0);
```

However, if any of these tensors is empty, then `.flat<T>()` is an empty buffer
and accessing the element at position 0 results in overflow.

### Patches
We have patched the issue in GitHub commit
[efea03b38fb8d3b81762237dc85e579cc5fc6e87](https://github.com/tensorflow/tensorflow/commit/efea03b38fb8d3b81762237dc85e579cc5fc6e87).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu X-Team.
