#!/bin/sh

UPSTREAM_REPO=http://tclxml.svn.sourceforge.net/svnroot/tclxml/trunk
PACKAGE=tclxml
SRC_VERSION=$(dpkg-parsechangelog | sed -ne 's/^Version: \(\([0-9]\+\):\)\?\(.*\)-.*/\3/p')
SVN_REVISION=${SRC_VERSION##*svn}
TARBALL=${PACKAGE}_${SRC_VERSION}.orig.tar.gz
rm -rf debian/orig-source
mkdir debian/orig-source
svn export -r ${SVN_REVISION} ${UPSTREAM_REPO} debian/orig-source/${PACKAGE}-${SRC_VERSION}.orig || exit 
GZIP='--best --no-name' tar --owner=root --group=root --mode=a+rX czf ${TARBALL} -C debian/orig-source ${PACKAGE}-${SRC_VERSION}.orig
rm -rf debian/orig-source

