[vset ZIP_mkzip_VERSION 1.2.4]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin zipfile::mkzip n [vset ZIP_mkzip_VERSION]]
[keywords decompression zip]
[copyright {2009 Pat Thoyts}]
[moddesc {Zip archive creation}]
[titledesc {Build a zip archive}]
[category  File]
[require Tcl "8.6 9"]
[require zipfile::mkzip [opt [vset ZIP_mkzip_VERSION]]]
[description]
[para]

This package utilizes the zlib functions in Tcl 8.6 to build zip
archives.

[section API]

[list_begin definitions]
[comment ---------------------------------------------------------------------]
[call [cmd ::zipfile::mkzip::mkzip] [arg zipfile] \
	[opt [option -zipkit]] \
	[opt "[option -runtime] [arg prefix]"] \
	[opt "[option -comment] [arg string]"] \
	[opt "[option -directory] [arg rootpath]"] \
	[opt "[option -prepend-base-directory] [arg bool]"] \
	[opt "[option -exclude] [arg exclude]"] \
	[opt [option --]] [opt [arg path]...]]

From [uri http://wiki.tcl.tk/15158]

[para] This command constructs a zip archive from a directory tree
using nothing but Tcl 8.6 core features. The resulting zip file should
be compatible with other [syscmd zip] programs - with the possible
exception of unicode support. The files generated by this command use
utf-8 encoding for all filenames and comments and it has been noticed
particularly on Windows the [syscmd info-zip] and the Windows built-in
zip view have rather poor support for this part of the ZIP file
specification. The [syscmd 7-Zip] program does correctly display utf8
filenames however and the [package vfs::zip] package will use these of
course.

[para] If you use
[example_begin][cmd ::mkzip::mkzip] mystuff.tm -zipkit -directory mystuff.vfs[example_end]

it will pack your [file mystuff.vfs/] virtual filesystem tree into a
zip archive with a suitable header such that on unix you may mark it
executable and it should run with tclkit. Or you can run it with
[syscmd tclsh] or [syscmd wish] 8.6 if you like.

[para] To change the executable header, specify the [option -runtime]
[file preface] where preface is a file containing code you want
prefixed. For instance, on Windows you can create a self-extracting
zip archive using

[example {
mkzip mystuff.exe -directory mystuff.vfs -runtime unzipsfx.exe
}]
The [file unzipsfx.exe] is the Info-Zip self-extracting stub.

[para] Accepted options:
[list_begin options]
[opt_def -runtime path]
This option specifies a file to use as prefix to the actual zip
archive. If specified [option -zipkit] will be ignored.

[opt_def -zipkit]
Instructs the command to generate a prefix which makes the archive a
zip-based starkit. Ignored if [option -runtime] is present.

[opt_def -comment string]
This options specifies a global comment to place into the generated
archive.

[opt_def -directory path]
This option specifies the directory to place into the generated
archive. If specified any argument [arg path]s are [emph ignored].

[opt_def -prepend-base-directory bool]
When this option is set the tail of the [option -directory] path is
prepended to all paths added to the archive.

[para] The option is ignored when option [option -directory] is not specified.

[para] By default this option is [const false].

[opt_def -exclude list]
This option specifies a list of glob patterns. All paths matching at
least one of the patterns are not placed into the generated archive.
This option defaults to [example {
    CVS/* */CVS/* *~ ".#*" "*/.#*"
}]

[opt_def --]
This option signals the end of the options, forcing processing of all
further words as arguments, even if they begin with a dash character.

[list_end]

[para] Accepted arguments:
[list_begin arguments]
[arg_def path path]
Each path is a directory or file to place into the generated archive.
Note however that these will be ignored when option [option -directory]
is specified.

[list_end]

[list_end]

[vset CATEGORY zipfile]
[include ../common-text/feedback.inc]
[manpage_end]
