from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


COLORS = _Mock()

NUMERIC_TYPES = _Mock()

TEXT_TYPES = _Mock()

_ = _Mock()

address = _Mock()

array = _Mock()

dateparse = _Mock()

datestr_to_datetime = _Mock()

datetime = _Mock()

dependencies = _Mock()

get_color_name = _Mock()

get_human_readable_type = _Mock()

get_numpy_dtype = _Mock()

get_size = _Mock()

get_type_string = _Mock()

globalsfilter = _Mock()

is_editable_type = _Mock()

is_known_type = _Mock()

is_supported = _Mock()

is_text_string = _Mock()

pil_patch = _Mock()

print_function = _Mock()

programs = _Mock()

re = _Mock()

sort_against = _Mock()

to_text_string = _Mock()

try_to_eval = _Mock()

unsorted_unique = _Mock()

value_to_display = _Mock()

ARRAY_COLOR = '#00ff00'

CUSTOM_TYPE_COLOR = '#7755aa'

PANDAS_REQVER = '>=0.13.1'

SCALAR_COLOR = '#0000ff'

UNSUPPORTED_COLOR = '#ffffff'

class DataFrame(_Mock):
  pass


class FakeObject(_Mock):
  pass


class Image(_Mock):
  pass


class MaskedArray(_Mock):
  pass
  _defaulthardmask = False

class TimeSeries(_Mock):
  pass


class matrix(_Mock):
  pass


class ndarray(_Mock):
  pass


