from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_get_type = _Mock()

_mod_name_key = _Mock()

_raise_key_error = _Mock()

_safe_get_formatter_method = _Mock()

_valid_formatter = _Mock()

abc = _Mock()

decorator = _Mock()

format_display_data = _Mock()

inspect = _Mock()

io = _Mock()

pretty = _Mock()

string_types = _Mock()

sys = _Mock()

types = _Mock()

unicode_to_str = _Mock()

warn = _Mock()

warn_format_error = _Mock()

warnings = _Mock()

with_metaclass = _Mock()

PY3 = _Mock()

class BaseFormatter(_Mock):
  pass


class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CUnicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class Configurable(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class DisplayFormatter(_Mock):
  pass


class FormatterABC(_Mock):
  pass
  _abc_negative_cache_version = 23
  enabled = True
  format_type = 'text/plain'

class FormatterWarning(_Mock):
  pass


class HTMLFormatter(_Mock):
  pass


class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class JPEGFormatter(_Mock):
  pass


class JSONFormatter(_Mock):
  pass


class JavascriptFormatter(_Mock):
  pass


class LatexFormatter(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class ObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class PDFFormatter(_Mock):
  pass


class PNGFormatter(_Mock):
  pass


class PlainTextFormatter(_Mock):
  pass


class SVGFormatter(_Mock):
  pass


class StringIO(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class unicode_type(_Mock):
  pass


