/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.SQLParserConstants;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.compile.Token;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class SQLParser
implements SQLParserConstants {
    private static final String[] SAVEPOINT_CLAUSE_NAMES = new String[]{"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
    private static final String[] ROUTINE_CLAUSE_NAMES = new String[]{null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "ON NULL INPUT"};
    private static final int[] JAVA_ROUTINE_CLAUSES = new int[]{3, 4, 5};
    private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = new String[]{"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 1;
    private static final int ON_OR_USING_CLAUSE_SIZE = 2;
    private static final int ON_CLAUSE = 0;
    private static final int USING_CLAUSE = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_SIZE = 3;
    private static final int OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
    private static final int OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;
    private static final int MAX_UTF8_LENGTH = 65535;
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;
    private Object[] paramDefaults;
    private String statementSQLText;
    private NodeFactory nodeFactory;
    private ContextManager cm;
    private CompilerContext compilerContext;
    private int parameterNumber;
    private Vector parameterList;
    private Boolean lastTokenDelimitedIdentifier = Boolean.FALSE;
    private Boolean nextToLastTokenDelimitedIdentifier = Boolean.FALSE;
    private Token lastIdentifierToken;
    private Token nextToLastIdentifierToken;
    static final String SINGLEQUOTES = "''";
    static final String DOUBLEQUOTES = "\"\"";
    static final String DEFAULT_INDEX_TYPE = "BTREE";
    boolean explicitNotNull = false;
    boolean explicitNull = false;
    Vector explicitlyNullableColumnsList = new Vector();
    private static final String[] ESCAPED_SYSFUN_FUNCTIONS = new String[]{"ACOS", "ASIN", "ATAN", "COS", "SIN", "TAN", "PI", "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR", "SIGN", "RAND", "COT"};
    public SQLParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[315];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private final JJCalls[] jj_2_rtns = new JJCalls[52];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    final void setCompilerContext(CompilerContext compilerContext) {
        this.compilerContext = compilerContext;
        this.cm = compilerContext.getContextManager();
    }

    private final NodeFactory getNodeFactory() throws StandardException {
        if (this.nodeFactory == null) {
            this.nodeFactory = this.getCompilerContext().getNodeFactory();
        }
        return this.nodeFactory;
    }

    private final CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    private DataTypeDescriptor getDataTypeServices(int n, int n2, int n3, int n4) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(n), n2, n3, true, n4);
    }

    private DataTypeDescriptor getJavaClassDataTypeDescriptor(String string) {
        return new DataTypeDescriptor(TypeId.getUserDefinedTypeId(string, this.lastTokenDelimitedIdentifier), true);
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
    }

    private void checkVersion(int n, String string) throws StandardException {
        this.getLanguageConnectionContext().getDataDictionary().checkVersion(n, string);
    }

    private void checkSqlStandardAccess(String string) throws StandardException {
        if (this.getLanguageConnectionContext().usesSqlAuthorization()) {
            return;
        }
        throw StandardException.newException("42Z60", (Object)string, (Object)"derby.database.sqlAuthorization", (Object)"TRUE");
    }

    private void checkInternalFeature(String string) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        if ((compilerContext.getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", string);
        }
    }

    private void checkTypeLimits(int n, int n2) throws StandardException {
        boolean bl = true;
        switch (n) {
            case -2: 
            case 1: {
                if (n2 <= 254) break;
                bl = false;
                break;
            }
            case -3: 
            case 12: {
                if (n2 <= 32672) break;
                bl = false;
                break;
            }
        }
        if (!bl) {
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2);
            throw StandardException.newException("42611", dataTypeDescriptor.getSQLstring());
        }
    }

    private final ContextManager getContextManager() {
        return this.cm;
    }

    private static String compressQuotes(String string, String string2) {
        String string3 = string;
        int n = string3.indexOf(string2);
        while (n != -1) {
            string3 = string3.substring(0, n + 1) + string3.substring(n + 2);
            n = string3.indexOf(string2, n + 1);
        }
        return string3;
    }

    private static void verifyImageLength(String string) throws StandardException {
        if (string.length() > 65535) {
            throw StandardException.newException("42Z99");
        }
    }

    private static String normalizeDelimitedID(String string) {
        string = SQLParser.compressQuotes(string, DOUBLEQUOTES);
        return string;
    }

    private static boolean isDATETIME(int n) {
        return n == 276 || n == 331 || n == 332;
    }

    ValueNode multOp(ValueNode valueNode, ValueNode valueNode2, int n) throws StandardException {
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 3: {
                return (ValueNode)this.nodeFactory.getNode(49, valueNode, valueNode2, this.getContextManager());
            }
            case 4: {
                return (ValueNode)this.nodeFactory.getNode(40, valueNode, valueNode2, this.getContextManager());
            }
            case 5: {
                return (ValueNode)this.nodeFactory.getNode(50, valueNode, valueNode2, this.getContextManager());
            }
        }
        return null;
    }

    private void setUpAndLinkParameters() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.setParameterList(this.parameterList);
        DataTypeDescriptor[] dataTypeDescriptorArray = compilerContext.getParameterTypes();
        int n = -1;
        int n2 = this.parameterList.size();
        for (int i = 0; i < n2; ++i) {
            ++n;
            ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(i);
            parameterNode.setDescriptors(dataTypeDescriptorArray);
        }
    }

    void initUnnamedParameterList() {
        this.parameterList = new Vector();
    }

    ParameterNode makeParameterNode() throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        if (this.paramDefaults != null && this.parameterNumber < this.paramDefaults.length) {
            dataValueDescriptor = (DataValueDescriptor)this.paramDefaults[this.parameterNumber];
        }
        ParameterNode parameterNode = (ParameterNode)this.nodeFactory.getNode(88, ReuseFactory.getInteger(this.parameterNumber), dataValueDescriptor, this.getContextManager());
        ++this.parameterNumber;
        this.parameterList.addElement(parameterNode);
        return parameterNode;
    }

    ParameterNode lookupUnnamedParameter(int n) {
        ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(n);
        return parameterNode;
    }

    ValueNode getNumericNode(String string) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        try {
            return (ValueNode)this.nodeFactory.getNode(70, new Integer(string), contextManager);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return (ValueNode)this.nodeFactory.getNode(71, new Long(string), contextManager);
            }
            catch (NumberFormatException numberFormatException2) {
                return (ValueNode)this.nodeFactory.getNode(67, string, contextManager);
            }
        }
    }

    private boolean isBuiltInAlias() {
        boolean bl = false;
        switch (this.token.kind) {
            case 263: 
            case 264: 
            case 295: 
            case 351: 
            case 373: 
            case 374: 
            case 406: 
            case 411: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    boolean commonDatatypeName(boolean bl) {
        return this.commonDatatypeName(1, bl);
    }

    boolean commonDatatypeName(int n, boolean bl) {
        boolean bl2 = false;
        switch (this.getToken((int)n).kind) {
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 109: 
            case 110: 
            case 121: 
            case 136: 
            case 160: 
            case 161: 
            case 180: 
            case 186: 
            case 207: 
            case 221: 
            case 254: 
            case 267: 
            case 270: 
            case 276: 
            case 302: 
            case 331: 
            case 332: 
            case 340: 
            case 347: 
            case 352: 
            case 381: {
                bl2 = true;
                break;
            }
            case 348: {
                if (bl) {
                    switch (this.getToken((int)(n + 1)).kind) {
                        case 74: 
                        case 75: 
                        case 253: 
                        case 254: 
                        case 381: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                bl2 = true;
                break;
            }
            case 178: {
                if (bl) {
                    switch (this.getToken((int)(n + 1)).kind) {
                        case 82: 
                        case 83: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private StatementNode getDeleteNode(FromTable fromTable, TableName tableName, ValueNode valueNode) throws StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, null, null, fromList, valueNode, null, null, this.getContextManager());
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(101, tableName, selectNode, this.getContextManager());
        this.setUpAndLinkParameters();
        return statementNode;
    }

    private StatementNode getUpdateNode(FromTable fromTable, TableName tableName, ResultColumnList resultColumnList, ValueNode valueNode) throws StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, resultColumnList, null, fromList, valueNode, null, null, this.getContextManager());
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(102, tableName, selectNode, this.getContextManager());
        this.setUpAndLinkParameters();
        return statementNode;
    }

    private ValueNode getTrimOperatorNode(Integer n, ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) throws StandardException {
        if (valueNode == null) {
            valueNode = (CharConstantNode)this.nodeFactory.getNode(61, " ", this.getContextManager());
        }
        return (ValueNode)this.nodeFactory.getNode(127, valueNode2, valueNode, null, ReuseFactory.getInteger(0), n, contextManager == null ? this.getContextManager() : contextManager);
    }

    private boolean ansiTrimSpecFollows() {
        return this.getToken((int)2).kind == 169 || this.getToken((int)2).kind == 240 || this.getToken((int)2).kind == 76;
    }

    private boolean remainingPredicateFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 73: 
            case 153: 
            case 171: 
            case 431: 
            case 432: 
            case 433: 
            case 434: 
            case 435: 
            case 436: 
            case 437: {
                bl = true;
                break;
            }
            case 183: {
                switch (this.getToken((int)2).kind) {
                    case 73: 
                    case 153: 
                    case 171: {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    private boolean dropFollows() {
        return this.getToken((int)1).kind == 122;
    }

    private boolean escapedValueFunctionFollows() {
        if (this.getToken((int)1).kind != 418) {
            return false;
        }
        return this.getToken((int)2).kind == 370;
    }

    private String getEscapedSYSFUN(String string) {
        string = StringUtil.SQLToUpperCase(string);
        for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; ++i) {
            if (!ESCAPED_SYSFUN_FUNCTIONS[i].equals(string)) continue;
            return string;
        }
        return null;
    }

    private boolean columnMethodInvocationFollows() {
        int n = this.getToken((int)1).kind;
        if (n == 0) {
            return false;
        }
        if (this.getToken((int)1).image.charAt(0) == '?') {
            return false;
        }
        if (n == 102 || n == 103 || n == 104 || n == 101 && SQLParser.isDATETIME(this.getToken((int)2).kind)) {
            return false;
        }
        if (this.getToken((int)2).kind != 426) {
            return false;
        }
        n = this.getToken((int)4).kind;
        if (n == 420) {
            return true;
        }
        if (n != 426) {
            return false;
        }
        n = this.getToken((int)6).kind;
        if (n == 420) {
            return true;
        }
        if (n != 426) {
            return false;
        }
        n = this.getToken((int)8).kind;
        return n == 420;
    }

    private boolean aggregateFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 71: 
            case 174: 
            case 175: 
            case 229: {
                bl = true;
                break;
            }
            case 99: {
                if (this.getToken((int)2).kind == 420) {
                    bl = true;
                }
            }
            default: {
                if (this.getToken((int)2).kind != 420 || this.getToken((int)3).kind != 120) break;
                bl = true;
            }
        }
        return bl;
    }

    private boolean miscBuiltinFollows() {
        boolean bl = false;
        int n = this.getToken((int)1).kind;
        if (this.getToken((int)0).kind == 341) {
            bl = true;
        }
        switch (n) {
            case 102: 
            case 103: 
            case 104: 
            case 345: {
                bl = true;
                break;
            }
            case 101: {
                if (!SQLParser.isDATETIME(this.getToken((int)2).kind)) break;
                bl = true;
                break;
            }
            case 81: 
            case 420: {
                bl = false;
                break;
            }
            default: {
                if (this.getToken((int)2).kind != 420) break;
                bl = true;
            }
        }
        return bl;
    }

    private boolean subqueryFollows() {
        boolean bl = false;
        int n = 1;
        while (true) {
            int n2;
            if ((n2 = this.getToken((int)n).kind) != 420) {
                if (n2 != 218 && n2 != 252) break;
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean rowValueConstructorListFollows() {
        boolean bl = false;
        if (this.getToken((int)1).kind == 420) {
            int n = 1;
            int n2 = 2;
            while (true) {
                int n3 = this.getToken((int)n2).kind;
                if (n2 == 2 && (n3 == 184 || n3 == 112)) {
                    bl = true;
                    break;
                }
                if (n == 1 && n3 == 424) {
                    bl = true;
                    break;
                }
                if (n3 == 0) break;
                if (n3 == 420) {
                    ++n;
                } else if (n3 == 421) {
                    --n;
                }
                if (n == 0) break;
                ++n2;
            }
        }
        return bl;
    }

    private boolean derbyPropertiesListFollows() {
        return this.getToken((int)1).kind == 53;
    }

    private boolean newInvocationFollows(int n) {
        boolean bl = false;
        if (this.getToken((int)n).kind == 379) {
            int n2 = 2 + n;
            while (true) {
                int n3;
                if ((n3 = this.getToken((int)n2).kind) == 420) {
                    bl = true;
                    break;
                }
                if (n3 != 426) break;
                n2 += 2;
            }
        }
        return bl;
    }

    boolean javaClassFollows() {
        boolean bl = false;
        int n = 2;
        while (true) {
            int n2;
            if ((n2 = this.getToken((int)n).kind) == 429) {
                bl = true;
                break;
            }
            if (n2 != 426) break;
            n += 2;
        }
        return bl;
    }

    private boolean fromNewInvocationFollows() {
        boolean bl = false;
        return this.getToken((int)1).kind == 140 && this.newInvocationFollows(2);
    }

    private boolean joinedTableExpressionFollows() {
        boolean bl = false;
        int n = this.getToken((int)1).kind;
        int n2 = this.getToken((int)2).kind;
        if (n == 166) {
            bl = true;
        } else if (n == 156 && n2 == 166) {
            bl = true;
        } else if ((n == 170 || n == 212) && n2 == 194) {
            if (this.getToken((int)3).kind == 166) {
                bl = true;
            }
        } else if ((n == 170 || n == 212) && n2 == 166) {
            bl = true;
        }
        return bl;
    }

    private static String aggName(Token token) {
        String string = null;
        switch (token.kind) {
            case 174: {
                string = "MAX";
                break;
            }
            case 71: {
                string = "AVG";
                break;
            }
            case 175: {
                string = "MIN";
                break;
            }
            case 229: {
                string = "SUM";
                break;
            }
            case 99: {
                string = "COUNT";
                break;
            }
        }
        return string;
    }

    private static Class aggClass(Token token) {
        Class clazz = null;
        switch (token.kind) {
            case 174: 
            case 175: {
                clazz = MaxMinAggregateDefinition.class;
                break;
            }
            case 71: 
            case 229: {
                clazz = SumAvgAggregateDefinition.class;
                break;
            }
            case 99: {
                clazz = CountAggregateDefinition.class;
                break;
            }
        }
        return clazz;
    }

    private boolean anotherPropertyFollows() {
        boolean bl = false;
        if (this.getToken((int)1).kind == 424) {
            int n;
            int n2 = 3;
            do {
                if ((n = this.getToken((int)n2).kind) == 433) {
                    bl = true;
                    break;
                }
                n2 += 2;
            } while (n == 426);
        }
        return bl;
    }

    StatementNode getCreateAliasNode(Object object, String string, Object object2, char c, Boolean bl) throws StandardException {
        StatementNode statementNode = (StatementNode)this.getNodeFactory().getCreateAliasNode(object, string, object2, c, bl, this.getContextManager());
        return statementNode;
    }

    StatementNode dropAliasNode(Object object, char c) throws StandardException {
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(156, object, new Character(c), this.getContextManager());
        return statementNode;
    }

    ValueNode getSubstringNode(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, Boolean bl) throws StandardException {
        return (ValueNode)this.nodeFactory.getNode(154, valueNode, valueNode2, valueNode3, ReuseFactory.getInteger(2), null, this.getContextManager());
    }

    public final TableName qualifiedName(int n) throws ParseException, StandardException {
        return this.qualifiedName(34, n);
    }

    private void initStatement(String string, Object[] objectArray) throws StandardException {
        this.parameterNumber = 0;
        this.statementSQLText = string;
        this.paramDefaults = objectArray;
        this.nodeFactory = this.getNodeFactory();
        this.initUnnamedParameterList();
    }

    private void checkIdentifierLengthLimit(String string, int n) throws StandardException {
        if (string.length() > n) {
            throw StandardException.newException("42622", (Object)string, (Object)String.valueOf(n));
        }
    }

    private ValueNode getJdbcIntervalNode(int n) throws StandardException {
        return (ValueNode)this.nodeFactory.getNode(70, ReuseFactory.getInteger(n), this.getContextManager());
    }

    private void checkAuthorizationLength(String string) throws StandardException {
        this.checkIdentifierLengthLimit(string, 30);
    }

    void checkRequiredRoutineClause(int[] nArray, Object[] objectArray) throws StandardException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (objectArray[n] != null) continue;
            throw StandardException.newException("42X01", ROUTINE_CLAUSE_NAMES[n]);
        }
    }

    public final StatementNode Statement(String string, Object[] objectArray) throws ParseException, StandardException {
        this.initStatement(string, objectArray);
        StatementNode statementNode = this.StatementPart(null);
        this.jj_consume_token(0);
        return statementNode;
    }

    public final StatementNode proceduralStatement(Token[] tokenArray) throws ParseException, StandardException {
        StatementNode statementNode;
        tokenArray[0] = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 159: {
                statementNode = this.insertStatement();
                break;
            }
            case 247: {
                statementNode = this.preparableUpdateStatement();
                break;
            }
            case 115: {
                statementNode = this.preparableDeleteStatement();
                break;
            }
            case 218: 
            case 252: 
            case 420: {
                statementNode = this.preparableSelectStatement(true);
                break;
            }
            case 341: 
            case 418: 
            case 438: {
                statementNode = this.callStatement();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode StatementPart(Token[] tokenArray) throws ParseException, StandardException {
        this.explicitNotNull = false;
        this.explicitNull = false;
        this.explicitlyNullableColumnsList = new Vector();
        if (tokenArray != null) {
            tokenArray[0] = this.getToken(1);
        }
        switch (this.jj_nt.kind) {
            case 375: 
            case 393: {
                StatementNode statementNode;
                switch (this.jj_nt.kind) {
                    case 393: {
                        statementNode = this.spsRenameStatement();
                        break;
                    }
                    case 375: {
                        statementNode = this.lockStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return statementNode;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        if (this.jj_2_2(1)) {
            StatementNode statementNode;
            block7 : switch (this.jj_nt.kind) {
                case 100: {
                    statementNode = this.createStatements();
                    break;
                }
                case 122: {
                    statementNode = this.dropStatements();
                    break;
                }
                case 62: {
                    statementNode = this.spsAlterStatement();
                    break;
                }
                case 111: {
                    statementNode = this.globalTemporaryTableDeclaration();
                    break;
                }
                case 115: 
                case 159: 
                case 213: 
                case 218: 
                case 247: 
                case 252: 
                case 309: 
                case 314: 
                case 341: 
                case 418: 
                case 420: 
                case 438: {
                    statementNode = this.preparableSQLDataStatement();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    if (this.jj_2_1(1)) {
                        statementNode = this.spsSetStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 335: {
                            statementNode = this.truncateTableStatement();
                            break block7;
                        }
                        case 147: {
                            statementNode = this.grantStatement();
                            break block7;
                        }
                        case 211: {
                            statementNode = this.revokeStatement();
                            break block7;
                        }
                        case 130: {
                            statementNode = this.execStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode createStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        Token token = this.jj_consume_token(100);
        block0 : switch (this.jj_nt.kind) {
            case 215: 
            case 256: 
            case 329: 
            case 410: {
                switch (this.jj_nt.kind) {
                    case 215: {
                        statementNode = this.schemaDefinition();
                        break block0;
                    }
                    case 256: {
                        statementNode = this.viewDefinition(token);
                        break block0;
                    }
                    case 410: {
                        statementNode = this.triggerDefinition();
                        break block0;
                    }
                    case 329: {
                        statementNode = this.synonymDefinition();
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 232: {
                statementNode = this.tableDefinition();
                break;
            }
            case 204: {
                statementNode = this.procedureDefinition();
                break;
            }
            case 142: {
                statementNode = this.functionDefinition();
                break;
            }
            case 245: 
            case 371: {
                statementNode = this.indexDefinition();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode dropStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(122);
        switch (this.jj_nt.kind) {
            case 215: {
                statementNode = this.dropSchemaStatement();
                break;
            }
            case 232: {
                statementNode = this.dropTableStatement();
                break;
            }
            case 371: {
                statementNode = this.dropIndexStatement();
                break;
            }
            case 142: 
            case 204: 
            case 329: {
                statementNode = this.dropAliasStatement();
                break;
            }
            case 256: {
                statementNode = this.dropViewStatement();
                break;
            }
            case 410: {
                statementNode = this.dropTriggerStatement();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode spsAlterStatement() throws ParseException, StandardException {
        this.jj_consume_token(62);
        StatementNode statementNode = this.alterTableStatement();
        return statementNode;
    }

    public final StatementNode spsSetStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 220 && this.getToken((int)2).kind != 101) {
            StatementNode statementNode;
            this.jj_consume_token(220);
            if (this.jj_2_3(1)) {
                statementNode = this.setIsolationStatement();
            } else if (this.jj_2_4(1)) {
                statementNode = this.setSchemaStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 376: {
                        statementNode = this.setMessageLocaleStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 220 && this.getToken((int)2).kind == 101) {
            StatementNode statementNode;
            this.jj_consume_token(220);
            if (this.jj_2_5(1)) {
                statementNode = this.setSchemaStatement();
            } else if (this.jj_2_6(1)) {
                statementNode = this.setIsolationStatement();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableSQLDataStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 115: {
                StatementNode statementNode = this.preparableDeleteStatement();
                return statementNode;
            }
            case 218: 
            case 252: 
            case 420: {
                CursorNode cursorNode = this.preparableSelectStatement(true);
                return cursorNode;
            }
            case 159: {
                StatementNode statementNode = this.insertStatement();
                return statementNode;
            }
            case 247: {
                StatementNode statementNode = this.preparableUpdateStatement();
                return statementNode;
            }
            case 341: 
            case 418: 
            case 438: {
                StatementNode statementNode = this.callStatement();
                return statementNode;
            }
            case 213: 
            case 309: 
            case 314: {
                StatementNode statementNode = this.savepointStatement();
                return statementNode;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableDeleteStatement() throws ParseException, StandardException {
        this.jj_consume_token(115);
        StatementNode statementNode = this.deleteBody();
        return statementNode;
    }

    public final StatementNode deleteBody() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        TableName tableName = null;
        ValueNode valueNode = null;
        FromTable fromTable = null;
        Properties properties = null;
        Token token = null;
        if (this.fromNewInvocationFollows()) {
            this.jj_consume_token(140);
            javaToSQLValueNode = this.newInvocation();
            switch (this.jj_nt.kind) {
                case 258: {
                    token = this.jj_consume_token(258);
                    valueNode = this.whereClause(token);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                }
            }
            fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getDeleteNode(fromTable, tableName, valueNode);
        }
        switch (this.jj_nt.kind) {
            case 140: {
                this.jj_consume_token(140);
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 0 && this.getToken((int)1).kind != 258 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 66: {
                            this.jj_consume_token(66);
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                        }
                    }
                    string = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 258: {
                        token = this.jj_consume_token(258);
                        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 187) {
                            fromTable = this.currentOfClause(string);
                            break;
                        }
                        if (this.jj_2_7(1)) {
                            valueNode = this.whereClause(token);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, string, ReuseFactory.getInteger(2), null, this.getContextManager());
                }
                if (properties != null) {
                    ((FromBaseTable)fromTable).setTableProperties(properties);
                }
                return this.getDeleteNode(fromTable, tableName, valueNode);
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FromTable currentOfClause(String string) throws ParseException, StandardException {
        String string2 = null;
        this.jj_consume_token(101);
        this.jj_consume_token(187);
        string2 = this.identifier(128, true);
        return (FromTable)this.nodeFactory.getNode(99, string, string2, null, this.getContextManager());
    }

    public final CursorNode preparableSelectStatement(boolean bl) throws ParseException, StandardException {
        Vector vector = new Vector();
        int n = 0;
        int n2 = 0;
        OrderByList orderByList = null;
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 193: {
                orderByList = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 137: {
                this.jj_consume_token(137);
                n = this.forUpdateClause(vector);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 259: {
                n2 = this.atIsolationLevel();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        CursorNode cursorNode = (CursorNode)this.nodeFactory.getNode(147, "SELECT", resultSetNode, null, orderByList, ReuseFactory.getInteger(n), n == 1 ? null : vector, this.getContextManager());
        if (bl) {
            this.setUpAndLinkParameters();
        }
        if (n2 != 0) {
            this.getCompilerContext().setScanIsolationLevel(n2);
        }
        return cursorNode;
    }

    public final StatementNode insertStatement() throws ParseException, StandardException {
        this.jj_consume_token(159);
        this.jj_consume_token(163);
        QueryTreeNode queryTreeNode = this.targetTable();
        StatementNode statementNode = this.insertColumnsAndSource(queryTreeNode);
        this.setUpAndLinkParameters();
        return statementNode;
    }

    public final QueryTreeNode targetTable() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        Object var2_2 = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLValueNode = this.newInvocation();
            return this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), var2_2, null, null, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                TableName tableName = this.qualifiedName(128);
                return tableName;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableUpdateStatement() throws ParseException, StandardException {
        this.jj_consume_token(247);
        StatementNode statementNode = this.updateBody();
        return statementNode;
    }

    public final boolean tableOrIndex() throws ParseException {
        switch (this.jj_nt.kind) {
            case 232: {
                this.jj_consume_token(232);
                return true;
            }
            case 371: {
                this.jj_consume_token(371);
                return false;
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode updateBody() throws ParseException, StandardException {
        String string = null;
        JavaToSQLValueNode javaToSQLValueNode = null;
        TableName tableName = null;
        ValueNode valueNode = null;
        FromTable fromTable = null;
        Properties properties = null;
        Token token = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLValueNode = this.newInvocation();
            this.jj_consume_token(220);
            ResultColumnList resultColumnList = this.setClauseList();
            switch (this.jj_nt.kind) {
                case 258: {
                    token = this.jj_consume_token(258);
                    valueNode = this.whereClause(token);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                }
            }
            fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getUpdateNode(fromTable, tableName, resultColumnList, valueNode);
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 220 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 66: {
                            this.jj_consume_token(66);
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                        }
                    }
                    string = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                this.jj_consume_token(220);
                ResultColumnList resultColumnList = this.setClauseList();
                block12 : switch (this.jj_nt.kind) {
                    case 258: {
                        token = this.jj_consume_token(258);
                        if (this.jj_2_8(1)) {
                            valueNode = this.whereClause(token);
                            break;
                        }
                        switch (this.jj_nt.kind) {
                            case 101: {
                                fromTable = this.currentOfClause(string);
                                break block12;
                            }
                        }
                        this.jj_la1[23] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, string, ReuseFactory.getInteger(1), null, this.getContextManager());
                }
                if (properties != null) {
                    ((FromBaseTable)fromTable).setTableProperties(properties);
                }
                return this.getUpdateNode(fromTable, tableName, resultColumnList, valueNode);
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode callStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        switch (this.jj_nt.kind) {
            case 341: 
            case 438: {
                statementNode = this.bareCallStatement();
                break;
            }
            case 418: {
                this.jj_consume_token(418);
                statementNode = this.bareCallStatement();
                this.jj_consume_token(419);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode bareCallStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 341: {
                this.jj_consume_token(341);
                ValueNode valueNode = this.primaryExpression(true);
                if (!(valueNode instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)valueNode).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74");
                }
                StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(95, valueNode, this.getContextManager());
                this.setUpAndLinkParameters();
                return statementNode;
            }
            case 438: {
                ParameterNode parameterNode = this.dynamicParameterSpecification();
                this.getCompilerContext().setReturnParameterFlag();
                this.jj_consume_token(433);
                this.jj_consume_token(341);
                ResultSetNode resultSetNode = this.rowValueConstructor(null);
                ResultColumnList resultColumnList = resultSetNode.getResultColumns();
                if (resultColumnList == null || resultColumnList.size() > 1) {
                    throw StandardException.newException("42X74");
                }
                ValueNode valueNode = ((ResultColumn)resultColumnList.elementAt(0)).getExpression();
                if (!(valueNode instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)valueNode).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74");
                }
                StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(147, "SELECT", resultSetNode, null, null, ReuseFactory.getInteger(1), null, this.getContextManager());
                parameterNode.setReturnOutputParam(valueNode);
                this.setUpAndLinkParameters();
                return statementNode;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpression(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = null;
        if (this.getToken((int)2).kind == 426 && this.getToken((int)4).kind == 420) {
            valueNode = this.routineInvocation();
            return valueNode;
        }
        if (this.jj_2_9(1)) {
            valueNode = this.primaryExpressionXX(bl);
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode savepointStatement() throws ParseException, StandardException {
        int n;
        String string = null;
        Object[] objectArray = new Object[3];
        switch (this.jj_nt.kind) {
            case 314: {
                this.jj_consume_token(314);
                string = this.identifier(128, true);
                block17: while (true) {
                    this.savepointStatementClause(objectArray);
                    switch (this.jj_nt.kind) {
                        case 188: 
                        case 245: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[28] = this.jj_gen;
                if (objectArray[2] == null) {
                    throw StandardException.newException("42X01", "MISSING ON ROLLBACK RETAIN CURSORS");
                }
                n = 1;
                break;
            }
            case 213: {
                this.jj_consume_token(213);
                switch (this.jj_nt.kind) {
                    case 260: {
                        this.jj_consume_token(260);
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                    }
                }
                this.jj_consume_token(236);
                this.jj_consume_token(314);
                switch (this.jj_nt.kind) {
                    case 74: 
                    case 87: 
                    case 99: 
                    case 107: 
                    case 177: 
                    case 231: 
                    case 243: 
                    case 251: 
                    case 253: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 348: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 445: 
                    case 451: {
                        string = this.identifier(128, true);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                n = 2;
                break;
            }
            case 309: {
                this.jj_consume_token(309);
                switch (this.jj_nt.kind) {
                    case 236: {
                        this.jj_consume_token(236);
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                    }
                }
                this.jj_consume_token(314);
                string = this.identifier(128, true);
                n = 3;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (StatementNode)this.nodeFactory.getNode(198, string, ReuseFactory.getInteger(n), this.getContextManager());
    }

    public final void savepointStatementClause(Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 245: {
                this.jj_consume_token(245);
                n = 0;
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                this.jj_consume_token(213);
                this.jj_consume_token(396);
                n = this.LocksOrCursors();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = SAVEPOINT_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = Boolean.TRUE;
        }
    }

    public final int LocksOrCursors() throws ParseException {
        switch (this.jj_nt.kind) {
            case 292: {
                this.jj_consume_token(292);
                return 1;
            }
            case 363: {
                this.jj_consume_token(363);
                return 2;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {
        Object[] objectArray = new Object[3];
        this.jj_consume_token(111);
        this.jj_consume_token(144);
        this.jj_consume_token(233);
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        TableElementList tableElementList = this.tableElementList();
        do {
            this.declareTableClause(objectArray);
        } while (this.jj_2_10(1));
        if (objectArray[0] == null) {
            throw StandardException.newException("42X01", "MISSING NOT LOGGED");
        }
        if (objectArray[1] == null) {
            objectArray[1] = Boolean.TRUE;
        }
        if (objectArray[2] == null) {
            objectArray[2] = Boolean.TRUE;
        }
        return (StatementNode)this.nodeFactory.getNode(141, tableName, tableElementList, null, (Boolean)objectArray[1], (Boolean)objectArray[2], this.getContextManager());
    }

    public final void declareTableClause(Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        Boolean bl = null;
        switch (this.jj_nt.kind) {
            case 183: {
                this.jj_consume_token(183);
                this.jj_consume_token(294);
                bl = Boolean.TRUE;
                n = 0;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                if (this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 91) {
                    this.jj_consume_token(188);
                    this.jj_consume_token(91);
                    bl = this.onCommit();
                    this.jj_consume_token(214);
                    n = 1;
                    break;
                }
                if (this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 213) {
                    this.jj_consume_token(188);
                    this.jj_consume_token(213);
                    this.jj_consume_token(115);
                    this.jj_consume_token(214);
                    bl = Boolean.TRUE;
                    n = 2;
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = TEMPORARY_TABLE_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = bl;
        }
    }

    public final Boolean onCommit() throws ParseException {
        switch (this.jj_nt.kind) {
            case 200: {
                this.jj_consume_token(200);
                return Boolean.FALSE;
            }
            case 115: {
                this.jj_consume_token(115);
                return Boolean.TRUE;
            }
        }
        this.jj_la1[36] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementList tableElementList() throws ParseException, StandardException {
        TableElementList tableElementList = (TableElementList)this.nodeFactory.getNode(12, this.getContextManager());
        this.jj_consume_token(420);
        this.tableElement(tableElementList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.tableElement(tableElementList);
        }
        this.jj_consume_token(421);
        return tableElementList;
    }

    public final void tableElement(TableElementList tableElementList) throws ParseException, StandardException {
        this.explicitNotNull = false;
        this.explicitNull = false;
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                TableElementNode tableElementNode = this.columnDefinition(tableElementList);
                tableElementList.addTableElement(tableElementNode);
                break;
            }
            case 85: 
            case 94: 
            case 138: 
            case 201: 
            case 245: {
                TableElementNode tableElementNode = this.tableConstraintDefinition();
                tableElementList.addTableElement(tableElementNode);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        ValueNode valueNode = null;
        long[] lArray = new long[4];
        String string = this.identifier(128, true);
        dataTypeDescriptor = this.dataTypeDDL();
        switch (this.jj_nt.kind) {
            case 85: 
            case 94: 
            case 112: 
            case 183: 
            case 201: 
            case 208: 
            case 245: 
            case 259: 
            case 281: {
                valueNode = this.defaultAndConstraints(dataTypeDescriptor, tableElementList, string, lArray);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        if (lArray[2] == 0L) {
            lArray = null;
        }
        return (TableElementNode)this.nodeFactory.getNode(116, string, valueNode, dataTypeDescriptor, lArray, this.getContextManager());
    }

    public final ValueNode defaultAndConstraints(DataTypeDescriptor dataTypeDescriptor, TableElementList tableElementList, String string, long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        switch (this.jj_nt.kind) {
            case 85: 
            case 94: 
            case 183: 
            case 201: 
            case 208: 
            case 245: {
                this.columnConstraintDefinition(dataTypeDescriptor, tableElementList, string);
                block16: while (true) {
                    switch (this.jj_nt.kind) {
                        case 85: 
                        case 94: 
                        case 183: 
                        case 201: 
                        case 208: 
                        case 245: {
                            break;
                        }
                        default: {
                            this.jj_la1[40] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.columnConstraintDefinition(dataTypeDescriptor, tableElementList, string);
                }
                block7 : switch (this.jj_nt.kind) {
                    case 112: 
                    case 259: 
                    case 281: {
                        valueNode = this.defaultClause(lArray, string);
                        while (true) {
                            switch (this.jj_nt.kind) {
                                case 85: 
                                case 94: 
                                case 183: 
                                case 201: 
                                case 208: 
                                case 245: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[41] = this.jj_gen;
                                    break block7;
                                }
                            }
                            this.columnConstraintDefinition(dataTypeDescriptor, tableElementList, string);
                        }
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                    }
                }
                return valueNode;
            }
            case 112: 
            case 259: 
            case 281: {
                valueNode = this.defaultClause(lArray, string);
                block18: while (true) {
                    switch (this.jj_nt.kind) {
                        case 85: 
                        case 94: 
                        case 183: 
                        case 201: 
                        case 208: 
                        case 245: {
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.columnConstraintDefinition(dataTypeDescriptor, tableElementList, string);
                }
                return valueNode;
            }
        }
        this.jj_la1[44] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {
        if (!this.commonDatatypeName(false)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor dataTypeCast() throws ParseException, StandardException {
        if (!this.commonDatatypeName(true)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        boolean bl = false;
        if (this.jj_2_11(1)) {
            if (this.getToken((int)2).kind == 289) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            dataTypeDescriptor = this.characterStringType();
        } else if (this.jj_2_12(1)) {
            if (this.getToken((int)3).kind == 289) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            dataTypeDescriptor = this.nationalCharacterStringType();
        } else if (this.jj_2_13(1)) {
            dataTypeDescriptor = this.numericType();
        } else {
            switch (this.jj_nt.kind) {
                case 276: 
                case 331: 
                case 332: {
                    dataTypeDescriptor = this.datetimeType();
                    break;
                }
                case 340: {
                    this.jj_consume_token(340);
                    this.checkInternalFeature("BOOLEAN");
                    dataTypeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
                    break;
                }
                case 348: {
                    dataTypeDescriptor = this.longType();
                    break;
                }
                case 74: 
                case 82: 
                case 83: 
                case 178: 
                case 267: 
                case 270: 
                case 302: {
                    dataTypeDescriptor = this.LOBType();
                    break;
                }
                case 352: {
                    dataTypeDescriptor = this.XMLType();
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor characterStringType() throws ParseException, StandardException {
        int n;
        int n2 = 1;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                n2 = this.charLength();
                n = 12;
                break;
            }
            case 82: 
            case 83: {
                this.charOrCharacter();
                block4 : switch (this.jj_nt.kind) {
                    case 255: {
                        token = this.jj_consume_token(255);
                        n2 = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 420: {
                                n2 = this.charLength();
                                break block4;
                            }
                        }
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                n = token == null ? 1 : 12;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 137: {
                n = this.forBitData(n);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        this.checkTypeLimits(n, n2);
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2);
        return dataTypeDescriptor;
    }

    public final void charOrCharacter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int charLength() throws ParseException, StandardException {
        this.jj_consume_token(420);
        int n = this.length();
        this.jj_consume_token(421);
        return n;
    }

    public final int forBitData(int n) throws ParseException {
        this.jj_consume_token(137);
        this.jj_consume_token(75);
        this.jj_consume_token(275);
        if (n == 1) {
            n = -2;
        } else if (n == 12) {
            n = -3;
        } else if (n == -1) {
            n = -4;
        }
        return n;
    }

    public final DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {
        int n = 1;
        String string = null;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 178: {
                this.jj_consume_token(178);
                this.charOrCharacter();
                block5 : switch (this.jj_nt.kind) {
                    case 255: {
                        token = this.jj_consume_token(255);
                        n = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 420: {
                                n = this.charLength();
                                break block5;
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                string = token == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 180: {
                this.jj_consume_token(180);
                block11 : switch (this.jj_nt.kind) {
                    case 255: {
                        token = this.jj_consume_token(255);
                        n = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 420: {
                                n = this.charLength();
                                break block11;
                            }
                        }
                        this.jj_la1[53] = this.jj_gen;
                    }
                }
                string = token == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 381: {
                this.jj_consume_token(381);
                n = this.charLength();
                string = "NATIONAL CHAR VARYING";
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw StandardException.newException("0A000.S", string);
    }

    public final DataTypeDescriptor LOBType() throws ParseException, StandardException {
        String string;
        int n = Integer.MAX_VALUE;
        switch (this.jj_nt.kind) {
            case 267: {
                this.jj_consume_token(267);
                switch (this.jj_nt.kind) {
                    case 420: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                string = "BLOB";
                break;
            }
            case 270: {
                this.jj_consume_token(270);
                switch (this.jj_nt.kind) {
                    case 420: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                    }
                }
                string = "CLOB";
                break;
            }
            case 302: {
                this.jj_consume_token(302);
                n = this.lengthAndModifier();
                String string2 = "NCLOB";
                throw StandardException.newException("0A000.S", string2);
            }
            case 74: {
                this.jj_consume_token(74);
                this.jj_consume_token(289);
                this.jj_consume_token(305);
                switch (this.jj_nt.kind) {
                    case 420: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                string = "BLOB";
                break;
            }
            case 82: 
            case 83: {
                this.charOrCharacter();
                this.jj_consume_token(289);
                this.jj_consume_token(305);
                switch (this.jj_nt.kind) {
                    case 420: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                    }
                }
                string = "CLOB";
                break;
            }
            case 178: {
                this.jj_consume_token(178);
                this.jj_consume_token(83);
                this.jj_consume_token(289);
                this.jj_consume_token(305);
                n = this.lengthAndModifier();
                String string3 = "NCLOB";
                throw StandardException.newException("0A000.S", string3);
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(string, n);
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor numericType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 109: 
            case 110: 
            case 160: 
            case 161: 
            case 186: 
            case 221: 
            case 347: {
                DataTypeDescriptor dataTypeDescriptor = this.exactNumericType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[61] = this.jj_gen;
        if (this.jj_2_14(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.approximateNumericType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactNumericType() throws ParseException, StandardException {
        int n = 5;
        int n2 = 0;
        int n3 = 3;
        String string = "DECIMAL";
        DataTypeDescriptor dataTypeDescriptor = null;
        switch (this.jj_nt.kind) {
            case 109: 
            case 110: 
            case 186: {
                switch (this.jj_nt.kind) {
                    case 186: {
                        this.jj_consume_token(186);
                        n3 = 2;
                        string = "NUMERIC";
                        break;
                    }
                    case 110: {
                        this.jj_consume_token(110);
                        break;
                    }
                    case 109: {
                        this.jj_consume_token(109);
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        n = this.precision();
                        switch (this.jj_nt.kind) {
                            case 424: {
                                this.jj_consume_token(424);
                                n2 = this.scale();
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                    }
                }
                if (n <= 0 || n > 31) {
                    throw StandardException.newException("42X48", (Object)string, (Object)String.valueOf(n));
                }
                if (n2 < 0 || n2 > 31) {
                    throw StandardException.newException("42Y42", (Object)string, (Object)String.valueOf(n2));
                }
                if (n2 > n) {
                    throw StandardException.newException("42Y43", (Object)String.valueOf(n2), (Object)String.valueOf(n));
                }
                int n4 = DataTypeUtilities.computeMaxWidth(n, n2);
                return this.getDataTypeServices(n3, n, n2, n4);
            }
            case 160: 
            case 161: 
            case 221: 
            case 347: {
                dataTypeDescriptor = this.exactIntegerType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 160: 
            case 161: {
                switch (this.jj_nt.kind) {
                    case 161: {
                        this.jj_consume_token(161);
                        break;
                    }
                    case 160: {
                        this.jj_consume_token(160);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(4);
            }
            case 221: {
                this.jj_consume_token(221);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(5);
            }
            case 347: {
                this.jj_consume_token(347);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5);
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        DataTypeDescriptor dataTypeDescriptor = null;
        switch (this.jj_nt.kind) {
            case 136: {
                this.jj_consume_token(136);
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        n4 = this.precision();
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                    }
                }
                if (n4 == -1) {
                    n4 = 52;
                }
                if (n4 > 0 && n4 <= 23) {
                    n = 7;
                    n4 = 23;
                    n2 = 0;
                    n3 = 4;
                } else if (n4 > 23 && n4 <= 52) {
                    n = 8;
                    n4 = 52;
                    n2 = 0;
                    n3 = 8;
                } else {
                    throw StandardException.newException("42X48", (Object)"FLOAT", (Object)String.valueOf(n4));
                }
                return this.getDataTypeServices(n, n4, n2, n3);
            }
            case 207: {
                this.jj_consume_token(207);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(7);
            }
        }
        this.jj_la1[69] = this.jj_gen;
        if (this.jj_2_15(1)) {
            dataTypeDescriptor = this.doubleType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor doubleType() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 308) {
            this.jj_consume_token(121);
            this.jj_consume_token(308);
        } else {
            switch (this.jj_nt.kind) {
                case 121: {
                    this.jj_consume_token(121);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
    }

    public final DataTypeDescriptor longType() throws ParseException, StandardException {
        this.jj_consume_token(348);
        DataTypeDescriptor dataTypeDescriptor = this.longSubType();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor longSubType() throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 137: {
                        n = this.forBitData(n);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n);
            }
            case 381: {
                this.jj_consume_token(381);
                throw StandardException.newException("0A000.S", "LONG NVARCHAR");
            }
        }
        this.jj_la1[72] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor XMLType() throws ParseException, StandardException {
        this.jj_consume_token(352);
        this.checkVersion(130, "XML");
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(456);
    }

    public final void xmlDocOrContent() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 366 && this.getToken((int)1).kind != 361) {
            throw StandardException.newException("42Z72", (Object)"DOCUMENT", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        if (this.getToken((int)1).kind == 361) {
            this.jj_consume_token(361);
            throw StandardException.newException("42Z74", "CONTENT");
        }
        if (this.getToken((int)1).kind == 366) {
            this.jj_consume_token(366);
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor javaType() throws ParseException, StandardException {
        String string = this.javaClassName();
        return this.getJavaClassDataTypeDescriptor(string);
    }

    public final String javaDSL() throws ParseException {
        String string = this.caseSensitiveIdentifierPlusReservedWords();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 426: {
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    break block3;
                }
            }
            string = this.javaDSLNameExtender(string);
        }
        return string;
    }

    public final String javaClassName() throws ParseException {
        String string = this.javaDSL();
        return string;
    }

    public final String javaDSLNameExtender(String string) throws ParseException {
        this.jj_consume_token(426);
        String string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return string + "." + string2;
    }

    public final int lengthAndModifier() throws ParseException, StandardException {
        Token token;
        Token token2 = null;
        this.jj_consume_token(420);
        block1 : switch (this.jj_nt.kind) {
            case 454: {
                token = this.jj_consume_token(454);
                break;
            }
            case 452: {
                token = this.jj_consume_token(452);
                switch (this.jj_nt.kind) {
                    case 445: {
                        token2 = this.jj_consume_token(445);
                        break block1;
                    }
                }
                this.jj_la1[74] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(421);
        String string = token.image + (token2 == null ? "" : token2.image);
        try {
            long l;
            char c = string.charAt(string.length() - 1);
            String string2 = string.substring(0, string.length() - 1);
            switch (c) {
                case 'G': 
                case 'g': {
                    l = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    l = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    l = 1024L;
                    break;
                }
                default: {
                    l = 1L;
                    string2 = string;
                }
            }
            long l2 = Long.parseLong(string2) * l;
            if (l2 > 0L && l2 <= Integer.MAX_VALUE) {
                return (int)l2;
            }
            if (l != 1L && l2 == 0x80000000L) {
                return Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", string);
    }

    public final int length() throws ParseException, StandardException {
        Token token = this.jj_consume_token(452);
        try {
            int n = Integer.parseInt(token.image);
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", token.image);
    }

    public final long exactNumber() throws ParseException, StandardException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 423: 
            case 425: {
                string = this.sign();
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(452);
        try {
            if (string.equals("-")) {
                return Long.parseLong("-" + token.image);
            }
            return Long.parseLong(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X49", token.image);
        }
    }

    public final int precision() throws ParseException, StandardException {
        int n = this.uint_value();
        return n;
    }

    public final int uint_value() throws ParseException, StandardException {
        Token token = this.jj_consume_token(452);
        try {
            return Integer.parseInt(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X49", token.image);
        }
    }

    public final int scale() throws ParseException, StandardException {
        int n = this.uint_value();
        return n;
    }

    public final DataTypeDescriptor datetimeType() throws ParseException, StandardException {
        Object var1_1 = null;
        int n = -1;
        switch (this.jj_nt.kind) {
            case 276: {
                this.jj_consume_token(276);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(91);
            }
            case 331: {
                this.jj_consume_token(331);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(92);
            }
            case 332: {
                this.jj_consume_token(332);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(93);
            }
        }
        this.jj_la1[77] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void qualifiedNameList(Vector vector, int n) throws ParseException, StandardException {
        this.qualifiedNameElement(vector, n);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.qualifiedNameElement(vector, n);
        }
    }

    public final void qualifiedNameElement(Vector vector, int n) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(n);
        vector.addElement(tableName);
    }

    public final TableName qualifiedName(int n, int n2) throws ParseException, StandardException {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string3 = this.identifier(128, false);
        if (this.getToken((int)1).kind == 426 && this.getToken((int)2).kind != 422) {
            this.jj_consume_token(426);
            string4 = this.identifier(128, false);
        }
        if (string4 == null) {
            string = string3;
        } else {
            string2 = string3;
            string = string4;
        }
        this.checkIdentifierLengthLimit(string, n2);
        if (string2 != null) {
            this.checkIdentifierLengthLimit(string2, 128);
        }
        return (TableName)this.nodeFactory.getNode(n, string2, string, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
    }

    public final ResultSetNode queryExpression(ResultSetNode resultSetNode, int n) throws ParseException, StandardException {
        ResultSetNode resultSetNode2 = this.nonJoinQueryTerm(resultSetNode, n);
        switch (this.jj_nt.kind) {
            case 127: 
            case 244: {
                resultSetNode2 = this.unionOrExcept(resultSetNode2);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        return resultSetNode2;
    }

    public final ResultSetNode unionOrExcept(ResultSetNode resultSetNode) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 244: {
                this.jj_consume_token(244);
                block4 : switch (this.jj_nt.kind) {
                    case 60: 
                    case 120: {
                        switch (this.jj_nt.kind) {
                            case 60: {
                                token = this.jj_consume_token(60);
                                break block4;
                            }
                            case 120: {
                                this.jj_consume_token(120);
                                break block4;
                            }
                        }
                        this.jj_la1[80] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                    }
                }
                ResultSetNode resultSetNode2 = this.queryExpression(resultSetNode, token != null ? 2 : 1);
                return resultSetNode2;
            }
            case 127: {
                this.jj_consume_token(127);
                block11 : switch (this.jj_nt.kind) {
                    case 60: 
                    case 120: {
                        switch (this.jj_nt.kind) {
                            case 60: {
                                token = this.jj_consume_token(60);
                                break block11;
                            }
                            case 120: {
                                this.jj_consume_token(120);
                                break block11;
                            }
                        }
                        this.jj_la1[82] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                    }
                }
                ResultSetNode resultSetNode3 = this.queryExpression(resultSetNode, token != null ? 4 : 3);
                return resultSetNode3;
            }
        }
        this.jj_la1[84] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode nonJoinQueryTerm(ResultSetNode resultSetNode, int n) throws ParseException, StandardException {
        ResultSetNode resultSetNode2 = this.nonJoinQueryPrimary();
        switch (this.jj_nt.kind) {
            case 162: {
                resultSetNode2 = this.intersect(resultSetNode2);
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
            }
        }
        switch (n) {
            case 0: {
                return resultSetNode2;
            }
            case 1: {
                return (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode2, Boolean.FALSE, Boolean.FALSE, null, this.getContextManager());
            }
            case 2: {
                return (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode2, Boolean.TRUE, Boolean.FALSE, null, this.getContextManager());
            }
            case 3: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(2), resultSetNode, resultSetNode2, Boolean.FALSE, null, this.getContextManager());
            }
            case 4: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(2), resultSetNode, resultSetNode2, Boolean.TRUE, null, this.getContextManager());
            }
            case 5: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(1), resultSetNode, resultSetNode2, Boolean.FALSE, null, this.getContextManager());
            }
            case 6: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(1), resultSetNode, resultSetNode2, Boolean.TRUE, null, this.getContextManager());
            }
        }
        return null;
    }

    public final ResultSetNode intersect(ResultSetNode resultSetNode) throws ParseException, StandardException {
        Token token = null;
        this.jj_consume_token(162);
        block0 : switch (this.jj_nt.kind) {
            case 60: 
            case 120: {
                switch (this.jj_nt.kind) {
                    case 60: {
                        token = this.jj_consume_token(60);
                        break block0;
                    }
                    case 120: {
                        this.jj_consume_token(120);
                        break block0;
                    }
                }
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        ResultSetNode resultSetNode2 = this.nonJoinQueryTerm(resultSetNode, token != null ? 6 : 5);
        return resultSetNode2;
    }

    public final ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 218: 
            case 252: {
                ResultSetNode resultSetNode = this.simpleTable();
                return resultSetNode;
            }
            case 420: {
                this.jj_consume_token(420);
                ResultSetNode resultSetNode = this.queryExpression(null, 0);
                this.jj_consume_token(421);
                return resultSetNode;
            }
        }
        this.jj_la1[88] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode simpleTable() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 218: {
                ResultSetNode resultSetNode = this.querySpecification();
                return resultSetNode;
            }
            case 252: {
                ResultSetNode resultSetNode = this.tableValueConstructor();
                return resultSetNode;
            }
        }
        this.jj_la1[89] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode querySpecification() throws ParseException, StandardException {
        boolean bl = false;
        this.jj_consume_token(218);
        if (this.jj_2_16(1)) {
            bl = this.setQuantifier();
        }
        ResultColumnList resultColumnList = this.selectList();
        SelectNode selectNode = this.tableExpression(resultColumnList);
        if (bl) {
            selectNode.makeDistinct();
        }
        return selectNode;
    }

    public final boolean setQuantifier() throws ParseException {
        if (this.getToken((int)1).kind == 120 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            this.jj_consume_token(120);
            return true;
        }
        if (this.getToken((int)1).kind == 60 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            this.jj_consume_token(60);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList selectList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        switch (this.jj_nt.kind) {
            case 422: {
                this.jj_consume_token(422);
                ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(16, null, this.getContextManager());
                resultColumnList.addResultColumn(resultColumn);
                return resultColumnList;
            }
        }
        this.jj_la1[90] = this.jj_gen;
        if (this.jj_2_17(1)) {
            this.selectColumnList(resultColumnList);
            return resultColumnList;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void selectColumnList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.selectSublist(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.selectSublist(resultColumnList);
        }
    }

    public final void selectSublist(ResultColumnList resultColumnList) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 426 && (this.getToken((int)3).kind == 422 || this.getToken((int)4).kind == 426 && this.getToken((int)5).kind == 422)) {
            TableName tableName = this.qualifiedName(128);
            this.jj_consume_token(426);
            this.jj_consume_token(422);
            ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(16, tableName, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        } else if (this.jj_2_18(1)) {
            ResultColumn resultColumn = this.derivedColumn(resultColumnList);
            resultColumnList.addResultColumn(resultColumn);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ResultColumn derivedColumn(ResultColumnList resultColumnList) throws ParseException, StandardException {
        String string = null;
        ValueNode valueNode = this.additiveExpression(null, 0, true);
        switch (this.jj_nt.kind) {
            case 66: 
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                string = this.asClause();
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
            }
        }
        if (string == null && valueNode instanceof ColumnReference) {
            string = ((ColumnReference)valueNode).columnName;
        }
        return (ResultColumn)this.nodeFactory.getNode(80, string, valueNode, this.getContextManager());
    }

    public final String asClause() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        String string = this.identifier(128, true);
        return string;
    }

    public final ValueNode valueExpression(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = this.orExpression(null, bl);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 192: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(192);
            valueNode = this.orExpression(valueNode, bl);
        }
        return valueNode;
    }

    public final ValueNode orExpression(ValueNode valueNode, boolean bl) throws ParseException, StandardException {
        ValueNode valueNode2 = this.andExpression(null, bl);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(63);
            valueNode2 = this.andExpression(valueNode2, bl);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        return (ValueNode)this.nodeFactory.getNode(52, valueNode, valueNode2, this.getContextManager());
    }

    public final ValueNode andExpression(ValueNode valueNode, boolean bl) throws ParseException, StandardException {
        Token token = null;
        if (this.getToken((int)1).kind == 183 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            token = this.jj_consume_token(183);
        }
        ValueNode valueNode2 = this.isSearchCondition(bl);
        if (token != null) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(26, valueNode2, this.getContextManager());
        }
        if (valueNode != null) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(39, valueNode, valueNode2, this.getContextManager());
        }
        return valueNode2;
    }

    public final ValueNode isSearchCondition(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode;
        Token token = null;
        Token token2 = null;
        Object var6_4 = null;
        ValueNode valueNode2 = this.booleanPrimary(bl);
        switch (this.jj_nt.kind) {
            case 164: {
                token = this.jj_consume_token(164);
                switch (this.jj_nt.kind) {
                    case 183: {
                        token2 = this.jj_consume_token(183);
                        break;
                    }
                    default: {
                        this.jj_la1[96] = this.jj_gen;
                    }
                }
                this.jj_consume_token(184);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        if (token != null) {
            valueNode = (ValueNode)this.nodeFactory.getNode(25, valueNode2, this.getContextManager());
            if (token2 != null) {
                valueNode = (ValueNode)this.nodeFactory.getNode(26, valueNode, this.getContextManager());
            }
        } else {
            valueNode = valueNode2;
        }
        return valueNode;
    }

    public final ValueNode booleanPrimary(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = this.predicate(bl);
        return valueNode;
    }

    public final ValueNode predicate(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode;
        if (this.jj_2_19(1)) {
            valueNode = this.additiveExpression(null, 0, bl);
        } else {
            switch (this.jj_nt.kind) {
                case 131: {
                    valueNode = this.existsExpression();
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        while (this.remainingPredicateFollows()) {
            valueNode = this.remainingPredicate(valueNode, bl);
        }
        return valueNode;
    }

    public final ValueNode remainingPredicate(ValueNode valueNode, boolean bl) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 431: 
            case 432: 
            case 433: 
            case 434: 
            case 435: 
            case 436: 
            case 437: {
                valueNode = this.remainingNonNegatablePredicate(valueNode, bl);
                return valueNode;
            }
            case 73: 
            case 153: 
            case 171: 
            case 183: {
                switch (this.jj_nt.kind) {
                    case 183: {
                        token = this.jj_consume_token(183);
                        break;
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                    }
                }
                valueNode = this.remainingNegatablePredicate(valueNode, bl);
                if (token != null) {
                    valueNode = (ValueNode)this.nodeFactory.getNode(26, valueNode, this.getContextManager());
                }
                return valueNode;
            }
        }
        this.jj_la1[100] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode remainingNonNegatablePredicate(ValueNode valueNode, boolean bl) throws ParseException, StandardException {
        Object var5_3 = null;
        Object var6_4 = null;
        int n = this.compOp();
        if ((this.getToken((int)1).kind == 60 || this.getToken((int)1).kind == 64 || this.getToken((int)1).kind == 222) && this.getToken((int)2).kind == 420) {
            n = this.quantifier(n);
            this.jj_consume_token(420);
            valueNode = this.tableSubquery(n, valueNode);
            this.jj_consume_token(421);
        } else if (this.jj_2_20(1)) {
            valueNode = this.additiveExpression(valueNode, n, bl);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return valueNode;
    }

    public final ValueNode remainingNegatablePredicate(ValueNode valueNode, boolean bl) throws ParseException, StandardException {
        ValueNode valueNode2 = null;
        ValueNode valueNode3 = null;
        switch (this.jj_nt.kind) {
            case 153: {
                this.jj_consume_token(153);
                valueNode2 = this.inPredicateValue(valueNode);
                return valueNode2;
            }
            case 171: {
                this.jj_consume_token(171);
                ValueNode valueNode4 = this.additiveExpression(null, 0, bl);
                block5 : switch (this.jj_nt.kind) {
                    case 126: 
                    case 418: {
                        switch (this.jj_nt.kind) {
                            case 126: {
                                this.jj_consume_token(126);
                                valueNode3 = this.additiveExpression(null, 0, bl);
                                break block5;
                            }
                            case 418: {
                                this.jj_consume_token(418);
                                this.jj_consume_token(126);
                                valueNode3 = this.additiveExpression(null, 0, bl);
                                this.jj_consume_token(419);
                                break block5;
                            }
                        }
                        this.jj_la1[101] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[102] = this.jj_gen;
                    }
                }
                valueNode2 = (ValueNode)this.nodeFactory.getNode(51, valueNode, valueNode4, valueNode3, this.getContextManager());
                return valueNode2;
            }
            case 73: {
                this.jj_consume_token(73);
                ValueNode valueNode5 = this.additiveExpression(null, 0, bl);
                this.jj_consume_token(63);
                ValueNode valueNode6 = this.additiveExpression(null, 0, bl);
                ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
                valueNodeList.addElement(valueNode5);
                valueNodeList.addElement(valueNode6);
                valueNode2 = (ValueNode)this.nodeFactory.getNode(53, valueNode, valueNodeList, this.getContextManager());
                return valueNode2;
            }
        }
        this.jj_la1[103] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int compOp() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 433: {
                this.jj_consume_token(433);
                return 6;
            }
            case 434: {
                this.jj_consume_token(434);
                return 7;
            }
            case 435: {
                this.jj_consume_token(435);
                return 7;
            }
            case 431: {
                this.jj_consume_token(431);
                return 10;
            }
            case 436: {
                this.jj_consume_token(436);
                return 8;
            }
            case 432: {
                this.jj_consume_token(432);
                return 11;
            }
            case 437: {
                this.jj_consume_token(437);
                return 9;
            }
        }
        this.jj_la1[104] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode additiveExpression(ValueNode valueNode, int n, boolean bl) throws ParseException, StandardException {
        int n2;
        ValueNode valueNode2 = this.multiplicativeExpression(null, 0, bl);
        block11: while (true) {
            switch (this.jj_nt.kind) {
                case 423: 
                case 425: {
                    break;
                }
                default: {
                    this.jj_la1[105] = this.jj_gen;
                    break block11;
                }
            }
            int n3 = this.additiveOperator();
            valueNode2 = this.multiplicativeExpression(valueNode2, n3, bl);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 6: {
                n2 = 41;
                break;
            }
            case 7: {
                n2 = 47;
                break;
            }
            case 10: {
                n2 = 45;
                break;
            }
            case 8: {
                n2 = 43;
                break;
            }
            case 11: {
                n2 = 44;
                break;
            }
            case 9: {
                n2 = 42;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return (ValueNode)this.nodeFactory.getNode(n2, valueNode, valueNode2, this.getContextManager());
    }

    public final int additiveOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 423: {
                Token token = this.jj_consume_token(423);
                return 1;
            }
            case 425: {
                Token token = this.jj_consume_token(425);
                return 2;
            }
        }
        this.jj_la1[106] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode multiplicativeExpression(ValueNode valueNode, int n, boolean bl) throws ParseException, StandardException {
        ValueNode valueNode2 = this.unaryExpression(null, 0, bl);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 422: 
                case 427: 
                case 443: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block7;
                }
            }
            int n2 = this.multiplicativeOperator();
            valueNode2 = this.unaryExpression(valueNode2, n2, bl);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 1: {
                return (ValueNode)this.nodeFactory.getNode(48, valueNode, valueNode2, this.getContextManager());
            }
            case 2: {
                return (ValueNode)this.nodeFactory.getNode(46, valueNode, valueNode2, this.getContextManager());
            }
        }
        return null;
    }

    public final int multiplicativeOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 422: {
                this.jj_consume_token(422);
                return 3;
            }
            case 427: {
                this.jj_consume_token(427);
                return 4;
            }
            case 443: {
                this.jj_consume_token(443);
                return 5;
            }
        }
        this.jj_la1[108] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode unaryExpression(ValueNode valueNode, int n, boolean bl) throws ParseException, StandardException {
        int n2;
        String string = null;
        int n3 = this.getToken((int)1).kind;
        if ((n3 == 423 || n3 == 425) && (n2 = this.getToken((int)2).kind) != 452 && n2 != 457) {
            string = this.sign();
        }
        ValueNode valueNode2 = this.primaryExpression(bl);
        if ("-".equals(string)) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(29, valueNode2, this.getContextManager());
        } else if ("+".equals(string)) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(30, valueNode2, this.getContextManager());
        }
        return this.multOp(valueNode, valueNode2, n);
    }

    public final String sign() throws ParseException {
        switch (this.jj_nt.kind) {
            case 423: {
                Token token = this.jj_consume_token(423);
                return token.image;
            }
            case 425: {
                Token token = this.jj_consume_token(425);
                return token.image;
            }
        }
        this.jj_la1[109] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpressionXX(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = this.primary(bl);
        while (this.jj_2_21(1)) {
            valueNode = this.nonStaticMethodCallOrFieldAccess(valueNode);
        }
        return valueNode;
    }

    public final ValueNode nonStaticMethodCallOrFieldAccess(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = this.nonStaticMethodInvocation(valueNode);
        return valueNode2;
    }

    public final ValueNode nonStaticMethodInvocation(ValueNode valueNode) throws ParseException, StandardException {
        Vector vector = new Vector();
        if (this.getToken((int)3).kind == 420) {
            switch (this.jj_nt.kind) {
                case 444: {
                    this.jj_consume_token(444);
                    break;
                }
                case 426: {
                    this.jj_consume_token(426);
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MethodCallNode methodCallNode = this.methodName(valueNode);
            this.methodCallParameterList(vector);
            if (valueNode instanceof ParameterNode) {
                throw StandardException.newException("42X54", methodCallNode.getMethodName());
            }
            methodCallNode.addParms(vector);
            return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 426: {
                this.jj_consume_token(426);
                MethodCallNode methodCallNode = this.methodName(valueNode);
                if (valueNode instanceof ParameterNode) {
                    throw StandardException.newException("42X54", methodCallNode.getMethodName());
                }
                methodCallNode.addParms(vector);
                return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
            }
        }
        this.jj_la1[111] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final MethodCallNode methodName(ValueNode valueNode) throws ParseException, StandardException {
        String string = this.caseSensitiveIdentifierPlusReservedWords();
        return (MethodCallNode)this.nodeFactory.getNode(98, string, valueNode, this.getContextManager());
    }

    public final MethodCallNode staticMethodName(String string) throws ParseException, StandardException {
        String string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return (MethodCallNode)this.nodeFactory.getNode(85, string2, string, this.getContextManager());
    }

    public final void methodParameter(Vector vector) throws ParseException, StandardException {
        if (this.jj_2_22(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0, false);
            vector.addElement(valueNode);
        } else {
            switch (this.jj_nt.kind) {
                case 184: {
                    ValueNode valueNode = this.nullSpecification();
                    vector.addElement(valueNode);
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final ValueNode primary(boolean bl) throws ParseException, StandardException {
        if (this.javaClassFollows()) {
            ValueNode valueNode = this.staticClassReference();
            return valueNode;
        }
        if (this.jj_2_23(1)) {
            ValueNode valueNode = this.valueExpressionPrimary(bl);
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassReference() throws ParseException, StandardException {
        String string = this.javaClass();
        this.jj_consume_token(429);
        ValueNode valueNode = this.staticClassReferenceType(string);
        return valueNode;
    }

    public final ValueNode staticClassReferenceType(String string) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 420) {
            ValueNode valueNode = this.staticMethodInvocation(string);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                ValueNode valueNode = this.staticClassFieldReference(string);
                return valueNode;
            }
        }
        this.jj_la1[113] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassFieldReference(String string) throws ParseException, StandardException {
        String string2 = null;
        string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(84, string, string2, this.nextToLastTokenDelimitedIdentifier, this.getContextManager()), this.getContextManager());
    }

    public final int nonSecondDatetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 262: {
                this.jj_consume_token(262);
                return 0;
            }
            case 298: {
                this.jj_consume_token(298);
                return 1;
            }
            case 277: {
                this.jj_consume_token(277);
                return 2;
            }
            case 150: {
                this.jj_consume_token(150);
                return 3;
            }
            case 176: {
                this.jj_consume_token(176);
                return 4;
            }
        }
        this.jj_la1[114] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedValueFunction() throws ParseException, StandardException {
        ValueNode valueNode = null;
        if (this.jj_2_24(1)) {
            ValueNode valueNode2 = this.miscBuiltinsCore(true);
            return valueNode2;
        }
        switch (this.jj_nt.kind) {
            case 228: {
                this.jj_consume_token(228);
                this.jj_consume_token(420);
                ValueNode valueNode3 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode4 = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        valueNode = this.additiveExpression(null, 0, false);
                        break;
                    }
                    default: {
                        this.jj_la1[115] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                return this.getSubstringNode(valueNode3, valueNode4, valueNode, Boolean.FALSE);
            }
            case 342: {
                this.jj_consume_token(342);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
            }
            case 343: {
                this.jj_consume_token(343);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 273: {
                this.jj_consume_token(273);
                this.jj_consume_token(420);
                ValueNode valueNode5 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode6 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(50, valueNode5, valueNode6, this.getContextManager());
            }
            case 105: 
            case 219: 
            case 249: {
                ValueNode valueNode7 = this.userNode();
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return valueNode7;
            }
            case 333: 
            case 334: {
                ValueNode valueNode8 = this.timestampArithmeticFuncion();
                return valueNode8;
            }
        }
        this.jj_la1[116] = this.jj_gen;
        if (this.getEscapedSYSFUN(this.getToken((int)1).image) != null) {
            ValueNode valueNode9 = this.escapedSYSFUNFunction();
            return valueNode9;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {
        Vector vector = new Vector();
        Token token = this.jj_consume_token(445);
        this.methodCallParameterList(vector);
        String string = this.getEscapedSYSFUN(token.image);
        TableName tableName = (TableName)this.nodeFactory.getNode(34, "SYSFUN", string, new Integer(0), new Integer(0), this.getContextManager());
        MethodCallNode methodCallNode = (MethodCallNode)this.nodeFactory.getNode(85, tableName, null, this.getContextManager());
        methodCallNode.addParms(vector);
        return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 333: {
                this.jj_consume_token(333);
                this.jj_consume_token(420);
                ValueNode valueNode = this.jdbcIntervalType();
                this.jj_consume_token(424);
                ValueNode valueNode2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode3 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(184, valueNode3, valueNode, valueNode2, ReuseFactory.getInteger(4), null, this.getContextManager());
            }
            case 334: {
                this.jj_consume_token(334);
                this.jj_consume_token(420);
                ValueNode valueNode = this.jdbcIntervalType();
                this.jj_consume_token(424);
                ValueNode valueNode4 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode5 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(185, valueNode5, valueNode, valueNode4, ReuseFactory.getInteger(5), null, this.getContextManager());
            }
        }
        this.jj_la1[117] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode jdbcIntervalType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 318: {
                this.jj_consume_token(318);
                return this.getJdbcIntervalNode(0);
            }
            case 319: {
                this.jj_consume_token(319);
                return this.getJdbcIntervalNode(1);
            }
            case 320: {
                this.jj_consume_token(320);
                return this.getJdbcIntervalNode(2);
            }
            case 321: {
                this.jj_consume_token(321);
                return this.getJdbcIntervalNode(3);
            }
            case 322: {
                this.jj_consume_token(322);
                return this.getJdbcIntervalNode(4);
            }
            case 323: {
                this.jj_consume_token(323);
                return this.getJdbcIntervalNode(5);
            }
            case 324: {
                this.jj_consume_token(324);
                return this.getJdbcIntervalNode(6);
            }
            case 325: {
                this.jj_consume_token(325);
                return this.getJdbcIntervalNode(7);
            }
            case 326: {
                this.jj_consume_token(326);
                return this.getJdbcIntervalNode(8);
            }
        }
        this.jj_la1[118] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericValueFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 263: {
                this.jj_consume_token(263);
                ValueNode valueNode = this.absFunction();
                return valueNode;
            }
            case 264: {
                this.jj_consume_token(264);
                ValueNode valueNode = this.absFunction();
                return valueNode;
            }
            case 406: {
                this.jj_consume_token(406);
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(189, valueNode, this.getContextManager());
            }
            case 295: {
                this.jj_consume_token(295);
                ValueNode valueNode = this.modFunction();
                return valueNode;
            }
            case 282: {
                this.jj_consume_token(282);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(5, this.getContextManager());
            }
        }
        this.jj_la1[119] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode coalesceFunction(String string) throws ParseException, StandardException {
        ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
        this.jj_consume_token(420);
        this.coalesceExpression(valueNodeList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[120] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.coalesceExpression(valueNodeList);
        }
        this.jj_consume_token(421);
        return (ValueNode)this.nodeFactory.getNode(192, string, valueNodeList, this.getContextManager());
    }

    public final void coalesceExpression(ValueNodeList valueNodeList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        valueNodeList.addElement(valueNode);
    }

    public final ValueNode absFunction() throws ParseException, StandardException {
        this.jj_consume_token(420);
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        this.jj_consume_token(421);
        return (ValueNode)this.nodeFactory.getNode(188, valueNode, this.getContextManager());
    }

    public final ValueNode modFunction() throws ParseException, StandardException {
        this.jj_consume_token(420);
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        this.jj_consume_token(424);
        ValueNode valueNode2 = this.additiveExpression(null, 0, false);
        this.jj_consume_token(421);
        return (ValueNode)this.nodeFactory.getNode(194, valueNode, valueNode2, this.getContextManager());
    }

    public final int datetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 150: 
            case 176: 
            case 262: 
            case 277: 
            case 298: {
                int n = this.nonSecondDatetimeField();
                return n;
            }
            case 217: {
                this.jj_consume_token(217);
                return 5;
            }
        }
        this.jj_la1[121] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode characterValueFunction() throws ParseException, StandardException {
        ValueNode valueNode = null;
        Token token = null;
        Token token2 = null;
        ValueNode valueNode2 = null;
        switch (this.jj_nt.kind) {
            case 351: {
                this.jj_consume_token(351);
                this.jj_consume_token(420);
                valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode3 = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        valueNode2 = this.additiveExpression(null, 0, false);
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                return this.getSubstringNode(valueNode, valueNode3, valueNode2, Boolean.FALSE);
            }
            case 172: 
            case 248: {
                switch (this.jj_nt.kind) {
                    case 248: {
                        token = this.jj_consume_token(248);
                        break;
                    }
                    case 172: {
                        token2 = this.jj_consume_token(172);
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(420);
                valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(83, valueNode, token != null ? "upper" : "lower", this.getContextManager());
            }
            case 373: 
            case 411: {
                switch (this.jj_nt.kind) {
                    case 411: {
                        token = this.jj_consume_token(411);
                        break;
                    }
                    case 373: {
                        token2 = this.jj_consume_token(373);
                        break;
                    }
                    default: {
                        this.jj_la1[124] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(420);
                valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(83, valueNode, token != null ? "upper" : "lower", this.getContextManager());
            }
            case 241: 
            case 349: 
            case 350: {
                valueNode = this.trimFunction();
                return valueNode;
            }
            case 374: {
                this.jj_consume_token(374);
                this.jj_consume_token(420);
                ValueNode valueNode4 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode5 = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        valueNode = this.additiveExpression(null, 0, false);
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(190, valueNode4, valueNode5, valueNode == null ? this.getNodeFactory().getNode(70, ReuseFactory.getInteger(1), this.getContextManager()) : valueNode, ReuseFactory.getInteger(1), null, this.getContextManager());
            }
        }
        this.jj_la1[126] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode trimFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 349: 
            case 350: {
                Integer n = this.trimType();
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return this.getTrimOperatorNode(n, null, valueNode, null);
            }
            case 241: {
                this.jj_consume_token(241);
                ValueNode valueNode = this.ansiTrim();
                return valueNode;
            }
        }
        this.jj_la1[127] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode ansiTrim() throws ParseException, StandardException {
        Integer n = ReuseFactory.getInteger(0);
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        if (this.ansiTrimSpecFollows()) {
            this.jj_consume_token(420);
            n = this.ansiTrimSpec();
            if (this.jj_2_25(Integer.MAX_VALUE)) {
                this.jj_consume_token(140);
                valueNode2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
            }
            if (this.jj_2_26(1)) {
                valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(140);
                valueNode2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (!this.ansiTrimSpecFollows()) {
            this.jj_consume_token(420);
            valueNode = this.additiveExpression(null, 0, false);
            switch (this.jj_nt.kind) {
                case 140: {
                    this.jj_consume_token(140);
                    valueNode2 = this.additiveExpression(null, 0, false);
                    this.jj_consume_token(421);
                    return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
                }
                case 421: {
                    this.jj_consume_token(421);
                    return this.getTrimOperatorNode(n, null, valueNode, null);
                }
            }
            this.jj_la1[128] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer ansiTrimSpec() throws ParseException {
        switch (this.jj_nt.kind) {
            case 240: {
                this.jj_consume_token(240);
                return ReuseFactory.getInteger(1);
            }
            case 169: {
                this.jj_consume_token(169);
                return ReuseFactory.getInteger(2);
            }
            case 76: {
                this.jj_consume_token(76);
                return ReuseFactory.getInteger(0);
            }
        }
        this.jj_la1[129] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer trimType() throws ParseException {
        switch (this.jj_nt.kind) {
            case 350: {
                this.jj_consume_token(350);
                return ReuseFactory.getInteger(1);
            }
            case 349: {
                this.jj_consume_token(349);
                return ReuseFactory.getInteger(2);
            }
        }
        this.jj_la1[130] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode valueExpressionPrimary(boolean bl) throws ParseException, StandardException {
        if (this.escapedValueFunctionFollows()) {
            this.jj_consume_token(418);
            this.jj_consume_token(370);
            ValueNode valueNode = this.escapedValueFunction();
            this.jj_consume_token(419);
            return valueNode;
        }
        if (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404) {
            this.jj_consume_token(101);
            switch (this.jj_nt.kind) {
                case 215: {
                    this.jj_consume_token(215);
                    break;
                }
                case 404: {
                    this.jj_consume_token(404);
                    break;
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return (ValueNode)this.nodeFactory.getNode(6, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 165) {
            this.jj_consume_token(101);
            this.jj_consume_token(165);
            return (ValueNode)this.nodeFactory.getNode(4, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 80: 
            case 105: 
            case 133: 
            case 185: 
            case 219: 
            case 242: 
            case 249: 
            case 418: 
            case 423: 
            case 425: 
            case 438: 
            case 452: 
            case 455: 
            case 456: 
            case 457: {
                ValueNode valueNode = this.valueSpecification();
                return valueNode;
            }
        }
        this.jj_la1[132] = this.jj_gen;
        if (this.newInvocationFollows(1)) {
            JavaToSQLValueNode javaToSQLValueNode = this.newInvocation();
            return javaToSQLValueNode;
        }
        if (this.aggregateFollows()) {
            ValueNode valueNode = this.aggregateNode();
            return valueNode;
        }
        if (this.miscBuiltinFollows()) {
            ValueNode valueNode = this.miscBuiltins();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                ColumnReference columnReference = this.columnReference();
                return columnReference;
            }
            case 420: {
                ValueNode valueNode;
                this.jj_consume_token(420);
                if (this.getToken((int)1).kind == 218 || this.getToken((int)1).kind == 252) {
                    valueNode = this.subquery(17, null);
                } else if (bl) {
                    valueNode = this.additiveExpression(null, 0, bl);
                } else if (this.jj_2_27(1)) {
                    valueNode = this.valueExpression(bl);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(421);
                return valueNode;
            }
            case 81: {
                ValueNode valueNode = this.castSpecification();
                return valueNode;
            }
        }
        this.jj_la1[133] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltins() throws ParseException, StandardException {
        if ((this.getToken((int)1).kind == 345 || this.getToken((int)1).kind == 263 || this.getToken((int)1).kind == 264 || this.getToken((int)1).kind == 406 || this.getToken((int)1).kind == 295 || this.getToken((int)1).kind == 87 || this.getToken((int)1).kind == 251 || this.getToken((int)1).kind == 282 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 172 || this.getToken((int)1).kind == 411 || this.getToken((int)1).kind == 373 || this.getToken((int)1).kind == 349 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 241 || this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332 || this.getToken((int)1).kind == 121 || this.getToken((int)1).kind == 82 || this.getToken((int)1).kind == 254 || this.getToken((int)1).kind == 161 || this.getToken((int)1).kind == 160 || this.getToken((int)1).kind == 221 || this.getToken((int)1).kind == 347 || this.getToken((int)1).kind == 262 || this.getToken((int)1).kind == 298 || this.getToken((int)1).kind == 277 || this.getToken((int)1).kind == 150 || this.getToken((int)1).kind == 176 || this.getToken((int)1).kind == 217 || this.getToken((int)1).kind == 290 || this.getToken((int)1).kind == 374 || this.getToken((int)1).kind == 354 || this.getToken((int)1).kind == 356 || this.getToken((int)1).kind == 353 || this.getToken((int)1).kind == 355) && this.getToken((int)2).kind == 420) {
            ValueNode valueNode = this.miscBuiltinsCore(false);
            return valueNode;
        }
        if (this.jj_2_28(1)) {
            ValueNode valueNode = this.datetimeValueFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                ValueNode valueNode = this.routineInvocation();
                return valueNode;
            }
        }
        this.jj_la1[134] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltinsCore(boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 345: {
                this.jj_consume_token(345);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                this.checkInternalFeature("GETCURRENTCONNECTION()");
                return (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(18, this.getContextManager()), this.getContextManager());
            }
            case 263: 
            case 264: 
            case 282: 
            case 295: 
            case 406: {
                ValueNode valueNode = this.numericValueFunction();
                return valueNode;
            }
            case 172: 
            case 241: 
            case 248: 
            case 349: 
            case 350: 
            case 351: 
            case 373: 
            case 374: 
            case 411: {
                ValueNode valueNode = this.characterValueFunction();
                return valueNode;
            }
        }
        this.jj_la1[135] = this.jj_gen;
        if (this.jj_2_29(1)) {
            ValueNode valueNode = this.dataTypeScalarFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 87: {
                this.jj_consume_token(87);
                ValueNode valueNode = this.coalesceFunction("COALESCE");
                return valueNode;
            }
            case 251: {
                this.jj_consume_token(251);
                ValueNode valueNode = this.coalesceFunction("VALUE");
                return valueNode;
            }
            case 290: {
                this.jj_consume_token(290);
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                ContextManager contextManager = this.getContextManager();
                if (bl) {
                    return (ValueNode)this.nodeFactory.getNode(23, this.getTrimOperatorNode(ReuseFactory.getInteger(1), null, valueNode, contextManager), contextManager);
                }
                return (ValueNode)this.nodeFactory.getNode(20, valueNode, contextManager);
            }
            case 353: 
            case 354: 
            case 355: 
            case 356: {
                ValueNode valueNode = this.xmlFunction();
                return valueNode;
            }
        }
        this.jj_la1[136] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dataTypeScalarFunction() throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 150: 
            case 176: 
            case 217: 
            case 262: 
            case 276: 
            case 277: 
            case 298: 
            case 331: 
            case 332: {
                ValueNode valueNode = this.dateTimeScalarFunction();
                return valueNode;
            }
        }
        this.jj_la1[138] = this.jj_gen;
        if (this.jj_2_30(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.numericFunctionType();
            this.jj_consume_token(420);
            ValueNode valueNode = this.additiveExpression(null, 0, false);
            this.jj_consume_token(421);
            ValueNode valueNode2 = (ValueNode)this.nodeFactory.getNode(60, valueNode, dataTypeDescriptor, this.getContextManager());
            ((CastNode)valueNode2).setForDataTypeFunction(true);
            ((CastNode)valueNode2).setForExternallyGeneratedCASTnode();
            return valueNode2;
        }
        switch (this.jj_nt.kind) {
            case 82: 
            case 254: {
                int n2 = this.charOrVarchar();
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        n = this.length();
                        break;
                    }
                    default: {
                        this.jj_la1[137] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                this.checkTypeLimits(n2, n);
                ValueNode valueNode3 = (ValueNode)this.nodeFactory.getNode(60, valueNode, new Integer(n2), new Integer(n), this.getContextManager());
                ((CastNode)valueNode3).setForDataTypeFunction(true);
                ((CastNode)valueNode3).setForExternallyGeneratedCASTnode();
                return valueNode3;
            }
        }
        this.jj_la1[139] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlFunction() throws ParseException, StandardException {
        this.checkVersion(130, "XML");
        XML.checkXMLRequirements();
        switch (this.jj_nt.kind) {
            case 354: {
                this.jj_consume_token(354);
                this.jj_consume_token(420);
                this.xmlDocOrContent();
                ValueNode valueNode = this.xmlParseValue();
                this.jj_consume_token(421);
                return valueNode;
            }
            case 356: {
                this.jj_consume_token(356);
                this.jj_consume_token(420);
                ValueNode valueNode = this.xmlSerializeValue();
                this.jj_consume_token(421);
                return valueNode;
            }
            case 353: {
                this.jj_consume_token(353);
                this.jj_consume_token(420);
                ValueNode valueNode = this.xmlQueryValue(true);
                this.jj_consume_token(421);
                return valueNode;
            }
            case 355: {
                this.jj_consume_token(355);
                this.jj_consume_token(420);
                ValueNode valueNode = this.xmlQueryValue(false);
                this.jj_consume_token(421);
                return valueNode;
            }
        }
        this.jj_la1[140] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlParseValue() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        boolean bl = this.xmlPreserveWhitespace();
        return (ValueNode)this.nodeFactory.getNode(200, valueNode, ReuseFactory.getInteger(0), new Object[]{bl ? Boolean.TRUE : Boolean.FALSE}, this.getContextManager());
    }

    public final boolean xmlPreserveWhitespace() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 408 && this.getToken((int)1).kind != 200) {
            throw StandardException.newException("42Z72", (Object)"PRESERVE WHITESPACE", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 408: {
                this.jj_consume_token(408);
                this.jj_consume_token(413);
                throw StandardException.newException("42Z74", "STRIP WHITESPACE");
            }
            case 200: {
                this.jj_consume_token(200);
                this.jj_consume_token(413);
                return true;
            }
        }
        this.jj_la1[141] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlSerializeValue() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        DataTypeDescriptor dataTypeDescriptor = this.xmlSerializeTargetType();
        return (ValueNode)this.nodeFactory.getNode(201, valueNode, ReuseFactory.getInteger(1), new Object[]{dataTypeDescriptor}, this.getContextManager());
    }

    public final DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 66) {
            throw StandardException.newException("42Z72", (Object)"AS", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[142] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlQueryValue(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        int n = -1;
        valueNode = this.additiveExpression(null, 0, false);
        this.jj_consume_token(388);
        n = this.xmlPassingMechanism();
        valueNode2 = this.xqVarList();
        if (!bl) {
            if (this.jj_2_32(1)) {
                this.xqReturningClause();
                if (this.jj_2_31(1)) {
                    this.xmlPassingMechanism();
                }
            }
            this.xqEmptyHandlingClause();
        } else if (!bl) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        ValueNode valueNode3 = (ValueNode)this.nodeFactory.getNode(bl ? 202 : 203, valueNode, valueNode2, bl ? ReuseFactory.getInteger(0) : ReuseFactory.getInteger(1), this.getContextManager());
        return valueNode3;
    }

    public final ValueNode xqVarList() throws ParseException, StandardException {
        ValueNode[] valueNodeArray = new ValueNode[]{null};
        this.xqVariable(valueNodeArray);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[143] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.xqVariable(valueNodeArray);
        }
        return valueNodeArray[0];
    }

    public final void xqVariable(ValueNode[] valueNodeArray) throws ParseException, StandardException {
        String string = null;
        int n = -1;
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        if (this.getToken((int)1).kind == 66) {
            this.jj_consume_token(66);
            string = this.identifier(128, true);
            throw StandardException.newException("42Z74", "PASSING ... AS");
        }
        if (this.jj_2_33(1)) {
            n = this.xmlPassingMechanism();
        }
        if (string == null) {
            if (valueNodeArray[0] != null) {
                throw StandardException.newException("42Z76");
            }
            valueNodeArray[0] = valueNode;
        }
    }

    public final short xmlPassingMechanism() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 391) {
            this.jj_consume_token(77);
            this.jj_consume_token(391);
            return 1;
        }
        switch (this.jj_nt.kind) {
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(251);
                throw StandardException.newException("42Z74", "BY VALUE");
            }
        }
        this.jj_la1[144] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqReturningClause() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 400) {
            this.jj_consume_token(397);
            this.jj_consume_token(400);
            return 3;
        }
        switch (this.jj_nt.kind) {
            case 397: {
                this.jj_consume_token(397);
                this.jj_consume_token(361);
                throw StandardException.newException("42Z74", "RETURNING CONTENT");
            }
        }
        this.jj_la1[145] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqEmptyHandlingClause() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 368) {
            this.jj_consume_token(368);
            this.jj_consume_token(188);
            this.jj_consume_token(368);
            return 5;
        }
        switch (this.jj_nt.kind) {
            case 184: {
                this.jj_consume_token(184);
                this.jj_consume_token(188);
                this.jj_consume_token(368);
                throw StandardException.newException("42Z74", "NULL ON EMPTY");
            }
        }
        this.jj_la1[146] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {
        if (this.jj_2_34(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.doubleType();
            return dataTypeDescriptor;
        }
        switch (this.jj_nt.kind) {
            case 160: 
            case 161: 
            case 221: 
            case 347: {
                DataTypeDescriptor dataTypeDescriptor = this.exactIntegerType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeScalarFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 331: {
                this.jj_consume_token(331);
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                ValueNode valueNode2 = (ValueNode)this.nodeFactory.getNode(60, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(92), this.getContextManager());
                ((CastNode)valueNode2).setForExternallyGeneratedCASTnode();
                return valueNode2;
            }
            case 276: {
                this.jj_consume_token(276);
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(32, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(91), this.getContextManager());
            }
            case 332: {
                this.jj_consume_token(332);
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                ValueNode valueNode3 = this.timestampFunctionCompletion(valueNode);
                return valueNode3;
            }
            case 150: 
            case 176: 
            case 217: 
            case 262: 
            case 277: 
            case 298: {
                int n = this.datetimeField();
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(87, ReuseFactory.getInteger(n), valueNode, this.getContextManager());
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode timestampFunctionCompletion(ValueNode valueNode) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 421: {
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(32, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(93), this.getContextManager());
            }
            case 424: {
                this.jj_consume_token(424);
                ValueNode valueNode2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(33, valueNode, valueNode2, this.getContextManager());
            }
        }
        this.jj_la1[149] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token booleanLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 242: {
                Token token = this.jj_consume_token(242);
                return token;
            }
            case 133: {
                Token token = this.jj_consume_token(133);
                return token;
            }
        }
        this.jj_la1[150] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generalValueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 438: {
                ParameterNode parameterNode = this.dynamicParameterSpecification();
                return parameterNode;
            }
            case 105: 
            case 219: 
            case 249: {
                ValueNode valueNode = this.userNode();
                return valueNode;
            }
        }
        this.jj_la1[151] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode userNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 249: {
                this.jj_consume_token(249);
                return (ValueNode)this.nodeFactory.getNode(110, this.getContextManager());
            }
            case 105: {
                this.jj_consume_token(105);
                return (ValueNode)this.nodeFactory.getNode(109, this.getContextManager());
            }
            case 219: {
                this.jj_consume_token(219);
                return (ValueNode)this.nodeFactory.getNode(125, this.getContextManager());
            }
        }
        this.jj_la1[152] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JavaToSQLValueNode newInvocation() throws ParseException, StandardException {
        Vector vector = new Vector();
        this.jj_consume_token(379);
        String string = this.javaClassName();
        this.methodCallParameterList(vector);
        if (!(string.startsWith("org.apache.derby.diag.") || string.startsWith("org.apache.derby.catalog.") || string.startsWith("com.ibm.db2j."))) {
            this.checkInternalFeature(string);
        }
        QueryTreeNode queryTreeNode = this.nodeFactory.getNode(133, string, vector, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return (JavaToSQLValueNode)this.nodeFactory.getNode(36, queryTreeNode, this.getContextManager());
    }

    public final JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {
        QueryTreeNode queryTreeNode = null;
        Vector vector = new Vector();
        TableName tableName = null;
        this.jj_consume_token(232);
        this.jj_consume_token(420);
        tableName = this.qualifiedName(128);
        this.methodCallParameterList(vector);
        this.jj_consume_token(421);
        queryTreeNode = this.nodeFactory.getNode(133, tableName, null, vector, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return (JavaToSQLValueNode)this.nodeFactory.getNode(36, queryTreeNode, this.getContextManager());
    }

    public final ValueNode staticMethodInvocation(String string) throws ParseException, StandardException {
        Vector vector = new Vector();
        MethodCallNode methodCallNode = this.staticMethodName(string);
        this.methodCallParameterList(vector);
        methodCallNode.addParms(vector);
        return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final void methodCallParameterList(Vector vector) throws ParseException, StandardException {
        this.jj_consume_token(420);
        if (this.jj_2_35(1)) {
            this.methodParameter(vector);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[153] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                this.methodParameter(vector);
            }
        }
        this.jj_consume_token(421);
    }

    public final ValueNode routineInvocation() throws ParseException, StandardException {
        Vector vector = new Vector();
        TableName tableName = this.qualifiedName(128);
        this.methodCallParameterList(vector);
        MethodCallNode methodCallNode = (MethodCallNode)this.nodeFactory.getNode(85, tableName, null, this.getContextManager());
        methodCallNode.addParms(vector);
        return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final String javaClass() throws ParseException, StandardException {
        String string = this.javaClassName();
        return string;
    }

    public final ValueNode columnMethodInvocation() throws ParseException, StandardException {
        ValueNode valueNode = this.columnNameForInvocation();
        ValueNode valueNode2 = this.nonStaticMethodInvocation(valueNode);
        return valueNode2;
    }

    public final ValueNode columnNameForInvocation() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TableName tableName = null;
        String string6 = this.identifier(128, true);
        if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind == 426) {
            this.jj_consume_token(426);
            string = this.identifier(128, true);
            if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind == 426) {
                this.jj_consume_token(426);
                string2 = this.identifier(128, true);
            }
        }
        if (string2 == null) {
            if (string == null) {
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string;
            }
        } else {
            string5 = string6;
            string4 = string;
            string3 = string2;
        }
        if (string4 != null) {
            tableName = (TableName)this.nodeFactory.getNode(34, string5, string4, new Integer(this.nextToLastIdentifierToken.beginOffset), new Integer(this.nextToLastIdentifierToken.endOffset), this.getContextManager());
        }
        ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(62, string3, tableName, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
        return valueNode;
    }

    public final ColumnReference columnReference() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TableName tableName = null;
        String string6 = this.identifier(128, false);
        if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind != 420) {
            this.jj_consume_token(426);
            string = this.identifier(128, false);
            if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind != 420) {
                this.jj_consume_token(426);
                string2 = this.identifier(128, false);
            }
        }
        if (string2 == null) {
            if (string == null) {
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string;
            }
        } else {
            string5 = string6;
            string4 = string;
            string3 = string2;
        }
        this.checkIdentifierLengthLimit(string3, 128);
        if (string5 != null) {
            this.checkIdentifierLengthLimit(string5, 128);
        }
        if (string4 != null) {
            this.checkIdentifierLengthLimit(string4, 128);
        }
        if (string4 != null) {
            tableName = (TableName)this.nodeFactory.getNode(34, string5, string4, new Integer(this.nextToLastIdentifierToken.beginOffset), new Integer(this.nextToLastIdentifierToken.endOffset), this.getContextManager());
        }
        return (ColumnReference)this.nodeFactory.getNode(62, string3, tableName, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
    }

    public final OrderByList orderByClause() throws ParseException, StandardException {
        this.jj_consume_token(193);
        this.jj_consume_token(77);
        OrderByList orderByList = this.sortSpecificationList();
        return orderByList;
    }

    public final int atIsolationLevel() throws ParseException, StandardException {
        this.jj_consume_token(259);
        int n = this.isolationLevelDB2Abbrev();
        return n;
    }

    public final OrderByList sortSpecificationList() throws ParseException, StandardException {
        OrderByList orderByList = (OrderByList)this.nodeFactory.getNode(7, this.getContextManager());
        this.sortSpecification(orderByList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.sortSpecification(orderByList);
        }
        return orderByList;
    }

    public final void sortSpecification(OrderByList orderByList) throws ParseException, StandardException {
        OrderByColumn orderByColumn = this.sortKey();
        switch (this.jj_nt.kind) {
            case 67: 
            case 116: {
                this.orderingSpecification(orderByColumn);
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
            }
        }
        orderByList.addOrderByColumn(orderByColumn);
    }

    public final OrderByColumn sortKey() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, true);
        return (OrderByColumn)this.nodeFactory.getNode(104, valueNode, this.getContextManager());
    }

    public final void orderingSpecification(OrderByColumn orderByColumn) throws ParseException {
        switch (this.jj_nt.kind) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                orderByColumn.setDescending();
                break;
            }
            default: {
                this.jj_la1[156] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int forUpdateClause(Vector vector) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 247: {
                this.jj_consume_token(247);
                switch (this.jj_nt.kind) {
                    case 187: {
                        this.jj_consume_token(187);
                        this.forUpdateColumnList(vector);
                        break;
                    }
                    default: {
                        this.jj_la1[157] = this.jj_gen;
                    }
                }
                return 2;
            }
            case 206: {
                this.jj_consume_token(206);
                this.jj_consume_token(189);
                return 1;
            }
            case 134: {
                this.jj_consume_token(134);
                this.jj_consume_token(189);
                return 1;
            }
        }
        this.jj_la1[158] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void forUpdateColumnList(Vector vector) throws ParseException, StandardException {
        this.forUpdateColumn(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[159] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.forUpdateColumn(vector);
        }
    }

    public final void forUpdateColumn(Vector vector) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        vector.addElement(string);
    }

    public final ResultColumnList setClauseList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.setClause(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[160] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.setClause(resultColumnList);
        }
        return resultColumnList;
    }

    public final void setClause(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ColumnReference columnReference = this.columnReference();
        this.jj_consume_token(433);
        ValueNode valueNode = this.updateSource(columnReference.getColumnName());
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnReference, valueNode, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final ValueNode updateSource(String string) throws ParseException, StandardException {
        if (this.jj_2_36(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0, false);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 184: {
                ValueNode valueNode = this.nullSpecification();
                return valueNode;
            }
            case 112: {
                this.jj_consume_token(112);
                return (ValueNode)this.nodeFactory.getNode(100, string, this.getContextManager());
            }
        }
        this.jj_la1[161] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode nullSpecification() throws ParseException, StandardException {
        this.jj_consume_token(184);
        return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
    }

    public final StatementNode insertColumnsAndSource(QueryTreeNode queryTreeNode) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        if (this.getToken((int)1).kind == 420 && !this.subqueryFollows()) {
            this.jj_consume_token(420);
            resultColumnList = this.insertColumnList();
            this.jj_consume_token(421);
        }
        switch (this.jj_nt.kind) {
            case 53: {
                properties = this.propertyList(false);
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
            }
        }
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        return (StatementNode)this.nodeFactory.getNode(138, queryTreeNode, resultColumnList, resultSetNode, properties, this.getContextManager());
    }

    public final ResultColumnList insertColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnQualifiedNameList(resultColumnList);
        return resultColumnList;
    }

    public final void columnQualifiedNameList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.columnQualifiedNameItem(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[163] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.columnQualifiedNameItem(resultColumnList);
        }
    }

    public final void columnQualifiedNameItem(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ColumnReference columnReference = this.columnReference();
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnReference, null, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final ResultSetNode rowValueConstructor(ResultSetNode resultSetNode) throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        if (this.rowValueConstructorListFollows()) {
            this.jj_consume_token(420);
            this.rowValueConstructorList(resultColumnList);
            this.jj_consume_token(421);
            ResultSetNode resultSetNode2 = (ResultSetNode)this.nodeFactory.getNode(105, resultColumnList, null, this.getContextManager());
            if (resultSetNode != null) {
                if (resultSetNode.getResultColumns().size() != resultSetNode2.getResultColumns().size()) {
                    throw StandardException.newException("42X59");
                }
                resultSetNode2 = (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode2, Boolean.TRUE, Boolean.TRUE, null, this.getContextManager());
            }
            return resultSetNode2;
        }
        this.rowValueConstructorElement(resultColumnList);
        ResultSetNode resultSetNode3 = (ResultSetNode)this.nodeFactory.getNode(105, resultColumnList, null, this.getContextManager());
        if (resultSetNode != null) {
            if (resultSetNode.getResultColumns().size() != resultSetNode3.getResultColumns().size()) {
                throw StandardException.newException("42X59");
            }
            resultSetNode3 = (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode3, Boolean.TRUE, Boolean.TRUE, null, this.getContextManager());
        }
        return resultSetNode3;
    }

    public final void rowValueConstructorElement(ResultColumnList resultColumnList) throws ParseException, StandardException {
        if (this.jj_2_37(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0, true);
            resultColumnList.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, valueNode, this.getContextManager()));
        } else {
            switch (this.jj_nt.kind) {
                case 184: {
                    ValueNode valueNode = this.nullSpecification();
                    resultColumnList.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, valueNode, this.getContextManager()));
                    break;
                }
                case 112: {
                    this.jj_consume_token(112);
                    resultColumnList.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, (ValueNode)this.nodeFactory.getNode(100, null, this.getContextManager()), this.getContextManager()));
                    break;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    throw StandardException.newException("42X80");
                }
            }
        }
    }

    public final void rowValueConstructorList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.rowValueConstructorElement(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.rowValueConstructorElement(resultColumnList);
        }
    }

    public final SubqueryNode tableSubquery(int n, ValueNode valueNode) throws ParseException, StandardException {
        SubqueryNode subqueryNode = this.subquery(n, valueNode);
        return subqueryNode;
    }

    public final SubqueryNode subquery(int n, ValueNode valueNode) throws ParseException, StandardException {
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        SubqueryNode subqueryNode = (SubqueryNode)this.nodeFactory.getNode(93, resultSetNode, ReuseFactory.getInteger(n), valueNode, this.getContextManager());
        return subqueryNode;
    }

    public final ValueNode inPredicateValue(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2;
        this.jj_consume_token(420);
        if (this.subqueryFollows()) {
            valueNode2 = this.tableSubquery(1, valueNode);
        } else if (this.jj_2_38(1)) {
            valueNode2 = this.inValueList(valueNode);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(421);
        return valueNode2;
    }

    public final ValueNode inValueList(ValueNode valueNode) throws ParseException, StandardException {
        ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
        this.inElement(valueNodeList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[166] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.inElement(valueNodeList);
        }
        return (ValueNode)this.nodeFactory.getNode(55, valueNode, valueNodeList, this.getContextManager());
    }

    public final void inElement(ValueNodeList valueNodeList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        valueNodeList.addElement(valueNode);
    }

    public final int quantifier(int n) throws ParseException, StandardException {
        int n2 = 0;
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                switch (n) {
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        n2 = 6;
                        break;
                    }
                    case 11: {
                        n2 = 14;
                        break;
                    }
                    case 10: {
                        n2 = 12;
                        break;
                    }
                    case 9: {
                        n2 = 10;
                        break;
                    }
                    case 8: {
                        n2 = 8;
                        break;
                    }
                }
                return n2;
            }
            case 64: 
            case 222: {
                this.some();
                switch (n) {
                    case 6: {
                        n2 = 3;
                        break;
                    }
                    case 7: {
                        n2 = 5;
                        break;
                    }
                    case 11: {
                        n2 = 13;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    case 9: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 7;
                        break;
                    }
                }
                return n2;
            }
        }
        this.jj_la1[167] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void some() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 222: {
                this.jj_consume_token(222);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[168] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SubqueryNode existsExpression() throws ParseException, StandardException {
        this.jj_consume_token(131);
        this.jj_consume_token(420);
        SubqueryNode subqueryNode = this.tableSubquery(15, null);
        this.jj_consume_token(421);
        return subqueryNode;
    }

    public final SelectNode tableExpression(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ValueNode valueNode = null;
        GroupByList groupByList = null;
        ValueNode valueNode2 = null;
        FromList fromList = this.fromClause();
        switch (this.jj_nt.kind) {
            case 258: {
                Token token = this.jj_consume_token(258);
                valueNode = this.whereClause(token);
                break;
            }
            default: {
                this.jj_la1[169] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 148: {
                groupByList = this.groupByClause();
                break;
            }
            default: {
                this.jj_la1[170] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 149: {
                valueNode2 = this.havingClause();
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
            }
        }
        if (valueNode2 != null && groupByList == null) {
            ValueNode valueNode3 = (ValueNode)this.nodeFactory.getNode(115, null, CountAggregateDefinition.class, Boolean.FALSE, "COUNT(*)", this.getContextManager());
            AggregateNode aggregateNode = (AggregateNode)valueNode3;
            aggregateNode.replaceAggregatesWithColumnReferences(resultColumnList, 0);
        }
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, resultColumnList, null, fromList, valueNode, groupByList, valueNode2, this.getContextManager());
        return selectNode;
    }

    public final FromList fromClause() throws ParseException, StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.jj_consume_token(140);
        Token token = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 53: {
                this.fromListProperties(fromList);
                break;
            }
            default: {
                this.jj_la1[172] = this.jj_gen;
            }
        }
        this.dummyTableReferenceRule(fromList);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[173] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(424);
            this.dummyTableReferenceRule(fromList);
        }
        Token token2 = this.getToken(0);
        fromList.setBeginOffset(token.beginOffset);
        fromList.setEndOffset(token2.endOffset);
        return fromList;
    }

    public final void fromListProperties(FromList fromList) throws ParseException, StandardException {
        Properties properties = this.propertyList(true);
        this.jj_consume_token(58);
        fromList.setProperties(properties);
    }

    public final void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 232 && this.getToken((int)2).kind == 420 && (this.getToken((int)3).kind == 218 || this.getToken((int)3).kind == 252)) {
            this.jj_consume_token(232);
            FromTable fromTable = this.tableReferenceTypes(false);
            fromList.addFromTable(fromTable);
        } else if (this.jj_2_39(1)) {
            FromTable fromTable = this.tableReferenceTypes(false);
            fromList.addFromTable(fromTable);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final FromTable tableReferenceTypes(boolean bl) throws ParseException, StandardException {
        if (this.jj_2_40(1)) {
            FromTable fromTable = this.tableReference(bl);
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 418: {
                this.jj_consume_token(418);
                this.jj_consume_token(382);
                FromTable fromTable = this.tableReference(bl);
                this.jj_consume_token(419);
                return fromTable;
            }
        }
        this.jj_la1[174] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] optionalTableClauses() throws ParseException, StandardException {
        Object[] objectArray = null;
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        String string = null;
        switch (this.jj_nt.kind) {
            case 53: {
                objectArray = this.optionalTableProperties();
                objectArray[1] = resultColumnList;
                objectArray[2] = string;
                return objectArray;
            }
        }
        this.jj_la1[179] = this.jj_gen;
        block3 : switch (this.jj_nt.kind) {
            case 66: 
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                switch (this.jj_nt.kind) {
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    default: {
                        this.jj_la1[175] = this.jj_gen;
                    }
                }
                string = this.identifier(128, true);
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        resultColumnList = this.derivedColumnList();
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[176] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(true);
                        this.jj_consume_token(58);
                        break block3;
                    }
                }
                this.jj_la1[177] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
            }
        }
        objectArray = new Object[]{properties, resultColumnList, string};
        return objectArray;
    }

    public final Object[] optionalTableProperties() throws ParseException, StandardException {
        Object[] objectArray = null;
        Properties properties = null;
        properties = this.propertyList(true);
        this.jj_consume_token(58);
        objectArray = new Object[3];
        objectArray[0] = properties;
        return objectArray;
    }

    public final FromTable tableReference(boolean bl) throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        ResultColumnList resultColumnList = null;
        TableOperatorNode tableOperatorNode = null;
        Object[] objectArray = new Object[3];
        Object var10_7 = null;
        if (this.jj_2_41(1)) {
            if (this.newInvocationFollows(1)) {
                javaToSQLValueNode = this.newInvocation();
            } else {
                switch (this.jj_nt.kind) {
                    case 232: {
                        javaToSQLValueNode = this.vtiTableConstruct();
                        break;
                    }
                    default: {
                        this.jj_la1[180] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_nt.kind) {
                case 66: {
                    this.jj_consume_token(66);
                    break;
                }
                default: {
                    this.jj_la1[181] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 420: {
                    this.jj_consume_token(420);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(421);
                    break;
                }
                default: {
                    this.jj_la1[182] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 53: {
                    objectArray = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[183] = this.jj_gen;
                }
            }
            while (this.joinedTableExpressionFollows()) {
                tableOperatorNode = this.joinedTableExpression(tableOperatorNode != null ? tableOperatorNode : (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager()), bl);
            }
            FromTable fromTable = tableOperatorNode == null ? (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager()) : tableOperatorNode;
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                TableName tableName = this.qualifiedName(128);
                objectArray = this.optionalTableClauses();
                while (this.joinedTableExpressionFollows()) {
                    tableOperatorNode = this.joinedTableExpression(tableOperatorNode != null ? tableOperatorNode : (FromTable)this.nodeFactory.getNode(135, tableName, (String)objectArray[2], (ResultColumnList)objectArray[1], (Properties)objectArray[0], this.getContextManager()), bl);
                }
                FromTable fromTable = tableOperatorNode == null ? (FromTable)this.nodeFactory.getNode(135, tableName, (String)objectArray[2], (ResultColumnList)objectArray[1], (Properties)objectArray[0], this.getContextManager()) : tableOperatorNode;
                return fromTable;
            }
        }
        this.jj_la1[187] = this.jj_gen;
        if (this.getToken((int)1).kind == 420 && (this.getToken((int)2).kind == 218 || this.getToken((int)2).kind == 252)) {
            ResultSetNode resultSetNode = this.derivedTable();
            switch (this.jj_nt.kind) {
                case 66: {
                    this.jj_consume_token(66);
                    break;
                }
                default: {
                    this.jj_la1[184] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 420: {
                    this.jj_consume_token(420);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(421);
                    break;
                }
                default: {
                    this.jj_la1[185] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 53: {
                    objectArray = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[186] = this.jj_gen;
                }
            }
            while (this.joinedTableExpressionFollows()) {
                tableOperatorNode = this.joinedTableExpression(tableOperatorNode != null ? tableOperatorNode : (FromTable)this.nodeFactory.getNode(136, resultSetNode, string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager()), bl);
            }
            FromTable fromTable = tableOperatorNode == null ? (FromTable)this.nodeFactory.getNode(136, resultSetNode, string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager()) : tableOperatorNode;
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                FromTable fromTable = this.tableReferenceTypes(true);
                this.jj_consume_token(421);
                while (this.joinedTableExpressionFollows()) {
                    tableOperatorNode = this.joinedTableExpression(tableOperatorNode != null ? tableOperatorNode : fromTable, bl);
                }
                FromTable fromTable2 = tableOperatorNode == null ? fromTable : tableOperatorNode;
                return fromTable2;
            }
        }
        this.jj_la1[188] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList derivedColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final void columnNameList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.columnNameItem(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[189] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.columnNameItem(resultColumnList);
        }
    }

    public final void columnNameItem(ResultColumnList resultColumnList) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final void indexColumnList(Vector vector) throws ParseException, StandardException {
        this.indexColumnItem(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[190] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.indexColumnItem(vector);
        }
    }

    public final void indexColumnItem(Vector vector) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        block0 : switch (this.jj_nt.kind) {
            case 67: 
            case 116: {
                switch (this.jj_nt.kind) {
                    case 67: {
                        this.jj_consume_token(67);
                        break block0;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        string = string + ' ';
                        break block0;
                    }
                }
                this.jj_la1[191] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[192] = this.jj_gen;
            }
        }
        vector.addElement(string);
    }

    public final ResultSetNode derivedTable() throws ParseException, StandardException {
        this.jj_consume_token(420);
        SubqueryNode subqueryNode = this.tableSubquery(0, null);
        this.jj_consume_token(421);
        return subqueryNode.getResultSet();
    }

    public final TableOperatorNode joinedTableExpression(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        TableOperatorNode tableOperatorNode = this.qualifiedJoin(resultSetNode, bl);
        return tableOperatorNode;
    }

    public final TableOperatorNode qualifiedJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        int n = 1;
        TableOperatorNode tableOperatorNode = null;
        Object[] objectArray = null;
        ResultColumnList resultColumnList = null;
        switch (this.jj_nt.kind) {
            case 156: 
            case 170: 
            case 212: {
                n = this.joinType();
                break;
            }
            default: {
                this.jj_la1[193] = this.jj_gen;
            }
        }
        this.jj_consume_token(166);
        FromTable fromTable = this.tableReferenceTypes(bl);
        objectArray = this.joinSpecification(resultSetNode, fromTable);
        ValueNode valueNode = (ValueNode)objectArray[0];
        resultColumnList = (ResultColumnList)objectArray[1];
        if (valueNode == null && resultColumnList == null) {
            throw StandardException.newException("42Y11", JoinNode.joinTypeToString(n));
        }
        switch (n) {
            case 1: {
                tableOperatorNode = (TableOperatorNode)this.nodeFactory.getNode(139, resultSetNode, fromTable, valueNode, resultColumnList, null, null, null, this.getContextManager());
                break;
            }
            case 3: {
                tableOperatorNode = (TableOperatorNode)this.nodeFactory.getNode(144, resultSetNode, fromTable, valueNode, resultColumnList, Boolean.FALSE, null, this.getContextManager());
                break;
            }
            case 4: {
                tableOperatorNode = (TableOperatorNode)this.nodeFactory.getNode(144, resultSetNode, fromTable, valueNode, resultColumnList, Boolean.TRUE, null, this.getContextManager());
                break;
            }
            default: {
                return null;
            }
        }
        tableOperatorNode.setNestedInParens(bl);
        return tableOperatorNode;
    }

    public final int joinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 156: {
                this.jj_consume_token(156);
                return 1;
            }
            case 170: 
            case 212: {
                int n = this.outerJoinType();
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        break;
                    }
                    default: {
                        this.jj_la1[194] = this.jj_gen;
                    }
                }
                return n;
            }
        }
        this.jj_la1[195] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int outerJoinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 170: {
                this.jj_consume_token(170);
                return 3;
            }
            case 212: {
                this.jj_consume_token(212);
                return 4;
            }
        }
        this.jj_la1[196] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] joinSpecification(ResultSetNode resultSetNode, ResultSetNode resultSetNode2) throws ParseException, StandardException {
        Object[] objectArray = new Object[2];
        Object var4_4 = null;
        ValueNode valueNode = null;
        valueNode = this.joinCondition();
        objectArray[0] = valueNode;
        objectArray[1] = var4_4;
        return objectArray;
    }

    public final ValueNode joinCondition() throws ParseException, StandardException {
        this.jj_consume_token(188);
        ValueNode valueNode = this.valueExpression(false);
        return valueNode;
    }

    public final ResultSetNode tableValueConstructor() throws ParseException, StandardException {
        this.jj_consume_token(252);
        ResultSetNode resultSetNode = this.tableValueConstructorList();
        return resultSetNode;
    }

    public final ResultSetNode tableValueConstructorList() throws ParseException, StandardException {
        ResultSetNode resultSetNode = this.rowValueConstructor(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            resultSetNode = this.rowValueConstructor(resultSetNode);
        }
        if (resultSetNode instanceof UnionNode) {
            ((UnionNode)resultSetNode).markTopTableConstructor();
        }
        return resultSetNode;
    }

    public final ValueNode datetimeValueFunction() throws ParseException, StandardException {
        int n = -1;
        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 276) {
            this.jj_consume_token(101);
            this.jj_consume_token(276);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 102: {
                this.jj_consume_token(102);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
            }
        }
        this.jj_la1[198] = this.jj_gen;
        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 331) {
            this.jj_consume_token(101);
            this.jj_consume_token(331);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 103: {
                this.jj_consume_token(103);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
            }
        }
        this.jj_la1[199] = this.jj_gen;
        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 332) {
            this.jj_consume_token(101);
            this.jj_consume_token(332);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(2), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 104: {
                this.jj_consume_token(104);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(2), this.getContextManager());
            }
        }
        this.jj_la1[200] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode aggregateNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 99: {
                ValueNode valueNode;
                this.jj_consume_token(99);
                this.jj_consume_token(420);
                switch (this.jj_nt.kind) {
                    case 422: {
                        this.jj_consume_token(422);
                        valueNode = (ValueNode)this.nodeFactory.getNode(115, null, CountAggregateDefinition.class, Boolean.FALSE, "COUNT(*)", this.getContextManager());
                        break;
                    }
                    default: {
                        this.jj_la1[201] = this.jj_gen;
                        if (this.jj_2_42(1)) {
                            valueNode = this.aggregateExpression("COUNT", CountAggregateDefinition.class);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(421);
                return valueNode;
            }
            case 71: 
            case 174: 
            case 175: 
            case 229: {
                ValueNode valueNode = this.generalAggregate();
                return valueNode;
            }
        }
        this.jj_la1[202] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode aggregateExpression(String string, Class clazz) throws ParseException, StandardException {
        boolean bl = false;
        if (this.jj_2_43(1)) {
            bl = this.setQuantifier();
        }
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        return (ValueNode)this.nodeFactory.getNode(115, valueNode, clazz, bl ? Boolean.TRUE : Boolean.FALSE, string, this.getContextManager());
    }

    public final ValueNode generalAggregate() throws ParseException, StandardException {
        Token token = this.builtInAggregateType();
        this.jj_consume_token(420);
        ValueNode valueNode = this.aggregateExpression(SQLParser.aggName(token), SQLParser.aggClass(token));
        this.jj_consume_token(421);
        return valueNode;
    }

    public final Token builtInAggregateType() throws ParseException, StandardException {
        Token token;
        switch (this.jj_nt.kind) {
            case 174: {
                token = this.jj_consume_token(174);
                break;
            }
            case 71: {
                token = this.jj_consume_token(71);
                break;
            }
            case 175: {
                token = this.jj_consume_token(175);
                break;
            }
            case 229: {
                token = this.jj_consume_token(229);
                break;
            }
            default: {
                this.jj_la1[203] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final ValueNode castSpecification() throws ParseException, StandardException {
        int n = -1;
        this.jj_consume_token(81);
        this.jj_consume_token(420);
        ValueNode valueNode = this.castOperand();
        this.jj_consume_token(66);
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeCast();
        this.jj_consume_token(421);
        ValueNode valueNode2 = (ValueNode)this.nodeFactory.getNode(60, valueNode, dataTypeDescriptor, this.getContextManager());
        ((CastNode)valueNode2).setForExternallyGeneratedCASTnode();
        if (dataTypeDescriptor.getTypeId().userType()) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(28, valueNode2, this.getContextManager()), this.getContextManager());
        }
        return valueNode2;
    }

    public final int charOrVarchar() throws ParseException {
        switch (this.jj_nt.kind) {
            case 82: {
                this.jj_consume_token(82);
                return 1;
            }
            case 254: {
                this.jj_consume_token(254);
                return 12;
            }
        }
        this.jj_la1[204] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode castOperand() throws ParseException, StandardException {
        if (this.jj_2_44(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0, false);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 184: {
                this.jj_consume_token(184);
                return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
            }
        }
        this.jj_la1[205] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
        this.jj_consume_token(438);
        return this.makeParameterNode();
    }

    public final ValueNode whereClause(Token token) throws ParseException, StandardException {
        ValueNode valueNode = this.valueExpression(false);
        Token token2 = this.getToken(0);
        valueNode.setBeginOffset(token.endOffset + 1);
        valueNode.setEndOffset(token2.endOffset);
        return valueNode;
    }

    public final GroupByList groupByClause() throws ParseException, StandardException {
        this.jj_consume_token(148);
        this.jj_consume_token(77);
        GroupByList groupByList = this.groupingColumnReferenceList();
        return groupByList;
    }

    public final GroupByList groupingColumnReferenceList() throws ParseException, StandardException {
        GroupByList groupByList = (GroupByList)this.nodeFactory.getNode(3, this.getContextManager());
        this.groupingColumnReference(groupByList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[206] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.groupingColumnReference(groupByList);
        }
        return groupByList;
    }

    public final void groupingColumnReference(GroupByList groupByList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        if (valueNode.isParameterNode()) {
            throw StandardException.newException("42X01", "?");
        }
        if (valueNode instanceof AggregateNode) {
            AggregateNode aggregateNode = (AggregateNode)valueNode;
            throw StandardException.newException("42Y26", aggregateNode.getAggregateName());
        }
        groupByList.addGroupByColumn((GroupByColumn)this.nodeFactory.getNode(35, valueNode, this.getContextManager()));
    }

    public final ValueNode havingClause() throws ParseException, StandardException {
        this.jj_consume_token(149);
        ValueNode valueNode = this.valueExpression(false);
        return valueNode;
    }

    public final StatementNode schemaDefinition() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        this.jj_consume_token(215);
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                string = this.identifier(128, true);
                switch (this.jj_nt.kind) {
                    case 70: {
                        this.jj_consume_token(70);
                        string2 = this.identifier(128, true);
                        break;
                    }
                    default: {
                        this.jj_la1[207] = this.jj_gen;
                    }
                }
                if (string2 != null) {
                    this.checkVersion(140, "AUTHORIZATION");
                }
                if (string.startsWith("SYS")) {
                    throw StandardException.newException("42939", string);
                }
                return (StatementNode)this.nodeFactory.getNode(134, string, string2, this.getContextManager());
            }
            case 70: {
                this.jj_consume_token(70);
                string2 = this.identifier(128, true);
                this.checkVersion(140, "AUTHORIZATION");
                if (string2.startsWith("SYS")) {
                    throw StandardException.newException("42939", string2);
                }
                return (StatementNode)this.nodeFactory.getNode(134, string2, string2, this.getContextManager());
            }
        }
        this.jj_la1[208] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableDefinition() throws ParseException, StandardException {
        char c = 'R';
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        boolean bl = true;
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        if (this.getToken((int)1).kind == 420 && this.getToken((int)3).kind != 424 && this.getToken((int)3).kind != 421) {
            TableElementList tableElementList = this.tableElementList();
            switch (this.jj_nt.kind) {
                case 53: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(58);
                    break;
                }
                default: {
                    this.jj_la1[209] = this.jj_gen;
                }
            }
            return (StatementNode)this.nodeFactory.getNode(141, tableName, tableElementList, properties, new Character(c), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 66: 
            case 420: {
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        resultColumnList = this.tableColumnList();
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[210] = this.jj_gen;
                    }
                }
                this.jj_consume_token(66);
                ResultSetNode resultSetNode = this.queryExpression(null, 0);
                this.jj_consume_token(259);
                switch (this.jj_nt.kind) {
                    case 182: {
                        this.jj_consume_token(182);
                        bl = false;
                        break;
                    }
                    default: {
                        this.jj_la1[211] = this.jj_gen;
                    }
                }
                this.jj_consume_token(275);
                if (bl) {
                    throw StandardException.newException("0A000.S", "WITH DATA");
                }
                HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
                resultSetNode.accept(hasNodeVisitor);
                if (hasNodeVisitor.hasNode()) {
                    throw StandardException.newException("42X99");
                }
                return (StatementNode)this.nodeFactory.getNode(141, tableName, resultColumnList, resultSetNode, this.getContextManager());
            }
        }
        this.jj_la1[212] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList tableColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final Properties propertyList(boolean bl) throws ParseException, StandardException {
        FormatableProperties formatableProperties = new FormatableProperties();
        this.jj_consume_token(53);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getToken((int)1).image, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=", true);
            if (stringTokenizer2.countTokens() != 3) {
                throw StandardException.newException("XCY04.S");
            }
            String string2 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.nextToken().equals("=")) {
                throw StandardException.newException("XCY04.S");
            }
            String string3 = stringTokenizer2.nextToken().trim();
            SQLParser.verifyImageLength(string3);
            if (formatableProperties.put(string2, string3 = string3.startsWith("'") && string3.endsWith("'") ? SQLParser.compressQuotes(string3.substring(1, string3.length() - 1), SINGLEQUOTES) : (string3.startsWith("\"") && string3.endsWith("\"") ? SQLParser.compressQuotes(string3.substring(1, string3.length() - 1), DOUBLEQUOTES) : string3.toUpperCase())) == null) continue;
            throw StandardException.newException("42Y49", string2);
        }
        if (!bl) {
            this.checkInternalFeature("DERBY-PROPERTIES");
        }
        return formatableProperties;
    }

    public final char DB2lockGranularityClause() throws ParseException, StandardException {
        this.jj_consume_token(293);
        char c = this.lockGranularity();
        return c;
    }

    public final char lockGranularity() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 232: {
                this.jj_consume_token(232);
                return 'T';
            }
            case 313: {
                this.jj_consume_token(313);
                return 'R';
            }
        }
        this.jj_la1[213] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode indexDefinition() throws ParseException, StandardException {
        Boolean bl = Boolean.FALSE;
        Properties properties = null;
        Vector vector = new Vector();
        switch (this.jj_nt.kind) {
            case 245: {
                bl = this.unique();
                break;
            }
            default: {
                this.jj_la1[214] = this.jj_gen;
            }
        }
        this.jj_consume_token(371);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(188);
        TableName tableName2 = this.qualifiedName(128);
        this.jj_consume_token(420);
        this.indexColumnList(vector);
        this.jj_consume_token(421);
        switch (this.jj_nt.kind) {
            case 53: {
                properties = this.propertyList(false);
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[215] = this.jj_gen;
            }
        }
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(tableName2.getSchemaName());
        } else if (tableName2.getSchemaName() == null) {
            tableName2.setSchemaName(tableName.getSchemaName());
        } else if (!tableName.getSchemaName().equals(tableName2.getSchemaName())) {
            throw StandardException.newException("X0Y26.S", (Object)tableName, (Object)tableName2);
        }
        return (StatementNode)this.nodeFactory.getNode(146, bl, DEFAULT_INDEX_TYPE, tableName, tableName2, vector, properties, this.getContextManager());
    }

    public final Boolean unique() throws ParseException, StandardException {
        this.jj_consume_token(245);
        return Boolean.TRUE;
    }

    public final StatementNode procedureDefinition() throws ParseException, StandardException {
        Object[] objectArray = new Object[9];
        this.jj_consume_token(204);
        TableName tableName = this.qualifiedName(128);
        objectArray[0] = this.procedureParameterList();
        block3: while (true) {
            this.routineElement(true, objectArray);
            switch (this.jj_nt.kind) {
                case 132: 
                case 182: 
                case 269: 
                case 274: 
                case 279: 
                case 288: 
                case 296: 
                case 312: 
                case 387: 
                case 390: 
                case 395: 
                case 405: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[216] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, objectArray);
        return this.getCreateAliasNode(tableName, (String)objectArray[4], objectArray, 'P', Boolean.FALSE);
    }

    public final void routineElement(boolean bl, Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        Object object = null;
        switch (this.jj_nt.kind) {
            case 405: {
                this.jj_consume_token(405);
                object = this.qualifiedName(128);
                n = 1;
                throw StandardException.newException("0A000.S", "SPECIFIC identifier");
            }
            case 279: 
            case 395: {
                switch (this.jj_nt.kind) {
                    case 279: {
                        this.jj_consume_token(279);
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                    }
                }
                this.jj_consume_token(395);
                this.jj_consume_token(402);
                int n2 = this.uint_value();
                if (!bl) {
                    throw StandardException.newException("42X01", "RESULT SETS");
                }
                object = ReuseFactory.getInteger(n2);
                n = 2;
                break;
            }
            case 288: {
                this.jj_consume_token(288);
                this.jj_consume_token(372);
                object = "JAVA";
                n = 3;
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                this.jj_consume_token(301);
                object = this.string();
                n = 4;
                break;
            }
            case 387: {
                this.jj_consume_token(387);
                this.jj_consume_token(409);
                object = this.parameterStyle();
                n = 5;
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(224);
                object = ReuseFactory.getShort((short)3);
                n = 6;
                break;
            }
            case 274: {
                this.jj_consume_token(274);
                this.jj_consume_token(224);
                object = ReuseFactory.getShort((short)2);
                n = 6;
                break;
            }
            case 390: {
                this.jj_consume_token(390);
                this.jj_consume_token(224);
                this.jj_consume_token(275);
                object = ReuseFactory.getShort((short)1);
                n = 6;
                break;
            }
            case 296: {
                this.jj_consume_token(296);
                this.jj_consume_token(224);
                this.jj_consume_token(275);
                if (!bl) {
                    throw StandardException.newException("42X01", "MODIFIES SQL DATA");
                }
                object = ReuseFactory.getShort((short)0);
                n = 6;
                break;
            }
            case 269: 
            case 312: {
                object = this.calledOnNullInput(bl);
                n = 7;
                break;
            }
            default: {
                this.jj_la1[218] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = ROUTINE_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = object;
        }
    }

    public final Boolean calledOnNullInput(boolean bl) throws ParseException, StandardException {
        Boolean bl2;
        switch (this.jj_nt.kind) {
            case 269: {
                this.jj_consume_token(269);
                bl2 = Boolean.TRUE;
                break;
            }
            case 312: {
                this.jj_consume_token(312);
                this.jj_consume_token(184);
                if (bl) {
                    throw StandardException.newException("42X01", "RETURNS NULL ON NULL INPUT");
                }
                bl2 = Boolean.FALSE;
                break;
            }
            default: {
                this.jj_la1[219] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(188);
        this.jj_consume_token(184);
        this.jj_consume_token(157);
        return bl2;
    }

    public final Short parameterStyle() throws ParseException {
        this.jj_consume_token(372);
        return ReuseFactory.getShort((short)0);
    }

    public final Object[] procedureParameterList() throws ParseException, StandardException {
        Object[] objectArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        this.jj_consume_token(420);
        if (this.jj_2_45(1)) {
            this.procedureParameterDefinition((Vector[])objectArray);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[220] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                this.procedureParameterDefinition((Vector[])objectArray);
            }
        }
        this.jj_consume_token(421);
        return objectArray;
    }

    public final void procedureParameterDefinition(Vector[] vectorArray) throws ParseException, StandardException {
        String string = "";
        Integer n = this.inoutParameter();
        if (this.commonDatatypeName(2, false)) {
            string = this.identifier(128, true);
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        vectorArray[0].addElement(string);
        vectorArray[1].addElement(dataTypeDescriptor);
        vectorArray[2].addElement(n);
    }

    public final Integer inoutParameter() throws ParseException {
        int n = 1;
        block0 : switch (this.jj_nt.kind) {
            case 153: 
            case 285: 
            case 386: {
                switch (this.jj_nt.kind) {
                    case 153: {
                        this.jj_consume_token(153);
                        break block0;
                    }
                    case 386: {
                        this.jj_consume_token(386);
                        n = 4;
                        break block0;
                    }
                    case 285: {
                        this.jj_consume_token(285);
                        n = 2;
                        break block0;
                    }
                }
                this.jj_la1[221] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[222] = this.jj_gen;
            }
        }
        return ReuseFactory.getInteger(n);
    }

    public final StatementNode functionDefinition() throws ParseException, StandardException {
        Object[] objectArray = new Object[9];
        this.jj_consume_token(142);
        TableName tableName = this.qualifiedName(128);
        objectArray[0] = this.functionParameterList();
        this.jj_consume_token(312);
        objectArray[8] = this.dataTypeCommon();
        block3: while (true) {
            this.routineElement(false, objectArray);
            switch (this.jj_nt.kind) {
                case 132: 
                case 182: 
                case 269: 
                case 274: 
                case 279: 
                case 288: 
                case 296: 
                case 312: 
                case 387: 
                case 390: 
                case 395: 
                case 405: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[223] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, objectArray);
        return this.getCreateAliasNode(tableName, (String)objectArray[4], objectArray, 'F', Boolean.FALSE);
    }

    public final Object[] functionParameterList() throws ParseException, StandardException {
        Object[] objectArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        this.jj_consume_token(420);
        if (this.jj_2_46(1)) {
            this.functionParameterDefinition((Vector[])objectArray);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[224] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                this.functionParameterDefinition((Vector[])objectArray);
            }
        }
        this.jj_consume_token(421);
        return objectArray;
    }

    public final void functionParameterDefinition(Vector[] vectorArray) throws ParseException, StandardException {
        String string = "";
        if (this.commonDatatypeName(2, false)) {
            string = this.identifier(128, true);
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        vectorArray[0].addElement(string);
        vectorArray[1].addElement(dataTypeDescriptor);
        vectorArray[2].addElement(ReuseFactory.getInteger(1));
    }

    public final StatementNode viewDefinition(Token token) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        Object var6_3 = null;
        this.jj_consume_token(256);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                resultColumnList = this.viewColumnList();
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[225] = this.jj_gen;
            }
        }
        this.jj_consume_token(66);
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        int n = 0;
        Token token2 = this.getToken(0);
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
        resultSetNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42X98");
        }
        return (StatementNode)this.nodeFactory.getNode(130, tableName, resultColumnList, resultSetNode, ReuseFactory.getInteger(n), StringUtil.slice(this.statementSQLText, token.beginOffset, token2.endOffset, false), this.getContextManager());
    }

    public final ResultColumnList viewColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final StatementNode triggerDefinition() throws ParseException, StandardException {
        Boolean bl = Boolean.FALSE;
        Token[] tokenArray = new Token[1];
        Object var7_3 = null;
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        Vector vector = null;
        this.jj_consume_token(410);
        TableName tableName = this.qualifiedName(128);
        Boolean bl2 = this.beforeOrAfter();
        int n = this.triggerEvent(resultColumnList);
        this.jj_consume_token(188);
        TableName tableName2 = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 392: {
                vector = this.triggerReferencingClause();
                break;
            }
            default: {
                this.jj_la1[226] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 137: {
                this.jj_consume_token(137);
                this.jj_consume_token(367);
                bl = this.rowOrStatement();
                break;
            }
            default: {
                this.jj_la1[227] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 378: {
                this.jj_consume_token(378);
                this.jj_consume_token(364);
                break;
            }
            default: {
                this.jj_la1[228] = this.jj_gen;
            }
        }
        StatementNode statementNode = this.proceduralStatement(tokenArray);
        int n2 = this.getToken((int)0).endOffset;
        int n3 = tokenArray[0].beginOffset;
        if (bl2.booleanValue() && statementNode instanceof DMLModStatementNode) {
            throw StandardException.newException("42Z9D", (Object)statementNode.statementToString(), (Object)"BEFORE");
        }
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
        statementNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42Y27");
        }
        return (StatementNode)this.nodeFactory.getNode(143, tableName, tableName2, ReuseFactory.getInteger(n), resultColumnList, bl2, bl, Boolean.TRUE, vector, null, null, ReuseFactory.getInteger(0), statementNode, StringUtil.slice(this.statementSQLText, n3, n2, false), ReuseFactory.getInteger(n3), this.getContextManager());
    }

    public final StatementNode synonymDefinition() throws ParseException, StandardException {
        this.jj_consume_token(329);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(137);
        TableName tableName2 = this.qualifiedName(128);
        this.checkVersion(130, "CREATE SYNONYM");
        return (StatementNode)this.getNodeFactory().getCreateAliasNode(tableName, tableName2, null, 'S', Boolean.FALSE, this.getContextManager());
    }

    public final Boolean beforeOrAfter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(78);
                this.jj_consume_token(358);
                return Boolean.TRUE;
            }
            case 357: {
                this.jj_consume_token(357);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[229] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int triggerEvent(ResultColumnList resultColumnList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 159: {
                this.jj_consume_token(159);
                return 4;
            }
            case 115: {
                this.jj_consume_token(115);
                return 2;
            }
            case 247: {
                this.jj_consume_token(247);
                switch (this.jj_nt.kind) {
                    case 187: {
                        this.jj_consume_token(187);
                        this.columnNameList(resultColumnList);
                        break;
                    }
                    default: {
                        this.jj_la1[230] = this.jj_gen;
                    }
                }
                return 1;
            }
        }
        this.jj_la1[231] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Boolean rowOrStatement() throws ParseException {
        switch (this.jj_nt.kind) {
            case 313: {
                this.token = this.jj_consume_token(313);
                return Boolean.TRUE;
            }
            case 328: {
                this.token = this.jj_consume_token(328);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[232] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Vector triggerReferencingClause() throws ParseException, StandardException {
        Vector vector = new Vector();
        this.jj_consume_token(392);
        this.triggerReferencingExpression(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 379: 
                case 380: 
                case 384: 
                case 385: {
                    break;
                }
                default: {
                    this.jj_la1[233] = this.jj_gen;
                    break block3;
                }
            }
            this.triggerReferencingExpression(vector);
        }
        return vector;
    }

    public final void triggerReferencingExpression(Vector vector) throws ParseException, StandardException {
        boolean bl = true;
        boolean bl2 = true;
        switch (this.jj_nt.kind) {
            case 379: {
                this.jj_consume_token(379);
                break;
            }
            case 384: {
                this.jj_consume_token(384);
                bl = false;
                break;
            }
            case 380: {
                this.jj_consume_token(380);
                bl2 = false;
                break;
            }
            case 385: {
                this.jj_consume_token(385);
                bl = false;
                bl2 = false;
                break;
            }
            default: {
                this.jj_la1[234] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(66);
        String string = this.identifier(128, true);
        vector.addElement(new TriggerReferencingStruct(bl2, bl, string));
    }

    public final ValueNode defaultClause(long[] lArray, String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 112: 
            case 259: {
                switch (this.jj_nt.kind) {
                    case 259: {
                        this.jj_consume_token(259);
                        break;
                    }
                    default: {
                        this.jj_la1[235] = this.jj_gen;
                    }
                }
                Token token = this.jj_consume_token(112);
                ValueNode valueNode = this.defaultOption(token, lArray, string);
                return valueNode;
            }
            case 281: {
                ValueNode valueNode = this.generatedColumnOption(lArray);
                return valueNode;
            }
        }
        this.jj_la1[236] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
        this.jj_consume_token(112);
        this.jj_consume_token(184);
        return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
    }

    public final ValueNode generatedColumnOption(long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        lArray[0] = 1L;
        lArray[1] = 1L;
        lArray[2] = 1L;
        lArray[3] = 0L;
        this.jj_consume_token(281);
        switch (this.jj_nt.kind) {
            case 266: {
                this.jj_consume_token(266);
                valueNode = null;
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(112);
                this.checkVersion(130, "GENERATED BY DEFAULT");
                valueNode = (ValueNode)this.nodeFactory.getNode(100, this.getContextManager());
                break;
            }
            default: {
                this.jj_la1[237] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(66);
        this.jj_consume_token(151);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                this.autoIncrementBeginEnd(lArray);
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[238] = this.jj_gen;
            }
        }
        return valueNode;
    }

    public final void autoIncrementBeginEnd(long[] lArray) throws ParseException, StandardException {
        long l = 1L;
        long l2 = 1L;
        switch (this.jj_nt.kind) {
            case 283: {
                this.jj_consume_token(283);
                this.jj_consume_token(77);
                lArray[1] = l2 = this.exactNumber();
                lArray[3] = 0L;
                return;
            }
            case 327: {
                this.jj_consume_token(327);
                this.jj_consume_token(259);
                l = this.exactNumber();
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        this.jj_consume_token(283);
                        this.jj_consume_token(77);
                        l2 = this.exactNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[239] = this.jj_gen;
                    }
                }
                lArray[0] = l;
                lArray[1] = l2;
                lArray[3] = 0L;
                return;
            }
        }
        this.jj_la1[240] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultOption(Token token, long[] lArray, String string) throws ParseException, StandardException {
        Object var5_4 = null;
        Object var6_5 = null;
        if (this.getToken((int)1).kind == 184 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            this.jj_consume_token(184);
            return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
        }
        if (this.jj_2_47(1)) {
            ValueNode valueNode = this.DB2DefaultOption(string);
            Token token2 = this.getToken(0);
            valueNode.setBeginOffset(token.beginOffset);
            valueNode.setEndOffset(token2.endOffset);
            valueNode = (ValueNode)this.nodeFactory.getNode(100, valueNode, StringUtil.slice(this.statementSQLText, token.beginOffset + 7, token2.endOffset, true), this.getContextManager());
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode DB2DefaultOption(String string) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404) {
            this.jj_consume_token(101);
            switch (this.jj_nt.kind) {
                case 215: {
                    this.jj_consume_token(215);
                    break;
                }
                case 404: {
                    this.jj_consume_token(404);
                    break;
                }
                default: {
                    this.jj_la1[241] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return (ValueNode)this.nodeFactory.getNode(6, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 249: {
                this.jj_consume_token(249);
                return (ValueNode)this.nodeFactory.getNode(110, this.getContextManager());
            }
        }
        this.jj_la1[242] = this.jj_gen;
        if (this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332) {
            ValueNode valueNode = this.miscBuiltins();
            return valueNode;
        }
        if (this.getToken((int)2).kind == 420 || this.getToken((int)4).kind == 420 && this.getToken((int)2).kind != 424) {
            ValueNode valueNode = this.miscBuiltins();
            throw StandardException.newException("42894", string);
        }
        if (this.jj_2_48(1)) {
            ValueNode valueNode = this.datetimeValueFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 133: 
            case 242: 
            case 418: 
            case 423: 
            case 425: 
            case 452: 
            case 455: 
            case 456: 
            case 457: {
                ValueNode valueNode = this.literal();
                return valueNode;
            }
        }
        this.jj_la1[243] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode literal() throws ParseException, StandardException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 423: 
            case 425: 
            case 452: 
            case 457: {
                switch (this.jj_nt.kind) {
                    case 423: 
                    case 425: {
                        string = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[244] = this.jj_gen;
                    }
                }
                ValueNode valueNode = this.numericLiteral(string);
                return valueNode;
            }
            case 455: {
                CharConstantNode charConstantNode = this.stringLiteral();
                return charConstantNode;
            }
            case 456: {
                ValueNode valueNode = this.hexLiteral();
                return valueNode;
            }
            case 418: {
                ValueNode valueNode = this.dateTimeLiteral();
                return valueNode;
            }
            case 133: 
            case 242: {
                Token token = this.booleanLiteral();
                this.checkInternalFeature(token.image);
                return (ValueNode)this.nodeFactory.getNode(38, StringUtil.SQLEqualsIgnoreCase(token.image, "true") ? Boolean.TRUE : Boolean.FALSE, this.getContextManager());
            }
        }
        this.jj_la1[245] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericLiteral(String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 452: {
                Token token = this.jj_consume_token(452);
                String string2 = token.image;
                if (string.equals("-")) {
                    string2 = string.concat(string2);
                }
                return this.getNumericNode(string2);
            }
            case 457: {
                Double d;
                Token token = this.jj_consume_token(457);
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(token.image);
                String string3 = stringBuffer.toString();
                int n = string3.indexOf(69);
                if (n == -1) {
                    n = string3.indexOf(101);
                }
                if (string3.length() > 30) {
                    throw StandardException.newException("42820", (Object)string3, (Object)"DOUBLE");
                }
                int n2 = string3.substring(0, n).indexOf(46);
                if (n2 == -1) {
                    stringBuffer.insert(n, '.');
                    string3 = stringBuffer.toString();
                    ++n;
                }
                try {
                    d = Double.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "DOUBLE");
                }
                double d2 = d;
                if (d2 == 0.0 && Double.parseDouble(string3.substring(0, n - 1)) != 0.0) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                return (ValueNode)this.nodeFactory.getNode(68, d, this.getContextManager());
            }
        }
        this.jj_la1[246] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeLiteral() throws ParseException, StandardException {
        this.jj_consume_token(418);
        ValueNode valueNode = this.escapedDateTimeLiteral();
        this.jj_consume_token(419);
        return valueNode;
    }

    public final ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 107: {
                this.jj_consume_token(107);
                ValueNode valueNode = this.bareDateLiteral();
                return valueNode;
            }
            case 231: {
                this.jj_consume_token(231);
                ValueNode valueNode = this.bareTimeLiteral();
                return valueNode;
            }
            case 243: {
                this.jj_consume_token(243);
                ValueNode valueNode = this.bareTimestampLiteral();
                return valueNode;
            }
        }
        this.jj_la1[247] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode bareDateLiteral() throws ParseException, StandardException {
        String string = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getDateValue(string, true), this.getContextManager());
    }

    public final ValueNode bareTimeLiteral() throws ParseException, StandardException {
        String string = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getTimeValue(string, true), this.getContextManager());
    }

    public final ValueNode bareTimestampLiteral() throws ParseException, StandardException {
        String string = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getTimestampValue(string, true), this.getContextManager());
    }

    public final String string() throws ParseException, StandardException {
        Token token = this.jj_consume_token(455);
        SQLParser.verifyImageLength(token.image);
        return SQLParser.compressQuotes(token.image.substring(1, token.image.length() - 1), SINGLEQUOTES);
    }

    public final CharConstantNode stringLiteral() throws ParseException, StandardException {
        Token token = this.jj_consume_token(455);
        if (token.image.length() - 2 > 32672) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(token.image));
        }
        String string = SQLParser.compressQuotes(token.image.substring(1, token.image.length() - 1), SINGLEQUOTES);
        return (CharConstantNode)this.nodeFactory.getNode(61, string, this.getContextManager());
    }

    public final ValueNode hexLiteral() throws ParseException, StandardException {
        Token token = this.jj_consume_token(456);
        String string = token.image;
        if (string.length() - 3 > 16336) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(string));
        }
        if ((string.length() - 3) % 2 == 1) {
            throw StandardException.newException("42606", StringUtil.formatForPrint(string));
        }
        int n = (string.length() - 3) / 2;
        return (ValueNode)this.nodeFactory.getNode(59, string.substring(2, string.length() - 1), ReuseFactory.getInteger(n), this.getContextManager());
    }

    public final TableName constraintNameDefinition() throws ParseException, StandardException {
        this.jj_consume_token(94);
        TableName tableName = this.qualifiedName(128);
        return tableName;
    }

    public final ConstraintDefinitionNode checkConstraintDefinition(TableName tableName, String string) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        this.jj_consume_token(85);
        Token token = this.jj_consume_token(420);
        ValueNode valueNode = this.valueExpression(false);
        Token token2 = this.jj_consume_token(421);
        if (string != null) {
            resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
            resultColumnList.addElement((ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager()));
        }
        valueNode.setBeginOffset(token.beginOffset);
        valueNode.setEndOffset(token2.endOffset);
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(4), resultColumnList, null, valueNode, StringUtil.slice(this.statementSQLText, token.beginOffset, token2.endOffset, true), this.getContextManager());
    }

    public final StatementNode spsRenameStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(393);
        switch (this.jj_nt.kind) {
            case 232: {
                statementNode = this.renameTableStatement();
                break;
            }
            case 371: {
                statementNode = this.renameIndexStatement();
                break;
            }
            case 90: {
                statementNode = this.renameColumnStatement();
                break;
            }
            default: {
                this.jj_la1[248] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode renameTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(236);
        String string = this.identifier(128, true);
        return (StatementNode)this.nodeFactory.getNode(191, tableName, null, string, Boolean.FALSE, ReuseFactory.getInteger(1), this.getContextManager());
    }

    public final StatementNode renameIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(371);
        String string = this.identifier(128, true);
        this.jj_consume_token(236);
        String string2 = this.identifier(128, true);
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(191, null, string, string2, Boolean.FALSE, ReuseFactory.getInteger(3), this.getContextManager());
        return statementNode;
    }

    public final StatementNode renameColumnStatement() throws ParseException, StandardException {
        this.jj_consume_token(90);
        ColumnReference columnReference = this.columnReference();
        this.jj_consume_token(236);
        String string = this.identifier(128, true);
        if (columnReference.getTableNameNode() == null) {
            throw StandardException.newException("42Y55", (Object)"RENAME COLUMN", (Object)columnReference.getColumnName());
        }
        return (StatementNode)this.nodeFactory.getNode(191, columnReference.getTableNameNode(), columnReference.getColumnName(), string, Boolean.FALSE, ReuseFactory.getInteger(2), this.getContextManager());
    }

    public final StatementNode lockStatement() throws ParseException, StandardException {
        this.jj_consume_token(375);
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(153);
        Boolean bl = this.lockMode();
        this.jj_consume_token(378);
        return (StatementNode)this.nodeFactory.getNode(112, tableName, bl, this.getContextManager());
    }

    public final Boolean lockMode() throws ParseException {
        switch (this.jj_nt.kind) {
            case 369: {
                this.jj_consume_token(369);
                return Boolean.TRUE;
            }
            case 403: {
                this.jj_consume_token(403);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[249] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode execStatement() throws ParseException, StandardException {
        this.jj_consume_token(130);
        this.jj_consume_token(328);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(118, tableName, this.getContextManager());
    }

    public final TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {
        this.setIsolationHeader();
        block0 : switch (this.jj_nt.kind) {
            case 236: 
            case 433: {
                switch (this.jj_nt.kind) {
                    case 433: {
                        this.jj_consume_token(433);
                        break block0;
                    }
                    case 236: {
                        this.jj_consume_token(236);
                        break block0;
                    }
                }
                this.jj_la1[250] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[251] = this.jj_gen;
            }
        }
        TransactionStatementNode transactionStatementNode = this.transactionMode();
        return transactionStatementNode;
    }

    public final void setIsolationHeader() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 165: {
                this.jj_consume_token(165);
                break;
            }
            default: {
                this.jj_la1[252] = this.jj_gen;
                if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 165) {
                    this.jj_consume_token(101);
                    this.jj_consume_token(165);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TransactionStatementNode transactionMode() throws ParseException, StandardException {
        int n = this.isolationLevelDB2OrReset();
        return (TransactionStatementNode)this.nodeFactory.getNode(21, ReuseFactory.getInteger(n), this.getContextManager());
    }

    public final int isolationLevelDB2OrReset() throws ParseException {
        switch (this.jj_nt.kind) {
            case 394: {
                this.jj_consume_token(394);
                return 0;
            }
        }
        this.jj_la1[253] = this.jj_gen;
        if (this.jj_2_49(1)) {
            int n = this.isolationLevelDB2();
            return n;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2() throws ParseException {
        switch (this.jj_nt.kind) {
            case 362: 
            case 398: 
            case 399: 
            case 412: {
                int n = this.isolationLevelDB2Abbrev();
                return n;
            }
            case 310: 
            case 317: {
                switch (this.jj_nt.kind) {
                    case 310: {
                        this.jj_consume_token(310);
                        this.jj_consume_token(206);
                        break;
                    }
                    case 317: {
                        this.jj_consume_token(317);
                        break;
                    }
                    default: {
                        this.jj_la1[254] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 4;
            }
            case 106: {
                this.jj_consume_token(106);
                this.jj_consume_token(407);
                return 2;
            }
            case 365: {
                this.jj_consume_token(365);
                this.jj_consume_token(206);
                return 1;
            }
        }
        this.jj_la1[255] = this.jj_gen;
        if (this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 272) {
            this.jj_consume_token(206);
            this.jj_consume_token(272);
            return 2;
        }
        if (this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 337) {
            this.jj_consume_token(206);
            this.jj_consume_token(337);
            return 1;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2Abbrev() throws ParseException {
        switch (this.jj_nt.kind) {
            case 398: {
                this.jj_consume_token(398);
                return 4;
            }
            case 399: {
                this.jj_consume_token(399);
                return 3;
            }
            case 362: {
                this.jj_consume_token(362);
                return 2;
            }
            case 412: {
                this.jj_consume_token(412);
                return 1;
            }
        }
        this.jj_la1[256] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevel() throws ParseException {
        this.jj_consume_token(165);
        this.jj_consume_token(291);
        int n = this.levelOfIsolation();
        return n;
    }

    public final int levelOfIsolation() throws ParseException {
        switch (this.jj_nt.kind) {
            case 206: {
                this.jj_consume_token(206);
                return this.levelOfIsolationRead();
            }
            case 310: {
                this.jj_consume_token(310);
                this.jj_consume_token(206);
                return 3;
            }
            case 317: {
                this.jj_consume_token(317);
                return 4;
            }
        }
        this.jj_la1[257] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int levelOfIsolationRead() throws ParseException {
        switch (this.jj_nt.kind) {
            case 337: {
                this.jj_consume_token(337);
                return 1;
            }
            case 272: {
                this.jj_consume_token(272);
                return 2;
            }
        }
        this.jj_la1[258] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode simpleValueSpecification() throws ParseException, StandardException {
        ValueNode valueNode = this.literal();
        return valueNode;
    }

    public final StatementNode setSchemaStatement() throws ParseException, StandardException {
        this.setSchemaHeader();
        switch (this.jj_nt.kind) {
            case 433: {
                this.jj_consume_token(433);
                break;
            }
            default: {
                this.jj_la1[259] = this.jj_gen;
            }
        }
        StatementNode statementNode = this.setSchemaValues();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(0);
            parameterNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return statementNode;
    }

    public final void setSchemaHeader() throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 215: {
                this.jj_consume_token(215);
                break;
            }
            default: {
                this.jj_la1[261] = this.jj_gen;
                if (this.getToken((int)1).kind == 101 && (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404)) {
                    this.jj_consume_token(101);
                    switch (this.jj_nt.kind) {
                        case 215: {
                            this.jj_consume_token(215);
                            break block0;
                        }
                        case 404: {
                            this.jj_consume_token(404);
                            break block0;
                        }
                    }
                    this.jj_la1[260] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode setSchemaValues() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String string = this.identifier(128, true);
                return (StatementNode)this.nodeFactory.getNode(81, string, null, this.getContextManager());
            }
            case 249: {
                this.jj_consume_token(249);
                return (StatementNode)this.nodeFactory.getNode(81, null, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 438: {
                this.dynamicParameterSpecification();
                return (StatementNode)this.nodeFactory.getNode(81, null, ReuseFactory.getInteger(2), this.getContextManager());
            }
            case 455: {
                String string = this.string();
                this.checkIdentifierLengthLimit(string, 128);
                return (StatementNode)this.nodeFactory.getNode(81, string, null, this.getContextManager());
            }
        }
        this.jj_la1[262] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setMessageLocaleStatement() throws ParseException, StandardException {
        this.jj_consume_token(376);
        String string = this.string();
        this.getContextManager().setMessageLocale(string);
        return (StatementNode)this.nodeFactory.getNode(19, this.getContextManager());
    }

    public final ValueNode valueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 133: 
            case 242: 
            case 418: 
            case 423: 
            case 425: 
            case 452: 
            case 455: 
            case 456: 
            case 457: {
                ValueNode valueNode = this.literal();
                return valueNode;
            }
            case 105: 
            case 219: 
            case 249: 
            case 438: {
                ValueNode valueNode = this.generalValueSpecification();
                return valueNode;
            }
            case 185: {
                this.jj_consume_token(185);
                this.jj_consume_token(420);
                ValueNode valueNode = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode valueNode2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                ContextManager contextManager = this.getContextManager();
                ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, contextManager);
                valueNodeList.addElement((ValueNode)this.nodeFactory.getNode(13, contextManager));
                valueNodeList.addElement(valueNode);
                return (ValueNode)this.nodeFactory.getNode(54, (ValueNode)this.nodeFactory.getNode(41, valueNode, valueNode2, contextManager), valueNodeList, Boolean.TRUE, contextManager);
            }
            case 80: {
                this.jj_consume_token(80);
                ValueNode valueNode = this.whenThenExpression();
                return valueNode;
            }
        }
        this.jj_la1[263] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode caseExpression() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 124: {
                this.jj_consume_token(124);
                ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(60, (ValueNode)this.nodeFactory.getNode(13, this.getContextManager()), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), this.getContextManager());
                ((CastNode)valueNode).setForExternallyGeneratedCASTnode();
                return valueNode;
            }
            case 123: {
                this.jj_consume_token(123);
                ValueNode valueNode = this.thenElseExpression();
                this.jj_consume_token(124);
                return valueNode;
            }
            case 339: {
                ValueNode valueNode = this.whenThenExpression();
                return valueNode;
            }
        }
        this.jj_la1[264] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode whenThenExpression() throws ParseException, StandardException {
        this.jj_consume_token(339);
        ValueNode valueNode = this.orExpression(null, false);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 192: {
                    break;
                }
                default: {
                    this.jj_la1[265] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(192);
            valueNode = this.orExpression(valueNode, false);
        }
        this.jj_consume_token(330);
        ValueNode valueNode2 = this.thenElseExpression();
        ValueNode valueNode3 = this.caseExpression();
        ContextManager contextManager = this.getContextManager();
        ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, contextManager);
        valueNodeList.addElement(valueNode2);
        valueNodeList.addElement(valueNode3);
        return (ValueNode)this.nodeFactory.getNode(54, valueNode, valueNodeList, Boolean.FALSE, contextManager);
    }

    public final ValueNode thenElseExpression() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 184) {
            this.jj_consume_token(184);
            ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(60, (ValueNode)this.nodeFactory.getNode(13, this.getContextManager()), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), this.getContextManager());
            ((CastNode)valueNode).setForExternallyGeneratedCASTnode();
            return valueNode;
        }
        if (this.jj_2_50(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0, false);
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode tableConstraintDefinition() throws ParseException, StandardException {
        Properties properties = null;
        TableName tableName = null;
        this.explicitNotNull = false;
        this.explicitNull = false;
        switch (this.jj_nt.kind) {
            case 94: {
                tableName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[266] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode constraintDefinitionNode = this.tableConstraint(tableName);
        switch (this.jj_nt.kind) {
            case 53: {
                properties = this.propertyList(false);
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[267] = this.jj_gen;
            }
        }
        if (properties != null) {
            constraintDefinitionNode.setProperties(properties);
        }
        return constraintDefinitionNode;
    }

    public final ConstraintDefinitionNode tableConstraint(TableName tableName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 201: 
            case 245: {
                ConstraintDefinitionNode constraintDefinitionNode = this.uniqueConstraintDefinition(tableName);
                return constraintDefinitionNode;
            }
            case 138: {
                ConstraintDefinitionNode constraintDefinitionNode = this.referentialConstraintDefinition(tableName);
                return constraintDefinitionNode;
            }
            case 85: {
                ConstraintDefinitionNode constraintDefinitionNode = this.checkConstraintDefinition(tableName, null);
                return constraintDefinitionNode;
            }
        }
        this.jj_la1[268] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConstraintDefinitionNode uniqueConstraintDefinition(TableName tableName) throws ParseException, StandardException {
        int n = this.uniqueSpecification(null, null);
        this.jj_consume_token(420);
        ResultColumnList resultColumnList = this.uniqueColumnList();
        this.jj_consume_token(421);
        if (n == 2) {
            for (int i = 0; i < resultColumnList.size(); ++i) {
                String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
                if (!this.explicitlyNullableColumnsList.contains(string)) continue;
                String string2 = "42831";
                throw StandardException.newException(string2, string);
            }
        }
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(n), resultColumnList, null, null, null, this.getContextManager());
    }

    public final int uniqueSpecification(DataTypeDescriptor dataTypeDescriptor, String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 245: {
                this.jj_consume_token(245);
                return 3;
            }
            case 201: {
                this.jj_consume_token(201);
                this.jj_consume_token(167);
                if (this.explicitNull) {
                    String string2 = "42831";
                    throw StandardException.newException(string2, string);
                }
                return 2;
            }
        }
        this.jj_la1[269] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList uniqueColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final ConstraintDefinitionNode referentialConstraintDefinition(TableName tableName) throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        ResultColumnList resultColumnList2 = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        int[] nArray = new int[]{2, 2};
        this.jj_consume_token(138);
        this.jj_consume_token(167);
        this.jj_consume_token(420);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(421);
        TableName tableName2 = this.referencesSpecification(resultColumnList2, nArray);
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(119, tableName, tableName2, resultColumnList, resultColumnList2, nArray, this.getContextManager());
    }

    public final TableName referencesSpecification(ResultColumnList resultColumnList, int[] nArray) throws ParseException, StandardException {
        TableName tableName = null;
        this.jj_consume_token(208);
        tableName = this.referencedTableAndColumns(resultColumnList);
        switch (this.jj_nt.kind) {
            case 188: {
                this.jj_consume_token(188);
                this.referentialTriggeredAction(nArray);
                break;
            }
            default: {
                this.jj_la1[270] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final TableName referencedTableAndColumns(ResultColumnList resultColumnList) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                this.columnNameList(resultColumnList);
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[271] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final void referentialTriggeredAction(int[] nArray) throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 247: {
                nArray[1] = this.updateRule();
                switch (this.jj_nt.kind) {
                    case 188: {
                        this.jj_consume_token(188);
                        nArray[0] = this.deleteRule();
                        break block0;
                    }
                }
                this.jj_la1[272] = this.jj_gen;
                break;
            }
            case 115: {
                nArray[0] = this.deleteRule();
                switch (this.jj_nt.kind) {
                    case 188: {
                        this.jj_consume_token(188);
                        nArray[1] = this.updateRule();
                        break block0;
                    }
                }
                this.jj_la1[273] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[274] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int updateRule() throws ParseException {
        this.jj_consume_token(247);
        int n = this.updateReferentialAction();
        return n;
    }

    public final int deleteRule() throws ParseException {
        this.jj_consume_token(115);
        int n = this.deleteReferentialAction();
        return n;
    }

    public final int updateReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 210: {
                this.jj_consume_token(210);
                return 1;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(265);
                return 2;
            }
        }
        this.jj_la1[275] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int deleteReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 78: {
                this.jj_consume_token(78);
                return 0;
            }
            case 210: {
                this.jj_consume_token(210);
                return 1;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(265);
                return 2;
            }
            case 220: {
                this.jj_consume_token(220);
                switch (this.jj_nt.kind) {
                    case 184: {
                        this.jj_consume_token(184);
                        return 3;
                    }
                    case 112: {
                        this.jj_consume_token(112);
                        return 4;
                    }
                }
                this.jj_la1[276] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[277] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void columnConstraintDefinition(DataTypeDescriptor dataTypeDescriptor, TableElementList tableElementList, String string) throws ParseException, StandardException {
        TableName tableName = null;
        switch (this.jj_nt.kind) {
            case 94: {
                tableName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[278] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode constraintDefinitionNode = this.columnConstraint(tableName, dataTypeDescriptor, string);
        if (constraintDefinitionNode == null) {
            return;
        }
        tableElementList.addTableElement(constraintDefinitionNode);
    }

    public final ConstraintDefinitionNode columnConstraint(TableName tableName, DataTypeDescriptor dataTypeDescriptor, String string) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        int[] nArray = new int[]{2, 2};
        switch (this.jj_nt.kind) {
            case 183: {
                this.jj_consume_token(183);
                this.jj_consume_token(184);
                this.explicitNotNull = true;
                if (this.explicitNull) {
                    throw StandardException.newException("42X83", string);
                }
                dataTypeDescriptor.setNullability(false);
                return null;
            }
            case 201: 
            case 245: {
                int n = this.uniqueSpecification(dataTypeDescriptor, string);
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[279] = this.jj_gen;
                    }
                }
                ResultColumnList resultColumnList2 = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
                resultColumnList2.addElement((ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager()));
                return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(n), resultColumnList2, properties, null, null, this.getContextManager());
            }
            case 208: {
                TableName tableName2 = this.referencesSpecification(resultColumnList, nArray);
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[280] = this.jj_gen;
                    }
                }
                ResultColumnList resultColumnList3 = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
                resultColumnList3.addElement((ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager()));
                ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)this.nodeFactory.getNode(119, tableName, tableName2, resultColumnList3, resultColumnList, nArray, this.getContextManager());
                if (properties != null) {
                    constraintDefinitionNode.setProperties(properties);
                }
                return constraintDefinitionNode;
            }
            case 85: {
                ConstraintDefinitionNode constraintDefinitionNode = this.checkConstraintDefinition(tableName, string);
                return constraintDefinitionNode;
            }
        }
        this.jj_la1[281] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropSchemaStatement() throws ParseException, StandardException {
        this.jj_consume_token(215);
        String string = this.identifier(128, true);
        this.jj_consume_token(210);
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(90, string, new Integer(1), this.getContextManager());
        return statementNode;
    }

    public final StatementNode alterTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        StatementNode statementNode = this.alterTableBody(tableName);
        return statementNode;
    }

    public final StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {
        char c = '\u0000';
        TableElementList tableElementList = (TableElementList)this.nodeFactory.getNode(12, this.getContextManager());
        Token token = null;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean[] blArray = new boolean[1];
        switch (this.jj_nt.kind) {
            case 360: {
                this.jj_consume_token(360);
                switch (this.jj_nt.kind) {
                    case 401: {
                        token = this.jj_consume_token(401);
                        break;
                    }
                    default: {
                        this.jj_la1[282] = this.jj_gen;
                    }
                }
                this.checkInternalFeature("COMPRESS");
                return (StatementNode)this.nodeFactory.getNode(114, tableName, new Boolean(token != null), this.getContextManager());
            }
            case 59: 
            case 62: 
            case 122: 
            case 293: {
                c = this.alterTableAction(tableElementList, nArray, nArray2, blArray);
                return (StatementNode)this.nodeFactory.getNode(114, tableName, tableElementList, new Character(c), nArray, nArray2, blArray, this.getContextManager());
            }
        }
        this.jj_la1[283] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final char alterTableAction(TableElementList tableElementList, int[] nArray, int[] nArray2, boolean[] blArray) throws ParseException, StandardException {
        char c = '\u0000';
        Object var8_6 = null;
        long[] lArray = new long[4];
        switch (this.jj_nt.kind) {
            case 59: {
                ColumnDefinitionNode columnDefinitionNode;
                TableElementNode tableElementNode;
                this.jj_consume_token(59);
                switch (this.jj_nt.kind) {
                    case 74: 
                    case 87: 
                    case 90: 
                    case 99: 
                    case 107: 
                    case 177: 
                    case 231: 
                    case 243: 
                    case 251: 
                    case 253: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 348: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 445: 
                    case 451: {
                        tableElementNode = this.addColumnDefinition(tableElementList);
                        break;
                    }
                    case 85: 
                    case 94: 
                    case 138: 
                    case 201: 
                    case 245: {
                        tableElementNode = this.tableConstraintDefinition();
                        break;
                    }
                    default: {
                        this.jj_la1[284] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (tableElementNode instanceof ColumnDefinitionNode && (columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).isAutoincrementColumn()) {
                    throw StandardException.newException("42601.S.372");
                }
                nArray[0] = 1;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
            case 62: {
                this.jj_consume_token(62);
                switch (this.jj_nt.kind) {
                    case 90: {
                        this.jj_consume_token(90);
                        break;
                    }
                    default: {
                        this.jj_la1[285] = this.jj_gen;
                    }
                }
                String string = this.identifier(128, true);
                TableElementNode tableElementNode = this.columnAlterClause(string);
                nArray[0] = 3;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
            case 122: {
                TableElementNode tableElementNode;
                this.jj_consume_token(122);
                switch (this.jj_nt.kind) {
                    case 74: 
                    case 87: 
                    case 90: 
                    case 99: 
                    case 107: 
                    case 177: 
                    case 231: 
                    case 243: 
                    case 251: 
                    case 253: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 348: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 445: 
                    case 451: {
                        tableElementNode = this.dropColumnDefinition(nArray2);
                        break;
                    }
                    default: {
                        this.jj_la1[286] = this.jj_gen;
                        if (this.jj_2_51(1)) {
                            tableElementNode = this.dropTableConstraintDefinition();
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                nArray[0] = 2;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
            case 293: {
                c = this.DB2lockGranularityClause();
                nArray[0] = 4;
                return c;
            }
        }
        this.jj_la1[287] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode dropColumnDefinition(int[] nArray) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[288] = this.jj_gen;
            }
        }
        String string = this.identifier(128, true);
        this.dropColumnReferentialAction(nArray);
        return (TableElementNode)this.nodeFactory.getNode(113, string, null, null, null, this.getContextManager());
    }

    public final void dropColumnReferentialAction(int[] nArray) throws ParseException {
        int n = 0;
        block0 : switch (this.jj_nt.kind) {
            case 78: 
            case 210: {
                switch (this.jj_nt.kind) {
                    case 78: {
                        this.jj_consume_token(78);
                        n = 0;
                        break block0;
                    }
                    case 210: {
                        this.jj_consume_token(210);
                        n = 1;
                        break block0;
                    }
                }
                this.jj_la1[289] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[290] = this.jj_gen;
            }
        }
        nArray[0] = n;
    }

    public final TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[291] = this.jj_gen;
            }
        }
        TableElementNode tableElementNode = this.columnDefinition(tableElementList);
        return tableElementNode;
    }

    public final TableElementNode columnAlterClause(String string) throws ParseException, StandardException {
        long[] lArray = new long[4];
        long l = 1L;
        long l2 = 1L;
        DataTypeDescriptor dataTypeDescriptor = null;
        if (this.getToken((int)2).kind == 275) {
            this.jj_consume_token(220);
            this.jj_consume_token(275);
            this.jj_consume_token(336);
            dataTypeDescriptor = this.dataTypeDDL();
            return (TableElementNode)this.nodeFactory.getNode(186, string, null, dataTypeDescriptor, null, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 283) {
            this.jj_consume_token(220);
            this.jj_consume_token(283);
            this.jj_consume_token(77);
            lArray[1] = l = this.exactNumber();
            lArray[3] = 2L;
            return (TableElementNode)this.nodeFactory.getNode(97, string, null, null, lArray, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 311: {
                this.jj_consume_token(311);
                this.jj_consume_token(259);
                lArray[0] = l2 = this.exactNumber();
                lArray[3] = 1L;
                return (TableElementNode)this.nodeFactory.getNode(97, string, null, null, lArray, this.getContextManager());
            }
        }
        this.jj_la1[292] = this.jj_gen;
        if (this.getToken((int)1).kind == 259 || this.getToken((int)1).kind == 112) {
            ValueNode valueNode = this.defaultClause(lArray, string);
            if (lArray[2] == 0L) {
                lArray = null;
            }
            return (TableElementNode)this.nodeFactory.getNode(97, string, valueNode, null, lArray, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 184) {
            this.jj_consume_token(184);
            return (TableElementNode)this.nodeFactory.getNode(187, string, null, null, null, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 183) {
            this.jj_consume_token(183);
            this.jj_consume_token(184);
            return (TableElementNode)this.nodeFactory.getNode(193, string, null, null, null, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 94) {
            this.jj_consume_token(94);
            TableName tableName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 201) {
            this.jj_consume_token(201);
            this.jj_consume_token(167);
            return (TableElementNode)this.nodeFactory.getNode(131, null, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 138) {
            this.jj_consume_token(138);
            this.jj_consume_token(167);
            TableName tableName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(6), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 245) {
            this.jj_consume_token(245);
            TableName tableName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(3), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 85: {
                this.jj_consume_token(85);
                TableName tableName = this.qualifiedName(128);
                return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(4), this.getContextManager());
            }
        }
        this.jj_la1[293] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(91, tableName, new Integer(2), this.getContextManager());
    }

    public final StatementNode dropIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(371);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(63, tableName, this.getContextManager());
    }

    public final StatementNode dropAliasStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 204: {
                this.jj_consume_token(204);
                TableName tableName = this.qualifiedName(128);
                return this.dropAliasNode(tableName, 'P');
            }
            case 142: {
                this.jj_consume_token(142);
                TableName tableName = this.qualifiedName(128);
                return this.dropAliasNode(tableName, 'F');
            }
            case 329: {
                this.jj_consume_token(329);
                TableName tableName = this.qualifiedName(128);
                this.checkVersion(130, "DROP SYNONYM");
                return this.dropAliasNode(tableName, 'S');
            }
        }
        this.jj_la1[294] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropViewStatement() throws ParseException, StandardException {
        this.jj_consume_token(256);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(92, tableName, this.getContextManager());
    }

    public final StatementNode dropTriggerStatement() throws ParseException, StandardException {
        this.jj_consume_token(410);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(65, tableName, this.getContextManager());
    }

    public final StatementNode truncateTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(335);
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(114, tableName, this.getContextManager());
    }

    public final StatementNode grantStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(147);
        this.checkVersion(140, "GRANT");
        this.checkSqlStandardAccess("GRANT");
        switch (this.jj_nt.kind) {
            case 60: 
            case 115: 
            case 159: 
            case 208: 
            case 218: 
            case 247: 
            case 410: {
                statementNode = this.tableGrantStatement();
                break;
            }
            case 130: {
                statementNode = this.routineGrantStatement();
                break;
            }
            default: {
                this.jj_la1[295] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode tableGrantStatement() throws ParseException, StandardException {
        PrivilegeNode privilegeNode = this.tablePrivileges();
        this.jj_consume_token(236);
        List list = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(89, privilegeNode, list, this.getContextManager());
    }

    public final PrivilegeNode tablePrivileges() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = null;
        TableName tableName = null;
        tablePrivilegesNode = this.tableActions();
        this.jj_consume_token(188);
        switch (this.jj_nt.kind) {
            case 232: {
                this.jj_consume_token(232);
                break;
            }
            default: {
                this.jj_la1[296] = this.jj_gen;
            }
        }
        tableName = this.qualifiedName(128);
        return (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(0), tableName, tablePrivilegesNode, this.getContextManager());
    }

    public final TablePrivilegesNode tableActions() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = (TablePrivilegesNode)this.nodeFactory.getNode(106, this.getContextManager());
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(203);
                tablePrivilegesNode.addAll();
                return tablePrivilegesNode;
            }
            case 115: 
            case 159: 
            case 208: 
            case 218: 
            case 247: 
            case 410: {
                this.tableAction(tablePrivilegesNode);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 424: {
                            break;
                        }
                        default: {
                            this.jj_la1[297] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(424);
                    this.tableAction(tablePrivilegesNode);
                }
                return tablePrivilegesNode;
            }
        }
        this.jj_la1[298] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode routineGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(130);
        this.jj_consume_token(188);
        RoutineDesignator routineDesignator = this.routineDesignator();
        this.jj_consume_token(236);
        List list = this.granteeList();
        PrivilegeNode privilegeNode = (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(1), routineDesignator, null, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(89, privilegeNode, list, this.getContextManager());
    }

    public final RoutineDesignator routineDesignator() throws ParseException, StandardException {
        Token token;
        Object var2_1 = null;
        TableName tableName = null;
        List list = null;
        switch (this.jj_nt.kind) {
            case 142: {
                token = this.jj_consume_token(142);
                break;
            }
            case 204: {
                token = this.jj_consume_token(204);
                break;
            }
            default: {
                this.jj_la1[299] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                list = this.parameterTypeList();
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[300] = this.jj_gen;
            }
        }
        return new RoutineDesignator(false, tableName, token.kind == 142, list);
    }

    public final List parameterTypeList() throws ParseException, StandardException {
        ArrayList<DataTypeDescriptor> arrayList = new ArrayList<DataTypeDescriptor>();
        if (this.jj_2_52(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
            arrayList.add(dataTypeDescriptor);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[301] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                dataTypeDescriptor = this.dataTypeCommon();
                arrayList.add(dataTypeDescriptor);
            }
        }
        return arrayList;
    }

    public final void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        switch (this.jj_nt.kind) {
            case 218: {
                this.jj_consume_token(218);
                switch (this.jj_nt.kind) {
                    case 420: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[302] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(0, resultColumnList);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                tablePrivilegesNode.addAction(1, null);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                tablePrivilegesNode.addAction(2, null);
                break;
            }
            case 247: {
                this.jj_consume_token(247);
                switch (this.jj_nt.kind) {
                    case 420: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[303] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(3, resultColumnList);
                break;
            }
            case 208: {
                this.jj_consume_token(208);
                switch (this.jj_nt.kind) {
                    case 420: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[304] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(4, resultColumnList);
                break;
            }
            case 410: {
                this.jj_consume_token(410);
                tablePrivilegesNode.addAction(5, null);
                break;
            }
            default: {
                this.jj_la1[305] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ResultColumnList privilegeColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.jj_consume_token(420);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(421);
        return resultColumnList;
    }

    public final List granteeList() throws ParseException, StandardException {
        ArrayList arrayList = new ArrayList();
        this.grantee(arrayList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[306] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.grantee(arrayList);
        }
        return arrayList;
    }

    public final void grantee(List list) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String string = this.identifier(128, true);
                this.checkAuthorizationLength(string);
                list.add(string);
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                list.add("PUBLIC");
                break;
            }
            default: {
                this.jj_la1[307] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode revokeStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(211);
        this.checkVersion(140, "REVOKE");
        this.checkSqlStandardAccess("REVOKE");
        switch (this.jj_nt.kind) {
            case 60: 
            case 115: 
            case 159: 
            case 208: 
            case 218: 
            case 247: 
            case 410: {
                statementNode = this.tableRevokeStatement();
                break;
            }
            case 130: {
                statementNode = this.routineRevokeStatement();
                break;
            }
            default: {
                this.jj_la1[308] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode tableRevokeStatement() throws ParseException, StandardException {
        PrivilegeNode privilegeNode = null;
        privilegeNode = this.tablePrivileges();
        this.jj_consume_token(140);
        List list = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(86, privilegeNode, list, this.getContextManager());
    }

    public final StatementNode routineRevokeStatement() throws ParseException, StandardException {
        RoutineDesignator routineDesignator = null;
        this.jj_consume_token(130);
        this.jj_consume_token(188);
        routineDesignator = this.routineDesignator();
        this.jj_consume_token(140);
        List list = this.granteeList();
        this.jj_consume_token(210);
        PrivilegeNode privilegeNode = (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(1), routineDesignator, null, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(86, privilegeNode, list, this.getContextManager());
    }

    public final String internalIdentifier(int n, boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 445: {
                Token token = this.jj_consume_token(445);
                String string = StringUtil.SQLToUpperCase(token.image);
                if (bl) {
                    this.checkIdentifierLengthLimit(string, n);
                }
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = Boolean.FALSE;
                this.nextToLastIdentifierToken = this.lastIdentifierToken;
                this.lastIdentifierToken = token;
                return string;
            }
            case 451: {
                String string = this.delimitedIdentifier();
                if (bl) {
                    this.checkIdentifierLengthLimit(string, n);
                }
                return string;
            }
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: {
                String string = this.nonReservedKeyword();
                return StringUtil.SQLToUpperCase(string);
            }
        }
        this.jj_la1[309] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier(int n, boolean bl) throws ParseException, StandardException {
        String string = this.internalIdentifier(n, bl);
        return string;
    }

    public final String delimitedIdentifier() throws ParseException {
        Token token = this.jj_consume_token(451);
        String string = token.image.substring(1, token.image.length() - 1);
        string = SQLParser.normalizeDelimitedID(string);
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.TRUE;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = token;
        return string;
    }

    public final String reservedKeyword() throws ParseException {
        Token token;
        switch (this.jj_nt.kind) {
            case 59: {
                token = this.jj_consume_token(59);
                break;
            }
            case 60: {
                token = this.jj_consume_token(60);
                break;
            }
            case 61: {
                token = this.jj_consume_token(61);
                break;
            }
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 63: {
                token = this.jj_consume_token(63);
                break;
            }
            case 64: {
                token = this.jj_consume_token(64);
                break;
            }
            case 65: {
                token = this.jj_consume_token(65);
                break;
            }
            case 66: {
                token = this.jj_consume_token(66);
                break;
            }
            case 67: {
                token = this.jj_consume_token(67);
                break;
            }
            case 68: {
                token = this.jj_consume_token(68);
                break;
            }
            case 69: {
                token = this.jj_consume_token(69);
                break;
            }
            case 70: {
                token = this.jj_consume_token(70);
                break;
            }
            case 71: {
                token = this.jj_consume_token(71);
                break;
            }
            case 72: {
                token = this.jj_consume_token(72);
                break;
            }
            case 73: {
                token = this.jj_consume_token(73);
                break;
            }
            case 75: {
                token = this.jj_consume_token(75);
                break;
            }
            case 76: {
                token = this.jj_consume_token(76);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            case 78: {
                token = this.jj_consume_token(78);
                break;
            }
            case 79: {
                token = this.jj_consume_token(79);
                break;
            }
            case 80: {
                token = this.jj_consume_token(80);
                break;
            }
            case 81: {
                token = this.jj_consume_token(81);
                break;
            }
            case 82: {
                token = this.jj_consume_token(82);
                break;
            }
            case 83: {
                token = this.jj_consume_token(83);
                break;
            }
            case 85: {
                token = this.jj_consume_token(85);
                break;
            }
            case 86: {
                token = this.jj_consume_token(86);
                break;
            }
            case 88: {
                token = this.jj_consume_token(88);
                break;
            }
            case 89: {
                token = this.jj_consume_token(89);
                break;
            }
            case 90: {
                token = this.jj_consume_token(90);
                break;
            }
            case 91: {
                token = this.jj_consume_token(91);
                break;
            }
            case 92: {
                token = this.jj_consume_token(92);
                break;
            }
            case 93: {
                token = this.jj_consume_token(93);
                break;
            }
            case 94: {
                token = this.jj_consume_token(94);
                break;
            }
            case 95: {
                token = this.jj_consume_token(95);
                break;
            }
            case 96: {
                token = this.jj_consume_token(96);
                break;
            }
            case 97: {
                token = this.jj_consume_token(97);
                break;
            }
            case 98: {
                token = this.jj_consume_token(98);
                break;
            }
            case 100: {
                token = this.jj_consume_token(100);
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            case 102: {
                token = this.jj_consume_token(102);
                break;
            }
            case 103: {
                token = this.jj_consume_token(103);
                break;
            }
            case 104: {
                token = this.jj_consume_token(104);
                break;
            }
            case 105: {
                token = this.jj_consume_token(105);
                break;
            }
            case 106: {
                token = this.jj_consume_token(106);
                break;
            }
            case 108: {
                token = this.jj_consume_token(108);
                break;
            }
            case 109: {
                token = this.jj_consume_token(109);
                break;
            }
            case 110: {
                token = this.jj_consume_token(110);
                break;
            }
            case 111: {
                token = this.jj_consume_token(111);
                break;
            }
            case 112: {
                token = this.jj_consume_token(112);
                break;
            }
            case 113: {
                token = this.jj_consume_token(113);
                break;
            }
            case 114: {
                token = this.jj_consume_token(114);
                break;
            }
            case 115: {
                token = this.jj_consume_token(115);
                break;
            }
            case 116: {
                token = this.jj_consume_token(116);
                break;
            }
            case 117: {
                token = this.jj_consume_token(117);
                break;
            }
            case 118: {
                token = this.jj_consume_token(118);
                break;
            }
            case 119: {
                token = this.jj_consume_token(119);
                break;
            }
            case 120: {
                token = this.jj_consume_token(120);
                break;
            }
            case 121: {
                token = this.jj_consume_token(121);
                break;
            }
            case 122: {
                token = this.jj_consume_token(122);
                break;
            }
            case 123: {
                token = this.jj_consume_token(123);
                break;
            }
            case 124: {
                token = this.jj_consume_token(124);
                break;
            }
            case 125: {
                token = this.jj_consume_token(125);
                break;
            }
            case 126: {
                token = this.jj_consume_token(126);
                break;
            }
            case 127: {
                token = this.jj_consume_token(127);
                break;
            }
            case 128: {
                token = this.jj_consume_token(128);
                break;
            }
            case 129: {
                token = this.jj_consume_token(129);
                break;
            }
            case 130: {
                token = this.jj_consume_token(130);
                break;
            }
            case 131: {
                token = this.jj_consume_token(131);
                break;
            }
            case 132: {
                token = this.jj_consume_token(132);
                break;
            }
            case 133: {
                token = this.jj_consume_token(133);
                break;
            }
            case 134: {
                token = this.jj_consume_token(134);
                break;
            }
            case 135: {
                token = this.jj_consume_token(135);
                break;
            }
            case 136: {
                token = this.jj_consume_token(136);
                break;
            }
            case 137: {
                token = this.jj_consume_token(137);
                break;
            }
            case 138: {
                token = this.jj_consume_token(138);
                break;
            }
            case 139: {
                token = this.jj_consume_token(139);
                break;
            }
            case 140: {
                token = this.jj_consume_token(140);
                break;
            }
            case 141: {
                token = this.jj_consume_token(141);
                break;
            }
            case 142: {
                token = this.jj_consume_token(142);
                break;
            }
            case 143: {
                token = this.jj_consume_token(143);
                break;
            }
            case 345: {
                token = this.jj_consume_token(345);
                break;
            }
            case 144: {
                token = this.jj_consume_token(144);
                break;
            }
            case 145: {
                token = this.jj_consume_token(145);
                break;
            }
            case 146: {
                token = this.jj_consume_token(146);
                break;
            }
            case 147: {
                token = this.jj_consume_token(147);
                break;
            }
            case 148: {
                token = this.jj_consume_token(148);
                break;
            }
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 150: {
                token = this.jj_consume_token(150);
                break;
            }
            case 151: {
                token = this.jj_consume_token(151);
                break;
            }
            case 152: {
                token = this.jj_consume_token(152);
                break;
            }
            case 153: {
                token = this.jj_consume_token(153);
                break;
            }
            case 154: {
                token = this.jj_consume_token(154);
                break;
            }
            case 155: {
                token = this.jj_consume_token(155);
                break;
            }
            case 156: {
                token = this.jj_consume_token(156);
                break;
            }
            case 285: {
                token = this.jj_consume_token(285);
                break;
            }
            case 157: {
                token = this.jj_consume_token(157);
                break;
            }
            case 158: {
                token = this.jj_consume_token(158);
                break;
            }
            case 159: {
                token = this.jj_consume_token(159);
                break;
            }
            case 160: {
                token = this.jj_consume_token(160);
                break;
            }
            case 161: {
                token = this.jj_consume_token(161);
                break;
            }
            case 162: {
                token = this.jj_consume_token(162);
                break;
            }
            case 163: {
                token = this.jj_consume_token(163);
                break;
            }
            case 164: {
                token = this.jj_consume_token(164);
                break;
            }
            case 165: {
                token = this.jj_consume_token(165);
                break;
            }
            case 166: {
                token = this.jj_consume_token(166);
                break;
            }
            case 167: {
                token = this.jj_consume_token(167);
                break;
            }
            case 168: {
                token = this.jj_consume_token(168);
                break;
            }
            case 169: {
                token = this.jj_consume_token(169);
                break;
            }
            case 170: {
                token = this.jj_consume_token(170);
                break;
            }
            case 171: {
                token = this.jj_consume_token(171);
                break;
            }
            case 172: {
                token = this.jj_consume_token(172);
                break;
            }
            case 173: {
                token = this.jj_consume_token(173);
                break;
            }
            case 174: {
                token = this.jj_consume_token(174);
                break;
            }
            case 175: {
                token = this.jj_consume_token(175);
                break;
            }
            case 176: {
                token = this.jj_consume_token(176);
                break;
            }
            case 178: {
                token = this.jj_consume_token(178);
                break;
            }
            case 179: {
                token = this.jj_consume_token(179);
                break;
            }
            case 180: {
                token = this.jj_consume_token(180);
                break;
            }
            case 381: {
                token = this.jj_consume_token(381);
                break;
            }
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 182: {
                token = this.jj_consume_token(182);
                break;
            }
            case 183: {
                token = this.jj_consume_token(183);
                break;
            }
            case 184: {
                token = this.jj_consume_token(184);
                break;
            }
            case 185: {
                token = this.jj_consume_token(185);
                break;
            }
            case 186: {
                token = this.jj_consume_token(186);
                break;
            }
            case 187: {
                token = this.jj_consume_token(187);
                break;
            }
            case 188: {
                token = this.jj_consume_token(188);
                break;
            }
            case 189: {
                token = this.jj_consume_token(189);
                break;
            }
            case 190: {
                token = this.jj_consume_token(190);
                break;
            }
            case 191: {
                token = this.jj_consume_token(191);
                break;
            }
            case 192: {
                token = this.jj_consume_token(192);
                break;
            }
            case 193: {
                token = this.jj_consume_token(193);
                break;
            }
            case 386: {
                token = this.jj_consume_token(386);
                break;
            }
            case 194: {
                token = this.jj_consume_token(194);
                break;
            }
            case 195: {
                token = this.jj_consume_token(195);
                break;
            }
            case 196: {
                token = this.jj_consume_token(196);
                break;
            }
            case 197: {
                token = this.jj_consume_token(197);
                break;
            }
            case 198: {
                token = this.jj_consume_token(198);
                break;
            }
            case 199: {
                token = this.jj_consume_token(199);
                break;
            }
            case 200: {
                token = this.jj_consume_token(200);
                break;
            }
            case 201: {
                token = this.jj_consume_token(201);
                break;
            }
            case 202: {
                token = this.jj_consume_token(202);
                break;
            }
            case 203: {
                token = this.jj_consume_token(203);
                break;
            }
            case 204: {
                token = this.jj_consume_token(204);
                break;
            }
            case 205: {
                token = this.jj_consume_token(205);
                break;
            }
            case 206: {
                token = this.jj_consume_token(206);
                break;
            }
            case 207: {
                token = this.jj_consume_token(207);
                break;
            }
            case 208: {
                token = this.jj_consume_token(208);
                break;
            }
            case 209: {
                token = this.jj_consume_token(209);
                break;
            }
            case 210: {
                token = this.jj_consume_token(210);
                break;
            }
            case 211: {
                token = this.jj_consume_token(211);
                break;
            }
            case 212: {
                token = this.jj_consume_token(212);
                break;
            }
            case 213: {
                token = this.jj_consume_token(213);
                break;
            }
            case 214: {
                token = this.jj_consume_token(214);
                break;
            }
            case 215: {
                token = this.jj_consume_token(215);
                break;
            }
            case 216: {
                token = this.jj_consume_token(216);
                break;
            }
            case 217: {
                token = this.jj_consume_token(217);
                break;
            }
            case 218: {
                token = this.jj_consume_token(218);
                break;
            }
            case 219: {
                token = this.jj_consume_token(219);
                break;
            }
            case 220: {
                token = this.jj_consume_token(220);
                break;
            }
            case 221: {
                token = this.jj_consume_token(221);
                break;
            }
            case 222: {
                token = this.jj_consume_token(222);
                break;
            }
            case 223: {
                token = this.jj_consume_token(223);
                break;
            }
            case 224: {
                token = this.jj_consume_token(224);
                break;
            }
            case 225: {
                token = this.jj_consume_token(225);
                break;
            }
            case 226: {
                token = this.jj_consume_token(226);
                break;
            }
            case 227: {
                token = this.jj_consume_token(227);
                break;
            }
            case 228: {
                token = this.jj_consume_token(228);
                break;
            }
            case 229: {
                token = this.jj_consume_token(229);
                break;
            }
            case 230: {
                token = this.jj_consume_token(230);
                break;
            }
            case 232: {
                token = this.jj_consume_token(232);
                break;
            }
            case 233: {
                token = this.jj_consume_token(233);
                break;
            }
            case 234: {
                token = this.jj_consume_token(234);
                break;
            }
            case 235: {
                token = this.jj_consume_token(235);
                break;
            }
            case 236: {
                token = this.jj_consume_token(236);
                break;
            }
            case 240: {
                token = this.jj_consume_token(240);
                break;
            }
            case 237: {
                token = this.jj_consume_token(237);
                break;
            }
            case 238: {
                token = this.jj_consume_token(238);
                break;
            }
            case 239: {
                token = this.jj_consume_token(239);
                break;
            }
            case 242: {
                token = this.jj_consume_token(242);
                break;
            }
            case 244: {
                token = this.jj_consume_token(244);
                break;
            }
            case 245: {
                token = this.jj_consume_token(245);
                break;
            }
            case 246: {
                token = this.jj_consume_token(246);
                break;
            }
            case 247: {
                token = this.jj_consume_token(247);
                break;
            }
            case 248: {
                token = this.jj_consume_token(248);
                break;
            }
            case 249: {
                token = this.jj_consume_token(249);
                break;
            }
            case 250: {
                token = this.jj_consume_token(250);
                break;
            }
            case 252: {
                token = this.jj_consume_token(252);
                break;
            }
            case 254: {
                token = this.jj_consume_token(254);
                break;
            }
            case 255: {
                token = this.jj_consume_token(255);
                break;
            }
            case 256: {
                token = this.jj_consume_token(256);
                break;
            }
            case 257: {
                token = this.jj_consume_token(257);
                break;
            }
            case 258: {
                token = this.jj_consume_token(258);
                break;
            }
            case 259: {
                token = this.jj_consume_token(259);
                break;
            }
            case 260: {
                token = this.jj_consume_token(260);
                break;
            }
            case 261: {
                token = this.jj_consume_token(261);
                break;
            }
            case 262: {
                token = this.jj_consume_token(262);
                break;
            }
            case 340: {
                token = this.jj_consume_token(340);
                break;
            }
            case 341: {
                token = this.jj_consume_token(341);
                break;
            }
            case 346: {
                token = this.jj_consume_token(346);
                break;
            }
            case 347: {
                token = this.jj_consume_token(347);
                break;
            }
            case 349: {
                token = this.jj_consume_token(349);
                break;
            }
            case 350: {
                token = this.jj_consume_token(350);
                break;
            }
            case 241: {
                token = this.jj_consume_token(241);
                break;
            }
            case 351: {
                token = this.jj_consume_token(351);
                break;
            }
            case 352: {
                token = this.jj_consume_token(352);
                break;
            }
            case 354: {
                token = this.jj_consume_token(354);
                break;
            }
            case 356: {
                token = this.jj_consume_token(356);
                break;
            }
            case 353: {
                token = this.jj_consume_token(353);
                break;
            }
            case 355: {
                token = this.jj_consume_token(355);
                break;
            }
            default: {
                this.jj_la1[310] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.FALSE;
        return token.image;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token token;
        switch (this.jj_nt.kind) {
            case 263: {
                token = this.jj_consume_token(263);
                break;
            }
            case 264: {
                token = this.jj_consume_token(264);
                break;
            }
            case 265: {
                token = this.jj_consume_token(265);
                break;
            }
            case 357: {
                token = this.jj_consume_token(357);
                break;
            }
            case 266: {
                token = this.jj_consume_token(266);
                break;
            }
            case 358: {
                token = this.jj_consume_token(358);
                break;
            }
            case 74: {
                token = this.jj_consume_token(74);
                break;
            }
            case 267: {
                token = this.jj_consume_token(267);
                break;
            }
            case 268: {
                token = this.jj_consume_token(268);
                break;
            }
            case 269: {
                token = this.jj_consume_token(269);
                break;
            }
            case 359: {
                token = this.jj_consume_token(359);
                break;
            }
            case 270: {
                token = this.jj_consume_token(270);
                break;
            }
            case 87: {
                token = this.jj_consume_token(87);
                break;
            }
            case 271: {
                token = this.jj_consume_token(271);
                break;
            }
            case 272: {
                token = this.jj_consume_token(272);
                break;
            }
            case 360: {
                token = this.jj_consume_token(360);
                break;
            }
            case 273: {
                token = this.jj_consume_token(273);
                break;
            }
            case 274: {
                token = this.jj_consume_token(274);
                break;
            }
            case 361: {
                token = this.jj_consume_token(361);
                break;
            }
            case 99: {
                token = this.jj_consume_token(99);
                break;
            }
            case 362: {
                token = this.jj_consume_token(362);
                break;
            }
            case 342: {
                token = this.jj_consume_token(342);
                break;
            }
            case 343: {
                token = this.jj_consume_token(343);
                break;
            }
            case 107: {
                token = this.jj_consume_token(107);
                break;
            }
            case 275: {
                token = this.jj_consume_token(275);
                break;
            }
            case 276: {
                token = this.jj_consume_token(276);
                break;
            }
            case 277: {
                token = this.jj_consume_token(277);
                break;
            }
            case 365: {
                token = this.jj_consume_token(365);
                break;
            }
            case 279: {
                token = this.jj_consume_token(279);
                break;
            }
            case 344: {
                token = this.jj_consume_token(344);
                break;
            }
            case 364: {
                token = this.jj_consume_token(364);
                break;
            }
            case 366: {
                token = this.jj_consume_token(366);
                break;
            }
            case 367: {
                token = this.jj_consume_token(367);
                break;
            }
            case 368: {
                token = this.jj_consume_token(368);
                break;
            }
            case 369: {
                token = this.jj_consume_token(369);
                break;
            }
            case 370: {
                token = this.jj_consume_token(370);
                break;
            }
            case 280: {
                token = this.jj_consume_token(280);
                break;
            }
            case 281: {
                token = this.jj_consume_token(281);
                break;
            }
            case 282: {
                token = this.jj_consume_token(282);
                break;
            }
            case 283: {
                token = this.jj_consume_token(283);
                break;
            }
            case 371: {
                token = this.jj_consume_token(371);
                break;
            }
            case 284: {
                token = this.jj_consume_token(284);
                break;
            }
            case 286: {
                token = this.jj_consume_token(286);
                break;
            }
            case 372: {
                token = this.jj_consume_token(372);
                break;
            }
            case 288: {
                token = this.jj_consume_token(288);
                break;
            }
            case 289: {
                token = this.jj_consume_token(289);
                break;
            }
            case 373: {
                token = this.jj_consume_token(373);
                break;
            }
            case 290: {
                token = this.jj_consume_token(290);
                break;
            }
            case 291: {
                token = this.jj_consume_token(291);
                break;
            }
            case 374: {
                token = this.jj_consume_token(374);
                break;
            }
            case 375: {
                token = this.jj_consume_token(375);
                break;
            }
            case 292: {
                token = this.jj_consume_token(292);
                break;
            }
            case 293: {
                token = this.jj_consume_token(293);
                break;
            }
            case 294: {
                token = this.jj_consume_token(294);
                break;
            }
            case 348: {
                token = this.jj_consume_token(348);
                break;
            }
            case 376: {
                token = this.jj_consume_token(376);
                break;
            }
            case 377: {
                token = this.jj_consume_token(377);
                break;
            }
            case 295: {
                token = this.jj_consume_token(295);
                break;
            }
            case 378: {
                token = this.jj_consume_token(378);
                break;
            }
            case 296: {
                token = this.jj_consume_token(296);
                break;
            }
            case 297: {
                token = this.jj_consume_token(297);
                break;
            }
            case 177: {
                token = this.jj_consume_token(177);
                break;
            }
            case 298: {
                token = this.jj_consume_token(298);
                break;
            }
            case 299: {
                token = this.jj_consume_token(299);
                break;
            }
            case 300: {
                token = this.jj_consume_token(300);
                break;
            }
            case 301: {
                token = this.jj_consume_token(301);
                break;
            }
            case 302: {
                token = this.jj_consume_token(302);
                break;
            }
            case 379: {
                token = this.jj_consume_token(379);
                break;
            }
            case 380: {
                token = this.jj_consume_token(380);
                break;
            }
            case 303: {
                token = this.jj_consume_token(303);
                break;
            }
            case 304: {
                token = this.jj_consume_token(304);
                break;
            }
            case 305: {
                token = this.jj_consume_token(305);
                break;
            }
            case 383: {
                token = this.jj_consume_token(383);
                break;
            }
            case 384: {
                token = this.jj_consume_token(384);
                break;
            }
            case 385: {
                token = this.jj_consume_token(385);
                break;
            }
            case 382: {
                token = this.jj_consume_token(382);
                break;
            }
            case 306: {
                token = this.jj_consume_token(306);
                break;
            }
            case 388: {
                token = this.jj_consume_token(388);
                break;
            }
            case 307: {
                token = this.jj_consume_token(307);
                break;
            }
            case 308: {
                token = this.jj_consume_token(308);
                break;
            }
            case 389: {
                token = this.jj_consume_token(389);
                break;
            }
            case 390: {
                token = this.jj_consume_token(390);
                break;
            }
            case 391: {
                token = this.jj_consume_token(391);
                break;
            }
            case 309: {
                token = this.jj_consume_token(309);
                break;
            }
            case 393: {
                token = this.jj_consume_token(393);
                break;
            }
            case 310: {
                token = this.jj_consume_token(310);
                break;
            }
            case 392: {
                token = this.jj_consume_token(392);
                break;
            }
            case 394: {
                token = this.jj_consume_token(394);
                break;
            }
            case 311: {
                token = this.jj_consume_token(311);
                break;
            }
            case 395: {
                token = this.jj_consume_token(395);
                break;
            }
            case 396: {
                token = this.jj_consume_token(396);
                break;
            }
            case 397: {
                token = this.jj_consume_token(397);
                break;
            }
            case 312: {
                token = this.jj_consume_token(312);
                break;
            }
            case 313: {
                token = this.jj_consume_token(313);
                break;
            }
            case 398: {
                token = this.jj_consume_token(398);
                break;
            }
            case 399: {
                token = this.jj_consume_token(399);
                break;
            }
            case 315: {
                token = this.jj_consume_token(315);
                break;
            }
            case 314: {
                token = this.jj_consume_token(314);
                break;
            }
            case 400: {
                token = this.jj_consume_token(400);
                break;
            }
            case 401: {
                token = this.jj_consume_token(401);
                break;
            }
            case 317: {
                token = this.jj_consume_token(317);
                break;
            }
            case 402: {
                token = this.jj_consume_token(402);
                break;
            }
            case 403: {
                token = this.jj_consume_token(403);
                break;
            }
            case 405: {
                token = this.jj_consume_token(405);
                break;
            }
            case 404: {
                token = this.jj_consume_token(404);
                break;
            }
            case 318: {
                token = this.jj_consume_token(318);
                break;
            }
            case 319: {
                token = this.jj_consume_token(319);
                break;
            }
            case 320: {
                token = this.jj_consume_token(320);
                break;
            }
            case 321: {
                token = this.jj_consume_token(321);
                break;
            }
            case 322: {
                token = this.jj_consume_token(322);
                break;
            }
            case 323: {
                token = this.jj_consume_token(323);
                break;
            }
            case 324: {
                token = this.jj_consume_token(324);
                break;
            }
            case 325: {
                token = this.jj_consume_token(325);
                break;
            }
            case 326: {
                token = this.jj_consume_token(326);
                break;
            }
            case 406: {
                token = this.jj_consume_token(406);
                break;
            }
            case 407: {
                token = this.jj_consume_token(407);
                break;
            }
            case 327: {
                token = this.jj_consume_token(327);
                break;
            }
            case 328: {
                token = this.jj_consume_token(328);
                break;
            }
            case 408: {
                token = this.jj_consume_token(408);
                break;
            }
            case 329: {
                token = this.jj_consume_token(329);
                break;
            }
            case 409: {
                token = this.jj_consume_token(409);
                break;
            }
            case 231: {
                token = this.jj_consume_token(231);
                break;
            }
            case 330: {
                token = this.jj_consume_token(330);
                break;
            }
            case 331: {
                token = this.jj_consume_token(331);
                break;
            }
            case 332: {
                token = this.jj_consume_token(332);
                break;
            }
            case 333: {
                token = this.jj_consume_token(333);
                break;
            }
            case 334: {
                token = this.jj_consume_token(334);
                break;
            }
            case 410: {
                token = this.jj_consume_token(410);
                break;
            }
            case 335: {
                token = this.jj_consume_token(335);
                break;
            }
            case 243: {
                token = this.jj_consume_token(243);
                break;
            }
            case 336: {
                token = this.jj_consume_token(336);
                break;
            }
            case 411: {
                token = this.jj_consume_token(411);
                break;
            }
            case 337: {
                token = this.jj_consume_token(337);
                break;
            }
            case 412: {
                token = this.jj_consume_token(412);
                break;
            }
            case 338: {
                token = this.jj_consume_token(338);
                break;
            }
            case 251: {
                token = this.jj_consume_token(251);
                break;
            }
            case 253: {
                token = this.jj_consume_token(253);
                break;
            }
            case 387: {
                token = this.jj_consume_token(387);
                break;
            }
            case 339: {
                token = this.jj_consume_token(339);
                break;
            }
            case 413: {
                token = this.jj_consume_token(413);
                break;
            }
            default: {
                this.jj_la1[311] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.FALSE;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = token;
        return token.image;
    }

    public final String caseSensitiveIdentifierPlusReservedWords() throws ParseException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String string = this.caseSensitiveIdentifier();
                return string;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 285: 
            case 340: 
            case 341: 
            case 345: 
            case 346: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 381: 
            case 386: {
                String string = this.reservedKeyword();
                return string;
            }
        }
        this.jj_la1[312] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String string = this.identifier(128, true);
                return string;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 285: 
            case 340: 
            case 341: 
            case 345: 
            case 346: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 381: 
            case 386: {
                String string = this.reservedKeyword();
                return StringUtil.SQLToUpperCase(string);
            }
        }
        this.jj_la1[313] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        switch (this.jj_nt.kind) {
            case 445: {
                Token token = this.jj_consume_token(445);
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = Boolean.FALSE;
                return token.image;
            }
            case 451: {
                String string = this.delimitedIdentifier();
                return string;
            }
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: {
                String string = this.nonReservedKeyword();
                return string;
            }
        }
        this.jj_la1[314] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, n);
        }
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_271() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_270() {
        return this.jj_scan_token(386);
    }

    private final boolean jj_3R_216() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_269()) {
            this.jj_scanpos = token;
            if (this.jj_3R_270()) {
                this.jj_scanpos = token;
                if (this.jj_3R_271()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_269() {
        return this.jj_scan_token(153);
    }

    private final boolean jj_3R_143() {
        return this.jj_scan_token(103);
    }

    private final boolean jj_3R_249() {
        return this.jj_scan_token(282);
    }

    private final boolean jj_3R_68() {
        return this.jj_3R_120();
    }

    private final boolean jj_3R_161() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_216()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_248() {
        return this.jj_scan_token(295);
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_195() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(82)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(83)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_141() {
        return this.jj_scan_token(102);
    }

    private final boolean jj_3R_162() {
        return this.jj_3R_217();
    }

    private final boolean jj_3R_247() {
        return this.jj_scan_token(406);
    }

    private final boolean jj_3R_246() {
        return this.jj_scan_token(264);
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_161()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_162()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_163();
    }

    private final boolean jj_3R_73() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 276;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_140()) {
            this.jj_scanpos = token;
            if (this.jj_3R_141()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 331;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_142()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_143()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 332;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_144()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_145()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_140() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_206() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_245()) {
            this.jj_scanpos = token;
            if (this.jj_3R_246()) {
                this.jj_scanpos = token;
                if (this.jj_3R_247()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_248()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_249()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_245() {
        return this.jj_scan_token(263);
    }

    private final boolean jj_3_45() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_109() {
        return this.jj_3R_195();
    }

    private final boolean jj_3R_214() {
        return this.jj_3R_217();
    }

    private final boolean jj_3_7() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3R_59() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = token;
            if (this.jj_3R_109()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_366() {
        return this.jj_scan_token(252);
    }

    private final boolean jj_3R_154() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_185() {
        return this.jj_3R_225();
    }

    private final boolean jj_3R_184() {
        return this.jj_3R_224();
    }

    private final boolean jj_3R_314() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_183() {
        return this.jj_3R_223();
    }

    private final boolean jj_3R_60() {
        return false;
    }

    private final boolean jj_3R_58() {
        return false;
    }

    private final boolean jj_3R_181() {
        return this.jj_3R_222();
    }

    private final boolean jj_3R_180() {
        return this.jj_scan_token(85);
    }

    private final boolean jj_3_13() {
        return this.jj_3R_62();
    }

    private final boolean jj_3_50() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_182() {
        return this.jj_scan_token(340);
    }

    private final boolean jj_3R_330() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(263)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(264)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(265)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(357)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(266)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(358)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(74)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(267)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(268)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(269)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(359)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(270)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(87)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(271)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(272)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(360)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(273)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(274)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(361)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(99)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(362)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(342)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(343)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(107)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(275)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(276)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(277)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(365)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(279)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(344)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(364)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(366)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(367)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(368)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(369)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(370)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(280)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(281)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(282)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(283)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(371)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(284)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(286)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(372)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(288)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(289)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(373)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(290)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(291)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(374)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(375)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(292)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(293)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(294)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(348)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(376)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(377)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(295)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(378)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(296)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(297)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(177)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(298)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(299)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(300)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(301)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(302)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(379)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(380)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(303)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(304)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(305)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(383)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(384)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(385)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(382)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(306)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(388)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(307)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(308)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(389)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(390)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(391)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(309)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(393)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(310)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(392)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(394)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(311)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(395)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(396)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(397)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(312)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(313)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(398)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(399)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(315)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(314)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(400)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(401)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(317)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(402)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(403)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(405)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(404)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(318)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(319)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(320)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(321)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(322)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(323)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(324)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(325)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(326)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(406)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(407)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(327)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(328)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(408)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(329)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(409)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(231)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(330)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(331)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(332)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(333)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(334)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(410)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(335)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(243)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(336)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(411)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(337)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(412)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(338)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(251)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(253)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(387)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(339)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(413)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_12() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind != 289;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_60()) {
            return true;
        }
        return this.jj_3R_61();
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_154();
    }

    private final boolean jj_3R_297() {
        return this.jj_3R_318();
    }

    private final boolean jj_3R_284() {
        return this.jj_scan_token(332);
    }

    private final boolean jj_3_11() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind != 289;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_58()) {
            return true;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3_38() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_179() {
        return this.jj_scan_token(245);
    }

    private final boolean jj_3R_283() {
        return this.jj_scan_token(331);
    }

    private final boolean jj_3R_90() {
        Token token = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = token;
            if (this.jj_3_12()) {
                this.jj_scanpos = token;
                if (this.jj_3_13()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_181()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_182()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_183()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_184()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_185()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_282() {
        return this.jj_scan_token(276);
    }

    private final boolean jj_3R_222() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_282()) {
            this.jj_scanpos = token;
            if (this.jj_3R_283()) {
                this.jj_scanpos = token;
                if (this.jj_3R_284()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_178() {
        return this.jj_scan_token(138);
    }

    private final boolean jj_3_20() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_303() {
        return this.jj_3R_214();
    }

    private final boolean jj_3R_218() {
        return false;
    }

    private final boolean jj_3R_226() {
        return this.jj_scan_token(115);
    }

    private final boolean jj_3_35() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_177() {
        return this.jj_scan_token(201);
    }

    private final boolean jj_3R_163() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.commonDatatypeName(false);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_218()) {
            return true;
        }
        return this.jj_3R_90();
    }

    private final boolean jj_3R_191() {
        return this.jj_3R_231();
    }

    private final boolean jj_3R_258() {
        return this.jj_scan_token(355);
    }

    private final boolean jj_3R_332() {
        return this.jj_scan_token(457);
    }

    private final boolean jj_3R_190() {
        return this.jj_3R_230();
    }

    private final boolean jj_3R_89() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 94;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_176()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 201;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_177()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 138;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_178()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 245;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_179()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_180()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_176() {
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_257() {
        return this.jj_scan_token(353);
    }

    private final boolean jj_3R_189() {
        return this.jj_3R_229();
    }

    private final boolean jj_3R_256() {
        return this.jj_scan_token(356);
    }

    private final boolean jj_3R_188() {
        return this.jj_3R_228();
    }

    private final boolean jj_3R_331() {
        return this.jj_scan_token(452);
    }

    private final boolean jj_3R_311() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_331()) {
            this.jj_scanpos = token;
            if (this.jj_3R_332()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_187() {
        return this.jj_3R_227();
    }

    private final boolean jj_3R_208() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_255()) {
            this.jj_scanpos = token;
            if (this.jj_3R_256()) {
                this.jj_scanpos = token;
                if (this.jj_3R_257()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_258()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_255() {
        return this.jj_scan_token(354);
    }

    private final boolean jj_3R_97() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_186()) {
            this.jj_scanpos = token;
            if (this.jj_3R_187()) {
                this.jj_scanpos = token;
                if (this.jj_3R_188()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_189()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_190()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_191()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_186() {
        return this.jj_3R_226();
    }

    private final boolean jj_3R_240() {
        return this.jj_scan_token(80);
    }

    private final boolean jj_3_6() {
        return this.jj_3R_53();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_277() {
        return this.jj_3R_315();
    }

    private final boolean jj_3R_147() {
        return this.jj_3R_211();
    }

    private final boolean jj_3_4() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_92() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_53();
    }

    private final boolean jj_3R_276() {
        return this.jj_3R_314();
    }

    private final boolean jj_3R_239() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3R_275() {
        return this.jj_3R_313();
    }

    private final boolean jj_3R_238() {
        return this.jj_3R_301();
    }

    private final boolean jj_3R_342() {
        return this.jj_3R_352();
    }

    private final boolean jj_3_19() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_91() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3R_43() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 220 && this.getToken((int)2).kind != 101;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_91()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 220 && this.getToken((int)2).kind == 101;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_92()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_30() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_160() {
        return this.jj_scan_token(232);
    }

    private final boolean jj_3R_274() {
        return this.jj_3R_312();
    }

    private final boolean jj_3R_201() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_237()) {
            this.jj_scanpos = token;
            if (this.jj_3R_238()) {
                this.jj_scanpos = token;
                if (this.jj_3R_239()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_240()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_237() {
        return this.jj_3R_219();
    }

    private final boolean jj_3R_310() {
        return this.jj_3R_299();
    }

    private final boolean jj_3R_219() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_273()) {
            this.jj_scanpos = token;
            if (this.jj_3R_274()) {
                this.jj_scanpos = token;
                if (this.jj_3R_275()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_276()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_277()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_273() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_311();
    }

    private final boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = token;
            if (this.jj_3_30()) {
                this.jj_scanpos = token;
                if (this.jj_3R_147()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_146() {
        return this.jj_3R_210();
    }

    private final boolean jj_3R_326() {
        Token token = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = token;
            if (this.jj_3R_342()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_37() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_95() {
        return this.jj_scan_token(62);
    }

    private final boolean jj_3R_169() {
        return this.jj_3R_219();
    }

    private final boolean jj_3R_305() {
        return this.jj_3R_326();
    }

    private final boolean jj_3R_138() {
        return this.jj_3R_208();
    }

    private final boolean jj_3_48() {
        return this.jj_3R_73();
    }

    private final boolean jj_3_24() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_94() {
        return this.jj_scan_token(122);
    }

    private final boolean jj_3R_215() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3R_137() {
        return this.jj_scan_token(290);
    }

    private final boolean jj_3R_136() {
        return this.jj_scan_token(251);
    }

    private final boolean jj_3R_168() {
        return this.jj_3R_203();
    }

    private final boolean jj_3R_159() {
        return this.jj_scan_token(379);
    }

    private final boolean jj_3R_357() {
        return this.jj_scan_token(176);
    }

    private final boolean jj_3R_135() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_356() {
        return this.jj_scan_token(150);
    }

    private final boolean jj_3_29() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_355() {
        return this.jj_scan_token(277);
    }

    private final boolean jj_3R_167() {
        return this.jj_3R_203();
    }

    private final boolean jj_3R_259() {
        return this.jj_3R_305();
    }

    private final boolean jj_3R_134() {
        return this.jj_3R_207();
    }

    private final boolean jj_3R_354() {
        return this.jj_scan_token(298);
    }

    private final boolean jj_3R_166() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_133() {
        return this.jj_3R_206();
    }

    private final boolean jj_3R_353() {
        return this.jj_scan_token(262);
    }

    private final boolean jj_3R_343() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_353()) {
            this.jj_scanpos = token;
            if (this.jj_3R_354()) {
                this.jj_scanpos = token;
                if (this.jj_3R_355()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_356()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_357()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_349() {
        return this.jj_scan_token(219);
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_93() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_106() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_87() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_165()) {
            this.jj_scanpos = token;
            if (this.jj_3R_166()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_167()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)2).kind == 420 || this.getToken((int)4).kind == 420 && this.getToken((int)2).kind != 424;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_168()) {
                        this.jj_scanpos = token;
                        if (this.jj_3_48()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_169()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_165() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_105() {
        return this.jj_scan_token(183);
    }

    private final boolean jj_3R_348() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_193() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_132() {
        return this.jj_scan_token(345);
    }

    private final boolean jj_3R_71() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = token;
            if (this.jj_3R_133()) {
                this.jj_scanpos = token;
                if (this.jj_3R_134()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_29()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_135()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_136()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_137()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_138()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_103() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(215)) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 101 && (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404);
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_193()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_101();
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_100();
    }

    private final boolean jj_3R_347() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_340() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_347()) {
            this.jj_scanpos = token;
            if (this.jj_3R_348()) {
                this.jj_scanpos = token;
                if (this.jj_3R_349()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_57() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 91;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_106()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 213;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_107()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_98();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_43();
    }

    private final boolean jj_3R_322() {
        return this.jj_3R_340();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_94();
    }

    private final boolean jj_3_51() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_44() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_321() {
        return this.jj_3R_339();
    }

    private final boolean jj_3R_301() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_321()) {
            this.jj_scanpos = token;
            if (this.jj_3R_322()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_244() {
        return this.jj_3R_303();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_209() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(183)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_259();
    }

    private final boolean jj_3_2() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = token;
            if (this.jj_3R_45()) {
                this.jj_scanpos = token;
                if (this.jj_3R_46()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_47()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_48()) {
                            this.jj_scanpos = token;
                            if (this.jj_3_1()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_49()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_50()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_51()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_52()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_28() {
        return this.jj_3R_73();
    }

    private final boolean jj_3_47() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_96() {
        return this.jj_scan_token(111);
    }

    private final boolean jj_3R_364() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(59)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(60)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(61)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(62)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(63)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(64)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(65)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(66)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(67)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(68)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(69)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(70)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(71)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(72)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(73)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(75)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(76)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(77)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(78)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(79)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(80)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(81)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(82)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(83)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(85)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(86)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(88)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(89)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(90)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(91)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(92)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(93)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(94)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(95)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(96)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(97)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(98)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(100)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(101)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(102)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(103)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(104)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(105)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(106)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(108)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(109)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(110)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(111)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(112)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(113)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(114)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(115)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(116)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(117)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(118)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(123)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(124)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(125)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(126)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(127)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(128)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(129)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(130)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(133)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(134)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(137)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(138)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(141)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(142)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(345)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(146)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(147)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(150)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(151)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(154)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(155)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(285)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(159)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(160)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(161)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(162)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(163)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(164)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(165)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(166)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(167)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(168)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(169)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(170)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(171)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(172)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(173)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(174)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(175)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(176)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(178)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(179)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(180)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(381)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(183)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(184)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(185)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(186)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(187)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(188)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(189)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(190)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(191)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(192)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(386)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(194)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(195)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(196)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(197)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(199)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(200)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(201)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(202)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(203)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(204)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(205)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(206)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(207)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(208)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(209)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(210)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(211)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(212)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(213)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(214)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(215)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(216)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(217)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(218)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(219)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(220)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(221)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(222)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(223)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(224)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(225)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(226)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(227)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(228)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(229)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(230)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(232)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(233)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(234)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(235)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(236)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(240)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(237)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(238)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(239)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(242)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(244)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(245)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(246)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(247)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(248)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(249)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(250)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(252)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(254)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(255)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(256)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(257)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(258)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(259)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(260)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(261)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(262)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(340)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(341)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(346)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(347)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(349)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(350)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(241)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(351)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(352)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(354)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(356)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(353)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(355)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_334() {
        return this.jj_scan_token(133);
    }

    private final boolean jj_3R_318() {
        return this.jj_3R_338();
    }

    private final boolean jj_3R_333() {
        return this.jj_scan_token(242);
    }

    private final boolean jj_3R_315() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_333()) {
            this.jj_scanpos = token;
            if (this.jj_3R_334()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_232() {
        return this.jj_3R_297();
    }

    private final boolean jj_3R_139() {
        return this.jj_3R_209();
    }

    private final boolean jj_3R_338() {
        return this.jj_3R_346();
    }

    private final boolean jj_3_23() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_329() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_104() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.javaClassFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_194()) {
            this.jj_scanpos = token;
            if (this.jj_3_23()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_194() {
        return this.jj_3R_232();
    }

    private final boolean jj_3R_72() {
        return this.jj_3R_139();
    }

    private final boolean jj_3R_158() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3R_281() {
        return this.jj_scan_token(412);
    }

    private final boolean jj_3R_203() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = (this.getToken((int)1).kind == 345 || this.getToken((int)1).kind == 263 || this.getToken((int)1).kind == 264 || this.getToken((int)1).kind == 406 || this.getToken((int)1).kind == 295 || this.getToken((int)1).kind == 87 || this.getToken((int)1).kind == 251 || this.getToken((int)1).kind == 282 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 172 || this.getToken((int)1).kind == 411 || this.getToken((int)1).kind == 373 || this.getToken((int)1).kind == 349 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 241 || this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332 || this.getToken((int)1).kind == 121 || this.getToken((int)1).kind == 82 || this.getToken((int)1).kind == 254 || this.getToken((int)1).kind == 161 || this.getToken((int)1).kind == 160 || this.getToken((int)1).kind == 221 || this.getToken((int)1).kind == 347 || this.getToken((int)1).kind == 262 || this.getToken((int)1).kind == 298 || this.getToken((int)1).kind == 277 || this.getToken((int)1).kind == 150 || this.getToken((int)1).kind == 176 || this.getToken((int)1).kind == 217 || this.getToken((int)1).kind == 290 || this.getToken((int)1).kind == 374 || this.getToken((int)1).kind == 354 || this.getToken((int)1).kind == 356 || this.getToken((int)1).kind == 353 || this.getToken((int)1).kind == 355) && this.getToken((int)2).kind == 420;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_243()) {
            this.jj_scanpos = token;
            if (this.jj_3_28()) {
                this.jj_scanpos = token;
                if (this.jj_3R_244()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_243() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_280() {
        return this.jj_scan_token(362);
    }

    private final boolean jj_3R_263() {
        return this.jj_3R_306();
    }

    private final boolean jj_3R_217() {
        return this.jj_3R_272();
    }

    private final boolean jj_3R_279() {
        return this.jj_scan_token(399);
    }

    private final boolean jj_3R_153() {
        return this.jj_3R_213();
    }

    private final boolean jj_3R_262() {
        return this.jj_scan_token(332);
    }

    private final boolean jj_3R_278() {
        return this.jj_scan_token(398);
    }

    private final boolean jj_3R_309() {
        return this.jj_3R_330();
    }

    private final boolean jj_3R_78() {
        Token token = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = token;
            if (this.jj_3R_153()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_22() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_175() {
        return this.jj_scan_token(206);
    }

    private final boolean jj_3_27() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_131() {
        return this.jj_3R_205();
    }

    private final boolean jj_3R_261() {
        return this.jj_scan_token(276);
    }

    private final boolean jj_3R_174() {
        return this.jj_scan_token(206);
    }

    private final boolean jj_3R_220() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_278()) {
            this.jj_scanpos = token;
            if (this.jj_3R_279()) {
                this.jj_scanpos = token;
                if (this.jj_3R_280()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_281()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_308() {
        return this.jj_3R_329();
    }

    private final boolean jj_3R_296() {
        return this.jj_scan_token(309);
    }

    private final boolean jj_3R_295() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3R_210() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_260()) {
            this.jj_scanpos = token;
            if (this.jj_3R_261()) {
                this.jj_scanpos = token;
                if (this.jj_3R_262()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_263()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_260() {
        return this.jj_scan_token(331);
    }

    private final boolean jj_3R_173() {
        return this.jj_scan_token(365);
    }

    private final boolean jj_3R_172() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_221() {
        return this.jj_scan_token(310);
    }

    private final boolean jj_3R_171() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_221()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(317)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_294() {
        return this.jj_scan_token(314);
    }

    private final boolean jj_3R_231() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_294()) {
            this.jj_scanpos = token;
            if (this.jj_3R_295()) {
                this.jj_scanpos = token;
                if (this.jj_3R_296()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_307() {
        return this.jj_scan_token(445);
    }

    private final boolean jj_3R_170() {
        return this.jj_3R_220();
    }

    private final boolean jj_3R_272() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_307()) {
            this.jj_scanpos = token;
            if (this.jj_3R_308()) {
                this.jj_scanpos = token;
                if (this.jj_3R_309()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_157() {
        return this.jj_3R_215();
    }

    private final boolean jj_3R_225() {
        return this.jj_scan_token(352);
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_213() {
        return this.jj_scan_token(184);
    }

    private final boolean jj_3R_130() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3R_88() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = token;
            if (this.jj_3R_171()) {
                this.jj_scanpos = token;
                if (this.jj_3R_172()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_173()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 272;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_174()) {
                            this.jj_scanpos = token;
                            this.lookingAhead = true;
                            this.jj_semLA = this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 337;
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_175()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_49() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_148() {
        return this.jj_3R_212();
    }

    private final boolean jj_3R_129() {
        return this.jj_3R_204();
    }

    private final boolean jj_3R_75() {
        Token token = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = token;
            if (this.jj_3R_148()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_34() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_128() {
        return this.jj_3R_203();
    }

    private final boolean jj_3_18() {
        return this.jj_3R_67();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_127() {
        return this.jj_3R_202();
    }

    private final boolean jj_3_36() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_300() {
        return this.jj_3R_303();
    }

    private final boolean jj_3R_236() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 426 && this.getToken((int)4).kind == 420;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_300()) {
            this.jj_scanpos = token;
            if (this.jj_3_9()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_126() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_223() {
        return this.jj_scan_token(348);
    }

    private final boolean jj_3R_119() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 426 && (this.getToken((int)3).kind == 422 || this.getToken((int)4).kind == 426 && this.getToken((int)5).kind == 422);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_197()) {
            this.jj_scanpos = token;
            if (this.jj_3_18()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_197() {
        return this.jj_3R_214();
    }

    private final boolean jj_3R_125() {
        return this.jj_3R_201();
    }

    private final boolean jj_3R_192() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_102() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(165)) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 165;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_192()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_156() {
        return this.jj_3R_214();
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(121);
    }

    private final boolean jj_3R_64() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 308;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_116()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(121)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_124() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_119();
    }

    private final boolean jj_3_15() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_123() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_200() {
        return this.jj_scan_token(426);
    }

    private final boolean jj_3R_152() {
        return this.jj_scan_token(397);
    }

    private final boolean jj_3R_122() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_70() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.escapedValueFunctionFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_122()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_123()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)2).kind == 165;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_124()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_125()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.newInvocationFollows(1);
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_126()) {
                            this.jj_scanpos = token;
                            this.lookingAhead = true;
                            this.jj_semLA = this.aggregateFollows();
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_127()) {
                                this.jj_scanpos = token;
                                this.lookingAhead = true;
                                this.jj_semLA = this.miscBuiltinFollows();
                                this.lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_128()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_129()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_130()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_131()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_100() {
        return this.jj_scan_token(211);
    }

    private final boolean jj_3_17() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_77() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 400;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_151()) {
            this.jj_scanpos = token;
            if (this.jj_3R_152()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_151() {
        return this.jj_scan_token(397);
    }

    private final boolean jj_3R_115() {
        return this.jj_scan_token(207);
    }

    private final boolean jj_3R_101() {
        return this.jj_scan_token(130);
    }

    private final boolean jj_3R_337() {
        return this.jj_3R_339();
    }

    private final boolean jj_3R_83() {
        return this.jj_3R_160();
    }

    private final boolean jj_3R_351() {
        return this.jj_scan_token(349);
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_81() {
        Token token = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = token;
            if (this.jj_3R_156()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 420 && (this.getToken((int)2).kind == 218 || this.getToken((int)2).kind == 252);
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_157()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_158()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_41() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.newInvocationFollows(1);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_82()) {
            this.jj_scanpos = token;
            if (this.jj_3R_83()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_350() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_341() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_350()) {
            this.jj_scanpos = token;
            if (this.jj_3R_351()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_121() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind == 420;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_199()) {
            this.jj_scanpos = token;
            if (this.jj_3R_200()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_199() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(444)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(426)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_336() {
        return this.jj_scan_token(341);
    }

    private final boolean jj_3R_317() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_336()) {
            this.jj_scanpos = token;
            if (this.jj_3R_337()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_114() {
        return this.jj_scan_token(136);
    }

    private final boolean jj_3R_63() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_114()) {
            this.jj_scanpos = token;
            if (this.jj_3R_115()) {
                this.jj_scanpos = token;
                if (this.jj_3_15()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_118() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_150() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_69() {
        return this.jj_3R_121();
    }

    private final boolean jj_3R_76() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 391;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_149()) {
            this.jj_scanpos = token;
            if (this.jj_3R_150()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_149() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_293() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_292() {
        return this.jj_3R_317();
    }

    private final boolean jj_3_21() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_268() {
        return this.jj_scan_token(347);
    }

    private final boolean jj_3R_117() {
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_65() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 120 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_117()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 60 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_118()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_230() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_292()) {
            this.jj_scanpos = token;
            if (this.jj_3R_293()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_267() {
        return this.jj_scan_token(221);
    }

    private final boolean jj_3_16() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_212() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_266()) {
            this.jj_scanpos = token;
            if (this.jj_3R_267()) {
                this.jj_scanpos = token;
                if (this.jj_3R_268()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_266() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(161)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(160)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_25() {
        return this.jj_scan_token(140);
    }

    private final boolean jj_3R_339() {
        return this.jj_scan_token(438);
    }

    private final boolean jj_3R_234() {
        return this.jj_3R_212();
    }

    private final boolean jj_3_26() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_365() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_320() {
        return this.jj_scan_token(425);
    }

    private final boolean jj_3R_319() {
        return this.jj_scan_token(423);
    }

    private final boolean jj_3R_299() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_319()) {
            this.jj_scanpos = token;
            if (this.jj_3R_320()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_8() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_362() {
        return this.jj_3R_366();
    }

    private final boolean jj_3_44() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_155() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_361() {
        return this.jj_3R_365();
    }

    private final boolean jj_3R_358() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_361()) {
            this.jj_scanpos = token;
            if (this.jj_3R_362()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_80() {
        Token token = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = token;
            if (this.jj_3R_155()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_40() {
        return this.jj_3R_81();
    }

    private final boolean jj_3_33() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_325() {
        return this.jj_scan_token(241);
    }

    private final boolean jj_3R_265() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3_52() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_324() {
        return this.jj_3R_341();
    }

    private final boolean jj_3R_304() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_324()) {
            this.jj_scanpos = token;
            if (this.jj_3R_325()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_211() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_264()) {
            this.jj_scanpos = token;
            if (this.jj_3R_265()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_264() {
        return this.jj_scan_token(82);
    }

    private final boolean jj_3R_345() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3_39() {
        return this.jj_3R_80();
    }

    private final boolean jj_3R_344() {
        return this.jj_3R_358();
    }

    private final boolean jj_3R_335() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_344()) {
            this.jj_scanpos = token;
            if (this.jj_3R_345()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_298() {
        return this.jj_scan_token(186);
    }

    private final boolean jj_3R_196() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_233()) {
            this.jj_scanpos = token;
            if (this.jj_3R_234()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_233() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_298()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(110)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(109)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_235() {
        return this.jj_3R_299();
    }

    private final boolean jj_3R_198() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_235()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_236();
    }

    private final boolean jj_3_14() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_254() {
        return this.jj_scan_token(374);
    }

    private final boolean jj_3R_113() {
        return this.jj_3R_196();
    }

    private final boolean jj_3R_62() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = token;
            if (this.jj_3_14()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_253() {
        return this.jj_3R_304();
    }

    private final boolean jj_3R_205() {
        return this.jj_scan_token(81);
    }

    private final boolean jj_3R_369() {
        return this.jj_3R_330();
    }

    private final boolean jj_3R_252() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(411)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(373)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_368() {
        return this.jj_3R_329();
    }

    private final boolean jj_3R_290() {
        return this.jj_scan_token(178);
    }

    private final boolean jj_3R_251() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(248)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(172)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_367() {
        return this.jj_scan_token(445);
    }

    private final boolean jj_3R_363() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_367()) {
            this.jj_scanpos = token;
            if (this.jj_3R_368()) {
                this.jj_scanpos = token;
                if (this.jj_3R_369()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_289() {
        return this.jj_3R_195();
    }

    private final boolean jj_3R_323() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(174)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(71)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(175)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(229)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_207() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_250()) {
            this.jj_scanpos = token;
            if (this.jj_3R_251()) {
                this.jj_scanpos = token;
                if (this.jj_3R_252()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_253()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_254()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_250() {
        return this.jj_scan_token(351);
    }

    private final boolean jj_3R_288() {
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_229() {
        return this.jj_scan_token(247);
    }

    private final boolean jj_3R_287() {
        return this.jj_scan_token(302);
    }

    private final boolean jj_3R_286() {
        return this.jj_scan_token(270);
    }

    private final boolean jj_3R_285() {
        return this.jj_scan_token(267);
    }

    private final boolean jj_3R_328() {
        return this.jj_scan_token(217);
    }

    private final boolean jj_3_31() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_327() {
        return this.jj_3R_343();
    }

    private final boolean jj_3R_306() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_327()) {
            this.jj_scanpos = token;
            if (this.jj_3R_328()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_302() {
        return this.jj_3R_323();
    }

    private final boolean jj_3R_224() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_285()) {
            this.jj_scanpos = token;
            if (this.jj_3R_286()) {
                this.jj_scanpos = token;
                if (this.jj_3R_287()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_288()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_289()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_290()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_360() {
        return this.jj_3R_364();
    }

    private final boolean jj_3R_359() {
        return this.jj_3R_363();
    }

    private final boolean jj_3R_346() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_359()) {
            this.jj_scanpos = token;
            if (this.jj_3R_360()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_120() {
        return this.jj_3R_198();
    }

    private final boolean jj_3R_164() {
        return this.jj_3R_217();
    }

    private final boolean jj_3_43() {
        return this.jj_3R_65();
    }

    private final boolean jj_3_32() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_86() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_164()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_163();
    }

    private final boolean jj_3R_84() {
        Token token = this.jj_scanpos;
        if (this.jj_3_43()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_68();
    }

    private final boolean jj_3R_313() {
        return this.jj_scan_token(456);
    }

    private final boolean jj_3R_316() {
        return this.jj_3R_335();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(381);
    }

    private final boolean jj_3_46() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_228() {
        return this.jj_scan_token(159);
    }

    private final boolean jj_3_42() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_242() {
        return this.jj_3R_302();
    }

    private final boolean jj_3R_99() {
        return this.jj_scan_token(147);
    }

    private final boolean jj_3R_111() {
        return this.jj_scan_token(180);
    }

    private final boolean jj_3R_352() {
        return this.jj_scan_token(131);
    }

    private final boolean jj_3R_204() {
        return this.jj_3R_217();
    }

    private final boolean jj_3R_312() {
        return this.jj_scan_token(455);
    }

    private final boolean jj_3R_110() {
        return this.jj_scan_token(178);
    }

    private final boolean jj_3R_202() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = token;
            if (this.jj_3R_242()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_241() {
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_98() {
        return this.jj_scan_token(335);
    }

    private final boolean jj_3R_61() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_110()) {
            this.jj_scanpos = token;
            if (this.jj_3R_111()) {
                this.jj_scanpos = token;
                if (this.jj_3R_112()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_145() {
        return this.jj_scan_token(104);
    }

    private final boolean jj_3R_291() {
        return this.jj_3R_316();
    }

    private final boolean jj_3R_227() {
        return this.jj_3R_291();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0, 0, 0x10000000, 0x10000000, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -134217728, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0x200000, 0, 0x200000, 0, 0, 0, 0x200000, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x200000, 0, 0, 0x48000000, 0, 0, 0, 0x48000000, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, -134217728, 0, -134217728, -134217728, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0x800400, 0, 0, 4, 0, 0, 0, 0x800400, 0, 0, 0, 0, 0x800400, 0, 0, 0, 0, 0, 0, 0, 0x40A00400, 0x40200000, 0x40200000, 0x40200000, 0, 0x40200000, 0x40200000, 787456, 0, 0, 786432, 0, 786432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 787456, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800404, 4, 0, 0, 0, 0, 0, 0, 512, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1048577, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 65536, 8520704, 0x800400, 0, 0x800000, 0, 0, 262144, 0, 0, 4, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0x800404, 0, 0, 4, 0, 0, 4, 0, 0, 0x800400, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 262144, 0, 0, 64, 0x800440, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800400, 65536, 0, 0, 0x40000000, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0x40000000, 0, 0, 0x200000, 0, 0, 0x44A00400, 0x4000000, 0x4800400, 0, 0x4000000, 16384, 16384, 0x4000000, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800400, 0, 0x800400, -9438209, 0x800400, -1048577, -1048577, 0x800400};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{524288, 0, 67665936, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 32, 0, 2056, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 524288, 0, 2056, 65536, 0, 0, 65536, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 24576, 0, 0, 24576, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0x1000000, Integer.MIN_VALUE, 0, 0x1000000, 0x1000000, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 2056, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 0, 0, 0x100000, 0x100000, 0, 0, 0, 0, 65536, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0x100000, 0x100000, 0, 0, 0, 0, 0, 64, 128, 256, 0, 8, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 2056, 512, 0x18000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 65536, 0, 0, 0, 0, 0, 0, 0x4000000, 2056, 0, 2056, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 524288, 0, 2056, 524288, 2056, -2057, 2056, -1, -1, 2056};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 524292, 0, 0, 16384, 16384, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 4096, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0x2000000, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0x400000, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 32, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 16, 0, 0, 0x2000000, 0x2000000, 16, 0, 0, 0, 512, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, -2147483644, 0, 0, Integer.MIN_VALUE, 16384, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, -2147483644, 0, -1, 0, -1, -1, 0};
    }

    private static void jj_la1_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0x10000000, 0, 131072, 0, 0, 0x10000000, 0, 0x800000, 0, 0, 131072, 0x800000, 0x800000, 0x800000, 0, 0x800000, 0x800000, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x140000, 0, 0, 0, 0, 262144, 0x4000003, 0x4000000, 0, 0, 0x4000003, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0x800000, 16, 0, 0x800000, 0x800800, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, -1, 65536, 0, 0, 0, 0, 0, 0, 65536, 0, 4096, 0, 0, 4096, 0, 0, 512, 0, 0, 0x2000000, 131072, 131072, 4096, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 3, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0x1000000, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 1024, 0, 1024, 1024, 0, 0, 0, 0, 0, 49152, 49152, 0, 0x1000000, 0, 0, 131072, 0, 0, 0x400000, 0, 0, 0, 0, 0x400000, 0, 0x400000, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0x400000, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0x2000000, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0x10000000, 0x10000000, 0, 0x400000, 0x1000000, 0x400000, 0, 0, 0, 0x800000, 0, 0, 131072, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 131072, -131073, 131072, -1, -1, 131072};
    }

    private static void jj_la1_6() {
        jj_la1_6 = new int[]{0x4000000, 0, 0x4200000, 524288, 0, 0x800000, 0x801000, 0x801000, 0, 0x4200000, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 256, 0, 512, 66048, 66048, 66048, 0, 66048, 66048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0x20000000, 0, 0x20000000, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0x8000000, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0x8000000, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 256, 0, 0, 0, 0, 0, 0x20000000, 0x2000000, 0, 0, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 4, 0x100000, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0x800000, 0x800000, 0, 0x8000000, 0, 1, 0, 0, 512, 512, 0, 0, 0, 0, 0, 262144, 0, 0x10040000, 0, 0, 0, 66048, 0, 0, 512, 0, 0, 0, 0, 262144, 262144, 0, 0, 0, 4096, 0x4010000, 0, 0, 0x4010000, 4096, 0, 0, 0, 0, 0, 0x4010000, 0, 8192, 0x4010000, 0, -1, 0, -1, -1, 0};
    }

    private static void jj_la1_7() {
        jj_la1_7 = new int[]{0x10800000, 0, 0x10800000, 0, 0, 0, 0x200100, 256, 0, 0x10800000, 0, 0, 0, 0, 0, 0, 0, 0, 0x28080080, 256, 0, 0, 0, 0, 0, 0x28080080, 0, 0, 0x200000, 0, 0x28080080, 4096, 0, 0x200000, 0, 0, 0, 0, 0x28280080, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0, 0, Integer.MIN_VALUE, 0x40000000, 0, 0, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0x10000000, 0x10000000, 0, 0, 0x28080080, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0x2000010, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0x1020000, 131072, 0, 65536, 0, 0, 0x2040000, 0x28080080, 0x28080080, 0x1020000, 0x8000000, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0x2000000, 0x2000000, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x28080080, 0, 256, 0, 0, 0, 0, 0, 0, 0x28080080, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0x40000000, 0, 0, 0, 0x28080080, 0, 0, 0, 0, 256, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 262144, 0, 262144, 0, 524416, 256, 0, 4096, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 705167488, 0x2040000, 0, 0, 0, 0, 0x200000, 0x200000, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0x28280080, 0, 0x28080080, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 256, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0x28080080, 0x800000, 0x28080080, -671613057, 0x28080080, -1, -1, 0x28080080};
    }

    private static void jj_la1_8() {
        jj_la1_8 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 4, 0, 0, 4, 0, 0, 0, 8, 1606418304, 0, 4, 0, 0, 0, 4, 1606418304, 0, 0, 0, 16, 1606418304, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0x2000008, 0, 0, 0x2000008, 0, 0x2000008, 1067008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x7FBFFFFF, 0x200040, 0, 131072, 0, 0, 67109248, 0, 0x200040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 1606418304, 67109248, 0, 0, 0x300040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x300040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 8658944, 0x800000, 8658944, 8192, 0, 0x20000000, 0x20000000, 8658944, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0x2000008, 1024, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 1606418304, 536871039, 1606418304, 0x7FBFFFFF, 0x7FBFFFFF, 1606418304};
    }

    private static void jj_la1_9() {
        jj_la1_9 = new int[]{0, 0, 0x4200000, 0, 0, 0, 0, 0, 0, 0x4200000, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, -268435457, 0, 0x4200000, 0, 16, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 1024, 0, 0, 0, -1073741824, 128, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, -268435457, 128, 4, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0x2000000, 0, 0, 0x1000101, 0, 0x1000101, 0x1000000, 0, 0, 0, 0x1000101, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20400000, 0x20400000, 0, 0x20400000, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, -268435457, 0, -268435457, 32, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, -268435457, 0, -268435457, -268435457, -268435457, -268435457};
    }

    private static void jj_la1_10() {
        jj_la1_10 = new int[]{0x200000, 0, 0x200000, 32768, 0, 512, 512, 512, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0x200000, 0x200000, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0x10101800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0x8000000, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0xC06000, 24576, 127, 0, 0, 0, 0, 0, 0, 0, -536870912, 0x60000000, 0, 0, 0x60000000, 0, 0, 0x11CFFFFF, 0x11CFFFFF, -503316480, 0, 0, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0x11CFFFFF, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0x11CFFFFF, -298844160, 0x11CFFFFF, -1, -1, 0x11CFFFFF};
    }

    private static void jj_la1_11() {
        jj_la1_11 = new int[]{0, 0x800000, 0, 0, 0x800000, 0, 524288, 524288, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 524288, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, -536872992, 0, 0, 0, 2048, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2049, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0x600000, 0, 0, 0, 0, 0, 0, -536872992, -536872992, 0x600000, 30, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 32, 0, 0, 0, 0x18000000, 0x18000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 131072, 0, 0, 0, 0, 0, 9216, 1024, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, -536872992, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, -536872992, 536870943, -536872992, -2049, -2049, -536872992};
    }

    private static void jj_la1_12() {
        jj_la1_12 = new int[]{0, 512, 0, 0, 512, 0x4000000, 0x4000000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFF, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0x8000000, 0, 0x8000000, 0, 0, 0, 0, 0x100000, 0, 0x3FFFFFFB, 0x3FFFFFFB, 0x8400000, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 2099272, 0, 2099272, 0, 0, 4, 4, 2099272, 0, 0, 256, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 1024, 0, 0x1000C000, 0x1000C000, 0, 0, 0, 0x100000, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0x3FFFFFFB, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0x3FFFFFFB, 0x4000000, 0x3FFFFFFB, 4, 0x3FFFFFFB, 0x3FFFFFFF, 0x3FFFFFFF, 0x3FFFFFFB};
    }

    private static void jj_la1_13() {
        jj_la1_13 = new int[]{0x400014, 0, 0x400014, 0, 0, 0, 0, 0, 0, 0x400014, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0x20000000, 0x400004, 0x400000, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 256, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 16, 0, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0, 256, 16, 0, 0, 0, 16, 0, 0, 0, 0, 1024, 0x20000000, 0, 640, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 64, 256, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 4161536, 4, 4, 0, 4161536, 640, 640, 0x8000840, 0x8000840, 640, 0x10000400, 1024, 0, 0x20000000, 0, 256, 0, 0, 0, 0, 256, 0, 256, 0, 0, 256, 0, 0, 32, 0, 0, 0, 4194948, 0x20000010, 0x20000000, 0, 0, 256, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 288, 0, 0x400000, 0, 256, 256, 0, 0, 0, 0, 256, 256, 0, 0, 256, 0, 256, 256, 0, 0, 0, 0, 0, 0, 256, 4, 0, 16, 0, 0x20000000, 0, 0, 0, 16, 0, 0, 16, 0, 0x20000000, 16, 256, 256, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 64, 0, 0, 0, 0, 256, 0, 0x20000000, 0, 16, 0, 16, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 256, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 256, 0, 0, 0, 644, 640, 644, 0, 0, 0, 0, 131072, 131072, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0x20400000, 4194948, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 16, 256, 16, 16, 16, 0, 256, 0x20000000, 0, 0x20000000, 0, 0, 0x20000000, 0x20000000, 0x20000000};
    }

    private static void jj_la1_14() {
        jj_la1_14 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 912, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 912, 0, 912, 528, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 136, 912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 0, 8, 8, 8};
    }

    public SQLParser(CharStream charStream) {
        int n;
        this.token_source = new SQLParserTokenManager(charStream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 315; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(CharStream charStream) {
        int n;
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 315; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public SQLParser(SQLParserTokenManager sQLParserTokenManager) {
        int n;
        this.token_source = sQLParserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 315; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(SQLParserTokenManager sQLParserTokenManager) {
        int n;
        this.token_source = sQLParserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 315; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[470];
        for (n2 = 0; n2 < 470; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 315; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) != 0) {
                    blArray[64 + n] = true;
                }
                if ((jj_la1_3[n2] & 1 << n) != 0) {
                    blArray[96 + n] = true;
                }
                if ((jj_la1_4[n2] & 1 << n) != 0) {
                    blArray[128 + n] = true;
                }
                if ((jj_la1_5[n2] & 1 << n) != 0) {
                    blArray[160 + n] = true;
                }
                if ((jj_la1_6[n2] & 1 << n) != 0) {
                    blArray[192 + n] = true;
                }
                if ((jj_la1_7[n2] & 1 << n) != 0) {
                    blArray[224 + n] = true;
                }
                if ((jj_la1_8[n2] & 1 << n) != 0) {
                    blArray[256 + n] = true;
                }
                if ((jj_la1_9[n2] & 1 << n) != 0) {
                    blArray[288 + n] = true;
                }
                if ((jj_la1_10[n2] & 1 << n) != 0) {
                    blArray[320 + n] = true;
                }
                if ((jj_la1_11[n2] & 1 << n) != 0) {
                    blArray[352 + n] = true;
                }
                if ((jj_la1_12[n2] & 1 << n) != 0) {
                    blArray[384 + n] = true;
                }
                if ((jj_la1_13[n2] & 1 << n) != 0) {
                    blArray[416 + n] = true;
                }
                if ((jj_la1_14[n2] & 1 << n) == 0) continue;
                blArray[448 + n] = true;
            }
        }
        for (n2 = 0; n2 < 470; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, SQLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 52; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        SQLParser.jj_la1_0();
        SQLParser.jj_la1_1();
        SQLParser.jj_la1_2();
        SQLParser.jj_la1_3();
        SQLParser.jj_la1_4();
        SQLParser.jj_la1_5();
        SQLParser.jj_la1_6();
        SQLParser.jj_la1_7();
        SQLParser.jj_la1_8();
        SQLParser.jj_la1_9();
        SQLParser.jj_la1_10();
        SQLParser.jj_la1_11();
        SQLParser.jj_la1_12();
        SQLParser.jj_la1_13();
        SQLParser.jj_la1_14();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

