/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnectionRequest;

public class NetPackageRequest
extends NetConnectionRequest {
    static final String COLLECTIONNAME = "NULLID";
    static final String collectionName = "NULLID";

    NetPackageRequest(NetAgent netAgent, CcsidManager ccsidManager, int n) {
        super(netAgent, ccsidManager, n);
    }

    void buildCommonPKGNAMinfo(Section section) throws SqlException {
        String string = "NULLID";
        int n = 255;
        boolean bl = false;
        bl = this.checkPKGNAMlengths(this.netAgent_.netConnection_.databaseName_, n, 18);
        if (!bl) {
            bl = this.checkPKGNAMlengths(string, n, 18);
        }
        if (!bl) {
            bl = this.checkPKGNAMlengths(section.getPackageName(), n, 18);
        }
        if (!bl) {
            this.writeScalarPaddedString(this.netAgent_.netConnection_.databaseName_, 18);
            this.writeScalarPaddedString(string, 18);
            this.writeScalarPaddedString(section.getPackageName(), 18);
        } else {
            this.buildSCLDTA(this.netAgent_.netConnection_.databaseName_, 18);
            this.buildSCLDTA(string, 18);
            this.buildSCLDTA(section.getPackageName(), 18);
        }
    }

    private void buildSCLDTA(String string, int n) throws SqlException {
        if (string.length() <= n) {
            this.write2Bytes(n);
            this.writeScalarPaddedString(string, n);
        } else {
            this.write2Bytes(string.length());
            this.writeScalarPaddedString(string, string.length());
        }
    }

    void buildPKGNAMCSN(Section section) throws SqlException {
        if (!this.canCommandUseDefaultPKGNAMCSN()) {
            this.markLengthBytes(8467);
            if (section.getPKGNAMCBytes() != null) {
                this.writeStoredPKGNAMCBytes(section);
            } else {
                this.markForCachingPKGNAMCSN();
                this.buildCommonPKGNAMinfo(section);
                this.writeScalarPaddedBytes(Configuration.dncPackageConsistencyToken, 8, (byte)0);
                this.storePKGNAMCBytes(section);
            }
            this.write2Bytes(section.getSectionNumber());
            this.updateLengthBytes();
        } else {
            this.writeScalar2Bytes(8460, section.getSectionNumber());
        }
    }

    private void storePKGNAMCBytes(Section section) {
        int n = this.popMarkForCachingPKGNAMCSN();
        int n2 = this.offset_ - n;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.bytes_, n, byArray, 0, n2);
        section.setPKGNAMCBytes(byArray);
    }

    private void writeStoredPKGNAMCBytes(Section section) {
        byte[] byArray = section.getPKGNAMCBytes();
        this.ensureLength(this.offset_ + byArray.length);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, byArray.length);
        this.offset_ += byArray.length;
    }

    private boolean canCommandUseDefaultPKGNAMCSN() {
        return false;
    }

    private boolean checkPKGNAMlengths(String string, int n, int n2) throws SqlException {
        int n3 = string.length();
        if (n3 > n) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("42622"), (Object)string, new Integer(n));
        }
        return n3 > n2;
    }

    private byte[] getBytes(String string, String string2) throws SqlException {
        try {
            return string.getBytes(string2);
        }
        catch (Exception exception) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XJ001.U"), (Object)exception.getClass().getName(), (Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void buildNOCMorNOCS(String string) throws SqlException {
        if (string == null) {
            this.write2Bytes(65535);
        } else {
            byte[] byArray = null;
            if (this.netAgent_.typdef_.isCcsidMbcSet()) {
                byArray = this.getBytes(string, this.netAgent_.typdef_.getCcsidMbcEncoding());
                this.write1Byte(0);
                this.write4Bytes(byArray.length);
                this.writeBytes(byArray, byArray.length);
                this.write1Byte(255);
            } else {
                byArray = this.getBytes(string, this.netAgent_.typdef_.getCcsidSbcEncoding());
                this.write1Byte(255);
                this.write1Byte(0);
                this.write4Bytes(byArray.length);
                this.writeBytes(byArray, byArray.length);
            }
        }
    }

    private void buildSQLSTTGRP(String string) throws SqlException {
        this.buildNOCMorNOCS(string);
    }

    private void buildSQLSTT(String string) throws SqlException {
        this.buildSQLSTTGRP(string);
    }

    protected void buildSQLSTTcommandData(String string) throws SqlException {
        this.createEncryptedCommandData();
        int n = this.offset_;
        this.markLengthBytes(9236);
        this.buildSQLSTT(string);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(n);
        }
    }

    protected void buildSQLATTRcommandData(String string) throws SqlException {
        this.createEncryptedCommandData();
        int n = this.offset_;
        this.markLengthBytes(9296);
        this.buildSQLSTT(string);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(n);
        }
    }

    public void encryptDataStream(int n) throws SqlException {
        int n2;
        byte[] byArray = new byte[this.offset_ - n];
        for (n2 = n; n2 < this.offset_; ++n2) {
            byArray[n2 - n] = this.bytes_[n2];
        }
        byte[] byArray2 = this.netAgent_.netConnection_.getEncryptionManager().encryptData(byArray, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
        n2 = byArray2.length;
        if (this.bytes_.length >= n + n2) {
            System.arraycopy(byArray2, 0, this.bytes_, n, n2);
        } else {
            byte[] byArray3 = new byte[n + n2];
            System.arraycopy(this.bytes_, 0, byArray3, 0, n);
            System.arraycopy(byArray2, 0, byArray3, n, n2);
            this.bytes_ = byArray3;
        }
        this.offset_ += n2 - byArray.length;
        this.bytes_[n - 6] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes_[n - 5] = (byte)(n2 & 0xFF);
    }
}

