/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _UTF8
#define _UTF8

// sc
#include "types.h"

// apr
struct apr_pool_t;


/**
 * \brief helper class for handling utf-8 strings.
 */

class utf8
{
public:
  class Buffer
  {
  public:
    Buffer();
    Buffer( const char* buf, sc::Size size );
    Buffer( const Buffer& src );

    const char* _buffer;
    sc::Size    _size;
  };

  static char* next8( const char* str );
  static char* next8( const char* str, sc::Size chars );
  static char* prev8( const char* str, const char* start );
  static char* prev8( const char* str, const char* start, sc::Size chars );
  static sc::Size strlen8( const char* str, sc::Size size );

  static Buffer to8( const char* src, sc::Size srcSize, const char* srcCP, apr_pool_t* pool );
  static Buffer to16( const char* src, sc::Size srcSize, apr_pool_t* pool );

private:
  utf8();

  static int getXlateHandle( void** handle, const char* frompage, const char* topage, const char* key );
  static apr_pool_t* _pool;
};

#endif // _UTF8
