/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_BLAMELINE_H
#define _SVN_BLAMELINE_H

// sc
#include "svn.h"
#include "util/String.h"


namespace svn
{

/**
 * This class represents a subversion blame line.
 */
class BlameLine
{
public:
  BlameLine( Linenumber lineNo, Revnumber rev, const sc::String& author, Date date,
    const sc::String& line );

  Linenumber getLineNo() const;
  Revnumber getRevnumber() const;
  Date getDate() const;
  const sc::String& getAuthor() const;
  const sc::String& getLine() const;

private:
  Linenumber   _lineNo;
  Revnumber    _rev;
  sc::String   _author;
  Date         _date;
  sc::String   _line;
};

} // namespace

#endif // _SVN_BLAMELINE_H
