/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "FontSettingsInfo.h"
#include "FontSettingsWidget.h"
#include "FontSettings.h"


FontSettingsInfo::FontSettingsInfo( const QString& title, const QString& id, FontSettings* fs, int sortIndex )
: _title(title), _id(id), _sortIndex(sortIndex), _fs(fs)
{
  _modGeneral = _fs->getGeneralFont();
  _modEditor  = _fs->getEditorFont();
}

FontSettingsInfo::~FontSettingsInfo()
{
}

const QString& FontSettingsInfo::getTitle()
{
  return _title;
}

const QString& FontSettingsInfo::getSettingsId()
{
  return _id;
}

void FontSettingsInfo::initWidgetData( SettingsWidget* sw )
{
  FontSettingsWidget* psw = dynamic_cast<FontSettingsWidget*>(sw);
  psw->setGeneralFont(_modGeneral);
  psw->setEditorFont(_modEditor);
}

void FontSettingsInfo::storeWidgetData( SettingsWidget* sw )
{
  FontSettingsWidget* psw = dynamic_cast<FontSettingsWidget*>(sw);
  _modGeneral = psw->getGeneralFont();
  _modEditor  = psw->getEditorFont();
}

bool FontSettingsInfo::isModified()
{
  if( _modGeneral != _fs->getGeneralFont() || _modEditor != _fs->getEditorFont() )
  {
    return true;
  }

  return false;
}

void FontSettingsInfo::ok()
{
  apply();
}

void FontSettingsInfo::apply()
{
  _fs->setGeneralFont(_modGeneral);
  _fs->setEditorFont(_modEditor);
}

void FontSettingsInfo::cancel()
{
  // nop
}

int FontSettingsInfo::getSortIndex()
{
  return _sortIndex;
}
