/* ====================================================================
 * Copyright (c) 2008  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "TestConfig.h"


void TestConfig::get( ConfigValues& values )
{
  for( ConfigValues::iterator it = values.begin(); it != values.end(); it++ )
  {
    sc::String key = (*it).getKey();

    KeyValues::iterator itv = _cfg.find(key);
    if( itv != _cfg.end() )
    {
      (*it).setStringValue( (*itv).second );
    }
  }
}

void TestConfig::set( const ConfigValues& values )
{
  for( ConfigValues::const_iterator it = values.begin(); it != values.end(); it++ )
  {
    sc::String key = (*it).getKey();

    KeyValues::iterator itv = _cfg.find(key);
    if( itv != _cfg.end() )
    {
      (*itv).second = (*it).getStringValue();
    }
    else
    {
      _cfg.insert( KeyValues::value_type((*it).getKey(),(*it).getStringValue()) );
    }
  }
}
