/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "PathSimplifierTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "sublib/PathSimplifier.h"
#include "util-test/AssertionTraitString.h"



void PathSimplifierTest::setUp()
{
}

void PathSimplifierTest::tearDown()
{
}

void PathSimplifierTest::simplifyEmptyPaths()
{
  PathSimplifier s( sc::NullString, sc::NullString );

  CPPUNIT_ASSERT_EQUAL( sc::NullString, s.getPrefix() );
  CPPUNIT_ASSERT_EQUAL( sc::NullString, s.getPath1() );
  CPPUNIT_ASSERT_EQUAL( sc::NullString, s.getPath2() );
}

void PathSimplifierTest::simplifyEqualPaths()
{
  PathSimplifier s(
    sc::String("/A/B/C/d"),
    sc::String("/A/B/C/d") );

  CPPUNIT_ASSERT_EQUAL( sc::String("/A/B/C"), s.getPrefix() );
  CPPUNIT_ASSERT_EQUAL( sc::String("d"), s.getPath1() );
  CPPUNIT_ASSERT_EQUAL( sc::String("d"), s.getPath2() );
}

void PathSimplifierTest::simplifyDifferentPaths()
{
  PathSimplifier s(
    sc::String("/A/B/C/D/e"),
    sc::String("/A/B/C/d") );

  CPPUNIT_ASSERT_EQUAL( sc::String("/A/B/C"), s.getPrefix() );
  CPPUNIT_ASSERT_EQUAL( sc::String("D/e"), s.getPath1() );
  CPPUNIT_ASSERT_EQUAL( sc::String("d"),   s.getPath2() );
}
