/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ToolsSettingsInfo.h"
#include "ToolsSettingsWidget.h"
#include "ToolsSettings.h"


ToolsSettingsInfo::ToolsSettingsInfo( const QString& title, const QString& id,
  ToolsSettings* ts, int sortIndex )
: _title(title), _id(id), _sortIndex(sortIndex), _ts(ts)
{
  _diffCmd  = _ts->getDiffCmd();
  _mergeCmd = _ts->getMergeCmd();
}

ToolsSettingsInfo::~ToolsSettingsInfo()
{
}

const QString& ToolsSettingsInfo::getTitle()
{
  return _title;
}

const QString& ToolsSettingsInfo::getSettingsId()
{
  return _id;
}

void ToolsSettingsInfo::initWidgetData( SettingsWidget* sw )
{
  ToolsSettingsWidget* tsw = dynamic_cast<ToolsSettingsWidget*>(sw);
  tsw->setBuiltinDiffCmd(QString::fromUtf8(_ts->getBuiltinDiffCmd()));
  tsw->setBuiltinMergeCmd(QString::fromUtf8(_ts->getBuiltinMergeCmd()));
  tsw->setDiffCmd(QString::fromUtf8(_diffCmd));
  tsw->setMergeCmd(QString::fromUtf8(_mergeCmd));
  tsw->setInitialized();
}

void ToolsSettingsInfo::storeWidgetData( SettingsWidget* sw )
{
  ToolsSettingsWidget* tsw = dynamic_cast<ToolsSettingsWidget*>(sw);
  _diffCmd  = tsw->getDiffCmd();
  _mergeCmd = tsw->getMergeCmd();
}

bool ToolsSettingsInfo::isModified()
{
  if( !(_diffCmd == _ts->getDiffCmd()) || !(_mergeCmd == _ts->getMergeCmd()) )
  {
    return true;
  }

  return false;
}

void ToolsSettingsInfo::ok()
{
  apply();
}

void ToolsSettingsInfo::apply()
{
  _ts->setDiffCmd(_diffCmd);
  _ts->setMergeCmd(_mergeCmd);
}

void ToolsSettingsInfo::cancel()
{
  // nop
}

int ToolsSettingsInfo::getSortIndex()
{
  return _sortIndex;
}
