/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UPDATECMD_H
#define _SC_UPDATECMD_H

// sc
#include "ScCmd.h"
#include "svn/svn.h"
class CmdResultCallback;
class UpdateParam;


/**
 * Command for updating a working copy.
 */
class UpdateCmd : public ScCmd
{
public:
  /**
   * Construct an UpdateCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  UpdateCmd( UpdateParam* param, CmdResultCallback* cb );
  ~UpdateCmd();

  void run();

private:
  // in
  UpdateParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_UPDATECMD_H
