/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTSTATUSFILTERDIALOG_H
#define _TEXTSTATUSFILTERDIALOG_H

// sc
#include "TextStatusFilter.h"

// qt
#include <QtGui/QDialog>
class QCheckBox;
class QGroupBox;


class TextStatusFilterDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  TextStatusFilterDialog( QWidget* parent, const TextStatusFilter&
    filter );

  const TextStatusFilter& getTextStatusFilter() const;

public slots:
  void checkBoxStateChanged( int state );
  void reset();

private:
  QCheckBox* createCheckBox( StatusId id );

  void setDefaultFilter();
  void clearCheckBoxes();
  void setCheckBoxes();

  QGroupBox*       _groupbox;
  TextStatusFilter _filter;
};

#endif // _TEXTSTATUSFILTERDIALOG_H
