/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PROJECTREADER_TEST_H
#define _PROJECTREADER_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
class Config;
class ConfigData;


class ProjectReaderTest : public CppUnit::TestCase 
{
  CPPUNIT_TEST_SUITE( ProjectReaderTest );
  CPPUNIT_TEST( testSimpleProjectRoot );
  CPPUNIT_TEST( testMultipleProjectRoot );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testSimpleProjectRoot();
  void testMultipleProjectRoot();

private:
  Config*     _cfg;
  ConfigData* _data;
};

#endif // _PROJECTREADER_TEST_H
