/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [integer.h]                   Type: Integer                              */
/*                                                                          */
/* Copyright (c) 1994 by Lars D\olle, Heike Manns                           */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef integer_INCL
#define integer_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/* ---------------------------- The Type --------------------------------- */

/*  
   [integer] implements the algebraic operations for long integers with a
   maximum number of MAX_LONG digits.
   An integer number is represented by its sign, length and digits:
   N.value = N.Sgn * Sum { N.Dig[i] * (IntBase^i) | i in [0 .. N.Len - 1] }
*/

AbstractType(Integer) // Abstract integer type
;

/* ---------------------------- Basics ----------------------------------- */

/*  
   In the following functions the integer operands won't be consumed and
   the resulting integers have to be released.
*/

Integer Int_cons(int Sgn, int Len, c_byte Dig[])
/* constructs an integer from sign 'Sgn', length 'Len' and digits 'Dig' */
;

void Int_des(Integer x, int *Sgn, int *Len, c_byte **Dig)
/* destructs an integer into sign 'Sgn', length 'Len' and digits 'Dig' */
;

Integer Int_copy(Integer a); /* copies integer 'a'                          */
void    Int_free(Integer a); /* frees integer 'a'                           */
void    Int_show(Integer a); /* prints integer 'a' to stdout; for debugging */

/* --------------------------- Conversion --------------------------------- */

c_string Int_itoa(Integer a, int Base)
/* converts integer 'a' into a string; allocs memory */
;

c_bool Int_s_ok(c_string s, int Base)
/* whether string 's' represents an integer; not consuming 's' */
;

Integer Int_atoi(c_string sn, int Base)
/* converts string 'sn' into a number; not consuming 'sn' */
;

Integer Int_Cto(long a);               /* converts long 'a' into an integer */

c_bool Int_okC(Integer n)
/* whether integer 'n' can be converted into a long */
;

long    Int_toC(Integer n);            /* converts integer 'n' into a long  */

/* --------------------------- Comparison --------------------------------- */

c_bool Int_is0(Integer x);             /* x == 0 ?                          */
int    Int_cmp(Integer a, Integer b);  /* a < b ? -1 : a == b ? 0 : +1      */
c_bool Int_eq(Integer a, Integer b);   /* a == b ?                          */
c_bool Int_ne(Integer a, Integer b);   /* a != b ?                          */
c_bool Int_lt(Integer a, Integer b);   /* a < b ?                           */
c_bool Int_le(Integer a, Integer b);   /* a <= b ?                          */
c_bool Int_gt(Integer a, Integer b);   /* a > b ?                           */
c_bool Int_ge(Integer a, Integer b);   /* a >= b ?                          */

/* ---------------------------- Arithmetic -------------------------------- */

int     Int_sgn(Integer a);            /* signum of integer 'a'             */
Integer Int_abs(Integer a);            /* absolute value |a|                */
Integer Int_neg(Integer a);            /* negation -a                       */
Integer Int_add(Integer a, Integer b); /* addition a + b                    */
Integer Int_sub(Integer a, Integer b); /* substraction a - b                */
Integer Int_mlt(Integer a, Integer b); /* multiplication a * b              */
Integer Int_quo(Integer a, Integer b); /* division a / b                    */
Integer Int_rem(Integer a, Integer b); /* remainder a % b                   */

void Int_quo_rem(Integer a, Integer b, Integer *quo, Integer *rem)
/* *quo = a/b; *rem = a%b */
;

Integer Int_gcd(Integer a, Integer b)
/* greatest common divisor of integer 'a' and 'b' */
;

Integer Int_exp(Integer b, long n);    /* exponent b ^ n                    */


#ifdef __cplusplus
}
#endif

#endif
